/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.guiComponent.validation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import oracle.ewt.button.ButtonBar;
import oracle.ewt.button.PushButton;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.SingleRowSelection;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.table.TableEvent;
import oracle.ewt.table.TableRowSelectListener;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.emSDK.client.guiComponent.validation.ValidationDialogCallback;
import oracle.sysman.emSDK.client.guiComponent.validation.ValidationHandler;
import oracle.sysman.emSDK.client.guiComponent.validation.ValidationObject;
import oracle.sysman.emSDK.client.guiComponent.validation.ValidationProblem;
import oracle.sysman.emSDK.common.nls.MessageBundle;
import oracle.sysman.vtx.VtxGBPanel;

public class ValidationDialog
extends BufferedDialog
implements WindowListener,
ActionListener,
ComponentListener,
TableRowSelectListener {
    private static MessageBundle m_msgFile = MessageBundle.getMessageBundle("Vta");
    public static final int IGNORE = 0;
    public static final int CLOSE = 1;
    private ValidationObject m_validationObject;
    private SingleRowSelection m_tableSelection;
    private SpreadTable m_errorList;
    private PushButton m_closeButton;
    private PushButton m_gotoButton;
    private boolean m_allowIgnore;
    private ArrayTwoDDataSource m_ds;
    private ValidationDialogCallback m_callbackHandler;
    private boolean resized = false;

    public ValidationDialog(BufferedFrame frame, ValidationObject validationObject, boolean ignoreOption) {
        this(frame, null, validationObject, ignoreOption);
    }

    public ValidationDialog(BufferedFrame frame, ValidationDialogCallback callbackHandler, ValidationObject validationObject, boolean ignoreOption) {
        this(frame, callbackHandler, validationObject, ignoreOption, false);
    }

    public ValidationDialog(BufferedFrame frame, ValidationDialogCallback callbackHandler, ValidationObject validationObject, boolean ignoreOption, boolean modal) {
        super((Frame)frame, modal);
        String strTitle = m_msgFile.getMessage("3049", false);
        ((Dialog)((Object)this)).setTitle(strTitle);
        if (validationObject == null || validationObject.getNumProblems() == 0) {
            throw new IllegalArgumentException();
        }
        this.m_callbackHandler = callbackHandler;
        this.m_validationObject = validationObject;
        this.m_allowIgnore = ignoreOption;
        ((Component)((Object)this)).setSize(400, 150);
        ((Dialog)((Object)this)).setResizable(true);
        ((Window)((Object)this)).addWindowListener(this);
        this.addControls();
        Point point = frame.getLocation();
        ((Component)((Object)this)).setLocation(point.x + 300, point.y + 100);
    }

    private void addControls() {
        VtxGBPanel basePanel = new VtxGBPanel(new GridBagLayout());
        String nlsLabel = m_msgFile.getMessage("2011", false);
        basePanel.add((Component)new LWLabel(nlsLabel), 0, 0, 1, 1, 0, 18, 0.0, 0.0, 5, 5, 0, 0);
        if (this.m_allowIgnore) {
            nlsLabel = m_msgFile.getMessage("3050", false);
            basePanel.add((Component)new LWLabel("  " + nlsLabel), 1, 0, 1, 1, 0, 18, 0.0, 0.0, 5, 0, 0, 0);
        }
        ScrollBox sb = new ScrollBox((Component)this.createTable(), 0, 0);
        basePanel.add((Component)sb, 0, 1, 2, 1, 1, 18, 1.0, 1.0, 5, 5, 5, 5);
        nlsLabel = m_msgFile.getMessage("3054", false);
        basePanel.add((Component)new MultiLineLabel(WordWrapper.getTextWrapper(), nlsLabel), 0, 2, 2, 1, 1, 18, 0.0, 0.30000000000000004, 5, 5, 0, 5);
        ButtonBar buttonPanel = new ButtonBar();
        nlsLabel = m_msgFile.getMessage("3051", false);
        this.m_gotoButton = new PushButton(nlsLabel);
        this.m_gotoButton.addActionListener((ActionListener)this);
        nlsLabel = m_msgFile.getMessage("3052", false);
        this.m_closeButton = new PushButton(nlsLabel);
        this.m_closeButton.addActionListener((ActionListener)this);
        this.m_closeButton.setDefault(true);
        buttonPanel.add((Component)this.m_gotoButton);
        buttonPanel.add((Component)this.m_closeButton);
        basePanel.add((Component)buttonPanel, 0, 3, 2, 1, 2, 15, 0.0, 0.0, 10, 0, 0, 0);
        this.enableButtons();
        this.setLayout(new BorderLayout());
        ((Container)((Object)this)).add("Center", (Component)((Object)basePanel));
    }

    private SpreadTable createTable() {
        this.m_ds = new ArrayTwoDDataSource(1, this.m_validationObject.getNumProblems());
        this.populateErrorList();
        this.m_errorList = new SpreadTable((TwoDDataSource)this.m_ds, null, null);
        this.m_errorList.addComponentListener(this);
        this.m_errorList.setColumnWidth(0, 200);
        this.m_errorList.setHorizontalSeparatorsVisible(false);
        this.m_errorList.setVerticalSeparatorsVisible(false);
        Grid grid = this.m_errorList.getGrid();
        this.m_tableSelection = new SingleRowSelection();
        grid.setGridSelection((GridSelection)this.m_tableSelection);
        this.m_errorList.addRowSelectListener((TableRowSelectListener)this);
        return this.m_errorList;
    }

    private void populateErrorList() {
        Enumeration enumeration = this.m_validationObject.getValidationElements();
        int index = 0;
        while (enumeration.hasMoreElements()) {
            ValidationProblem problem = (ValidationProblem)enumeration.nextElement();
            this.m_ds.setData(0, index, (Object)problem.getMessage());
            ++index;
        }
    }

    private int getMaxWidth() {
        Graphics g = ((Component)((Object)this)).getGraphics();
        FontMetrics metrics = g.getFontMetrics();
        int maxWidth = 0;
        Enumeration enumeration = this.m_validationObject.getValidationElements();
        while (enumeration.hasMoreElements()) {
            ValidationProblem problem = (ValidationProblem)enumeration.nextElement();
            String msg = problem.getMessage();
            int stringWidth = metrics.stringWidth(msg);
            maxWidth = Math.max(maxWidth, stringWidth);
        }
        g.dispose();
        return maxWidth;
    }

    public void validate() {
        if (!this.resized) {
            int rowHeight = this.m_errorList.getDefaultRowHeight();
            this.m_errorList.setDefaultRowHeight(rowHeight += 10);
            int numLines = 3;
            ((Component)((Object)this)).setSize(400, 132 + rowHeight * numLines);
            this.resized = true;
        }
        super.validate();
    }

    private ValidationProblem getSelectedItem() {
        ValidationProblem problem = null;
        if (this.m_tableSelection.isSomethingSelected()) {
            int[] selections = this.m_tableSelection.getSelectedRows();
            problem = this.m_validationObject.getValidationProblemAt(selections[0]);
        }
        return problem;
    }

    private void exit(int returnVal) {
        if (this.m_callbackHandler != null) {
            this.m_callbackHandler.validationDialogDismissed(returnVal, this.getSelectedItem());
        }
        this.dispose();
    }

    private void handleProblem() {
        ValidationHandler handler;
        ValidationProblem problem = this.getSelectedItem();
        if (problem != null && (handler = problem.getValidationHandler()) != null) {
            handler.handleValidationProblem(problem.getComponent());
        }
    }

    private void enableButtons() {
        int[] selections = this.m_tableSelection.getSelectedRows();
        boolean itemSelected = selections != null && selections.length > 0;
        this.m_gotoButton.setEnabled(itemSelected);
    }

    public void rowSelected(TableEvent event) {
        this.enableButtons();
    }

    public void rowSelecting(TableEvent event) {
    }

    public void rowDeselecting(TableEvent event) {
    }

    public void rowDeselected(TableEvent event) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_closeButton) {
            this.exit(1);
        } else if (e.getSource() == this.m_gotoButton) {
            this.handleProblem();
        } else if (e.getSource() == this.m_errorList) {
            this.handleProblem();
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        if (e.getComponent() instanceof SpreadTable) {
            SpreadTable table = (SpreadTable)e.getComponent();
            int width = this.getMaxWidth();
            int tableWidth = table.getSize().width;
            int colWidth = Math.max(width, tableWidth);
            table.setColumnWidth(0, colWidth);
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.exit(1);
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

