/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.util.printComponent;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintJob;
import oracle.sysman.emSDK.common.nls.MessageBundle;

public class PrintGraphics {
    private static MessageBundle m_msgBundle = MessageBundle.getMessageBundle("Vtk");
    private String m_Header = m_msgBundle.getMessage("3024", false);
    private String m_Footer = m_msgBundle.getMessage("3025", false);
    private Graphics m_Page;
    private PrintJob m_PrintJob;
    private int m_pageHeight;
    private int m_pageWidth;
    private int m_pageNum;
    private Point m_origin;

    public PrintGraphics(PrintJob printJob, Graphics graphics) {
        this.m_Page = graphics;
        this.m_PrintJob = printJob;
        this.preparePage(this.m_Page);
    }

    public Graphics getGraphics() {
        return this.m_Page;
    }

    public Point getOrigin() {
        return this.m_origin;
    }

    public int getPageHeight() {
        return this.m_pageHeight;
    }

    public int getPageWidth() {
        return this.m_pageWidth;
    }

    public void setHeader(String header) {
        if (header == null) {
            return;
        }
        this.m_Header = header;
    }

    public void setFooter(String footer) {
        if (footer == null) {
            return;
        }
        this.m_Footer = footer;
    }

    public Graphics newPage() {
        if (this.m_Page != null) {
            this.m_Page.dispose();
        }
        this.m_Page = this.m_PrintJob.getGraphics();
        this.preparePage(this.m_Page);
        return this.m_Page;
    }

    private void preparePage(Graphics page) {
        String pageNum;
        int width;
        FontMetrics metrics;
        int offset;
        block2: {
            page.setFont(new Font("TimesRoman", 0, 12));
            offset = this.m_PrintJob.getPageResolution() / 20;
            this.m_pageHeight = this.m_PrintJob.getPageDimension().height - offset * 2;
            this.m_pageWidth = this.m_PrintJob.getPageDimension().width - offset * 2;
            metrics = page.getFontMetrics();
            int height = metrics.getHeight() - metrics.getLeading();
            width = metrics.stringWidth(this.m_Header);
            page.drawString(this.m_Header, (this.m_pageWidth - width) / 2 + offset, (offset - height) / 2 + metrics.getAscent());
            ++this.m_pageNum;
            pageNum = null;
            try {
                pageNum = this.m_Footer.concat(Integer.toString(this.m_pageNum));
            }
            catch (NumberFormatException numberFormatException) {
                if (pageNum != null) break block2;
                pageNum = this.m_Footer;
            }
        }
        width = metrics.stringWidth(this.m_Footer);
        page.drawString(pageNum, (this.m_pageWidth - width) / 2 + offset, this.m_pageHeight + offset);
        page.translate(offset / 2, offset);
        this.m_origin = new Point(offset / 2, offset);
    }
}

