/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.client.util.printComponent;

import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import oracle.sysman.emSDK.client.appContainer.WebApplication;
import oracle.sysman.emSDK.client.util.printComponent.PrintConstants;
import oracle.sysman.emSDK.client.util.printComponent.PrintGraphics;
import oracle.sysman.emSDK.client.util.printComponent.PrintJobException;
import oracle.sysman.emSDK.client.util.printComponent.Printable;

public class PrintJobThread
implements Runnable {
    private boolean m_printJobCancelled = false;
    private Printable m_requester;
    private WebApplication m_container;

    public PrintJobThread(Printable requester, WebApplication console) {
        this.m_requester = requester;
        this.m_container = console;
    }

    public void run() {
        PrintJob printJob = null;
        PrintGraphics printGraphics = null;
        if (!this.m_printJobCancelled && this.m_requester != null) {
            try {
                try {
                    printJob = Toolkit.getDefaultToolkit().getPrintJob(this.m_container.getFrame(), this.m_requester.getTitle(), null);
                    if (printJob == null) {
                        PrintJobException exception = new PrintJobException(0, PrintConstants.NO_PRINTER_FOUND_MSG);
                        this.m_requester.setException(exception);
                        Object var4_6 = null;
                        if (printGraphics != null) {
                            printGraphics.getGraphics().dispose();
                        }
                        if (printJob != null) {
                            printJob.end();
                        }
                        this.m_container.printJobCompleted(this);
                        return;
                    }
                    Graphics graphics = printJob.getGraphics();
                    printGraphics = new PrintGraphics(printJob, graphics);
                    boolean status = this.m_requester.doPrint(printGraphics);
                }
                catch (PrintJobException exception) {
                    this.m_requester.setException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                if (printGraphics != null) {
                    printGraphics.getGraphics().dispose();
                }
                if (printJob != null) {
                    printJob.end();
                }
                this.m_container.printJobCompleted(this);
                throw throwable;
            }
            Object var4_7 = null;
            if (printGraphics != null) {
                printGraphics.getGraphics().dispose();
            }
            if (printJob != null) {
                printJob.end();
            }
            this.m_container.printJobCompleted(this);
        }
    }

    public void cancelPrint() {
        this.m_printJobCancelled = true;
        boolean status = this.m_requester.cancelPrint();
        this.m_container.printJobCompleted(this);
    }
}

