/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.common.nls;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import oracle.sysman.vxx.vxxt.VxxtTRACE;

public class MessageBundle {
    private ResourceBundle m_resBundle;
    private String m_sFacility;
    private Locale m_locale = Locale.getDefault();
    private String m_sPackage = "oracle.sysman.resources";
    private static Hashtable m_hBundles = new Hashtable();
    private static String m_sDefPackage = "oracle.sysman.resources";
    private static String m_sSeparator = "/";
    private static Locale m_defLocale = Locale.getDefault();

    public static MessageBundle getMessageBundle(String facility) {
        return MessageBundle.getMessageBundle(facility, m_defLocale.toString(), m_sDefPackage);
    }

    public static MessageBundle getMessageBundle(String facility, Locale locale) {
        return MessageBundle.getMessageBundle(facility, locale.toString(), m_sDefPackage);
    }

    public static MessageBundle getMessageBundle(String facility, Locale locale, String packageName) {
        return MessageBundle.getMessageBundle(facility, locale.toString(), packageName);
    }

    public static MessageBundle getMessageBundle(String facility, String strLocale) {
        return MessageBundle.getMessageBundle(facility, strLocale, m_sDefPackage);
    }

    public static MessageBundle getMessageBundle(String facility, String strLocale, String packageName) {
        StringBuffer bdlInfo = new StringBuffer(50);
        bdlInfo.append(facility).append(m_sSeparator).append(strLocale).append(m_sSeparator).append(packageName);
        MessageBundle bndl = null;
        Hashtable hashtable = m_hBundles;
        synchronized (hashtable) {
            bndl = (MessageBundle)m_hBundles.get(bdlInfo.toString());
            if (bndl == null) {
                bndl = new MessageBundle(facility, strLocale, packageName);
                m_hBundles.put(bdlInfo.toString(), bndl);
            }
        }
        return bndl;
    }

    public MessageBundle(String facility) {
        this(facility, Locale.getDefault());
    }

    public MessageBundle(String facility, Locale locale) {
        if (locale != null) {
            this.m_locale = locale;
        }
        this.m_sFacility = facility;
    }

    public MessageBundle(String facility, Locale locale, String packageName) {
        this(facility, locale);
        if (!m_sDefPackage.equals(packageName)) {
            this.setPackage(packageName);
        }
    }

    public MessageBundle(String facility, String strLocale) {
        if (strLocale != null) {
            StringTokenizer tk = new StringTokenizer(strLocale, "_");
            if (tk.countTokens() == 3) {
                String language = tk.nextToken();
                String country = tk.nextToken();
                String variant = tk.nextToken();
                this.m_locale = new Locale(language, country, variant);
            } else if (tk.countTokens() == 2) {
                String language = tk.nextToken();
                String country = tk.nextToken();
                this.m_locale = new Locale(language, country);
            }
        }
        this.m_sFacility = facility;
    }

    public MessageBundle(String facility, String strLocale, String packageName) {
        this(facility, strLocale);
        if (!m_sDefPackage.equals(packageName)) {
            this.setPackage(packageName);
        }
    }

    public MessageBundle(Locale locale, String facility) {
        this(facility, locale);
    }

    private String getCode(String key) {
        return String.valueOf(this.getFacility().toUpperCase()) + "-" + key;
    }

    public String getMessage(String key, boolean errNum) {
        String msg = null;
        try {
            msg = this.getMyBundle().getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            msg = "<null>";
            VxxtTRACE.out("MessageBundle.getMessage() failed to load the string " + this.getCode(key));
        }
        if (!errNum) {
            return msg;
        }
        return String.valueOf(this.getCode(key)) + " : " + msg;
    }

    public String getMessage(String key, boolean errNum, Object[] args) {
        return MessageFormat.format(this.getMessage(key, errNum), args);
    }

    public synchronized String getPackage() {
        return this.m_sPackage;
    }

    public synchronized void setPackage(String packageName) throws MissingResourceException {
        StringBuffer bdlInfo = new StringBuffer();
        bdlInfo.append(this.getFacility()).append("/").append(this.m_locale.toString()).append("/").append(this.m_sPackage);
        this.m_sPackage = packageName;
        this.loadBundle(true);
        Hashtable hashtable = m_hBundles;
        synchronized (hashtable) {
            if (m_hBundles.remove(bdlInfo.toString()) != null) {
                m_hBundles.put(bdlInfo.toString(), this);
            }
        }
    }

    private void loadBundle(boolean forceReload) {
        if (this.m_resBundle == null || forceReload) {
            String resourceString = String.valueOf(this.m_sPackage) + "." + this.getFacility() + "Msg";
            this.m_resBundle = ResourceBundle.getBundle(resourceString, this.getLocale());
        }
    }

    private String getFacility() {
        return this.m_sFacility;
    }

    private Locale getLocale() {
        return this.m_locale;
    }

    private synchronized ResourceBundle getMyBundle() {
        this.loadBundle(false);
        return this.m_resBundle;
    }
}

