/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.common.registry;

import java.io.File;
import java.io.IOException;
import oracle.sysman.emSDK.common.registry.Entry;
import oracle.sysman.emSDK.common.registry.ObjectContext;
import oracle.sysman.emSDK.common.registry.ObjectRegistry;
import oracle.sysman.emSDK.common.registry.OracleHomeMissingException;
import oracle.sysman.emSDK.common.registry.PropertiesFileRegistry;
import oracle.sysman.emSDK.common.registry.RegistryObject;
import oracle.sysman.emSDK.common.registry.RegistryOperations;

public class ClientConfigPropertiesRegistry
extends PropertiesFileRegistry {
    public static final String PROPERTIES_FILE_NAME = "ClientConfig.properties";

    public ClientConfigPropertiesRegistry() throws IOException, OracleHomeMissingException {
        String oraHome = System.getProperty("ORACLE_HOME");
        if (oraHome == null) {
            throw new OracleHomeMissingException();
        }
        if (!oraHome.endsWith(File.separator)) {
            oraHome = String.valueOf(oraHome) + File.separator;
        }
        this.setPropertiesFile(String.valueOf(oraHome) + "sysman" + File.separator + "config" + File.separator + PROPERTIES_FILE_NAME);
        try {
            this.setRegistryNamingContext("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ClientConfigPropertiesRegistry test = null;
        try {
            test = new ClientConfigPropertiesRegistry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(test.getRegistryName());
        System.out.println(test.getRegistryScope());
        try {
            Entry[] en = new Entry[]{new Entry("type", "BACCHUS"), new Entry("class", "a.b.c"), new Entry("name", "MyApp")};
            test.putSubtree("/application/app1", en);
            test.saveRegistry();
        }
        catch (Exception exception) {}
        test.dump();
        try {
            System.out.println("Getting application subtree.");
            Entry[] e = test.getSubtree("/application/app1");
            int i = 0;
            while (i < e.length) {
                System.out.println(String.valueOf(e[i].key) + "      " + e[i].val);
                ++i;
            }
            System.out.println("Getting application subtree keys.");
            String[] s = test.getSubtreeKeys("/application/app1");
            int i2 = 0;
            while (i2 < s.length) {
                System.out.println(s[i2]);
                ++i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ObjectRegistry objReg = new ObjectRegistry((RegistryOperations)test);
        Entry[] domain = new Entry[]{new Entry("name", "MBS"), new Entry("BootHost", "chinacat"), new Entry("BootPort", "7771")};
        RegistryObject domObj = new RegistryObject(ObjectContext.CONTEXT_OEM_SYSTEM, "domain", "domain1", domain);
        try {
            objReg.putObject(domObj);
            objReg.saveRegistry();
            RegistryObject obj1 = objReg.getObject(ObjectContext.CONTEXT_OEM_SYSTEM, "domain", "domain1");
            obj1.dump();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        test.dump();
        try {
            RegistryObject[] objs = objReg.getObjectsOfType(ObjectContext.CONTEXT_OEM_SYSTEM, "domain");
            int i = 0;
            while (i < objs.length) {
                objs[i].dump();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getRegistryName() {
        return new String("Client Config Registry");
    }
}

