/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.common.registry;

public class ObjectContext {
    private String m_ctxt;
    public static final String[] COMPANY_ORACLE = new String[2];
    public static final String[] ORG_SMP;
    public static final String[] PRODUCT_OEM_SYSTEM;
    public static final String[] PRODUCT_OEM_CONSOLE;
    public static final String[] PRODUCT_OEM;
    public static final ObjectContext CONTEXT_OEM_SYSTEM;
    public static final ObjectContext CONTEXT_OEM_CONSOLE;
    public static final ObjectContext CONTEXT_OEM;

    public ObjectContext(String[] company, String[] org, String[] product) {
        int i;
        if (company == null || company.length < 1) {
            throw new IllegalArgumentException("Company name must be at least one element long.");
        }
        if (product == null || product.length < 1) {
            throw new IllegalArgumentException("Company name must be at least one element long.");
        }
        this.m_ctxt = new String();
        int i2 = 0;
        while (i2 < company.length) {
            this.m_ctxt = String.valueOf(this.m_ctxt) + "/" + company[i2];
            ++i2;
        }
        if (org != null) {
            i = 0;
            while (i < org.length) {
                this.m_ctxt = String.valueOf(this.m_ctxt) + "/" + org[i];
                ++i;
            }
        }
        i = 0;
        while (i < product.length) {
            this.m_ctxt = String.valueOf(this.m_ctxt) + "/" + product[i];
            ++i;
        }
    }

    ObjectContext(String ctxt) {
        this.m_ctxt = ctxt;
    }

    String getContext() {
        return this.m_ctxt;
    }

    static {
        ObjectContext.COMPANY_ORACLE[0] = "com";
        ObjectContext.COMPANY_ORACLE[1] = "oracle";
        ORG_SMP = new String[1];
        ObjectContext.ORG_SMP[0] = "sysman";
        PRODUCT_OEM_SYSTEM = new String[2];
        ObjectContext.PRODUCT_OEM_SYSTEM[0] = "em";
        ObjectContext.PRODUCT_OEM_SYSTEM[1] = "system";
        PRODUCT_OEM_CONSOLE = new String[2];
        ObjectContext.PRODUCT_OEM_CONSOLE[0] = "em";
        ObjectContext.PRODUCT_OEM_CONSOLE[1] = "console";
        PRODUCT_OEM = new String[1];
        ObjectContext.PRODUCT_OEM[0] = "em";
        CONTEXT_OEM_SYSTEM = new ObjectContext(COMPANY_ORACLE, ORG_SMP, PRODUCT_OEM_SYSTEM);
        CONTEXT_OEM_CONSOLE = new ObjectContext(COMPANY_ORACLE, ORG_SMP, PRODUCT_OEM_CONSOLE);
        CONTEXT_OEM = new ObjectContext(COMPANY_ORACLE, ORG_SMP, PRODUCT_OEM);
    }
}

