/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emSDK.common.registry;

import oracle.sysman.emSDK.common.nls.MessageBundle;
import oracle.sysman.emSDK.common.registry.Entry;
import oracle.sysman.emSDK.common.registry.InvalidKeyException;
import oracle.sysman.emSDK.common.registry.NotFoundException;
import oracle.sysman.emSDK.common.registry.ObjectContext;
import oracle.sysman.emSDK.common.registry.RegistryException;
import oracle.sysman.emSDK.common.registry.RegistryObject;
import oracle.sysman.emSDK.common.registry.RegistryOperations;

public class ObjectRegistry {
    private static MessageBundle m_msgBundle = MessageBundle.getMessageBundle("EmSDK");
    private RegistryOperations m_reg;
    private static ObjectRegistry m_instance = null;
    private static boolean m_inBrowser;

    public ObjectRegistry(RegistryOperations impl) throws IllegalArgumentException {
        if (impl == null) {
            throw new IllegalArgumentException(m_msgBundle.getMessage("1001", false));
        }
        this.m_reg = impl;
    }

    public static ObjectRegistry getInstance() throws RegistryException {
        if (m_instance == null) {
            throw new RegistryException(m_msgBundle.getMessage("1001", false));
        }
        return m_instance;
    }

    public static void setInstance(ObjectRegistry reg, boolean inBrowser) {
        m_instance = reg;
        m_inBrowser = inBrowser;
    }

    public static boolean inBrowser() {
        return m_inBrowser;
    }

    public RegistryObject getObject(ObjectContext ctxt, String objType, String objName) throws InvalidKeyException, RegistryException {
        String key = String.valueOf(ctxt.getContext()) + "/" + objType + "/" + objName;
        Entry[] fields = this.m_reg.getSubtree(key);
        return new RegistryObject(ctxt, key, fields);
    }

    public RegistryObject[] getObjectsOfType(ObjectContext ctxt, String objType) throws InvalidKeyException, RegistryException {
        String key = String.valueOf(ctxt.getContext()) + "/" + objType;
        Entry[] objs = this.m_reg.getSubtree(key);
        return RegistryObject.parseObjectSubtree(ctxt, objType, objs);
    }

    public void putObject(RegistryObject obj) throws InvalidKeyException, RegistryException {
        this.m_reg.putSubtree(obj.getObjectName(), obj.getObjectFields());
    }

    public void removeObject(RegistryObject obj) throws NotFoundException, InvalidKeyException, RegistryException {
        this.m_reg.removeSubtree(obj.getObjectName());
    }

    public void removeObjectsOfType(ObjectContext ctxt, String objType) throws NotFoundException, InvalidKeyException, RegistryException {
        String key = String.valueOf(ctxt.getContext()) + "/" + objType;
        this.m_reg.removeSubtree(key);
    }

    public String[] getSubtreeKeys(String rootKey) throws InvalidKeyException, RegistryException {
        return this.m_reg.getSubtreeKeys(rootKey);
    }

    public void saveRegistry() throws RegistryException {
        this.m_reg.saveRegistry();
    }
}

