/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vtx;

import java.awt.Dimension;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.Grid;
import oracle.ewt.header.Header;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.util.ImmInsets;
import oracle.sysman.vtx.TableAutoResizeListener;

public class VtxSTableUtil {
    private static int _MIN_COLUMN_WIDTH = 10;

    public static void enableAutoResize(SpreadTable table) {
        new TableAutoResizeListener(table);
    }

    public static void autoResizeAllColumns(SpreadTable table) {
        VtxSTableUtil.autoResizeAllColumns(table, false);
    }

    public static void autoResizeAllColumns(SpreadTable table, boolean fill) {
        Header header = table.getColumnHeader();
        int colcnt = table.getGrid().getColumnCount();
        int[] colWidth = new int[colcnt];
        int i = 0;
        while (i < colcnt) {
            colWidth[i] = VtxSTableUtil._getPreferredColumnWidth(table, i, true);
            ++i;
        }
        if (fill) {
            int tableWidth = table.getInnerSize().width;
            int colTotalWidth = 0;
            i = 0;
            while (i < colcnt) {
                colTotalWidth += colWidth[i];
                ++i;
            }
            if (colTotalWidth > 0 && colTotalWidth < tableWidth - 60) {
                i = 0;
                while (i < colcnt) {
                    colWidth[i] = (int)((float)(tableWidth - 60) * ((float)colWidth[i] / (float)colTotalWidth));
                    ++i;
                }
            }
        }
        i = 0;
        while (i < colcnt) {
            colWidth[i] = Math.max(_MIN_COLUMN_WIDTH, colWidth[i]);
            ++i;
        }
        i = 0;
        while (i < colcnt) {
            table.setColumnWidth(i, colWidth[i]);
            ++i;
        }
    }

    public static void autoResizeColumn(SpreadTable table, int colindex) {
        VtxSTableUtil.autoResizeColumn(table, colindex, false);
    }

    public static void autoResizeColumn(SpreadTable table, int colindex, boolean includeHeader) {
        int maxWidth = VtxSTableUtil._getPreferredColumnWidth(table, colindex, includeHeader);
        maxWidth = Math.max(_MIN_COLUMN_WIDTH, maxWidth);
        table.setColumnWidth(colindex, maxWidth);
    }

    private static int _getPreferredColumnWidth(SpreadTable table, int colindex, boolean includeHeader) {
        ImmInsets insets;
        PaintContext context;
        Grid grid = table.getGrid();
        int maxWidth = 0;
        Painter painter = grid.getColumnPainter(colindex);
        AppearanceManager am = grid.getAppearanceManager();
        int first = grid.getFirstRowOnScreen();
        int last = first + grid.getOnScreenRowCount();
        int i = first;
        while (i < last) {
            context = grid.getCellPaintContext(colindex, i);
            Dimension prefSize = painter.getPreferredSize(context);
            insets = am.getCellPaintingAppearance(colindex, i).getInsets();
            prefSize.width += insets.left + insets.right;
            if (prefSize.width > maxWidth) {
                maxWidth = prefSize.width;
            }
            ++i;
        }
        if (includeHeader) {
            Header header = table.getColumnHeader();
            context = header.getItemPaintContext(colindex);
            insets = header.getItemAppearance(colindex).getInsets();
            int headerSize = insets.left + insets.right;
            BorderPainter border = header.getHeaderItemBorderPainter();
            insets = border.getInsets(context);
            headerSize += insets.left + insets.right;
            painter = header.getPainter(colindex);
            if ((headerSize += painter.getPreferredSize((PaintContext)context).width) > maxWidth) {
                maxWidth = headerSize;
            }
        }
        return maxWidth;
    }
}

