/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vxn;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import oracle.sysman.emSDK.common.nls.MessageBundle;
import oracle.sysman.vxn.VxnBootstrapException;
import oracle.sysman.vxn.VxnNamingService;
import oracle.sysman.vxn.VxnPortBoundException;
import oracle.sysman.vxx.vxxt.VxxtTRACE;

public class VxnBootService
extends Thread {
    private static MessageBundle m_msgBundle = new MessageBundle("Vxn");
    public static final String BOOT_PORT_PROP = "oem.BootPort";
    public static final String BOOT_HOST_PROP = "oem.BootHost";
    public static final String BOOT_PORT_DEFAULT = "7771";
    public static final String BOOT_OPER = "NamingService";
    public static final String SHUTDOWN_OPER = "Shutdown";
    public static final String DIAGNOSE_OPER = "Diagnose";
    private String m_ior;
    private VxnNamingService m_ns;
    private int m_port = -1;
    private ServerSocket m_serverSocket;

    public VxnBootService(String ior, VxnNamingService ns) throws VxnPortBoundException, VxnBootstrapException {
        this.m_ior = ior;
        this.m_ns = ns;
        String sPort = System.getProperty(BOOT_PORT_PROP);
        try {
            this.m_port = Integer.parseInt(sPort);
        }
        catch (NumberFormatException numberFormatException) {
            throw new VxnBootstrapException(m_msgBundle.getMessage("1001", false));
        }
        try {
            this.m_serverSocket = new ServerSocket(this.m_port);
        }
        catch (BindException bindException) {
            throw new VxnPortBoundException(m_msgBundle.getMessage("1002", false, new Object[]{Integer.toString(this.m_port)}));
        }
        catch (IOException iOException) {
            throw new VxnBootstrapException(m_msgBundle.getMessage("1003", false));
        }
        VxxtTRACE.out("Starting boot service on port " + this.m_port, 3);
        this.start();
    }

    public void run() {
        Socket socket = null;
        byte[] inBuffer = new byte[20];
        boolean bExit = false;
        try {
            while (true) {
                socket = this.m_serverSocket.accept();
                BufferedOutputStream ostream = new BufferedOutputStream(socket.getOutputStream());
                BufferedInputStream istream = new BufferedInputStream(socket.getInputStream());
                int bytesRead = istream.read(inBuffer, 0, 20);
                String request = new String(inBuffer, 0, bytesRead);
                if (request.equals(BOOT_OPER)) {
                    byte[] outBuffer = this.m_ior.getBytes();
                    ostream.write(outBuffer, 0, outBuffer.length);
                    ostream.flush();
                } else {
                    if (request.equals(SHUTDOWN_OPER)) {
                        bExit = true;
                        break;
                    }
                    VxxtTRACE.out("Unrecognized bootstrap request.", 2);
                }
                socket.close();
                socket = null;
            }
        }
        catch (IOException e) {
            VxxtTRACE.out("\n\n*******************************************", 2);
            VxxtTRACE.out("IMPORTANT: If you see this, please save both client and server traces and contact Michael Stern.", 2);
            VxxtTRACE.out("Bootstrap Exception: Closing Socket connection.", 15);
            e.printStackTrace();
            VxxtTRACE.out("*******************************************\n\n", 2);
        }
        try {
            if (socket != null) {
                socket.close();
                socket = null;
            }
        }
        catch (IOException iOException) {}
        try {
            this.m_serverSocket.close();
        }
        catch (IOException iOException) {}
        if (bExit) {
            this.m_ns.standAloneExit();
        }
    }

    public void endService() {
        if (!this.isAlive()) {
            return;
        }
        Socket socket = null;
        try {
            try {
                byte[] outBuffer = null;
                socket = new Socket(InetAddress.getLocalHost(), this.m_port);
                BufferedOutputStream ostream = new BufferedOutputStream(socket.getOutputStream());
                String command = SHUTDOWN_OPER;
                outBuffer = command.getBytes();
                ostream.write(outBuffer, 0, outBuffer.length);
                ostream.flush();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            Object var3_6 = null;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException iOException) {}
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {}
    }
}

