/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vxn;

import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import oracle.sysman.emSDK.common.nls.MessageBundle;
import oracle.sysman.vxn.VxnBadHostException;
import oracle.sysman.vxn.VxnBadPortException;
import oracle.sysman.vxn.VxnBootstrapException;
import oracle.sysman.vxn.VxnServiceNotFoundException;
import oracle.sysman.vxx.vxxt.VxxtTRACE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;

public class VxnClientBootstrap {
    private static MessageBundle m_msgBundle = new MessageBundle("Vxn");
    private static int MAX_IOR_SIZE = 1000;
    private static Applet m_applet = null;

    public static NamingContext getInitialNamingContext(Applet applet) throws VxnBadPortException, VxnBadHostException, VxnServiceNotFoundException, VxnBootstrapException {
        m_applet = applet;
        return VxnClientBootstrap.getInitialNamingContext();
    }

    public static NamingContext getInitialNamingContext() throws VxnBadPortException, VxnBadHostException, VxnServiceNotFoundException, VxnBootstrapException {
        NamingContext initNC = null;
        byte[] outBuffer = new byte[20];
        byte[] inBuffer = new byte[MAX_IOR_SIZE];
        Socket socket = null;
        String host = null;
        String sPort = null;
        try {
            host = m_applet != null ? (m_applet.getAppletContext() != null ? m_applet.getParameter("oem.BootHost") : System.getProperty("oem.BootHost")) : System.getProperty("oem.BootHost");
            if (host == null) {
                throw new VxnBadHostException(m_msgBundle.getMessage("1004", false));
            }
        }
        catch (SecurityException securityException) {
            if (m_applet != null) {
                if (m_applet.getAppletContext() != null) {
                    host = m_applet.getParameter("oem.BootHost");
                }
            }
            throw new VxnBootstrapException(m_msgBundle.getMessage("1006", false));
        }
        try {
            sPort = m_applet != null ? (m_applet.getAppletContext() != null ? m_applet.getParameter("oem.BootPort") : System.getProperty("oem.BootPort")) : System.getProperty("oem.BootPort");
            if (sPort == null) {
                throw new VxnBadPortException(m_msgBundle.getMessage("1001", false));
            }
        }
        catch (SecurityException securityException) {
            if (m_applet != null) {
                if (m_applet.getAppletContext() != null) {
                    sPort = m_applet.getParameter("oem.BootPort");
                }
            }
            throw new VxnBootstrapException(m_msgBundle.getMessage("1006", false));
        }
        VxxtTRACE.out("Reading Properties: oem.BootHost = " + host + " oem.BootPort = " + sPort, 3);
        try {
            try {
                if (host == "") {
                    throw new VxnBadHostException(m_msgBundle.getMessage("1000", false));
                }
                int port = -1;
                try {
                    port = Integer.parseInt(sPort);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new VxnBadPortException(m_msgBundle.getMessage("1001", false));
                }
                socket = new Socket(host, port);
                VxxtTRACE.out("Opening bootstrap socket on host " + host + " and port " + port, 2);
                BufferedOutputStream ostream = new BufferedOutputStream(socket.getOutputStream());
                BufferedInputStream istream = new BufferedInputStream(socket.getInputStream());
                String command = "NamingService";
                outBuffer = command.getBytes();
                ostream.write(outBuffer, 0, outBuffer.length);
                ostream.flush();
                int bytesRead = istream.read(inBuffer, 0, MAX_IOR_SIZE);
                String ior = new String(inBuffer, 0, bytesRead);
                ORB orb = ORB.init();
                Object obj = orb.string_to_object(ior);
                initNC = NamingContextHelper.narrow((Object)obj);
            }
            catch (ConnectException connectException) {
                throw new VxnServiceNotFoundException(m_msgBundle.getMessage("1007", false));
            }
            catch (Exception e) {
                throw new VxnBootstrapException(e.getMessage());
            }
            java.lang.Object var8_15 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var8_16 = null;
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException iOException) {}
        return initNC;
    }
}

