/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vxn;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.emSDK.common.nls.MessageBundle;
import oracle.sysman.vdf.VdfMASFaultHandler;
import oracle.sysman.vxn.VxnBindingIterator;
import oracle.sysman.vxn.VxnBootService;
import oracle.sysman.vxn.VxnBootstrapException;
import oracle.sysman.vxn.VxnCannotProceedException;
import oracle.sysman.vxn.VxnName;
import oracle.sysman.vxn.VxnNamingContext;
import oracle.sysman.vxx.VxxOMSConfigProperties;
import oracle.sysman.vxx.VxxProperties;
import oracle.sysman.vxx.vxxt.VxxtTRACE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;

public class VxnNamingService
implements Runnable,
VdfMASFaultHandler {
    private static MessageBundle m_msgBundle = new MessageBundle("Vxn");
    private Thread m_threadMain = new Thread(this);
    private boolean m_bExitNow = false;
    private Vector m_names;
    private ORB m_orb;
    private VxnBootService m_bootService;
    private boolean m_bLocal = false;
    private NamingContext m_initNC;
    private static boolean m_bEmbedded;

    private static VxnNamingService getNamingService(boolean bLocal) throws VxnBootstrapException {
        VxnNamingService ns = new VxnNamingService(bLocal);
        ns.init();
        ns.startMainThread();
        m_bEmbedded = true;
        return ns;
    }

    public static VxnNamingService getNamingService() throws VxnBootstrapException {
        return VxnNamingService.getNamingService(false);
    }

    public static VxnNamingService getLocalNamingService() throws VxnBootstrapException {
        return VxnNamingService.getNamingService(true);
    }

    public NamingContext getLocalInitialNamingContext() {
        if (!this.m_bLocal) {
            return null;
        }
        return this.m_initNC;
    }

    public void handleFault(String[] masNames) {
        VxxtTRACE.out("################### Name Service fault handler called !! ######################");
        this.dump();
        int i = 0;
        while (i < masNames.length) {
            VxxtTRACE.out("Removing Entries for Defective OMS on node " + masNames[i]);
            this.purgeObsoleteEntries(masNames[i]);
            ++i;
        }
        this.dump();
    }

    public static void main(String[] args) {
        VxxtTRACE.enableDebugTracing();
        VxxtTRACE.configure(false, true, true, false, null, false);
        VxxtTRACE.out("Vxn: testing VxxtTRACE.out().... ");
        VxxOMSConfigProperties omsProperties = new VxxOMSConfigProperties();
        VxxtTRACE.out("calling getAppProperties()...");
        VxxProperties.getAppProperties();
        VxnNamingService ns = new VxnNamingService();
        try {
            ns.init();
        }
        catch (VxnBootstrapException vxnBootstrapException) {
            return;
        }
        ns.startMainThread();
        System.out.println("Naming service successfully started.");
    }

    public void run() {
        this.waitUntilExit();
        if (!m_bEmbedded) {
            System.exit(0);
        }
    }

    public VxnNamingService() {
        this.m_orb = ORB.init();
        this.setExitable(false);
    }

    public VxnNamingService(boolean bLocal) {
        this.m_bLocal = bLocal;
        this.m_orb = ORB.init();
        this.setExitable(false);
    }

    private void init() throws VxnBootstrapException {
        if (!this.initNames()) {
            throw new VxnBootstrapException(m_msgBundle.getMessage("1008", false));
        }
        VxnNamingContext.setNamingService(this);
        VxnBindingIterator.setNamingService(this);
        this.enableBootstrap();
    }

    public synchronized void exit() {
        VxxtTRACE.out("Exiting Naming Service.", 2);
        if (this.m_bootService != null) {
            this.m_bootService.endService();
        }
        this.setExitable(true);
        this.notifyAll();
    }

    public void standAloneExit() {
        if (!m_bEmbedded) {
            this.exit();
        }
    }

    public void dump() {
        if (this.m_names.size() == 0) {
            VxxtTRACE.out("No names in array.");
        } else {
            String buffer = null;
            int i = 0;
            Enumeration e = this.m_names.elements();
            while (e.hasMoreElements()) {
                VxnName n = (VxnName)e.nextElement();
                buffer = String.valueOf(i) + ": ";
                int x = 0;
                while (x < n.getDepth() * 4) {
                    buffer = String.valueOf(buffer) + " ";
                    ++x;
                }
                VxxtTRACE.out(String.valueOf(buffer) + n.toString());
                ++i;
            }
        }
        VxxtTRACE.out("");
    }

    synchronized void bind(NameComponent[] n, Object obj, int index, boolean bOverwrite) throws NotFound, AlreadyBound, VxnCannotProceedException {
        int cursorIndex = this.traverseToTerminalContext(n, index, false);
        VxnName cursor = this.getNameAt(cursorIndex);
        int termIndex = n.length - 1;
        VxnName name = this.findChildName(cursorIndex, cursor.getDepth(), n[termIndex]);
        if (name == null) {
            name = new VxnName(cursor.getDepth() + 1, n[termIndex].id, n[termIndex].kind);
            this.addContext(name, cursorIndex + 1);
        } else if (name.isBound() && !bOverwrite) {
            throw new AlreadyBound();
        }
        String IOR = this.m_orb.object_to_string(obj);
        name.bind(IOR);
        this.writeNames();
    }

    synchronized Object resolve(NameComponent[] n, int index) throws NotFound, VxnCannotProceedException {
        VxnNamingContext obj = null;
        int curIndex = this.traverseToTerminalContext(n, index, true);
        if (curIndex == -1) {
            throw new NotFound(NotFoundReason.missing_node, new NameComponent[0]);
        }
        VxnName cursor = this.getNameAt(curIndex);
        if (cursor.isBound()) {
            String IOR = cursor.getIOR();
            obj = this.m_orb.string_to_object(IOR);
        } else {
            obj = VxnNamingContext.getNewContext(curIndex);
        }
        return obj;
    }

    synchronized void unbind(NameComponent[] n, int index) throws NotFound, VxnCannotProceedException {
        int curIndex = this.traverseToTerminalContext(n, index, true);
        VxnName cursor = this.getNameAt(curIndex);
        this.stripTree(n, curIndex, cursor, index);
    }

    synchronized void purgeObsoleteEntries(String location) {
        boolean findMore = true;
        boolean found = false;
        VxnName curEntry = null;
        try {
            VxxtTRACE.out("purging location " + location);
            while (findMore) {
                found = false;
                int i = 0;
                Enumeration e = this.m_names.elements();
                while (e.hasMoreElements()) {
                    curEntry = (VxnName)e.nextElement();
                    if (curEntry.getDepth() == 6 && location.equalsIgnoreCase(curEntry.getID())) {
                        this.purgeChildren(i, curEntry);
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (found) continue;
                findMore = false;
            }
        }
        catch (NotFound e) {
            VxxtTRACE.out((Exception)((java.lang.Object)e));
        }
        catch (VxnCannotProceedException e) {
            VxxtTRACE.out(e);
        }
    }

    void purgeChildren(int curIndex, VxnName curEntry) throws NotFound, VxnCannotProceedException {
        VxnName child = this.getNameAt(curIndex + 1);
        if (child != null && child.getDepth() > curEntry.getDepth()) {
            this.purgeChildren(curIndex + 1, child);
        }
        VxxtTRACE.out("Removing entry " + curEntry);
        this.removeContext(curIndex);
        this.writeNames();
    }

    void stripTree(NameComponent[] n, int curIndex, VxnName cursor, int index) throws NotFound, VxnCannotProceedException {
        String buffer = "Unbind name ";
        VxnName child = this.getNameAt(curIndex + 1);
        if (child == null || child.getDepth() != cursor.getDepth() + 1) {
            this.removeContext(curIndex);
            this.writeNames();
            int numRemain = n.length - 1;
            if (numRemain == 0) {
                return;
            }
            NameComponent[] rest = new NameComponent[numRemain];
            int i = 0;
            while (i < numRemain) {
                rest[i] = n[i];
                ++i;
            }
            int nextIndex = this.traverseToTerminalContext(rest, index, true);
            VxnName nextCursor = this.getNameAt(nextIndex);
            this.stripTree(rest, nextIndex, nextCursor, index);
        }
    }

    synchronized VxnNamingContext newContext(int index) {
        VxnName cursor = null;
        cursor = this.getNameAt(index);
        VxnName newName = new VxnName(cursor.getDepth() + 1);
        this.addContext(newName, index + 1);
        this.writeNames();
        return VxnNamingContext.getNewContext(index + 1);
    }

    synchronized VxnNamingContext bindNewContext(NameComponent[] n, int index) throws NotFound, AlreadyBound, VxnCannotProceedException {
        VxnName cursor;
        int cursorIndex = this.traverseToTerminalContext(n, index, false);
        VxnName oldName = this.findChildName(cursorIndex, (cursor = this.getNameAt(cursorIndex)).getDepth(), n[n.length - 1]);
        if (oldName != null) {
            throw new AlreadyBound();
        }
        NameComponent nc = n[n.length - 1];
        VxnName newName = new VxnName(cursor.getDepth() + 1, nc.id, nc.kind);
        this.addContext(newName, cursorIndex + 1);
        this.writeNames();
        return VxnNamingContext.getNewContext(cursorIndex + 1);
    }

    synchronized void destroyContext(int index) throws NotEmpty {
        VxnName cursor = null;
        VxnName child = null;
        boolean bLastName = false;
        cursor = this.getNameAt(index);
        try {
            child = (VxnName)this.m_names.elementAt(index + 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            bLastName = true;
        }
        if (!bLastName && child.getDepth() > cursor.getDepth()) {
            throw new NotEmpty();
        }
        this.removeContext(index);
        this.writeNames();
    }

    synchronized int getBindings(int parentIndex, int startIndex, int how_many, BindingListHolder bl) {
        VxnName cursor = this.getNameAt(parentIndex);
        VxnName child = null;
        Vector<Binding> list = new Vector<Binding>();
        int parentDepth = cursor.getDepth();
        int childDepth = cursor.getDepth() + 1;
        int count = 0;
        int iteratorStartIndex = -1;
        int i = startIndex;
        while (count < how_many + 1) {
            child = this.getNameAt(i);
            if (child == null || child.getDepth() == parentDepth) break;
            if (child.getDepth() == childDepth) {
                if (count < how_many) {
                    Binding b = new Binding();
                    b.binding_type = child.isBound() ? BindingType.nobject : BindingType.ncontext;
                    NameComponent nc = new NameComponent(child.getID(), child.getKind());
                    NameComponent[] nca = new NameComponent[]{nc};
                    b.binding_name = nca;
                    list.addElement(b);
                } else {
                    iteratorStartIndex = i;
                }
                ++count;
            }
            ++i;
        }
        java.lang.Object[] bindings = new Binding[list.size()];
        if (list.size() > 0) {
            list.copyInto(bindings);
        }
        bl.value = bindings;
        return iteratorStartIndex;
    }

    void list(int how_many, BindingListHolder bl, BindingIteratorHolder bi, int index) {
        int nextStart = this.getBindings(index, index + 1, how_many, bl);
        VxnBindingIterator vbi = nextStart == -1 ? null : new VxnBindingIterator(index, nextStart);
        bi.value = vbi;
    }

    ORB getORB() {
        return this.m_orb;
    }

    private VxnName getNameAt(int index) {
        VxnName cursor = null;
        try {
            cursor = (VxnName)this.m_names.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return cursor;
    }

    private int traverseToTerminalContext(NameComponent[] n, int start, boolean bContext) throws NotFound, VxnCannotProceedException {
        int end = -1;
        if (start > this.m_names.size()) {
            VxxtTRACE.out("ERROR: attempt to traverse to illegal index. Cursor out of sync.", 2);
            throw new VxnCannotProceedException(n);
        }
        if (n.length == 1 && !bContext) {
            return start;
        }
        VxnName cursor = this.getNameAt(start);
        VxnName next = null;
        int curDepth = cursor.getDepth();
        int nameIndex = 0;
        int endOfArray = this.m_names.size();
        boolean bFound = false;
        int index = start + 1;
        while (index < endOfArray) {
            try {
                next = (VxnName)this.m_names.elementAt(index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            if (next.getDepth() == curDepth + 1) {
                if (next.matches(n[nameIndex])) {
                    ++curDepth;
                    if (++nameIndex == (bContext ? n.length : n.length - 1)) {
                        bFound = true;
                        end = index;
                        break;
                    }
                }
            } else if (next.getDepth() <= curDepth + 1) break;
            ++index;
        }
        if (!bFound) {
            int numRemain = n.length - nameIndex;
            NameComponent[] rest = new NameComponent[numRemain];
            int i = 0;
            while (i < numRemain) {
                rest[i] = n[i + nameIndex];
                ++i;
            }
            throw new NotFound(NotFoundReason.missing_node, rest);
        }
        return end;
    }

    private VxnName findChildName(int parentIndex, int depth, NameComponent n) {
        int i = parentIndex + 1;
        VxnName child = this.getNameAt(i);
        boolean bFound = false;
        while (!bFound) {
            if (child == null || child.getDepth() == depth) break;
            if (child.getDepth() == depth + 1 && child.matches(n)) {
                bFound = true;
                break;
            }
            child = this.getNameAt(++i);
        }
        return bFound ? child : null;
    }

    private String getNamesFilename() {
        return String.valueOf(this.getNamesFilePath()) + File.separator + "COSNaming.store";
    }

    private String getNamesFilePath() {
        String path = System.getProperty("ORACLE_HOME");
        if (path == null) {
            path = "L:" + File.separator;
        }
        path = String.valueOf(path) + File.separator + "sysman" + File.separator + "system";
        return path;
    }

    private void writeNames() {
        if (!this.m_bLocal) {
            return;
        }
        FileOutputStream ostream = null;
        ObjectOutputStream p = null;
        try {
            try {
                ostream = new FileOutputStream(this.getNamesFilename());
                p = new ObjectOutputStream(ostream);
                p.writeObject(this.m_names);
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    File f = new File(this.getNamesFilePath());
                    boolean bMade = f.mkdirs();
                    if (bMade) {
                        VxxtTRACE.out("Created directory for naming service persistence file.", 2);
                        this.writeNames();
                    }
                    VxxtTRACE.out("Could not create directory for naming service persistence file.", 2);
                }
                catch (SecurityException ex) {
                    VxxtTRACE.out("Could not create directory for naming service persistence file.", 2);
                    VxxtTRACE.out(ex);
                }
            }
            catch (IOException e) {
                VxxtTRACE.out("Unexpected exception writing naming service file.", 2);
                VxxtTRACE.out(e);
            }
            java.lang.Object var4_7 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var4_8 = null;
            try {
                if (p != null) {
                    p.close();
                }
                if (ostream != null) {
                    ostream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (p != null) {
                p.close();
            }
            if (ostream != null) {
                ostream.close();
            }
        }
        catch (IOException iOException) {}
    }

    private boolean initNames() {
        FileInputStream istream = null;
        ObjectInputStream p = null;
        boolean bSuccess = true;
        if (!this.m_bLocal) {
            this.initNewNamesList();
            return bSuccess;
        }
        try {
            try {
                istream = new FileInputStream(this.getNamesFilename());
                p = new ObjectInputStream(istream);
                this.m_names = (Vector)p.readObject();
                VxxtTRACE.out("Reading serialized names from file.", 2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                VxxtTRACE.out("Store file not found; creating new file.", 2);
                this.initNewNamesList();
            }
            catch (IOException e) {
                VxxtTRACE.out("IOException looking for store file; creating new file.", 2);
                VxxtTRACE.out(e);
                this.initNewNamesList();
                try {
                    File f = new File(this.getNamesFilePath());
                    VxxtTRACE.out("Naming service persistence file is " + this.getNamesFilePath(), 2);
                    boolean bDeleted = f.delete();
                    if (bDeleted) {
                        VxxtTRACE.out("Deleted indecipherable naming service persistence file.", 2);
                    }
                    VxxtTRACE.out("Could not delete indecipherable naming service persistence file.", 2);
                }
                catch (SecurityException ex) {
                    VxxtTRACE.out("Security violation deleting indecipherable naming service persistence file.", 2);
                    VxxtTRACE.out(ex);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                bSuccess = false;
            }
            java.lang.Object var5_9 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var5_10 = null;
            try {
                if (p != null) {
                    p.close();
                }
                if (istream != null) {
                    istream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (p != null) {
                p.close();
            }
            if (istream != null) {
                istream.close();
            }
        }
        catch (IOException iOException) {}
        return bSuccess;
    }

    private void initNewNamesList() {
        this.m_names = new Vector(200, 0);
        VxnName root = new VxnName(0, "INTERNAL_ROOT", "ARE_YOU_KIND?");
        this.m_names.addElement(root);
        VxxtTRACE.out("Could not find names file.  Creating new naming tree.", 2);
    }

    private static NamingContext getInitialContext() {
        VxnNamingContext nc = null;
        if (nc == null) {
            VxxtTRACE.out("Visigenic implementation.  Calling getNewContext(0) to get initial context.", 2);
            nc = VxnNamingContext.getNewContext(0);
        }
        return nc;
    }

    private void enableBootstrap() throws VxnBootstrapException {
        this.m_initNC = VxnNamingService.getInitialContext();
        if (!this.m_bLocal) {
            String IOR = this.m_orb.object_to_string((Object)this.m_initNC);
            VxxtTRACE.out("About to create a service that will serve out ..[" + IOR.length() + "] " + IOR, 2);
            this.m_bootService = new VxnBootService(IOR, this);
        } else {
            if (this.m_initNC == null) {
                System.out.println("ERROR: m_initNC is null in enableBootstrap.");
            }
            VxxtTRACE.out("Local/dedicated Naming Service started.", 2);
        }
    }

    private void startMainThread() {
        if (this.m_threadMain == null) {
            VxxtTRACE.out("FATAL ERROR: main thread not created.", 16);
        } else {
            this.m_threadMain.start();
        }
    }

    private synchronized void waitUntilExit() {
        while (!this.getExitable()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void setExitable(boolean state) {
        this.m_bExitNow = state;
    }

    private synchronized boolean getExitable() {
        return this.m_bExitNow;
    }

    private void addContext(VxnName name, int index) throws ArrayIndexOutOfBoundsException {
        this.m_names.insertElementAt(name, index);
        VxnNamingContext.incCursorsFromIndex(index);
    }

    private void removeContext(int index) {
        this.m_names.removeElementAt(index);
        VxnNamingContext.decCursorsFromIndex(index);
    }

    private void test() {
        Object obj;
        NamingContext ncx;
        NameComponent[] nca;
        NameComponent ncomp;
        NamingContext vnc = VxnNamingService.getInitialContext();
        System.out.println("Adding new_context 1 to init NC.");
        NamingContext nc1 = vnc.new_context();
        System.out.println("Adding new_context 2 to NC 1.");
        NamingContext nc2 = nc1.new_context();
        System.out.println("Adding new_context 3 to NC 2.");
        NamingContext nc3 = nc2.new_context();
        System.out.println("Adding new_context 4 to NC 1.");
        NamingContext nc4 = nc1.new_context();
        System.out.println("Destroying context 3.");
        try {
            nc3.destroy();
        }
        catch (NotEmpty notEmpty) {
            System.out.println("Context 3 could not be destroyed - not empty.");
        }
        System.out.println("Destroying context 1.");
        try {
            nc1.destroy();
        }
        catch (NotEmpty notEmpty) {
            System.out.println("Context 1 could not be destroyed - not empty.");
        }
        System.out.println("Destroying context 4.");
        try {
            nc4.destroy();
        }
        catch (NotEmpty notEmpty) {
            System.out.println("Context 4 could not be destroyed - not empty.");
        }
        System.out.println("Destroying context 2.");
        try {
            nc2.destroy();
        }
        catch (NotEmpty notEmpty) {
            System.out.println("Context 2 could not be destroyed - not empty.");
        }
        System.out.println("Destroying context 1.");
        try {
            nc1.destroy();
        }
        catch (NotEmpty notEmpty) {
            System.out.println("Context 1 could not be destroyed - not empty.");
        }
        System.out.println("Creating new context A.");
        try {
            ncomp = new NameComponent("A", "kA");
            nca = new NameComponent[]{ncomp};
            nc1 = vnc.bind_new_context(nca);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Create context with invalid name.");
        try {
            nca = new NameComponent[]{};
            ncx = vnc.bind_new_context(nca);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Create context A/B/C with compound contexts not created (NotFound).");
        try {
            ncomp = new NameComponent("A", "kA");
            ncomp = new NameComponent("B", "kB");
            ncomp = new NameComponent("C", "kC");
            nca = new NameComponent[]{ncomp, ncomp, ncomp};
            ncx = vnc.bind_new_context(nca);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Create an already bound context.");
        try {
            ncomp = new NameComponent("A", "kA");
            nca = new NameComponent[]{ncomp};
            ncx = vnc.bind_new_context(nca);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Create context A/B from compound name.");
        try {
            ncomp = new NameComponent("A", "kA");
            ncomp = new NameComponent("B", "kB");
            nca = new NameComponent[]{ncomp, ncomp};
            nc2 = vnc.bind_new_context(nca);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Create context A/C from simple name under A.");
        try {
            ncomp = new NameComponent("C", "kC");
            nca = new NameComponent[]{ncomp};
            nc3 = nc1.bind_new_context(nca);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Create context A/C/D from compound name.");
        try {
            ncomp = new NameComponent("A", "kA");
            ncomp = new NameComponent("C", "kC");
            ncomp = new NameComponent("D", "kD");
            nca = new NameComponent[]{ncomp, ncomp, ncomp};
            nc4 = vnc.bind_new_context(nca);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Bind IOR to A from root.");
        try {
            ncomp = new NameComponent("A", "kA");
            nca = new NameComponent[]{ncomp};
            vnc.bind(nca, (Object)vnc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Bind IOR to A/B/X from root (NotFound).");
        try {
            ncomp = new NameComponent("A", "kA");
            ncomp = new NameComponent("B", "kB");
            ncomp = new NameComponent("X", "kX");
            nca = new NameComponent[]{ncomp, ncomp, ncomp};
            vnc.bind(nca, (Object)vnc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Bind IOR to A from root (AlreadyBound).");
        try {
            ncomp = new NameComponent("A", "kA");
            nca = new NameComponent[]{ncomp};
            vnc.bind(nca, (Object)vnc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Rebind IOR to A from root.");
        try {
            ncomp = new NameComponent("A", "kA");
            nca = new NameComponent[]{ncomp};
            vnc.rebind(nca, (Object)vnc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Bind IOR to A/C/D from root.");
        try {
            ncomp = new NameComponent("A", "kA");
            ncomp = new NameComponent("C", "kC");
            ncomp = new NameComponent("D", "kD");
            nca = new NameComponent[]{ncomp, ncomp, ncomp};
            vnc.bind(nca, (Object)vnc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Bind IOR to A/B from A.");
        try {
            ncomp = new NameComponent("B", "kB");
            nca = new NameComponent[]{ncomp};
            nc1.bind(nca, (Object)vnc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Resolve A in root.");
        try {
            ncomp = new NameComponent("A", "kA");
            nca = new NameComponent[]{ncomp};
            obj = vnc.resolve(nca);
            System.out.println("IOR found.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Resolve X in root (NotFound).");
        try {
            ncomp = new NameComponent("X", "kX");
            nca = new NameComponent[]{ncomp};
            obj = vnc.resolve(nca);
            System.out.println("IOR found.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Resolve A/B/X in root (NotFound).");
        try {
            ncomp = new NameComponent("A", "kA");
            ncomp = new NameComponent("B", "kB");
            ncomp = new NameComponent("X", "kX");
            nca = new NameComponent[]{ncomp, ncomp, ncomp};
            obj = vnc.resolve(nca);
            System.out.println("IOR found.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Resolve A/C in root (NotFound - NC).");
        try {
            ncomp = new NameComponent("A", "kA");
            ncomp = new NameComponent("C", "kC");
            nca = new NameComponent[]{ncomp, ncomp};
            obj = vnc.resolve(nca);
            System.out.println("IOR found.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Resolve A/C/D in A/C.");
        try {
            ncomp = new NameComponent("D", "kD");
            nca = new NameComponent[]{ncomp};
            obj = nc3.resolve(nca);
            System.out.println("IOR found.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Unbind A in root.");
        try {
            ncomp = new NameComponent("A", "kA");
            nca = new NameComponent[]{ncomp};
            vnc.unbind(nca);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Unbind A/X in root (NotFound).");
        try {
            ncomp = new NameComponent("A", "kA");
            ncomp = new NameComponent("X", "kX");
            nca = new NameComponent[]{ncomp, ncomp};
            vnc.unbind(nca);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Unbind A/C in root (NotFound - NC).");
        try {
            ncomp = new NameComponent("A", "kA");
            ncomp = new NameComponent("C", "kC");
            nca = new NameComponent[]{ncomp, ncomp};
            vnc.unbind(nca);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Unbind A/C/D in A.");
        try {
            ncomp = new NameComponent("C", "kC");
            ncomp = new NameComponent("D", "kD");
            nca = new NameComponent[]{ncomp, ncomp};
            nc1.unbind(nca);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BindingIteratorHolder bi = new BindingIteratorHolder();
        BindingListHolder bl = new BindingListHolder();
        System.out.println("Listing root.");
        vnc.list(10, bl, bi);
        this.printList(bl);
        if (bi.value != null) {
            System.out.println("ERROR: Binding Iterator returned.");
        }
        System.out.println("Listing A.");
        nc1.list(10, bl, bi);
        this.printList(bl);
        if (bi.value != null) {
            System.out.println("ERROR: Binding Iterator returned.");
        }
        System.out.println("Listing A/B.");
        nc2.list(10, bl, bi);
        this.printList(bl);
        if (bi.value != null) {
            System.out.println("ERROR: Binding Iterator returned.");
        }
        System.out.println("Listing A/C/D.");
        nc4.list(10, bl, bi);
        this.printList(bl);
        if (bi.value != null) {
            System.out.println("ERROR: Binding Iterator returned.");
        }
    }

    private void printList(BindingListHolder bl) {
        Binding[] list = bl.value;
        if (list.length == 0) {
            System.out.println("No elements in list.\n");
        } else {
            int i = 0;
            while (i < list.length) {
                String type = list[i].binding_type == BindingType.nobject ? "Object" : "Context";
                NameComponent[] nca = list[i].binding_name;
                System.out.println(String.valueOf(type) + " | " + nca[0].id + " | " + nca[0].kind);
                ++i;
            }
            System.out.println("");
        }
    }
}

