/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vxx;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import oracle.sysman.vxx.VxxProperties;
import oracle.sysman.vxx.VxxPropertiesFile;
import oracle.sysman.vxx.vxxd.VxxdCrypt;
import oracle.sysman.vxx.vxxx.VxxxString;

public final class VxxOMSConfigProperties
extends VxxPropertiesFile {
    private static String m_fileName = null;
    private VxxdCrypt m_des = new VxxdCrypt();

    public static void main(String[] args) {
        VxxProperties.getAppProperties();
        VxxOMSConfigProperties props = new VxxOMSConfigProperties();
        String user = props.getUser();
        String password = props.getPassword();
        System.out.println("user is " + user);
        System.out.println("Password is " + password);
        props.setPassword("devtest6");
        password = props.getPassword();
        System.out.println("After change, password is " + password);
        String service = props.getService();
        System.out.println(">>>OMS Properties:");
        props.list(System.out);
        System.out.println(">>>System Properties:");
        Properties sysProps = System.getProperties();
        sysProps.list(System.out);
        try {
            props.save();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public VxxOMSConfigProperties() {
        super(VxxOMSConfigProperties.constructName());
    }

    public String getUser() {
        return this.getProperty("OEM.REPOSITORY.USER");
    }

    public String setUser(String user) {
        return this.put("OEM.REPOSITORY.USER", user);
    }

    public String removeUser() {
        return this.remove("OEM.REPOSITORY.USER");
    }

    public String getPassword() {
        String encrPwd = this.getProperty("OEM.REPOSITORY.PASSWORD");
        if (encrPwd == null) {
            return encrPwd;
        }
        byte[] encrPwdArray = VxxxString.asciiStringToByteArray(encrPwd);
        byte[] decrPasswdArray = this.m_des.decryptAsByteArray(encrPwdArray, this.getUser().getBytes());
        return new String(decrPasswdArray).trim();
    }

    public String setPassword(String pwd) {
        VxxdCrypt des = new VxxdCrypt();
        byte[] encryptedPasswordArray = this.m_des.encryptAsByteArray(pwd, this.getUser());
        String encryptedPassword = VxxxString.byteArrayToAsciiString(encryptedPasswordArray);
        return this.put("OEM.REPOSITORY.PASSWORD", encryptedPassword);
    }

    public String removePassword() {
        return this.remove("OEM.REPOSITORY.PASSWORD");
    }

    public String getService() {
        return this.getProperty("OEM.REPOSITORY.DATABASE");
    }

    public String setService(String service) {
        return this.put("OEM.REPOSITORY.DATABASE", service);
    }

    public String removeService() {
        return this.remove("OEM.REPOSITORY.DATABASE");
    }

    public String getIsMaster() {
        return this.getProperty("oms.isMaster");
    }

    public String setIsMaster(String isMaster) {
        return this.put("oms.isMaster", isMaster);
    }

    public String removeIsMaster() {
        return this.remove("oms.isMaster");
    }

    public String getBootHost() {
        return this.getProperty("oem.BootHost");
    }

    public String setBootHost(String bootHost) {
        return this.put("oem.BootHost", bootHost);
    }

    public String removeBootHost() {
        return this.remove("oem.BootHost");
    }

    public String getBootPort() {
        return this.getProperty("oem.BootPort");
    }

    public String setBootPort(String bootPort) {
        return this.put("oem.BootPort", bootPort);
    }

    public String removeBootPort() {
        return this.remove("oem.BootPort");
    }

    public static String getPropertiesFileName() {
        return VxxOMSConfigProperties.constructName();
    }

    private static String constructName() {
        block4: {
            if (m_fileName != null) break block4;
            String ORACLE_HOME = System.getProperty("ORACLE_HOME");
            File path = new File("");
            if (ORACLE_HOME != null) {
                path = new File(ORACLE_HOME, "sysman");
                path = new File(path, "config");
            } else {
                path = new File(System.getProperty("user.dir"));
            }
            m_fileName = "omsconfig.properties";
            path = new File(path, m_fileName);
            try {
                m_fileName = path.getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
        return m_fileName;
    }
}

