/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vxx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import oracle.sysman.emSDK.common.nls.MessageBundle;
import oracle.sysman.vxx.VxxFile;
import oracle.sysman.vxx.VxxProperties;

public class VxxPropertiesFile
extends VxxProperties
implements VxxFile {
    private File m_file;
    private boolean m_loading = false;
    private boolean m_loaded = false;
    private boolean m_modified = false;
    private String m_fileBanner;

    public static void main(String[] args) {
        String fileName = "d:/orant/sysman/config/OMSRepositoryConstraints.properties";
        VxxProperties.getAppProperties();
        Properties sysProps = System.getProperties();
        VxxPropertiesFile props = new VxxPropertiesFile(fileName);
        Enumeration e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            System.out.println("Name: " + key + ", Value: " + props.getProperty(key));
        }
        props.put("Lovelace", "Ada");
        props.put("Babbage", "Charles");
        props.put("Turing", "Alan");
        System.out.println(">>>VxxPropertiesFile contents:");
        props.list(System.out);
        System.out.println(">>>System Properties contents:");
        sysProps.list(System.out);
        props.remove((Object)"Turing", true);
        props.remove((Object)"Babbage", false);
        props.remove("Lovelace");
        System.out.println(">>>VxxPropertiesFile contents:");
        props.list(System.out);
        System.out.println(">>>System Properties contents:");
        sysProps.list(System.out);
    }

    public VxxPropertiesFile(String filename) {
        this(new File(filename));
    }

    public VxxPropertiesFile(File file) {
        this.m_file = file;
    }

    public VxxPropertiesFile(String filename, Properties defaults) {
        this(new File(filename));
    }

    public VxxPropertiesFile(File file, Properties defaults) {
        super(defaults);
        this.m_file = file;
    }

    public void clear() {
        super.clear();
        this.m_loaded = false;
        this.m_modified = true;
    }

    public void load() throws IOException {
        block8: {
            block6: {
                block7: {
                    if (!this.exists()) break block6;
                    if (!this.canRead()) break block7;
                    String filename = this.getCanonicalPath();
                    FileInputStream stream = new FileInputStream(filename);
                    try {
                        this.m_loading = true;
                        super.load(stream);
                        this.m_loaded = true;
                        this.m_modified = false;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        this.m_loading = false;
                        throw throwable;
                    }
                    Object var4_5 = null;
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    this.m_loading = false;
                    break block8;
                }
                MessageBundle msgFile = new MessageBundle("Vxx");
                String strError = msgFile.getMessage("2006", true);
                throw new IOException(strError);
            }
            this.m_loaded = true;
            this.m_modified = false;
        }
    }

    public void save() throws IOException {
        if (this.m_fileBanner == null) {
            MessageBundle msgFile = new MessageBundle("Vxx");
            this.m_fileBanner = msgFile.getMessage("3000", false);
        }
        FileOutputStream fStream = new FileOutputStream(this.getCanonicalPath());
        super.save(fStream, this.m_fileBanner);
        fStream.close();
        this.m_modified = false;
    }

    public void setFileBanner(String banner) {
        this.m_fileBanner = banner;
    }

    public synchronized Enumeration keys() {
        if (!this.m_loading && !this.m_loaded) {
            this.loadProperties();
            if (!this.m_loaded) {
                return null;
            }
        }
        return super.keys();
    }

    public String getProperty(String key, String defaultValue) {
        if (!this.m_loading && !this.m_loaded) {
            this.loadProperties();
            if (!this.m_loaded) {
                return null;
            }
        }
        return super.getProperty(key, defaultValue);
    }

    public String getProperty(String key) {
        if (!this.m_loading && !this.m_loaded) {
            this.loadProperties();
            if (!this.m_loaded) {
                return null;
            }
        }
        return super.getProperty(key);
    }

    public void list(PrintWriter out) {
        if (!this.m_loading && !this.m_loaded) {
            this.loadProperties();
            if (!this.m_loaded) {
                return;
            }
        }
        super.list(out);
    }

    public void list(PrintStream out) {
        if (!this.m_loading && !this.m_loaded) {
            this.loadProperties();
            if (!this.m_loaded) {
                return;
            }
        }
        super.list(out);
    }

    public Enumeration propertyNames() {
        if (!this.m_loading && !this.m_loaded) {
            this.loadProperties();
            if (!this.m_loaded) {
                return null;
            }
        }
        return super.propertyNames();
    }

    public String put(String key, String value) {
        if (!this.m_loading && !this.m_loaded) {
            this.loadProperties();
            if (!this.m_loaded) {
                return null;
            }
        }
        String oldValue = (String)super.put(key, value);
        this.m_modified = true;
        return oldValue;
    }

    public String remove(String key) {
        if (!this.m_loading && !this.m_loaded) {
            this.loadProperties();
            if (!this.m_loaded) {
                return null;
            }
        }
        String oldValue = (String)super.remove(key);
        this.m_modified = true;
        return oldValue;
    }

    public int size() {
        if (!this.m_loading && !this.m_loaded) {
            this.loadProperties();
        }
        return super.size();
    }

    public boolean canRead() {
        return this.m_file.canRead();
    }

    public boolean canWrite() {
        return this.m_file.canWrite();
    }

    public boolean delete() {
        return this.m_file.delete();
    }

    public boolean equals(Object obj) {
        return this.m_file.equals(obj);
    }

    public boolean exists() {
        return this.m_file.exists();
    }

    public String getAbsolutePath() {
        return this.m_file.getAbsolutePath();
    }

    public String getCanonicalPath() throws IOException {
        return this.m_file.getCanonicalPath();
    }

    public String getName() {
        return this.m_file.getName();
    }

    public String getParent() {
        return this.m_file.getParent();
    }

    public String getPath() {
        return this.m_file.getPath();
    }

    public boolean isAbsolute() {
        return this.m_file.isAbsolute();
    }

    public boolean isDirectory() {
        return this.m_file.isDirectory();
    }

    public boolean isFile() {
        return this.m_file.isFile();
    }

    public long lastModified() {
        return this.m_file.lastModified();
    }

    public long length() {
        return this.m_file.length();
    }

    public String[] list() {
        return this.m_file.list();
    }

    public String[] list(FilenameFilter filter) {
        return this.m_file.list(filter);
    }

    public boolean mkdir() {
        return this.m_file.mkdir();
    }

    public boolean mkdirs() {
        return this.m_file.mkdirs();
    }

    public boolean renameTo(File dest) {
        return this.m_file.renameTo(dest);
    }

    public void loadProperties() {
        try {
            this.load();
        }
        catch (Exception exception) {}
    }
}

