/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vxx.vxxt;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.sysman.vxx.vxxt.VxxtTRACE;

class LoggerStream
extends PrintStream {
    String m_prefix = "";
    int m_maxFiles;
    long m_maxSize;
    File[] m_files;
    private int currentIndex;
    private long currentSize;
    private boolean m_multiFile = false;
    private int runningIndex;

    public LoggerStream(String strLogFile, boolean bSavePrevious) throws IOException {
        super(System.out, true);
        LoggerStream.updateOldFiles(strLogFile, bSavePrevious);
        this.out = new FileOutputStream(strLogFile, false);
    }

    public LoggerStream(String prefix, int maxFiles, long maxSize, boolean bSavePrevious) throws IOException {
        super(System.out, true);
        this.m_multiFile = true;
        this.m_prefix = prefix;
        this.m_maxFiles = Math.max(maxFiles, 2);
        this.m_maxSize = maxSize;
        LoggerStream.updateOldFiles(prefix, bSavePrevious);
        this.m_files = new File[this.m_maxFiles];
        String filename = this.getNewFileName();
        this.m_files[0] = new File(filename);
        this.out = new FileOutputStream(filename, false);
    }

    static void updateOldFiles(String filePath, boolean bSave) {
        File f = new File(filePath);
        String name = f.getName();
        String path = f.getParent();
        if (path == null) {
            path = ".";
        }
        File dir = new File(path);
        String[] list = dir.list();
        String separator = System.getProperty("file.separator");
        String strTimeStamp = LoggerStream.getTimeStamp();
        int idx = 0;
        while (idx < list.length) {
            String strTmp;
            if (list[idx].equals(name)) {
                File oldFile = new File(String.valueOf(path) + separator + list[idx]);
                if (bSave) {
                    File newFile = new File(String.valueOf(path) + separator + list[idx] + "_" + strTimeStamp);
                    if (oldFile.exists()) {
                        oldFile.renameTo(newFile);
                    }
                } else if (oldFile.isFile()) {
                    oldFile.delete();
                }
            } else if (list[idx].startsWith(name) && list[idx].length() > name.length() && list[idx].charAt(name.length()) == '.' && (strTmp = list[idx].substring(name.length() + 1)) != null && strTmp.length() > 0 && strTmp.indexOf(95) == -1) {
                boolean bValid = true;
                try {
                    int nVal = new Integer(strTmp);
                }
                catch (NumberFormatException numberFormatException) {
                    bValid = false;
                }
                catch (Exception exception) {
                    bValid = false;
                }
                if (bValid) {
                    File oldFile = new File(String.valueOf(path) + separator + list[idx]);
                    if (bSave) {
                        File newFile = new File(String.valueOf(path) + separator + list[idx] + "_" + strTimeStamp);
                        if (oldFile.exists()) {
                            oldFile.renameTo(newFile);
                        }
                    } else if (oldFile.isFile()) {
                        oldFile.delete();
                    }
                }
            }
            ++idx;
        }
    }

    static long convertMegToBytes(int n) {
        return n * 1000 * 1024;
    }

    private String getNewFileName() {
        String strFilename = String.valueOf(this.m_prefix) + "." + this.runningIndex++;
        return strFilename;
    }

    private void checkAndSwitch(long attemptedSize) throws IOException {
        this.currentSize += attemptedSize;
        if (this.currentSize > this.m_maxSize) {
            LoggerStream loggerStream = this;
            synchronized (loggerStream) {
                if (this.currentSize > this.m_maxSize) {
                    this.out.flush();
                    this.out.close();
                    this.currentIndex = (this.currentIndex + 1) % this.m_maxFiles;
                    if (this.m_files[this.currentIndex] != null) {
                        this.m_files[this.currentIndex].delete();
                    }
                    String filename = this.getNewFileName();
                    this.m_files[this.currentIndex] = new File(filename);
                    this.out = new FileOutputStream(filename, false);
                    this.currentSize = attemptedSize;
                }
            }
        }
    }

    private static String getTimeStamp() {
        String strTimeStamp = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        strTimeStamp = sdf.format(new Date());
        return strTimeStamp;
    }

    public void print(String x) {
        if (this.m_multiFile) {
            try {
                this.checkAndSwitch(x.length());
            }
            catch (IOException ex) {
                ex.printStackTrace(VxxtTRACE.m_stderr);
            }
        }
        super.print(x);
    }

    public void println(String x) {
        if (this.m_multiFile) {
            this.currentSize += 2L;
        }
        super.println(x);
    }
}

