/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.vxx.vxxx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class VxxxString {
    private static char byteToAsciiLN(byte b) {
        return Character.forDigit(b & 0xF, 16);
    }

    private static char byteToAsciiHN(byte b) {
        return Character.forDigit(b >>> 4 & 0xF, 16);
    }

    private static byte nibblesToByte(char highNibble, char lowNibble) {
        return (byte)((byte)Character.digit(highNibble, 16) << 4 | (byte)Character.digit(lowNibble, 16) & 0xF);
    }

    public static byte[] asciiStringToByteArray(String asciiString) {
        if (asciiString.length() % 2 != 0) {
            asciiString = "0" + asciiString;
        }
        int length = asciiString.length();
        int lengthByHalf = length / 2;
        byte[] byteArray = new byte[lengthByHalf];
        char[] asciiCharArray = new char[length];
        asciiString.getChars(0, length, asciiCharArray, 0);
        int i = 0;
        while (i < lengthByHalf) {
            byteArray[i] = VxxxString.nibblesToByte(asciiCharArray[i * 2], asciiCharArray[i * 2 + 1]);
            ++i;
        }
        return byteArray;
    }

    public static String byteArrayToAsciiString(byte[] byteArray) {
        StringBuffer sb = new StringBuffer(byteArray.length * 2);
        int i = 0;
        while (i < byteArray.length) {
            sb.append(VxxxString.byteToAsciiHN(byteArray[i]));
            sb.append(VxxxString.byteToAsciiLN(byteArray[i]));
            ++i;
        }
        return sb.toString();
    }

    public static byte[] getBytes(String inString) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(inString);
        return baos.toByteArray();
    }

    public static String toString(byte[] byteArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream BAstrm = new ByteArrayInputStream(byteArray);
        ObjectInputStream OIstrm = new ObjectInputStream(BAstrm);
        return (String)OIstrm.readObject();
    }

    public static void main(String[] args) {
        byte[] byteArray = new byte[]{1, 25, -93, 4, -45, -76, -12, 101};
        System.out.println("Initial ByteArray of length " + byteArray.length);
        String s = VxxxString.byteArrayToAsciiString(byteArray);
        System.out.println("String from byte array: " + s);
        byte[] newByteArray = VxxxString.asciiStringToByteArray(s);
        System.out.println("Length of new byte array " + newByteArray.length);
        int i = 0;
        while (i < newByteArray.length) {
            System.out.print(String.valueOf(newByteArray[i]) + " ");
            ++i;
        }
        System.out.println("");
        System.out.println(" Performing String to Byte to String Conversions : ");
        try {
            byte[] stringToBytes = VxxxString.getBytes("TEST");
            System.out.println(" Converted String : TEST to byte array : " + stringToBytes);
            byte[] javaStringToBytes = new String("TEST").getBytes();
            System.out.println(" String.getBytes for TEST returns      : " + javaStringToBytes);
            System.out.println(" Converted Bytes : " + stringToBytes + " to String : " + VxxxString.toString(stringToBytes));
            System.out.println(" Converting java string bytes back to string [expect exception] : ");
            System.out.println(" Converted Bytes : " + javaStringToBytes + " to String : " + VxxxString.toString(javaStringToBytes));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

