/*
 * Decompiled with CFR 0.152.
 */
package oracle.CartridgeServices;

import java.util.Hashtable;
import oracle.CartridgeServices.CountException;
import oracle.CartridgeServices.InvalidKeyException;

public final class ContextManager {
    public static Hashtable ctx;
    public static int count;
    static final int MAXCOUNT = Integer.MAX_VALUE;

    public static int setContext(Object o) throws CountException {
        System.out.println("setContext key=" + count);
        if (ctx == null) {
            System.out.println("create hashtable");
            ctx = new Hashtable(100);
            count = 0;
        }
        ctx.put(new Integer(count), o);
        if (++count > Integer.MAX_VALUE) {
            throw new CountException("count is too large");
        }
        System.out.println("setContext new key=" + count);
        return count - 1;
    }

    public static Object getContext(int key) throws InvalidKeyException {
        System.out.println("getContext key=" + key + " count=" + count);
        if (key < 0 || key > Integer.MAX_VALUE) {
            throw new InvalidKeyException("count is too large");
        }
        return ctx.get(new Integer(key));
    }

    public static Object clearContext(int key) throws InvalidKeyException {
        System.out.println("clearContext key=" + key + " count=" + count);
        if (key < 0 || key > Integer.MAX_VALUE) {
            throw new InvalidKeyException("count is too large");
        }
        Object r = ctx.remove(new Integer(key));
        return r;
    }
}

