/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.admin.lio.lioo;

import java.io.File;
import oracle.security.admin.util.AdminTRACE;
import oracle.security.wallet.NZException;
import oracle.security.wallet.NZNative;
import oracle.security.wallet.NZWallet;

public class LiooClient {
    private NZWallet nzWalletObj;

    public LiooClient() {
        AdminTRACE.out("Creating Client Object...");
        new NZNative();
        AdminTRACE.out("Loaded NZNative class");
    }

    public String getDefaultDirectory() {
        try {
            String string = NZWallet.getDefaultWRL();
            String string2 = "Def. WRL: " + string;
            AdminTRACE.out(string2);
            if (string.startsWith("file")) {
                return string.substring(5);
            }
            return string;
        }
        catch (NZException nZException) {
            String string = nZException.toString();
            AdminTRACE.out(string);
            return null;
        }
    }

    public boolean isValidPassword(String string) {
        if (this.nzWalletObj == null && !this.loadWallet(string)) {
            return false;
        }
        return this.nzWalletObj.getPassword().equals(string);
    }

    public boolean changePassword(String string, String string2) {
        if (this.nzWalletObj == null && !this.loadWallet(string)) {
            return false;
        }
        this.nzWalletObj.setPassword(string2);
        return this.storeWallet();
    }

    public boolean storeWallet() {
        try {
            String string = "file:" + this.getDefaultDirectory();
            this.nzWalletObj.setWRL(string);
            String string2 = "WRL: " + this.nzWalletObj.getWRL();
            AdminTRACE.out(string2);
            return this.nzWalletObj.storeWallet();
        }
        catch (NZException nZException) {
            String string = nZException.toString();
            AdminTRACE.out(string);
            return false;
        }
    }

    public boolean loadWallet(String string) {
        String string2 = this.getDefaultDirectory();
        return this.loadWallet(string2, string);
    }

    public boolean loadWallet(String string, String string2) {
        AdminTRACE.out("Inside loadwallet");
        String string3 = "file:" + string;
        try {
            String string4 = "WRL: " + string3;
            AdminTRACE.out(string4);
            string4 = "Password: " + string2;
            AdminTRACE.out(string4);
            if (this.nzWalletObj != null) {
                this.nzWalletObj.freeWalletCMem();
                this.nzWalletObj = null;
            }
            this.nzWalletObj = NZWallet.loadWallet(string3, string2);
            return this.nzWalletObj != null;
        }
        catch (NZException nZException) {
            String string5 = "Loading exception: " + nZException.toString();
            AdminTRACE.out(string5);
            return false;
        }
    }

    public boolean storeSSOWallet() {
        try {
            String string = "file:" + this.getDefaultDirectory();
            this.nzWalletObj.setWRL(string);
            String string2 = "WRL :" + this.nzWalletObj.getWRL();
            AdminTRACE.out(string2);
            return this.nzWalletObj.storeSSOWallet();
        }
        catch (NZException nZException) {
            String string = nZException.toString();
            AdminTRACE.out(string);
            return false;
        }
    }

    public boolean isWalletExists() {
        File file = new File(this.getDefaultDirectory(), "ewallet.der");
        return file.canRead();
    }

    public boolean isSsoWalletExists() {
        File file = new File(this.getDefaultDirectory(), "cwallet.sso");
        return file.canRead();
    }

    public boolean delSsoWlt() {
        File file = new File(this.getDefaultDirectory(), "cwallet.sso");
        return file.delete();
    }

    private static void debug(String string) {
        AdminTRACE.out(string);
    }
}

