/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.admin.util;

import java.util.Enumeration;
import java.util.Vector;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Search;
import oracle.bali.share.sort.Sort;

public abstract class AdminSortedList
extends Vector
implements Comparator {
    static final long serialVersionUID = 1613063033080804554L;
    protected int compareMask;
    protected int keyMask;
    public static final int ALL_MASK = -1;

    public AdminSortedList(int n) {
        this.keyMask = n;
        this.compareMask = n;
    }

    public abstract int compareWithMask(Object var1, Object var2, int var3);

    public abstract void checkInstanceOf(Object var1) throws ClassCastException;

    public final int getMask() {
        return this.compareMask;
    }

    public final int getKeyMask() {
        return this.keyMask;
    }

    public final boolean isSortedByKey() {
        return this.keyMask == this.compareMask;
    }

    public boolean isSorted() {
        return this.isSorted(this.compareMask);
    }

    public boolean isSorted(int n) {
        int n2 = 1;
        while (n2 < this.elementCount) {
            if (this.compareWithMask(this.elementData[n2 - 1], this.elementData[n2], n) > 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public final int compare(Object object, Object object2) {
        return this.compareWithMask(object, object2, this.compareMask);
    }

    public final synchronized int search(Object object) {
        return Search.bSearch((Object)object, (Object[])this.elementData, (int)this.elementCount, (Comparator)this);
    }

    public final synchronized int searchByKey(Object object) {
        if (this.keyMask == this.compareMask) {
            return Search.bSearch((Object)object, (Object[])this.elementData, (int)this.elementCount, (Comparator)this);
        }
        int n = 0;
        while (n < this.elementCount) {
            if (this.compareWithMask(this.elementData[n], object, this.keyMask) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public final synchronized void sort() {
        Sort.qSort((Object[])this.elementData, (int)this.elementCount, (Comparator)this);
    }

    public final synchronized void sortWithMask(int n) {
        this.compareMask = n;
        if (this.elementCount > 0 && this.compareMask != 0) {
            Sort.qSort((Object[])this.elementData, (int)this.elementCount, (Comparator)this);
        }
    }

    public final synchronized int insertElement(Object object) throws ClassCastException {
        this.checkInstanceOf(object);
        this.debug("AdminSortedList: insert: elementCount = " + this.elementCount);
        this.ensureCapacity(this.elementCount + 1);
        int n = -1;
        if (this.keyMask == this.compareMask) {
            this.debug("is sorted by key");
            int n2 = this.compareMask;
            this.compareMask = this.keyMask;
            n = Search.bSearch((Object)object, (Object[])this.elementData, (int)this.elementCount, (Comparator)this);
            this.debug("index = " + n);
            this.compareMask = n2;
            if (n == -1) {
                this.debug("Search.ITEM_NOT_FOUND");
                n = Search.bSearchAndInsert((Object)object, (Object[])this.elementData, (int)this.elementCount, (Comparator)this);
                ++this.elementCount;
            } else {
                this.debug("replace old element");
                this.elementData[n] = object;
            }
        } else {
            this.debug("is sorted by non key");
            int n3 = 0;
            while (n3 < this.elementCount) {
                if (this.compareWithMask(object, this.elementData[n3], this.keyMask) == 0) {
                    this.debug("find element at " + n3);
                    n = n3;
                    this.elementData[n] = object;
                    break;
                }
                ++n3;
            }
            if (n == -1) {
                n = Search.bSearch((Object)object, (Object[])this.elementData, (int)this.elementCount, (Comparator)this);
                this.debug("nonkey, ITEM_NOT_FOUND, index = " + n);
                if (n == -1) {
                    n = Search.bSearchAndInsert((Object)object, (Object[])this.elementData, (int)this.elementCount, (Comparator)this);
                    this.debug("nonkey, ITEM_NOT_FOUND, bSearchAndInsert index = " + n);
                    ++this.elementCount;
                } else {
                    this.insertElementAt(object, n);
                    this.debug("nonkey, ITEM_NOT_FOUND, insertElementAt index = " + n);
                }
            }
        }
        return n;
    }

    public final synchronized Object removeKey(Object object) {
        Object object2 = null;
        if (this.keyMask == this.compareMask) {
            int n = this.compareMask;
            this.compareMask = this.keyMask;
            int n2 = Search.bSearch((Object)object, (Object[])this.elementData, (int)this.elementCount, (Comparator)this);
            this.compareMask = n;
            if (n2 != -1) {
                object2 = this.elementData[n2];
                this.removeElementAt(n2);
            }
        } else {
            int n = 0;
            while (n < this.elementCount) {
                if (this.compareWithMask(object, this.elementData[n], this.keyMask) == 0) {
                    object2 = this.elementData[n];
                    this.removeElementAt(n);
                    break;
                }
                ++n;
            }
        }
        return object2;
    }

    public final void diff(AdminSortedList adminSortedList, AdminSortedList adminSortedList2) {
        AdminSortedList adminSortedList3 = (AdminSortedList)adminSortedList.clone();
        adminSortedList3.sortWithMask(this.compareMask);
        Enumeration enumeration = this.elements();
        Enumeration enumeration2 = adminSortedList3.elements();
        block0: while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Object e2 = enumeration2.nextElement();
            while (this.compareWithMask(e, e2, this.compareMask) != 0) {
                if (this.compareWithMask(e, e2, this.compareMask) > 0) {
                    if (enumeration2.hasMoreElements()) {
                        e2 = enumeration2.nextElement();
                        continue;
                    }
                    adminSortedList2.insertElement(e);
                    continue block0;
                }
                adminSortedList2.insertElement(e);
                if (!enumeration.hasMoreElements()) continue block0;
                e = enumeration.nextElement();
            }
        }
        while (enumeration.hasMoreElements()) {
            adminSortedList2.insertElement(enumeration.nextElement());
        }
        adminSortedList2 = (AdminSortedList)adminSortedList2.clone();
    }

    public final void diffWithMask(AdminSortedList adminSortedList, AdminSortedList adminSortedList2, int n) {
        AdminSortedList adminSortedList3 = (AdminSortedList)this.clone();
        adminSortedList3.sortWithMask(n);
        adminSortedList3.diff(adminSortedList, adminSortedList2);
    }

    public static final void diff(AdminSortedList adminSortedList, AdminSortedList adminSortedList2, AdminSortedList adminSortedList3, AdminSortedList adminSortedList4, AdminSortedList adminSortedList5, AdminSortedList adminSortedList6, int n) {
        AdminSortedList adminSortedList7 = (AdminSortedList)adminSortedList.clone();
        AdminSortedList adminSortedList8 = (AdminSortedList)adminSortedList2.clone();
        if (adminSortedList3 != null) {
            adminSortedList3.removeAllElements();
        }
        if (adminSortedList4 != null) {
            adminSortedList4.removeAllElements();
        }
        if (adminSortedList5 != null) {
            adminSortedList5.removeAllElements();
        }
        if (adminSortedList6 != null) {
            adminSortedList6.removeAllElements();
        }
        int n2 = adminSortedList7.keyMask;
        adminSortedList7.sortWithMask(n2);
        adminSortedList8.sortWithMask(n2);
        if (adminSortedList3 != null) {
            adminSortedList3.sortWithMask(n2);
        }
        if (adminSortedList4 != null) {
            adminSortedList4.sortWithMask(n2);
        }
        if (adminSortedList5 != null) {
            adminSortedList5.sortWithMask(n2);
        }
        if (adminSortedList6 != null) {
            adminSortedList6.sortWithMask(n2);
        }
        int n3 = n2 | n;
        Enumeration enumeration = adminSortedList7.elements();
        Enumeration enumeration2 = adminSortedList8.elements();
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Object e2 = enumeration2.nextElement();
            while (adminSortedList7.compareWithMask(e, e2, adminSortedList7.compareMask) != 0) {
                if (adminSortedList7.compareWithMask(e, e2, adminSortedList7.compareMask) > 0) {
                    if (adminSortedList4 != null) {
                        adminSortedList4.insertElement(e2);
                    }
                    if (enumeration2.hasMoreElements()) {
                        e2 = enumeration2.nextElement();
                        continue;
                    }
                    if (adminSortedList3 == null) break;
                    adminSortedList3.insertElement(e);
                    break;
                }
                if (adminSortedList3 != null) {
                    adminSortedList3.insertElement(e);
                }
                if (enumeration.hasMoreElements()) {
                    e = enumeration.nextElement();
                    continue;
                }
                if (adminSortedList4 == null) break;
                adminSortedList4.insertElement(e2);
                break;
            }
            if (adminSortedList7.compareWithMask(e, e2, adminSortedList7.compareMask) != 0 || adminSortedList7.compareWithMask(e, e2, n3) == 0) continue;
            if (adminSortedList5 != null) {
                adminSortedList5.insertElement(e);
            }
            if (adminSortedList6 == null) continue;
            adminSortedList6.insertElement(e2);
        }
        while (enumeration.hasMoreElements()) {
            if (adminSortedList3 == null) continue;
            adminSortedList3.insertElement(enumeration.nextElement());
        }
        while (enumeration2.hasMoreElements()) {
            if (adminSortedList4 == null) continue;
            adminSortedList4.insertElement(enumeration2.nextElement());
        }
    }

    public int compareBool(boolean bl, boolean bl2) {
        int n = 0;
        if (bl != bl2) {
            n = bl ? 1 : -1;
        }
        return n;
    }

    protected void debug(String string) {
    }
}

