/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.admin.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import oracle.ewt.EwtComponent;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIManager;
import oracle.ewt.imageCanvas.ImageCanvas;
import oracle.ewt.layout.EqualColumnLayout;
import oracle.ewt.lwAWT.BufferedWindow;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.SeparatorBorderPainter;
import oracle.security.admin.util.AdminSplashScreen;
import oracle.security.admin.util.SplashScreenWindowAdapter;

class SplashScreenWindow
extends BufferedWindow {
    SplashScreenWindowAdapter m_adapter = new SplashScreenWindowAdapter(this);
    int m_width = -1;
    int m_height = -1;
    private LWLabel m_labelAction;
    private LWTextField m_textBar;
    private LWLabel m_copyright;

    public SplashScreenWindow(Frame frame, Image image, Image image2, String string, String string2, String string3) {
        super(frame);
        this.initControls(image, image2, string, string2, string3);
        this.m_width += 10;
        this.m_height += 27;
        ((Component)((Object)this)).setSize(this.m_width, this.m_height);
        this.centerWindow();
        ((Window)((Object)this)).addWindowListener(this.m_adapter);
        ((Component)((Object)this)).enableEvents(24L);
    }

    public void paintImmediate() {
        super.paintImmediate(0, 0, ((Component)((Object)this)).getSize().width, ((Component)((Object)this)).getSize().height);
    }

    public void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n = dimension.width / 2 - ((Component)((Object)this)).getSize().width / 2;
        int n2 = dimension.height / 2 - ((Component)((Object)this)).getSize().height / 2;
        ((Component)((Object)this)).setBounds(n, n2, ((Component)((Object)this)).getSize().width, ((Component)((Object)this)).getSize().height);
    }

    private void initControls(Image image, Image image2, String string, String string2, String string3) {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        EwtComponent ewtComponent = new EwtComponent();
        ewtComponent.setBorderPainter(UIManager.createGroupBoxPainter((String)""));
        ewtComponent.setLayout(new BorderLayout());
        ((Container)((Object)this)).add("Center", (Component)ewtComponent);
        ewtComponent.add("North", (Component)this.createBannerPanel(image2, string));
        ewtComponent.add("Center", (Component)this.createImagePanel(image));
        ewtComponent.add("South", (Component)this.createStatusPanel(string2, string3));
    }

    private EwtComponent createBannerPanel(Image image, String string) {
        EwtComponent ewtComponent = new EwtComponent();
        ewtComponent.setBorderPainter((BorderPainter)new FixedBorderPainter(0, 2, 6, 6));
        ewtComponent.setLayout(new BorderLayout());
        ewtComponent.setBackground(Color.black);
        ewtComponent.setForeground(Color.black);
        EwtComponent ewtComponent2 = new EwtComponent();
        ewtComponent2.setBorderPainter((BorderPainter)new FixedBorderPainter(0, 0, 0, 0));
        ewtComponent2.setBackground(Color.black);
        ImageCanvas imageCanvas = new ImageCanvas(image);
        ewtComponent2.setLayout(new BorderLayout());
        ewtComponent2.add("Center", (Component)imageCanvas);
        EwtComponent ewtComponent3 = new EwtComponent();
        ewtComponent3.setBorderPainter((BorderPainter)new SeparatorBorderPainter(2, true, 0));
        ewtComponent3.setLayout(new BorderLayout());
        LWLabel lWLabel = new LWLabel(string, 1);
        lWLabel.setForeground(Color.white);
        lWLabel.setFont(new Font("Helvetica", 0, 18));
        ewtComponent3.add("Center", (Component)lWLabel);
        ewtComponent.add("North", (Component)ewtComponent2);
        ewtComponent.add("Center", (Component)ewtComponent3);
        FontMetrics fontMetrics = ((Component)((Object)this)).getFontMetrics(lWLabel.getFont());
        this.m_height += image.getHeight(this.m_adapter) + fontMetrics.getHeight() + 5;
        return ewtComponent;
    }

    private EwtComponent createImagePanel(Image image) {
        EwtComponent ewtComponent = new EwtComponent();
        ewtComponent.setBorderPainter((BorderPainter)new FixedBorderPainter(0, 0, 0, 0));
        ewtComponent.setBackground(Color.black);
        ImageCanvas imageCanvas = new ImageCanvas(image);
        imageCanvas.setScalingMode(1);
        this.m_height += image.getHeight(this.m_adapter);
        this.m_width = Math.max(image.getWidth(this.m_adapter), this.m_width);
        ewtComponent.setLayout((LayoutManager)new EqualColumnLayout());
        ewtComponent.add((Component)imageCanvas);
        return ewtComponent;
    }

    private EwtComponent createStatusPanel(String string, String string2) {
        EwtComponent ewtComponent = new EwtComponent();
        ewtComponent.setBorderPainter((BorderPainter)new SeparatorBorderPainter((Painter)new FixedBorderPainter(4, 8, 0, 8), 1, true, 0));
        ewtComponent.setLayout(new GridLayout(2, 1, 0, 0));
        ewtComponent.setBackground(UIManager.getColor((Object)LookAndFeel.DARK_LOOK));
        ewtComponent.setForeground(UIManager.getColor((Object)LookAndFeel.LIGHT_LOOK));
        this.m_textBar = new LWTextField(string);
        this.m_textBar.setAlignment(3);
        this.m_textBar.setBorderPainter((BorderPainter)new SeparatorBorderPainter(2, true, 0));
        this.m_textBar.setBackground(UIManager.getColor((Object)LookAndFeel.DARK_LOOK));
        this.m_textBar.setForeground(UIManager.getColor((Object)LookAndFeel.LIGHT_LOOK));
        this.m_textBar.setFont(new Font("Helvetica", 0, 11));
        FontMetrics fontMetrics = ((Component)((Object)this)).getFontMetrics(this.m_textBar.getFont());
        this.m_labelAction = new LWLabel(string, 3);
        this.m_labelAction.setForeground(Color.white);
        this.m_labelAction.setFont(new Font("Helvetica", 0, 12));
        fontMetrics = ((Component)((Object)this)).getFontMetrics(this.m_labelAction.getFont());
        this.m_height += fontMetrics.getHeight();
        this.m_width = Math.max(fontMetrics.stringWidth(this.m_labelAction.getText()), this.m_width);
        this.m_copyright = new LWLabel(string2, 3);
        this.m_copyright.setForeground(Color.lightGray);
        this.m_copyright.setFont(new Font("Helvetica", 0, 9));
        fontMetrics = ((Component)((Object)this)).getFontMetrics(this.m_copyright.getFont());
        this.m_height += fontMetrics.getHeight();
        this.m_width = Math.max(fontMetrics.stringWidth(this.m_copyright.getText()), this.m_width);
        ewtComponent.add((Component)this.m_textBar);
        ewtComponent.add((Component)this.m_copyright);
        return ewtComponent;
    }

    public void setActionText(String string) {
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
        this.m_textBar.setText(string);
        this.m_textBar.setEnabled(false);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        AdminSplashScreen.toFront();
        switch (mouseEvent.getID()) {
            case 500: {
                if (!((Component)((Object)this)).contains(mouseEvent.getX(), mouseEvent.getY())) break;
                this.dispose();
                return;
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        switch (keyEvent.getID()) {
            case 400: {
                AdminSplashScreen.toFront();
                return;
            }
        }
    }

    public void dispose() {
        super.dispose();
    }
}

