<%-----------------------------------------------------------
   Copyright  1999, Oracle Corporation. All rights reserved.
------------------------------------------------------------%>

<%-- declare request and page scoped beans here --%>

<jsp:useBean id = "includeCount" class = "oracle.jsp.jml.JmlNumber" scope = "request" />
<jsp:useBean id = "pageCount" class = "oracle.jsp.jml.JmlNumber" scope = "page" > 
	<jsp:setProperty name = "pageCount" property = "value" value = "<%= pageCount.getValue() + 1 %>" /> 
</jsp:useBean>

<%-- declare the event dispatchers --%>
<jsp:useBean id = "requestDispatcher" class = "oracle.jsp.sample.event.PageEventDispatcher" scope = "request" >
	<jsp:setProperty name = "requestDispatcher" property = "page" value = "<%= this %>" />
	<jsp:setProperty name = "requestDispatcher" property = "methodName" value = "request_OnEnd" />
</jsp:useBean>

<jsp:useBean id = "pageDispatcher" class = "oracle.jsp.sample.event.PageEventDispatcher" scope = "page" >
	<jsp:setProperty name = "pageDispatcher" property = "page" value = "<%= this %>" />
	<jsp:setProperty name = "pageDispatcher" property = "methodName" value = "page_OnEnd" />
</jsp:useBean>

<%! 
	// request_OnEnd Event Handler
	public void request_OnEnd(ServletContext application, HttpServletRequest request) {
		// acquire beans
		oracle.jsp.jml.JmlNumber includeCount = 
		    (oracle.jsp.jml.JmlNumber) request.getAttribute("includeCount");

		// now cleanup the bean
		if (includeCount != null) application.log("request_OnEnd: Include count = " + includeCount.getValue());	
	}

	// page_OnEnd Event Handler
	public void page_OnEnd(ServletContext application, PageContext page) {
		// acquire beans
		oracle.jsp.jml.JmlNumber pageCount = 
		    (oracle.jsp.jml.JmlNumber) page.getAttribute("pageCount");

		// now cleanup the bean -- uncomment code for real bean
		if (pageCount != null) application.log("page_OnEnd: Page count = " + pageCount.getValue());
	}  
%>

<%-- Page implementation goes here --%>

<jsp:setProperty name = "includeCount" property = "value" value = '<%= (request.getAttribute("javax.servlet.include.request_uri") != null) ? includeCount.getValue() + 1 : 0 %>' /> 

<h2> Hello World </h2>

Included: <%= request.getAttribute("javax.servlet.include.request_uri") %>   Count: <%= includeCount.getValue() %> <br>

<% if (includeCount.getValue() < 5) { %>
	<jsp:include page="scope.jsp" flush = "true" />
<% } %>
