REM
REM $Header: bdemobld.sql 1.1 94/10/19 09:22:46 gdudey Osd<desktop/netware> $ Copyr (c) 1994 Oracle
REM
REM   NAME
REM     bdemobld.sql - Build Oracle Data Browser Demonstration Tables
REM   DESCRIPTION
REM     This SQL script builds the Oracle Data Browser demonstration tables
REM     used in the Oracle Data Browser documentation.
REM   NOTES
REM     Do not run this script in the same account where you have run 
REM     demobld.sql.  Creating a separate account called BROWSER is 
REM     recommended.
REM     Constraints created with this script are not named so that the
REM     script will run under both ORACLE Version 6 and ORACLE7 untouched.
REM   MODIFIED   (MM/DD/YY)
REM    gpancha    02/23/94 -  Changed CHAR to VARCHAR2. 
REM    spao       09/02/93 -  Recreated missing INSERT statements for
REM                           SALARY_GRADE table.
REM    spao       08/10/93 -  Changed nonunique indexes to unique indexes and
REM                           corrected PRICE table to meet check constraints.
REM    spao       02/24/93 -  Changed date inputs to be language/territory
REM                           independent; changed number inputs to be
REM                           territory independent; separated constraint
REM                           definitions from table definitions; added
REM                           indexes for LOCATION, DEPARTMENT, JOB,
REM                           EMPLOYEE, and SALARY_GRADE tables.
REM    spao       05/02/91 -  Creation

REM Drop old datasources

DROP VIEW SALES;
DROP TABLE ITEM;
DROP TABLE SALES_ORDER;
DROP TABLE CUSTOMER;
DROP TABLE PRICE;
DROP TABLE PRODUCT;
DROP TABLE SALARY_GRADE;
DROP TABLE EMPLOYEE;
DROP TABLE JOB;
DROP TABLE DEPARTMENT;
DROP TABLE LOCATION;

REM Create new datasources

CREATE TABLE LOCATION (
        LOCATION_ID             NUMBER(3),
        REGIONAL_GROUP          VARCHAR2(20));

CREATE TABLE DEPARTMENT (
        DEPARTMENT_ID           NUMBER(2),
        NAME                    VARCHAR2(14),
        LOCATION_ID             NUMBER(3));

CREATE TABLE JOB (
        JOB_ID                  NUMBER(3),
        FUNCTION                VARCHAR2(30));

CREATE TABLE EMPLOYEE (
        EMPLOYEE_ID             NUMBER(4),
        LAST_NAME               VARCHAR2(15),
        FIRST_NAME              VARCHAR2(15),
        MIDDLE_INITIAL          VARCHAR2(1),
        JOB_ID                  NUMBER(3),
        MANAGER_ID              NUMBER(4),
        HIRE_DATE               DATE,
        SALARY                  NUMBER(7,2),
        COMMISSION              NUMBER(7,2),
        DEPARTMENT_ID           NUMBER(2));

CREATE TABLE SALARY_GRADE (
        GRADE_ID                NUMBER(3),
        LOWER_BOUND             NUMBER(7,2),
        UPPER_BOUND             NUMBER(7,2));

CREATE TABLE PRODUCT (
        PRODUCT_ID              NUMBER (6),
        DESCRIPTION             VARCHAR2 (30));
 
CREATE TABLE PRICE (
        PRODUCT_ID              NUMBER (6),
        LIST_PRICE              NUMBER (8,2),
        MIN_PRICE               NUMBER (8,2),
        START_DATE              DATE,
        END_DATE                DATE);

CREATE TABLE CUSTOMER (
        CUSTOMER_ID             NUMBER (6),
        NAME                    VARCHAR2 (45),
        ADDRESS                 VARCHAR2 (40),
        CITY                    VARCHAR2 (30),
        STATE                   VARCHAR2 (2),
        ZIP_CODE                VARCHAR2 (9),
        AREA_CODE               NUMBER (3),
        PHONE_NUMBER            NUMBER (7),
        SALESPERSON_ID          NUMBER (4),
        CREDIT_LIMIT            NUMBER (9,2),
        COMMENTS                LONG);

CREATE TABLE SALES_ORDER  (
        ORDER_ID                NUMBER (4),
        ORDER_DATE              DATE,
        CUSTOMER_ID             NUMBER (6),
        SHIP_DATE               DATE,
        TOTAL                   NUMBER (8,2));

CREATE TABLE ITEM  (
        ORDER_ID                NUMBER (4),
        ITEM_ID                 NUMBER (4),
        PRODUCT_ID              NUMBER (6),
        ACTUAL_PRICE            NUMBER (8,2),
        QUANTITY                NUMBER (8),
        TOTAL                   NUMBER (8,2));

CREATE VIEW SALES AS
SELECT SALESPERSON_ID, SALES_ORDER.CUSTOMER_ID, CUSTOMER.NAME CUSTOMER,
       PRODUCT.PRODUCT_ID, DESCRIPTION PRODUCT, SUM(ITEM.TOTAL) AMOUNT
FROM SALES_ORDER, ITEM, CUSTOMER, PRODUCT
WHERE SALES_ORDER.ORDER_ID = ITEM.ORDER_ID
AND SALES_ORDER.CUSTOMER_ID = CUSTOMER.CUSTOMER_ID
AND ITEM.PRODUCT_ID = PRODUCT.PRODUCT_ID
GROUP BY SALESPERSON_ID, SALES_ORDER.CUSTOMER_ID, CUSTOMER.NAME,
         PRODUCT.PRODUCT_ID, DESCRIPTION;

REM Grant SELECT privileges to PUBLIC on the datasources

GRANT SELECT ON LOCATION TO PUBLIC;
GRANT SELECT ON DEPARTMENT TO PUBLIC;
GRANT SELECT ON JOB TO PUBLIC;
GRANT SELECT ON EMPLOYEE TO PUBLIC;
GRANT SELECT ON SALARY_GRADE TO PUBLIC;
GRANT SELECT ON PRODUCT TO PUBLIC;
GRANT SELECT ON PRICE TO PUBLIC;
GRANT SELECT ON CUSTOMER TO PUBLIC;
GRANT SELECT ON SALES_ORDER TO PUBLIC;
GRANT SELECT ON ITEM TO PUBLIC;
GRANT SELECT ON SALES TO PUBLIC;
 
REM Comment the datasources and their columns

COMMENT ON TABLE EMPLOYEE IS 'General information on all corporate employees.';
COMMENT ON COLUMN EMPLOYEE.EMPLOYEE_ID IS 'Employee Number: Unique 4-digit identification number assigned to every employee.';
COMMENT ON COLUMN EMPLOYEE.LAST_NAME IS 'Last name of employee.  Stored in all caps.';
COMMENT ON COLUMN EMPLOYEE.FIRST_NAME IS 'First name of employee.  Stored in all caps.';
COMMENT ON COLUMN EMPLOYEE.MIDDLE_INITIAL IS 'Middle initial (one character only).  Stored in all caps.';
COMMENT ON COLUMN EMPLOYEE.JOB_ID IS 'Job identification number.  See JOB for descriptions.';
COMMENT ON COLUMN EMPLOYEE.MANAGER_ID IS 'Manager: The employee number of this employee''s manager.  If employee has no manager, value should be NULL.';
COMMENT ON COLUMN EMPLOYEE.HIRE_DATE IS 'Date the employee was HIRED, not necessarily the day the employee STARTED.';
COMMENT ON COLUMN EMPLOYEE.SALARY IS 'Monthly salary for the employee in U.S. dollars.  Salary grade information can be found in the table SALARY_GRADE.';
COMMENT ON COLUMN EMPLOYEE.COMMISSION IS 'Commission (in U.S. dollars) earned last month.  This field should be NULL for non-commissioned employees.';
COMMENT ON COLUMN EMPLOYEE.DEPARTMENT_ID IS 'Employee''s department number.  Further department information is available in the table DEPT.';

COMMENT ON TABLE JOB IS 'All valid job categories for personnel information.';
COMMENT ON COLUMN JOB.JOB_ID IS 'Unique 3-digit code for job function and title.';
COMMENT ON COLUMN JOB.FUNCTION IS 'Generic function class of job.';

COMMENT ON TABLE DEPARTMENT IS 'Department information for all U.S. operations.';
COMMENT ON COLUMN DEPARTMENT.DEPARTMENT_ID IS 'Department number: Unique 2-digit department number assigned to each department.';
COMMENT ON COLUMN DEPARTMENT.NAME IS 'Department name: Only the first 14 characters of a department name can be stored in the database.  Storing names in all caps is recommended but not required.';
COMMENT ON COLUMN DEPARTMENT.LOCATION_ID IS 'Department location: The code for where the department''s central office is located.  (LOCATION)';

COMMENT ON TABLE LOCATION IS 'Location information for all U.S. departments and warehouses.';
COMMENT ON COLUMN LOCATION.LOCATION_ID IS 'Central location corporate location code.';
COMMENT ON COLUMN LOCATION.REGIONAL_GROUP IS 'Metropolitan center closest to location.';

COMMENT ON TABLE SALARY_GRADE IS 'Salary grade levels.  Used to classify monthly salary information in U.S. dollars, as found in EMP.SAL.';
COMMENT ON COLUMN SALARY_GRADE.GRADE_ID IS 'Number used to grade salaries.  Higher salary grade numbers denote higher salaries.';
COMMENT ON COLUMN SALARY_GRADE.LOWER_BOUND IS 'The lowest monthly salary (rounded to the nearest U.S. dollar) that applies to a particular salary grade. (i.e. the condition ROUND(EMP.SAL) >= LOWER_BOUND must be met.)';
COMMENT ON COLUMN SALARY_GRADE.UPPER_BOUND IS 'The highest monthly salary (rounded to the nearest U.S. dollar) that applies to a particular salary grade. (i.e. the condition ROUND(EMP.SAL) <= UPPER_BOUND must be met.)';

COMMENT ON TABLE PRODUCT IS 'Products in catalog.  Pricing information can be found in table PRICE.';
COMMENT ON COLUMN PRODUCT.PRODUCT_ID IS 'Unique 6 digit number assigned to all products.  Number generated by sequence PRODUCT_ID.';
COMMENT ON COLUMN PRODUCT.DESCRIPTION IS 'Full product name (up to 30 characters).  Storing product names in all caps is recommended but not required.';

COMMENT ON TABLE PRICE IS 'Prices (both standard and minimum) of products.  Database tracks both effective dates and expiration dates for prices.';
COMMENT ON COLUMN PRICE.PRODUCT_ID IS 'Product number to which price applies.  Product name found in table PRICE.';
COMMENT ON COLUMN PRICE.LIST_PRICE IS 'Undiscounted price (in U.S. dollars).';
COMMENT ON COLUMN PRICE.MIN_PRICE IS 'Lowest price (in U.S. dollars) that can be offered.';
COMMENT ON COLUMN PRICE.START_DATE IS 'Date which standard and minimum prices go into effect.';
COMMENT ON COLUMN PRICE.END_DATE IS 'Date which standard and minimum price expire.  This value can be left NULL.';

COMMENT ON TABLE CUSTOMER IS 'Information on all U.S. customers and prospective customers.';
COMMENT ON COLUMN CUSTOMER.CUSTOMER_ID IS 'Unique 6 digit number assigned to all customers.  Number generated by the sequence CUSTOMER_ID.';
COMMENT ON COLUMN CUSTOMER.NAME IS 'Full store name of every customer (up to 45 characters).  Storing names in all caps is recommended but not required.';
COMMENT ON COLUMN CUSTOMER.ADDRESS IS 'Street address of customer.  CITY, STATE, and ZIP_CODE make up the rest of the address.';
COMMENT ON COLUMN CUSTOMER.CITY IS 'City name for address of customer.  Storing city names in all caps is recommended, but not required.';
COMMENT ON COLUMN CUSTOMER.STATE IS 'Two letter abbreviation for state name for address of customer.  Must be entered in all caps.';
COMMENT ON COLUMN CUSTOMER.ZIP_CODE IS 'Zip code of customer.  Supports both 5 and 9 digit zip codes.  Dashes should be omitted from 9 digit zips.';
COMMENT ON COLUMN CUSTOMER.AREA_CODE IS 'Area code of phone number for customer.';
COMMENT ON COLUMN CUSTOMER.PHONE_NUMBER IS 'Phone number of customer.  This field does not supports letters and spaces for mnemonics (7 numeric digits only).';
COMMENT ON COLUMN CUSTOMER.SALESPERSON_ID IS 'Employee number of sales representative handling customer''s account.  Employee information can be found in the EMPLOYEE table.';
COMMENT ON COLUMN CUSTOMER.CREDIT_LIMIT IS 'Credit limit of customer or prospective customer in U.S. dollars.';
COMMENT ON COLUMN CUSTOMER.COMMENTS IS 'Field can be used flexibly.  Suggestions for use include lists of action items or special considerations when dealing with the particular customer.';

COMMENT ON TABLE SALES_ORDER IS 'Sales order for a customer.  Items in the order can be found in the table ITEM.';
COMMENT ON COLUMN SALES_ORDER.ORDER_ID IS 'Unique 4 digit number assigned to all orders.  Number generated by sequence ORDER_ID.';
COMMENT ON COLUMN SALES_ORDER.ORDER_DATE IS 'Date sales order logged (not necessarily when order was fulfilled.)';
COMMENT ON COLUMN SALES_ORDER.CUSTOMER_ID IS 'Customer ordering the goods.  Further information can be found in the table CUSTOMER.';
COMMENT ON COLUMN SALES_ORDER.SHIP_DATE IS 'Date order fulfilled and invoice sent (not necessarily date payment received).';
COMMENT ON COLUMN SALES_ORDER.TOTAL IS 'Total of all items totals in the order.  (i.e. the value of TOTAL for order N should contain: SELECT SUM(TOTAL) FROM ITEM WHERE ORDER_ID=N)';

COMMENT ON TABLE ITEM IS 'Items listed in sales orders.  Product information can be found in table PRODUCT.  Sales order information can be found in table SALES_ORDER.';
COMMENT ON COLUMN ITEM.ORDER_ID IS 'Sales order in which this item appears.  Sales order information can be found in table SALES_ORDER.';
COMMENT ON COLUMN ITEM.ITEM_ID IS 'Number of item within the sales order.';
COMMENT ON COLUMN ITEM.PRODUCT_ID IS 'Number of product (described in PRODUCT) that pertains to the line item.';
COMMENT ON COLUMN ITEM.ACTUAL_PRICE IS 'Price to be paid by the customer in U.S. dollars.  The standard price is PRICE.STANDARD_PRICE, but in some instances, discounts are given to as low as PRICE.MINIMUM_PRICE.';
COMMENT ON COLUMN ITEM.QUANTITY IS 'The amount of product to be ordered in this line item.';
COMMENT ON COLUMN ITEM.TOTAL IS 'The total price (in U.S. dollars) of this line item.  TOTAL = ACTUAL_PRICE * QUANTITY.';

COMMENT ON TABLE SALES IS 'Summary view joining tables SALES_ORDER, ITEM, CUSTOMER, and PRODUCT.  Summarizes the item total grouped by sales representative, customer, and product.  Used by the SALES ORDERS application.';
COMMENT ON COLUMN SALES.SALESPERSON_ID IS 'Employee number of sales representative handling customer''s account.  Employee information can be found in the EMPLOYEE table. (Same as CUSTOMER.SALESPERSON_ID)';
COMMENT ON COLUMN SALES.CUSTOMER_ID IS 'Unique 6 digit number assigned to all customers.  Number generated by the sequence CUSTOMER_ID. (Same as CUSTOMER.CUSTOMER_ID)';
COMMENT ON COLUMN SALES.CUSTOMER IS 'Full store name of every customer (up to 45 characters).  Storing names in all caps is recommended but not required. (Same as CUSTOMER.NAME)';
COMMENT ON COLUMN SALES.PRODUCT_ID IS 'Unique 6 digit number assigned to all products.  Number generated by sequence PRODUCT_ID. (Same as PRODUCT.PRODUCT_ID)';
COMMENT ON COLUMN SALES.PRODUCT IS 'Full product name (up to 30 characters).  Storing product names in all caps is recommended but not required. (Same as PRODUCT.PRODUCT_NAME)';
COMMENT ON COLUMN SALES.AMOUNT IS 'Total sales in (U.S. dollars) of the product sold by the representative to the customer.';

REM Insert Data

INSERT INTO LOCATION VALUES (122, 'NEW YORK');
INSERT INTO LOCATION VALUES (124, 'DALLAS');
INSERT INTO LOCATION VALUES (123, 'CHICAGO');
INSERT INTO LOCATION VALUES (167, 'BOSTON');

INSERT INTO DEPARTMENT VALUES (10,'ACCOUNTING','122');
INSERT INTO DEPARTMENT VALUES (20,'RESEARCH','124');
INSERT INTO DEPARTMENT VALUES (30,'SALES','123');
INSERT INTO DEPARTMENT VALUES (40,'OPERATIONS','167');

INSERT INTO DEPARTMENT VALUES
  ( 12 , 'RESEARCH', '122');

INSERT INTO DEPARTMENT VALUES
  ( 13 , 'SALES', '122');

INSERT INTO DEPARTMENT VALUES
  ( 14 , 'OPERATIONS', '122');

INSERT INTO DEPARTMENT VALUES
  ( 23 , 'SALES', '124');

INSERT INTO DEPARTMENT VALUES
  ( 24 , 'OPERATIONS', '124');

INSERT INTO DEPARTMENT VALUES
  ( 34 , 'OPERATIONS', '123');

INSERT INTO DEPARTMENT VALUES
  ( 43 , 'SALES', '167');

INSERT INTO JOB VALUES (667, 'CLERK');
INSERT INTO JOB VALUES (668, 'STAFF');
INSERT INTO JOB VALUES (669, 'ANALYST');
INSERT INTO JOB VALUES (670, 'SALESPERSON');
INSERT INTO JOB VALUES (671, 'MANAGER');
INSERT INTO JOB VALUES (672, 'PRESIDENT');

INSERT INTO SALARY_GRADE VALUES (1,700,1200);
INSERT INTO SALARY_GRADE VALUES (2,1201,1400);
INSERT INTO SALARY_GRADE VALUES (3,1401,2000);
INSERT INTO SALARY_GRADE VALUES (4,2001,3000);
INSERT INTO SALARY_GRADE VALUES (5,3001,9999);

INSERT INTO EMPLOYEE VALUES
    (7369,'SMITH','JOHN','Q',667,7902,TO_DATE(2446052,'J'),800,NULL,20);
INSERT INTO EMPLOYEE VALUES
    (7499,'ALLEN','KEVIN','J',670,7698,TO_DATE(2446117,'J'),1600,300,30);
INSERT INTO EMPLOYEE VALUES
    (7505,'DOYLE','JEAN','K',671,7839,TO_DATE(2446160,'J'),2850,NULL,13);
INSERT INTO EMPLOYEE VALUES
    (7506,'DENNIS','LYNN','S',671,7839,TO_DATE(2446201,'J'),2750,NULL,23);
INSERT INTO EMPLOYEE VALUES
    (7507,'BAKER','LESLIE','D',671,7839,TO_DATE(2446227,'J'),2200,NULL,14);
INSERT INTO EMPLOYEE VALUES
    (7521,'WARD','CYNTHIA','D',670,7698,TO_DATE(2446119,'J'),1250,500,30);
INSERT INTO EMPLOYEE VALUES
    (7555,'PETERS','DANIEL','T',670,7505,TO_DATE(2446156,'J'),1250,300,13);
INSERT INTO EMPLOYEE VALUES
    (7557,'SHAW','KAREN','P',670,7505,TO_DATE(2446158,'J'),1250,1200,13);
INSERT INTO EMPLOYEE VALUES
    (7560,'DUNCAN','SARAH','S',670,7506,TO_DATE(2446217,'J'),1250,NULL,23);
INSERT INTO EMPLOYEE VALUES
    (7564,'LANGE','GREGORY','J',670,7506,TO_DATE(2446218,'J'),1250,300,23);
INSERT INTO EMPLOYEE VALUES
    (7566,'JONES','TERRY','M',671,7839,TO_DATE(2446158,'J'),2975,NULL,20);
INSERT INTO EMPLOYEE VALUES
    (7569,'ALBERTS','CHRIS','L',671,7839,TO_DATE(2446162,'J'),3000,NULL,12);
INSERT INTO EMPLOYEE VALUES
    (7600,'PORTER','RAYMOND','Y',670,7505,TO_DATE(2446171,'J'),1250,900,13);
INSERT INTO EMPLOYEE VALUES
    (7609,'LEWIS','RICHARD','M',668,7507,TO_DATE(2446172,'J'),1800,NULL,24);
INSERT INTO EMPLOYEE VALUES
    (7654,'MARTIN','KENNETH','J',670,7698,TO_DATE(2446337,'J'),1250,1400,30);
INSERT INTO EMPLOYEE VALUES
    (7676,'SOMMERS','DENISE','D',668,7507,TO_DATE(2446175,'J'),1850,NULL,34);
INSERT INTO EMPLOYEE VALUES
    (7698,'BLAKE','MARION','S',671,7839,TO_DATE(2446187,'J'),2850,NULL,30);
INSERT INTO EMPLOYEE VALUES
    (7782,'CLARK','CAROL','F',671,7839,TO_DATE(2446226,'J'),2450,NULL,10);
INSERT INTO EMPLOYEE VALUES
    (7788,'SCOTT','DONALD','T',669,7566,TO_DATE(2446774,'J'),3000,NULL,20);
INSERT INTO EMPLOYEE VALUES
    (7789,'WEST','LIVIA','N',670,7506,TO_DATE(2446160,'J'),1500,1000,23);
INSERT INTO EMPLOYEE VALUES
    (7799,'FISHER','MATTHEW','G',669,7569,TO_DATE(2446777,'J'),3000,NULL,12);
INSERT INTO EMPLOYEE VALUES
    (7820,'ROSS','PAUL','S',670,7505,TO_DATE(2446218,'J'),1300,800,43);
INSERT INTO EMPLOYEE VALUES
    (7839,'KING','FRANCIS','A',672,NULL,TO_DATE(2446387,'J'),5000,NULL,10);
INSERT INTO EMPLOYEE VALUES
    (7844,'TURNER','MARY','A',670,7698,TO_DATE(2446317,'J'),1500,0,30);
INSERT INTO EMPLOYEE VALUES
    (7876,'ADAMS','DIANE','G',667,7788,TO_DATE(2446808,'J'),1100,NULL,20);
INSERT INTO EMPLOYEE VALUES
    (7900,'JAMES','FRED','S',667,7698,TO_DATE(2446403,'J'),950,NULL,30);
INSERT INTO EMPLOYEE VALUES
    (7902,'FORD','JENNIFER','D',669,7566,TO_DATE(2446403,'J'),3000,NULL,20);
INSERT INTO EMPLOYEE VALUES
    (7916,'ROBERTS','GRACE','M',669,7569,TO_DATE(2446800,'J'),2875,NULL,12);
INSERT INTO EMPLOYEE VALUES
    (7919,'DOUGLAS','MICHAEL','A',667,7799,TO_DATE(2446800,'J'),800,NULL,12);
INSERT INTO EMPLOYEE VALUES
    (7934,'MILLER','BARBARA','M',667,7782,TO_DATE(2446454,'J'),1300,NULL,10);
INSERT INTO EMPLOYEE VALUES
    (7950,'JENSEN','ALICE','B',667,7505,TO_DATE(2446811,'J'),750,NULL,13);
INSERT INTO EMPLOYEE VALUES
    (7954,'MURRAY','JAMES','T',667,7506,TO_DATE(2446812,'J'),750,NULL,23);

INSERT INTO PRICE VALUES
   (100871,4.8,3.2,TO_DATE(2447528,'J'),TO_DATE(2447862,'J'));
INSERT INTO PRICE VALUES
   (100890,58,46.4,TO_DATE(2447528,'J'),NULL);
INSERT INTO PRICE VALUES
   (100890,54,40.5,TO_DATE(2447314,'J'),TO_DATE(2447527,'J'));
INSERT INTO PRICE VALUES
   (100860,35,28,TO_DATE(2448044,'J'),NULL);
INSERT INTO PRICE VALUES
   (100860,32,25.6,TO_DATE(2447893,'J'),TO_DATE(2448043,'J'));
INSERT INTO PRICE VALUES
   (100860,30,24,TO_DATE(2447528,'J'),TO_DATE(2447892,'J'));
INSERT INTO PRICE VALUES
   (100861,45,36,TO_DATE(2448044,'J'),NULL);
INSERT INTO PRICE VALUES
   (100861,42,33.6,TO_DATE(2447893,'J'),TO_DATE(2448043,'J'));
INSERT INTO PRICE VALUES
   (100861,39,31.2,TO_DATE(2447528,'J'),TO_DATE(2447892,'J'));
INSERT INTO PRICE VALUES
   (100870,2.8,2.4,TO_DATE(2447893,'J'),NULL);
INSERT INTO PRICE VALUES
   (100870,2.4,1.9,TO_DATE(2447528,'J'),TO_DATE(2447862,'J'));
INSERT INTO PRICE VALUES
   (100871,5.6,4.8,TO_DATE(2447893,'J'),NULL);
INSERT INTO PRICE VALUES
   (101860,24,18,TO_DATE(2447573,'J'),NULL);
INSERT INTO PRICE VALUES
   (101863,12.5,9.4,TO_DATE(2447573,'J'),NULL);
INSERT INTO PRICE VALUES
   (102130,3.4,2.8,TO_DATE(2447757,'J'),NULL);
INSERT INTO PRICE VALUES
   (200376,2.4,1.75,TO_DATE(2448211,'J'),NULL);
INSERT INTO PRICE VALUES
   (200380,4,3.2,TO_DATE(2448211,'J'),NULL);
INSERT INTO PRICE VALUES
   (103120,23.2,18.6,TO_DATE(2447528,'J'),TO_DATE(2447892,'J'));
INSERT INTO PRICE VALUES
   (103120,24,19.2,TO_DATE(2447893,'J'),TO_DATE(2448043,'J'));
INSERT INTO PRICE VALUES
   (103120,25,20,TO_DATE(2448044,'J'),NULL);
INSERT INTO PRICE VALUES
   (103121,27.8,22.3,TO_DATE(2447528,'J'),TO_DATE(2447892,'J'));
INSERT INTO PRICE VALUES
   (103121,28.8,23,TO_DATE(2447893,'J'),TO_DATE(2448043,'J'));
INSERT INTO PRICE VALUES
   (103121,30,24,TO_DATE(2448044,'J'),NULL);
INSERT INTO PRICE VALUES
   (103130,4,3.5,TO_DATE(2447528,'J'),TO_DATE(2447892,'J'));
INSERT INTO PRICE VALUES
   (103130,4.2,3.6,TO_DATE(2447893,'J'),NULL);
INSERT INTO PRICE VALUES
   (103131,4.2,3.6,TO_DATE(2447528,'J'),TO_DATE(2447892,'J'));
INSERT INTO PRICE VALUES
   (103131,4.5,3.9,TO_DATE(2447893,'J'),NULL);
INSERT INTO PRICE VALUES
   (103140,20,15,TO_DATE(2447573,'J'),NULL);
INSERT INTO PRICE VALUES
   (103141,20,15,TO_DATE(2447573,'J'),NULL);
INSERT INTO PRICE VALUES
   (102132,3.4,2.8,TO_DATE(2447757,'J'),NULL);
INSERT INTO PRICE VALUES
   (104350,40,32,TO_DATE(2447528,'J'),TO_DATE(2447892,'J'));
INSERT INTO PRICE VALUES
   (104350,42,33.6,TO_DATE(2447893,'J'),TO_DATE(2448043,'J'));
INSERT INTO PRICE VALUES
   (104350,44,35.3,TO_DATE(2448044,'J'),NULL);
INSERT INTO PRICE VALUES
   (104351,23.6,18.9,TO_DATE(2447528,'J'),TO_DATE(2447892,'J'));
INSERT INTO PRICE VALUES
   (104351,24.8,19.8,TO_DATE(2447893,'J'),TO_DATE(2448043,'J'));
INSERT INTO PRICE VALUES
   (104351,26,20.8,TO_DATE(2448044,'J'),NULL);
INSERT INTO PRICE VALUES
   (104352,50,35,TO_DATE(2447528,'J'),TO_DATE(2447892,'J'));
INSERT INTO PRICE VALUES
   (104352,54,37.8,TO_DATE(2447893,'J'),TO_DATE(2448043,'J'));
INSERT INTO PRICE VALUES
   (104352,58.3,40.8,TO_DATE(2448044,'J'),NULL);
INSERT INTO PRICE VALUES
   (104360,36,29.5,TO_DATE(2447528,'J'),TO_DATE(2447892,'J'));
INSERT INTO PRICE VALUES
   (104360,39,32,TO_DATE(2447893,'J'),NULL);
INSERT INTO PRICE VALUES
   (104361,47,33,TO_DATE(2447528,'J'),TO_DATE(2447892,'J'));
INSERT INTO PRICE VALUES
   (104361,50,35,TO_DATE(2447893,'J'),NULL);
INSERT INTO PRICE VALUES
   (104362,5,4,TO_DATE(2447573,'J'),NULL);
INSERT INTO PRICE VALUES
   (102134,3.4,2.8,TO_DATE(2447757,'J'),NULL);
INSERT INTO PRICE VALUES
   (105123,36.3,29,TO_DATE(2447528,'J'),TO_DATE(2447892,'J'));
INSERT INTO PRICE VALUES
   (105123,37.7,32,TO_DATE(2447893,'J'),TO_DATE(2448043,'J'));
INSERT INTO PRICE VALUES
   (105123,40,34,TO_DATE(2448044,'J'),NULL);
INSERT INTO PRICE VALUES
   (105124,10,7.6,TO_DATE(2447528,'J'),TO_DATE(2447892,'J'));
INSERT INTO PRICE VALUES
   (105124,12,9,TO_DATE(2447893,'J'),TO_DATE(2448043,'J'));
INSERT INTO PRICE VALUES
   (105124,15,10,TO_DATE(2448044,'J'),NULL);
INSERT INTO PRICE VALUES
   (105125,2,1.7,TO_DATE(2447528,'J'),TO_DATE(2447892,'J'));
INSERT INTO PRICE VALUES
   (105125,3,2.6,TO_DATE(2447893,'J'),NULL);
INSERT INTO PRICE VALUES
   (105126,5,4.3,TO_DATE(2447528,'J'),TO_DATE(2447892,'J'));
INSERT INTO PRICE VALUES
   (105126,6,5,TO_DATE(2447893,'J'),NULL);
INSERT INTO PRICE VALUES
   (105127,6,5,TO_DATE(2448211,'J'),NULL);
INSERT INTO PRICE VALUES
   (105128,10,8,TO_DATE(2448211,'J'),NULL);
INSERT INTO PRICE VALUES
   (102136,3.4,2.8,TO_DATE(2447757,'J'),NULL);

INSERT INTO PRODUCT VALUES ('100860', 'ACE TENNIS RACKET I');
INSERT INTO PRODUCT VALUES ('100861', 'ACE TENNIS RACKET II');
INSERT INTO PRODUCT VALUES ('100870', 'ACE TENNIS BALLS-3 PACK');
INSERT INTO PRODUCT VALUES ('100871', 'ACE TENNIS BALLS-6 PACK');
INSERT INTO PRODUCT VALUES ('100890', 'ACE TENNIS NET');
INSERT INTO PRODUCT VALUES ('101860', 'SP TENNIS RACKET');
INSERT INTO PRODUCT VALUES ('101863', 'SP JUNIOR RACKET');
INSERT INTO PRODUCT VALUES ('102130', 'RH: "GUIDE TO TENNIS"');
INSERT INTO PRODUCT VALUES ('200376', 'SB ENERGY BAR-6 PACK');
INSERT INTO PRODUCT VALUES ('200380', 'SB VITA SNACK-6 PACK');
INSERT INTO PRODUCT VALUES ( 103120 , 'WIFF SOFTBALL BAT I');
INSERT INTO PRODUCT VALUES ( 103121 , 'WIFF SOFTBALL BAT II');
INSERT INTO PRODUCT VALUES ( 103130 , 'WIFF SOFTBALL, SMALL');
INSERT INTO PRODUCT VALUES ( 103131 , 'WIFF SOFTBALL, LARGE');
INSERT INTO PRODUCT VALUES ( 103140 , 'WIFF SOFTBALL MITT (LH)');
INSERT INTO PRODUCT VALUES ( 103141 , 'WIFF SOFTBALL MITT (RH)');
INSERT INTO PRODUCT VALUES ( 102132 , 'RH: "GUIDE TO SOFTBALL"');
INSERT INTO PRODUCT VALUES ( 104350 , 'DUNK BASKETBALL INDOOR');
INSERT INTO PRODUCT VALUES ( 104351 , 'DUNK BASKETBALL OUTDOOR');
INSERT INTO PRODUCT VALUES ( 104352 , 'DUNK BASKETBALL PROFESSIONAL');
INSERT INTO PRODUCT VALUES ( 104360 , 'DUNK HOOP');
INSERT INTO PRODUCT VALUES ( 104361 , 'DUNK HOOP W/FIBERGLASS BOARD');
INSERT INTO PRODUCT VALUES ( 104362 , 'DUNK NETS - RAINBOW');
INSERT INTO PRODUCT VALUES ( 102134 , 'RH: "GUIDE TO BASKETBALL"');
INSERT INTO PRODUCT VALUES ( 105123 , 'YELLOW JERSEY BICYCLE HELMET');
INSERT INTO PRODUCT VALUES ( 105124 , 'YELLOW JERSEY BICYCLE GLOVES');
INSERT INTO PRODUCT VALUES ( 105125 , 'YELLOW JERSEY WATER BOTTLE');
INSERT INTO PRODUCT VALUES ( 105126 , 'YELLOW JERSEY BOTTLE CAGE');
INSERT INTO PRODUCT VALUES ( 105127 , 'YELLOW JERSEY FRAME PUMP');
INSERT INTO PRODUCT VALUES ( 105128 , 'YELLOW JERSEY SADDLE PACK');
INSERT INTO PRODUCT VALUES ( 102136 , 'RH: "GUIDE TO CYCLING"');

INSERT INTO SALES_ORDER VALUES
   (610,TO_DATE(2448264,'J'),101,TO_DATE(2448265,'J'),101.4);
INSERT INTO SALES_ORDER VALUES
   (611,TO_DATE(2448268,'J'),102,TO_DATE(2448268,'J'),45);
INSERT INTO SALES_ORDER VALUES
   (612,TO_DATE(2448272,'J'),104,TO_DATE(2448277,'J'),5860);
INSERT INTO SALES_ORDER VALUES
   (601,TO_DATE(2448013,'J'),106,TO_DATE(2448042,'J'),60.8);
INSERT INTO SALES_ORDER VALUES
   (602,TO_DATE(2448048,'J'),102,TO_DATE(2448063,'J'),56);
INSERT INTO SALES_ORDER VALUES
   (600,TO_DATE(2448013,'J'),103,TO_DATE(2448041,'J'),42);
INSERT INTO SALES_ORDER VALUES
   (604,TO_DATE(2448058,'J'),106,TO_DATE(2448073,'J'),642);
INSERT INTO SALES_ORDER VALUES
   (605,TO_DATE(2448087,'J'),106,TO_DATE(2448103,'J'),8374);
INSERT INTO SALES_ORDER VALUES
   (606,TO_DATE(2448087,'J'),100,TO_DATE(2448103,'J'),3.4);
INSERT INTO SALES_ORDER VALUES
   (609,TO_DATE(2448105,'J'),100,TO_DATE(2448119,'J'),102.5);
INSERT INTO SALES_ORDER VALUES
   (607,TO_DATE(2448091,'J'),104,TO_DATE(2448091,'J'),5.6);
INSERT INTO SALES_ORDER VALUES
   (608,TO_DATE(2448098,'J'),104,TO_DATE(2448098,'J'),35.2);
INSERT INTO SALES_ORDER VALUES
   (603,TO_DATE(2448048,'J'),102,TO_DATE(2448048,'J'),224);
INSERT INTO SALES_ORDER VALUES
   (620,TO_DATE(2448328,'J'),100,TO_DATE(2448328,'J'),4450);
INSERT INTO SALES_ORDER VALUES
   (613,TO_DATE(2448289,'J'),108,TO_DATE(2448289,'J'),6400);
INSERT INTO SALES_ORDER VALUES
   (614,TO_DATE(2448289,'J'),102,TO_DATE(2448293,'J'),23940);
INSERT INTO SALES_ORDER VALUES
   (616,TO_DATE(2448291,'J'),103,TO_DATE(2448298,'J'),764);
INSERT INTO SALES_ORDER VALUES
   (619,TO_DATE(2448310,'J'),104,TO_DATE(2448320,'J'),1260);
INSERT INTO SALES_ORDER VALUES
   (617,TO_DATE(2448293,'J'),105,TO_DATE(2448319,'J'),46370);
INSERT INTO SALES_ORDER VALUES
   (615,TO_DATE(2448289,'J'),107,TO_DATE(2448294,'J'),710);
INSERT INTO SALES_ORDER VALUES
   (618,TO_DATE(2448303,'J'),102,TO_DATE(2448322,'J'),3083);
INSERT INTO SALES_ORDER VALUES
   (621,TO_DATE(2448331,'J'),100,TO_DATE(2448348,'J'),730);
INSERT INTO SALES_ORDER VALUES
   (509,TO_DATE(2447682,'J'),226,TO_DATE(2447688,'J'),1174);
INSERT INTO SALES_ORDER VALUES
   (523,TO_DATE(2447936,'J'),226,TO_DATE(2447936,'J'),1165);
INSERT INTO SALES_ORDER VALUES
   (549,TO_DATE(2448253,'J'),226,TO_DATE(2448271,'J'),1620);
INSERT INTO SALES_ORDER VALUES
   (507,TO_DATE(2447673,'J'),228,TO_DATE(2447674,'J'),886);
INSERT INTO SALES_ORDER VALUES
   (516,TO_DATE(2447800,'J'),228,TO_DATE(2447803,'J'),1815);
INSERT INTO SALES_ORDER VALUES
   (553,TO_DATE(2448290,'J'),228,TO_DATE(2448301,'J'),4400);
INSERT INTO SALES_ORDER VALUES
   (526,TO_DATE(2447955,'J'),221,TO_DATE(2447958,'J'),7700);
INSERT INTO SALES_ORDER VALUES
   (543,TO_DATE(2448139,'J'),221,TO_DATE(2448142,'J'),8400);
INSERT INTO SALES_ORDER VALUES
   (555,TO_DATE(2448320,'J'),221,TO_DATE(2448323,'J'),8540);
INSERT INTO SALES_ORDER VALUES
   (559,TO_DATE(2448212,'J'),222,TO_DATE(2448370,'J'),387.2);
INSERT INTO SALES_ORDER VALUES
   (528,TO_DATE(2447975,'J'),224,TO_DATE(2447975,'J'),3770);
INSERT INTO SALES_ORDER VALUES
   (531,TO_DATE(2447982,'J'),224,TO_DATE(2447984,'J'),1400);
INSERT INTO SALES_ORDER VALUES
   (558,TO_DATE(2448347,'J'),224,TO_DATE(2448349,'J'),1700);
INSERT INTO SALES_ORDER VALUES
   (525,TO_DATE(2447951,'J'),225,TO_DATE(2447954,'J'),377);
INSERT INTO SALES_ORDER VALUES
   (552,TO_DATE(2448290,'J'),223,TO_DATE(2448295,'J'),555.8);
INSERT INTO SALES_ORDER VALUES
   (556,TO_DATE(2448326,'J'),223,TO_DATE(2448328,'J'),85);
INSERT INTO SALES_ORDER VALUES
   (560,TO_DATE(2448372,'J'),223,TO_DATE(2448372,'J'),72);
INSERT INTO SALES_ORDER VALUES
   (565,TO_DATE(2448409,'J'),227,TO_DATE(2448411,'J'),4900);
INSERT INTO SALES_ORDER VALUES
   (574,TO_DATE(2448540,'J'),201,TO_DATE(2448542,'J'),1685);
INSERT INTO SALES_ORDER VALUES
   (576,TO_DATE(2448543,'J'),201,TO_DATE(2448548,'J'),2058.9);
INSERT INTO SALES_ORDER VALUES
   (503,TO_DATE(2447611,'J'),201,TO_DATE(2447623,'J'),1876);
INSERT INTO SALES_ORDER VALUES
   (518,TO_DATE(2447820,'J'),201,TO_DATE(2447836,'J'),2932.5);
INSERT INTO SALES_ORDER VALUES
   (517,TO_DATE(2447823,'J'),201,TO_DATE(2447838,'J'),784);
INSERT INTO SALES_ORDER VALUES
   (544,TO_DATE(2448146,'J'),202,TO_DATE(2448150,'J'),2358);
INSERT INTO SALES_ORDER VALUES
   (524,TO_DATE(2447945,'J'),202,TO_DATE(2447955,'J'),1979);
INSERT INTO SALES_ORDER VALUES
   (502,TO_DATE(2447568,'J'),202,TO_DATE(2447581,'J'),500);
INSERT INTO SALES_ORDER VALUES
   (539,TO_DATE(2448069,'J'),202,TO_DATE(2448076,'J'),1300);
INSERT INTO SALES_ORDER VALUES
   (511,TO_DATE(2447756,'J'),202,TO_DATE(2447760,'J'),647);
INSERT INTO SALES_ORDER VALUES
   (512,TO_DATE(2447767,'J'),203,TO_DATE(2447783,'J'),428);
INSERT INTO SALES_ORDER VALUES
   (562,TO_DATE(2448381,'J'),203,TO_DATE(2448396,'J'),2044.5);
INSERT INTO SALES_ORDER VALUES
   (529,TO_DATE(2447984,'J'),203,TO_DATE(2447987,'J'),1264.7);
INSERT INTO SALES_ORDER VALUES
   (563,TO_DATE(2448402,'J'),204,TO_DATE(2448403,'J'),889);
INSERT INTO SALES_ORDER VALUES
   (568,TO_DATE(2448451,'J'),204,TO_DATE(2448459,'J'),1217.4);
INSERT INTO SALES_ORDER VALUES
   (504,TO_DATE(2447628,'J'),204,TO_DATE(2447629,'J'),1434.7);
INSERT INTO SALES_ORDER VALUES
   (538,TO_DATE(2448066,'J'),204,TO_DATE(2448069,'J'),741);
INSERT INTO SALES_ORDER VALUES
   (535,TO_DATE(2448040,'J'),204,TO_DATE(2448052,'J'),810);
INSERT INTO SALES_ORDER VALUES
   (578,TO_DATE(2448580,'J'),204,TO_DATE(2448595,'J'),2275.6);
INSERT INTO SALES_ORDER VALUES
   (534,TO_DATE(2448023,'J'),206,TO_DATE(2448027,'J'),420);
INSERT INTO SALES_ORDER VALUES
   (536,TO_DATE(2448033,'J'),206,TO_DATE(2448049,'J'),2135.6);
INSERT INTO SALES_ORDER VALUES
   (572,TO_DATE(2448488,'J'),206,TO_DATE(2448493,'J'),1200.5);
INSERT INTO SALES_ORDER VALUES
   (514,TO_DATE(2447775,'J'),207,TO_DATE(2447786,'J'),1140);
INSERT INTO SALES_ORDER VALUES
   (521,TO_DATE(2447851,'J'),207,TO_DATE(2447854,'J'),896.9);
INSERT INTO SALES_ORDER VALUES
   (551,TO_DATE(2448279,'J'),208,TO_DATE(2448294,'J'),1142);
INSERT INTO SALES_ORDER VALUES
   (513,TO_DATE(2447776,'J'),208,TO_DATE(2447784,'J'),1497);
INSERT INTO SALES_ORDER VALUES
   (508,TO_DATE(2447673,'J'),208,TO_DATE(2447686,'J'),1080);
INSERT INTO SALES_ORDER VALUES
   (515,TO_DATE(2447789,'J'),208,TO_DATE(2447796,'J'),1428.5);
INSERT INTO SALES_ORDER VALUES
   (542,TO_DATE(2448115,'J'),208,TO_DATE(2448127,'J'),2409);
INSERT INTO SALES_ORDER VALUES
   (573,TO_DATE(2448540,'J'),201,TO_DATE(2448542,'J'),1627);
INSERT INTO SALES_ORDER VALUES
   (566,TO_DATE(2448417,'J'),201,TO_DATE(2448420,'J'),3389.2);
INSERT INTO SALES_ORDER VALUES
   (520,TO_DATE(2447847,'J'),201,TO_DATE(2447850,'J'),341.6);
INSERT INTO SALES_ORDER VALUES
   (519,TO_DATE(2447820,'J'),201,TO_DATE(2447836,'J'),955);
INSERT INTO SALES_ORDER VALUES
   (575,TO_DATE(2448534,'J'),201,TO_DATE(2448547,'J'),684);
INSERT INTO SALES_ORDER VALUES
   (547,TO_DATE(2448181,'J'),202,TO_DATE(2448192,'J'),984.4);
INSERT INTO SALES_ORDER VALUES
   (540,TO_DATE(2448088,'J'),202,TO_DATE(2448090,'J'),861.2);
INSERT INTO SALES_ORDER VALUES
   (567,TO_DATE(2448443,'J'),202,TO_DATE(2448445,'J'),200);
INSERT INTO SALES_ORDER VALUES
   (570,TO_DATE(2448455,'J'),202,TO_DATE(2448462,'J'),663.6);
INSERT INTO SALES_ORDER VALUES
   (571,TO_DATE(2448471,'J'),202,TO_DATE(2448481,'J'),1095.6);
INSERT INTO SALES_ORDER VALUES
   (541,TO_DATE(2448112,'J'),203,TO_DATE(2448122,'J'),400);
INSERT INTO SALES_ORDER VALUES
   (532,TO_DATE(2447990,'J'),203,TO_DATE(2448003,'J'),1295.4);
INSERT INTO SALES_ORDER VALUES
   (527,TO_DATE(2447950,'J'),204,TO_DATE(2447965,'J'),3054.4);
INSERT INTO SALES_ORDER VALUES
   (501,TO_DATE(2447533,'J'),204,TO_DATE(2447538,'J'),216);
INSERT INTO SALES_ORDER VALUES
   (564,TO_DATE(2448402,'J'),204,TO_DATE(2448403,'J'),898.8);
INSERT INTO SALES_ORDER VALUES
   (537,TO_DATE(2448057,'J'),204,TO_DATE(2448069,'J'),672.9);
INSERT INTO SALES_ORDER VALUES
   (522,TO_DATE(2447899,'J'),204,TO_DATE(2447902,'J'),2578.8);
INSERT INTO SALES_ORDER VALUES
   (554,TO_DATE(2448306,'J'),204,TO_DATE(2448310,'J'),282.8);
INSERT INTO SALES_ORDER VALUES
   (569,TO_DATE(2448454,'J'),205,TO_DATE(2448461,'J'),2073);
INSERT INTO SALES_ORDER VALUES
   (550,TO_DATE(2448284,'J'),205,TO_DATE(2448295,'J'),2356);
INSERT INTO SALES_ORDER VALUES
   (548,TO_DATE(2448222,'J'),205,TO_DATE(2448238,'J'),666.9);
INSERT INTO SALES_ORDER VALUES
   (505,TO_DATE(2447624,'J'),206,TO_DATE(2447639,'J'),650);
INSERT INTO SALES_ORDER VALUES
   (577,TO_DATE(2448536,'J'),206,TO_DATE(2448550,'J'),1265.75);
INSERT INTO SALES_ORDER VALUES
   (533,TO_DATE(2448010,'J'),206,TO_DATE(2448014,'J'),1122.1);
INSERT INTO SALES_ORDER VALUES
   (561,TO_DATE(2448367,'J'),207,TO_DATE(2448384,'J'),2558.3);
INSERT INTO SALES_ORDER VALUES
   (506,TO_DATE(2447644,'J'),208,TO_DATE(2447657,'J'),2600.4);
INSERT INTO SALES_ORDER VALUES
   (530,TO_DATE(2447985,'J'),208,TO_DATE(2447989,'J'),3026.5);
INSERT INTO SALES_ORDER VALUES
   (545,TO_DATE(2448171,'J'),208,TO_DATE(2448178,'J'),475);
INSERT INTO SALES_ORDER VALUES
   (557,TO_DATE(2448324,'J'),208,TO_DATE(2448328,'J'),2461.8);
INSERT INTO SALES_ORDER VALUES
   (546,TO_DATE(2448182,'J'),208,TO_DATE(2448188,'J'),3663);
INSERT INTO SALES_ORDER VALUES
   (510,TO_DATE(2447726,'J'),208,TO_DATE(2447729,'J'),1336.6);

INSERT INTO ITEM VALUES (600,1,100861,42,1,42);
INSERT INTO ITEM VALUES (610,3,100890,58,1,58);
INSERT INTO ITEM VALUES (611,1,100861,45,1,45);
INSERT INTO ITEM VALUES (612,1,100860,30,100,3000);
INSERT INTO ITEM VALUES (601,1,200376,2.4,12,28.8);
INSERT INTO ITEM VALUES (601,2,100860,32,1,32);
INSERT INTO ITEM VALUES (602,1,100870,2.8,20,56);
INSERT INTO ITEM VALUES (604,1,100890,58,3,174);
INSERT INTO ITEM VALUES (604,2,100861,42,2,84);
INSERT INTO ITEM VALUES (604,3,100860,32,12,384);
INSERT INTO ITEM VALUES (603,1,100860,32,7,224);
INSERT INTO ITEM VALUES (610,1,100860,35,1,35);
INSERT INTO ITEM VALUES (610,2,100870,2.8,3,8.4);
INSERT INTO ITEM VALUES (613,4,200376,2.2,200,440);
INSERT INTO ITEM VALUES (614,1,100860,35,444,15540);
INSERT INTO ITEM VALUES (614,2,100870,2.8,1000,2800);
INSERT INTO ITEM VALUES (612,2,100861,40.5,20,810);
INSERT INTO ITEM VALUES (612,3,101863,10,150,1500);
INSERT INTO ITEM VALUES (620,1,100860,35,10,350);
INSERT INTO ITEM VALUES (620,2,200376,2.4,1000,2400);
INSERT INTO ITEM VALUES (620,3,102130,3.4,500,1700);
INSERT INTO ITEM VALUES (613,1,100871,5.6,100,560);
INSERT INTO ITEM VALUES (613,2,101860,24,200,4800);
INSERT INTO ITEM VALUES (613,3,200380,4,150,600);
INSERT INTO ITEM VALUES (619,3,102130,3.4,100,340);
INSERT INTO ITEM VALUES (617,1,100860,35,50,1750);
INSERT INTO ITEM VALUES (617,2,100861,45,100,4500);
INSERT INTO ITEM VALUES (614,3,100871,5.6,1000,5600);
INSERT INTO ITEM VALUES (616,1,100861,45,10,450);
INSERT INTO ITEM VALUES (616,2,100870,2.8,50,140);
INSERT INTO ITEM VALUES (616,3,100890,58,2,116);
INSERT INTO ITEM VALUES (616,4,102130,3.4,10,34);
INSERT INTO ITEM VALUES (616,5,200376,2.4,10,24);
INSERT INTO ITEM VALUES (619,1,200380,4,100,400);
INSERT INTO ITEM VALUES (619,2,200376,2.4,100,240);
INSERT INTO ITEM VALUES (615,1,100861,45,4,180);
INSERT INTO ITEM VALUES (607,1,100871,5.6,1,5.6);
INSERT INTO ITEM VALUES (615,2,100870,2.8,100,280);
INSERT INTO ITEM VALUES (617,3,100870,2.8,500,1400);
INSERT INTO ITEM VALUES (617,4,100871,5.6,500,2800);
INSERT INTO ITEM VALUES (617,5,100890,58,500,29000);
INSERT INTO ITEM VALUES (617,6,101860,24,100,2400);
INSERT INTO ITEM VALUES (617,7,101863,12.5,200,2500);
INSERT INTO ITEM VALUES (617,8,102130,3.4,100,340);
INSERT INTO ITEM VALUES (617,9,200376,2.4,200,480);
INSERT INTO ITEM VALUES (617,10,200380,4,300,1200);
INSERT INTO ITEM VALUES (609,2,100870,2.5,5,12.5);
INSERT INTO ITEM VALUES (609,3,100890,50,1,50);
INSERT INTO ITEM VALUES (618,1,100860,35,23,805);
INSERT INTO ITEM VALUES (618,2,100861,45,50,2250);
INSERT INTO ITEM VALUES (618,3,100870,2.8,10,28);
INSERT INTO ITEM VALUES (621,1,100861,45,10,450);
INSERT INTO ITEM VALUES (621,2,100870,2.8,100,280);
INSERT INTO ITEM VALUES (615,3,100871,5,50,250);
INSERT INTO ITEM VALUES (608,1,101860,24,1,24);
INSERT INTO ITEM VALUES (608,2,100871,5.6,2,11.2);
INSERT INTO ITEM VALUES (609,1,100861,40,1,40);
INSERT INTO ITEM VALUES (606,1,102130,3.4,1,3.4);
INSERT INTO ITEM VALUES (605,1,100861,45,100,4500);
INSERT INTO ITEM VALUES (605,2,100870,2.8,500,1400);
INSERT INTO ITEM VALUES (605,3,100890,58,5,290);
INSERT INTO ITEM VALUES (605,4,101860,24,50,1200);
INSERT INTO ITEM VALUES (605,5,101863,9.5,100,950);
INSERT INTO ITEM VALUES (605,6,102130,3.4,10,34);
INSERT INTO ITEM VALUES (612,4,100871,5.5,100,550);
INSERT INTO ITEM VALUES (619,4,100871,5.6,50,280);
INSERT INTO ITEM VALUES (509,1,105123,35,30,1050);
INSERT INTO ITEM VALUES (509,2,105124,9,10,90);
INSERT INTO ITEM VALUES (509,3,102136,3.4,10,34);
INSERT INTO ITEM VALUES (523,1,102136,3.4,10,34);
INSERT INTO ITEM VALUES (523,2,105123,37.7,30,1131);
INSERT INTO ITEM VALUES (549,1,105123,38,5,190);
INSERT INTO ITEM VALUES (549,2,105127,6,30,180);
INSERT INTO ITEM VALUES (549,3,105125,3,200,600);
INSERT INTO ITEM VALUES (549,4,105124,13,50,650);
INSERT INTO ITEM VALUES (507,1,105123,35.3,20,706);
INSERT INTO ITEM VALUES (507,2,105124,9,20,180);
INSERT INTO ITEM VALUES (516,1,105124,9,60,540);
INSERT INTO ITEM VALUES (516,2,102136,3.2,250,800);
INSERT INTO ITEM VALUES (516,3,105125,1.9,250,475);
INSERT INTO ITEM VALUES (553,1,105127,6,500,3000);
INSERT INTO ITEM VALUES (553,2,200376,1.75,800,1400);
INSERT INTO ITEM VALUES (526,1,105123,32,100,3200);
INSERT INTO ITEM VALUES (526,2,105124,9,500,4500);
INSERT INTO ITEM VALUES (543,1,105123,34,100,3400);
INSERT INTO ITEM VALUES (543,2,105124,10,500,5000);
INSERT INTO ITEM VALUES (555,1,105123,34,100,3400);
INSERT INTO ITEM VALUES (555,2,105124,10,500,5000);
INSERT INTO ITEM VALUES (555,3,102136,2.8,50,140);
INSERT INTO ITEM VALUES (559,1,105123,40,5,200);
INSERT INTO ITEM VALUES (559,2,105124,15,5,75);
INSERT INTO ITEM VALUES (559,3,105127,6,5,30);
INSERT INTO ITEM VALUES (559,4,102136,3.4,3,10.2);
INSERT INTO ITEM VALUES (559,5,200376,2.4,30,72);
INSERT INTO ITEM VALUES (528,1,105123,37.7,100,3770);
INSERT INTO ITEM VALUES (531,1,105124,11,100,1100);
INSERT INTO ITEM VALUES (531,2,102136,3,100,300);
INSERT INTO ITEM VALUES (558,1,105124,14,100,1400);
INSERT INTO ITEM VALUES (558,2,102136,3,100,300);
INSERT INTO ITEM VALUES (525,1,105123,37.7,10,377);
INSERT INTO ITEM VALUES (552,1,105123,40,10,400);
INSERT INTO ITEM VALUES (552,2,105124,15,10,150);
INSERT INTO ITEM VALUES (552,3,102136,3.4,1,3.4);
INSERT INTO ITEM VALUES (552,4,200376,2.4,1,2.4);
INSERT INTO ITEM VALUES (556,1,102136,3.4,25,85);
INSERT INTO ITEM VALUES (560,1,200376,2.4,30,72);
INSERT INTO ITEM VALUES (565,1,105123,37,100,3700);
INSERT INTO ITEM VALUES (565,2,105124,12,100,1200);
INSERT INTO ITEM VALUES (574,1,104350,41.8,25,1045);
INSERT INTO ITEM VALUES (574,2,200380,3.2,200,640);
INSERT INTO ITEM VALUES (576,1,104350,44,10,440);
INSERT INTO ITEM VALUES (576,2,104351,26,10,260);
INSERT INTO ITEM VALUES (576,3,104362,4.25,170,722.5);
INSERT INTO ITEM VALUES (576,4,200376,2.16,90,194.4);
INSERT INTO ITEM VALUES (576,5,200380,3.4,130,442);
INSERT INTO ITEM VALUES (503,1,104350,38,30,1140);
INSERT INTO ITEM VALUES (503,2,104351,23.6,10,236);
INSERT INTO ITEM VALUES (503,3,104352,50,10,500);
INSERT INTO ITEM VALUES (518,1,104350,38,25,950);
INSERT INTO ITEM VALUES (518,2,104351,23.6,20,472);
INSERT INTO ITEM VALUES (518,3,104360,36,20,720);
INSERT INTO ITEM VALUES (518,4,104362,4.25,170,722.5);
INSERT INTO ITEM VALUES (518,5,102134,3.4,20,68);
INSERT INTO ITEM VALUES (517,1,104352,50,15,750);
INSERT INTO ITEM VALUES (517,2,102134,3.4,10,34);
INSERT INTO ITEM VALUES (544,1,104350,44,15,660);
INSERT INTO ITEM VALUES (544,2,104351,26,15,390);
INSERT INTO ITEM VALUES (544,3,104352,58.3,10,583);
INSERT INTO ITEM VALUES (544,4,104361,50,10,500);
INSERT INTO ITEM VALUES (544,5,104362,4.5,50,225);
INSERT INTO ITEM VALUES (524,1,104350,42,10,420);
INSERT INTO ITEM VALUES (524,2,104351,23.56,35,824.6);
INSERT INTO ITEM VALUES (524,3,104362,4.25,150,637.5);
INSERT INTO ITEM VALUES (524,4,102134,3.23,30,96.9);
INSERT INTO ITEM VALUES (502,1,104352,50,10,500);
INSERT INTO ITEM VALUES (539,1,104351,26,20,520);
INSERT INTO ITEM VALUES (539,2,104360,39,20,780);
INSERT INTO ITEM VALUES (511,1,104351,23.6,15,354);
INSERT INTO ITEM VALUES (511,2,104362,4.5,50,225);
INSERT INTO ITEM VALUES (511,3,102134,3.4,20,68);
INSERT INTO ITEM VALUES (512,1,104360,36,10,360);
INSERT INTO ITEM VALUES (512,2,102134,3.4,20,68);
INSERT INTO ITEM VALUES (562,1,104351,24.7,25,617.5);
INSERT INTO ITEM VALUES (562,2,104352,58.3,15,874.5);
INSERT INTO ITEM VALUES (562,3,104362,4.25,130,552.5);
INSERT INTO ITEM VALUES (529,1,104350,39.89,30,1196.7);
INSERT INTO ITEM VALUES (529,2,102134,3.4,20,68);
INSERT INTO ITEM VALUES (563,1,104352,58.3,10,583);
INSERT INTO ITEM VALUES (563,2,200376,2.04,150,306);
INSERT INTO ITEM VALUES (568,1,104351,24.7,30,741);
INSERT INTO ITEM VALUES (568,2,200376,2.04,110,224.4);
INSERT INTO ITEM VALUES (568,3,200380,3.6,70,252);
INSERT INTO ITEM VALUES (504,1,104350,40,10,400);
INSERT INTO ITEM VALUES (504,2,104351,22.42,35,784.7);
INSERT INTO ITEM VALUES (504,3,104352,50,5,250);
INSERT INTO ITEM VALUES (538,1,104351,24.7,30,741);
INSERT INTO ITEM VALUES (535,1,104352,54,15,810);
INSERT INTO ITEM VALUES (578,1,104350,41.8,40,1672);
INSERT INTO ITEM VALUES (578,2,200376,2.04,190,387.6);
INSERT INTO ITEM VALUES (578,3,200380,3.6,60,216);
INSERT INTO ITEM VALUES (534,1,104350,42,10,420);
INSERT INTO ITEM VALUES (536,1,104350,39.89,40,1595.6);
INSERT INTO ITEM VALUES (536,2,104352,54,10,540);
INSERT INTO ITEM VALUES (572,1,104351,24.7,25,617.5);
INSERT INTO ITEM VALUES (572,2,104352,58.3,10,583);
INSERT INTO ITEM VALUES (514,1,104350,38,30,1140);
INSERT INTO ITEM VALUES (521,1,104350,40,20,800);
INSERT INTO ITEM VALUES (521,2,102134,3.23,30,96.9);
INSERT INTO ITEM VALUES (551,1,104350,44,10,440);
INSERT INTO ITEM VALUES (551,2,104361,50,5,250);
INSERT INTO ITEM VALUES (551,3,102134,3.4,20,68);
INSERT INTO ITEM VALUES (551,4,200376,1.92,200,384);
INSERT INTO ITEM VALUES (513,1,104350,40,15,600);
INSERT INTO ITEM VALUES (513,2,104351,23.6,20,472);
INSERT INTO ITEM VALUES (513,3,104362,4.25,100,425);
INSERT INTO ITEM VALUES (508,1,104360,36,20,720);
INSERT INTO ITEM VALUES (508,2,104362,4.5,80,360);
INSERT INTO ITEM VALUES (515,1,104350,40,20,800);
INSERT INTO ITEM VALUES (515,2,104351,22.42,25,560.5);
INSERT INTO ITEM VALUES (515,3,102134,3.4,20,68);
INSERT INTO ITEM VALUES (542,1,104350,41.8,25,1045);
INSERT INTO ITEM VALUES (542,2,104360,39,20,780);
INSERT INTO ITEM VALUES (542,3,104361,50,11,550);
INSERT INTO ITEM VALUES (542,4,102134,3.4,10,34);
INSERT INTO ITEM VALUES (573,1,103120,22.5,50,1125);
INSERT INTO ITEM VALUES (573,2,103131,4.04,50,202);
INSERT INTO ITEM VALUES (573,3,103141,20,15,300);
INSERT INTO ITEM VALUES (566,1,103120,23.75,40,950);
INSERT INTO ITEM VALUES (566,2,103121,27,50,1350);
INSERT INTO ITEM VALUES (566,3,103130,3.77,60,226.2);
INSERT INTO ITEM VALUES (566,4,103131,3.9,170,663);
INSERT INTO ITEM VALUES (566,5,103141,20,10,200);
INSERT INTO ITEM VALUES (520,1,103130,4,10,40);
INSERT INTO ITEM VALUES (520,2,103131,3.77,80,301.6);
INSERT INTO ITEM VALUES (519,1,103130,3.5,110,385);
INSERT INTO ITEM VALUES (519,2,103140,19,30,570);
INSERT INTO ITEM VALUES (575,1,103140,19,30,570);
INSERT INTO ITEM VALUES (575,2,200380,3.8,30,114);
INSERT INTO ITEM VALUES (547,1,103130,3.77,80,301.6);
INSERT INTO ITEM VALUES (547,2,103131,4.04,70,282.8);
INSERT INTO ITEM VALUES (547,3,103140,20,15,300);
INSERT INTO ITEM VALUES (547,4,103141,20,5,100);
INSERT INTO ITEM VALUES (540,1,103130,3.98,40,159.2);
INSERT INTO ITEM VALUES (540,2,103131,3.9,180,702);
INSERT INTO ITEM VALUES (567,1,103140,20,10,200);
INSERT INTO ITEM VALUES (570,1,103131,4.04,90,363.6);
INSERT INTO ITEM VALUES (570,2,103140,20,15,300);
INSERT INTO ITEM VALUES (571,1,103131,4.04,70,282.8);
INSERT INTO ITEM VALUES (571,2,103140,19,25,475);
INSERT INTO ITEM VALUES (571,3,102132,3.4,15,51);
INSERT INTO ITEM VALUES (571,4,200376,2.16,80,172.8);
INSERT INTO ITEM VALUES (571,5,200380,3.8,30,114);
INSERT INTO ITEM VALUES (541,1,103140,20,10,200);
INSERT INTO ITEM VALUES (541,2,103141,20,10,200);
INSERT INTO ITEM VALUES (532,1,103120,21.59,60,1295.4);
INSERT INTO ITEM VALUES (527,1,103120,21.59,60,1295.4);
INSERT INTO ITEM VALUES (527,2,103121,27.35,40,1094);
INSERT INTO ITEM VALUES (527,3,103140,19,35,665);
INSERT INTO ITEM VALUES (501,1,103130,3.6,60,216);
INSERT INTO ITEM VALUES (564,1,103130,3.77,80,301.6);
INSERT INTO ITEM VALUES (564,2,103131,3.9,120,468);
INSERT INTO ITEM VALUES (564,3,102132,3.23,40,129.2);
INSERT INTO ITEM VALUES (537,1,103130,3.6,160,576);
INSERT INTO ITEM VALUES (537,2,102132,3.23,30,96.9);
INSERT INTO ITEM VALUES (522,1,103120,21.59,80,1727.2);
INSERT INTO ITEM VALUES (522,2,103121,28.8,10,288);
INSERT INTO ITEM VALUES (522,3,103131,4.04,90,363.6);
INSERT INTO ITEM VALUES (522,4,103141,20,10,200);
INSERT INTO ITEM VALUES (554,1,103131,4.04,70,282.8);
INSERT INTO ITEM VALUES (569,1,103120,22.5,50,1125);
INSERT INTO ITEM VALUES (569,2,103130,3.6,180,648);
INSERT INTO ITEM VALUES (569,3,103141,20,15,300);
INSERT INTO ITEM VALUES (550,1,103120,22.5,60,1350);
INSERT INTO ITEM VALUES (550,2,103140,19,45,855);
INSERT INTO ITEM VALUES (550,3,103141,20,5,100);
INSERT INTO ITEM VALUES (550,4,102132,3.4,15,51);
INSERT INTO ITEM VALUES (548,1,103140,19,30,570);
INSERT INTO ITEM VALUES (548,2,102132,3.23,30,96.9);
INSERT INTO ITEM VALUES (505,1,103130,3.5,100,350);
INSERT INTO ITEM VALUES (505,2,103140,20,15,300);
INSERT INTO ITEM VALUES (577,1,103121,30,20,600);
INSERT INTO ITEM VALUES (577,2,103131,3.9,150,585);
INSERT INTO ITEM VALUES (577,3,102132,3.23,25,80.75);
INSERT INTO ITEM VALUES (533,1,103121,27.35,30,820.5);
INSERT INTO ITEM VALUES (533,2,103130,3.77,80,301.6);
INSERT INTO ITEM VALUES (561,1,103120,22.5,80,1800);
INSERT INTO ITEM VALUES (561,2,103130,3.77,70,263.9);
INSERT INTO ITEM VALUES (561,3,103141,20,15,300);
INSERT INTO ITEM VALUES (561,4,200376,2.16,90,194.4);
INSERT INTO ITEM VALUES (506,1,103120,20.88,80,1670.4);
INSERT INTO ITEM VALUES (506,2,103130,3.5,180,630);
INSERT INTO ITEM VALUES (506,3,103141,20,15,300);
INSERT INTO ITEM VALUES (530,1,103121,25.91,50,1295.5);
INSERT INTO ITEM VALUES (530,2,103130,3.6,200,720);
INSERT INTO ITEM VALUES (530,3,103140,19,40,760);
INSERT INTO ITEM VALUES (530,4,103141,20,10,200);
INSERT INTO ITEM VALUES (530,5,102132,3.4,15,51);
INSERT INTO ITEM VALUES (545,1,103140,19,25,475);
INSERT INTO ITEM VALUES (557,1,103120,23.75,40,950);
INSERT INTO ITEM VALUES (557,2,103121,30,10,300);
INSERT INTO ITEM VALUES (557,3,103140,19,35,665);
INSERT INTO ITEM VALUES (557,4,200376,2.16,80,172.8);
INSERT INTO ITEM VALUES (557,5,200380,3.4,110,374);
INSERT INTO ITEM VALUES (546,1,103120,22.5,50,1125);
INSERT INTO ITEM VALUES (546,2,103121,30,20,600);
INSERT INTO ITEM VALUES (546,3,103130,3.6,120,432);
INSERT INTO ITEM VALUES (546,4,103131,3.9,140,546);
INSERT INTO ITEM VALUES (546,5,103140,19,40,760);
INSERT INTO ITEM VALUES (546,6,103141,20,10,200);
INSERT INTO ITEM VALUES (510,1,103120,20.88,60,1252.8);
INSERT INTO ITEM VALUES (510,2,103131,4.19,20,83.8);

INSERT INTO CUSTOMER
  (ZIP_CODE, STATE, SALESPERSON_ID, PHONE_NUMBER, 
  NAME, 
  CUSTOMER_ID, CREDIT_LIMIT, CITY, AREA_CODE, ADDRESS, 
  COMMENTS)
  VALUES ('96711', 'CA', '7844', '5986609', 
  'JOCKSPORTS',
  '100', '5000', 'BELMONT', '415', '345 VIEWRIDGE', 
  'Very friendly people to work with -- sales rep likes to be called Mike.');
 
INSERT INTO CUSTOMER
  (ZIP_CODE, STATE, SALESPERSON_ID, PHONE_NUMBER, 
  NAME, 
  CUSTOMER_ID, CREDIT_LIMIT, CITY, AREA_CODE, ADDRESS, 
  COMMENTS)
  VALUES ('94061', 'CA', '7521', '3681223',
  'TKB SPORT SHOP',
  '101', '10000', 'REDWOOD CITY', '415', '490 BOLI RD.', 
  'Rep called 5/8 about change in order - contact shipping.');
                                                              
INSERT INTO CUSTOMER
  (ZIP_CODE, STATE, SALESPERSON_ID, PHONE_NUMBER, 
  NAME, 
  CUSTOMER_ID, CREDIT_LIMIT, CITY, AREA_CODE, ADDRESS, 
  COMMENTS)
  VALUES ('95133', 'CA', '7654', '6443341', 
  'VOLLYRITE',
  '102', '7000', 'BURLINGAME', '415', '9722 HAMILTON', 
  'Company doing heavy promotion beginning 10/89. Prepare for large orders during winter.');
 
INSERT INTO CUSTOMER
  (ZIP_CODE, STATE, SALESPERSON_ID, PHONE_NUMBER, 
  NAME, 
  CUSTOMER_ID, CREDIT_LIMIT, CITY, AREA_CODE, ADDRESS, 
  COMMENTS)
  VALUES ('97544', 'CA', '7521', '6779312',
  'JUST TENNIS',
  '103', '3000', 'BURLINGAME', '415', 'HILLVIEW MALL', 
  'Contact rep about new line of tennis rackets.');
                                                             
INSERT INTO CUSTOMER
  (ZIP_CODE, STATE, SALESPERSON_ID, PHONE_NUMBER, 
  NAME, 
  CUSTOMER_ID, CREDIT_LIMIT, CITY, AREA_CODE, ADDRESS, 
  COMMENTS)
  VALUES ('93301', 'CA', '7499', '9962323',
  'EVERY MOUNTAIN',
  '104', '10000', 'CUPERTINO', '408', '574 SURRY RD.', 
  'Customer with high market share (23%) due to aggressive advertising.');
                                                      
INSERT INTO CUSTOMER
  (ZIP_CODE, STATE, SALESPERSON_ID, PHONE_NUMBER, 
  NAME, 
  CUSTOMER_ID, CREDIT_LIMIT, CITY, AREA_CODE, ADDRESS, 
  COMMENTS)
  VALUES ('91003', 'CA', '7844', '3769966',
  'K + T SPORTS',
  '105', '5000', 'SANTA CLARA', '408', '3476 EL PASEO', 
  'Tends to order large amounts of merchandise at once. Accounting is considering raising their credit limit. Usually pays on time.');
                                                      
INSERT INTO CUSTOMER
  (ZIP_CODE, STATE, SALESPERSON_ID, PHONE_NUMBER, 
  NAME, 
  CUSTOMER_ID, CREDIT_LIMIT, CITY, AREA_CODE, ADDRESS, 
  COMMENTS)
  VALUES ('94301', 'CA', '7521', '3649777',
  'SHAPE UP',
  '106', '6000', 'PALO ALTO', '415', '908 SEQUOIA', 
  'Support intensive. Orders small amounts (< 800) of merchandise at a time.');
 
INSERT INTO CUSTOMER
  (ZIP_CODE, STATE, SALESPERSON_ID, PHONE_NUMBER, 
  NAME, 
  CUSTOMER_ID, CREDIT_LIMIT, CITY, AREA_CODE, ADDRESS, 
  COMMENTS)
  VALUES ('93301', 'CA', '7499', '9674398',
  'WOMENS SPORTS',
  '107', '10000', 'SUNNYVALE', '408', 'VALCO VILLAGE', 
  'First sporting goods store geared exclusively towards women. Unusual promotional style and very willing to take chances towards new products!');
            
INSERT INTO CUSTOMER
  (ZIP_CODE, STATE, SALESPERSON_ID, PHONE_NUMBER, 
  NAME, 
  CUSTOMER_ID, CREDIT_LIMIT, CITY, AREA_CODE, ADDRESS, 
  COMMENTS)
  VALUES ('55649', 'MN', '7844', '5669123',
  'NORTH WOODS HEALTH AND FITNESS SUPPLY CENTER',
  '108', '8000', 'HIBBING', '612', '98 LONE PINE WAY', '');

INSERT INTO CUSTOMER VALUES
  ( 201 , 'STADIUM SPORTS', '47 IRVING PL.',
  'NEW YORK', 'NY', '10003',
  '212', '5555335',  7557 ,  10000 ,
  'Large general-purpose sports store with an affluent customer base.');

INSERT INTO CUSTOMER VALUES
  ( 202 , 'HOOPS', '2345 ADAMS AVE.',
  'LEICESTER', 'MA', '01524',
  '508', '5557542',  7820 ,  5000 ,
  'Specializes in basketball equipment.');

INSERT INTO CUSTOMER VALUES
  ( 203 , 'REBOUND SPORTS', '2 E. 14TH ST.',
  'NEW YORK', 'NY', '10009',
  '212', '5555989',  7557 ,  10000 ,
  'Follow up on the promotion proposal.');

INSERT INTO CUSTOMER VALUES
  ( 204 , 'THE POWER FORWARD', '1 KNOTS LANDING',
  'DALLAS', 'TX', '75248',
  '214', '5550505',  7560 ,  12000 ,
  'Large floorspace.  Prefers maintaining large amounts of inventory on hand.');

INSERT INTO CUSTOMER VALUES
  ( 205 , 'POINT GUARD', '20 THURSTON ST.',
  'YONKERS', 'NY', '10956',
  '914', '5554766',  7557 ,  3000 ,
  'Tremendous potential for an exclusive agreement.');

INSERT INTO CUSTOMER VALUES
  ( 206 , 'THE COLISEUM', '5678 WILBUR PL.',
  'SCARSDALE', 'NY', '10583',
  '914', '5550217',  7557 ,  6000 ,
  'Contact rep. about new product lines.');

INSERT INTO CUSTOMER VALUES
  ( 207 , 'FAST BREAK', '1000 HERBERT LN.',
  'CONCORD', 'MA', '01742',
  '508', '5551298',  7820 ,  7000 ,
  'Customer requires written price quotes before making purchase requisitions.');

INSERT INTO CUSTOMER VALUES
  ( 208 , 'AL AND BOB''S SPORTS', '260 YORKTOWN CT.',
  'AUSTIN', 'TX', '78731',
  '512', '5557631',  7560 ,  4000 ,
  'Very personal purchasing agents -- Sharon and Scott.');

INSERT INTO CUSTOMER VALUES
  ( 211 , 'AT BAT', '234 BEACHEM ST.',
  'BROOKLINE', 'MA', '02146',
  '617', '5557385',  7820 ,  8000 ,
  'Have an open purchase order for $3000.  Ship immediately on request.');

INSERT INTO CUSTOMER VALUES
  ( 212 , 'ALL SPORT', '1000 38TH ST.',
  'BROOKLYN', 'NY', '11210',
  '718', '5551739',  7600 ,  6000 ,
  'Pursue a contract -- possible candidate for volume purchasing agreements.');

INSERT INTO CUSTOMER VALUES
  ( 213 , 'GOOD SPORT', '400 46TH ST.',
  'SUNNYSIDE', 'NY', '11104',
  '718', '5553771',  7600 ,  5000 ,
  'May be moving to a larger location.');

INSERT INTO CUSTOMER VALUES
  ( 214 , 'AL''S PRO SHOP', '45 SPRUCE ST.',
  'SPRING', 'TX', '77388',
  '713', '5555172',  7564 ,  8000 ,
  'Target market is serious athletes.');

INSERT INTO CUSTOMER VALUES
  ( 215 , 'BOB''S FAMILY SPORTS', '400 E. 23RD',
  'HOUSTON', 'TX', '77026',
  '713', '5558015',  7654 ,  8000 ,
  'Target market is casual and weekend athletes.  Offers a large selection.');

INSERT INTO CUSTOMER VALUES
  ( 216 , 'THE ALL AMERICAN', '547 PRENTICE RD.',
  'CHELSEA', 'MA', '02150',
  '617', '5553047',  7820 ,  5000 ,
  'Customer prefers to be called between 10 and 12.');

INSERT INTO CUSTOMER VALUES
  ( 217 , 'HIT, THROW, AND RUN', '333 WOOD COURT',
  'GRAPEVINE', 'TX', '76051',
  '817', '5552352',  7564 ,  6000 ,
  'General purpose sports store.');

INSERT INTO CUSTOMER VALUES
  ( 218 , 'THE OUTFIELD', '346 GARDEN BLVD.',
  'FLUSHING', 'NY', '11355',
  '718', '5552131',  7820 ,  4000 ,
  'Store does not open until 11am and does not have an answering service.');

INSERT INTO CUSTOMER VALUES
  ( 221 , 'WHEELS AND DEALS', '2 MEMORIAL DRIVE',
  'HOUSTON', 'TX', '77007',
  '713', '5554139',  7789 ,  10000 ,
  'Discount bicycle and sporting good store.');

INSERT INTO CUSTOMER VALUES
  ( 222 , 'JUST BIKES', '4000 PARKRIDGE BLVD.',
  'DALLAS', 'TX', '75205',
  '214', '5558735',  7789 ,  4000 ,
  'Exclusive bicycle dealer.');

INSERT INTO CUSTOMER VALUES
  ( 223 , 'VELO SPORTS', '23 WHITE ST.',
  'MALDEN', 'MA', '02148',
  '617', '5554983',  7820 ,  5000 ,
  'Clerk answers all phone lines.  Ask for Mike.');

INSERT INTO CUSTOMER VALUES
  ( 224 , 'JOE''S BIKE SHOP', '4500 FOX COURT',
  'GRAND PRARIE', 'TX', '75051',
  '214', '5559834',  7789 ,  6000 ,
  'Call Joe to make sure last shipment was complete.');

INSERT INTO CUSTOMER VALUES
  ( 225 , 'BOB''S SWIM, CYCLE, AND RUN', '300 HORSECREEK CIRCLE',
  'IRVING', 'TX', '75039',
  '214', '5558388',  7789 ,  7000 ,
  'Store catering to triathletes.');

INSERT INTO CUSTOMER VALUES
  ( 226 , 'CENTURY SHOP', '8 DAGMAR DR.',
  'HUNTINGTON', 'NY', '11743',
  '516', '5553006',  7555 ,  4000 ,
  'Customer in the midst of a cost-cutting program.');

INSERT INTO CUSTOMER VALUES
  ( 227 , 'THE TOUR', '2500 GARDNER RD.',
  'SOMERVILLE', 'MA', '02144',
  '617', '5556673',  7820 ,  5000 ,
  'Customer referred to us by The All American.');

INSERT INTO CUSTOMER VALUES
  ( 228 , 'FITNESS FIRST', '5000 85TH ST.',
  'JACKSON HEIGHTS', 'NY', '11372',
  '718', '5558710',  7555 ,  4000 ,
  'Recently acquired another sporting goods store.  Expect higher volume in the future.');

COMMIT;

REM Create indexes

CREATE UNIQUE INDEX I_LOCATION$LOCATION_ID ON LOCATION (LOCATION_ID);
CREATE UNIQUE INDEX I_DEPARTMENT$DEPARTMENT_ID ON DEPARTMENT (DEPARTMENT_ID);
CREATE UNIQUE INDEX I_JOB$JOB_ID ON JOB (JOB_ID);
CREATE UNIQUE INDEX I_EMPLOYEE$EMPLOYEE_ID ON EMPLOYEE (EMPLOYEE_ID);
CREATE UNIQUE INDEX I_SALARY_GRADE$GRADE_ID ON SALARY_GRADE (GRADE_ID);
CREATE UNIQUE INDEX I_PRODUCT$PRODUCT_ID ON PRODUCT (PRODUCT_ID);
CREATE UNIQUE INDEX I_PRICE ON PRICE (PRODUCT_ID, START_DATE);
CREATE UNIQUE INDEX I_CUSTOMER$CUSTOMER_ID ON CUSTOMER (CUSTOMER_ID);
CREATE UNIQUE INDEX I_SALES_ORDER$ORDER_ID ON SALES_ORDER (ORDER_ID);
CREATE UNIQUE INDEX I_ITEM ON ITEM (ORDER_ID, ITEM_ID);

REM Add constraints

ALTER TABLE CUSTOMER ADD /* CONSTRAINT CUSTOMER_ID_NN */
   CHECK (CUSTOMER_ID IS NOT NULL);
ALTER TABLE CUSTOMER ADD /* CONSTRAINT SALESPERSON_ID_NN */
   CHECK (SALESPERSON_ID IS NOT NULL);
ALTER TABLE CUSTOMER ADD /* CONSTRAINT CUSTOMER_ID_ZERO */
   CHECK (CUSTOMER_ID > 0);
ALTER TABLE CUSTOMER ADD /* CONSTRAINT STATE_ALL_CAPS */
   CHECK (STATE = UPPER(STATE));
ALTER TABLE CUSTOMER ADD /* CONSTRAINT ZIP_CODE_FULL */
   CHECK (LENGTH(NVL(ZIP_CODE, '99999')) IN (5, 9));
ALTER TABLE DEPARTMENT ADD /* CONSTRAINT DEPTNO_NN */
   CHECK (DEPARTMENT_ID IS NOT NULL);
ALTER TABLE EMPLOYEE ADD /* CONSTRAINT EMPNO_NN */
   CHECK (EMPLOYEE_ID IS NOT NULL);
ALTER TABLE EMPLOYEE ADD /* CONSTRAINT EMPLOYEE$DEPTNO_NN */
   CHECK (DEPARTMENT_ID IS NOT NULL);
ALTER TABLE ITEM ADD /* CONSTRAINT ITEM$ORDER_ID_NN */
   CHECK (ORDER_ID IS NOT NULL);
ALTER TABLE ITEM ADD /* CONSTRAINT ITEM_ID_NN */
   CHECK (ITEM_ID IS NOT NULL);
ALTER TABLE JOB ADD /* CONSTRAINT JOBID_NN */
   CHECK (JOB_ID IS NOT NULL);
ALTER TABLE JOB ADD /* CONSTRAINT JOBFN_NN */
   CHECK (FUNCTION IS NOT NULL);
ALTER TABLE LOCATION ADD /* CONSTRAINT LOC_NN */
   CHECK (LOCATION_ID IS NOT NULL);
ALTER TABLE PRICE ADD /* CONSTRAINT PRICE$PRODUCT_ID_NN */
   CHECK (PRODUCT_ID IS NOT NULL);
ALTER TABLE PRICE ADD /* CONSTRAINT START_DATE_NN */
   CHECK (START_DATE IS NOT NULL);
ALTER TABLE PRICE ADD /* CONSTRAINT MIN_PRICE_LESS */
   CHECK (LIST_PRICE IS NULL OR MIN_PRICE IS NULL OR MIN_PRICE <= LIST_PRICE);
ALTER TABLE PRICE ADD /* CONSTRAINT START_DATE_LESS */
   CHECK (END_DATE IS NULL OR START_DATE <= END_DATE);
ALTER TABLE PRODUCT ADD /* CONSTRAINT PRODUCT_ID_NN */
   CHECK (PRODUCT_ID IS NOT NULL);
ALTER TABLE SALARY_GRADE ADD /* CONSTRAINT GRADE_ID_NN */
   CHECK (GRADE_ID IS NOT NULL);
ALTER TABLE SALARY_GRADE ADD /* CONSTRAINT LOWER_BOUND_LESS */
   CHECK ((LOWER_BOUND IS NULL AND UPPER_BOUND IS NOT NULL) OR (LOWER_BOUND IS NOT NULL AND UPPER_BOUND IS NULL) OR (LOWER_BOUND <= UPPER_BOUND));
ALTER TABLE SALES_ORDER ADD /* CONSTRAINT ORDER_ID_NN */
   CHECK (ORDER_ID IS NOT NULL);
ALTER TABLE SALES_ORDER ADD /* CONSTRAINT ORDER$CUSTOMER_ID_NN */
   CHECK (CUSTOMER_ID IS NOT NULL);
ALTER TABLE SALES_ORDER ADD /* CONSTRAINT SALES_TOTAL_ZERO */
   CHECK (TOTAL >= 0);

ALTER TABLE CUSTOMER ADD /* CONSTRAINT CUSTOMER_PRIMARY_KEY */
   PRIMARY KEY (CUSTOMER_ID);
ALTER TABLE DEPARTMENT ADD /* CONSTRAINT DEPT_PRIMARY_KEY */
   PRIMARY KEY (DEPARTMENT_ID);
ALTER TABLE EMPLOYEE ADD /* CONSTRAINT EMP_PRIMARY_KEY */
   PRIMARY KEY (EMPLOYEE_ID);
ALTER TABLE ITEM ADD /* CONSTRAINT ITEM_PRIMARY_KEY */
   PRIMARY KEY (ORDER_ID, ITEM_ID);
ALTER TABLE JOB ADD /* CONSTRAINT JOB_PRIMARY_KEY */
   PRIMARY KEY (JOB_ID);
ALTER TABLE LOCATION ADD /* CONSTRAINT LOC_PRIMARY_KEY */
   PRIMARY KEY (LOCATION_ID);
ALTER TABLE PRICE ADD /* CONSTRAINT PRICE_PRIMARY_KEY */
   PRIMARY KEY (PRODUCT_ID, START_DATE);
ALTER TABLE PRODUCT ADD /* CONSTRAINT PRODUCT_PRIMARY_KEY */
   PRIMARY KEY (PRODUCT_ID);
ALTER TABLE SALARY_GRADE ADD /* CONSTRAINT SALARY_GRADE_PRIMARY_KEY */
   PRIMARY KEY (GRADE_ID);
ALTER TABLE SALES_ORDER ADD /* CONSTRAINT SALES_ORDER_PRIMARY_KEY */
   PRIMARY KEY (ORDER_ID);

ALTER TABLE CUSTOMER ADD /* CONSTRAINT CUSTOMER_FOREIGN_KEY  */
   FOREIGN KEY (SALESPERSON_ID) REFERENCES EMPLOYEE;
ALTER TABLE DEPARTMENT ADD /* CONSTRAINT DEPT_FOREIGN_KEY  */
   FOREIGN KEY (LOCATION_ID) REFERENCES LOCATION;
ALTER TABLE EMPLOYEE ADD /* CONSTRAINT EMP_FOREIGN_KEY_2  */
   FOREIGN KEY (JOB_ID) REFERENCES JOB;
ALTER TABLE EMPLOYEE ADD /* CONSTRAINT EMP_SELF_KEY  */
   FOREIGN KEY (MANAGER_ID) REFERENCES EMPLOYEE;
ALTER TABLE EMPLOYEE ADD /* CONSTRAINT EMP_FOREIGN_KEY_1  */
   FOREIGN KEY (DEPARTMENT_ID) REFERENCES DEPARTMENT;
ALTER TABLE ITEM ADD /* CONSTRAINT ITEM_ORDER_FOREIGN_KEY  */
   FOREIGN KEY (ORDER_ID) REFERENCES SALES_ORDER;
ALTER TABLE ITEM ADD /* CONSTRAINT ITEM_PRODUCT_FOREIGN_KEY  */
   FOREIGN KEY (PRODUCT_ID) REFERENCES PRODUCT;
ALTER TABLE PRICE ADD /* CONSTRAINT PRICE_FOREIGN_KEY  */
   FOREIGN KEY (PRODUCT_ID) REFERENCES PRODUCT;
ALTER TABLE SALES_ORDER ADD /* CONSTRAINT SALES_ORDER_FOREIGN_KEY  */
   FOREIGN KEY (CUSTOMER_ID) REFERENCES CUSTOMER;
