Rem
Rem $Header: c0801060.sql 05-aug-2000.15:31:46 araghava Exp $
Rem
Rem c0801060.sql
Rem
Rem  Copyright (c) Oracle Corporation 1999, 2000. All Rights Reserved.
Rem
Rem    NAME
Rem      c0801060.sql - upgrade Oracle RDBMS from 8.1.6 to the new release
Rem
Rem    DESCRIPTION
Rem
Rem	 Put any dictionary related changes here (ie-create, alter, 
Rem    	 update,...).  DO NOT put PL/SQL modules in this script.  
Rem	 If you must upgrade using PL/SQL, put the module in a0801060.sql
Rem	 as catalog.sql and catproc.sql will be run before a0801060.sql
Rem	 is invoked.
Rem
Rem	 This script is called from u0801060.sql and c0801050.sql
Rem
Rem
Rem      This script performs the upgrade in the following stages:
Rem        STAGE 1: upgrade from 8.1.6 to 8.1.7
Rem        STAGE 2: call catalog.sql and catproc.sql
Rem
Rem    NOTES
Rem
Rem      * This script needs to be run in the new release's environment
Rem        (after installing the release to which you want to upgrade).
Rem
Rem      * You must be connected as INTERNAL to run this script.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    araghava    08/05/00 - Add charsetform to partcol$, subpartcol$.
Rem    rdecker     07/20/00 - don't drop owa_public
Rem    araghava    07/10/00 - Add segcol#, type# to partcol$, subpartcol$.
Rem    rdecker     05/25/00 - drop user owa_public, not drop owa_public!
Rem    dmwong      05/17/00 - add rls_index2.
Rem    rdecker     05/10/00 - DROP owa_public 
Rem    weiwang     11/15/99 - add column presentation and version to reg$
Rem    rshaikh     10/29/99 - create
Rem    rshaikh     10/29/99 - Created
Rem

Rem =========================================================================
Rem BEGIN STAGE 1: upgrade from 8.1.6 to 8.1.7
Rem =========================================================================
REM Add upgrade here!!!!

Rem add column presentation and version to reg$
alter table reg$ add ( presentation number, version number )
/

Rem add additional index to rls$
create index i_rls2 on rls$(obj#)
/

Rem add segcol#, type#, charsetform to partcol$ and subpartcol$
alter table partcol$ add (segcol# number, type# number, charsetform number);
alter table subpartcol$ add (segcol# number, type# number, charsetform number);

Rem initialize partcol$
update partcol$ 
set (col#, spare1, segcol#, type#, charsetform) = 
  (select col$.col#, col$.charsetid, col$.segcol#, col$.type#, 
     col$.charsetform 
   from col$ 
   where col$.obj# = partcol$.obj# and col$.intcol# = partcol$.intcol#
   union
   select col$.col#, col$.charsetid, col$.segcol#, col$.type#,
     col$.charsetform
   from col$, ind$ 
   where ind$.obj# = partcol$.obj# and ind$.bo# = col$.obj# and 
         col$.intcol# = partcol$.intcol#);

commit;

Rem initialize partcol$
update subpartcol$ 
set (col#, spare1, segcol#, type#, charsetform) = 
  (select col$.col#, col$.charsetid, col$.segcol#, col$.type#,
     col$.charsetform 
   from col$ 
   where col$.obj# = subpartcol$.obj# and col$.intcol# = subpartcol$.intcol#
   union
   select col$.col#, col$.charsetid, col$.segcol#, col$.type#,
     col$.charsetform
   from col$, ind$ 
   where ind$.obj# = subpartcol$.obj# and ind$.bo# = col$.obj# and 
         col$.intcol# = subpartcol$.intcol#);

commit;

alter table partcol$ modify (segcol# number not null, type# number not null);
alter table subpartcol$ modify (segcol# number not null, 
type# number not null);

Rem =========================================================================
Rem END STAGE 1: upgrade from 8.1.6 to 8.1.7
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 2: run the current release version of catalog and catproc
Rem =========================================================================

@@catalog
@@catblock
@@catproc
@@utlraw
@@prvtrawb.plb 
grant execute on utl_raw to public ; 
@@catoctk
set echo off;
@@utlpg
set echo off;
@@prvtpgb.plb 
set echo off;
grant execute on utl_pg to public ; 
@@caths
set echo off;

Rem For the next release, we'll need to create a file called c080x0x0.sql,
Rem which should call catalog and catproc.
Rem When updating this script for the next release, delete the calls to
Rem the scripts above and uncomment the call to c080x0x0.sql below.
Rem
Rem @@c0801070

Rem =========================================================================
Rem END STAGE 2: upgrade from 8.1.7 to the new release
Rem =========================================================================

Rem *************************************************************************
Rem END c0801060.sql
Rem *************************************************************************
