rem 
Rem Copyright (c) 1988, 1995, 1996, 1997, 1998, 2000 by Oracle Corporation
Rem
Rem NAME
Rem   CATLG803.SQL -- special variation of the 8.0.3 version of CATALOG
Rem
Rem FUNCTION
Rem   Same as CATALOG for 8.0.3, except that it performs a cleanup step
Rem   after creating package STANDARD.  This is to be used when downgrading
Rem   to 8.0.3.
Rem
Rem NOTES
Rem
Rem   * Do ***NOT*** execute this script without first reading the Oracle
Rem     Migration book for this release.
Rem
Rem   * This script is to be used ONLY as a step in the process to downgrade
Rem     from the current release to 8.0.3.
Rem
Rem   * Must be run when connected to SYS or INTERNAL.
Rem
Rem   * Do not create DBA synonyms in this file, they should be
Rem     added to the file dba_syn.sql
Rem
Rem Please make sure that the following 3 lines are at the end of this file:
Rem ===========================================================================
Rem THIS IS THE END OF THIS FILE - IF I AM NOT HERE THEN RCS HAS TRUNCATED FILE
Rem ===========================================================================
Rem MODIFIED
Rem     ppjanic    02/06/00 -  1154181: Remove package/type body from objauth$
Rem     ncramesh   08/04/98 -  change for sqlplus
Rem     ncramesh   05/19/98 -  fix comments
Rem     usundara   06/03/98 -  merge 8.0.5 -> 8.1.3; fix comments
Rem     usundara   04/29/98 -  update for 8.0.5 (add back the call to standard
Rem                            but follow it up with a script from MRAMACHE to
Rem                            do a special cleanup after running STANDARD)
Rem     mramache   11/17/97 -  created

rem ===========================================================================
rem BEGIN loading package STANDARD
rem ===========================================================================

rem Load PL/SQL Package STANDARD first, so views can depend upon it.
rem
rem Although this step isn't necessary when downgrading from 8.0.5 since
rem the 8.0.3 and 8.0.5 versions of package STANDARD are identical, it
rem may become necessary when downgrading from some future version where
rem the two versions are different.  So it is safest to keep this in here
rem to avoid future problems.

@@standard

rem ===========================================================================
rem END loading package STANDARD
rem ===========================================================================

rem ===========================================================================
rem BEGIN cleanup after running package STANDARD
rem ===========================================================================

rem This step needs to be done to workaround bug 571546.  This script was
rem provided by Mark Ramacher (mramache) in the bug database.

REM In 8.0.3, if this happens by running catalog.sql, standard.sql, or however,
REM the problem can be cleaned up by running the following two sql statements.
REM You must be connected as sys, have no users on the system and restart the
REM database after performing these statements.

REM cleanup script
REM There are two Invariants (broken by bug #571546)
REM 1) if a table is status valid and depends on a type, the type can't
REM    be in status 5. (NOTE: drop type force marks the table invalid)
REM 2) if a table is status valid and depends on a type, the timestamp of
REM    the type must be equal to the parent timestamp of the dependency
REM    entry in dependency$.

REM  First, make sure that all types with table dependents that are
REM valid are not in status 5. (Invariant 1)

update obj$ set status = 6 where
obj# in (select o2.obj# from obj$ o1, obj$ o2, dependency$ d
where o1.type# = 2 and o2.type# = 13 and o1.status = 1 and
o2.status = 5 and d.d_obj# = o1.obj# and d.p_obj# = o2.obj#);

REM Now make sure the dependency timestamps are the same as the
REM type's timestamp. (Invariant 2)

update dependency$ set p_timestamp = (select stime from obj$ where
obj# = p_obj#) where
d_obj# in (select o1.obj# from obj$ o1, obj$ o2, dependency$ d
where o1.type# = 2 and o2.type# = 13  and
o1.status = 1 and d.d_obj# = o1.obj# and d.p_obj# = o2.obj# and
d.p_timestamp != o2.stime);

rem ===========================================================================
rem END cleanup after running package STANDARD
rem ===========================================================================

rem ===========================================================================
rem BEGIN rest of the 8.0.3 version of CATALOG.SQL
rem ===========================================================================

remark
remark	FAMILY "FIXED (VIRTUAL) VIEWS"
remark               

create or replace view v_$dlm_misc as select * from v$dlm_misc;
drop public synonym v$dlm_misc;
create public synonym v$dlm_misc for v_$dlm_misc;
grant select on v_$dlm_misc to select_catalog_role;

create or replace view v_$dlm_latch as select * from v$dlm_latch;
drop public synonym v$dlm_latch;
create public synonym v$dlm_latch for v_$dlm_latch;
grant select on v_$dlm_latch to select_catalog_role;

create or replace view v_$dlm_convert_local as select * from v$dlm_convert_local;
drop public synonym v$dlm_convert_local;
create public synonym v$dlm_convert_local for v_$dlm_convert_local;
grant select on v_$dlm_convert_local to select_catalog_role;

create or replace view v_$dlm_convert_remote as select * from v$dlm_convert_remote;
drop public synonym v$dlm_convert_remote;
create public synonym v$dlm_convert_remote for v_$dlm_convert_remote;
grant select on v_$dlm_convert_remote to select_catalog_role;

create or replace view v_$bh as select * from v$bh;
drop public synonym v$bh;
create public synonym v$bh for v_$bh;
grant select on v_$bh to select_catalog_role;

create or replace view v_$lock_element as select * from v$lock_element;
drop public synonym v$lock_element;
create public synonym v$lock_element for v_$lock_element;
grant select on v_$lock_element to select_catalog_role;

create or replace view v_$locks_with_collisions as select * from v$locks_with_collisions;
drop public synonym v$locks_with_collisions;
create public synonym v$locks_with_collisions for v_$locks_with_collisions;
grant select on v_$locks_with_collisions to select_catalog_role;

create or replace view v_$file_ping as select * from v$file_ping;
drop public synonym v$file_ping;
create public synonym v$file_ping for v_$file_ping;
grant select on v_$file_ping to select_catalog_role;

create or replace view v_$class_ping as select * from v$class_ping;
drop public synonym v$class_ping;
create public synonym v$class_ping for v_$class_ping;
grant select on v_$class_ping to select_catalog_role;

create or replace view v_$buffer_pool as select * from v$buffer_pool;
drop public synonym v$buffer_pool;
create public synonym v$buffer_pool for v_$buffer_pool;
grant select on v_$buffer_pool to select_catalog_role;

create or replace view v_$controlfile as select * from v$controlfile;
drop public synonym v$controlfile;
create public synonym v$controlfile for v_$controlfile;
grant select on v_$controlfile to select_catalog_role;

create or replace view v_$datafile as select * from v$datafile;
drop public synonym v$datafile;
create public synonym v$datafile for v_$datafile;
grant select on v_$datafile to SELECT_CATALOG_ROLE;

create or replace view v_$log as select * from v$log;
drop public synonym v$log;
create public synonym v$log for v_$log;
grant select on v_$log to SELECT_CATALOG_ROLE;

create or replace view v_$thread as select * from v$thread;
drop public synonym v$thread;
create public synonym v$thread for v_$thread;
grant select on v_$thread to select_catalog_role;

create or replace view v_$process as select * from v$process;
drop public synonym v$process;
create public synonym v$process for v_$process;
grant select on v_$process to select_catalog_role;

create or replace view v_$bgprocess as select * from v$bgprocess;
drop public synonym v$bgprocess;
create public synonym v$bgprocess for v_$bgprocess;
grant select on v_$bgprocess to select_catalog_role;

create or replace view v_$session as select * from v$session;
drop public synonym v$session;
create public synonym v$session for v_$session;
grant select on v_$session to select_catalog_role;

create or replace view v_$license as select * from v$license;
drop public synonym v$license;
create public synonym v$license for v_$license;
grant select on v_$license to select_catalog_role;

create or replace view v_$transaction as select * from v$transaction;
drop public synonym v$transaction;
create public synonym v$transaction for v_$transaction;
grant select on v_$transaction to select_catalog_role;

create or replace view v_$locked_object as select * from v$locked_object;
drop public synonym v$locked_object;
create public synonym v$locked_object for v_$locked_object;
grant select on v_$locked_object to select_catalog_role;

create or replace view v_$latch as select * from v$latch;
drop public synonym v$latch;
create public synonym v$latch for v_$latch;
grant select on v_$latch to select_catalog_role;

create or replace view v_$latch_children as select * from v$latch_children;
drop public synonym v$latch_children;
create public synonym v$latch_children for v_$latch_children;
grant select on v_$latch_children to select_catalog_role;

create or replace view v_$latch_parent as select * from v$latch_parent;
drop public synonym v$latch_parent;
create public synonym v$latch_parent for v_$latch_parent;
grant select on v_$latch_parent to select_catalog_role;

create or replace view v_$latchname as select * from v$latchname;
drop public synonym v$latchname;
create public synonym v$latchname for v_$latchname;
grant select on v_$latchname to select_catalog_role;

create or replace view v_$latchholder as select * from v$latchholder;
drop public synonym v$latchholder;
create public synonym v$latchholder for v_$latchholder;
grant select on v_$latchholder to select_catalog_role;

create or replace view v_$latch_misses as select * from v$latch_misses;
drop public synonym v$latch_misses;
create public synonym v$latch_misses for v_$latch_misses;
grant select on v_$latch_misses to select_catalog_role;

create or replace view v_$session_longops as select * from v$session_longops;
drop public synonym v$session_longops;
create public synonym v$session_longops for v_$session_longops;
grant select on v_$session_longops to public;

create or replace view v_$resource as select * from v$resource;
drop public synonym v$resource;
create public synonym v$resource for v_$resource;
grant select on v_$resource to select_catalog_role;

create or replace view v_$_lock as select * from v$_lock;
drop public synonym v$_lock;
create public synonym v$_lock for v_$_lock;
grant select on v_$_lock to select_catalog_role;

create or replace view v_$lock as select * from v$lock;
drop public synonym v$lock;
create public synonym v$lock for v_$lock;
grant select on v_$lock to select_catalog_role;

create or replace view v_$sesstat as select * from v$sesstat;
drop public synonym v$sesstat;
create public synonym v$sesstat for v_$sesstat;
grant select on v_$sesstat to select_catalog_role;

create or replace view v_$mystat as select * from v$mystat;
drop public synonym v$mystat;
create public synonym v$mystat for v_$mystat;
grant select on v_$mystat to select_catalog_role;

create or replace view v_$subcache as select * from v$subcache;
drop public synonym v$subcache;
create public synonym v$subcache for v_$subcache;
grant select on v_$subcache to select_catalog_role;

create or replace view v_$sysstat as select * from v$sysstat;
drop public synonym v$sysstat;
create public synonym v$sysstat for v_$sysstat;
grant select on v_$sysstat to select_catalog_role;

create or replace view v_$statname as select * from v$statname;
drop public synonym v$statname;
create public synonym v$statname for v_$statname;
grant select on v_$statname to select_catalog_role;

create or replace view v_$access as select * from v$access;
drop public synonym v$access;
create public synonym v$access for v_$access;
grant select on v_$access to select_catalog_role;

create or replace view v_$object_dependency as 
  select * from v$object_dependency;
drop public synonym v$object_dependency;
create public synonym v$object_dependency for v_$object_dependency;
grant select on v_$object_dependency to select_catalog_role;

create or replace view v_$dbfile as select * from v$dbfile;
drop public synonym v$dbfile;
create public synonym v$dbfile for v_$dbfile;
grant select on v_$dbfile to select_catalog_role;

create or replace view v_$filestat as select * from v$filestat;
drop public synonym v$filestat;
create public synonym v$filestat for v_$filestat;
grant select on v_$filestat to select_catalog_role;

create or replace view v_$logfile as select * from v$logfile;
drop public synonym v$logfile;
create public synonym v$logfile for v_$logfile;
grant select on v_$logfile to select_catalog_role;

create or replace view v_$rollname as select x$kturd.kturdusn usn,undo$.name
   from x$kturd, undo$
   where x$kturd.kturdusn=undo$.us# and x$kturd.kturdsiz!=0;
drop public synonym v$rollname;
create public synonym v$rollname for v_$rollname;
grant select on v_$rollname to select_catalog_role;

create or replace view v_$rollstat as select * from v$rollstat;
drop public synonym v$rollstat;
create public synonym v$rollstat for v_$rollstat;
grant select on v_$rollstat to select_catalog_role;

create or replace view v_$sga as select * from v$sga;
drop public synonym v$sga;
create public synonym v$sga for v_$sga;
grant select on v_$sga to select_catalog_role;

create or replace view v_$parameter as select * from v$parameter;
drop public synonym v$parameter;
create public synonym v$parameter for v_$parameter;
grant select on v_$parameter to select_catalog_role;

create or replace view v_$system_parameter as select * from v$system_parameter;
drop public synonym v$system_parameter;
create public synonym v$system_parameter for v_$system_parameter;
grant select on v_$system_parameter to select_catalog_role;

create or replace view v_$rowcache as select * from v$rowcache;
drop public synonym v$rowcache;
create public synonym v$rowcache for v_$rowcache;
grant select on v_$rowcache to select_catalog_role;

create or replace view v_$enabledprivs as select * from v$enabledprivs;
drop public synonym v$enabledprivs;
create public synonym v$enabledprivs for v_$enabledprivs;
grant select on v_$enabledprivs to select_catalog_role;

create or replace view v_$nls_parameters as select * from v$nls_parameters;
drop public synonym v$nls_parameters;
create public synonym v$nls_parameters for v_$nls_parameters;
grant select on v_$nls_parameters to public;

create or replace view v_$nls_valid_values as
select * from v$nls_valid_values;
drop public synonym v$nls_valid_values;
create public synonym v$nls_valid_values for v_$nls_valid_values;
grant select on v_$nls_valid_values to public;

create or replace view v_$mls_parameters as select * from v$parameter
where name like 'mls%';
drop public synonym v$mls_parameters;
create public synonym v$mls_parameters for v_$mls_parameters;
grant select on v_$mls_parameters to public;

create or replace view v_$librarycache as select * from v$librarycache;
drop public synonym v$librarycache;
create public synonym v$librarycache for v_$librarycache;
grant select on v_$librarycache to select_catalog_role;

create or replace view v_$type_size as select * from v$type_size;
drop public synonym v$type_size;
create public synonym v$type_size for v_$type_size;
grant select on v_$type_size to select_catalog_role;

create or replace view v_$archive as select * from v$archive;
drop public synonym v$archive;
create public synonym v$archive for v_$archive;
grant select on v_$archive to select_catalog_role;

create or replace view v_$circuit as select * from v$circuit;
drop public synonym v$circuit;
create public synonym v$circuit for v_$circuit;
grant select on v_$circuit to select_catalog_role;

create or replace view v_$database as select * from v$database;
drop public synonym v$database;
create public synonym v$database for v_$database;
grant select on v_$database to select_catalog_role;

create or replace view v_$instance as select * from v$instance;
drop public synonym v$instance;
create public synonym v$instance for v_$instance;
grant select on v_$instance to select_catalog_role;

create or replace view v_$dispatcher as select * from v$dispatcher;
drop public synonym v$dispatcher;
create public synonym v$dispatcher for v_$dispatcher;
grant select on v_$dispatcher to select_catalog_role;

create or replace view v_$dispatcher_rate as select * from v$dispatcher_rate;
drop public synonym v$dispatcher_rate;
create public synonym v$dispatcher_rate for v_$dispatcher_rate;
grant select on v_$dispatcher_rate to select_catalog_role;

create or replace view v_$loghist as select * from v$loghist;
drop public synonym v$loghist;
create public synonym v$loghist for v_$loghist;
grant select on v_$loghist to select_catalog_role;

REM create or replace view v_$plsarea as select * from v$plsarea;
drop public synonym v$plsarea;
REM create public synonym v$plsarea for v_$plsarea;

create or replace view v_$sqlarea as select * from v$sqlarea;
drop public synonym v$sqlarea;
create public synonym v$sqlarea for v_$sqlarea;
grant select on v_$sqlarea to select_catalog_role;

create or replace view v_$sqltext as select * from v$sqltext;
drop public synonym v$sqltext;
create public synonym v$sqltext for v_$sqltext;
grant select on v_$sqltext to select_catalog_role;

create or replace view v_$sqltext_with_newlines as 
      select * from v$sqltext_with_newlines;
drop public synonym v$sqltext_with_newlines;
create public synonym v$sqltext_with_newlines for v_$sqltext_with_newlines;
grant select on v_$sqltext_with_newlines to select_catalog_role;

create or replace view v_$sql as select * from v$sql;
drop public synonym v$sql;
create public synonym v$sql for v_$sql;
grant select on v_$sql to select_catalog_role;

create or replace view v_$db_pipes as select * from v$db_pipes;
drop public synonym v$db_pipes;
create public synonym v$db_pipes for v_$db_pipes;
grant select on v_$db_pipes to select_catalog_role;

create or replace view v_$db_object_cache as select * from v$db_object_cache;
drop public synonym v$db_object_cache;
create public synonym v$db_object_cache for v_$db_object_cache;
grant select on v_$db_object_cache to select_catalog_role;

create or replace view v_$open_cursor as select * from v$open_cursor;
drop public synonym v$open_cursor;
create public synonym v$open_cursor for v_$open_cursor;
grant select on v_$open_cursor to select_catalog_role;

create or replace view v_$option as select * from v$option;
drop public synonym v$option;
create public synonym v$option for v_$option;
grant select on v_$option to public;

create or replace view v_$version as select * from v$version;
drop public synonym v$version;
create public synonym v$version for v_$version;
grant select on v_$version to public;

create or replace view v_$pq_sesstat as select * from v$pq_sesstat;
drop public synonym v$pq_sesstat;
create public synonym v$pq_sesstat for v_$pq_sesstat;
grant select on v_$pq_sesstat to public;

create or replace view v_$pq_sysstat as select * from v$pq_sysstat;
drop public synonym v$pq_sysstat;
create public synonym v$pq_sysstat for v_$pq_sysstat;
grant select on v_$pq_sysstat to select_catalog_role;

create or replace view v_$pq_slave as select * from v$pq_slave;
drop public synonym v$pq_slave;
create public synonym v$pq_slave for v_$pq_slave;
grant select on v_$pq_slave to select_catalog_role;

create or replace view v_$queue as select * from v$queue;
drop public synonym v$queue;
create public synonym v$queue for v_$queue;
grant select on v_$queue to select_catalog_role;

create or replace view v_$mts as select * from v$mts;
drop public synonym v$mts;
create public synonym v$mts for v_$mts;
grant select on v_$mts to select_catalog_role;

create or replace view v_$dblink as select * from v$dblink;
drop public synonym v$dblink;
create public synonym v$dblink for v_$dblink;
grant select on v_$dblink to select_catalog_role;

create or replace view v_$pwfile_users as select * from v$pwfile_users;
drop public synonym v$pwfile_users;
create public synonym v$pwfile_users for v_$pwfile_users;
grant select on v_$pwfile_users to select_catalog_role;

create or replace view v_$reqdist as select * from v$reqdist;
drop public synonym v$reqdist;
create public synonym v$reqdist for v_$reqdist;
grant select on v_$reqdist to select_catalog_role;

create or replace view v_$sgastat as select * from v$sgastat;
drop public synonym v$sgastat;
create public synonym v$sgastat for v_$sgastat;
grant select on v_$sgastat to select_catalog_role;

create or replace view v_$waitstat as select * from v$waitstat;
drop public synonym v$waitstat;
create public synonym v$waitstat for v_$waitstat;
grant select on v_$waitstat to select_catalog_role;

create or replace view v_$shared_server as select * from v$shared_server;
drop public synonym v$shared_server;
create public synonym v$shared_server for v_$shared_server;
grant select on v_$shared_server to select_catalog_role;

create or replace view v_$timer as select * from v$timer;
drop public synonym v$timer;
create public synonym v$timer for v_$timer;
grant select on v_$timer to select_catalog_role;

create or replace view v_$recover_file as select * from v$recover_file;
drop public synonym v$recover_file;
create public synonym v$recover_file for v_$recover_file;
grant select on v_$recover_file to select_catalog_role;

create or replace view v_$backup as select * from v$backup;
drop public synonym v$backup;
create public synonym v$backup for v_$backup;
grant select on v_$backup to select_catalog_role;


create or replace view v_$backup_set as select * from v$backup_set;
drop public synonym v$backup_set;
create public synonym v$backup_set for v_$backup_set;
grant select on v_$backup_set to select_catalog_role;

create or replace view v_$backup_piece as select * from v$backup_piece;
drop public synonym v$backup_piece;
create public synonym v$backup_piece for v_$backup_piece;
grant select on v_$backup_piece to select_catalog_role;

create or replace view v_$backup_datafile as select * from v$backup_datafile;
drop public synonym v$backup_datafile;
create public synonym v$backup_datafile for v_$backup_datafile;
grant select on v_$backup_datafile to select_catalog_role;

create or replace view v_$backup_redolog as select * from v$backup_redolog;
drop public synonym v$backup_redolog;
create public synonym v$backup_redolog for v_$backup_redolog;
grant select on v_$backup_redolog to select_catalog_role;

create or replace view v_$backup_corruption as select * from v$backup_corruption;
drop public synonym v$backup_corruption;
create public synonym v$backup_corruption for v_$backup_corruption;
grant select on v_$backup_corruption to select_catalog_role;

create or replace view v_$copy_corruption as select * from v$copy_corruption;
drop public synonym v$copy_corruption;
create public synonym v$copy_corruption for v_$copy_corruption;
grant select on v_$copy_corruption to select_catalog_role;

create or replace view v_$deleted_object as select * from v$deleted_object;
drop public synonym v$deleted_object;
create public synonym v$deleted_object for v_$deleted_object;
grant select on v_$deleted_object to select_catalog_role;

create or replace view v_$controlfile_record_section as select * from v$controlfile_record_section;
drop public synonym v$controlfile_record_section;
create public synonym v$controlfile_record_section for v_$controlfile_record_section;
grant select on v_$controlfile_record_section to select_catalog_role;

create or replace view v_$archived_log as select * from v$archived_log;
drop public synonym v$archived_log;
create public synonym v$archived_log for v_$archived_log;
grant select on v_$archived_log to select_catalog_role;

create or replace view v_$offline_range as select * from v$offline_range;
drop public synonym v$offline_range;
create public synonym v$offline_range for v_$offline_range;
grant select on v_$offline_range to select_catalog_role;

create or replace view v_$datafile_copy as select * from v$datafile_copy;
drop public synonym v$datafile_copy;
create public synonym v$datafile_copy for v_$datafile_copy;
grant select on v_$datafile_copy to select_catalog_role;

create or replace view v_$tablespace as select * from v$tablespace;
drop public synonym v$tablespace;
create public synonym v$tablespace for v_$tablespace;
grant select on v_$tablespace to select_catalog_role;

create or replace view v_$log_history as select * from v$log_history;
drop public synonym v$log_history;
create public synonym v$log_history for v_$log_history;
grant select on v_$log_history to select_catalog_role;

create or replace view v_$recovery_log as select * from v$recovery_log;
drop public synonym v$recovery_log;
create public synonym v$recovery_log for v_$recovery_log;
grant select on v_$recovery_log to select_catalog_role;

create or replace view v_$datafile_header as select * from v$datafile_header;
drop public synonym v$datafile_header;
create public synonym v$datafile_header for v_$datafile_header;
grant select on v_$datafile_header to select_catalog_role;
 
create or replace view v_$backup_device as select * from v$backup_device;
drop public synonym v$backup_device;
create public synonym v$backup_device for v_$backup_device;
grant select on v_$backup_device to select_catalog_role;

create or replace view v_$archive_dest as select * from v$archive_dest;
drop public synonym v$archive_dest;
create public synonym v$archive_dest for v_$archive_dest;
grant select on v_$archive_dest to select_catalog_role;

create or replace view v_$fixed_table as select * from v$fixed_table;
drop public synonym v$fixed_table;
create public synonym v$fixed_table for v_$fixed_table;
grant select on v_$fixed_table to select_catalog_role;

create or replace view v_$fixed_view_definition as 
   select * from v$fixed_view_definition;
drop public synonym v$fixed_view_definition;
create public synonym v$fixed_view_definition for v_$fixed_view_definition;
grant select on v_$fixed_view_definition to select_catalog_role;

create or replace view v_$indexed_fixed_column as 
  select * from v$indexed_fixed_column;
drop public synonym v$indexed_fixed_column;
create public synonym v$indexed_fixed_column for v_$indexed_fixed_column;
grant select on v_$indexed_fixed_column to select_catalog_role;

create or replace view v_$session_cursor_cache as 
  select * from v$session_cursor_cache;
drop public synonym v$session_cursor_cache;
create public synonym v$session_cursor_cache for v_$session_cursor_cache;
grant select on v_$session_cursor_cache to select_catalog_role;

create or replace view v_$session_wait as 
  select * from v$session_wait;
drop public synonym v$session_wait;
create public synonym v$session_wait for v_$session_wait;
grant select on v_$session_wait to select_catalog_role;

create or replace view v_$session_event as 
  select * from v$session_event;
drop public synonym v$session_event;
create public synonym v$session_event for v_$session_event;
grant select on v_$session_event to select_catalog_role;

create or replace view v_$session_connect_info as 
  select * from v$session_connect_info;
drop public synonym v$session_connect_info;
create public synonym v$session_connect_info for v_$session_connect_info;
grant select on v_$session_connect_info to select_catalog_role;

create or replace view v_$system_event as 
  select * from v$system_event;
drop public synonym v$system_event;
create public synonym v$system_event for v_$system_event;
grant select on v_$system_event to select_catalog_role;

create or replace view v_$event_name as 
  select * from v$event_name;
drop public synonym v$event_name;
create public synonym v$event_name for v_$event_name;
grant select on v_$event_name to select_catalog_role;

create or replace view v_$execution as 
  select * from v$execution;
drop public synonym v$execution;
create public synonym v$execution for v_$execution;
grant select on v_$execution to select_catalog_role;

create or replace view v_$system_cursor_cache as 
  select * from v$system_cursor_cache;
drop public synonym v$system_cursor_cache;
create public synonym v$system_cursor_cache for v_$system_cursor_cache;
grant select on v_$system_cursor_cache to select_catalog_role;

create or replace view v_$sess_io as
  select * from v$sess_io;
drop public synonym v$sess_io;
create public synonym v$sess_io for v_$sess_io;
grant select on v_$sess_io to select_catalog_role;

create or replace view v_$compatibility as
  select * from v$compatibility;
drop public synonym v$compatibility;
create public synonym v$compatibility for v_$compatibility;
grant select on v_$compatibility to select_catalog_role;

create or replace view v_$compatseg as
  select * from v$compatseg;
drop public synonym v$compatseg;
create public synonym v$compatseg for v_$compatseg;
grant select on v_$compatseg to select_catalog_role;

create or replace view v_$recovery_status as
  select * from v$recovery_status;
drop public synonym v$recovery_status;
create public synonym v$recovery_status for v_$recovery_status;
grant select on v_$recovery_status to select_catalog_role;

create or replace view v_$recovery_file_status as
  select * from v$recovery_file_status;
drop public synonym v$recovery_file_status;
create public synonym v$recovery_file_status for v_$recovery_file_status;
grant select on v_$recovery_file_status to select_catalog_role;

create or replace view v_$shared_pool_reserved as
  select * from v$shared_pool_reserved;
drop public synonym v$shared_pool_reserved;
create public synonym v$shared_pool_reserved for v_$shared_pool_reserved;
grant select on v_$shared_pool_reserved to select_catalog_role;

create or replace view v_$sort_segment as select * from v$sort_segment;
drop public synonym v$sort_segment;
create public synonym v$sort_segment for v_$sort_segment;
grant select on v_$sort_segment to select_catalog_role;

create or replace view v_$sort_usage as select * from v$sort_usage;
drop public synonym v$sort_usage;
create public synonym v$sort_usage for v_$sort_usage;
grant select on v_$sort_usage to select_catalog_role;

create or replace view v_$resource_limit as select * from v$resource_limit;
drop public synonym v$resource_limit;
create public synonym v$resource_limit for v_$resource_limit;
grant select on v_$resource_limit to select_catalog_role;

create or replace view v_$enqueue_lock as select * from v$enqueue_lock;
drop public synonym v$enqueue_lock;
create public synonym v$enqueue_lock for v_$enqueue_lock;
grant select on v_$enqueue_lock to select_catalog_role;

create or replace view v_$transaction_enqueue as select * from v$transaction_enqueue;
drop public synonym v$transaction_enqueue;
create public synonym v$transaction_enqueue for v_$transaction_enqueue;
grant select on v_$transaction_enqueue to select_catalog_role;

create or replace view v_$pq_tqstat as select * from v$pq_tqstat;
drop public synonym v$pq_tqstat;
create public synonym v$pq_tqstat for v_$pq_tqstat;
grant select on v_$pq_tqstat to public;

create or replace view v_$active_instances as select * from v$active_instances;
drop public synonym v$active_instances;
create public synonym v$active_instances for v_$active_instances;
grant select on v_$active_instances to public;

create or replace view v_$sql_cursor as select * from v$sql_cursor;
drop public synonym v$sql_cursor;
create public synonym v$sql_cursor for v_$sql_cursor;
grant select on v_$sql_cursor to select_catalog_role;

create or replace view v_$sql_bind_metadata as
  select * from v$sql_bind_metadata;
drop public synonym v$sql_bind_metadata;
create public synonym v$sql_bind_metadata for v_$sql_bind_metadata;
grant select on v_$sql_bind_metadata to select_catalog_role;

create or replace view v_$sql_bind_data as select * from v$sql_bind_data;
drop public synonym v$sql_bind_data;
create public synonym v$sql_bind_data for v_$sql_bind_data;
grant select on v_$sql_bind_data to select_catalog_role;

create or replace view v_$sql_shared_memory
  as select * from v$sql_shared_memory;
drop public synonym v$sql_shared_memory;
create public synonym v$sql_shared_memory for v_$sql_shared_memory;
grant select on v_$sql_shared_memory to select_catalog_role;

create or replace view v_$global_transaction
  as select * from v$global_transaction;
drop public synonym v$global_transaction;
create public synonym v$global_transaction for v_$global_transaction;
grant select on v_$global_transaction to select_catalog_role;

create or replace view v_$session_object_cache as 
  select * from v$session_object_cache;
drop public synonym v$session_object_cache;
create public synonym v$session_object_cache for v_$session_object_cache;
grant select on v_$session_object_cache to select_catalog_role;


remark Create synonyms for the global fixed views
remark 
remark

create or replace view gv_$enqueue_lock as select * from gv$enqueue_lock;
drop public synonym gv$enqueue_lock;
create public synonym gv$enqueue_lock for gv_$enqueue_lock;
grant select on gv_$enqueue_lock to select_catalog_role;

create or replace view gv_$transaction_enqueue as select * from gv$transaction_enqueue;
drop public synonym gv$transaction_enqueue;
create public synonym gv$transaction_enqueue for gv_$transaction_enqueue;
grant select on gv_$transaction_enqueue to select_catalog_role;

create or replace view gv_$resource_limit as select * from gv$resource_limit;
drop public synonym gv$resource_limit;
create public synonym gv$resource_limit for gv_$resource_limit;
grant select on gv_$resource_limit to select_catalog_role;

create or replace view gv_$dlm_misc as select * from gv$dlm_misc;
drop public synonym gv$dlm_misc;
create public synonym gv$dlm_misc for gv_$dlm_misc;
grant select on gv_$dlm_misc to select_catalog_role;

create or replace view gv_$dlm_latch as select * from gv$dlm_latch;
drop public synonym gv$dlm_latch;
create public synonym gv$dlm_latch for gv_$dlm_latch;
grant select on gv_$dlm_latch to select_catalog_role;

create or replace view gv_$dlm_convert_local as select * from gv$dlm_convert_local;
drop public synonym gv$dlm_convert_local;
create public synonym gv$dlm_convert_local for gv_$dlm_convert_local;
grant select on gv_$dlm_convert_local to select_catalog_role;

create or replace view gv_$dlm_convert_remote as select * from gv$dlm_convert_remote;
drop public synonym gv$dlm_convert_remote;
create public synonym gv$dlm_convert_remote for gv_$dlm_convert_remote;
grant select on gv_$dlm_convert_remote to select_catalog_role;

create or replace view gv_$bh as select * from gv$bh;
drop public synonym gv$bh;
create public synonym gv$bh for gv_$bh;
grant select on gv_$bh to select_catalog_role;

create or replace view gv_$lock_element as select * from gv$lock_element;
drop public synonym gv$lock_element;
create public synonym gv$lock_element for gv_$lock_element;
grant select on gv_$lock_element to select_catalog_role;

create or replace view gv_$locks_with_collisions as select * from gv$locks_with_collisions;
drop public synonym gv$locks_with_collisions;
create public synonym gv$locks_with_collisions for gv_$locks_with_collisions;
grant select on gv_$locks_with_collisions to select_catalog_role;

create or replace view gv_$file_ping as select * from gv$file_ping;
drop public synonym gv$file_ping;
create public synonym gv$file_ping for gv_$file_ping;
grant select on gv_$file_ping to select_catalog_role;

create or replace view gv_$class_ping as select * from gv$class_ping;
drop public synonym gv$class_ping;
create public synonym gv$class_ping for gv_$class_ping;
grant select on gv_$class_ping to select_catalog_role;

create or replace view gv_$buffer_pool as select * from gv$buffer_pool;
drop public synonym gv$buffer_pool;
create public synonym gv$buffer_pool for gv_$buffer_pool;
grant select on gv_$buffer_pool to select_catalog_role;

create or replace view gv_$controlfile as select * from gv$controlfile;
drop public synonym gv$controlfile;
create public synonym gv$controlfile for gv_$controlfile;
grant select on gv_$controlfile to select_catalog_role;

create or replace view gv_$datafile as select * from gv$datafile;
drop public synonym gv$datafile;
create public synonym gv$datafile for gv_$datafile;
grant select on gv_$datafile to SELECT_CATALOG_ROLE;

create or replace view gv_$log as select * from gv$log;
drop public synonym gv$log;
create public synonym gv$log for gv_$log;
grant select on gv_$log to SELECT_CATALOG_ROLE;

create or replace view gv_$thread as select * from gv$thread;
drop public synonym gv$thread;
create public synonym gv$thread for gv_$thread;
grant select on gv_$thread to select_catalog_role;

create or replace view gv_$process as select * from gv$process;
drop public synonym gv$process;
create public synonym gv$process for gv_$process;
grant select on gv_$process to select_catalog_role;

create or replace view gv_$bgprocess as select * from gv$bgprocess;
drop public synonym gv$bgprocess;
create public synonym gv$bgprocess for gv_$bgprocess;
grant select on gv_$bgprocess to select_catalog_role;

create or replace view gv_$session as select * from gv$session;
drop public synonym gv$session;
create public synonym gv$session for gv_$session;
grant select on gv_$session to select_catalog_role;

create or replace view gv_$license as select * from gv$license;
drop public synonym gv$license;
create public synonym gv$license for gv_$license;
grant select on gv_$license to select_catalog_role;

create or replace view gv_$transaction as select * from gv$transaction;
drop public synonym gv$transaction;
create public synonym gv$transaction for gv_$transaction;
grant select on gv_$transaction to select_catalog_role;

create or replace view gv_$locked_object as select * from gv$locked_object;
drop public synonym gv$locked_object;
create public synonym gv$locked_object for gv_$locked_object;
grant select on gv_$locked_object to select_catalog_role;

create or replace view gv_$latch as select * from gv$latch;
drop public synonym gv$latch;
create public synonym gv$latch for gv_$latch;
grant select on gv_$latch to select_catalog_role;

create or replace view gv_$latch_children as select * from gv$latch_children;
drop public synonym gv$latch_children;
create public synonym gv$latch_children for gv_$latch_children;
grant select on gv_$latch_children to select_catalog_role;

create or replace view gv_$latch_parent as select * from gv$latch_parent;
drop public synonym gv$latch_parent;
create public synonym gv$latch_parent for gv_$latch_parent;
grant select on gv_$latch_parent to select_catalog_role;

create or replace view gv_$latchname as select * from gv$latchname;
drop public synonym gv$latchname;
create public synonym gv$latchname for gv_$latchname;
grant select on gv_$latchname to select_catalog_role;

create or replace view gv_$latchholder as select * from gv$latchholder;
drop public synonym gv$latchholder;
create public synonym gv$latchholder for gv_$latchholder;
grant select on gv_$latchholder to select_catalog_role;

create or replace view gv_$latch_misses as select * from gv$latch_misses;
drop public synonym gv$latch_misses;
create public synonym gv$latch_misses for gv_$latch_misses;
grant select on gv_$latch_misses to select_catalog_role;

create or replace view gv_$session_longops as select * from gv$session_longops;
drop public synonym gv$session_longops;
create public synonym gv$session_longops for gv_$session_longops;
grant select on gv_$session_longops to public;

create or replace view gv_$resource as select * from gv$resource;
drop public synonym gv$resource;
create public synonym gv$resource for gv_$resource;
grant select on gv_$resource to select_catalog_role;

create or replace view gv_$_lock as select * from gv$_lock;
drop public synonym gv$_lock;
create public synonym gv$_lock for gv_$_lock;
grant select on gv_$_lock to select_catalog_role;

create or replace view gv_$lock as select * from gv$lock;
drop public synonym gv$lock;
create public synonym gv$lock for gv_$lock;
grant select on gv_$lock to select_catalog_role;

create or replace view gv_$sesstat as select * from gv$sesstat;
drop public synonym gv$sesstat;
create public synonym gv$sesstat for gv_$sesstat;
grant select on gv_$sesstat to select_catalog_role;

create or replace view gv_$mystat as select * from gv$mystat;
drop public synonym gv$mystat;
create public synonym gv$mystat for gv_$mystat;
grant select on gv_$mystat to select_catalog_role;

create or replace view gv_$subcache as select * from gv$subcache;
drop public synonym gv$subcache;
create public synonym gv$subcache for gv_$subcache;
grant select on gv_$subcache to select_catalog_role;

create or replace view gv_$sysstat as select * from gv$sysstat;
drop public synonym gv$sysstat;
create public synonym gv$sysstat for gv_$sysstat;
grant select on gv_$sysstat to select_catalog_role;

create or replace view gv_$statname as select * from gv$statname;
drop public synonym gv$statname;
create public synonym gv$statname for gv_$statname;
grant select on gv_$statname to select_catalog_role;

create or replace view gv_$access as select * from gv$access;
drop public synonym gv$access;
create public synonym gv$access for gv_$access;
grant select on gv_$access to select_catalog_role;

create or replace view gv_$object_dependency as 
  select * from gv$object_dependency;
drop public synonym gv$object_dependency;
create public synonym gv$object_dependency for gv_$object_dependency;
grant select on gv_$object_dependency to select_catalog_role;

create or replace view gv_$dbfile as select * from gv$dbfile;
drop public synonym gv$dbfile;
create public synonym gv$dbfile for gv_$dbfile;
grant select on gv_$dbfile to select_catalog_role;

create or replace view gv_$filestat as select * from gv$filestat;
drop public synonym gv$filestat;
create public synonym gv$filestat for gv_$filestat;
grant select on gv_$filestat to select_catalog_role;

create or replace view gv_$logfile as select * from gv$logfile;
drop public synonym gv$logfile;
create public synonym gv$logfile for gv_$logfile;
grant select on gv_$logfile to select_catalog_role;

remark This is bad for gv$ views.  Need to fix or just forget -msc-
remark create or replace view gv_$rollname as select 
remark     x$kturd.kturdusn usn,undo$.name
remark   from x$kturd, undo$
remark   where x$kturd.kturdusn=undo$.us# and x$kturd.kturdsiz!=0;
remark drop public synonym gv$rollname;
remark create public synonym gv$rollname for gv_$rollname;
remark grant select on gv_$rollname to select_catalog_role;

create or replace view gv_$rollstat as select * from gv$rollstat;
drop public synonym gv$rollstat;
create public synonym gv$rollstat for gv_$rollstat;
grant select on gv_$rollstat to select_catalog_role;

create or replace view gv_$sga as select * from gv$sga;
drop public synonym gv$sga;
create public synonym gv$sga for gv_$sga;
grant select on gv_$sga to select_catalog_role;

create or replace view gv_$parameter as select * from gv$parameter;
drop public synonym gv$parameter;
create public synonym gv$parameter for gv_$parameter;
grant select on gv_$parameter to select_catalog_role;

create or replace view gv_$system_parameter as select * from gv$system_parameter;
drop public synonym gv$system_parameter;
create public synonym gv$system_parameter for gv_$system_parameter;
grant select on gv_$system_parameter to select_catalog_role;

create or replace view gv_$rowcache as select * from gv$rowcache;
drop public synonym gv$rowcache;
create public synonym gv$rowcache for gv_$rowcache;
grant select on gv_$rowcache to select_catalog_role;

create or replace view gv_$enabledprivs as select * from gv$enabledprivs;
drop public synonym gv$enabledprivs;
create public synonym gv$enabledprivs for gv_$enabledprivs;
grant select on gv_$enabledprivs to select_catalog_role;

create or replace view gv_$nls_parameters as select * from gv$nls_parameters;
drop public synonym gv$nls_parameters;
create public synonym gv$nls_parameters for gv_$nls_parameters;
grant select on gv_$nls_parameters to public;

create or replace view gv_$nls_valid_values as
select * from gv$nls_valid_values;
drop public synonym gv$nls_valid_values;
create public synonym gv$nls_valid_values for gv_$nls_valid_values;
grant select on gv_$nls_valid_values to public;

create or replace view gv_$mls_parameters as select * from gv$parameter
where name like 'mls%';
drop public synonym gv$mls_parameters;
create public synonym gv$mls_parameters for gv_$mls_parameters;
grant select on gv_$mls_parameters to public;

create or replace view gv_$librarycache as select * from gv$librarycache;
drop public synonym gv$librarycache;
create public synonym gv$librarycache for gv_$librarycache;
grant select on gv_$librarycache to select_catalog_role;

create or replace view gv_$type_size as select * from gv$type_size;
drop public synonym gv$type_size;
create public synonym gv$type_size for gv_$type_size;
grant select on gv_$type_size to select_catalog_role;

create or replace view gv_$archive as select * from gv$archive;
drop public synonym gv$archive;
create public synonym gv$archive for gv_$archive;
grant select on gv_$archive to select_catalog_role;

create or replace view gv_$circuit as select * from gv$circuit;
drop public synonym gv$circuit;
create public synonym gv$circuit for gv_$circuit;
grant select on gv_$circuit to select_catalog_role;

create or replace view gv_$database as select * from gv$database;
drop public synonym gv$database;
create public synonym gv$database for gv_$database;
grant select on gv_$database to select_catalog_role;

create or replace view gv_$instance as select * from gv$instance;
drop public synonym gv$instance;
create public synonym gv$instance for gv_$instance;
grant select on gv_$instance to select_catalog_role;

create or replace view gv_$dispatcher as select * from gv$dispatcher;
drop public synonym gv$dispatcher;
create public synonym gv$dispatcher for gv_$dispatcher;
grant select on gv_$dispatcher to select_catalog_role;

create or replace view gv_$dispatcher_rate as select * from gv$dispatcher_rate;
drop public synonym gv$dispatcher_rate;
create public synonym gv$dispatcher_rate for gv_$dispatcher_rate;
grant select on gv_$dispatcher_rate to select_catalog_role;

create or replace view gv_$loghist as select * from gv$loghist;
drop public synonym gv$loghist;
create public synonym gv$loghist for gv_$loghist;
grant select on gv_$loghist to select_catalog_role;

REM create or replace view gv_$plsarea as select * from gv$plsarea;
drop public synonym gv$plsarea;
REM create public synonym gv$plsarea for gv_$plsarea;

create or replace view gv_$sqlarea as select * from gv$sqlarea;
drop public synonym gv$sqlarea;
create public synonym gv$sqlarea for gv_$sqlarea;
grant select on gv_$sqlarea to select_catalog_role;

create or replace view gv_$sqltext as select * from gv$sqltext;
drop public synonym gv$sqltext;
create public synonym gv$sqltext for gv_$sqltext;
grant select on gv_$sqltext to select_catalog_role;

create or replace view gv_$sqltext_with_newlines as 
      select * from gv$sqltext_with_newlines;
drop public synonym gv$sqltext_with_newlines;
create public synonym gv$sqltext_with_newlines for gv_$sqltext_with_newlines;
grant select on gv_$sqltext_with_newlines to select_catalog_role;

create or replace view gv_$sql as select * from gv$sql;
drop public synonym gv$sql;
create public synonym gv$sql for gv_$sql;
grant select on gv_$sql to select_catalog_role;

create or replace view gv_$db_pipes as select * from gv$db_pipes;
drop public synonym gv$db_pipes;
create public synonym gv$db_pipes for gv_$db_pipes;
grant select on gv_$db_pipes to select_catalog_role;

create or replace view gv_$db_object_cache as select * from gv$db_object_cache;
drop public synonym gv$db_object_cache;
create public synonym gv$db_object_cache for gv_$db_object_cache;
grant select on gv_$db_object_cache to select_catalog_role;

create or replace view gv_$open_cursor as select * from gv$open_cursor;
drop public synonym gv$open_cursor;
create public synonym gv$open_cursor for gv_$open_cursor;
grant select on gv_$open_cursor to select_catalog_role;

create or replace view gv_$option as select * from gv$option;
drop public synonym gv$option;
create public synonym gv$option for gv_$option;
grant select on gv_$option to public;

create or replace view gv_$version as select * from gv$version;
drop public synonym gv$version;
create public synonym gv$version for gv_$version;
grant select on gv_$version to public;

create or replace view gv_$pq_sesstat as select * from gv$pq_sesstat;
drop public synonym gv$pq_sesstat;
create public synonym gv$pq_sesstat for gv_$pq_sesstat;
grant select on gv_$pq_sesstat to public;

create or replace view gv_$pq_sysstat as select * from gv$pq_sysstat;
drop public synonym gv$pq_sysstat;
create public synonym gv$pq_sysstat for gv_$pq_sysstat;
grant select on gv_$pq_sysstat to select_catalog_role;

create or replace view gv_$pq_slave as select * from gv$pq_slave;
drop public synonym gv$pq_slave;
create public synonym gv$pq_slave for gv_$pq_slave;
grant select on gv_$pq_slave to select_catalog_role;

create or replace view gv_$queue as select * from gv$queue;
drop public synonym gv$queue;
create public synonym gv$queue for gv_$queue;
grant select on gv_$queue to select_catalog_role;

create or replace view gv_$mts as select * from gv$mts;
drop public synonym gv$mts;
create public synonym gv$mts for gv_$mts;
grant select on gv_$mts to select_catalog_role;

create or replace view gv_$dblink as select * from gv$dblink;
drop public synonym gv$dblink;
create public synonym gv$dblink for gv_$dblink;
grant select on gv_$dblink to select_catalog_role;

create or replace view gv_$pwfile_users as select * from gv$pwfile_users;
drop public synonym gv$pwfile_users;
create public synonym gv$pwfile_users for gv_$pwfile_users;
grant select on gv_$pwfile_users to select_catalog_role;

create or replace view gv_$reqdist as select * from gv$reqdist;
drop public synonym gv$reqdist;
create public synonym gv$reqdist for gv_$reqdist;
grant select on gv_$reqdist to select_catalog_role;

create or replace view gv_$sgastat as select * from gv$sgastat;
drop public synonym gv$sgastat;
create public synonym gv$sgastat for gv_$sgastat;
grant select on gv_$sgastat to select_catalog_role;

create or replace view gv_$waitstat as select * from gv$waitstat;
drop public synonym gv$waitstat;
create public synonym gv$waitstat for gv_$waitstat;
grant select on gv_$waitstat to select_catalog_role;

create or replace view gv_$shared_server as select * from gv$shared_server;
drop public synonym gv$shared_server;
create public synonym gv$shared_server for gv_$shared_server;
grant select on gv_$shared_server to select_catalog_role;

create or replace view gv_$timer as select * from gv$timer;
drop public synonym gv$timer;
create public synonym gv$timer for gv_$timer;
grant select on gv_$timer to select_catalog_role;

create or replace view gv_$recover_file as select * from gv$recover_file;
drop public synonym gv$recover_file;
create public synonym gv$recover_file for gv_$recover_file;
grant select on gv_$recover_file to select_catalog_role;

create or replace view gv_$backup as select * from gv$backup;
drop public synonym gv$backup;
create public synonym gv$backup for gv_$backup;
grant select on gv_$backup to select_catalog_role;


create or replace view gv_$backup_set as select * from gv$backup_set;
drop public synonym gv$backup_set;
create public synonym gv$backup_set for gv_$backup_set;
grant select on gv_$backup_set to select_catalog_role;

create or replace view gv_$backup_piece as select * from gv$backup_piece;
drop public synonym gv$backup_piece;
create public synonym gv$backup_piece for gv_$backup_piece;
grant select on gv_$backup_piece to select_catalog_role;

create or replace view gv_$backup_datafile as select * from gv$backup_datafile;
drop public synonym gv$backup_datafile;
create public synonym gv$backup_datafile for gv_$backup_datafile;
grant select on gv_$backup_datafile to select_catalog_role;

create or replace view gv_$backup_redolog as select * from gv$backup_redolog;
drop public synonym gv$backup_redolog;
create public synonym gv$backup_redolog for gv_$backup_redolog;
grant select on gv_$backup_redolog to select_catalog_role;

create or replace view gv_$backup_corruption as select * from gv$backup_corruption;
drop public synonym gv$backup_corruption;
create public synonym gv$backup_corruption for gv_$backup_corruption;
grant select on gv_$backup_corruption to select_catalog_role;

create or replace view gv_$copy_corruption as select * from gv$copy_corruption;
drop public synonym gv$copy_corruption;
create public synonym gv$copy_corruption for gv_$copy_corruption;
grant select on gv_$copy_corruption to select_catalog_role;

create or replace view gv_$deleted_object as select * from gv$deleted_object;
drop public synonym gv$deleted_object;
create public synonym gv$deleted_object for gv_$deleted_object;
grant select on gv_$deleted_object to select_catalog_role;

create or replace view gv_$controlfile_record_section as select * from gv$controlfile_record_section;
drop public synonym gv$controlfile_record_section;
create public synonym gv$controlfile_record_section for gv_$controlfile_record_section;
grant select on gv_$controlfile_record_section to select_catalog_role;

create or replace view gv_$archived_log as select * from gv$archived_log;
drop public synonym gv$archived_log;
create public synonym gv$archived_log for gv_$archived_log;
grant select on gv_$archived_log to select_catalog_role;

create or replace view gv_$offline_range as select * from gv$offline_range;
drop public synonym gv$offline_range;
create public synonym gv$offline_range for gv_$offline_range;
grant select on gv_$offline_range to select_catalog_role;

create or replace view gv_$datafile_copy as select * from gv$datafile_copy;
drop public synonym gv$datafile_copy;
create public synonym gv$datafile_copy for gv_$datafile_copy;
grant select on gv_$datafile_copy to select_catalog_role;

create or replace view gv_$tablespace as select * from gv$tablespace;
drop public synonym gv$tablespace;
create public synonym gv$tablespace for gv_$tablespace;
grant select on gv_$tablespace to select_catalog_role;

create or replace view gv_$log_history as select * from gv$log_history;
drop public synonym gv$log_history;
create public synonym gv$log_history for gv_$log_history;
grant select on gv_$log_history to select_catalog_role;

create or replace view gv_$recovery_log as select * from gv$recovery_log;
drop public synonym gv$recovery_log;
create public synonym gv$recovery_log for gv_$recovery_log;
grant select on gv_$recovery_log to select_catalog_role;

create or replace view gv_$datafile_header as select * from gv$datafile_header;
drop public synonym gv$datafile_header;
create public synonym gv$datafile_header for gv_$datafile_header;
grant select on gv_$datafile_header to select_catalog_role;
 
create or replace view gv_$backup_device as select * from gv$backup_device;
drop public synonym gv$backup_device;
create public synonym gv$backup_device for gv_$backup_device;
grant select on gv_$backup_device to select_catalog_role;

create or replace view gv_$archive_dest as select * from gv$archive_dest;
drop public synonym gv$archive_dest;
create public synonym gv$archive_dest for gv_$archive_dest;
grant select on gv_$archive_dest to select_catalog_role;

create or replace view gv_$fixed_table as select * from gv$fixed_table;
drop public synonym gv$fixed_table;
create public synonym gv$fixed_table for gv_$fixed_table;
grant select on gv_$fixed_table to select_catalog_role;

create or replace view gv_$fixed_view_definition as 
   select * from gv$fixed_view_definition;
drop public synonym gv$fixed_view_definition;
create public synonym gv$fixed_view_definition for gv_$fixed_view_definition;
grant select on gv_$fixed_view_definition to select_catalog_role;

create or replace view gv_$indexed_fixed_column as 
  select * from gv$indexed_fixed_column;
drop public synonym gv$indexed_fixed_column;
create public synonym gv$indexed_fixed_column for gv_$indexed_fixed_column;
grant select on gv_$indexed_fixed_column to select_catalog_role;

create or replace view gv_$session_cursor_cache as 
  select * from gv$session_cursor_cache;
drop public synonym gv$session_cursor_cache;
create public synonym gv$session_cursor_cache for gv_$session_cursor_cache;
grant select on gv_$session_cursor_cache to select_catalog_role;

create or replace view gv_$session_wait as 
  select * from gv$session_wait;
drop public synonym gv$session_wait;
create public synonym gv$session_wait for gv_$session_wait;
grant select on gv_$session_wait to select_catalog_role;

create or replace view gv_$session_event as 
  select * from gv$session_event;
drop public synonym gv$session_event;
create public synonym gv$session_event for gv_$session_event;
grant select on gv_$session_event to select_catalog_role;

create or replace view gv_$session_connect_info as 
  select * from gv$session_connect_info;
drop public synonym gv$session_connect_info;
create public synonym gv$session_connect_info for gv_$session_connect_info;
grant select on gv_$session_connect_info to select_catalog_role;

create or replace view gv_$system_event as 
  select * from gv$system_event;
drop public synonym gv$system_event;
create public synonym gv$system_event for gv_$system_event;
grant select on gv_$system_event to select_catalog_role;

create or replace view gv_$event_name as 
  select * from gv$event_name;
drop public synonym gv$event_name;
create public synonym gv$event_name for gv_$event_name;
grant select on gv_$event_name to select_catalog_role;

create or replace view gv_$execution as 
  select * from gv$execution;
drop public synonym gv$execution;
create public synonym gv$execution for gv_$execution;
grant select on gv_$execution to select_catalog_role;

create or replace view gv_$system_cursor_cache as 
  select * from gv$system_cursor_cache;
drop public synonym gv$system_cursor_cache;
create public synonym gv$system_cursor_cache for gv_$system_cursor_cache;
grant select on gv_$system_cursor_cache to select_catalog_role;

create or replace view gv_$sess_io as
  select * from gv$sess_io;
drop public synonym gv$sess_io;
create public synonym gv$sess_io for gv_$sess_io;
grant select on gv_$sess_io to select_catalog_role;

create or replace view gv_$compatibility as
  select * from gv$compatibility;
drop public synonym gv$compatibility;
create public synonym gv$compatibility for gv_$compatibility;
grant select on gv_$compatibility to select_catalog_role;

create or replace view gv_$compatseg as
  select * from gv$compatseg;
drop public synonym gv$compatseg;
create public synonym gv$compatseg for gv_$compatseg;
grant select on gv_$compatseg to select_catalog_role;

create or replace view gv_$recovery_status as
  select * from gv$recovery_status;
drop public synonym gv$recovery_status;
create public synonym gv$recovery_status for gv_$recovery_status;
grant select on gv_$recovery_status to select_catalog_role;

create or replace view gv_$recovery_file_status as
  select * from gv$recovery_file_status;
drop public synonym gv$recovery_file_status;
create public synonym gv$recovery_file_status for gv_$recovery_file_status;
grant select on gv_$recovery_file_status to select_catalog_role;

create or replace view gv_$shared_pool_reserved as
  select * from gv$shared_pool_reserved;
drop public synonym gv$shared_pool_reserved;
create public synonym gv$shared_pool_reserved for gv_$shared_pool_reserved;
grant select on gv_$shared_pool_reserved to select_catalog_role;

create or replace view gv_$sort_segment as select * from gv$sort_segment;
drop public synonym gv$sort_segment;
create public synonym gv$sort_segment for gv_$sort_segment;
grant select on gv_$sort_segment to select_catalog_role;

create or replace view gv_$sort_usage as select * from gv$sort_usage;
drop public synonym gv$sort_usage;
create public synonym gv$sort_usage for gv_$sort_usage;
grant select on gv_$sort_usage to select_catalog_role;


create or replace view gv_$pq_tqstat as select * from gv$pq_tqstat;
drop public synonym gv$pq_tqstat;
create public synonym gv$pq_tqstat for gv_$pq_tqstat;
grant select on gv_$pq_tqstat to public;

create or replace view gv_$active_instances as select * from gv$active_instances;
drop public synonym gv$active_instances;
create public synonym gv$active_instances for gv_$active_instances;
grant select on gv_$active_instances to public;

create or replace view gv_$sql_cursor as select * from gv$sql_cursor;
drop public synonym gv$sql_cursor;
create public synonym gv$sql_cursor for gv_$sql_cursor;
grant select on gv_$sql_cursor to select_catalog_role;

create or replace view gv_$sql_bind_metadata as
  select * from gv$sql_bind_metadata;
drop public synonym gv$sql_bind_metadata;
create public synonym gv$sql_bind_metadata for gv_$sql_bind_metadata;
grant select on gv_$sql_bind_metadata to select_catalog_role;

create or replace view gv_$sql_bind_data as select * from gv$sql_bind_data;
drop public synonym gv$sql_bind_data;
create public synonym gv$sql_bind_data for gv_$sql_bind_data;
grant select on gv_$sql_bind_data to select_catalog_role;

create or replace view gv_$sql_shared_memory
  as select * from gv$sql_shared_memory;
drop public synonym gv$sql_shared_memory;
create public synonym gv$sql_shared_memory for gv_$sql_shared_memory;
grant select on gv_$sql_shared_memory to select_catalog_role;

create or replace view gv_$global_transaction 
  as select * from gv$global_transaction;
drop public synonym gv$global_transaction;
create public synonym gv$global_transaction for gv_$global_transaction;
grant select on gv_$global_transaction to select_catalog_role;

create or replace view gv_$session_object_cache as 
  select * from gv$session_object_cache;
drop public synonym gv$session_object_cache;
create public synonym gv$session_object_cache for gv_$session_object_cache;
grant select on gv_$session_object_cache to select_catalog_role;


remark
remark  FAMILY "PRIVILEGE MAP"
remark  Tables for mapping privilege numbers to privilege names.
remark
remark  SYSTEM_PRIVILEGE_MAP now in sql.bsq
remark
remark  TABLE_PRIVILEGE_MAP now in sql.bsq
remark
remark
remark  FAMILY "PRIVS"
remark

create or replace view SESSION_PRIVS
    (PRIVILEGE)
as
select spm.name
from sys.v$enabledprivs ep, system_privilege_map spm
where spm.privilege = ep.priv_number
/
comment on table SESSION_PRIVS is
'Privileges which the user currently has set'
/
comment on column SESSION_PRIVS.PRIVILEGE is
'Privilege Name'
/
drop public synonym SESSION_PRIVS
/
create public synonym SESSION_PRIVS for SESSION_PRIVS
/
grant select on SESSION_PRIVS to PUBLIC with grant option
/

remark
remark  FAMILY "ROLES"
remark
create or replace view SESSION_ROLES
    (ROLE)
as
select u.name
from x$kzsro,user$ u
where kzsrorol!=userenv('SCHEMAID') and kzsrorol!=1 and u.user#=kzsrorol
/
comment on table SESSION_ROLES is
'Roles which the user currently has enabled.'
/
comment on column SESSION_ROLES.ROLE is
'Role name'
/
drop public synonym SESSION_ROLES
/
create public synonym SESSION_ROLES for SESSION_ROLES
/
grant select on SESSION_ROLES to PUBLIC with grant option
/
create or replace view ROLE_SYS_PRIVS
    (ROLE, PRIVILEGE, ADMIN_OPTION)
as
select u.name,spm.name,decode(min(option$),1,'YES','NO')
from  sys.user$ u, sys.system_privilege_map spm, sys.sysauth$ sa
where grantee# in 
   (select distinct(privilege#)
    from sys.sysauth$ sa
    where privilege# > 0 
    connect by prior sa.privilege# = sa.grantee#
    start with grantee#=userenv('SCHEMAID') or grantee#=1 or grantee# in
      (select kzdosrol from x$kzdos))
  and u.user#=sa.grantee# and sa.privilege#=spm.privilege
group by u.name, spm.name
/
comment on table ROLE_SYS_PRIVS is
'System privileges granted to roles'
/
comment on column ROLE_SYS_PRIVS.ROLE is
'Role name'
/
comment on column ROLE_SYS_PRIVS.PRIVILEGE is
'System Privilege'
/
comment on column ROLE_SYS_PRIVS.ADMIN_OPTION is
'Grant was with the ADMIN option'
/
drop public synonym ROLE_SYS_PRIVS
/
create public synonym ROLE_SYS_PRIVS for ROLE_SYS_PRIVS
/
grant select on ROLE_SYS_PRIVS to PUBLIC with grant option
/
create or replace view ROLE_TAB_PRIVS
    (ROLE, OWNER, TABLE_NAME, COLUMN_NAME, PRIVILEGE, GRANTABLE)
as
select u1.name,u2.name,o.name,col$.name,tpm.name, 
       decode(max(oa.option$), 1, 'YES', 'NO')
from  sys.user$ u1,sys.user$ u2,sys.table_privilege_map tpm,
      sys.objauth$ oa,sys.obj$ o,sys.col$
where grantee# in        
   (select distinct(privilege#)
    from sys.sysauth$ sa
    where privilege# > 0 
    connect by prior sa.privilege# = sa.grantee#
    start with grantee#=userenv('SCHEMAID') or grantee#=1 or grantee# in
      (select kzdosrol from x$kzdos))
   and u1.user#=oa.grantee# and oa.privilege#=tpm.privilege
   and oa.obj#=o.obj# and oa.obj#=col$.obj#(+) and oa.col#=col$.col#(+)
   and u2.user#=o.owner#
  and bitand(col$.property, 32) = 0 /* not hidden column */
group by u1.name,u2.name,o.name,col$.name,tpm.name
/

comment on table ROLE_TAB_PRIVS is
'Table privileges granted to roles'
/
comment on column ROLE_TAB_PRIVS.ROLE is
'Role Name'
/
comment on column ROLE_TAB_PRIVS.TABLE_NAME is
'Table Name or Sequence Name'
/
comment on column ROLE_TAB_PRIVS.COLUMN_NAME is
'Column Name if applicable'
/
comment on column ROLE_TAB_PRIVS.PRIVILEGE is
'Table Privilege'
/
drop public synonym ROLE_TAB_PRIVS
/
create public synonym ROLE_TAB_PRIVS for ROLE_TAB_PRIVS
/
grant select on ROLE_TAB_PRIVS to PUBLIC with grant option
/
create or replace view ROLE_ROLE_PRIVS
    (ROLE, GRANTED_ROLE, ADMIN_OPTION)
as
select u1.name,u2.name,decode(min(option$),1,'YES','NO')
from  sys.user$ u1, sys.user$ u2, sys.sysauth$ sa
where grantee# in 
   (select distinct(privilege#)
    from sys.sysauth$ sa
    where privilege# > 0 
    connect by prior sa.privilege# = sa.grantee#
    start with grantee#=userenv('SCHEMAID') or grantee#=1 or grantee# in
      (select kzdosrol from x$kzdos))
   and u1.user#=sa.grantee# and u2.user#=sa.privilege#
group by u1.name,u2.name
/
comment on table ROLE_ROLE_PRIVS is
'Roles which are granted to roles'
/
comment on column ROLE_ROLE_PRIVS.ROLE is
'Role Name'
/
comment on column ROLE_ROLE_PRIVS.GRANTED_ROLE is
'Role which was granted'
/
comment on column ROLE_ROLE_PRIVS.ADMIN_OPTION is
'Grant was with the ADMIN option'
/
drop public synonym ROLE_ROLE_PRIVS
/
create public synonym ROLE_ROLE_PRIVS for ROLE_ROLE_PRIVS
/
grant select on ROLE_ROLE_PRIVS to PUBLIC with grant option
/
create or replace view DBA_ROLES (ROLE, PASSWORD_REQUIRED)
as
select name, decode(password, null, 'NO', 'EXTERNAL', 'EXTERNAL', 'YES')
from  user$
where type# = 0 and name not in ('PUBLIC', '_NEXT_USER')
/
drop public synonym DBA_ROLES
/
create public synonym DBA_ROLES for DBA_ROLES
/
grant select on DBA_ROLES to select_catalog_role
/
comment on table DBA_ROLES is
'All Roles which exist in the database'
/
comment on column DBA_ROLES.ROLE is
'Role Name'
/
comment on column DBA_ROLES.PASSWORD_REQUIRED is
'Indicates if the role requires a password to be enabled'
/
remark
remark These are table that actually enables the user to see his or her 
remark limits
remark
create or replace view DBA_PROFILES
    (PROFILE, RESOURCE_NAME, RESOURCE_TYPE, LIMIT)
as select n.name, m.name,
          decode (u.type#, 0, 'KERNEL', 1, 'PASSWORD', 'INVALID'),
	  decode (u.limit#, 0, 'DEFAULT', 2147483647, 'UNLIMITED', 
             decode(u.resource#, 4,
               decode (u.type#, 1, o.name, u.limit#),
                 decode(u.type#, 0, u.limit#,
                   decode(u.resource#, 1, trunc(u.limit#/86400, 4), 2,
                     trunc(u.limit#/86400, 4), 5, trunc(u.limit#/86400, 4),
                     6, trunc(u.limit#/86400, 4), u.limit#))))
  from sys.profile$ u, sys.profname$ n, sys.resource_map m, sys.obj$ o
  where u.resource# = m.resource#
  and u.type#=m.type#
  and o.obj# (+) = u.limit#
  and n.profile# = u.profile#
/
drop public synonym DBA_PROFILES
/
create public synonym DBA_PROFILES for DBA_PROFILES
/
grant select on DBA_PROFILES to select_catalog_role
/
comment on table DBA_PROFILES is
'Display all profiles and their limits'
/
comment on column DBA_PROFILES.PROFILE is
'Profile name'
/
comment on column DBA_PROFILES.RESOURCE_NAME is
'Resource name'
/
comment on column DBA_PROFILES.LIMIT is
'Limit placed on this resource for this profile'
/

REM
REM  This view enables the user to see his own profile limits
REM
create or replace view USER_RESOURCE_LIMITS
    (RESOURCE_NAME, LIMIT)
as select m.name,
	  decode (u.limit#, 2147483647, 'UNLIMITED', 
			   0, decode (p.limit#, 2147483647, 'UNLIMITED',
					       p.limit#),
			   u.limit#)
  from sys.profile$ u, sys.profile$ p,
       sys.resource_map m, user$ s
  where u.resource# = m.resource#
  and p.profile# = 0 
  and p.resource# = u.resource#
  and u.type# = p.type#
  and p.type# = 0
  and m.type# = 0
  and s.resource$ = u.profile#
  and s.user# = userenv('SCHEMAID')
/
comment on table USER_RESOURCE_LIMITS is
'Display resource limit of the user'
/
comment on column USER_RESOURCE_LIMITS.RESOURCE_NAME is
'Resource name'
/
comment on column USER_RESOURCE_LIMITS.LIMIT is
'Limit placed on this resource'
/
drop public synonym USER_RESOURCE_LIMITS
/
create public synonym USER_RESOURCE_LIMITS for USER_RESOURCE_LIMITS
/
grant select on USER_RESOURCE_LIMITS to PUBLIC with grant option
/
create or replace view USER_PASSWORD_LIMITS
    (RESOURCE_NAME, LIMIT)
as select m.name,
	  decode (u.limit#, 2147483647, 'UNLIMITED', -1, 0, 
            0, decode (p.limit#, 2147483647, 'UNLIMITED', -1, 0,
                 decode (p.resource#, 4, po.name, 1, trunc(p.limit#/86400, 4),
                   2, trunc(p.limit#/86400, 4), 5, trunc(p.limit#/86400, 4),
                   6, trunc(p.limit#/86400, 4), p.limit#)),
	    decode (u.resource#, 4, uo.name, 1, trunc(u.limit#/86400, 4), 2,
               trunc(u.limit#/86400, 4), 5, trunc(u.limit#/86400, 4),
               6, trunc(u.limit#/86400, 4), u.limit#))
  from sys.profile$ u, sys.profile$ p, sys.obj$ uo, sys.obj$ po,
       sys.resource_map m, sys.user$ s
  where u.resource# = m.resource#
  and p.profile# = 0 
  and p.resource# = u.resource#
  and u.type# = p.type#
  and p.type# = 1
  and m.type# = 1
  and uo.obj#(+) = u.limit#
  and po.obj#(+) = p.limit#
  and s.resource$ = u.profile#
  and s.user# = userenv('SCHEMAID')
/
comment on table USER_PASSWORD_LIMITS is
'Display password limits of the user'
/
comment on column USER_PASSWORD_LIMITS.RESOURCE_NAME is
'Resource name'
/
comment on column USER_PASSWORD_LIMITS.LIMIT is
'Limit placed on this resource'
/
drop public synonym USER_PASSWORD_LIMITS
/
create public synonym USER_PASSWORD_LIMITS for USER_PASSWORD_LIMITS
/
grant select on USER_PASSWORD_LIMITS to PUBLIC with grant option
/
REM
REM  This view shows the resource cost of the system
REM
create or replace view RESOURCE_COST
    (RESOURCE_NAME, UNIT_COST)
as select m.name,c.cost
  from sys.resource_cost$ c, sys.resource_map m where 
  c.resource# = m.resource#
  and m.type# = 0
  and c.resource# in (2, 4, 7, 8)
/
comment on table RESOURCE_COST is
'Cost for each resource'
/
comment on column RESOURCE_COST.RESOURCE_NAME is
'Name of resource'
/
comment on column RESOURCE_COST.UNIT_COST is
'Cost for resource'
/
drop public synonym RESOURCE_COST
/
create public synonym RESOURCE_COST for RESOURCE_COST
/
grant select on RESOURCE_COST to PUBLIC
/

remark
remark  FAMILY "CATALOG"
remark  Objects which may be used as tables in SQL statements: 
remark  Tables, Views, Synonyms.
remark               

create or replace view USER_CATALOG
    (TABLE_NAME,
     TABLE_TYPE)
as
select o.name,
       decode(o.type#, 0, 'NEXT OBJECT', 1, 'INDEX', 2, 'TABLE', 3, 'CLUSTER',
                      4, 'VIEW', 5, 'SYNONYM', 6, 'SEQUENCE', 'UNDEFINED')
from sys.obj$ o
where o.owner# = userenv('SCHEMAID')
  and ((o.type# in (4, 5, 6))
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
  and o.linkname is null
/
comment on table USER_CATALOG is
'Tables, Views, Synonyms and Sequences owned by the user'
/
comment on column USER_CATALOG.TABLE_NAME is
'Name of the object'
/
comment on column USER_CATALOG.TABLE_TYPE is
'Type of the object'
/
drop public synonym USER_CATALOG
/
create public synonym USER_CATALOG for USER_CATALOG
/
drop public synonym CAT
/
create public synonym CAT for USER_CATALOG
/
grant select on USER_CATALOG to PUBLIC with grant option
/
remark
remark  This view shows all tables, views, synonyms, and sequences owned by the
remark  user and those tables, views, synonyms, and sequences that PUBLIC
remark  has been granted access.
remark
create or replace view ALL_CATALOG
    (OWNER, TABLE_NAME,
     TABLE_TYPE)
as
select u.name, o.name,
       decode(o.type#, 0, 'NEXT OBJECT', 1, 'INDEX', 2, 'TABLE', 3, 'CLUSTER',
                      4, 'VIEW', 5, 'SYNONYM', 6, 'SEQUENCE', 'UNDEFINED')
from sys.user$ u, sys.obj$ o
where o.owner# = u.user#
  and ((o.type# in (4, 5, 6))
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
  and o.linkname is null
  and (o.owner# in (userenv('SCHEMAID'), 1)   /* public objects */
       or
       obj# in ( select obj#  /* directly granted privileges */
                 from sys.objauth$
                 where grantee# in ( select kzsrorol
                                      from x$kzsro
                                    )
                )
       or
       (
	  o.type# in (2, 4, 5) /* table, view, synonym */
	  and
	  exists (select null from v$enabledprivs
		  where priv_number in (-45 /* LOCK ANY TABLE */,
					-47 /* SELECT ANY TABLE */,
					-48 /* INSERT ANY TABLE */,
					-49 /* UPDATE ANY TABLE */,
					-50 /* DELETE ANY TABLE */))
       )
       or
       ( o.type# = 6 /* sequence */
	 and
	 exists (select null from v$enabledprivs
		 where priv_number = -109 /* SELECT ANY SEQUENCE */)))
/
comment on table ALL_CATALOG is
'All tables, views, synonyms, sequences accessible to the user'
/
comment on column ALL_CATALOG.OWNER is
'Owner of the object'
/
comment on column ALL_CATALOG.TABLE_NAME is
'Name of the object'
/
comment on column ALL_CATALOG.TABLE_TYPE is
'Type of the object'
/
drop public synonym ALL_CATALOG
/
create public synonym ALL_CATALOG for ALL_CATALOG
/
grant select on ALL_CATALOG to PUBLIC with grant option
/
create or replace view DBA_CATALOG
    (OWNER, TABLE_NAME,
     TABLE_TYPE)
as
select u.name, o.name,
       decode(o.type#, 0, 'NEXT OBJECT', 1, 'INDEX', 2, 'TABLE', 3, 'CLUSTER',
                      4, 'VIEW', 5, 'SYNONYM', 6, 'SEQUENCE', 'UNDEFINED')
from sys.user$ u, sys.obj$ o
where o.owner# = u.user#
  and o.linkname is null
  and ((o.type# in (4, 5, 6))
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
/
drop public synonym DBA_CATALOG
/
create public synonym DBA_CATALOG for DBA_CATALOG
/
grant select on DBA_CATALOG to select_catalog_role
/
comment on table DBA_CATALOG is
'All database Tables, Views, Synonyms, Sequences'
/
comment on column DBA_CATALOG.OWNER is
'Owner of the object'
/
comment on column DBA_CATALOG.TABLE_NAME is
'Name of the object'
/
comment on column DBA_CATALOG.TABLE_TYPE is
'Type of the object'
/
remark
remark  FAMILY "CLUSTERS"
remark  CREATE CLUSTER parameters.
remark  This family has no "ALL" member.
remark
create or replace view USER_CLUSTERS
    (CLUSTER_NAME, TABLESPACE_NAME,
     PCT_FREE, PCT_USED, KEY_SIZE,
     INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE, 
     FREELISTS, FREELIST_GROUPS,
     AVG_BLOCKS_PER_KEY,
     CLUSTER_TYPE, FUNCTION, HASHKEYS,
     DEGREE, INSTANCES, CACHE, BUFFER_POOL)
as select o.name, ts.name,
          mod(c.pctfree$, 100), c.pctused$, c.size$,c.initrans,c.maxtrans,
          s.iniexts * ts.blocksize, s.extsize * ts.blocksize,
          s.minexts, s.maxexts, s.extpct,
	  decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
          c.spare4, decode(c.hashkeys, 0, 'INDEX', 'HASH'),
          decode(c.hashkeys, 0, NULL,
                 decode(c.func, 0, 'COLUMN', 1, 'DEFAULT', 
                                2, 'HASH EXPRESSION', 3, 'DEFAULT2', NULL)),
          c.hashkeys,
	  lpad(decode(c.degree, 32767, 'DEFAULT', nvl(c.degree,1)),10),
	  lpad(decode(c.instances, 32767, 'DEFAULT', nvl(c.instances,1)),10),
	  lpad(decode(bitand(c.flags, 8), 8, 'Y', 'N'), 5),
          decode(s.cachehint, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from sys.ts$ ts, sys.seg$ s, sys.clu$ c, sys.obj$ o
where o.owner# = userenv('SCHEMAID')
  and o.obj# = c.obj#
  and c.ts# = ts.ts# 
  and c.ts# = s.ts#
  and c.file# = s.file#
  and c.block# = s.block#
/
comment on table USER_CLUSTERS is
'Descriptions of user''s own clusters'
/
comment on column USER_CLUSTERS.CLUSTER_NAME is
'Name of the cluster'
/
comment on column USER_CLUSTERS.TABLESPACE_NAME is
'Name of the tablespace containing the cluster'
/
comment on column USER_CLUSTERS.PCT_FREE is
'Minimum percentage of free space in a block'
/
comment on column USER_CLUSTERS.PCT_USED is
'Minimum percentage of used space in a block'
/
comment on column USER_CLUSTERS.KEY_SIZE is
'Estimated size of cluster key plus associated rows'
/
comment on column USER_CLUSTERS.INI_TRANS is
'Initial number of transactions'
/
comment on column USER_CLUSTERS.MAX_TRANS is
'Maximum number of transactions'
/
comment on column USER_CLUSTERS.INITIAL_EXTENT is
'Size of the initial extent in bytes'
/
comment on column USER_CLUSTERS.NEXT_EXTENT is
'Size of secondary extents in bytes'
/
comment on column USER_CLUSTERS.MIN_EXTENTS is
'Minimum number of extents allowed in the segment'
/
comment on column USER_CLUSTERS.MAX_EXTENTS is
'Maximum number of extents allowed in the segment'
/
comment on column USER_CLUSTERS.PCT_INCREASE is
'Percentage increase in extent size'
/
comment on column USER_CLUSTERS.FREELISTS is
'Number of process freelists allocated in this segment'
/
comment on column USER_CLUSTERS.FREELIST_GROUPS is
'Number of freelist groups allocated in this segment'
/
comment on column USER_CLUSTERS.AVG_BLOCKS_PER_KEY is
'Average number of blocks containing rows with a given cluster key'
/
comment on column USER_CLUSTERS.CLUSTER_TYPE is
'Type of cluster: b-tree index or hash'
/
comment on column USER_CLUSTERS.FUNCTION is
'If a hash cluster, the hash function'
/
comment on column USER_CLUSTERS.HASHKEYS is
'If a hash cluster, the number of hash keys (hash buckets)'
/
comment on column USER_CLUSTERS.DEGREE is
'The number of threads per instance for scanning the cluster'
/
comment on column USER_CLUSTERS.INSTANCES is
'The number of instances across which the cluster is to be scanned'
/
comment on column USER_CLUSTERS.CACHE is
'Whether the cluster is to be cached in the buffer cache'
/
comment on column USER_CLUSTERS.BUFFER_POOL is
'The default buffer pool to be used for cluster blocks'
/
drop public synonym USER_CLUSTERS
/
create public synonym USER_CLUSTERS for USER_CLUSTERS
/
drop public synonym CLU
/
create public synonym CLU for USER_CLUSTERS
/
grant select on USER_CLUSTERS to PUBLIC with grant option
/
create or replace view ALL_CLUSTERS
    (OWNER, CLUSTER_NAME, TABLESPACE_NAME,
     PCT_FREE, PCT_USED, KEY_SIZE,
     INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,
     FREELISTS, FREELIST_GROUPS,
     AVG_BLOCKS_PER_KEY,
     CLUSTER_TYPE, FUNCTION, HASHKEYS,
     DEGREE, INSTANCES, CACHE, BUFFER_POOL)
as select u.name, o.name, ts.name,
          mod(c.pctfree$, 100), c.pctused$, c.size$,c.initrans,c.maxtrans,
          s.iniexts * ts.blocksize, s.extsize * ts.blocksize,
          s.minexts, s.maxexts, s.extpct,
          decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
          c.spare4, decode(c.hashkeys, 0, 'INDEX', 'HASH'),
          decode(c.hashkeys, 0, NULL,
                 decode(c.func, 0, 'COLUMN', 1, 'DEFAULT',
                                2, 'HASH EXPRESSION', 3, 'DEFAULT2', NULL)),
          c.hashkeys,
	  lpad(decode(c.degree, 32767, 'DEFAULT', nvl(c.degree,1)),10),
	  lpad(decode(c.instances, 32767, 'DEFAULT', nvl(c.instances,1)),10),
	  lpad(decode(bitand(c.flags, 8), 8, 'Y', 'N'), 5),
          decode(s.cachehint, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from sys.user$ u, sys.ts$ ts, sys.seg$ s, sys.clu$ c, sys.obj$ o
where o.owner# = u.user#
  and o.obj#   = c.obj#
  and c.ts#    = ts.ts#
  and c.ts#    = s.ts#
  and c.file#  = s.file#
  and c.block# = s.block#
  and (o.owner# = userenv('SCHEMAID')
       or  /* user has system privilages */
         exists (select null from v$enabledprivs
                 where priv_number in (-61 /* CREATE ANY CLUSTER */,
                                       -62 /* ALTER ANY CLUSTER */,
                                       -63 /* DROP ANY CLUSTER */ )
                )
      )
/
drop public synonym ALL_CLUSTERS
/
create public synonym ALL_CLUSTERS for ALL_CLUSTERS
/
grant select on ALL_CLUSTERS to PUBLIC with grant option
/
comment on table ALL_CLUSTERS is
'Description of clusters accessible to the user'
/
comment on column ALL_CLUSTERS.OWNER is
'Owner of the cluster'
/
comment on column ALL_CLUSTERS.CLUSTER_NAME is
'Name of the cluster'
/
comment on column ALL_CLUSTERS.TABLESPACE_NAME is
'Name of the tablespace containing the cluster'
/
comment on column ALL_CLUSTERS.PCT_FREE is
'Minimum percentage of free space in a block'
/
comment on column ALL_CLUSTERS.PCT_USED is
'Minimum percentage of used space in a block'
/
comment on column ALL_CLUSTERS.KEY_SIZE is
'Estimated size of cluster key plus associated rows'
/
comment on column ALL_CLUSTERS.INI_TRANS is
'Initial number of transactions'
/
comment on column ALL_CLUSTERS.MAX_TRANS is
'Maximum number of transactions'
/
comment on column ALL_CLUSTERS.INITIAL_EXTENT is
'Size of the initial extent in bytes'
/
comment on column ALL_CLUSTERS.NEXT_EXTENT is
'Size of secondary extents in bytes'
/
comment on column ALL_CLUSTERS.MIN_EXTENTS is
'Minimum number of extents allowed in the segment'
/
comment on column ALL_CLUSTERS.MAX_EXTENTS is
'Maximum number of extents allowed in the segment'
/
comment on column ALL_CLUSTERS.PCT_INCREASE is
'Percentage increase in extent size'
/
comment on column ALL_CLUSTERS.FREELISTS is
'Number of process freelists allocated in this segment'
/
comment on column ALL_CLUSTERS.FREELIST_GROUPS is
'Number of freelist groups allocated in this segment'
/
comment on column ALL_CLUSTERS.AVG_BLOCKS_PER_KEY is
'Average number of blocks containing rows with a given cluster key'
/
comment on column ALL_CLUSTERS.CLUSTER_TYPE is
'Type of cluster: b-tree index or hash'
/
comment on column ALL_CLUSTERS.FUNCTION is
'If a hash cluster, the hash function'
/
comment on column ALL_CLUSTERS.HASHKEYS is
'If a hash cluster, the number of hash keys (hash buckets)'
/
comment on column ALL_CLUSTERS.DEGREE is
'The number of threads per instance for scanning the cluster'
/
comment on column ALL_CLUSTERS.INSTANCES is
'The number of instances across which the cluster is to be scanned'
/
comment on column ALL_CLUSTERS.CACHE is
'Whether the cluster is to be cached in the buffer cache'
/
comment on column ALL_CLUSTERS.BUFFER_POOL is
'The default buffer pool to be used for cluster blocks'
/

create or replace view DBA_CLUSTERS
    (OWNER, CLUSTER_NAME, TABLESPACE_NAME,
     PCT_FREE, PCT_USED, KEY_SIZE,
     INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE, 
     FREELISTS, FREELIST_GROUPS,
     AVG_BLOCKS_PER_KEY,
     CLUSTER_TYPE, FUNCTION, HASHKEYS,
     DEGREE, INSTANCES, CACHE, BUFFER_POOL)
as select u.name, o.name, ts.name,
          mod(c.pctfree$, 100), c.pctused$, c.size$,c.initrans,c.maxtrans,
          s.iniexts * ts.blocksize, s.extsize * ts.blocksize,
          s.minexts, s.maxexts, s.extpct,
	  decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
          c.spare4, decode(c.hashkeys, 0, 'INDEX', 'HASH'),
          decode(c.hashkeys, 0, NULL,
                 decode(c.func, 0, 'COLUMN', 1, 'DEFAULT',
                                2, 'HASH EXPRESSION', 3, 'DEFAULT2', NULL)),
          c.hashkeys,
	  lpad(decode(c.degree, 32767, 'DEFAULT', nvl(c.degree,1)),10),
	  lpad(decode(c.instances, 32767, 'DEFAULT', nvl(c.instances,1)),10),
	  lpad(decode(bitand(c.flags, 8), 8, 'Y', 'N'), 5),
          decode(s.cachehint, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from sys.user$ u, sys.ts$ ts, sys.seg$ s, sys.clu$ c, sys.obj$ o
where o.owner# = u.user#
  and o.obj# = c.obj#
  and c.ts# = ts.ts#
  and c.ts# = s.ts#
  and c.file# = s.file#
  and c.block# = s.block#
/
drop public synonym DBA_CLUSTERS
/
create public synonym DBA_CLUSTERS for DBA_CLUSTERS
/
grant select on DBA_CLUSTERS to select_catalog_role
/
comment on table DBA_CLUSTERS is
'Description of all clusters in the database'
/
comment on column DBA_CLUSTERS.OWNER is
'Owner of the cluster'
/
comment on column DBA_CLUSTERS.CLUSTER_NAME is
'Name of the cluster'
/
comment on column DBA_CLUSTERS.TABLESPACE_NAME is
'Name of the tablespace containing the cluster'
/
comment on column DBA_CLUSTERS.PCT_FREE is
'Minimum percentage of free space in a block'
/
comment on column DBA_CLUSTERS.PCT_USED is
'Minimum percentage of used space in a block'
/
comment on column DBA_CLUSTERS.KEY_SIZE is
'Estimated size of cluster key plus associated rows'
/
comment on column DBA_CLUSTERS.INI_TRANS is
'Initial number of transactions'
/
comment on column DBA_CLUSTERS.MAX_TRANS is
'Maximum number of transactions'
/
comment on column DBA_CLUSTERS.INITIAL_EXTENT is
'Size of the initial extent in bytes'
/
comment on column DBA_CLUSTERS.NEXT_EXTENT is
'Size of secondary extents in bytes'
/
comment on column DBA_CLUSTERS.MIN_EXTENTS is
'Minimum number of extents allowed in the segment'
/
comment on column DBA_CLUSTERS.MAX_EXTENTS is
'Maximum number of extents allowed in the segment'
/
comment on column DBA_CLUSTERS.PCT_INCREASE is
'Percentage increase in extent size'
/
comment on column DBA_CLUSTERS.FREELISTS is
'Number of process freelists allocated in this segment'
/
comment on column DBA_CLUSTERS.FREELIST_GROUPS is
'Number of freelist groups allocated in this segment'
/
comment on column DBA_CLUSTERS.AVG_BLOCKS_PER_KEY is
'Average number of blocks containing rows with a given cluster key'
/
comment on column DBA_CLUSTERS.CLUSTER_TYPE is
'Type of cluster: b-tree index or hash'
/
comment on column DBA_CLUSTERS.FUNCTION is
'If a hash cluster, the hash function'
/
comment on column DBA_CLUSTERS.HASHKEYS is
'If a hash cluster, the number of hash keys (hash buckets)'
/
comment on column DBA_CLUSTERS.DEGREE is
'The number of threads per instance for scanning the cluster'
/
comment on column DBA_CLUSTERS.INSTANCES is
'The number of instances across which the cluster is to be scanned'
/
comment on column DBA_CLUSTERS.CACHE is
'Whether the cluster is to be cached in the buffer cache'
/
comment on column DBA_CLUSTERS.BUFFER_POOL is
'The default buffer pool to be used for cluster blocks'
/

remark
remark  FAMILY "CLU_COLUMNS"
remark  Mapping of cluster columns to table columns.
remark  This family has no ALL member.
remark
create or replace view USER_CLU_COLUMNS
    (CLUSTER_NAME, CLU_COLUMN_NAME, TABLE_NAME, TAB_COLUMN_NAME)
as
select oc.name, cc.name, ot.name,
       decode(bitand(tc.property, 1), 1, ac.name, tc.name)
from sys.obj$ oc, sys.col$ cc, sys.obj$ ot, sys.col$ tc, sys.tab$ t,
     sys.attrcol$ ac
where oc.obj#    = cc.obj#
  and t.bobj#    = oc.obj#
  and t.obj#     = tc.obj#
  and tc.segcol# = cc.segcol#
  and t.obj#     = ot.obj#
  and oc.type#   = 3
  and oc.owner#  = userenv('SCHEMAID')
  and tc.obj#    = ac.obj#(+)
  and tc.intcol# = ac.intcol#(+)
/
comment on table USER_CLU_COLUMNS is
'Mapping of table columns to cluster columns'
/
comment on column USER_CLU_COLUMNS.CLUSTER_NAME is
'Cluster name'
/
comment on column USER_CLU_COLUMNS.CLU_COLUMN_NAME is
'Key column in the cluster'
/
comment on column USER_CLU_COLUMNS.TABLE_NAME is
'Clustered table name'
/
comment on column USER_CLU_COLUMNS.TAB_COLUMN_NAME is
'Key column or attribute of object column in the table'
/
drop public synonym USER_CLU_COLUMNS
/
create public synonym USER_CLU_COLUMNS for USER_CLU_COLUMNS
/
grant select on USER_CLU_COLUMNS to PUBLIC with grant option
/
create or replace view DBA_CLU_COLUMNS
    (OWNER, CLUSTER_NAME, CLU_COLUMN_NAME, TABLE_NAME, TAB_COLUMN_NAME)
as
select u.name, oc.name, cc.name, ot.name,
       decode(bitand(tc.property, 1), 1, ac.name, tc.name)
from sys.user$ u, sys.obj$ oc, sys.col$ cc, sys.obj$ ot, sys.col$ tc,
     sys.tab$ t, sys.attrcol$ ac
where oc.owner#  = u.user#
  and oc.obj#    = cc.obj#
  and t.bobj#    = oc.obj#
  and t.obj#     = tc.obj#
  and tc.segcol# = cc.segcol#
  and t.obj#     = ot.obj#
  and oc.type#   = 3
  and tc.obj#    = ac.obj#(+)
  and tc.intcol# = ac.intcol#(+)
/
drop public synonym DBA_CLU_COLUMNS
/
create public synonym DBA_CLU_COLUMNS for DBA_CLU_COLUMNS
/
grant select on DBA_CLU_COLUMNS to select_catalog_role
/
comment on table DBA_CLU_COLUMNS is
'Mapping of table columns to cluster columns'
/
comment on column DBA_CLU_COLUMNS.OWNER is
'Owner of the cluster'
/
comment on column DBA_CLU_COLUMNS.CLUSTER_NAME is
'Cluster name'
/
comment on column DBA_CLU_COLUMNS.CLU_COLUMN_NAME is
'Key column in the cluster'
/
comment on column DBA_CLU_COLUMNS.TABLE_NAME is
'Clustered table name'
/
comment on column DBA_CLU_COLUMNS.TAB_COLUMN_NAME is
'Key column or attribute of object column in the table'
/
remark
remark  FAMILY "COL_COMMENTS"
remark  Comments on columns of tables and views.
remark
create or replace view USER_COL_COMMENTS
    (TABLE_NAME, COLUMN_NAME, COMMENTS)
as
select o.name, c.name, co.comment$
from sys.obj$ o, sys.col$ c, sys.com$ co
where o.owner# = userenv('SCHEMAID')
  and o.type# in (2, 4)
  and o.obj# = c.obj#
  and c.obj# = co.obj#(+)
  and c.col# = co.col#(+)
  and bitand(c.property, 32) = 0 /* not hidden column */
/
comment on table USER_COL_COMMENTS is
'Comments on columns of user''s tables and views'
/
comment on column USER_COL_COMMENTS.TABLE_NAME is
'Object name'
/
comment on column USER_COL_COMMENTS.COLUMN_NAME is
'Column name'
/
comment on column USER_COL_COMMENTS.COMMENTS is
'Comment on the column'
/
drop public synonym USER_COL_COMMENTS
/
create public synonym USER_COL_COMMENTS for USER_COL_COMMENTS
/
grant select on USER_COL_COMMENTS to PUBLIC with grant option
/
create or replace view ALL_COL_COMMENTS
    (OWNER, TABLE_NAME, COLUMN_NAME, COMMENTS)
as
select u.name, o.name, c.name, co.comment$
from sys.obj$ o, sys.col$ c, sys.user$ u, sys.com$ co
where o.owner# = u.user#
  and o.type# in (2, 4, 5)
  and o.obj# = c.obj#
  and c.obj# = co.obj#(+)
  and c.col# = co.col#(+)
  and bitand(c.property, 32) = 0 /* not hidden column */
  and (o.owner# = userenv('SCHEMAID')
       or o.obj# in
         (select obj#
          from sys.objauth$
          where grantee# in ( select kzsrorol
                              from x$kzsro
                            )
          )
       or
	 exists (select null from v$enabledprivs
	         where priv_number in (-45 /* LOCK ANY TABLE */,
				       -47 /* SELECT ANY TABLE */,
				       -48 /* INSERT ANY TABLE */,
				       -49 /* UPDATE ANY TABLE */,
				       -50 /* DELETE ANY TABLE */))
      )
/
comment on table ALL_COL_COMMENTS is
'Comments on columns of accessible tables and views'
/
comment on column ALL_COL_COMMENTS.OWNER is
'Owner of the object'
/
comment on column ALL_COL_COMMENTS.TABLE_NAME is
'Name of the object'
/
comment on column ALL_COL_COMMENTS.COLUMN_NAME is
'Name of the column'
/
comment on column ALL_COL_COMMENTS.COMMENTS is
'Comment on the column'
/
drop public synonym ALL_COL_COMMENTS
/
create public synonym ALL_COL_COMMENTS for ALL_COL_COMMENTS
/
grant select on ALL_COL_COMMENTS to PUBLIC with grant option
/
create or replace view DBA_COL_COMMENTS
    (OWNER, TABLE_NAME, COLUMN_NAME, COMMENTS)
as
select u.name, o.name, c.name, co.comment$
from sys.obj$ o, sys.col$ c, sys.user$ u, sys.com$ co
where o.owner# = u.user#
  and o.type# in (2, 4)
  and o.obj# = c.obj#
  and c.obj# = co.obj#(+)
  and c.col# = co.col#(+)
  and bitand(c.property, 32) = 0 /* not hidden column */
/
drop public synonym DBA_COL_COMMENTS
/
create public synonym DBA_COL_COMMENTS for DBA_COL_COMMENTS
/
grant select on DBA_COL_COMMENTS to select_catalog_role
/
comment on table DBA_COL_COMMENTS is
'Comments on columns of all tables and views'
/
comment on column DBA_COL_COMMENTS.OWNER is
'Name of the owner of the object'
/
comment on column DBA_COL_COMMENTS.TABLE_NAME is
'Name of the object'
/
comment on column DBA_COL_COMMENTS.COLUMN_NAME is
'Name of the column'
/
comment on column DBA_COL_COMMENTS.COMMENTS is
'Comment on the object'
/
remark
remark  FAMILY "COL_PRIVS"
remark  Grants on columns.
remark
create or replace view USER_COL_PRIVS
      (GRANTEE, OWNER, TABLE_NAME, COLUMN_NAME, GRANTOR, PRIVILEGE, GRANTABLE)
as
select ue.name, u.name, o.name, c.name, ur.name, tpm.name, 
       decode(oa.option$, 1, 'YES', 'NO')
from sys.objauth$ oa, sys.obj$ o, sys.user$ u, sys.user$ ur, sys.user$ ue,
     sys.col$ c, table_privilege_map tpm
where oa.obj# = o.obj#
  and oa.grantor# = ur.user#
  and oa.grantee# = ue.user#
  and u.user# = o.owner#
  and oa.obj# = c.obj#
  and oa.col# = c.col#
  and bitand(c.property, 32) = 0 /* not hidden column */
  and oa.col# is not null
  and oa.privilege# = tpm.privilege
  and userenv('SCHEMAID') in (oa.grantor#, oa.grantee#, o.owner#)
/
comment on table USER_COL_PRIVS is
'Grants on columns for which the user is the owner, grantor or grantee'
/
comment on column USER_COL_PRIVS.GRANTEE is
'Name of the user to whom access was granted'
/
comment on column USER_COL_PRIVS.OWNER is
'Username of the owner of the object'
/
comment on column USER_COL_PRIVS.TABLE_NAME is
'Name of the object'
/
comment on column USER_COL_PRIVS.COLUMN_NAME is
'Name of the column'
/
comment on column USER_COL_PRIVS.GRANTOR is
'Name of the user who performed the grant'
/
comment on column USER_COL_PRIVS.PRIVILEGE is
'Column Privilege'
/
comment on column USER_COL_PRIVS.GRANTABLE is
'Privilege is grantable'
/
drop public synonym USER_COL_PRIVS
/
create public synonym USER_COL_PRIVS for USER_COL_PRIVS
/
grant select on USER_COL_PRIVS to PUBLIC with grant option
/
create or replace view ALL_COL_PRIVS
      (GRANTOR, GRANTEE, TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME,
       PRIVILEGE, GRANTABLE)
as
select ur.name, ue.name, u.name, o.name, c.name, tpm.name, 
       decode(oa.option$, 1, 'YES', 'NO')
from sys.objauth$ oa, sys.obj$ o, sys.user$ u, sys.user$ ur, sys.user$ ue,
     sys.col$ c, table_privilege_map tpm
where oa.obj# = o.obj#
  and oa.grantor# = ur.user#
  and oa.grantee# = ue.user#
  and u.user# = o.owner#
  and oa.obj# = c.obj#
  and oa.col# = c.col#
  and bitand(c.property, 32) = 0 /* not hidden column */
  and oa.col# is not null
  and oa.privilege# = tpm.privilege
  and (oa.grantor# = userenv('SCHEMAID') or
       oa.grantee# in (select kzsrorol from x$kzsro) or
       o.owner# = userenv('SCHEMAID'))
/
comment on table ALL_COL_PRIVS is
'Grants on columns for which the user is the grantor, grantee, owner, 
 or an enabled role or PUBLIC is the grantee'
/
comment on column ALL_COL_PRIVS.GRANTOR is
'Name of the user who performed the grant'
/
comment on column ALL_COL_PRIVS.GRANTEE is
'Name of the user to whom access was granted'
/
comment on column ALL_COL_PRIVS.TABLE_SCHEMA is
'Schema of the object'
/
comment on column ALL_COL_PRIVS.TABLE_NAME is
'Name of the object'
/
comment on column ALL_COL_PRIVS.COLUMN_NAME is
'Name of the column'
/
comment on column ALL_COL_PRIVS.PRIVILEGE is
'Column Privilege'
/
comment on column ALL_COL_PRIVS.GRANTABLE is
'Privilege is grantable'
/
drop public synonym ALL_COL_PRIVS
/
create public synonym ALL_COL_PRIVS for ALL_COL_PRIVS
/
grant select on ALL_COL_PRIVS to PUBLIC with grant option
/
create or replace view DBA_COL_PRIVS
      (GRANTEE, OWNER, TABLE_NAME, COLUMN_NAME, GRANTOR, PRIVILEGE, GRANTABLE)
as
select ue.name, u.name, o.name, c.name, ur.name, tpm.name, 
       decode(oa.option$, 1, 'YES', 'NO')
from sys.objauth$ oa, sys.obj$ o, sys.user$ u, sys.user$ ur, sys.user$ ue,
     sys.col$ c, table_privilege_map tpm
where oa.obj# = o.obj#
  and oa.grantor# = ur.user#
  and oa.grantee# = ue.user#
  and oa.obj# = c.obj#
  and oa.col# = c.col#
  and bitand(c.property, 32) = 0 /* not hidden column */
  and oa.col# is not null
  and oa.privilege# = tpm.privilege
  and u.user# = o.owner#
/
drop public synonym DBA_COL_PRIVS
/
create public synonym DBA_COL_PRIVS for DBA_COL_PRIVS
/
grant select on DBA_COL_PRIVS to select_catalog_role
/
comment on table DBA_COL_PRIVS is
'All grants on columns in the database'
/
comment on column DBA_COL_PRIVS.GRANTEE is
'Name of the user to whom access was granted'
/
comment on column DBA_COL_PRIVS.OWNER is
'Username of the owner of the object'
/
comment on column DBA_COL_PRIVS.TABLE_NAME is
'Name of the object'
/
comment on column DBA_COL_PRIVS.COLUMN_NAME is
'Name of the column'
/
comment on column DBA_COL_PRIVS.GRANTOR is
'Name of the user who performed the grant'
/
comment on column DBA_COL_PRIVS.PRIVILEGE is
'Column Privilege'
/
comment on column DBA_COL_PRIVS.GRANTABLE is
'Privilege is grantable'
/
remark
remark  FAMILY "COL_PRIVS_MADE"
remark  Grants on columns made by the user.
remark  This family has no DBA member.
remark
create or replace view USER_COL_PRIVS_MADE
      (GRANTEE, TABLE_NAME, COLUMN_NAME, GRANTOR, PRIVILEGE, GRANTABLE)
as
select ue.name, o.name, c.name, ur.name, tpm.name, 
       decode(oa.option$, 1, 'YES', 'NO')
from sys.objauth$ oa, sys.obj$ o, sys.user$ ue, sys.user$ ur,
     sys.col$ c, table_privilege_map tpm
where oa.obj# = o.obj#
  and oa.grantor# = ur.user#
  and oa.grantee# = ue.user#
  and oa.obj# = c.obj#
  and oa.col# = c.col#
  and bitand(c.property, 32) = 0 /* not hidden column */
  and oa.col# is not null
  and oa.privilege# = tpm.privilege
  and o.owner# = userenv('SCHEMAID')
/
comment on table USER_COL_PRIVS_MADE is
'All grants on columns of objects owned by the user'
/
comment on column USER_COL_PRIVS_MADE.GRANTEE is
'Name of the user to whom access was granted'
/
comment on column USER_COL_PRIVS_MADE.TABLE_NAME is
'Name of the object'
/
comment on column USER_COL_PRIVS_MADE.COLUMN_NAME is
'Name of the column'
/
comment on column USER_COL_PRIVS_MADE.GRANTOR is
'Name of the user who performed the grant'
/
comment on column USER_COL_PRIVS_MADE.PRIVILEGE is
'Column Privilege'
/
comment on column USER_COL_PRIVS_MADE.GRANTABLE is
'Privilege is grantable'
/
drop public synonym USER_COL_PRIVS_MADE
/
create public synonym USER_COL_PRIVS_MADE for USER_COL_PRIVS_MADE
/
grant select on USER_COL_PRIVS_MADE to PUBLIC with grant option
/
create or replace view ALL_COL_PRIVS_MADE
      (GRANTEE, OWNER, TABLE_NAME, COLUMN_NAME, GRANTOR, PRIVILEGE, GRANTABLE)
as
select ue.name, u.name, o.name, c.name, ur.name, tpm.name, 
       decode(oa.option$, 1, 'YES', 'NO')
from sys.objauth$ oa, sys.obj$ o, sys.user$ u, sys.user$ ur, sys.user$ ue,
     sys.col$ c, table_privilege_map tpm
where oa.obj# = o.obj#
  and oa.grantor# = ur.user#
  and oa.grantee# = ue.user#
  and u.user# = o.owner#
  and oa.obj# = c.obj#
  and oa.col# = c.col#
  and bitand(c.property, 32) = 0 /* not hidden column */
  and oa.col# is not null
  and oa.privilege# = tpm.privilege
  and userenv('SCHEMAID') in (o.owner#, oa.grantor#)
/
comment on table ALL_COL_PRIVS_MADE is
'Grants on columns for which the user is owner or grantor'
/
comment on column ALL_COL_PRIVS_MADE.GRANTEE is
'Name of the user to whom access was granted'
/
comment on column ALL_COL_PRIVS_MADE.OWNER is
'Username of the owner of the object'
/
comment on column ALL_COL_PRIVS_MADE.TABLE_NAME is
'Name of the object'
/
comment on column ALL_COL_PRIVS_MADE.COLUMN_NAME is
'Name of the column'
/
comment on column ALL_COL_PRIVS_MADE.GRANTOR is
'Name of the user who performed the grant'
/
comment on column ALL_COL_PRIVS_MADE.PRIVILEGE is
'Column Privilege'
/
comment on column ALL_COL_PRIVS_MADE.GRANTABLE is
'Privilege is grantable'
/
drop public synonym ALL_COL_PRIVS_MADE
/
create public synonym ALL_COL_PRIVS_MADE for ALL_COL_PRIVS_MADE
/
grant select on ALL_COL_PRIVS_MADE to PUBLIC with grant option
/
remark
remark  FAMILY "COL_PRIVS_RECD"
remark  Received grants on columns
remark
create or replace view USER_COL_PRIVS_RECD
      (OWNER, TABLE_NAME, COLUMN_NAME, GRANTOR, PRIVILEGE, GRANTABLE)
as
select u.name, o.name, c.name, ur.name, tpm.name, 
       decode(oa.option$, 1, 'YES', 'NO')
from sys.objauth$ oa, sys.obj$ o, sys.user$ u, sys.user$ ur,
     sys.col$ c, table_privilege_map tpm
where oa.obj# = o.obj#
  and oa.grantor# = ur.user#
  and u.user# = o.owner#
  and oa.obj# = c.obj#
  and oa.col# = c.col#
  and bitand(c.property, 32) = 0 /* not hidden column */
  and oa.col# is not null
  and oa.privilege# = tpm.privilege
  and oa.grantee# = userenv('SCHEMAID')
/
comment on table USER_COL_PRIVS_RECD is
'Grants on columns for which the user is the grantee'
/
comment on column USER_COL_PRIVS_RECD.OWNER is
'Username of the owner of the object'
/
comment on column USER_COL_PRIVS_RECD.TABLE_NAME is
'Name of the object'
/
comment on column USER_COL_PRIVS_RECD.COLUMN_NAME is
'Name of the column'
/
comment on column USER_COL_PRIVS_RECD.GRANTOR is
'Name of the user who performed the grant'
/
comment on column USER_COL_PRIVS_RECD.PRIVILEGE is
'Column Privilege'
/
comment on column USER_COL_PRIVS_RECD.GRANTABLE is
'Privilege is grantable'
/
drop public synonym USER_COL_PRIVS_RECD
/
create public synonym USER_COL_PRIVS_RECD for USER_COL_PRIVS_RECD
/
grant select on USER_COL_PRIVS_RECD to PUBLIC with grant option
/
create or replace view ALL_COL_PRIVS_RECD
      (GRANTEE, OWNER, TABLE_NAME, COLUMN_NAME, GRANTOR, PRIVILEGE, GRANTABLE)
as
select ue.name, u.name, o.name, c.name, ur.name, tpm.name, 
       decode(oa.option$, 1, 'YES', 'NO')
from sys.objauth$ oa, sys.obj$ o, sys.user$ u, sys.user$ ur, sys.user$ ue,
     sys.col$ c, table_privilege_map tpm
where oa.obj# = o.obj#
  and oa.grantor# = ur.user#
  and oa.grantee# = ue.user#
  and u.user# = o.owner#
  and oa.obj# = c.obj#
  and oa.col# = c.col#
  and bitand(c.property, 32) = 0 /* not hidden column */
  and oa.col# is not null
  and oa.privilege# = tpm.privilege
  and oa.grantee# in (select kzsrorol from x$kzsro)
/
comment on table ALL_COL_PRIVS_RECD is
'Grants on columns for which the user, PUBLIC or enabled role is the grantee'
/
comment on column ALL_COL_PRIVS_RECD.GRANTEE is
'Name of the user to whom access was granted'
/
comment on column ALL_COL_PRIVS_RECD.OWNER is
'Username of the owner of the object'
/
comment on column ALL_COL_PRIVS_RECD.TABLE_NAME is
'Name of the object'
/
comment on column ALL_COL_PRIVS_RECD.COLUMN_NAME is
'Name of the column'
/
comment on column ALL_COL_PRIVS_RECD.GRANTOR is
'Name of the user who performed the grant'
/
comment on column ALL_COL_PRIVS_RECD.PRIVILEGE is
'Column privilege'
/
comment on column ALL_COL_PRIVS_RECD.GRANTABLE is
'Privilege is grantable'
/
drop public synonym ALL_COL_PRIVS_RECD
/
create public synonym ALL_COL_PRIVS_RECD for ALL_COL_PRIVS_RECD
/
grant select on ALL_COL_PRIVS_RECD to PUBLIC with grant option
/

remark
remark  FAMILY "DATA_FILES"
remark  Information about database files.
remark  This family has a DBA member only.
remark  (we also have added filext$ for compatibility with 7.2 release)
remark
create or replace view DBA_DATA_FILES
    (FILE_NAME, FILE_ID, TABLESPACE_NAME, 
     BYTES, BLOCKS, 
     STATUS, RELATIVE_FNO, AUTOEXTENSIBLE, MAXBYTES, MAXBLOCKS, INCREMENT_BY)
as
select v.name, f.file#, ts.name, 
       ts.blocksize * f.blocks, f.blocks, 
       decode(f.status$, 1, 'INVALID', 2, 'AVAILABLE', 'UNDEFINED'),
       f.relfile#, decode(f.inc, 0, 'NO', 'YES'),
       ts.blocksize * f.maxextend, f.maxextend, f.inc
from sys.file$ f, sys.ts$ ts, sys.v$dbfile v
where v.file# = f.file#
  and f.ts# = ts.ts#
/
drop public synonym DBA_DATA_FILES
/
create public synonym DBA_DATA_FILES for DBA_DATA_FILES
/
grant select on DBA_DATA_FILES to select_catalog_role
/
comment on table DBA_DATA_FILES is
'Information about database files'
/
comment on column DBA_DATA_FILES.FILE_NAME is
'Name of the database file'
/
comment on column DBA_DATA_FILES.FILE_ID is
'ID of the database file'
/
comment on column DBA_DATA_FILES.TABLESPACE_NAME is
'Name of the tablespace to which the file belongs'
/
comment on column DBA_DATA_FILES.BYTES is
'Size of the file in bytes'
/
comment on column DBA_DATA_FILES.BLOCKS is
'Size of the file in ORACLE blocks'
/
comment on column DBA_DATA_FILES.STATUS is
'File status:  "INVALID" or "AVAILABLE"'
/
comment on column DBA_DATA_FILES.RELATIVE_FNO is
'Tablespace-relative file number'
/
comment on column DBA_DATA_FILES.AUTOEXTENSIBLE is
'Autoextensible indicator:  "YES" or "NO"'
/
comment on column DBA_DATA_FILES.MAXBYTES is
'Maximum size of the file in bytes'
/
comment on column DBA_DATA_FILES.MAXBLOCKS is
'Maximum size of the file in ORACLE blocks'
/
comment on column DBA_DATA_FILES.INCREMENT_BY is
'Default increment for autoextension'
/
create or replace view FILEXT$
    (FILE#, MAXEXTEND, INC)
as
select f.file#, f.maxextend, f.inc 
from sys.file$ f where f.inc <> 0
/
comment on table FILEXT$ is
'Information about extensible files'
/
comment on column FILEXT$.FILE# is
'ID of the database file'
/
comment on column FILEXT$.MAXEXTEND is
'Maximum size of the file in ORACLE blocks'
/
comment on column FILEXT$.INC is
'Default increment for autoextension'
/
grant select on FILEXT$ to select_catalog_role
/
remark
remark  FAMILY "DB_LINKS"
remark  All relevant information about database links.
remark
create or replace view USER_DB_LINKS
    (DB_LINK, USERNAME, PASSWORD, HOST, CREATED)
as
select l.name, l.userid, l.password, l.host, l.ctime
from sys.link$ l
where l.owner# = userenv('SCHEMAID')
/
comment on table USER_DB_LINKS is
'Database links owned by the user'
/
comment on column USER_DB_LINKS.DB_LINK is
'Name of the database link'
/
comment on column USER_DB_LINKS.USERNAME is
'Name of user to log on as'
/
comment on column USER_DB_LINKS.PASSWORD is
'Password for logon'
/
comment on column USER_DB_LINKS.HOST is
'SQL*Net string for connect'
/
comment on column USER_DB_LINKS.CREATED is
'Creation time of the database link'
/
drop public synonym USER_DB_LINKS
/
create public synonym USER_DB_LINKS for USER_DB_LINKS
/
grant select on USER_DB_LINKS to PUBLIC with grant option
/
create or replace view ALL_DB_LINKS
    (OWNER, DB_LINK, USERNAME, HOST, CREATED)
as
select u.name, l.name, l.userid, l.host, l.ctime
from sys.link$ l, sys.user$ u
where l.owner# in ( select kzsrorol from x$kzsro )
  and l.owner# = u.user#
/
comment on table ALL_DB_LINKS is
'Database links accessible to the user'
/
comment on column ALL_DB_LINKS.DB_LINK is
'Name of the database link'
/
comment on column ALL_DB_LINKS.USERNAME is
'Name of user to log on as'
/
comment on column ALL_DB_LINKS.HOST is
'SQL*Net string for connect'
/
comment on column ALL_DB_LINKS.CREATED is
'Creation time of the database link'
/
drop public synonym ALL_DB_LINKS
/
create public synonym ALL_DB_LINKS for ALL_DB_LINKS
/
grant select on ALL_DB_LINKS to PUBLIC with grant option
/
create or replace view DBA_DB_LINKS
    (OWNER, DB_LINK, USERNAME, HOST, CREATED)
as
select u.name, l.name, l.userid, l.host, l.ctime
from sys.link$ l, sys.user$ u
where l.owner# = u.user#
/
drop public synonym DBA_DB_LINKS
/
create public synonym DBA_DB_LINKS for DBA_DB_LINKS
/
grant select on DBA_DB_LINKS to select_catalog_role
/
comment on table DBA_DB_LINKS is
'All database links in the database'
/
comment on column DBA_DB_LINKS.DB_LINK is
'Name of the database link'
/
comment on column DBA_DB_LINKS.USERNAME is
'Name of user to log on as'
/
comment on column DBA_DB_LINKS.HOST is
'SQL*Net string for connect'
/
comment on column DBA_DB_LINKS.CREATED is
'Creation time of the database link'
/
remark
remark  VIEW "DICTIONARY"
remark  Online documentation for data dictionary tables and views.
remark  This view exists outside of the family schema.
remark
/* Find the names of public synonyms for views owned by SYS that
have names different from the synonym name.  This allows the user
to see the short-hand synonyms we have created.
*/
create or replace view DICTIONARY
    (TABLE_NAME, COMMENTS)
as
select o.name, c.comment$
from sys.obj$ o, sys.com$ c
where o.obj# = c.obj#(+)
  and c.col# is null
  and o.owner# = 0
  and o.type# = 4
  and (o.name like 'USER%'
       or o.name like 'ALL%'
       or (o.name like 'DBA%'
           and exists
                   (select null
                    from sys.v$enabledprivs
                    where priv_number = -47 /* SELECT ANY TABLE */)
           )
      )
union all
select o.name, c.comment$
from sys.obj$ o, sys.com$ c
where o.obj# = c.obj#(+)
  and o.owner# = 0
  and o.name in ('AUDIT_ACTIONS', 'COLUMN_PRIVILEGES', 'DICTIONARY',
        'DICT_COLUMNS', 'DUAL', 'GLOBAL_NAME', 'INDEX_HISTOGRAM',
        'INDEX_STATS', 'RESOURCE_COST', 'ROLE_ROLE_PRIVS', 'ROLE_SYS_PRIVS',
        'ROLE_TAB_PRIVS', 'SESSION_PRIVS', 'SESSION_ROLES',
        'TABLE_PRIVILEGES','NLS_SESSION_PARAMETERS','NLS_INSTANCE_PARAMETERS',
        'NLS_DATABASE_PARAMETERS')
  and c.col# is null
union all
select so.name, 'Synonym for ' || sy.name
from sys.obj$ ro, sys.syn$ sy, sys.obj$ so
where so.type# = 5
  and ro.linkname is null
  and so.owner# = 1
  and so.obj# = sy.obj#
  and so.name <> sy.name
  and sy.owner = 'SYS'
  and sy.name = ro.name
  and ro.owner# = 0
  and ro.type# = 4
  and (ro.owner# = userenv('SCHEMAID')
       or ro.obj# in
	   (select oa.obj#
	    from sys.objauth$ oa
	    where grantee# in (select kzsrorol from x$kzsro))
       or exists (select null from v$enabledprivs
	          where priv_number in (-45 /* LOCK ANY TABLE */,
			 	        -47 /* SELECT ANY TABLE */,
				        -48 /* INSERT ANY TABLE */,
				        -49 /* UPDATE ANY TABLE */,
				        -50 /* DELETE ANY TABLE */)
                  ))
/
comment on table DICTIONARY is
'Description of data dictionary tables and views'
/
comment on column DICTIONARY.TABLE_NAME is
'Name of the object'
/
comment on column DICTIONARY.COMMENTS is
'Text comment on the object'
/
drop public synonym DICTIONARY
/
create public synonym DICTIONARY for DICTIONARY
/
drop public synonym DICT
/
create public synonym DICT for DICTIONARY
/
grant select on DICTIONARY to PUBLIC with grant option
/
remark
remark  VIEW "DICT_COLUMNS"
remark  Online documentation for columns in data dictionary tables and views.
remark  This view exists outside of the family schema.
remark
/* Find the column comments for public synonyms for views owned by SYS that
have names different from the synonym name.  This allows the user
to see the columns of the short-hand synonyms we have created.
*/
create or replace view DICT_COLUMNS
    (TABLE_NAME, COLUMN_NAME, COMMENTS)
as
select o.name, c.name, co.comment$
from sys.com$ co, sys.col$ c, sys.obj$ o
where o.owner# = 0
  and o.type# = 4
  and (o.name like 'USER%'
       or o.name like 'ALL%'
       or (o.name like 'DBA%'
           and exists
                   (select null
                    from sys.v$enabledprivs
                    where priv_number = -47 /* SELECT ANY TABLE */)
           )
      )
  and o.obj# = c.obj#
  and c.obj# = co.obj#(+)
  and c.col# = co.col#(+)
  and bitand(c.property, 32) = 0 /* not hidden column */
union all
select o.name, c.name, co.comment$
from sys.com$ co, sys.col$ c, sys.obj$ o
where o.owner# = 0
  and o.name in ('AUDIT_ACTIONS','DUAL','DICTIONARY', 'DICT_COLUMNS')
  and o.obj# = c.obj#
  and c.obj# = co.obj#(+)
  and c.col# = co.col#(+)
  and bitand(c.property, 32) = 0 /* not hidden column */
union all
select so.name, c.name, co.comment$
from sys.com$ co,sys.col$ c, sys.obj$ ro, sys.syn$ sy, sys.obj$ so
where so.type# = 5
  and so.owner# = 1
  and so.obj# = sy.obj#
  and so.name <> sy.name
  and sy.owner = 'SYS'
  and sy.name = ro.name
  and ro.owner# = 0
  and ro.type# = 4
  and ro.obj# = c.obj#
  and c.col# = co.col#(+)  
  and bitand(c.property, 32) = 0 /* not hidden column */
  and c.obj# = co.obj#(+)
/
comment on table DICT_COLUMNS is
'Description of columns in data dictionary tables and views'
/
comment on column DICT_COLUMNS.TABLE_NAME is
'Name of the object that contains the column'
/
comment on column DICT_COLUMNS.COLUMN_NAME is
'Name of the column'
/
comment on column DICT_COLUMNS.COMMENTS is
'Text comment on the object'
/
drop public synonym DICT_COLUMNS
/
create public synonym DICT_COLUMNS for DICT_COLUMNS
/
grant select on DICT_COLUMNS to PUBLIC with grant option
/
remark
remark  FAMILY "EXP_OBJECTS"
remark  Objects that have been incrementally exported.
remark  This family has a DBA member only.
remark
create or replace view DBA_EXP_OBJECTS
    (OWNER, OBJECT_NAME, OBJECT_TYPE, CUMULATIVE, INCREMENTAL, EXPORT_VERSION)
as
select u.name, o.name, 
       decode(o.type#, 1, 'INDEX', 2, 'TABLE', 3, 'CLUSTER',
                      4, 'VIEW', 5, 'SYNONYM', 6, 'SEQUENCE', 7, 'PROCEDURE',
                      8, 'FUNCTION', 9, 'PACKAGE', 11, 'PACKAGE BODY', 
		      12, 'TRIGGER', 13, 'TYPE', 14, 'TYPE BODY', 
                      22, 'LIBRARY', 'UNDEFINED'),
       o.ctime, o.itime, o.expid
from sys.incexp o, sys.user$ u
where o.owner# = u.user#
/
drop public synonym DBA_EXP_OBJECTS
/
create public synonym DBA_EXP_OBJECTS for DBA_EXP_OBJECTS
/
grant select on DBA_EXP_OBJECTS to select_catalog_role
/
comment on table DBA_EXP_OBJECTS is
'Objects that have been incrementally exported'
/
comment on column DBA_EXP_OBJECTS.OWNER is
'Owner of exported object'
/ 
comment on column DBA_EXP_OBJECTS.OBJECT_NAME is
'Name of exported object'
/ 
comment on column DBA_EXP_OBJECTS.OBJECT_TYPE is
'Type of exported object'
/ 
comment on column DBA_EXP_OBJECTS.CUMULATIVE is
'Timestamp of last cumulative export'
/ 
comment on column DBA_EXP_OBJECTS.INCREMENTAL is
'Timestamp of last incremental export'
/ 
comment on column DBA_EXP_OBJECTS.EXPORT_VERSION is
'The id of the export session'
/ 
remark
remark  FAMILY "EXP_VERSION"
remark  Version number of last incremental export
remark  This family has a DBA member only.
remark
create or replace view DBA_EXP_VERSION 
    (EXP_VERSION)
as
select o.expid 
from sys.incvid o
/
drop public synonym DBA_EXP_VERSION
/
create public synonym DBA_EXP_VERSION for DBA_EXP_VERSION
/
grant select on DBA_EXP_VERSION to select_catalog_role
/
comment on table DBA_EXP_VERSION is
'Version number of the last export session'
/
comment on column DBA_EXP_VERSION.EXP_VERSION is
'Version number of the last export session'
/
remark
remark  FAMILY "EXP_FILES"
remark  Files created by incremental exports.
remark  This family has a DBA member only.
remark
create or replace view DBA_EXP_FILES 
     (EXP_VERSION, EXP_TYPE, FILE_NAME, USER_NAME, TIMESTAMP)
as
select o.expid, decode(o.exptype, 'X', 'COMPLETE', 'C', 'CUMULATIVE',
                                  'I', 'INCREMENTAL', 'UNDEFINED'),
       o.expfile, o.expuser, o.expdate
from sys.incfil o
/
drop public synonym DBA_EXP_FILES
/
create public synonym DBA_EXP_FILES for DBA_EXP_FILES
/
grant select on DBA_EXP_FILES to select_catalog_role
/
comment on table DBA_EXP_FILES is
'Description of export files'
/
comment on column DBA_EXP_FILES.EXP_VERSION is
'Version number of the export session'
/
comment on column DBA_EXP_FILES.FILE_NAME is
'Name of the export file'
/
comment on column DBA_EXP_FILES.USER_NAME is
'Name of user who executed export'
/
comment on column DBA_EXP_FILES.TIMESTAMP is
'Timestamp of the export session'
/
remark
remark  FAMILY "FREE_SPACE"
remark  Free extents.
remark  This family has no ALL member.
remark
create or replace view USER_FREE_SPACE
    (TABLESPACE_NAME, FILE_ID, BLOCK_ID,
     BYTES, BLOCKS, RELATIVE_FNO)
as
select ts.name, fi.file#, f.block#,
       f.length * ts.blocksize, f.length, f.file#
from sys.fet$ f, sys.ts$ ts, sys.file$ fi
where f.ts# = ts.ts#
  and f.ts# = fi.ts#
  and f.file# = fi.relfile#
  and (ts.ts# in
         (select tsq.ts#
          from sys.tsq$ tsq
          where tsq.user# = userenv('SCHEMAID') and tsq.maxblocks != 0)
       or exists
          (select null
           from sys.v$enabledprivs
           where priv_number = -15 /* UNLIMITED TABLESPACE */)
      )
/
comment on table USER_FREE_SPACE is
'Free extents in tablespaces accessible to the user'
/
comment on column USER_FREE_SPACE.TABLESPACE_NAME is
'Name of the tablespace containing the extent'
/
comment on column USER_FREE_SPACE.FILE_ID is
'ID number of the file containing the extent'
/
comment on column USER_FREE_SPACE.BLOCK_ID is
'Starting block number of the extent'
/
comment on column USER_FREE_SPACE.BYTES is
'Size of the extent in bytes'
/
comment on column USER_FREE_SPACE.BLOCKS is
'Size of the extent in ORACLE blocks'
/
comment on column USER_FREE_SPACE.RELATIVE_FNO is
'Relative number of the file containing the extent'
/
drop public synonym USER_FREE_SPACE
/
create public synonym USER_FREE_SPACE for USER_FREE_SPACE
/
grant select on USER_FREE_SPACE to PUBLIC with grant option
/
create or replace view DBA_FREE_SPACE
    (TABLESPACE_NAME, FILE_ID, BLOCK_ID,
     BYTES, BLOCKS, RELATIVE_FNO)
as
select ts.name, fi.file#, f.block#,
       f.length * ts.blocksize, f.length, f.file#
from sys.fet$ f, sys.ts$ ts, sys.file$ fi
where f.ts# = ts.ts#
  and f.ts# = fi.ts#
  and f.file# = fi.relfile#
/
drop public synonym DBA_FREE_SPACE
/
create public synonym DBA_FREE_SPACE for DBA_FREE_SPACE
/
grant select on DBA_FREE_SPACE to select_catalog_role
/
comment on table DBA_FREE_SPACE is
'Free extents in all tablespaces'
/
comment on column DBA_FREE_SPACE.TABLESPACE_NAME is
'Name of the tablespace containing the extent'
/
comment on column DBA_FREE_SPACE.FILE_ID is
'ID number of the file containing the extent'
/
comment on column DBA_FREE_SPACE.BLOCK_ID is
'Starting block number of the extent'
/
comment on column DBA_FREE_SPACE.BYTES is
'Size of the extent in bytes'
/
comment on column DBA_FREE_SPACE.BLOCKS is
'Size of the extent in ORACLE blocks'
/
comment on column DBA_FREE_SPACE.RELATIVE_FNO is
'Relative number of the file containing the extent'
/
remark
remark  FAMILY "FREE_SPACE_COALESCED"
remark  Free extents which are Coalesced
remark  This family has only DBA member
remark
remark the following view is just used for constructing the main view 
remark
create or replace view DBA_FREE_SPACE_COALESCED_TMP1 as
select ts#, count(*) extents_coalesced, sum(length) blocks_coalesced
from sys.fet$ a 
where not exists (
  select * from sys.fet$ b 
  where b.ts#=a.ts# and
	b.file#=a.file# and
	a.block#=b.block#+b.length)
group by ts#
/
grant select on DBA_FREE_SPACE_COALESCED_TMP1 to select_catalog_role
/
comment on table DBA_FREE_SPACE_COALESCED_TMP1 is
'Coalesced Free Extents for all Tablespaces'
/
comment on column DBA_FREE_SPACE_COALESCED_TMP1.ts# is
'Number of Tablespace'
/
comment on column DBA_FREE_SPACE_COALESCED_TMP1.extents_coalesced is
'Number of Coalesced Free Extents in Tablespace'
/
comment on column DBA_FREE_SPACE_COALESCED_TMP1.blocks_coalesced is
'Total Coalesced Free Oracle Blocks in Tablespace'
/
remark
remark this view is just used for constructing the main view 
remark
create or replace view DBA_FREE_SPACE_COALESCED_TMP2 as
select ts#, count(*) total_extents, sum(length) total_blocks
from sys.fet$ 
group by ts#
/
grant select on DBA_FREE_SPACE_COALESCED_TMP2 to select_catalog_role
/
comment on table DBA_FREE_SPACE_COALESCED_TMP2 is
'Free Extents in Tablespaces'
/
comment on column DBA_FREE_SPACE_COALESCED_TMP2.ts# is
'Number of Tablespace'
/
comment on column DBA_FREE_SPACE_COALESCED_TMP2.total_extents is
'Number of Free Extents in Tablespace'
/
comment on column DBA_FREE_SPACE_COALESCED_TMP2.total_blocks is
'Total Free Blocks in Tablespace'
/
remark
remark MAIN VIEW for this family
remark Free extents which do not have any other free extents before them are
remark considered coalesced. This implies that if there is contiguous free
remark space represented as 5 free extents, then we consider the first of
remark these to be coalesced and the rest 4 to be non coalesced.
remark
create or replace view DBA_FREE_SPACE_COALESCED
    (TABLESPACE_NAME, TOTAL_EXTENTS, EXTENTS_COALESCED, PERCENT_EXTENTS_COALESCED, TOTAL_BYTES, BYTES_COALESCED, TOTAL_BLOCKS, BLOCKS_COALESCED, PERCENT_BLOCKS_COALESCED)
as
select name,total_extents, extents_coalesced, 
       extents_coalesced/total_extents*100,total_blocks*c.blocksize, 
       blocks_coalesced*c.blocksize, total_blocks, blocks_coalesced,
       blocks_coalesced/total_blocks*100
from DBA_FREE_SPACE_COALESCED_TMP1 a, DBA_FREE_SPACE_COALESCED_TMP2 b, sys.ts$ c 
	where a.ts#=b.ts# and a.ts#=c.ts#
/
drop public synonym DBA_FREE_SPACE_COALESCED
/
create public synonym DBA_FREE_SPACE_COALESCED for DBA_FREE_SPACE_COALESCED
/
grant select on DBA_FREE_SPACE_COALESCED to select_catalog_role
/
comment on table DBA_FREE_SPACE_COALESCED is
'Statistics on Coalesced Space in Tablespaces'
/
comment on column DBA_FREE_SPACE_COALESCED.TABLESPACE_NAME is
'Name of Tablespace'
/
comment on column DBA_FREE_SPACE_COALESCED.TOTAL_EXTENTS is
'Total Number of Free Extents in Tablespace'
/
comment on column DBA_FREE_SPACE_COALESCED.EXTENTS_COALESCED is
'Total Number of Coalesced Free Extents in Tablespace'
/
comment on column DBA_FREE_SPACE_COALESCED.PERCENT_EXTENTS_COALESCED is
'Percentage of Coalesced Free Extents in Tablespace'
/
comment on column DBA_FREE_SPACE_COALESCED.TOTAL_BYTES is
'Total Number of Free Bytes in Tablespace'
/
comment on column DBA_FREE_SPACE_COALESCED.BYTES_COALESCED is
'Total Number of Coalesced Free Bytes in Tablespace'
/
comment on column DBA_FREE_SPACE_COALESCED.TOTAL_BLOCKS is
'Total Number of Free Oracle Blocks in Tablespace'
/
comment on column DBA_FREE_SPACE_COALESCED.BLOCKS_COALESCED is
'Total Number of Coalesced Free Oracle Blocks in Tablespace'
/
comment on column DBA_FREE_SPACE_COALESCED.PERCENT_BLOCKS_COALESCED is
'Percentage of Coalesced Free Oracle Blocks in Tablespace'
/
remark
remark  FAMILY "INDEXES"
remark  CREATE INDEX parameters.
remark
create or replace view USER_INDEXES
    (INDEX_NAME,
     INDEX_TYPE,
     TABLE_OWNER, TABLE_NAME,
     TABLE_TYPE,
     UNIQUENESS,
     TABLESPACE_NAME, INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE, PCT_THRESHOLD, INCLUDE_COLUMN,
     FREELISTS, FREELIST_GROUPS, PCT_FREE, LOGGING,
     BLEVEL, LEAF_BLOCKS, DISTINCT_KEYS, AVG_LEAF_BLOCKS_PER_KEY,
     AVG_DATA_BLOCKS_PER_KEY, CLUSTERING_FACTOR, STATUS, 
     NUM_ROWS, SAMPLE_SIZE, LAST_ANALYZED, DEGREE, INSTANCES, PARTITIONED,
     TEMPORARY, GENERATED, BUFFER_POOL)
as
select o.name,
       decode(i.type#, 1, 'NORMAL', 2, 'BITMAP', 3, 'CLUSTER', 4, 'IOT - TOP',
	              5, 'IOT - NESTED', 6, 'SECONDARY', 7, 'ANSI', 8, 'LOB'),
       iu.name, io.name,
       decode(io.type#, 0, 'NEXT OBJECT', 1, 'INDEX', 2, 'TABLE', 3, 'CLUSTER',
                       4, 'VIEW', 5, 'SYNONYM', 6, 'SEQUENCE', 'UNDEFINED'),
       decode(bitand(i.property, 1), 0, 'NONUNIQUE', 1, 'UNIQUE', 'UNDEFINED'),
       decode(bitand(i.property, 2),2, null, ts.name),
       to_number(decode(bitand(i.property, 2),2, null, i.initrans)), 
       to_number(decode(bitand(i.property, 2),2, null, i.maxtrans)),
       s.iniexts * ts.blocksize, s.extsize * ts.blocksize,
       s.minexts, s.maxexts, s.extpct, i.pctthres$, i.trunccnt,  
       decode(s.lists, 0, 1, s.lists), 
       decode(s.groups, 0, 1, s.groups), 
       decode(bitand(i.property, 2),0,i.pctfree$,null),
       decode(bitand(i.property, 2), 2, NULL, 
	        decode(bitand(i.flags, 4), 0, 'YES', 'NO')),
       i.blevel, i.leafcnt, i.distkey, i.lblkkey, i.dblkkey, i.clufac,
       decode(bitand(i.property, 2), 2, 'N/A',
	      decode(bitand(i.flags, 1), 1, 'UNUSABLE', 'VALID')),
       rowcnt, samplesize, analyzetime, 
       decode(i.degree, 32767, 'DEFAULT', nvl(i.degree,1)),
       decode(i.instances, 32767, 'DEFAULT', nvl(i.instances,1)),
       decode(bitand(i.property, 2), 2, 'YES', 'NO'),
       decode(bitand(o.flags, 2), 0, 'N', 2, 'Y', 'N'),
       decode(bitand(o.flags, 4), 0, 'N', 4, 'Y', 'N'),
       decode(s.cachehint, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from sys.ts$ ts, sys.seg$ s, sys.user$ iu, sys.obj$ io, sys.ind$ i, sys.obj$ o
where o.owner# = userenv('SCHEMAID')
  and o.obj# = i.obj#
  and i.bo# = io.obj#
  and io.owner# = iu.user#
  and i.ts# = ts.ts# (+)
  and i.file# = s.file# (+)
  and i.block# = s.block# (+)
  and i.ts# = s.ts# (+)
  and i.type# in (1, 2, 3, 4, 6, 7, 8)
/
comment on table USER_INDEXES is
'Description of the user''s own indexes'
/
comment on column USER_INDEXES.STATUS is
'Whether the non-partitioned index is in USABLE or not'
/
comment on column USER_INDEXES.INDEX_NAME is
'Name of the index'
/
comment on column USER_INDEXES.TABLE_OWNER is
'Owner of the indexed object'
/
comment on column USER_INDEXES.TABLE_NAME is
'Name of the indexed object'
/
comment on column USER_INDEXES.TABLE_TYPE is
'Type of the indexed object'
/
comment on column USER_INDEXES.UNIQUENESS is
'Uniqueness status of the index:  "UNIQUE",  "NONUNIQUE", or "BITMAP"'
/
comment on column USER_INDEXES.TABLESPACE_NAME is
'Name of the tablespace containing the index'
/
comment on column USER_INDEXES.INI_TRANS is
'Initial number of transactions'
/
comment on column USER_INDEXES.MAX_TRANS is
'Maximum number of transactions'
/
comment on column USER_INDEXES.INITIAL_EXTENT is
'Size of the initial extent in bytes'
/
comment on column USER_INDEXES.NEXT_EXTENT is
'Size of secondary extents in bytes'
/
comment on column USER_INDEXES.MIN_EXTENTS is
'Minimum number of extents allowed in the segment'
/
comment on column USER_INDEXES.MAX_EXTENTS is
'Maximum number of extents allowed in the segment'
/
comment on column USER_INDEXES.PCT_INCREASE is
'Percentage increase in extent size'
/
comment on column USER_INDEXES.PCT_THRESHOLD is
'Threshold percentage of block space allowed per index entry'
/
comment on column USER_INDEXES.INCLUDE_COLUMN is
'User column-id for last column to be included in index-only table top index'
/
comment on column USER_INDEXES.FREELISTS is
'Number of process freelists allocated in this segment'
/
comment on column USER_INDEXES.FREELIST_GROUPS is
'Number of freelist groups allocated to this segment'
/
comment on column USER_INDEXES.PCT_FREE is
'Minimum percentage of free space in a block'
/
comment on column USER_INDEXES.LOGGING is
'Logging attribute'
/
comment on column USER_INDEXES.BLEVEL is
'B-Tree level'
/
comment on column USER_INDEXES.LEAF_BLOCKS is
'The number of leaf blocks in the index'
/
comment on column USER_INDEXES.DISTINCT_KEYS is
'The number of distinct keys in the index'
/
comment on column USER_INDEXES.AVG_LEAF_BLOCKS_PER_KEY is
'The average number of leaf blocks per key'
/
comment on column USER_INDEXES.AVG_DATA_BLOCKS_PER_KEY is
'The average number of data blocks per key'
/
comment on column USER_INDEXES.CLUSTERING_FACTOR is
'A measurement of the amount of (dis)order of the table this index is for'
/
comment on column USER_INDEXES.NUM_ROWS is
'Number of rows in the index'
/
comment on column USER_INDEXES.SAMPLE_SIZE is
'The sample size used in analyzing this index'
/
comment on column USER_INDEXES.LAST_ANALYZED is
'The date of the most recent time this index was analyzed'
/
comment on column USER_INDEXES.DEGREE is
'The number of threads per instance for scanning the partitioned index'
/
comment on column USER_INDEXES.INSTANCES is
'The number of instances across which the partitioned index is to be scanned'
/
comment on column USER_INDEXES.PARTITIONED is
'Is this index partitioned? YES or NO'
/
comment on column USER_INDEXES.TEMPORARY is
'Can the current session only see data that it place in this object itself?'
/
comment on column USER_INDEXES.GENERATED is
'Was the name of this index system generated?'
/
comment on column USER_INDEXES.BUFFER_POOL is
'The default buffer pool to be used for index blocks'
/
drop public synonym USER_INDEXES
/
create public synonym USER_INDEXES for USER_INDEXES
/
drop public synonym IND
/
create public synonym IND for USER_INDEXES
/
grant select on USER_INDEXES to PUBLIC with grant option
/
remark
remark  This view does not include cluster indexes on clusters
remark  containing tables which are accessible to the user.
remark
create or replace view ALL_INDEXES
    (OWNER, INDEX_NAME, 
     INDEX_TYPE,
     TABLE_OWNER, TABLE_NAME,
     TABLE_TYPE,
     UNIQUENESS,
     TABLESPACE_NAME, INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,
     PCT_THRESHOLD, INCLUDE_COLUMN,
     FREELISTS,  FREELIST_GROUPS, PCT_FREE, LOGGING, 
     BLEVEL, LEAF_BLOCKS, DISTINCT_KEYS, AVG_LEAF_BLOCKS_PER_KEY,
     AVG_DATA_BLOCKS_PER_KEY, CLUSTERING_FACTOR, STATUS, 
     NUM_ROWS, SAMPLE_SIZE, LAST_ANALYZED, DEGREE, INSTANCES, PARTITIONED,
     TEMPORARY, GENERATED, BUFFER_POOL)
 as 
select u.name, o.name, 
       decode(i.type#, 1, 'NORMAL', 2, 'BITMAP', 3, 'CLUSTER', 4, 'IOT - TOP',
	              5, 'IOT - NESTED', 6, 'SECONDARY', 7, 'ANSI', 8, 'LOB'),
       iu.name, io.name, 'TABLE',
       decode(bitand(i.property, 1), 0, 'NONUNIQUE', 1, 'UNIQUE', 'UNDEFINED'),
       decode(bitand(i.property, 2),0, ts.name, null),
       decode(bitand(i.property, 2),0, i.initrans, null), 
       decode(bitand(i.property, 2),0, i.maxtrans, null),
       s.iniexts * ts.blocksize, s.extsize * ts.blocksize, 
       s.minexts, s.maxexts, s.extpct, i.pctthres$, i.trunccnt, 
       decode(s.lists, 0, 1, s.lists), 
       decode(s.groups, 0, 1, s.groups), 
       decode(bitand(i.property, 2),0,i.pctfree$,null),
       decode(bitand(i.property, 2), 2, NULL, 
	        decode(bitand(i.flags, 4), 0, 'YES', 'NO')),
       i.blevel, i.leafcnt, i.distkey, i.lblkkey, i.dblkkey, i.clufac,
       decode(bitand(i.property, 2), 2, 'N/A',
	      decode(bitand(i.flags, 1), 1, 'UNUSABLE', 'VALID')),
       rowcnt, samplesize, analyzetime, 
       decode(i.degree, 32767, 'DEFAULT', nvl(i.degree,1)),
       decode(i.instances, 32767, 'DEFAULT', nvl(i.instances,1)),
       decode(bitand(i.property, 2), 2, 'YES', 'NO'),
       decode(bitand(o.flags, 2), 0, 'N', 2, 'Y', 'N'),
       decode(bitand(o.flags, 4), 0, 'N', 4, 'Y', 'N'),
       decode(s.cachehint, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from sys.ts$ ts, sys.seg$ s, sys.user$ iu, sys.obj$ io, 
     sys.user$ u, sys.ind$ i, sys.obj$ o
where u.user# = o.owner#
  and o.obj# = i.obj#
  and i.bo# = io.obj#
  and io.owner# = iu.user# 
  and io.type# = 2 /* tables */
  and i.ts# = ts.ts# (+)
  and i.file# = s.file# (+)
  and i.block# = s.block# (+)
  and i.ts# = s.ts# (+)
  and i.type# in (1, 2, 3, 4, 6, 7)
  and (io.owner# = userenv('SCHEMAID')
        or
       io.obj# in ( select obj#
                    from objauth$
                    where grantee# in ( select kzsrorol
                                        from x$kzsro
                                      )
                   )
        or
	 exists (select null from v$enabledprivs
	         where priv_number in (-45 /* LOCK ANY TABLE */,
				       -47 /* SELECT ANY TABLE */,
				       -48 /* INSERT ANY TABLE */,
				       -49 /* UPDATE ANY TABLE */,
				       -50 /* DELETE ANY TABLE */)
                 )
       )
/
comment on table ALL_INDEXES is
'Descriptions of indexes on tables accessible to the user'
/
comment on column ALL_INDEXES.OWNER is
'Username of the owner of the index'
/
comment on column ALL_INDEXES.STATUS is
'Whether the non-partitioned index is in USABLE or not'
/
comment on column ALL_INDEXES.INDEX_NAME is
'Name of the index'
/
comment on column ALL_INDEXES.TABLE_OWNER is
'Owner of the indexed object'
/
comment on column ALL_INDEXES.TABLE_NAME is
'Name of the indexed object'
/
comment on column ALL_INDEXES.TABLE_TYPE is
'Type of the indexed object'
/
comment on column ALL_INDEXES.UNIQUENESS is
'Uniqueness status of the index: "UNIQUE",  "NONUNIQUE", or "BITMAP"'
/
comment on column ALL_INDEXES.TABLESPACE_NAME is
'Name of the tablespace containing the index'
/
comment on column ALL_INDEXES.INI_TRANS is
'Initial number of transactions'
/
comment on column ALL_INDEXES.MAX_TRANS is
'Maximum number of transactions'
/
comment on column ALL_INDEXES.INITIAL_EXTENT is
'Size of the initial extent'
/
comment on column ALL_INDEXES.NEXT_EXTENT is
'Size of secondary extents'
/
comment on column ALL_INDEXES.MIN_EXTENTS is
'Minimum number of extents allowed in the segment'
/
comment on column ALL_INDEXES.MAX_EXTENTS is
'Maximum number of extents allowed in the segment'
/
comment on column ALL_INDEXES.PCT_INCREASE is
'Percentage increase in extent size'
/
comment on column ALL_INDEXES.PCT_THRESHOLD is
'Threshold percentage of block space allowed per index entry'
/
comment on column ALL_INDEXES.INCLUDE_COLUMN is
'User column-id for last column to be included in index-only table top index'
/
comment on column ALL_INDEXES.FREELISTS is
'Number of process freelists allocated in this segment'
/
comment on column ALL_INDEXES.FREELIST_GROUPS is
'Number of freelist groups allocated to this segment'
/
comment on column ALL_INDEXES.PCT_FREE is
'Minimum percentage of free space in a block'
/
comment on column ALL_INDEXES.LOGGING is
'Logging attribute'
/
comment on column ALL_INDEXES.BLEVEL is
'B-Tree level'
/
comment on column ALL_INDEXES.LEAF_BLOCKS is
'The number of leaf blocks in the index'
/
comment on column ALL_INDEXES.DISTINCT_KEYS is
'The number of distinct keys in the index'
/
comment on column ALL_INDEXES.AVG_LEAF_BLOCKS_PER_KEY is
'The average number of leaf blocks per key'
/
comment on column ALL_INDEXES.AVG_DATA_BLOCKS_PER_KEY is
'The average number of data blocks per key'
/
comment on column ALL_INDEXES.CLUSTERING_FACTOR is
'A measurement of the amount of (dis)order of the table this index is for'
/
comment on column ALL_INDEXES.SAMPLE_SIZE is
'The sample size used in analyzing this index'
/
comment on column ALL_INDEXES.LAST_ANALYZED is
'The date of the most recent time this index was analyzed'
/
comment on column ALL_INDEXES.DEGREE is
'The number of threads per instance for scanning the partitioned index'
/
comment on column ALL_INDEXES.INSTANCES is
'The number of instances across which the partitioned index is to be scanned'
/
comment on column ALL_INDEXES.PARTITIONED is
'Is this index partitioned? YES or NO'
/
comment on column ALL_INDEXES.TEMPORARY is
'Can the current session only see data that it place in this object itself?'
/
comment on column ALL_INDEXES.GENERATED is
'Was the name of this index system generated?'
/
comment on column ALL_INDEXES.BUFFER_POOL is
'The default buffer pool to be used for index blocks'
/
drop public synonym ALL_INDEXES
/
create public synonym ALL_INDEXES for ALL_INDEXES
/
grant select on ALL_INDEXES to PUBLIC with grant option
/
create or replace view DBA_INDEXES
    (OWNER, INDEX_NAME,
     INDEX_TYPE,
     TABLE_OWNER, TABLE_NAME,
     TABLE_TYPE,
     UNIQUENESS,
     TABLESPACE_NAME, INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE, PCT_THRESHOLD, INCLUDE_COLUMN,
     FREELISTS, FREELIST_GROUPS, PCT_FREE, LOGGING, BLEVEL,
     LEAF_BLOCKS, DISTINCT_KEYS, AVG_LEAF_BLOCKS_PER_KEY,
     AVG_DATA_BLOCKS_PER_KEY, CLUSTERING_FACTOR, STATUS, 
     NUM_ROWS, SAMPLE_SIZE, LAST_ANALYZED, DEGREE, INSTANCES, PARTITIONED,
     TEMPORARY, GENERATED, BUFFER_POOL)
as
select u.name, o.name,
       decode(i.type#, 1, 'NORMAL', 2, 'BITMAP', 3, 'CLUSTER', 4, 'IOT - TOP',
	              5, 'IOT - NESTED', 6, 'SECONDARY', 7, 'ANSI', 8, 'LOB'),
       iu.name, io.name,
       decode(io.type#, 0, 'NEXT OBJECT', 1, 'INDEX', 2, 'TABLE', 3, 'CLUSTER',
                       4, 'VIEW', 5, 'SYNONYM', 6, 'SEQUENCE', 'UNDEFINED'),
       decode(bitand(i.property, 1), 0, 'NONUNIQUE', 1, 'UNIQUE', 'UNDEFINED'),
       decode(bitand(i.property, 2),0, ts.name, null),
       decode(bitand(i.property, 2),0, i.initrans, null), 
       decode(bitand(i.property, 2),0, i.maxtrans, null),
       s.iniexts * ts.blocksize, s.extsize * ts.blocksize,
       s.minexts, s.maxexts, s.extpct, i.pctthres$, i.trunccnt,
       decode(s.lists, 0, 1, s.lists), 
       decode(s.groups, 0, 1, s.groups),
       decode(bitand(i.property, 2),0,i.pctfree$,null),
       decode(bitand(i.property, 2), 2, NULL, 
	        decode(bitand(i.flags, 4), 0, 'YES', 'NO')),
       i.blevel, i.leafcnt, i.distkey, i.lblkkey, i.dblkkey, i.clufac,
       decode(bitand(i.property, 2), 2, 'N/A',
	      decode(bitand(i.flags, 1), 1, 'UNUSABLE', 'VALID')),
       rowcnt, samplesize, analyzetime, 
       decode(i.degree, 32767, 'DEFAULT', nvl(i.degree,1)),
       decode(i.instances, 32767, 'DEFAULT', nvl(i.instances,1)),       
       decode(bitand(i.property, 2), 2, 'YES', 'NO'),
       decode(bitand(o.flags, 2), 0, 'N', 2, 'Y', 'N'),
       decode(bitand(o.flags, 4), 0, 'N', 4, 'Y', 'N'),
       decode(s.cachehint, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from sys.ts$ ts, sys.seg$ s,
     sys.user$ iu, sys.obj$ io, sys.user$ u, sys.ind$ i, sys.obj$ o
where u.user# = o.owner#
  and o.obj# = i.obj#
  and i.bo# = io.obj#
  and io.owner# = iu.user#
  and i.ts# = ts.ts# (+)
  and i.file# = s.file# (+)
  and i.block# = s.block# (+)
  and i.ts# = s.ts# (+)
/
drop public synonym DBA_INDEXES
/
create public synonym DBA_INDEXES for DBA_INDEXES
/
grant select on DBA_INDEXES to select_catalog_role
/
comment on table DBA_INDEXES is
'Description for all indexes in the database'
/
comment on column DBA_INDEXES.STATUS is
'Whether non-partitioned index is in UNUSABLE state or not'
/
comment on column DBA_INDEXES.OWNER is
'Username of the owner of the index'
/
comment on column DBA_INDEXES.INDEX_NAME is
'Name of the index'
/
comment on column DBA_INDEXES.TABLE_OWNER is
'Owner of the indexed object'
/
comment on column DBA_INDEXES.TABLE_NAME is
'Name of the indexed object'
/
comment on column DBA_INDEXES.TABLE_TYPE is
'Type of the indexed object'
/
comment on column DBA_INDEXES.UNIQUENESS is
'Uniqueness status of the index: "UNIQUE",  "NONUNIQUE", or "BITMAP"'
/
comment on column DBA_INDEXES.TABLESPACE_NAME is
'Name of the tablespace containing the index'
/
comment on column DBA_INDEXES.INI_TRANS is
'Initial number of transactions'
/
comment on column DBA_INDEXES.MAX_TRANS is
'Maximum number of transactions'
/
comment on column DBA_INDEXES.INITIAL_EXTENT is
'Size of the initial extent'
/
comment on column DBA_INDEXES.NEXT_EXTENT is
'Size of secondary extents'
/
comment on column DBA_INDEXES.MIN_EXTENTS is
'Minimum number of extents allowed in the segment'
/
comment on column DBA_INDEXES.MAX_EXTENTS is
'Maximum number of extents allowed in the segment'
/
comment on column DBA_INDEXES.PCT_INCREASE is
'Percentage increase in extent size'
/
comment on column DBA_INDEXES.PCT_THRESHOLD is
'Threshold percentage of block space allowed per index entry'
/
comment on column DBA_INDEXES.INCLUDE_COLUMN is
'User column-id for last column to be included in index-only table top index'
/
comment on column DBA_INDEXES.FREELISTS is
'Number of process freelists allocated in this segment'
/
comment on column DBA_INDEXES.FREELIST_GROUPS is
'Number of freelist groups allocated to this segment'
/
comment on column DBA_INDEXES.PCT_FREE is
'Minimum percentage of free space in a block'
/
comment on column DBA_INDEXES.LOGGING is
'Logging attribute'
/
comment on column DBA_INDEXES.BLEVEL is
'B-Tree level'
/
comment on column DBA_INDEXES.LEAF_BLOCKS is
'The number of leaf blocks in the index'
/
comment on column DBA_INDEXES.DISTINCT_KEYS is
'The number of distinct keys in the index'
/
comment on column DBA_INDEXES.AVG_LEAF_BLOCKS_PER_KEY is
'The average number of leaf blocks per key'
/
comment on column DBA_INDEXES.AVG_DATA_BLOCKS_PER_KEY is
'The average number of data blocks per key'
/
comment on column DBA_INDEXES.CLUSTERING_FACTOR is
'A measurement of the amount of (dis)order of the table this index is for'
/
comment on column DBA_INDEXES.SAMPLE_SIZE is
'The sample size used in analyzing this index'
/
comment on column DBA_INDEXES.LAST_ANALYZED is
'The date of the most recent time this index was analyzed'
/
comment on column DBA_INDEXES.DEGREE is
'The number of threads per instance for scanning the partitioned index'
/
comment on column DBA_INDEXES.INSTANCES is
'The number of instances across which the partitioned index is to be scanned'
/
comment on column DBA_INDEXES.PARTITIONED is
'Is this index partitioned? YES or NO'
/
comment on column DBA_INDEXES.TEMPORARY is
'Can the current session only see data that it place in this object itself?'
/
comment on column DBA_INDEXES.GENERATED is
'Was the name of this index system generated?'
/
comment on column DBA_INDEXES.BUFFER_POOL is
'The default buffer pool to be used for index blocks'
/

remark
remark  FAMILY "IND_COLUMNS"
remark  Displays information on which columns are contained in which
remark  indexes
remark
create or replace view USER_IND_COLUMNS
    (INDEX_NAME, TABLE_NAME, COLUMN_NAME, COLUMN_POSITION, COLUMN_LENGTH)
as
select idx.name, base.name, 
       decode(bitand(c.property, 1), 1, ac.name, c.name), ic.pos#, c.length
from sys.col$ c, sys.obj$ idx, sys.obj$ base, sys.icol$ ic, sys.ind$ i,
       sys.attrcol$ ac
where base.obj# = c.obj#
  and ic.bo# = base.obj#
  and ic.intcol# = c.intcol#
  and (base.owner# = userenv('SCHEMAID') or idx.owner# = userenv('SCHEMAID'))
  and ic.obj# = idx.obj#
  and idx.obj# = i.obj#
  and i.type# in (1, 2, 3, 4, 6, 7)
  and c.obj# = ac.obj#(+)
  and c.intcol# = ac.intcol#(+)
/
comment on table USER_IND_COLUMNS is
'COLUMNs comprising user''s INDEXes or on user''s TABLES'
/
comment on column USER_IND_COLUMNS.INDEX_NAME is
'Index name'
/
comment on column USER_IND_COLUMNS.TABLE_NAME is
'Table or cluster name'
/
comment on column USER_IND_COLUMNS.COLUMN_NAME is
'Column name or attribute of object column'
/
comment on column USER_IND_COLUMNS.COLUMN_POSITION is
'Position of column or attribute within index'
/
comment on column USER_IND_COLUMNS.COLUMN_LENGTH is
'Indexed length of the column or attribute'
/
drop public synonym USER_IND_COLUMNS
/
create public synonym USER_IND_COLUMNS for USER_IND_COLUMNS
/
grant select on USER_IND_COLUMNS to PUBLIC with grant option
/
create or replace view ALL_IND_COLUMNS
    (INDEX_OWNER, INDEX_NAME,
     TABLE_OWNER, TABLE_NAME,
     COLUMN_NAME, COLUMN_POSITION, COLUMN_LENGTH)
as
select io.name, idx.name, bo.name, base.name, 
       decode(bitand(c.property, 1), 1, ac.name, c.name), ic.pos#, c.length
from sys.col$ c, sys.obj$ idx, sys.obj$ base, sys.icol$ ic,
     sys.user$ io, sys.user$ bo, sys.ind$ i, sys.attrcol$ ac
where base.obj# = c.obj#
  and ic.intcol# = c.intcol#
  and ic.bo# = base.obj#
  and io.user# = idx.owner#
  and bo.user# = base.owner#
  and ic.obj# = idx.obj#
  and idx.obj# = i.obj#
  and i.type# in (1, 2, 3, 4, 6, 7)
  and c.obj# = ac.obj#(+)
  and c.intcol# = ac.intcol#(+)
  and (idx.owner# = userenv('SCHEMAID') or
       base.owner# = userenv('SCHEMAID')
       or
       base.obj# in ( select obj#
                     from sys.objauth$
                     where grantee# in ( select kzsrorol
                                         from x$kzsro
                                       )
                   )
        or
	 exists (select null from v$enabledprivs
	         where priv_number in (-45 /* LOCK ANY TABLE */,
				       -47 /* SELECT ANY TABLE */,
				       -48 /* INSERT ANY TABLE */,
				       -49 /* UPDATE ANY TABLE */,
				       -50 /* DELETE ANY TABLE */)
                 )
       )
/
comment on table ALL_IND_COLUMNS is
'COLUMNs comprising INDEXes on accessible TABLES'
/
comment on column ALL_IND_COLUMNS.INDEX_OWNER is
'Index owner'
/
comment on column ALL_IND_COLUMNS.INDEX_NAME is
'Index name'
/
comment on column ALL_IND_COLUMNS.TABLE_OWNER is
'Table or cluster owner'
/
comment on column ALL_IND_COLUMNS.TABLE_NAME is
'Table or cluster name'
/
comment on column ALL_IND_COLUMNS.COLUMN_NAME is
'Column name or attribute of object column'
/
comment on column ALL_IND_COLUMNS.COLUMN_POSITION is
'Position of column or attribute within index'
/
comment on column ALL_IND_COLUMNS.COLUMN_LENGTH is
'Indexed length of the column or attribute'
/
drop public synonym ALL_IND_COLUMNS
/
create public synonym ALL_IND_COLUMNS for ALL_IND_COLUMNS
/
grant select on ALL_IND_COLUMNS to PUBLIC with grant option
/
create or replace view DBA_IND_COLUMNS
    (INDEX_OWNER, INDEX_NAME,
     TABLE_OWNER, TABLE_NAME,
     COLUMN_NAME, COLUMN_POSITION, COLUMN_LENGTH)
as
select io.name, idx.name, bo.name, base.name, 
       decode(bitand(c.property, 1), 1, ac.name, c.name), ic.pos#, c.length
from sys.col$ c, sys.obj$ idx, sys.obj$ base, sys.icol$ ic,
     sys.user$ io, sys.user$ bo, sys.ind$ i, sys.attrcol$ ac
where base.obj# = c.obj#
  and ic.intcol# = c.intcol#
  and ic.bo# = base.obj#
  and io.user# = idx.owner#
  and bo.user# = base.owner#
  and ic.obj# = idx.obj#
  and idx.obj# = i.obj#
  and i.type# in (1, 2, 3, 4, 6, 7)
  and c.obj# = ac.obj#(+)
  and c.intcol# = ac.intcol#(+)
/
drop public synonym DBA_IND_COLUMNS
/
create public synonym DBA_IND_COLUMNS for DBA_IND_COLUMNS
/
grant select on DBA_IND_COLUMNS to select_catalog_role
/
comment on table DBA_IND_COLUMNS is
'COLUMNs comprising INDEXes on all TABLEs and CLUSTERs'
/
comment on column DBA_IND_COLUMNS.INDEX_OWNER is
'Index owner'
/
comment on column DBA_IND_COLUMNS.INDEX_NAME is
'Index name'
/
comment on column DBA_IND_COLUMNS.TABLE_OWNER is
'Table or cluster owner'
/
comment on column DBA_IND_COLUMNS.TABLE_NAME is
'Table or cluster name'
/
comment on column DBA_IND_COLUMNS.COLUMN_NAME is
'Column name or attribute of object column'
/
comment on column DBA_IND_COLUMNS.COLUMN_POSITION is
'Position of column or attribute within index'
/
comment on column DBA_IND_COLUMNS.COLUMN_LENGTH is
'Indexed length of the column or attribute'
/
create or replace view INDEX_STATS as
 select	kdxstrot+1	height, 
	s.blocks,
	o.name, 
        o.subname       partition_name,
       	kdxstlrw 	lf_rows,
	kdxstlbk	lf_blks,
	kdxstlln	lf_rows_len,
	kdxstlub	lf_blk_len,
       	kdxstbrw 	br_rows,
	kdxstbbk	br_blks,
	kdxstbln	br_rows_len,
	kdxstbub	br_blk_len,
	kdxstdrw	del_lf_rows,
	kdxstdln	del_lf_rows_len,
	kdxstdis	distinct_keys,
	kdxstmrl	most_repeated_key,
	kdxstlbk*kdxstlub+kdxstbbk*kdxstbub	btree_space,
	kdxstlln+kdxstbln			used_space,
	ceil(((kdxstlln+kdxstbln)*100)/
	(kdxstlbk*kdxstlub+kdxstbbk*kdxstbub))
						pct_used,	
	kdxstlrw/decode(kdxstdis, 0, 1, kdxstdis) rows_per_key,
	kdxstrot+1+(kdxstlrw+kdxstdis)/(decode(kdxstdis, 0, 1, kdxstdis)*2)
						blks_gets_per_access
  from obj$ o, ind$ i, seg$ s, x$kdxst
 where kdxstfil = s.file#
  and  kdxstblk = s.block#
  and  kdxsttsn = s.ts#
  and  s.file#  = i.file#
  and  s.block# = i.block#
  and  s.ts# = i.ts#
  and  i.obj#   = o.obj#
union all
 select	kdxstrot+1	height, 
	s.blocks,
	o.name, 
        o.subname       partition_name,
       	kdxstlrw 	lf_rows,
	kdxstlbk	lf_blks,
	kdxstlln	lf_rows_len,
	kdxstlub	lf_blk_len,
       	kdxstbrw 	br_rows,
	kdxstbbk	br_blks,
	kdxstbln	br_rows_len,
	kdxstbub	br_blk_len,
	kdxstdrw	del_lf_rows,
	kdxstdln	del_lf_rows_len,
	kdxstdis	distinct_keys,
	kdxstmrl	most_repeated_key,
	kdxstlbk*kdxstlub+kdxstbbk*kdxstbub	btree_space,
	kdxstlln+kdxstbln			used_space,
	ceil(((kdxstlln+kdxstbln)*100)/
	(kdxstlbk*kdxstlub+kdxstbbk*kdxstbub))
						pct_used,	
	kdxstlrw/decode(kdxstdis, 0, 1, kdxstdis) rows_per_key,
	kdxstrot+1+(kdxstlrw+kdxstdis)/(decode(kdxstdis, 0, 1, kdxstdis)*2)
						blks_gets_per_access
  from obj$ o, seg$ s, indpart$ ip, x$kdxst
 where kdxstfil = s.file#
  and  kdxstblk = s.block#
  and  kdxsttsn = s.ts#
  and  s.file#  = ip.file#
  and  s.block# = ip.block#
  and  s.ts#    = ip.ts#
  and  ip.obj#  = o.obj#
/
comment on table INDEX_STATS is
'statistics on the b-tree'
/
comment on column index_stats.height is 
'height of the b-tree'
/
comment on column index_stats.blocks is
'blocks allocated to the segment'
/
comment on column index_stats.name is
'name of the index'
/
comment on column index_stats.partition_name is
'name of the index partition, if partitioned'
/
comment on column index_stats.lf_rows is
'number of leaf rows (values in the index)'
/
comment on column index_stats.lf_blks is
'number of leaf blocks in the b-tree'
/
comment on column index_stats.lf_rows_len is
'sum of the lengths of all the leaf rows'
/
comment on column index_stats.lf_blk_len is
'useable space in a leaf block'
/
comment on column index_stats.br_rows is
'number of branch rows'
/
comment on column index_stats.br_blks is
'number of branch blocks in the b-tree'
/
comment on column index_stats.br_rows_len is
'sum of the lengths of all the branch blocks in the b-tree'
/
comment on column index_stats.br_blk_len is
'useable space in a branch block'
/
comment on column index_stats.del_lf_rows is
'number of deleted leaf rows in the index'
/
comment on column index_stats.del_lf_rows_len is
'total length of all deleted rows in the index'
/
comment on column index_stats.distinct_keys is
'number of distinct keys in the index'
/
comment on column index_stats.most_repeated_key is
'how many times the most repeated key is repeated'
/
comment on column index_stats.btree_space is
'total space currently allocated in the b-tree'
/
comment on column index_stats.used_space is
'total space that is currently being used in the b-tree'
/
comment on column index_stats.pct_used is
'percent of space allocated in the b-tree that is being used'
/
comment on column index_stats.rows_per_key is
'average number of rows per distinct key'
/
comment on column index_stats.blks_gets_per_access is
'Expected number of consistent mode block gets per row. This assumes that a row chosen at random from the table is being searched for using the index'
/
drop public synonym INDEX_STATS
/
create public synonym INDEX_STATS for INDEX_STATS
/
grant select on INDEX_STATS to public with grant option
/
create or replace view INDEX_HISTOGRAM as
 select hist.indx * power(2, stats.kdxstscl-4)	repeat_count,
	hist.kdxhsval				keys_with_repeat_count
	from  x$kdxst stats, x$kdxhs hist
/
comment on table INDEX_HISTOGRAM is
'statistics on keys with repeat count'
/
comment on column index_histogram.repeat_count is
'number of times that a key is repeated'
/
comment on column index_histogram.keys_with_repeat_count is
'number of keys that are repeated REPEAT_COUNT times'
/
drop public synonym INDEX_HISTOGRAM
/
create public synonym INDEX_HISTOGRAM for INDEX_HISTOGRAM
/
grant select on INDEX_HISTOGRAM to public with grant option
/
remark
remark  FAMILY "OBJECTS"
remark  List of objects, including creation and modify times.
remark
create or replace view USER_OBJECTS
    (OBJECT_NAME, SUBOBJECT_NAME, OBJECT_ID, DATA_OBJECT_ID, OBJECT_TYPE,
     CREATED, LAST_DDL_TIME, TIMESTAMP, STATUS, TEMPORARY, GENERATED)
as
select o.name, o.subname, o.obj#, o.dataobj#,
       decode(o.type#, 0, 'NEXT OBJECT', 1, 'INDEX', 2, 'TABLE', 3, 'CLUSTER',
                      4, 'VIEW', 5, 'SYNONYM', 6, 'SEQUENCE', 
                      7, 'PROCEDURE', 8, 'FUNCTION', 9, 'PACKAGE',
                      11, 'PACKAGE BODY', 12, 'TRIGGER',
                      13, 'TYPE', 14, 'TYPE BODY', 
		      19, 'TABLE PARTITION', 20, 'INDEX PARTITION', 
		      22, 'LIBRARY', 23, 'DIRECTORY', 'UNDEFINED'),
       o.ctime, o.mtime,
       to_char(o.stime, 'YYYY-MM-DD:HH24:MI:SS'),
       decode(o.status, 0, 'N/A', 1, 'VALID', 'INVALID'),
       decode(bitand(o.flags, 2), 0, 'N', 2, 'Y', 'N'),
       decode(bitand(o.flags, 4), 0, 'N', 4, 'Y', 'N')
from sys.obj$ o
where o.owner# = userenv('SCHEMAID')
  and o.linkname is null
  and (o.type# not in (1  /* INDEX - handled below */,
		      10 /* NON-EXISTENT */) 
       or
       (o.type# = 1 and 1 = (select 1
			     from sys.ind$ i
			    where i.obj# = o.obj#
			      and i.type# in (1, 2, 3, 4, 6, 7))))
union all
select l.name, NULL, to_number(null), to_number(null),
       'DATABASE LINK',
       l.ctime, to_date(null), NULL, 'VALID', 'N', 'N'
from sys.link$ l
where l.owner# = userenv('SCHEMAID')
/
comment on table USER_OBJECTS is
'Objects owned by the user'
/
comment on column USER_OBJECTS.OBJECT_NAME is
'Name of the object'
/
comment on column USER_OBJECTS.SUBOBJECT_NAME is
'Name of the sub-object (for example, partititon)'
/
comment on column USER_OBJECTS.OBJECT_ID is
'Object number of the object'
/
comment on column USER_OBJECTS.DATA_OBJECT_ID is
'Object number of the segment which contains the object'
/
comment on column USER_OBJECTS.OBJECT_TYPE is
'Type of the object'
/
comment on column USER_OBJECTS.CREATED is
'Timestamp for the creation of the object'
/
comment on column USER_OBJECTS.LAST_DDL_TIME is
'Timestamp for the last DDL change (including GRANT and REVOKE) to the object'
/
comment on column USER_OBJECTS.TIMESTAMP is
'Timestamp for the specification of the object'
/
comment on column USER_OBJECTS.STATUS is
'Status of the object'
/
comment on column USER_OBJECTS.TEMPORARY is
'Can the current session only see data that it place in this object itself?'
/
comment on column USER_OBJECTS.GENERATED is
'Was the name of this object system generated?'
/
drop public synonym USER_OBJECTS
/
create public synonym USER_OBJECTS for USER_OBJECTS
/
drop public synonym OBJ
/
create public synonym OBJ for USER_OBJECTS
/
grant select on USER_OBJECTS to PUBLIC with grant option
/
create or replace view ALL_OBJECTS
    (OWNER, OBJECT_NAME, SUBOBJECT_NAME, OBJECT_ID, DATA_OBJECT_ID, 
     OBJECT_TYPE, CREATED, LAST_DDL_TIME, TIMESTAMP, STATUS, 
     TEMPORARY, GENERATED)
as
select u.name, o.name, o.subname, o.obj#, o.dataobj#,
       decode(o.type#, 0, 'NEXT OBJECT', 1, 'INDEX', 2, 'TABLE', 3, 'CLUSTER',
                      4, 'VIEW', 5, 'SYNONYM', 6, 'SEQUENCE', 
                      7, 'PROCEDURE', 8, 'FUNCTION', 9, 'PACKAGE',
                      11, 'PACKAGE BODY', 12, 'TRIGGER',
                      13, 'TYPE', 14, 'TYPE BODY', 
		      19, 'TABLE PARTITION', 20, 'INDEX PARTITION', 
		      22, 'LIBRARY', 23, 'DIRECTORY', 'UNDEFINED'),
       o.ctime, o.mtime,
       to_char(o.stime, 'YYYY-MM-DD:HH24:MI:SS'),
       decode(o.status, 0, 'N/A', 1, 'VALID', 'INVALID'),
       decode(bitand(o.flags, 2), 0, 'N', 2, 'Y', 'N'),
       decode(bitand(o.flags, 4), 0, 'N', 4, 'Y', 'N')
from sys.obj$ o, sys.user$ u
where o.owner# = u.user#
  and o.linkname is null
  and (o.type# not in (1  /* INDEX - handled below */,
		      10 /* NON-EXISTENT */) 
       or
       (o.type# = 1 and 1 = (select 1
			     from sys.ind$ i
			    where i.obj# = o.obj#
			      and i.type# in (1, 2, 3, 4, 6, 7))))
  and
  (
    o.owner# in (userenv('SCHEMAID'), 1 /* PUBLIC */)
    or
    (
      /* EXECUTE privilege does not let user see package/type body */
      o.type# != 11 and o.type# != 14
      and
      o.obj# in (select obj# from sys.objauth$
                 where grantee# in (select kzsrorol from x$kzsro)
                   and privilege# in (3 /* DELETE */,   6 /* INSERT */,
                                      7 /* LOCK */,     9 /* SELECT */,
                                      10 /* UPDATE */, 12 /* EXECUTE */,
                                      11 /* USAGE */,  16 /* CREATE */,
                                      17 /* READ */,   18 /* WRITE  */ ))
    )
    or 
    ( 
       o.type# in (7, 8, 9) /* prc, fcn, pkg */ 
       and 
       exists (select null from v$enabledprivs 
               where priv_number in ( 
                                      -144 /* EXECUTE ANY PROCEDURE */, 
                                      -141 /* CREATE ANY PROCEDURE */ 
                                    ) 
              ) 
    ) 
    or
    (
       o.type# in (12) /* trigger */
       and
       exists (select null from v$enabledprivs
	       where priv_number in (
	                              -152 /* CREATE ANY TRIGGER */
				    )
              )
    )
    or
    (
       o.type# = 11 /* pkg body */
       and
       exists (select null from v$enabledprivs
	       where priv_number =   -141 /* CREATE ANY PROCEDURE */
              )
    )
    or 
    ( 
       o.type# in (22) /* library */
       and 
       exists (select null from v$enabledprivs 
               where priv_number in ( 
                                      -189 /* CREATE ANY LIBRARY */,
                                      -190 /* ALTER ANY LIBRARY */,
                                      -191 /* DROP ANY LIBRARY */,
                                      -192 /* EXECUTE ANY LIBRARY */
                                    ) 
              ) 
    ) 
    or
    (
       o.type# in (1, 2, 4, 5, 19, 20) /* index, table, view, synonym */
       and
       exists (select null from v$enabledprivs
               where priv_number in (-45 /* LOCK ANY TABLE */,
				     -47 /* SELECT ANY TABLE */,
				     -48 /* INSERT ANY TABLE */,
				     -49 /* UPDATE ANY TABLE */,
				     -50 /* DELETE ANY TABLE */)
               )
    )
    or 
    ( o.type# = 6 /* sequence */ 
      and 
      exists (select null from v$enabledprivs 
              where priv_number = -109 /* SELECT ANY SEQUENCE */) 
    ) 
    or 
    ( o.type# = 13 /* type */ 
      and 
      exists (select null from v$enabledprivs 
              where priv_number in (-184 /* EXECUTE ANY TYPE */,
                                    -181 /* CREATE ANY TYPE */))
    ) 
    or 
    ( 
      o.type# = 14 /* type body */ 
      and 
      exists (select null from v$enabledprivs 
              where priv_number = -181 /* CREATE ANY TYPE */) 
    ) 
    or 
    ( 
       o.type# = 23 /* directory */ 
       and 
       exists (select null from v$enabledprivs 
               where priv_number in ( 
                                      -177 /* CREATE ANY DIRECTORY */, 
                                      -178 /* DROP ANY DIRECTORY */ 
                                    ) 
              ) 
    ) 
  ) 
/ 
comment on table ALL_OBJECTS is
'Objects accessible to the user'
/
comment on column ALL_OBJECTS.OWNER is
'Username of the owner of the object'
/
comment on column ALL_OBJECTS.OBJECT_NAME is
'Name of the object'
/
comment on column ALL_OBJECTS.SUBOBJECT_NAME is
'Name of the sub-object (for example, partititon)'
/
comment on column ALL_OBJECTS.OBJECT_ID is
'Object number of the object'
/
comment on column ALL_OBJECTS.DATA_OBJECT_ID is
'Object number of the segment which contains the object'
/
comment on column ALL_OBJECTS.OBJECT_TYPE is
'Type of the object'
/
comment on column ALL_OBJECTS.CREATED is
'Timestamp for the creation of the object'
/
comment on column ALL_OBJECTS.LAST_DDL_TIME is
'Timestamp for the last DDL change (including GRANT and REVOKE) to the object'
/
comment on column ALL_OBJECTS.TIMESTAMP is
'Timestamp for the specification of the object'
/
comment on column ALL_OBJECTS.STATUS is
'Status of the object'
/
comment on column ALL_OBJECTS.TEMPORARY is
'Can the current session only see data that it placed in this object itself?'
/
comment on column ALL_OBJECTS.GENERATED is
'Was the name of this object system generated?'
/
drop public synonym ALL_OBJECTS
/
create public synonym ALL_OBJECTS for ALL_OBJECTS
/
grant select on ALL_OBJECTS to PUBLIC with grant option
/
create or replace view DBA_OBJECTS
    (OWNER, OBJECT_NAME, SUBOBJECT_NAME, OBJECT_ID, DATA_OBJECT_ID, 
     OBJECT_TYPE, CREATED, LAST_DDL_TIME, TIMESTAMP, STATUS, 
     TEMPORARY, GENERATED)
as
select u.name, o.name, o.subname, o.obj#, o.dataobj#,
       decode(o.type#, 0, 'NEXT OBJECT', 1, 'INDEX', 2, 'TABLE', 3, 'CLUSTER',
                      4, 'VIEW', 5, 'SYNONYM', 6, 'SEQUENCE', 
                      7, 'PROCEDURE', 8, 'FUNCTION', 9, 'PACKAGE',
                      11, 'PACKAGE BODY', 12, 'TRIGGER',
                      13, 'TYPE', 14, 'TYPE BODY', 
		      19, 'TABLE PARTITION', 20, 'INDEX PARTITION', 
		      22, 'LIBRARY', 23, 'DIRECTORY', 'UNDEFINED'),
       o.ctime, o.mtime,
       to_char(o.stime, 'YYYY-MM-DD:HH24:MI:SS'),
       decode(o.status, 0, 'N/A', 1, 'VALID', 'INVALID'),
       decode(bitand(o.flags, 2), 0, 'N', 2, 'Y', 'N'),
       decode(bitand(o.flags, 4), 0, 'N', 4, 'Y', 'N')
from sys.obj$ o, sys.user$ u
where o.owner# = u.user#
  and o.linkname is null
  and (o.type# not in (1  /* INDEX - handled below */,
		      10 /* NON-EXISTENT */) 
       or
       (o.type# = 1 and 1 = (select 1
			      from sys.ind$ i
			     where i.obj# = o.obj#
			       and i.type# in (1, 2, 3, 4, 6, 7))))
  and o.name != '_NEXT_OBJECT'
  and o.name != '_default_auditing_options_'
union all
select u.name, l.name, NULL, to_number(null), to_number(null),
       'DATABASE LINK',
       l.ctime, to_date(null), NULL, 'VALID','N','N'
from sys.link$ l, sys.user$ u
where l.owner# = u.user#
/
drop public synonym DBA_OBJECTS
/
create public synonym DBA_OBJECTS for DBA_OBJECTS
/
grant select on DBA_OBJECTS to select_catalog_role
/
comment on table DBA_OBJECTS is
'All objects in the database'
/
comment on column DBA_OBJECTS.OWNER is
'Username of the owner of the object'
/
comment on column DBA_OBJECTS.OBJECT_NAME is
'Name of the object'
/
comment on column DBA_OBJECTS.SUBOBJECT_NAME is
'Name of the sub-object (for example, partititon)'
/
comment on column DBA_OBJECTS.OBJECT_ID is
'Object number of the object'
/
comment on column DBA_OBJECTS.DATA_OBJECT_ID is
'Object number of the segment which contains the object'
/
comment on column DBA_OBJECTS.OBJECT_TYPE is
'Type of the object'
/
comment on column DBA_OBJECTS.CREATED is
'Timestamp for the creation of the object'
/
comment on column DBA_OBJECTS.LAST_DDL_TIME is
'Timestamp for the last DDL change (including GRANT and REVOKE) to the object'
/
comment on column DBA_OBJECTS.TIMESTAMP is
'Timestamp for the specification of the object'
/
comment on column DBA_OBJECTS.STATUS is
'Status of the object'
/
comment on column DBA_OBJECTS.TEMPORARY is
'Can the current session only see data that it place in this object itself?'
/
comment on column DBA_OBJECTS.GENERATED is
'Was the name of this object system generated?'
/

remark
remark Family ARGUMENTS
remark

create or replace view ALL_ARGUMENTS
(OWNER, OBJECT_NAME, PACKAGE_NAME, OBJECT_ID, OVERLOAD, 
ARGUMENT_NAME, POSITION, SEQUENCE, 
DATA_LEVEL, DATA_TYPE, DEFAULT_VALUE, DEFAULT_LENGTH, IN_OUT, DATA_LENGTH, 
DATA_PRECISION, DATA_SCALE, RADIX, CHARACTER_SET_NAME,
TYPE_OWNER, TYPE_NAME, TYPE_SUBNAME, TYPE_LINK)
as
select
u.name, /* OWNER */
nvl(a.procedure$,o.name), /* OBJECT_NAME */
decode(a.procedure$,null,null, o.name), /* PACKAGE_NAME */
o.obj#, /* OBJECT_ID */
decode(a.overload#,0,null,a.overload#), /* OVERLOAD */
a.argument, /* ARGUMENT_NAME */
a.position#, /* POSITION */
a.sequence#, /* SEQUENCE */
a.level#, /* DATA_LEVEL */
decode(a.type#,  /* DATA_TYPE */
0, null, 
1, decode(a.charsetform, 2, 'NVARCHAR2', 'VARCHAR2'),
2, decode(a.scale, null, decode(a.precision#, null, 'NUMBER', 'FLOAT'),'NUMBER'),
3, 'NATIVE INTEGER',
8, 'LONG', 
9, decode(a.charsetform, 2, 'NCHAR VARYING', 'VARCHAR'),
12, 'DATE', 
23, 'RAW', 
24, 'LONG RAW', 
29, 'BINARY_INTEGER',
69, 'ROWID',
96, decode(a.charsetform, 2, 'NCHAR', 'CHAR'), 
102, 'REF CURSOR',
105, 'MLSLABEL',
106, 'MLSLABEL', 
110, 'REF',
111, 'REF',
112, decode(a.charsetform, 2, 'NCLOB', 'CLOB'),
113, 'BLOB', 114, 'BFILE', 115, 'CFILE',
121, 'OBJECT',
122, 'TABLE',
123, 'VARRAY',
250, 'PL/SQL RECORD', 
251, 'PL/SQL TABLE',
252, 'PL/SQL BOOLEAN',
'UNDEFINED'), 
default$, /* DEFAULT_VALUE */
deflength, /* DEFAULT_LENGTH */
decode(in_out,null,'IN',1,'OUT',2,'IN/OUT','Undefined'), /* IN_OUT */
length, /* DATA_LENGTH */
precision#, /* DATA_PRECISION */
scale, /* DATA_SCALE */
radix, /* RADIX */
decode(a.charsetform, 1, 'CHAR_CS',           /* CHARACTER_SET_NAME */
                      2, 'NCHAR_CS',
                      3, NLS_CHARSET_NAME(a.charsetid),
                      4, 'ARG:'||a.charsetid),
a.type_owner, /* TYPE_OWNER */
a.type_name, /* TYPE_NAME */
a.type_subname, /* TYPE_SUBNAME */
a.type_linkname /* TYPE_LINK */
from obj$ o,argument$ a,user$ u
where o.obj# = a.obj#
and o.owner# = u.user#
and (owner# = userenv('SCHEMAID')
or exists 
  (select null from v$enabledprivs where priv_number in (-144,-141))
or o.obj# in (select obj# from sys.objauth$ where grantee# in
  (select kzsrorol from x$kzsro) and privilege# = 12))
/
comment on table all_arguments is
'Arguments in object accessible to the user'
/
comment on column all_arguments.owner is
'Username of the owner of the object'
/
comment on column all_arguments.object_name is
'Procedure or function name'
/
comment on column all_arguments.overload is
'Overload unique identifier'
/
comment on column all_arguments.package_name is
'Package name'
/
comment on column all_arguments.object_id is
'Object number of the object'
/
comment on column all_arguments.argument_name is
'Argument name'
/
comment on column all_arguments.position is
'Position in argument list, or null for function return value'
/
comment on column all_arguments.sequence is
'Argument sequence, including all nesting levels'
/
comment on column all_arguments.data_level is
'Nesting depth of argument for composite types'
/
comment on column all_arguments.data_type is
'Datatype of the argument'
/
comment on column all_arguments.default_value is
'Default value for the argument'
/
comment on column all_arguments.default_length is
'Length of default value for the argument'
/
comment on column all_arguments.in_out is
'Argument direction (IN, OUT, or IN/OUT)'
/
comment on column all_arguments.data_length is
'Length of the column in bytes'
/
comment on column all_arguments.data_precision is
'Length: decimal digits (NUMBER) or binary digits (FLOAT)'
/
comment on column all_arguments.data_scale is
'Digits to right of decimal point in a number'
/
comment on column all_arguments.radix is
'Argument radix for a number'
/
comment on column all_arguments.character_set_name is
'Character set name for the argument'
/
comment on column all_arguments.type_owner is
'Owner name for the argument type in case of object types'
/
comment on column all_arguments.type_name is
'Object name for the argument type in case of object types'
/
comment on column all_arguments.type_subname is
'Subordinate object name for the argument type in case of object types'
/
comment on column all_arguments.type_link is
'Database link name for the argument type in case of object types'
/
drop public synonym all_arguments
/
create public synonym all_arguments for all_arguments
/
grant select on all_arguments to public with grant option
/

create or replace view USER_ARGUMENTS
(OBJECT_NAME, PACKAGE_NAME, OBJECT_ID, OVERLOAD, 
ARGUMENT_NAME, POSITION, SEQUENCE, 
DATA_LEVEL, DATA_TYPE, DEFAULT_VALUE, DEFAULT_LENGTH, IN_OUT, DATA_LENGTH, 
DATA_PRECISION, DATA_SCALE, RADIX, CHARACTER_SET_NAME,
TYPE_OWNER, TYPE_NAME, TYPE_SUBNAME, TYPE_LINK)
as
select
nvl(a.procedure$,o.name), /* OBJECT_NAME */
decode(a.procedure$,null,null, o.name), /* PACKAGE_NAME */
o.obj#, /* OBJECT_ID */
decode(a.overload#,0,null,a.overload#), /* OVERLOAD */
a.argument, /* ARGUMENT_NAME */
a.position#, /* POSITION */
a.sequence#, /* SEQUENCE */
a.level#, /* DATA_LEVEL */
decode(a.type#,  /* DATA_TYPE */
0, null, 
1, decode(a.charsetform, 2, 'NVARCHAR2', 'VARCHAR2'),
2, decode(a.scale, null, decode(a.precision#, null, 'NUMBER', 'FLOAT'),'NUMBER'),
3, 'NATIVE INTEGER',
8, 'LONG', 
9, decode(a.charsetform, 2, 'NCHAR VARYING', 'VARCHAR'),
12, 'DATE', 
23, 'RAW', 
24, 'LONG RAW', 
29, 'BINARY_INTEGER',
69, 'ROWID',
96, decode(a.charsetform, 2, 'NCHAR', 'CHAR'), 
102, 'REF CURSOR',
105, 'MLSLABEL',
106, 'MLSLABEL', 
110, 'REF',
111, 'REF',
112, decode(a.charsetform, 2, 'NCLOB', 'CLOB'),
113, 'BLOB', 114, 'BFILE', 115, 'CFILE',
121, 'OBJECT',
122, 'TABLE',
123, 'VARRAY',
250, 'PL/SQL RECORD', 
251, 'PL/SQL TABLE',
252, 'PL/SQL BOOLEAN',
'UNDEFINED'), 
default$, /* DEFAULT_VALUE */
deflength, /* DEFAULT_LENGTH */
decode(in_out,null,'IN',1,'OUT',2,'IN/OUT','Undefined'), /* IN_OUT */
length, /* DATA_LENGTH */
precision#, /* DATA_PRECISION */
scale, /* DATA_SCALE */
radix, /* RADIX */
decode(a.charsetform, 1, 'CHAR_CS',           /* CHARACTER_SET_NAME */
                      2, 'NCHAR_CS',
                      3, NLS_CHARSET_NAME(a.charsetid),
                      4, 'ARG:'||a.charsetid),
a.type_owner, /* TYPE_OWNER */
a.type_name, /* TYPE_NAME */
a.type_subname, /* TYPE_SUBNAME */
a.type_linkname /* TYPE_LINK */
from obj$ o,argument$ a
where o.obj# = a.obj#
and owner# = userenv('SCHEMAID')
/
comment on table user_arguments is
'Arguments in object accessible to the user'
/
comment on column user_arguments.object_name is
'Procedure or function name'
/
comment on column user_arguments.overload is
'Overload unique identifier'
/
comment on column user_arguments.package_name is
'Package name'
/
comment on column user_arguments.object_id is
'Object number of the object'
/
comment on column user_arguments.argument_name is
'Argument name'
/
comment on column user_arguments.position is
'Position in argument list, or null for function return value'
/
comment on column user_arguments.sequence is
'Argument sequence, including all nesting levels'
/
comment on column user_arguments.data_level is
'Nesting depth of argument for composite types'
/
comment on column user_arguments.data_type is
'Datatype of the argument'
/
comment on column user_arguments.default_value is
'Default value for the argument'
/
comment on column user_arguments.default_length is
'Length of default value for the argument'
/
comment on column user_arguments.in_out is
'Argument direction (IN, OUT, or IN/OUT)'
/
comment on column user_arguments.data_length is
'Length of the column in bytes'
/
comment on column user_arguments.data_precision is
'Length: decimal digits (NUMBER) or binary digits (FLOAT)'
/
comment on column user_arguments.data_scale is
'Digits to right of decimal point in a number'
/
comment on column user_arguments.radix is
'Argument radix for a number'
/
comment on column user_arguments.character_set_name is
'Character set name for the argument'
/
comment on column user_arguments.type_owner is
'Owner name for the argument type in case of object types'
/
comment on column user_arguments.type_name is
'Object name for the argument type in case of object types'
/
comment on column user_arguments.type_subname is
'Subordinate object name for the argument type in case of object types'
/
comment on column user_arguments.type_link is
'Database link name for the argument type in case of object types'
/
drop public synonym user_arguments
/
create public synonym user_arguments for user_arguments
/
grant select on user_arguments to public with grant option
/
remark
remark  FAMILY "ROLLBACK_SEGS"
remark  CREATE ROLLBACK SEGMENT parameters.
remark  This family has a DBA member only.
remark
create or replace view DBA_ROLLBACK_SEGS
    (SEGMENT_NAME, OWNER, TABLESPACE_NAME, SEGMENT_ID, FILE_ID, BLOCK_ID,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,
     STATUS, INSTANCE_NUM, RELATIVE_FNO)
as
select un.name, decode(un.user#,1,'PUBLIC','SYS'),
       ts.name, un.us#, f.file#, un.block#,
       s.iniexts * ts.blocksize, s.extsize * ts.blocksize,
       s.minexts, s.maxexts, s.extpct,
       decode(un.status$, 2, 'OFFLINE', 3, 'ONLINE',
                          4, 'UNDEFINED', 5, 'NEEDS RECOVERY', 
                          6, 'PARTLY AVAILABLE', 'UNDEFINED'),
       decode(un.inst#, 0, NULL, un.inst#), un.file#
from sys.undo$ un, sys.seg$ s, sys.ts$ ts, sys.file$ f
where un.status$ != 1
  and un.ts# = s.ts#
  and un.file# = s.file# 
  and un.block# = s.block#
  and s.type# = 1
  and s.ts# = ts.ts#
  and un.ts# = f.ts#
  and un.file# = f.relfile#
/
drop public synonym DBA_ROLLBACK_SEGS
/
create public synonym DBA_ROLLBACK_SEGS for DBA_ROLLBACK_SEGS
/
grant select on DBA_ROLLBACK_SEGS to select_catalog_role
/
comment on table DBA_ROLLBACK_SEGS is
'Description of rollback segments'
/
comment on column DBA_ROLLBACK_SEGS.SEGMENT_NAME is
'Name of the rollback segment'
/
comment on column DBA_ROLLBACK_SEGS.OWNER is
'Owner of the rollback segment'
/
comment on column DBA_ROLLBACK_SEGS.TABLESPACE_NAME is
'Name of the tablespace containing the rollback segment'
/
comment on column DBA_ROLLBACK_SEGS.SEGMENT_ID is
'ID number of the rollback segment'
/
comment on column DBA_ROLLBACK_SEGS.FILE_ID is
'ID number of the file containing the segment header'
/
comment on column DBA_ROLLBACK_SEGS.BLOCK_ID is
'ID number of the block containing the segment header'
/
comment on column DBA_ROLLBACK_SEGS.INITIAL_EXTENT is
'Initial extent size in bytes'
/
comment on column DBA_ROLLBACK_SEGS.NEXT_EXTENT is
'Secondary extent size in bytes'
/
comment on column DBA_ROLLBACK_SEGS.MIN_EXTENTS is
'Minimum number of extents'
/
comment on column DBA_ROLLBACK_SEGS.MAX_EXTENTS is
'Maximum number of extents'
/
comment on column DBA_ROLLBACK_SEGS.PCT_INCREASE is
'Percent increase for extent size'
/
comment on column DBA_ROLLBACK_SEGS.STATUS is
'Rollback segment status'
/   
comment on column DBA_ROLLBACK_SEGS.INSTANCE_NUM is
'Rollback segment owning parallel server instance number'
/
comment on column DBA_ROLLBACK_SEGS.RELATIVE_FNO is
'Relative number of the file containing the segment header'
/
remark
remark  FAMILY "ROLE GRANTS"
remark  
remark
create or replace view USER_ROLE_PRIVS
    (USERNAME, GRANTED_ROLE, ADMIN_OPTION, DEFAULT_ROLE, OS_GRANTED)
as
select decode(sa.grantee#, 1, 'PUBLIC', u1.name), u2.name,
       decode(min(option$), 1, 'YES', 'NO'),
       decode(min(u1.defrole), 0, 'NO', 1, 'YES', 
              2, decode(min(ud.role#),null,'NO','YES'), 
              3, decode(min(ud.role#),null,'YES','NO'), 'NO'), 'NO'
from sysauth$ sa,defrole$ ud, user$ u1, user$ u2
where sa.grantee# in (userenv('SCHEMAID'),1) and sa.grantee#=ud.user#(+)
  and sa.privilege#=ud.role#(+) and u1.user#=sa.grantee#
  and u2.user#=sa.privilege#
group by decode(sa.grantee#,1,'PUBLIC',u1.name),u2.name
union
select user,u.name,decode(kzdosadm,'A','YES','NO'), 
       decode(kzdosdef,'Y','YES','NO'), 'YES'
 from sys.user$ u,x$kzdos
where u.user#=x$kzdos.kzdosrol
/
comment on table USER_ROLE_PRIVS is
'Roles granted to current user'
/
comment on column USER_ROLE_PRIVS.USERNAME is
'User Name or PUBLIC'
/
comment on column USER_ROLE_PRIVS.GRANTED_ROLE is
'Granted role name'
/
comment on column USER_ROLE_PRIVS.ADMIN_OPTION is
'Grant was with the ADMIN option'
/
comment on column USER_ROLE_PRIVS.DEFAULT_ROLE is
'Role is designated as a DEFAULT ROLE for the user'
/
comment on column USER_ROLE_PRIVS.OS_GRANTED is
'Role is granted via the operating system (using OS_ROLES = TRUE)'
/
drop public synonym USER_ROLE_PRIVS
/
create public synonym USER_ROLE_PRIVS for USER_ROLE_PRIVS
/
grant select on USER_ROLE_PRIVS to PUBLIC with grant option
/
create or replace view DBA_ROLE_PRIVS
    (GRANTEE, GRANTED_ROLE, ADMIN_OPTION, DEFAULT_ROLE)
as
select decode(sa.grantee#, 1, 'PUBLIC', u1.name), u2.name,
       decode(min(option$), 1, 'YES', 'NO'),
       decode(min(u1.defrole), 0, 'NO', 1, 'YES', 
              2, decode(min(ud.role#),null,'NO','YES'), 
              3, decode(min(ud.role#),null,'YES','NO'), 'NO')
from sysauth$ sa,defrole$ ud, user$ u1, user$ u2
where sa.grantee#=ud.user#(+)
  and sa.privilege#=ud.role#(+) and u1.user#=sa.grantee#
  and u2.user#=sa.privilege#
group by decode(sa.grantee#,1,'PUBLIC',u1.name),u2.name
/
drop public synonym DBA_ROLE_PRIVS
/
create public synonym DBA_ROLE_PRIVS for DBA_ROLE_PRIVS
/
grant select on DBA_ROLE_PRIVS to select_catalog_role
/
comment on table DBA_ROLE_PRIVS is
'Roles granted to users and roles'
/
comment on column DBA_ROLE_PRIVS.GRANTEE is
'Grantee Name, User or Role receiving the grant'
/
comment on column DBA_ROLE_PRIVS.GRANTED_ROLE is
'Granted role name'
/
comment on column DBA_ROLE_PRIVS.ADMIN_OPTION is
'Grant was with the ADMIN option'
/
comment on column DBA_ROLE_PRIVS.DEFAULT_ROLE is
'Role is designated as a DEFAULT ROLE for the user'
/
remark
remark  FAMILY "SYS GRANTS"
remark  
remark
create or replace view USER_SYS_PRIVS
    (USERNAME, PRIVILEGE, ADMIN_OPTION)
as
select decode(sa.grantee#,1,'PUBLIC',user),spm.name,
       decode(min(option$),1,'YES','NO')
from  sys.system_privilege_map spm, sys.sysauth$ sa
where (sa.grantee#=userenv('SCHEMAID') or sa.grantee#=1)
  and sa.privilege#=spm.privilege
group by decode(sa.grantee#,1,'PUBLIC',user),spm.name
/
comment on table USER_SYS_PRIVS is
'System privileges granted to current user'
/
comment on column USER_SYS_PRIVS.USERNAME is
'User Name or PUBLIC'
/
comment on column USER_SYS_PRIVS.PRIVILEGE is
'System privilege'
/
comment on column USER_SYS_PRIVS.ADMIN_OPTION is
'Grant was with the ADMIN option'
/
drop public synonym USER_SYS_PRIVS
/
create public synonym USER_SYS_PRIVS for USER_SYS_PRIVS
/
grant select on USER_SYS_PRIVS to PUBLIC with grant option
/
create or replace view DBA_SYS_PRIVS
    (GRANTEE, PRIVILEGE, ADMIN_OPTION)
as
select u.name,spm.name,decode(min(option$),1,'YES','NO')
from  sys.system_privilege_map spm, sys.sysauth$ sa, user$ u
where sa.grantee#=u.user# and sa.privilege#=spm.privilege
group by u.name,spm.name
/
drop public synonym DBA_SYS_PRIVS
/
create public synonym DBA_SYS_PRIVS for DBA_SYS_PRIVS
/
grant select on DBA_SYS_PRIVS to select_catalog_role
/
comment on table DBA_SYS_PRIVS is
'System privileges granted to users and roles'
/
comment on column DBA_SYS_PRIVS.GRANTEE is
'Grantee Name, User or Role receiving the grant'
/
comment on column DBA_SYS_PRIVS.PRIVILEGE is
'System privilege'
/
comment on column DBA_SYS_PRIVS.ADMIN_OPTION is
'Grant was with the ADMIN option'
/
remark  FAMILY "SEGMENTS"
remark  Storage for all types of segments
remark  This family has no ALL member.
remark  define SYS_OBJECTS for use by segments views
remark  The sys_objects view is a basis for segments views 
remark  The sys_user_segs view is a basis for user_segments and 
remark  user_extents views
remark  The sys_dba_segs view is a basis for dba_segments and 
remark  dba_extents views
create or replace view SYS_OBJECTS
    (OBJECT_TYPE, OBJECT_TYPE_ID, SEGMENT_TYPE_ID,
     OBJECT_ID, HEADER_FILE, HEADER_BLOCK, TS_NUMBER)
as
select decode(bitand(t.property, 8192), 8192, 'NESTED TABLE', 'TABLE'), 2, 5,
       t.obj#, t.file#, t.block#, t.ts#
from sys.tab$ t
where bitand(t.property, 1024) = 0               /* exclude clustered tables */
union all
select 'TABLE PARTITION', 19, 5,
       tp.obj#, tp.file#, tp.block#, tp.ts#
from sys.tabpart$ tp
union all
select 'CLUSTER', 3, 5,
       c.obj#, c.file#, c.block#, c.ts#
from sys.clu$ c
union all
select decode(i.type#, 8, 'LOBINDEX', 'INDEX'), 1, 6,
       i.obj#, i.file#, i.block#, i.ts#
from sys.ind$ i
where i.type# in (1, 2, 3, 4, 6, 7, 8)
union all
select 'INDEX PARTITION', 20, 6,
       ip.obj#, ip.file#, ip.block#, ip.ts#
from sys.indpart$ ip
union all
select 'LOBSEGMENT', 21, 8,
       l.lobj#, l.file#, l.block#, l.ts#
from sys.lob$ l
/
grant select on SYS_OBJECTS to select_catalog_role
/
create or replace view SYS_USER_SEGS
    (SEGMENT_NAME,
     PARTITION_NAME,
     SEGMENT_TYPE,
     TABLESPACE_ID, TABLESPACE_NAME, BLOCKSIZE,
     HEADER_FILE, HEADER_BLOCK,
     BYTES, BLOCKS, EXTENTS, 
     INITIAL_EXTENT, NEXT_EXTENT, 
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,
     FREELISTS, FREELIST_GROUPS, BUFFER_POOL)
as
select o.name,
       o.subname,
       so.object_type,
       ts.ts#, ts.name, ts.blocksize,
       s.file#, s.block#,
       s.blocks * ts.blocksize, s.blocks, s.extents, 
       s.iniexts * ts.blocksize, s.extsize * ts.blocksize, s.minexts, 
       s.maxexts, s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       decode(s.cachehint, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from sys.obj$ o, sys.ts$ ts, sys.sys_objects so, sys.seg$ s
where s.file# = so.header_file
  and s.block# = so.header_block
  and s.ts# = so.ts_number
  and s.ts# = ts.ts#
  and o.obj# = so.object_id
  and o.owner# = userenv('SCHEMAID')
  and s.type# = so.segment_type_id
  and o.type# = so.object_type_id
union all
select un.name,
       'ROLLBACK',
       NULL,
       ts.ts#, ts.name, ts.blocksize,
       s.file#, s.block#,
       s.blocks * ts.blocksize, s.blocks, s.extents,
       s.iniexts * ts.blocksize, s.extsize * ts.blocksize, s.minexts, 
       s.maxexts, s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       decode(s.cachehint, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from sys.ts$ ts, sys.undo$ un, sys.seg$ s
where s.file# = un.file#
  and s.block# = un.block#
  and s.ts# = un.ts#
  and s.ts# = ts.ts#
  and s.user# = userenv('SCHEMAID')
  and s.type# = 1
  and un.status$ != 1  
union all
select to_char(f.file#) || '.' || to_char(s.block#),
       NULL,
       decode(s.type#, 2, 'DEFERRED ROLLBACK', 3, 'TEMPORARY',
                      4, 'CACHE', 'UNDEFINED'),
       ts.ts#, ts.name, ts.blocksize,
       s.file#, s.block#,
       s.blocks * ts.blocksize, s.blocks, s.extents,
       s.iniexts * ts.blocksize, s.extsize * ts.blocksize, s.minexts, 
       s.maxexts, s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       decode(s.cachehint, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from sys.ts$ ts, sys.seg$ s, sys.file$ f
where s.ts# = ts.ts#
  and s.ts# = f.ts#
  and s.file# = f.relfile#
  and s.user# = userenv('SCHEMAID')
  and s.type# not in (1, 5, 6, 8)
/
grant select on SYS_USER_SEGS to select_catalog_role
/
create or replace view SYS_DBA_SEGS
    (OWNER, SEGMENT_NAME,
     PARTITION_NAME,
     SEGMENT_TYPE,
     TABLESPACE_ID, TABLESPACE_NAME, BLOCKSIZE,
     HEADER_FILE, HEADER_BLOCK,
     BYTES, BLOCKS, EXTENTS, 
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE, FREELISTS, FREELIST_GROUPS,
     RELATIVE_FNO, BUFFER_POOL)
as
select u.name, o.name, o.subname,
       so.object_type,
       ts.ts#, ts.name, ts.blocksize,
       f.file#, s.block#,
       s.blocks * ts.blocksize, s.blocks, s.extents, 
       s.iniexts * ts.blocksize, s.extsize * ts.blocksize, s.minexts, 
       s.maxexts, s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       s.file#,
       decode(s.cachehint, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from sys.user$ u, sys.obj$ o, sys.ts$ ts, sys.sys_objects so, sys.seg$ s,
     sys.file$ f
where s.file# = so.header_file
  and s.block# = so.header_block
  and s.ts# = so.ts_number
  and s.ts# = ts.ts#
  and o.obj# = so.object_id
  and o.owner# = u.user#
  and s.type# = so.segment_type_id
  and o.type# = so.object_type_id
  and s.ts# = f.ts#
  and s.file# = f.relfile#
union all
select u.name, un.name, NULL,
       'ROLLBACK', ts.ts#, ts.name, ts.blocksize, f.file#, s.block#,
       s.blocks * ts.blocksize, s.blocks, s.extents,
       s.iniexts * ts.blocksize, s.extsize * ts.blocksize, s.minexts, 
       s.maxexts, s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups), 
       s.file#,
       decode(s.cachehint, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from sys.user$ u, sys.ts$ ts, sys.undo$ un, sys.seg$ s, sys.file$ f
where s.file# = un.file#
  and s.block# = un.block#
  and s.ts# = un.ts#
  and s.ts# = ts.ts#
  and s.user# = u.user#
  and s.type# = 1
  and un.status$ != 1
  and un.ts# = f.ts#
  and un.file# = f.relfile#
union all
select u.name, to_char(f.file#) || '.' || to_char(s.block#), NULL,
       decode(s.type#, 2, 'DEFERRED ROLLBACK', 3, 'TEMPORARY',
                      4, 'CACHE', 'UNDEFINED'),
       ts.ts#, ts.name, ts.blocksize,
       f.file#, s.block#,
       s.blocks * ts.blocksize, s.blocks, s.extents,
       s.iniexts * ts.blocksize, s.extsize * ts.blocksize, s.minexts, 
       s.maxexts, s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       s.file#,
       decode(s.cachehint, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from sys.user$ u, sys.ts$ ts, sys.seg$ s, sys.file$ f
where s.ts# = ts.ts#
  and s.user# = u.user#
  and s.type# not in (1, 5, 6, 8)
  and s.ts# = f.ts#
  and s.file# = f.relfile#
/
grant select on SYS_DBA_SEGS to select_catalog_role
/
remark USER_SEGMENTS masks out tablespace number from sys_user_segs
create or replace view USER_SEGMENTS
    (SEGMENT_NAME,
     PARTITION_NAME,
     SEGMENT_TYPE,
     TABLESPACE_NAME,
     BYTES, BLOCKS, EXTENTS, 
     INITIAL_EXTENT, NEXT_EXTENT, 
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE, FREELISTS, FREELIST_GROUPS,
     BUFFER_POOL)
as
select segment_name, partition_name, segment_type, tablespace_name,
       bytes, blocks, extents, initial_extent, next_extent,
       min_extents, max_extents, pct_increase, freelists, freelist_groups,
       buffer_pool
from sys_user_segs
/
comment on table USER_SEGMENTS is
'Storage allocated for all database segments'
/
comment on column USER_SEGMENTS.SEGMENT_NAME is
'Name, if any, of the segment'
/
comment on column USER_SEGMENTS.PARTITION_NAME is
'Partition Name, if any, of the segment'
/
comment on column USER_SEGMENTS.SEGMENT_TYPE is
'Type of segment:  "TABLE", "CLUSTER", "INDEX", "ROLLBACK", "DEFERRED ROLLBACK", "TEMPORARY", or "CACHE"'
/
comment on column USER_SEGMENTS.TABLESPACE_NAME is
'Name of the tablespace containing the segment'
/
comment on column USER_SEGMENTS.BYTES is
'Size, in bytes, of the segment'
/
comment on column USER_SEGMENTS.BLOCKS is
'Size, in Oracle blocks, of the segment'
/
comment on column USER_SEGMENTS.EXTENTS is
'Number of extents allocated to the segment'
/
comment on column USER_SEGMENTS.INITIAL_EXTENT is
'Size, in bytes, of the initial extent of the segment'
/
comment on column USER_SEGMENTS.NEXT_EXTENT is
'Size, in bytes, of the next extent to be allocated to the segment' 
/
comment on column USER_SEGMENTS.MIN_EXTENTS is
'Minimum number of extents allowed in the segment'
/
comment on column USER_SEGMENTS.MAX_EXTENTS is
'Maximum number of extents allowed in the segment'
/
comment on column USER_SEGMENTS.PCT_INCREASE is
'Percent by which to increase the size of the next extent to be allocated'
/
comment on column USER_SEGMENTS.FREELISTS is
'Number of process freelists allocated to this segment'
/
comment on column USER_SEGMENTS.FREELIST_GROUPS is
'Number of freelist groups allocated to this segment'
/
comment on column USER_SEGMENTS.BUFFER_POOL is
'The default buffer pool to be used for blocks from this segment'
/
drop public synonym USER_SEGMENTS
/
create public synonym USER_SEGMENTS for USER_SEGMENTS
/
grant select on USER_SEGMENTS to PUBLIC with grant option
/
remark DBA_SEGMENTS masks out tablespace number from sys_dba_segs
create or replace view DBA_SEGMENTS
    (OWNER, SEGMENT_NAME,
     PARTITION_NAME,
     SEGMENT_TYPE,
     TABLESPACE_NAME,
     HEADER_FILE, HEADER_BLOCK,
     BYTES, BLOCKS, EXTENTS, 
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE, FREELISTS, FREELIST_GROUPS,
     RELATIVE_FNO, BUFFER_POOL)
as
select owner, segment_name, partition_name, segment_type, tablespace_name,
       header_file, header_block, bytes, blocks, extents, initial_extent,
       next_extent, min_extents, max_extents, pct_increase, freelists,
       freelist_groups, relative_fno, buffer_pool
from sys_dba_segs
/
drop public synonym DBA_SEGMENTS
/
create public synonym DBA_SEGMENTS for DBA_SEGMENTS
/
grant select on DBA_SEGMENTS to select_catalog_role
/
comment on table DBA_SEGMENTS is
'Storage allocated for all database segments'
/
comment on column DBA_SEGMENTS.OWNER is
'Username of the segment owner'
/
comment on column DBA_SEGMENTS.SEGMENT_NAME is
'Name, if any, of the segment'
/
comment on column DBA_SEGMENTS.PARTITION_NAME is
'Partition Name, if any, of the segment'
/
comment on column DBA_SEGMENTS.SEGMENT_TYPE is
'Type of segment:  "TABLE", "CLUSTER", "INDEX", "ROLLBACK",
"DEFERRED ROLLBACK", "TEMPORARY", or "CACHE"'
/
comment on column DBA_SEGMENTS.TABLESPACE_NAME is
'Name of the tablespace containing the segment'
/
comment on column DBA_SEGMENTS.HEADER_FILE is
'ID of the file containing the segment header'
/
comment on column DBA_SEGMENTS.HEADER_BLOCK is
'ID of the block containing the segment header'
/
comment on column DBA_SEGMENTS.BYTES is
'Size, in bytes, of the segment'
/
comment on column DBA_SEGMENTS.BLOCKS is
'Size, in Oracle blocks, of the segment'
/
comment on column DBA_SEGMENTS.EXTENTS is
'Number of extents allocated to the segment'
/
comment on column DBA_SEGMENTS.INITIAL_EXTENT is
'Size, in bytes, of the initial extent of the segment'
/
comment on column DBA_SEGMENTS.NEXT_EXTENT is
'Size, in bytes, of the next extent to be allocated to the segment' 
/
comment on column DBA_SEGMENTS.MIN_EXTENTS is
'Minimum number of extents allowed in the segment'
/
comment on column DBA_SEGMENTS.MAX_EXTENTS is
'Maximum number of extents allowed in the segment'
/
comment on column DBA_SEGMENTS.PCT_INCREASE is
'Percent by which to increase the size of the next extent to be allocated'
/
comment on column DBA_SEGMENTS.FREELISTS is
'Number of process freelists allocated in this segment'
/
comment on column DBA_SEGMENTS.FREELIST_GROUPS is
'Number of freelist groups allocated in this segment'
/
comment on column DBA_SEGMENTS.RELATIVE_FNO is
'Relative number of the file containing the segment header'
/
comment on column DBA_SEGMENTS.BUFFER_POOL is
'The default buffer pool to be used for segments blocks'
/
remark
remark  FAMILY "EXTENTS"
remark  Extents associated with their segments.
remark
create or replace view USER_EXTENTS
    (SEGMENT_NAME, PARTITION_NAME, SEGMENT_TYPE, TABLESPACE_NAME,
     EXTENT_ID, BYTES, BLOCKS)
as
select ds.segment_name, ds.partition_name, ds.segment_type, 
       ds.tablespace_name, e.ext#, e.length * ds.blocksize, e.length
from sys.uet$ e, sys.sys_user_segs ds
where e.segfile# = ds.header_file
  and e.segblock# = ds.header_block
  and e.ts# = ds.tablespace_id
/
comment on table USER_EXTENTS is
'Extents comprising segments owned by the user'
/
comment on column USER_EXTENTS.SEGMENT_NAME is
'Name of the segment associated with the extent'
/
comment on column USER_EXTENTS.PARTITION_NAME is
'Partition Name, if any, of the segment'
/
comment on column USER_EXTENTS.TABLESPACE_NAME is
'Name of the tablespace containing the extent'
/
comment on column USER_EXTENTS.SEGMENT_TYPE is
'Type of the segment'
/
comment on column USER_EXTENTS.EXTENT_ID is
'Extent number in the segment'
/
comment on column USER_EXTENTS.BYTES is
'Size of the extent in bytes'
/
comment on column USER_EXTENTS.BLOCKS is
'Size of the extent in ORACLE blocks'
/
drop public synonym USER_EXTENTS
/
create public synonym USER_EXTENTS for USER_EXTENTS
/
grant select on USER_EXTENTS to PUBLIC with grant option
/
create or replace view DBA_EXTENTS
    (OWNER, SEGMENT_NAME, PARTITION_NAME, SEGMENT_TYPE, TABLESPACE_NAME,
     EXTENT_ID, FILE_ID, BLOCK_ID,
     BYTES, BLOCKS, RELATIVE_FNO)
as
select ds.owner, ds.segment_name, ds.partition_name, ds.segment_type, 
       ds.tablespace_name,
       e.ext#, f.file#, e.block#, e.length * ds.blocksize, e.length, e.file#
from sys.uet$ e, sys.sys_dba_segs ds, sys.file$ f
where e.segfile# = ds.relative_fno
  and e.segblock# = ds.header_block
  and e.ts# = ds.tablespace_id
  and e.ts# = f.ts#
  and e.file# = f.relfile#
/
drop public synonym DBA_EXTENTS
/
create public synonym DBA_EXTENTS for DBA_EXTENTS
/
grant select on DBA_EXTENTS to select_catalog_role
/
comment on table DBA_EXTENTS is
'Extents comprising all segments in the database'
/
comment on column DBA_EXTENTS.OWNER is
'Owner of the segment associated with the extent'
/
comment on column DBA_EXTENTS.SEGMENT_NAME is
'Name of the segment associated with the extent'
/
comment on column DBA_EXTENTS.PARTITION_NAME is
'Partition Name, if any, of the segment'
/
comment on column DBA_EXTENTS.TABLESPACE_NAME is
'Name of the tablespace containing the extent'
/
comment on column DBA_EXTENTS.SEGMENT_TYPE is
'Type of the segment'
/
comment on column DBA_EXTENTS.FILE_ID is
'Name of the file containing the extent'
/
comment on column DBA_EXTENTS.BLOCK_ID is
'Starting block number of the extent'
/
comment on column DBA_EXTENTS.EXTENT_ID is
'Extent number in the segment'
/
comment on column DBA_EXTENTS.BYTES is
'Size of the extent in bytes'
/
comment on column DBA_EXTENTS.BLOCKS is
'Size of the extent in ORACLE blocks'
/
comment on column DBA_EXTENTS.RELATIVE_FNO is
'Relative number of the file containing the segment header'
/
remark
remark  FAMILY "SEQUENCES"
remark  CREATE SEQUENCE information.
remark
create or replace view USER_SEQUENCES
  (SEQUENCE_NAME, MIN_VALUE, MAX_VALUE, INCREMENT_BY,
                  CYCLE_FLAG, ORDER_FLAG, CACHE_SIZE, LAST_NUMBER)
as select o.name,
      s.minvalue, s.maxvalue, s.increment$,
      decode (s.cycle#, 0, 'N', 1, 'Y'),
      decode (s.order$, 0, 'N', 1, 'Y'),
      s.cache, s.highwater
from sys.seq$ s, sys.obj$ o
where o.owner# = userenv('SCHEMAID')
  and o.obj# = s.obj#
/
comment on table USER_SEQUENCES is
'Description of the user''s own SEQUENCEs'
/
comment on column USER_SEQUENCES.SEQUENCE_NAME is
'SEQUENCE name'
/
comment on column USER_SEQUENCES.INCREMENT_BY is
'Value by which sequence is incremented'
/
comment on column USER_SEQUENCES.MIN_VALUE is
'Minimum value of the sequence'
/
comment on column USER_SEQUENCES.MAX_VALUE is
'Maximum value of the sequence'
/
comment on column USER_SEQUENCES.CYCLE_FLAG is
'Does sequence wrap around on reaching limit?'
/
comment on column USER_SEQUENCES.ORDER_FLAG is
'Are sequence numbers generated in order?'
/
comment on column USER_SEQUENCES.CACHE_SIZE is
'Number of sequence numbers to cache'
/
comment on column USER_SEQUENCES.LAST_NUMBER is
'Last sequence number written to disk'
/
drop public synonym USER_SEQUENCES
/
create public synonym USER_SEQUENCES for USER_SEQUENCES
/
drop public synonym SEQ
/
create public synonym SEQ for USER_SEQUENCES
/
grant select on USER_SEQUENCES to PUBLIC with grant option
/
create or replace view ALL_SEQUENCES
  (SEQUENCE_OWNER, SEQUENCE_NAME, 
                  MIN_VALUE, MAX_VALUE, INCREMENT_BY,
                  CYCLE_FLAG, ORDER_FLAG, CACHE_SIZE, LAST_NUMBER)
as select u.name, o.name,
      s.minvalue, s.maxvalue, s.increment$, 
      decode (s.cycle#, 0, 'N', 1, 'Y'),
      decode (s.order$, 0, 'N', 1, 'Y'),
      s.cache, s.highwater
from sys.seq$ s, sys.obj$ o, sys.user$ u
where u.user# = o.owner#
  and o.obj# = s.obj#
  and (o.owner# = userenv('SCHEMAID')
       or o.obj# in
            (select oa.obj#
             from sys.objauth$ oa
             where grantee# in ( select kzsrorol
                                 from x$kzsro
                               )
            )
        or
	 exists (select null from v$enabledprivs
	         where priv_number = -109 /* SELECT ANY SEQUENCE */
                 )
      )
/
comment on table ALL_SEQUENCES is
'Description of SEQUENCEs accessible to the user'
/
comment on column ALL_SEQUENCES.SEQUENCE_OWNER is
'Name of the owner of the sequence'
/
comment on column ALL_SEQUENCES.SEQUENCE_NAME is
'SEQUENCE name'
/
comment on column ALL_SEQUENCES.INCREMENT_BY is
'Value by which sequence is incremented'
/
comment on column ALL_SEQUENCES.MIN_VALUE is
'Minimum value of the sequence'
/
comment on column ALL_SEQUENCES.MAX_VALUE is
'Maximum value of the sequence'
/
comment on column ALL_SEQUENCES.CYCLE_FLAG is
'Does sequence wrap around on reaching limit?'
/
comment on column ALL_SEQUENCES.ORDER_FLAG is
'Are sequence numbers generated in order?'
/
comment on column ALL_SEQUENCES.CACHE_SIZE is
'Number of sequence numbers to cache'
/
comment on column ALL_SEQUENCES.LAST_NUMBER is
'Last sequence number written to disk'
/
drop public synonym ALL_SEQUENCES
/
create public synonym ALL_SEQUENCES for ALL_SEQUENCES
/
grant select on ALL_SEQUENCES to PUBLIC with grant option
/
create or replace view DBA_SEQUENCES
  (SEQUENCE_OWNER, SEQUENCE_NAME, 
                  MIN_VALUE, MAX_VALUE, INCREMENT_BY,
                  CYCLE_FLAG, ORDER_FLAG, CACHE_SIZE, LAST_NUMBER)
as select u.name, o.name,
      s.minvalue, s.maxvalue, s.increment$, 
      decode (s.cycle#, 0, 'N', 1, 'Y'),
      decode (s.order$, 0, 'N', 1, 'Y'),
      s.cache, s.highwater
from sys.seq$ s, sys.obj$ o, sys.user$ u
where u.user# = o.owner#
  and o.obj# = s.obj#
/
drop public synonym DBA_SEQUENCES
/
create public synonym DBA_SEQUENCES for DBA_SEQUENCES
/
grant select on DBA_SEQUENCES to select_catalog_role
/
comment on table DBA_SEQUENCES is
'Description of all SEQUENCEs in the database'
/
comment on column DBA_SEQUENCES.SEQUENCE_OWNER is
'Name of the owner of the sequence'
/
comment on column DBA_SEQUENCES.SEQUENCE_NAME is
'SEQUENCE name'
/
comment on column DBA_SEQUENCES.INCREMENT_BY is
'Value by which sequence is incremented'
/
comment on column DBA_SEQUENCES.MIN_VALUE is
'Minimum value of the sequence'
/
comment on column DBA_SEQUENCES.MAX_VALUE is
'Maximum value of the sequence'
/
comment on column DBA_SEQUENCES.CYCLE_FLAG is
'Does sequence wrap around on reaching limit?'
/
comment on column DBA_SEQUENCES.ORDER_FLAG is
'Are sequence numbers generated in order?'
/
comment on column DBA_SEQUENCES.CACHE_SIZE is
'Number of sequence numbers to cache'
/
comment on column DBA_SEQUENCES.LAST_NUMBER is
'Last sequence number written to disk'
/
remark
remark  FAMILY "SYNONYMS"
remark  CREATE SYNONYM information.
remark
create or replace view USER_SYNONYMS
    (SYNONYM_NAME, TABLE_OWNER, TABLE_NAME, DB_LINK)
as select o.name, s.owner, s.name, s.node
from sys.syn$ s, sys.obj$ o
where o.obj# = s.obj#
  and o.type# = 5
  and o.owner# = userenv('SCHEMAID')
/
comment on table USER_SYNONYMS is
'The user''s private synonyms'
/
comment on column USER_SYNONYMS.SYNONYM_NAME is
'Name of the synonym'
/
comment on column USER_SYNONYMS.TABLE_OWNER is
'Owner of the object referenced by the synonym'
/
comment on column USER_SYNONYMS.TABLE_NAME is
'Name of the object referenced by the synonym'
/
comment on column USER_SYNONYMS.DB_LINK is
'Database link referenced in a remote synonym'
/
drop public synonym SYN
/
create public synonym SYN for USER_SYNONYMS
/
drop public synonym USER_SYNONYMS
/
create public synonym USER_SYNONYMS for USER_SYNONYMS
/
grant select on USER_SYNONYMS to PUBLIC with grant option
/
remark
remark  This view shows all synonyms owned by the user (private synonyms),
remark  plus all public synonyms.
remark
create or replace view ALL_SYNONYMS
    (OWNER, SYNONYM_NAME, TABLE_OWNER, TABLE_NAME, DB_LINK)
as
select u.name, o.name, s.owner, s.name, s.node
from sys.user$ u, sys.syn$ s, sys.obj$ o
where o.obj# = s.obj#
  and o.type# = 5
  and o.owner# = u.user#
  and (
       o.owner# in (USERENV('SCHEMAID'), 1 /* PUBLIC */)  /* user's private, any public */
       or /* user has any privs on base object */
	exists
        (select null from sys.objauth$ ba, sys.obj$ bo, sys.user$ bu
         where bu.name = s.owner
           and bo.name = s.name
           and bu.user# = bo.owner#
           and ba.obj# = bo.obj#
           and ba.grantee# in (select kzsrorol from x$kzsro))
        or /* user has system privileges */
	 exists (select null from v$enabledprivs
	         where priv_number in (-45 /* LOCK ANY TABLE */,
				       -47 /* SELECT ANY TABLE */,
				       -48 /* INSERT ANY TABLE */,
				       -49 /* UPDATE ANY TABLE */,
				       -50 /* DELETE ANY TABLE */)
                 )
       )
/
comment on table ALL_SYNONYMS is
'All synonyms accessible to the user'
/
comment on column ALL_SYNONYMS.OWNER is
'Owner of the synonym'
/
comment on column ALL_SYNONYMS.SYNONYM_NAME is
'Name of the synonym'
/
comment on column ALL_SYNONYMS.TABLE_OWNER is
'Owner of the object referenced by the synonym'
/
comment on column ALL_SYNONYMS.TABLE_NAME is
'Name of the object referenced by the synonym'
/
comment on column ALL_SYNONYMS.DB_LINK is
'Name of the database link referenced in a remote synonym'
/
drop public synonym ALL_SYNONYMS
/
create public synonym ALL_SYNONYMS for ALL_SYNONYMS
/
grant select on ALL_SYNONYMS to PUBLIC with grant option
/
create or replace view DBA_SYNONYMS
    (OWNER, SYNONYM_NAME, TABLE_OWNER, TABLE_NAME, DB_LINK)
as select u.name, o.name, s.owner, s.name, s.node
from sys.user$ u, sys.syn$ s, sys.obj$ o
where o.obj# = s.obj#
  and o.type# = 5
  and o.owner# = u.user#
/
drop public synonym DBA_SYNONYMS
/
create public synonym DBA_SYNONYMS for DBA_SYNONYMS
/
grant select on DBA_SYNONYMS to select_catalog_role
/
comment on table DBA_SYNONYMS is
'All synonyms in the database'
/
comment on column DBA_SYNONYMS.OWNER is
'Username of the owner of the synonym'
/
comment on column DBA_SYNONYMS.SYNONYM_NAME is
'Name of the synonym'
/
comment on column DBA_SYNONYMS.TABLE_OWNER is
'Owner of the object referenced by the synonym'
/
comment on column DBA_SYNONYMS.TABLE_NAME is
'Name of the object referenced by the synonym'
/
comment on column DBA_SYNONYMS.DB_LINK is
'Name of the database link referenced in a remote synonym'
/
remark
remark  FAMILY "TABLES"
remark  CREATE TABLE parameters.
remark
create or replace view USER_TABLES
    (TABLE_NAME, TABLESPACE_NAME, CLUSTER_NAME, IOT_NAME,
     PCT_FREE, PCT_USED,
     INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,
     FREELISTS, FREELIST_GROUPS, LOGGING,
     BACKED_UP, NUM_ROWS, BLOCKS, EMPTY_BLOCKS,
     AVG_SPACE, CHAIN_CNT, AVG_ROW_LEN,
     AVG_SPACE_FREELIST_BLOCKS, NUM_FREELIST_BLOCKS,
     DEGREE, INSTANCES, CACHE, TABLE_LOCK, 
     SAMPLE_SIZE, LAST_ANALYZED, PARTITIONED,
     IOT_TYPE, TEMPORARY, NESTED,
     BUFFER_POOL)
as
select o.name, decode(bitand(t.property, 32), 32, null, 
		      decode(bitand(t.property, 64), 64, null, ts.name)),
       decode(bitand(t.property, 1024), 0, null, co.name), 
       decode(bitand(t.property, 512), 0, null, co.name),
       decode(bitand(t.property, 32), 0, mod(t.pctfree$, 100), null),
       decode(bitand(t.property, 32), 0, t.pctused$, null), 
       decode(bitand(t.property, 32), 0, t.initrans, null), 
       decode(bitand(t.property, 32), 0, t.maxtrans, null),
       s.iniexts * ts.blocksize, s.extsize * ts.blocksize,
       s.minexts, s.maxexts, s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       decode(bitand(t.property, 32), 32, null, 
	        decode(bitand(t.flags, 32), 0, 'YES', 'NO')),
       decode(bitand(t.flags,1), 0, 'Y', 1, 'N', '?'),
       t.rowcnt, t.blkcnt, t.empcnt, t.avgspc, t.chncnt, t.avgrln,
       t.avgspc_flb, t.flbcnt,
       lpad(decode(t.degree, 32767, 'DEFAULT', nvl(t.degree,1)),10),
       lpad(decode(t.instances, 32767, 'DEFAULT', nvl(t.instances,1)),10),
       lpad(decode(bitand(t.flags, 8), 8, 'Y', 'N'),5),
       decode(bitand(t.flags, 6), 0, 'ENABLED', 'DISABLED'),
       t.samplesize, t.analyzetime, 
       decode(bitand(t.property, 32), 32, 'YES', 'NO'),
       decode(bitand(t.property, 64), 64, 'IOT', 
               decode(bitand(t.property, 512), 512, 'IOT_OVERFLOW', null)),
            decode(bitand(o.flags, 2), 0, 'N', 2, 'Y', 'N'), 
       decode(bitand(t.property, 8192), 8192, 'YES',
              decode(bitand(t.property, 1), 0, 'NO', 'YES')),
       decode(s.cachehint, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from sys.ts$ ts, sys.seg$ s, sys.obj$ co, sys.tab$ t, sys.obj$ o
where o.owner# = userenv('SCHEMAID')
  and o.obj# = t.obj#
  and bitand(t.property, 1) = 0
  and t.bobj# = co.obj# (+)
  and t.ts# = ts.ts#
  and t.file# = s.file# (+)
  and t.block# = s.block# (+)
  and t.ts# = s.ts# (+)
/
comment on table USER_TABLES is
'Description of the user''s own relational tables'
/
comment on column USER_TABLES.TABLE_NAME is
'Name of the table'
/
comment on column USER_TABLES.TABLESPACE_NAME is
'Name of the tablespace containing the table'
/
comment on column USER_TABLES.CLUSTER_NAME is
'Name of the cluster, if any, to which the table belongs'
/
comment on column USER_TABLES.IOT_NAME is
'Name of the index-only table, if any, to which the overflow entry belongs'
/
comment on column USER_TABLES.PCT_FREE is
'Minimum percentage of free space in a block'
/
comment on column USER_TABLES.PCT_USED is
'Minimum percentage of used space in a block'
/
comment on column USER_TABLES.INI_TRANS is
'Initial number of transactions'
/
comment on column USER_TABLES.MAX_TRANS is
'Maximum number of transactions'
/
comment on column USER_TABLES.INITIAL_EXTENT is
'Size of the initial extent in bytes'
/
comment on column USER_TABLES.NEXT_EXTENT is
'Size of secondary extents in bytes'
/
comment on column USER_TABLES.MIN_EXTENTS is
'Minimum number of extents allowed in the segment'
/
comment on column USER_TABLES.MAX_EXTENTS is
'Maximum number of extents allowed in the segment'
/
comment on column USER_TABLES.PCT_INCREASE is
'Percentage increase in extent size'
/
comment on column USER_TABLES.FREELISTS is
'Number of process freelists allocated in this segment'
/
comment on column USER_TABLES.FREELIST_GROUPS is
'Number of freelist groups allocated in this segment'
/
comment on column USER_TABLES.LOGGING is
'Logging attribute'
/
comment on column USER_TABLES.BACKED_UP is
'Has table been backed up since last modification?'
/
comment on column USER_TABLES.NUM_ROWS is
'The number of rows in the table'
/
comment on column USER_TABLES.BLOCKS is
'The number of used blocks in the table'
/
comment on column USER_TABLES.EMPTY_BLOCKS is
'The number of empty (never used) blocks in the table'
/
comment on column USER_TABLES.AVG_SPACE is
'The average available free space in the table'
/
comment on column USER_TABLES.CHAIN_CNT is
'The number of chained rows in the table'
/
comment on column USER_TABLES.AVG_ROW_LEN is
'The average row length, including row overhead'
/
comment on column USER_TABLES.AVG_SPACE_FREELIST_BLOCKS is
'The average freespace of all blocks on a freelist'
/
comment on column USER_TABLES.NUM_FREELIST_BLOCKS is
'The number of blocks on the freelist'
/
comment on column USER_TABLES.DEGREE is
'The number of threads per instance for scanning the table'
/
comment on column USER_TABLES.INSTANCES is
'The number of instances across which the table is to be scanned'
/
comment on column USER_TABLES.CACHE is
'Whether the table is to be cached in the buffer cache'
/
comment on column USER_TABLES.TABLE_LOCK is
'Whether table locking is enabled or disabled'
/
comment on column USER_TABLES.SAMPLE_SIZE is
'The sample size used in analyzing this table'
/
comment on column USER_TABLES.LAST_ANALYZED is
'The date of the most recent time this table was analyzed'
/
comment on column USER_TABLES.PARTITIONED is
'Is this table partitioned? YES or NO'
/
comment on column USER_TABLES.IOT_TYPE is
'If index-only table, then IOT_TYPE is IOT or IOT_OVERFLOW else NULL'
/
comment on column USER_TABLES.TEMPORARY is
'Can the current session only see data that it place in this object itself?'
/
comment on column USER_TABLES.NESTED is
'Is the table a nested table?'
/
comment on column USER_TABLES.BUFFER_POOL is
'The default buffer pool to be used for table blocks'
/
drop public synonym USER_TABLES
/
create public synonym USER_TABLES for USER_TABLES
/
drop public synonym TABS
/
create public synonym TABS for USER_TABLES
/
grant select on USER_TABLES to PUBLIC with grant option
/
create or replace view USER_OBJECT_TABLES
    (TABLE_NAME, TABLESPACE_NAME, CLUSTER_NAME, IOT_NAME,
     PCT_FREE, PCT_USED,
     INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,
     FREELISTS, FREELIST_GROUPS, LOGGING,
     BACKED_UP, NUM_ROWS, BLOCKS, EMPTY_BLOCKS,
     AVG_SPACE, CHAIN_CNT, AVG_ROW_LEN,
     AVG_SPACE_FREELIST_BLOCKS, NUM_FREELIST_BLOCKS,
     DEGREE, INSTANCES, CACHE, TABLE_LOCK, 
     SAMPLE_SIZE, LAST_ANALYZED, PARTITIONED,
     IOT_TYPE,
     TABLE_TYPE_OWNER, TABLE_TYPE, TEMPORARY, NESTED,
     BUFFER_POOL)
as
select o.name, decode(bitand(t.property, 32), 32, null, ts.name), 
       decode(bitand(t.property, 1024), 0, null, co.name), 
       decode(bitand(t.property, 512), 0, null, co.name),
       decode(bitand(t.property, 32), 0, mod(t.pctfree$, 100), null),
       decode(bitand(t.property, 32), 0, t.pctused$, null), 
       decode(bitand(t.property, 32), 0, t.initrans, null), 
       decode(bitand(t.property, 32), 0, t.maxtrans, null),
       s.iniexts * ts.blocksize, s.extsize * ts.blocksize,
       s.minexts, s.maxexts, s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       decode(bitand(t.property, 32), 32, null, 
	        decode(bitand(t.flags, 32), 0, 'YES', 'NO')),
       decode(bitand(t.flags,1), 0, 'Y', 1, 'N', '?'),
       t.rowcnt, t.blkcnt, t.empcnt, t.avgspc, t.chncnt, t.avgrln,
       t.avgspc_flb, t.flbcnt,
       lpad(decode(t.degree, 32767, 'DEFAULT', nvl(t.degree,1)),10),
       lpad(decode(t.instances, 32767, 'DEFAULT', nvl(t.instances,1)),10),
       lpad(decode(bitand(t.flags, 8), 8, 'Y', 'N'),5),
       decode(bitand(t.flags, 6), 0, 'ENABLED', 'DISABLED'),
       t.samplesize, t.analyzetime, 
       decode(bitand(t.property, 32), 32, 'YES', 'NO'),
       decode(bitand(t.property, 64), 64, 'IOT', 
               decode(bitand(t.property, 512), 512, 'IOT_OVERFLOW', null)),
       tu.name, ty.name,
       decode(bitand(o.flags, 2), 0, 'N', 2, 'Y', 'N'), 
       decode(bitand(t.property, 8192), 8192, 'YES', 'NO'),
       decode(s.cachehint, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from sys.ts$ ts, sys.seg$ s, sys.obj$ co, sys.tab$ t, sys.obj$ o,
     sys.coltype$ ac, sys.obj$ ty, sys.user$ tu, sys.col$ tc
where o.owner# = userenv('SCHEMAID')
  and o.obj# = t.obj#
  and bitand(t.property, 1) = 1
  and t.obj# = tc.obj#
  and tc.name = 'SYS_NC_ROWINFO$'
  and tc.obj# = ac.obj#
  and tc.intcol# = ac.intcol#
  and ac.toid = ty.oid$
  and ty.type# <> 10
  and ty.owner# = tu.user#
  and t.bobj# = co.obj# (+)
  and t.ts# = ts.ts#
  and t.file# = s.file# (+)
  and t.block# = s.block# (+)
  and t.ts# = s.ts# (+)
/
comment on table USER_OBJECT_TABLES is
'Description of the user''s own object tables'
/
comment on column USER_OBJECT_TABLES.TABLE_NAME is
'Name of the table'
/
comment on column USER_OBJECT_TABLES.TABLESPACE_NAME is
'Name of the tablespace containing the table'
/
comment on column USER_OBJECT_TABLES.CLUSTER_NAME is
'Name of the cluster, if any, to which the table belongs'
/
comment on column USER_OBJECT_TABLES.IOT_NAME is
'Name of the index-only table, if any, to which the overflow entry belongs'
/
comment on column USER_OBJECT_TABLES.PCT_FREE is
'Minimum percentage of free space in a block'
/
comment on column USER_OBJECT_TABLES.PCT_USED is
'Minimum percentage of used space in a block'
/
comment on column USER_OBJECT_TABLES.INI_TRANS is
'Initial number of transactions'
/
comment on column USER_OBJECT_TABLES.MAX_TRANS is
'Maximum number of transactions'
/
comment on column USER_OBJECT_TABLES.INITIAL_EXTENT is
'Size of the initial extent in bytes'
/
comment on column USER_OBJECT_TABLES.NEXT_EXTENT is
'Size of secondary extents in bytes'
/
comment on column USER_OBJECT_TABLES.MIN_EXTENTS is
'Minimum number of extents allowed in the segment'
/
comment on column USER_OBJECT_TABLES.MAX_EXTENTS is
'Maximum number of extents allowed in the segment'
/
comment on column USER_OBJECT_TABLES.PCT_INCREASE is
'Percentage increase in extent size'
/
comment on column USER_OBJECT_TABLES.FREELISTS is
'Number of process freelists allocated in this segment'
/
comment on column USER_OBJECT_TABLES.FREELIST_GROUPS is
'Number of freelist groups allocated in this segment'
/
comment on column USER_OBJECT_TABLES.LOGGING is
'Logging attribute'
/
comment on column USER_OBJECT_TABLES.BACKED_UP is
'Has table been backed up since last modification?'
/
comment on column USER_OBJECT_TABLES.NUM_ROWS is
'The number of rows in the table'
/
comment on column USER_OBJECT_TABLES.BLOCKS is
'The number of used blocks in the table'
/
comment on column USER_OBJECT_TABLES.EMPTY_BLOCKS is
'The number of empty (never used) blocks in the table'
/
comment on column USER_OBJECT_TABLES.AVG_SPACE is
'The average available free space in the table'
/
comment on column USER_OBJECT_TABLES.CHAIN_CNT is
'The number of chained rows in the table'
/
comment on column USER_OBJECT_TABLES.AVG_ROW_LEN is
'The average row length, including row overhead'
/
comment on column USER_OBJECT_TABLES.AVG_SPACE_FREELIST_BLOCKS is
'The average freespace of all blocks on a freelist'
/
comment on column USER_OBJECT_TABLES.NUM_FREELIST_BLOCKS is
'The number of blocks on the freelist'
/
comment on column USER_OBJECT_TABLES.DEGREE is
'The number of threads per instance for scanning the table'
/
comment on column USER_OBJECT_TABLES.INSTANCES is
'The number of instances across which the table is to be scanned'
/
comment on column USER_OBJECT_TABLES.CACHE is
'Whether the table is to be cached in the buffer cache'
/
comment on column USER_OBJECT_TABLES.TABLE_LOCK is
'Whether table locking is enabled or disabled'
/
comment on column USER_OBJECT_TABLES.SAMPLE_SIZE is
'The sample size used in analyzing this table'
/
comment on column USER_OBJECT_TABLES.LAST_ANALYZED is
'The date of the most recent time this table was analyzed'
/
comment on column USER_OBJECT_TABLES.PARTITIONED is
'Is this table partitioned? YES or NO'
/
comment on column USER_OBJECT_TABLES.IOT_TYPE is
'If index-only table, then IOT_TYPE is IOT or IOT_OVERFLOW else NULL'
/
comment on column USER_OBJECT_TABLES.TABLE_TYPE_OWNER is
'Owner of the type of the table if the table is an object table'
/
comment on column USER_OBJECT_TABLES.TABLE_TYPE is
'Type of the table if the table is an object table'
/
comment on column USER_OBJECT_TABLES.TEMPORARY is
'Can the current session only see data that it place in this object itself?'
/
comment on column USER_OBJECT_TABLES.NESTED is
'Is the table a nested table?'
/
comment on column USER_OBJECT_TABLES.BUFFER_POOL is
'The default buffer pool to be used for table blocks'
/
drop public synonym USER_OBJECT_TABLES
/
create public synonym USER_OBJECT_TABLES for USER_OBJECT_TABLES
/
grant select on USER_OBJECT_TABLES to PUBLIC with grant option
/
create or replace view USER_ALL_TABLES
    (TABLE_NAME, TABLESPACE_NAME, CLUSTER_NAME, IOT_NAME,
     PCT_FREE, PCT_USED,
     INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,
     FREELISTS, FREELIST_GROUPS, LOGGING,
     BACKED_UP, NUM_ROWS, BLOCKS, EMPTY_BLOCKS,
     AVG_SPACE, CHAIN_CNT, AVG_ROW_LEN,
     AVG_SPACE_FREELIST_BLOCKS, NUM_FREELIST_BLOCKS,
     DEGREE, INSTANCES, CACHE, TABLE_LOCK, 
     SAMPLE_SIZE, LAST_ANALYZED, PARTITIONED,
     IOT_TYPE,
     TABLE_TYPE_OWNER, TABLE_TYPE, TEMPORARY, NESTED,
     BUFFER_POOL)
as
select TABLE_NAME, TABLESPACE_NAME, CLUSTER_NAME, IOT_NAME,
     PCT_FREE, PCT_USED,
     INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,
     FREELISTS, FREELIST_GROUPS, LOGGING,
     BACKED_UP, NUM_ROWS, BLOCKS, EMPTY_BLOCKS,
     AVG_SPACE, CHAIN_CNT, AVG_ROW_LEN,
     AVG_SPACE_FREELIST_BLOCKS, NUM_FREELIST_BLOCKS,
     DEGREE, INSTANCES, CACHE, TABLE_LOCK, 
     SAMPLE_SIZE, LAST_ANALYZED, PARTITIONED,
     IOT_TYPE,
     NULL, NULL, TEMPORARY, NESTED,
     BUFFER_POOL
from user_tables
union all
select TABLE_NAME, TABLESPACE_NAME, CLUSTER_NAME, IOT_NAME,
     PCT_FREE, PCT_USED,
     INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,
     FREELISTS, FREELIST_GROUPS, LOGGING,
     BACKED_UP, NUM_ROWS, BLOCKS, EMPTY_BLOCKS,
     AVG_SPACE, CHAIN_CNT, AVG_ROW_LEN,
     AVG_SPACE_FREELIST_BLOCKS, NUM_FREELIST_BLOCKS,
     DEGREE, INSTANCES, CACHE, TABLE_LOCK, 
     SAMPLE_SIZE, LAST_ANALYZED, PARTITIONED,
     IOT_TYPE,
     TABLE_TYPE_OWNER, TABLE_TYPE, TEMPORARY, NESTED,
     BUFFER_POOL
from user_object_tables
/
comment on table USER_ALL_TABLES is
'Description of all object and relational tables owned by the user''s'
/
comment on column USER_ALL_TABLES.TABLE_NAME is
'Name of the table'
/
comment on column USER_ALL_TABLES.TABLESPACE_NAME is
'Name of the tablespace containing the table'
/
comment on column USER_ALL_TABLES.CLUSTER_NAME is
'Name of the cluster, if any, to which the table belongs'
/
comment on column USER_ALL_TABLES.IOT_NAME is
'Name of the index-only table, if any, to which the overflow entry belongs'
/
comment on column USER_ALL_TABLES.PCT_FREE is
'Minimum percentage of free space in a block'
/
comment on column USER_ALL_TABLES.PCT_USED is
'Minimum percentage of used space in a block'
/
comment on column USER_ALL_TABLES.INI_TRANS is
'Initial number of transactions'
/
comment on column USER_ALL_TABLES.MAX_TRANS is
'Maximum number of transactions'
/
comment on column USER_ALL_TABLES.INITIAL_EXTENT is
'Size of the initial extent in bytes'
/
comment on column USER_ALL_TABLES.NEXT_EXTENT is
'Size of secondary extents in bytes'
/
comment on column USER_ALL_TABLES.MIN_EXTENTS is
'Minimum number of extents allowed in the segment'
/
comment on column USER_ALL_TABLES.MAX_EXTENTS is
'Maximum number of extents allowed in the segment'
/
comment on column USER_ALL_TABLES.PCT_INCREASE is
'Percentage increase in extent size'
/
comment on column USER_ALL_TABLES.FREELISTS is
'Number of process freelists allocated in this segment'
/
comment on column USER_ALL_TABLES.FREELIST_GROUPS is
'Number of freelist groups allocated in this segment'
/
comment on column USER_ALL_TABLES.LOGGING is
'Logging attribute'
/
comment on column USER_ALL_TABLES.BACKED_UP is
'Has table been backed up since last modification?'
/
comment on column USER_ALL_TABLES.NUM_ROWS is
'The number of rows in the table'
/
comment on column USER_ALL_TABLES.BLOCKS is
'The number of used blocks in the table'
/
comment on column USER_ALL_TABLES.EMPTY_BLOCKS is
'The number of empty (never used) blocks in the table'
/
comment on column USER_ALL_TABLES.AVG_SPACE is
'The average available free space in the table'
/
comment on column USER_ALL_TABLES.CHAIN_CNT is
'The number of chained rows in the table'
/
comment on column USER_ALL_TABLES.AVG_ROW_LEN is
'The average row length, including row overhead'
/
comment on column USER_ALL_TABLES.AVG_SPACE_FREELIST_BLOCKS is
'The average freespace of all blocks on a freelist'
/
comment on column USER_ALL_TABLES.NUM_FREELIST_BLOCKS is
'The number of blocks on the freelist'
/
comment on column USER_ALL_TABLES.DEGREE is
'The number of threads per instance for scanning the table'
/
comment on column USER_ALL_TABLES.INSTANCES is
'The number of instances across which the table is to be scanned'
/
comment on column USER_ALL_TABLES.CACHE is
'Whether the table is to be cached in the buffer cache'
/
comment on column USER_ALL_TABLES.TABLE_LOCK is
'Whether table locking is enabled or disabled'
/
comment on column USER_ALL_TABLES.SAMPLE_SIZE is
'The sample size used in analyzing this table'
/
comment on column USER_ALL_TABLES.LAST_ANALYZED is
'The date of the most recent time this table was analyzed'
/
comment on column USER_ALL_TABLES.PARTITIONED is
'Is this table partitioned? YES or NO'
/
comment on column USER_ALL_TABLES.IOT_TYPE is
'If index-only table, then IOT_TYPE is IOT or IOT_OVERFLOW else NULL'
/
comment on column USER_ALL_TABLES.TABLE_TYPE_OWNER is
'Owner of the type of the table if the table is an object table'
/
comment on column USER_ALL_TABLES.TABLE_TYPE is
'Type of the table if the table is an object table'
/
comment on column USER_ALL_TABLES.TEMPORARY is
'Can the current session only see data that it place in this object itself?'
/
comment on column USER_ALL_TABLES.NESTED is
'Is the table a nested table?'
/
comment on column USER_ALL_TABLES.BUFFER_POOL is
'The default buffer pool to be used for table blocks'
/
drop public synonym USER_ALL_TABLES
/
create public synonym USER_ALL_TABLES for USER_ALL_TABLES
/
grant select on USER_ALL_TABLES to PUBLIC with grant option
/
create or replace view ALL_TABLES
    (OWNER, TABLE_NAME, TABLESPACE_NAME, CLUSTER_NAME, IOT_NAME,
     PCT_FREE, PCT_USED,
     INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,
     FREELISTS, FREELIST_GROUPS, LOGGING,
     BACKED_UP, NUM_ROWS, BLOCKS, EMPTY_BLOCKS,
     AVG_SPACE, CHAIN_CNT, AVG_ROW_LEN,
     AVG_SPACE_FREELIST_BLOCKS, NUM_FREELIST_BLOCKS,
     DEGREE, INSTANCES, CACHE, TABLE_LOCK, 
     SAMPLE_SIZE, LAST_ANALYZED, PARTITIONED,
     IOT_TYPE, TEMPORARY, NESTED,
     BUFFER_POOL)
as
select u.name, o.name,decode(bitand(t.property, 32), 32, null, 
	 		     decode(bitand(t.property, 64), 64, null, ts.name)), 
       decode(bitand(t.property, 1024), 0, null, co.name), 
       decode(bitand(t.property, 512), 0, null, co.name),
       decode(bitand(t.property, 32), 0, mod(t.pctfree$, 100), null),
       decode(bitand(t.property, 32), 0, t.pctused$, null), 
       decode(bitand(t.property, 32), 0, t.initrans, null), 
       decode(bitand(t.property, 32), 0, t.maxtrans, null),
       s.iniexts * ts.blocksize, s.extsize * ts.blocksize,
       s.minexts, s.maxexts, s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       decode(bitand(t.property, 32), 32, null, 
	        decode(bitand(t.flags, 32), 0, 'YES', 'NO')),
       decode(bitand(t.flags,1), 0, 'Y', 1, 'N', '?'),
       t.rowcnt, t.blkcnt, t.empcnt, t.avgspc, t.chncnt, t.avgrln,
       t.avgspc_flb, t.flbcnt,
       lpad(decode(t.degree, 32767, 'DEFAULT', nvl(t.degree,1)),10),
       lpad(decode(t.instances, 32767, 'DEFAULT', nvl(t.instances,1)),10),
       lpad(decode(bitand(t.flags, 8), 8, 'Y', 'N'),5),
       decode(bitand(t.flags, 6), 0, 'ENABLED', 'DISABLED'),
       t.samplesize, t.analyzetime,
       decode(bitand(t.property, 32), 32, 'YES', 'NO'),
       decode(bitand(t.property, 64), 64, 'IOT', 
               decode(bitand(t.property, 512), 512, 'IOT_OVERFLOW', null)),
       decode(bitand(o.flags, 2), 0, 'N', 2, 'Y', 'N'), 
       decode(bitand(t.property, 8192), 8192, 'YES',
              decode(bitand(t.property, 1), 0, 'NO', 'YES')),
       decode(s.cachehint, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from sys.user$ u, sys.ts$ ts, sys.seg$ s, sys.obj$ co, sys.tab$ t, sys.obj$ o
where o.owner# = u.user#
  and o.obj# = t.obj#
  and bitand(t.property, 1) = 0
  and t.bobj# = co.obj# (+)
  and t.ts# = ts.ts#
  and t.file# = s.file# (+)
  and t.block# = s.block# (+)
  and t.ts# = s.ts# (+)
  and (o.owner# = userenv('SCHEMAID')
       or o.obj# in
            (select oa.obj#
             from sys.objauth$ oa
             where grantee# in ( select kzsrorol
                                 from x$kzsro
                               ) 
            )
       or /* user has system privileges */
	 exists (select null from v$enabledprivs
	         where priv_number in (-45 /* LOCK ANY TABLE */,
				       -47 /* SELECT ANY TABLE */,
				       -48 /* INSERT ANY TABLE */,
				       -49 /* UPDATE ANY TABLE */,
				       -50 /* DELETE ANY TABLE */)
                 )
      )
/
comment on table ALL_TABLES is
'Description of relational tables accessible to the user'
/
comment on column ALL_TABLES.OWNER is
'Owner of the table'
/
comment on column ALL_TABLES.TABLE_NAME is
'Name of the table'
/
comment on column ALL_TABLES.TABLESPACE_NAME is
'Name of the tablespace containing the table'
/
comment on column ALL_TABLES.CLUSTER_NAME is
'Name of the cluster, if any, to which the table belongs'
/
comment on column ALL_TABLES.IOT_NAME is
'Name of the index-only table, if any, to which the overflow entry belongs'
/
comment on column ALL_TABLES.PCT_FREE is
'Minimum percentage of free space in a block'
/
comment on column ALL_TABLES.PCT_USED is
'Minimum percentage of used space in a block'
/
comment on column ALL_TABLES.INI_TRANS is
'Initial number of transactions'
/
comment on column ALL_TABLES.MAX_TRANS is
'Maximum number of transactions'
/
comment on column ALL_TABLES.INITIAL_EXTENT is
'Size of the initial extent in bytes'
/
comment on column ALL_TABLES.NEXT_EXTENT is
'Size of secondary extents in bytes'
/
comment on column ALL_TABLES.MIN_EXTENTS is
'Minimum number of extents allowed in the segment'
/
comment on column ALL_TABLES.MAX_EXTENTS is
'Maximum number of extents allowed in the segment'
/
comment on column ALL_TABLES.PCT_INCREASE is
'Percentage increase in extent size'
/
comment on column ALL_TABLES.FREELISTS is
'Number of process freelists allocated in this segment'
/
comment on column ALL_TABLES.FREELIST_GROUPS is
'Number of freelist groups allocated in this segment'
/
comment on column ALL_TABLES.LOGGING is
'Logging attribute'
/
comment on column ALL_TABLES.BACKED_UP is
'Has table been backed up since last modification?'
/
comment on column ALL_TABLES.NUM_ROWS is
'The number of rows in the table'
/
comment on column ALL_TABLES.BLOCKS is
'The number of used blocks in the table'
/
comment on column ALL_TABLES.EMPTY_BLOCKS is
'The number of empty (never used) blocks in the table'
/
comment on column ALL_TABLES.AVG_SPACE is
'The average available free space in the table'
/
comment on column ALL_TABLES.CHAIN_CNT is
'The number of chained rows in the table'
/
comment on column ALL_TABLES.AVG_ROW_LEN is
'The average row length, including row overhead'
/
comment on column ALL_TABLES.AVG_SPACE_FREELIST_BLOCKS is
'The average freespace of all blocks on a freelist'
/
comment on column ALL_TABLES.NUM_FREELIST_BLOCKS is
'The number of blocks on the freelist'
/
comment on column ALL_TABLES.DEGREE is
'The number of threads per instance for scanning the table'
/
comment on column ALL_TABLES.INSTANCES is
'The number of instances across which the table is to be scanned'
/
comment on column ALL_TABLES.CACHE is
'Whether the table is to be cached in the buffer cache'
/
comment on column ALL_TABLES.TABLE_LOCK is
'Whether table locking is enabled or disabled'
/
comment on column ALL_TABLES.SAMPLE_SIZE is
'The sample size used in analyzing this table'
/
comment on column ALL_TABLES.LAST_ANALYZED is
'The date of the most recent time this table was analyzed'
/
comment on column ALL_TABLES.PARTITIONED is
'Is this table partitioned? YES or NO'
/
comment on column ALL_TABLES.IOT_TYPE is
'If index-only table, then IOT_TYPE is IOT or IOT_OVERFLOW else NULL'
/
comment on column ALL_TABLES.TEMPORARY is
'Can the current session only see data that it place in this object itself?'
/
comment on column ALL_TABLES.NESTED is
'Is the table a nested table?'
/
comment on column ALL_TABLES.BUFFER_POOL is
'The default buffer pool to be used for table blocks'
/
drop public synonym ALL_TABLES
/
create public synonym ALL_TABLES for ALL_TABLES
/
grant select on ALL_TABLES to PUBLIC with grant option
/
create or replace view ALL_OBJECT_TABLES
    (OWNER, TABLE_NAME, TABLESPACE_NAME, CLUSTER_NAME, IOT_NAME,
     PCT_FREE, PCT_USED,
     INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,
     FREELISTS, FREELIST_GROUPS, LOGGING,
     BACKED_UP, NUM_ROWS, BLOCKS, EMPTY_BLOCKS,
     AVG_SPACE, CHAIN_CNT, AVG_ROW_LEN,
     AVG_SPACE_FREELIST_BLOCKS, NUM_FREELIST_BLOCKS,
     DEGREE, INSTANCES, CACHE, TABLE_LOCK, 
     SAMPLE_SIZE, LAST_ANALYZED, PARTITIONED,
     IOT_TYPE, 
     TABLE_TYPE_OWNER, TABLE_TYPE, TEMPORARY, NESTED, 
     BUFFER_POOL)
as
select u.name, o.name, ts.name,
       decode(bitand(t.property, 1024), 0, null, co.name), 
       decode(bitand(t.property, 512), 0, null, co.name),
       decode(bitand(t.property, 32), 0, mod(t.pctfree$, 100), null),
       decode(bitand(t.property, 32), 0, t.pctused$, null), 
       decode(bitand(t.property, 32), 0, t.initrans, null), 
       decode(bitand(t.property, 32), 0, t.maxtrans, null),
       s.iniexts * ts.blocksize, s.extsize * ts.blocksize,
       s.minexts, s.maxexts, s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       decode(bitand(t.property, 32), 32, null, 
	        decode(bitand(t.flags, 32), 0, 'YES', 'NO')),
       decode(bitand(t.flags,1), 0, 'Y', 1, 'N', '?'),
       t.rowcnt, t.blkcnt, t.empcnt, t.avgspc, t.chncnt, t.avgrln,
       t.avgspc_flb, t.flbcnt,
       lpad(decode(t.degree, 32767, 'DEFAULT', nvl(t.degree,1)),10),
       lpad(decode(t.instances, 32767, 'DEFAULT', nvl(t.instances,1)),10),
       lpad(decode(bitand(t.flags, 8), 8, 'Y', 'N'),5),
       decode(bitand(t.flags, 6), 0, 'ENABLED', 'DISABLED'),
       t.samplesize, t.analyzetime,
       decode(bitand(t.property, 32), 32, 'YES', 'NO'),
       decode(bitand(t.property, 64), 64, 'IOT', 
               decode(bitand(t.property, 512), 512, 'IOT_OVERFLOW', null)),
       tu.name, ty.name, 
       decode(bitand(o.flags, 2), 0, 'N', 2, 'Y', 'N'),
       decode(bitand(t.property, 8192), 8192, 'YES', 'NO'),
       decode(s.cachehint, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from sys.user$ u, sys.ts$ ts, sys.seg$ s, sys.obj$ co, sys.tab$ t, sys.obj$ o,
     sys.coltype$ ac, sys.obj$ ty, sys.user$ tu, sys.col$ tc
where o.owner# = u.user#
  and o.obj# = t.obj#
  and bitand(t.property, 1) = 1
  and t.obj# = tc.obj#
  and tc.name = 'SYS_NC_ROWINFO$'
  and tc.obj# = ac.obj#
  and tc.intcol# = ac.intcol#
  and ac.toid = ty.oid$
  and ty.type# <> 10
  and ty.owner# = tu.user#
  and t.bobj# = co.obj# (+)
  and t.ts# = ts.ts#
  and t.file# = s.file# (+)
  and t.block# = s.block# (+)
  and t.ts# = s.ts# (+)
  and (o.owner# = userenv('SCHEMAID')
       or o.obj# in
            (select oa.obj#
             from sys.objauth$ oa
             where grantee# in ( select kzsrorol
                                 from x$kzsro
                               ) 
            )
       or /* user has system privileges */
	 exists (select null from v$enabledprivs
	         where priv_number in (-45 /* LOCK ANY TABLE */,
				       -47 /* SELECT ANY TABLE */,
				       -48 /* INSERT ANY TABLE */,
				       -49 /* UPDATE ANY TABLE */,
				       -50 /* DELETE ANY TABLE */)
                 )
      )
/
comment on table ALL_OBJECT_TABLES is
'Description of all object tables accessible to the user'
/
comment on column ALL_OBJECT_TABLES.OWNER is
'Owner of the table'
/
comment on column ALL_OBJECT_TABLES.TABLE_NAME is
'Name of the table'
/
comment on column ALL_OBJECT_TABLES.TABLESPACE_NAME is
'Name of the tablespace containing the table'
/
comment on column ALL_OBJECT_TABLES.CLUSTER_NAME is
'Name of the cluster, if any, to which the table belongs'
/
comment on column ALL_OBJECT_TABLES.IOT_NAME is
'Name of the index-only table, if any, to which the overflow entry belongs'
/
comment on column ALL_OBJECT_TABLES.PCT_FREE is
'Minimum percentage of free space in a block'
/
comment on column ALL_OBJECT_TABLES.PCT_USED is
'Minimum percentage of used space in a block'
/
comment on column ALL_OBJECT_TABLES.INI_TRANS is
'Initial number of transactions'
/
comment on column ALL_OBJECT_TABLES.MAX_TRANS is
'Maximum number of transactions'
/
comment on column ALL_OBJECT_TABLES.INITIAL_EXTENT is
'Size of the initial extent in bytes'
/
comment on column ALL_OBJECT_TABLES.NEXT_EXTENT is
'Size of secondary extents in bytes'
/
comment on column ALL_OBJECT_TABLES.MIN_EXTENTS is
'Minimum number of extents allowed in the segment'
/
comment on column ALL_OBJECT_TABLES.MAX_EXTENTS is
'Maximum number of extents allowed in the segment'
/
comment on column ALL_OBJECT_TABLES.PCT_INCREASE is
'Percentage increase in extent size'
/
comment on column ALL_OBJECT_TABLES.FREELISTS is
'Number of process freelists allocated in this segment'
/
comment on column ALL_OBJECT_TABLES.FREELIST_GROUPS is
'Number of freelist groups allocated in this segment'
/
comment on column ALL_OBJECT_TABLES.LOGGING is
'Logging attribute'
/
comment on column ALL_OBJECT_TABLES.BACKED_UP is
'Has table been backed up since last modification?'
/
comment on column ALL_OBJECT_TABLES.NUM_ROWS is
'The number of rows in the table'
/
comment on column ALL_OBJECT_TABLES.BLOCKS is
'The number of used blocks in the table'
/
comment on column ALL_OBJECT_TABLES.EMPTY_BLOCKS is
'The number of empty (never used) blocks in the table'
/
comment on column ALL_OBJECT_TABLES.AVG_SPACE is
'The average available free space in the table'
/
comment on column ALL_OBJECT_TABLES.CHAIN_CNT is
'The number of chained rows in the table'
/
comment on column ALL_OBJECT_TABLES.AVG_ROW_LEN is
'The average row length, including row overhead'
/
comment on column ALL_OBJECT_TABLES.AVG_SPACE_FREELIST_BLOCKS is
'The average freespace of all blocks on a freelist'
/
comment on column ALL_OBJECT_TABLES.NUM_FREELIST_BLOCKS is
'The number of blocks on the freelist'
/
comment on column ALL_OBJECT_TABLES.DEGREE is
'The number of threads per instance for scanning the table'
/
comment on column ALL_OBJECT_TABLES.INSTANCES is
'The number of instances across which the table is to be scanned'
/
comment on column ALL_OBJECT_TABLES.CACHE is
'Whether the table is to be cached in the buffer cache'
/
comment on column ALL_OBJECT_TABLES.TABLE_LOCK is
'Whether table locking is enabled or disabled'
/
comment on column ALL_OBJECT_TABLES.SAMPLE_SIZE is
'The sample size used in analyzing this table'
/
comment on column ALL_OBJECT_TABLES.LAST_ANALYZED is
'The date of the most recent time this table was analyzed'
/
comment on column ALL_OBJECT_TABLES.PARTITIONED is
'Is this table partitioned? YES or NO'
/
comment on column ALL_OBJECT_TABLES.IOT_TYPE is
'If index-only table, then IOT_TYPE is IOT or IOT_OVERFLOW else NULL'
/
comment on column ALL_OBJECT_TABLES.TABLE_TYPE_OWNER is
'Owner of the type of the table if the table is an object table'
/
comment on column ALL_OBJECT_TABLES.TABLE_TYPE is
'Type of the table if the table is an object table'
/
comment on column ALL_OBJECT_TABLES.TEMPORARY is
'Can the current session only see data that it place in this object itself?'
/
comment on column ALL_OBJECT_TABLES.NESTED is
'Is the table a nested table?'
/
comment on column ALL_OBJECT_TABLES.BUFFER_POOL is
'The default buffer pool to be used for table blocks'
/
drop public synonym ALL_OBJECT_TABLES
/
create public synonym ALL_OBJECT_TABLES for ALL_OBJECT_TABLES
/
grant select on ALL_OBJECT_TABLES to PUBLIC with grant option
/
create or replace view ALL_ALL_TABLES
    (OWNER, TABLE_NAME, TABLESPACE_NAME, CLUSTER_NAME, IOT_NAME,
     PCT_FREE, PCT_USED,
     INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,
     FREELISTS, FREELIST_GROUPS, LOGGING,
     BACKED_UP, NUM_ROWS, BLOCKS, EMPTY_BLOCKS,
     AVG_SPACE, CHAIN_CNT, AVG_ROW_LEN,
     AVG_SPACE_FREELIST_BLOCKS, NUM_FREELIST_BLOCKS,
     DEGREE, INSTANCES, CACHE, TABLE_LOCK, 
     SAMPLE_SIZE, LAST_ANALYZED, PARTITIONED,
     IOT_TYPE, 
     TABLE_TYPE_OWNER, TABLE_TYPE, TEMPORARY, NESTED, 
     BUFFER_POOL)
as
select OWNER, TABLE_NAME, TABLESPACE_NAME, CLUSTER_NAME, IOT_NAME,
     PCT_FREE, PCT_USED,
     INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,
     FREELISTS, FREELIST_GROUPS, LOGGING,
     BACKED_UP, NUM_ROWS, BLOCKS, EMPTY_BLOCKS,
     AVG_SPACE, CHAIN_CNT, AVG_ROW_LEN,
     AVG_SPACE_FREELIST_BLOCKS, NUM_FREELIST_BLOCKS,
     DEGREE, INSTANCES, CACHE, TABLE_LOCK, 
     SAMPLE_SIZE, LAST_ANALYZED, PARTITIONED,
     IOT_TYPE, NULL, NULL, TEMPORARY, NESTED,
     BUFFER_POOL
from all_tables
union all
select * from all_object_tables
/
comment on table ALL_ALL_TABLES is
'Description of all object and relational tables accessible to the user'
/
comment on column ALL_ALL_TABLES.OWNER is
'Owner of the table'
/
comment on column ALL_ALL_TABLES.TABLE_NAME is
'Name of the table'
/
comment on column ALL_ALL_TABLES.TABLESPACE_NAME is
'Name of the tablespace containing the table'
/
comment on column ALL_ALL_TABLES.CLUSTER_NAME is
'Name of the cluster, if any, to which the table belongs'
/
comment on column ALL_ALL_TABLES.IOT_NAME is
'Name of the index-only table, if any, to which the overflow entry belongs'
/
comment on column ALL_ALL_TABLES.PCT_FREE is
'Minimum percentage of free space in a block'
/
comment on column ALL_ALL_TABLES.PCT_USED is
'Minimum percentage of used space in a block'
/
comment on column ALL_ALL_TABLES.INI_TRANS is
'Initial number of transactions'
/
comment on column ALL_ALL_TABLES.MAX_TRANS is
'Maximum number of transactions'
/
comment on column ALL_ALL_TABLES.INITIAL_EXTENT is
'Size of the initial extent in bytes'
/
comment on column ALL_ALL_TABLES.NEXT_EXTENT is
'Size of secondary extents in bytes'
/
comment on column ALL_ALL_TABLES.MIN_EXTENTS is
'Minimum number of extents allowed in the segment'
/
comment on column ALL_ALL_TABLES.MAX_EXTENTS is
'Maximum number of extents allowed in the segment'
/
comment on column ALL_ALL_TABLES.PCT_INCREASE is
'Percentage increase in extent size'
/
comment on column ALL_ALL_TABLES.FREELISTS is
'Number of process freelists allocated in this segment'
/
comment on column ALL_ALL_TABLES.FREELIST_GROUPS is
'Number of freelist groups allocated in this segment'
/
comment on column ALL_ALL_TABLES.LOGGING is
'Logging attribute'
/
comment on column ALL_ALL_TABLES.BACKED_UP is
'Has table been backed up since last modification?'
/
comment on column ALL_ALL_TABLES.NUM_ROWS is
'The number of rows in the table'
/
comment on column ALL_ALL_TABLES.BLOCKS is
'The number of used blocks in the table'
/
comment on column ALL_ALL_TABLES.EMPTY_BLOCKS is
'The number of empty (never used) blocks in the table'
/
comment on column ALL_ALL_TABLES.AVG_SPACE is
'The average available free space in the table'
/
comment on column ALL_ALL_TABLES.CHAIN_CNT is
'The number of chained rows in the table'
/
comment on column ALL_ALL_TABLES.AVG_ROW_LEN is
'The average row length, including row overhead'
/
comment on column ALL_ALL_TABLES.AVG_SPACE_FREELIST_BLOCKS is
'The average freespace of all blocks on a freelist'
/
comment on column ALL_ALL_TABLES.NUM_FREELIST_BLOCKS is
'The number of blocks on the freelist'
/
comment on column ALL_ALL_TABLES.DEGREE is
'The number of threads per instance for scanning the table'
/
comment on column ALL_ALL_TABLES.INSTANCES is
'The number of instances across which the table is to be scanned'
/
comment on column ALL_ALL_TABLES.CACHE is
'Whether the table is to be cached in the buffer cache'
/
comment on column ALL_ALL_TABLES.TABLE_LOCK is
'Whether table locking is enabled or disabled'
/
comment on column ALL_ALL_TABLES.SAMPLE_SIZE is
'The sample size used in analyzing this table'
/
comment on column ALL_ALL_TABLES.LAST_ANALYZED is
'The date of the most recent time this table was analyzed'
/
comment on column ALL_ALL_TABLES.PARTITIONED is
'Is this table partitioned? YES or NO'
/
comment on column ALL_ALL_TABLES.IOT_TYPE is
'If index-only table, then IOT_TYPE is IOT or IOT_OVERFLOW else NULL'
/
comment on column ALL_ALL_TABLES.TABLE_TYPE_OWNER is
'Owner of the type of the table if the table is an object table'
/
comment on column ALL_ALL_TABLES.TABLE_TYPE is
'Type of the table if the table is an object table'
/
comment on column ALL_ALL_TABLES.TEMPORARY is
'Can the current session only see data that it place in this object itself?'
/
comment on column ALL_ALL_TABLES.NESTED is
'Is the table a nested table?'
/
comment on column ALL_ALL_TABLES.BUFFER_POOL is
'The default buffer pool to be used for table blocks'
/
drop public synonym ALL_ALL_TABLES
/
create public synonym ALL_ALL_TABLES for ALL_ALL_TABLES
/
grant select on ALL_ALL_TABLES to PUBLIC with grant option
/
create or replace view DBA_TABLES
    (OWNER, TABLE_NAME, TABLESPACE_NAME, CLUSTER_NAME, IOT_NAME,
     PCT_FREE, PCT_USED,
     INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,
     FREELISTS, FREELIST_GROUPS, LOGGING,
     BACKED_UP, NUM_ROWS, BLOCKS, EMPTY_BLOCKS,
     AVG_SPACE, CHAIN_CNT, AVG_ROW_LEN,
     AVG_SPACE_FREELIST_BLOCKS, NUM_FREELIST_BLOCKS,
     DEGREE, INSTANCES, CACHE, TABLE_LOCK, 
     SAMPLE_SIZE, LAST_ANALYZED, PARTITIONED,
     IOT_TYPE, TEMPORARY, NESTED,
     BUFFER_POOL)
as
select u.name, o.name, decode(bitand(t.property, 32), 32, null,
			      decode(bitand(t.property, 64), 64, null, ts.name)),
       decode(bitand(t.property, 1024), 0, null, co.name), 
       decode(bitand(t.property, 512), 0, null, co.name),
       decode(bitand(t.property, 32), 0, mod(t.pctfree$, 100), null),
       decode(bitand(t.property, 32), 0, t.pctused$, null), 
       decode(bitand(t.property, 32), 0, t.initrans, null), 
       decode(bitand(t.property, 32), 0, t.maxtrans, null),
       s.iniexts * ts.blocksize, s.extsize * ts.blocksize,
       s.minexts, s.maxexts, s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       decode(bitand(t.property, 32), 32, null, 
	        decode(bitand(t.flags, 32), 0, 'YES', 'NO')),
       decode(bitand(t.flags,1), 0, 'Y', 1, 'N', '?'),
       t.rowcnt, t.blkcnt, t.empcnt, t.avgspc, t.chncnt, t.avgrln,
       t.avgspc_flb, t.flbcnt,
       lpad(decode(t.degree, 32767, 'DEFAULT', nvl(t.degree,1)),10),
       lpad(decode(t.instances, 32767, 'DEFAULT', nvl(t.instances,1)),10),
       lpad(decode(bitand(t.flags, 8), 8, 'Y', 'N'),5),
       decode(bitand(t.flags, 6), 0, 'ENABLED', 'DISABLED'),
       t.samplesize, t.analyzetime, 
       decode(bitand(t.property, 32), 32, 'YES', 'NO'),
       decode(bitand(t.property, 64), 64, 'IOT', 
               decode(bitand(t.property, 512), 512, 'IOT_OVERFLOW', null)),
       decode(bitand(o.flags, 2), 0, 'N', 2, 'Y', 'N'), 
       decode(bitand(t.property, 8192), 8192, 'YES',
  	      decode(bitand(t.property, 1), 0, 'NO', 'YES')),
       decode(s.cachehint, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from sys.user$ u, sys.ts$ ts, sys.seg$ s, sys.obj$ co, sys.tab$ t, sys.obj$ o
where o.owner# = u.user#
  and o.obj# = t.obj#
  and bitand(t.property, 1) = 0
  and t.bobj# = co.obj# (+)
  and t.ts# = ts.ts#
  and t.file# = s.file# (+)
  and t.block# = s.block# (+)
  and t.ts# = s.ts# (+)
/
drop public synonym DBA_TABLES
/
create public synonym DBA_TABLES for DBA_TABLES
/
grant select on DBA_TABLES to select_catalog_role
/
comment on table DBA_TABLES is
'Description of all relational tables in the database'
/
comment on column DBA_TABLES.OWNER is
'Owner of the table'
/
comment on column DBA_TABLES.TABLE_NAME is
'Name of the table'
/
comment on column DBA_TABLES.TABLESPACE_NAME is
'Name of the tablespace containing the table'
/
comment on column DBA_TABLES.CLUSTER_NAME is
'Name of the cluster, if any, to which the table belongs'
/
comment on column DBA_TABLES.IOT_NAME is
'Name of the index-only table, if any, to which the overflow entry belongs'
/
comment on column DBA_TABLES.PCT_FREE is
'Minimum percentage of free space in a block'
/
comment on column DBA_TABLES.PCT_USED is
'Minimum percentage of used space in a block'
/
comment on column DBA_TABLES.INI_TRANS is
'Initial number of transactions'
/
comment on column DBA_TABLES.MAX_TRANS is
'Maximum number of transactions'
/
comment on column DBA_TABLES.INITIAL_EXTENT is
'Size of the initial extent in bytes'
/
comment on column DBA_TABLES.NEXT_EXTENT is
'Size of secondary extents in bytes'
/
comment on column DBA_TABLES.MIN_EXTENTS is
'Minimum number of extents allowed in the segment'
/
comment on column DBA_TABLES.MAX_EXTENTS is
'Maximum number of extents allowed in the segment'
/
comment on column DBA_TABLES.PCT_INCREASE is
'Percentage increase in extent size'
/
comment on column DBA_TABLES.FREELISTS is
'Number of process freelists allocated in this segment'
/
comment on column DBA_TABLES.FREELIST_GROUPS is
'Number of freelist groups allocated in this segment'
/
comment on column DBA_TABLES.LOGGING is
'Logging attribute'
/
comment on column DBA_TABLES.BACKED_UP is
'Has table been backed up since last modification?'
/
comment on column DBA_TABLES.NUM_ROWS is
'The number of rows in the table'
/
comment on column DBA_TABLES.BLOCKS is
'The number of used blocks in the table'
/
comment on column DBA_TABLES.EMPTY_BLOCKS is
'The number of empty (never used) blocks in the table'
/
comment on column DBA_TABLES.AVG_SPACE is
'The average available free space in the table'
/
comment on column DBA_TABLES.CHAIN_CNT is
'The number of chained rows in the table'
/
comment on column DBA_TABLES.AVG_ROW_LEN is
'The average row length, including row overhead'
/
comment on column DBA_TABLES.AVG_SPACE_FREELIST_BLOCKS is
'The average freespace of all blocks on a freelist'
/
comment on column DBA_TABLES.NUM_FREELIST_BLOCKS is
'The number of blocks on the freelist'
/
comment on column DBA_TABLES.DEGREE is
'The number of threads per instance for scanning the table'
/
comment on column DBA_TABLES.INSTANCES is
'The number of instances across which the table is to be scanned'
/
comment on column DBA_TABLES.CACHE is
'Whether the table is to be cached in the buffer cache'
/
comment on column DBA_TABLES.TABLE_LOCK is
'Whether table locking is enabled or disabled'
/
comment on column DBA_TABLES.SAMPLE_SIZE is
'The sample size used in analyzing this table'
/
comment on column DBA_TABLES.LAST_ANALYZED is
'The date of the most recent time this table was analyzed'
/
comment on column DBA_TABLES.PARTITIONED is
'Is this table partitioned? YES or NO'
/
comment on column DBA_TABLES.IOT_TYPE is
'If index-only table, then IOT_TYPE is IOT or IOT_OVERFLOW else NULL'
/
comment on column DBA_TABLES.TEMPORARY is
'Can the current session only see data that it place in this object itself?'
/
comment on column DBA_TABLES.NESTED is
'Is the table a nested table?'
/
comment on column DBA_TABLES.BUFFER_POOL is
'The default buffer pool to be used for table blocks'
/
create or replace view DBA_OBJECT_TABLES
    (OWNER, TABLE_NAME, TABLESPACE_NAME, CLUSTER_NAME, IOT_NAME,
     PCT_FREE, PCT_USED,
     INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,
     FREELISTS, FREELIST_GROUPS, LOGGING,
     BACKED_UP, NUM_ROWS, BLOCKS, EMPTY_BLOCKS,
     AVG_SPACE, CHAIN_CNT, AVG_ROW_LEN,
     AVG_SPACE_FREELIST_BLOCKS, NUM_FREELIST_BLOCKS,
     DEGREE, INSTANCES, CACHE, TABLE_LOCK, 
     SAMPLE_SIZE, LAST_ANALYZED, PARTITIONED,
     IOT_TYPE, 
     TABLE_TYPE_OWNER, TABLE_TYPE, TEMPORARY, NESTED, 
     BUFFER_POOL)
as
select u.name, o.name, ts.name, 
       decode(bitand(t.property, 1024), 0, null, co.name), 
       decode(bitand(t.property, 512), 0, null, co.name),
       decode(bitand(t.property, 32), 0, mod(t.pctfree$, 100), null),
       decode(bitand(t.property, 32), 0, t.pctused$, null), 
       decode(bitand(t.property, 32), 0, t.initrans, null), 
       decode(bitand(t.property, 32), 0, t.maxtrans, null),
       s.iniexts * ts.blocksize, s.extsize * ts.blocksize,
       s.minexts, s.maxexts, s.extpct,
       decode(s.lists, 0, 1, s.lists), decode(s.groups, 0, 1, s.groups),
       decode(bitand(t.property, 32), 32, null, 
	        decode(bitand(t.flags, 32), 0, 'YES', 'NO')),
       decode(bitand(t.flags,1), 0, 'Y', 1, 'N', '?'),
       t.rowcnt, t.blkcnt, t.empcnt, t.avgspc, t.chncnt, t.avgrln,
       t.avgspc_flb, t.flbcnt,
       lpad(decode(t.degree, 32767, 'DEFAULT', nvl(t.degree,1)),10),
       lpad(decode(t.instances, 32767, 'DEFAULT', nvl(t.instances,1)),10),
       lpad(decode(bitand(t.flags, 8), 8, 'Y', 'N'),5),
       decode(bitand(t.flags, 6), 0, 'ENABLED', 'DISABLED'),
       t.samplesize, t.analyzetime, 
       decode(bitand(t.property, 32), 32, 'YES', 'NO'),
       decode(bitand(t.property, 64), 64, 'IOT', 
               decode(bitand(t.property, 512), 512, 'IOT_OVERFLOW', null)),
       tu.name, ty.name, 
       decode(bitand(o.flags, 2), 0, 'N', 2, 'Y', 'N'), 
       decode(bitand(t.property, 8192), 8192, 'YES', 'NO'),
       decode(s.cachehint, 0, 'DEFAULT', 1, 'KEEP', 2, 'RECYCLE', NULL)
from sys.user$ u, sys.ts$ ts, sys.seg$ s, sys.obj$ co, sys.tab$ t, sys.obj$ o,
     sys.coltype$ ac, sys.obj$ ty, sys.user$ tu, sys.col$ tc
where o.owner# = u.user#
  and o.obj# = t.obj#
  and bitand(t.property, 1) = 1
  and t.obj# = tc.obj#
  and tc.name = 'SYS_NC_ROWINFO$'
  and tc.obj# = ac.obj#
  and tc.intcol# = ac.intcol#
  and ac.toid = ty.oid$
  and ty.owner# = tu.user#
  and ty.type# <> 10
  and t.bobj# = co.obj# (+)
  and t.ts# = ts.ts#
  and t.file# = s.file# (+)
  and t.block# = s.block# (+)
  and t.ts# = s.ts# (+)
/
drop public synonym DBA_OBJECT_TABLES
/
create public synonym DBA_OBJECT_TABLES for DBA_OBJECT_TABLES
/
grant select on DBA_OBJECT_TABLES to select_catalog_role
/
comment on table DBA_OBJECT_TABLES is
'Description of all object tables in the database'
/
comment on column DBA_OBJECT_TABLES.OWNER is
'Owner of the table'
/
comment on column DBA_OBJECT_TABLES.TABLE_NAME is
'Name of the table'
/
comment on column DBA_OBJECT_TABLES.TABLESPACE_NAME is
'Name of the tablespace containing the table'
/
comment on column DBA_OBJECT_TABLES.CLUSTER_NAME is
'Name of the cluster, if any, to which the table belongs'
/
comment on column DBA_OBJECT_TABLES.IOT_NAME is
'Name of the index-only table, if any, to which the overflow entry belongs'
/
comment on column DBA_OBJECT_TABLES.PCT_FREE is
'Minimum percentage of free space in a block'
/
comment on column DBA_OBJECT_TABLES.PCT_USED is
'Minimum percentage of used space in a block'
/
comment on column DBA_OBJECT_TABLES.INI_TRANS is
'Initial number of transactions'
/
comment on column DBA_OBJECT_TABLES.MAX_TRANS is
'Maximum number of transactions'
/
comment on column DBA_OBJECT_TABLES.INITIAL_EXTENT is
'Size of the initial extent in bytes'
/
comment on column DBA_OBJECT_TABLES.NEXT_EXTENT is
'Size of secondary extents in bytes'
/
comment on column DBA_OBJECT_TABLES.MIN_EXTENTS is
'Minimum number of extents allowed in the segment'
/
comment on column DBA_OBJECT_TABLES.MAX_EXTENTS is
'Maximum number of extents allowed in the segment'
/
comment on column DBA_OBJECT_TABLES.PCT_INCREASE is
'Percentage increase in extent size'
/
comment on column DBA_OBJECT_TABLES.FREELISTS is
'Number of process freelists allocated in this segment'
/
comment on column DBA_OBJECT_TABLES.FREELIST_GROUPS is
'Number of freelist groups allocated in this segment'
/
comment on column DBA_OBJECT_TABLES.LOGGING is
'Logging attribute'
/
comment on column DBA_OBJECT_TABLES.BACKED_UP is
'Has table been backed up since last modification?'
/
comment on column DBA_OBJECT_TABLES.NUM_ROWS is
'The number of rows in the table'
/
comment on column DBA_OBJECT_TABLES.BLOCKS is
'The number of used blocks in the table'
/
comment on column DBA_OBJECT_TABLES.EMPTY_BLOCKS is
'The number of empty (never used) blocks in the table'
/
comment on column DBA_OBJECT_TABLES.AVG_SPACE is
'The average available free space in the table'
/
comment on column DBA_OBJECT_TABLES.CHAIN_CNT is
'The number of chained rows in the table'
/
comment on column DBA_OBJECT_TABLES.AVG_ROW_LEN is
'The average row length, including row overhead'
/
comment on column DBA_OBJECT_TABLES.AVG_SPACE_FREELIST_BLOCKS is
'The average freespace of all blocks on a freelist'
/
comment on column DBA_OBJECT_TABLES.NUM_FREELIST_BLOCKS is
'The number of blocks on the freelist'
/
comment on column DBA_OBJECT_TABLES.DEGREE is
'The number of threads per instance for scanning the table'
/
comment on column DBA_OBJECT_TABLES.INSTANCES is
'The number of instances across which the table is to be scanned'
/
comment on column DBA_OBJECT_TABLES.CACHE is
'Whether the table is to be cached in the buffer cache'
/
comment on column DBA_OBJECT_TABLES.TABLE_LOCK is
'Whether table locking is enabled or disabled'
/
comment on column DBA_OBJECT_TABLES.SAMPLE_SIZE is
'The sample size used in analyzing this table'
/
comment on column DBA_OBJECT_TABLES.LAST_ANALYZED is
'The date of the most recent time this table was analyzed'
/
comment on column DBA_OBJECT_TABLES.PARTITIONED is
'Is this table partitioned? YES or NO'
/
comment on column DBA_OBJECT_TABLES.IOT_TYPE is
'If index-only table, then IOT_TYPE is IOT or IOT_OVERFLOW else NULL'
/
comment on column DBA_OBJECT_TABLES.TABLE_TYPE_OWNER is
'Owner of the type of the table if the table is an object table'
/
comment on column DBA_OBJECT_TABLES.TABLE_TYPE is
'Type of the table if the table is an object table'
/
comment on column DBA_OBJECT_TABLES.TEMPORARY is
'Can the current session only see data that it place in this object itself?'
/
comment on column DBA_OBJECT_TABLES.NESTED is
'Is the table a nested table?'
/
comment on column DBA_OBJECT_TABLES.BUFFER_POOL is
'The default buffer pool to be used for table blocks'
/
create or replace view DBA_ALL_TABLES
    (OWNER, TABLE_NAME, TABLESPACE_NAME, CLUSTER_NAME, IOT_NAME,
     PCT_FREE, PCT_USED,
     INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,
     FREELISTS, FREELIST_GROUPS, LOGGING,
     BACKED_UP, NUM_ROWS, BLOCKS, EMPTY_BLOCKS,
     AVG_SPACE, CHAIN_CNT, AVG_ROW_LEN,
     AVG_SPACE_FREELIST_BLOCKS, NUM_FREELIST_BLOCKS,
     DEGREE, INSTANCES, CACHE, TABLE_LOCK, 
     SAMPLE_SIZE, LAST_ANALYZED, PARTITIONED,
     IOT_TYPE, 
     TABLE_TYPE_OWNER, TABLE_TYPE, TEMPORARY, NESTED, 
     BUFFER_POOL)
as
select OWNER, TABLE_NAME, TABLESPACE_NAME, CLUSTER_NAME, IOT_NAME,
     PCT_FREE, PCT_USED,
     INI_TRANS, MAX_TRANS,
     INITIAL_EXTENT, NEXT_EXTENT,
     MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,
     FREELISTS, FREELIST_GROUPS, LOGGING,
     BACKED_UP, NUM_ROWS, BLOCKS, EMPTY_BLOCKS,
     AVG_SPACE, CHAIN_CNT, AVG_ROW_LEN,
     AVG_SPACE_FREELIST_BLOCKS, NUM_FREELIST_BLOCKS,
     DEGREE, INSTANCES, CACHE, TABLE_LOCK, 
     SAMPLE_SIZE, LAST_ANALYZED, PARTITIONED,
     IOT_TYPE, NULL, NULL, TEMPORARY, NESTED,
     BUFFER_POOL
from dba_tables
union all
select * from dba_object_tables
/
drop public synonym DBA_ALL_TABLES
/
create public synonym DBA_ALL_TABLES for DBA_ALL_TABLES
/
grant select on DBA_ALL_TABLES to select_catalog_role
/
comment on table DBA_ALL_TABLES is
'Description of all object and relational tables in the database'
/
comment on column DBA_ALL_TABLES.OWNER is
'Owner of the table'
/
comment on column DBA_ALL_TABLES.TABLE_NAME is
'Name of the table'
/
comment on column DBA_ALL_TABLES.TABLESPACE_NAME is
'Name of the tablespace containing the table'
/
comment on column DBA_ALL_TABLES.CLUSTER_NAME is
'Name of the cluster, if any, to which the table belongs'
/
comment on column DBA_ALL_TABLES.IOT_NAME is
'Name of the index-only table, if any, to which the overflow entry belongs'
/
comment on column DBA_ALL_TABLES.PCT_FREE is
'Minimum percentage of free space in a block'
/
comment on column DBA_ALL_TABLES.PCT_USED is
'Minimum percentage of used space in a block'
/
comment on column DBA_ALL_TABLES.INI_TRANS is
'Initial number of transactions'
/
comment on column DBA_ALL_TABLES.MAX_TRANS is
'Maximum number of transactions'
/
comment on column DBA_ALL_TABLES.INITIAL_EXTENT is
'Size of the initial extent in bytes'
/
comment on column DBA_ALL_TABLES.NEXT_EXTENT is
'Size of secondary extents in bytes'
/
comment on column DBA_ALL_TABLES.MIN_EXTENTS is
'Minimum number of extents allowed in the segment'
/
comment on column DBA_ALL_TABLES.MAX_EXTENTS is
'Maximum number of extents allowed in the segment'
/
comment on column DBA_ALL_TABLES.PCT_INCREASE is
'Percentage increase in extent size'
/
comment on column DBA_ALL_TABLES.FREELISTS is
'Number of process freelists allocated in this segment'
/
comment on column DBA_ALL_TABLES.FREELIST_GROUPS is
'Number of freelist groups allocated in this segment'
/
comment on column DBA_ALL_TABLES.LOGGING is
'Logging attribute'
/
comment on column DBA_ALL_TABLES.BACKED_UP is
'Has table been backed up since last modification?'
/
comment on column DBA_ALL_TABLES.NUM_ROWS is
'The number of rows in the table'
/
comment on column DBA_ALL_TABLES.BLOCKS is
'The number of used blocks in the table'
/
comment on column DBA_ALL_TABLES.EMPTY_BLOCKS is
'The number of empty (never used) blocks in the table'
/
comment on column DBA_ALL_TABLES.AVG_SPACE is
'The average available free space in the table'
/
comment on column DBA_ALL_TABLES.CHAIN_CNT is
'The number of chained rows in the table'
/
comment on column DBA_ALL_TABLES.AVG_ROW_LEN is
'The average row length, including row overhead'
/
comment on column DBA_ALL_TABLES.AVG_SPACE_FREELIST_BLOCKS is
'The average freespace of all blocks on a freelist'
/
comment on column DBA_ALL_TABLES.NUM_FREELIST_BLOCKS is
'The number of blocks on the freelist'
/
comment on column DBA_ALL_TABLES.DEGREE is
'The number of threads per instance for scanning the table'
/
comment on column DBA_ALL_TABLES.INSTANCES is
'The number of instances across which the table is to be scanned'
/
comment on column DBA_ALL_TABLES.CACHE is
'Whether the table is to be cached in the buffer cache'
/
comment on column DBA_ALL_TABLES.TABLE_LOCK is
'Whether table locking is enabled or disabled'
/
comment on column DBA_ALL_TABLES.SAMPLE_SIZE is
'The sample size used in analyzing this table'
/
comment on column DBA_ALL_TABLES.LAST_ANALYZED is
'The date of the most recent time this table was analyzed'
/
comment on column DBA_ALL_TABLES.PARTITIONED is
'Is this table partitioned? YES or NO'
/
comment on column DBA_ALL_TABLES.IOT_TYPE is
'If index-only table, then IOT_TYPE is IOT or IOT_OVERFLOW else NULL'
/
comment on column DBA_ALL_TABLES.TABLE_TYPE_OWNER is
'Owner of the type of the table if the table is an object table'
/
comment on column DBA_ALL_TABLES.TABLE_TYPE is
'Type of the table if the table is an object table'
/
comment on column DBA_ALL_TABLES.TEMPORARY is
'Can the current session only see data that it place in this object itself?'
/
comment on column DBA_ALL_TABLES.NESTED is
'Is the table a nested table?'
/
comment on column DBA_ALL_TABLES.BUFFER_POOL is
'The default buffer pool to be used for table blocks'
/
remark
remark  FAMILY "TABLESPACES"
remark  CREATE TABLESPACE parameters, except datafiles.
remark  This family has no ALL member.
remark
create or replace view USER_TABLESPACES
    (TABLESPACE_NAME, INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS,
     MAX_EXTENTS, PCT_INCREASE, MIN_EXTLEN,
     STATUS, CONTENTS, LOGGING)
as select ts.name, ts.blocksize * ts.dflinit,
                   ts.blocksize * ts.dflincr,
                   ts.dflminext, ts.dflmaxext, ts.dflextpct,
	           ts.blocksize * ts.dflminlen,
          decode(ts.online$, 1, 'ONLINE', 2, 'OFFLINE',
                 3, 'INVALID', 4, 'READ ONLY', 'UNDEFINED'),
          decode(ts.contents$, 0, 'PERMANENT', 1, 'TEMPORARY'),
          decode(ts.dflogging, 0, 'NOLOGGING', 1, 'LOGGING')
from sys.ts$ ts
where exists (select null from sys.tsq$ tsq
              where tsq.ts# = ts.ts#
                and tsq.user# = userenv('SCHEMAID') and 
                (tsq.blocks > 0 or tsq.maxblocks != 0))
       or exists
          (select null
           from sys.v$enabledprivs
           where priv_number = -15 /* UNLIMITED TABLESPACE */)
/
comment on table USER_TABLESPACES is
'Description of accessible tablespaces'
/
comment on column USER_TABLESPACES.TABLESPACE_NAME is
'Tablespace name'
/
comment on column USER_TABLESPACES.INITIAL_EXTENT is
'Default initial extent size'
/
comment on column USER_TABLESPACES.NEXT_EXTENT is
'Default incremental extent size'
/
comment on column USER_TABLESPACES.MIN_EXTENTS is
'Default minimum number of extents'
/
comment on column USER_TABLESPACES.MAX_EXTENTS is
'Default maximum number of extents'
/
comment on column USER_TABLESPACES.PCT_INCREASE is
'Default percent increase for extent size'
/
comment on column USER_TABLESPACES.MIN_EXTLEN is
'Minimum extent size for the tablespace'
/
comment on column USER_TABLESPACES.STATUS is
'Tablespace status: "ONLINE", "OFFLINE", or "READ ONLY"'
/
comment on column USER_TABLESPACES.CONTENTS is
'Tablespace contents: "PERMANENT", or "TEMPORARY"'
/
comment on column USER_TABLESPACES.LOGGING is
'Default logging attribute'
/
drop public synonym USER_TABLESPACES
/
create public synonym USER_TABLESPACES for USER_TABLESPACES
/
grant select on USER_TABLESPACES to PUBLIC with grant option
/
create or replace view DBA_TABLESPACES
    (TABLESPACE_NAME, INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS,
     MAX_EXTENTS, PCT_INCREASE, MIN_EXTLEN,
     STATUS, CONTENTS, LOGGING)
as select ts.name, ts.blocksize * ts.dflinit,
          ts.blocksize * ts.dflincr, ts.dflminext,
          ts.dflmaxext, ts.dflextpct,
	  ts.blocksize * ts.dflminlen,
          decode(ts.online$, 1, 'ONLINE', 2, 'OFFLINE',
                 4, 'READ ONLY', 'UNDEFINED'),
          decode(ts.contents$, 0, 'PERMANENT', 1, 'TEMPORARY'),
          decode(ts.dflogging, 0, 'NOLOGGING', 1, 'LOGGING')
from sys.ts$ ts
where ts.online$ != 3
/
drop public synonym DBA_TABLESPACES
/
create public synonym DBA_TABLESPACES for DBA_TABLESPACES
/
grant select on DBA_TABLESPACES to select_catalog_role
/
comment on table DBA_TABLESPACES is
'Description of all tablespaces'
/
comment on column DBA_TABLESPACES.TABLESPACE_NAME is
'Tablespace name'
/
comment on column DBA_TABLESPACES.INITIAL_EXTENT is
'Default initial extent size'
/
comment on column DBA_TABLESPACES.NEXT_EXTENT is
'Default incremental extent size'
/
comment on column DBA_TABLESPACES.MIN_EXTENTS is
'Default minimum number of extents'
/
comment on column DBA_TABLESPACES.MAX_EXTENTS is
'Default maximum number of extents'
/
comment on column DBA_TABLESPACES.PCT_INCREASE is
'Default percent increase for extent size'
/
comment on column DBA_TABLESPACES.MIN_EXTLEN is
'Minimum extent size for the tablespace'
/
comment on column DBA_TABLESPACES.STATUS is
'Tablespace status: "ONLINE", "OFFLINE", or "READ ONLY"'
/
comment on column DBA_TABLESPACES.CONTENTS is
'Tablespace contents: "PERMANENT", or "TEMPORARY"'
/
comment on column DBA_TABLESPACES.LOGGING is
'Default logging attribute'
/
remark
remark  FAMILY "TAB_COLUMNS"
remark  The columns that make up objects:  Tables, Views, Clusters
remark  Includes information specified or implied by user in 
remark  CREATE/ALTER TABLE/VIEW/CLUSTER.
remark
create or replace view USER_TAB_COLUMNS
    (TABLE_NAME,
     COLUMN_NAME, DATA_TYPE, DATA_TYPE_MOD, DATA_TYPE_OWNER,
     DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, COLUMN_ID,
     DEFAULT_LENGTH, DATA_DEFAULT, NUM_DISTINCT, LOW_VALUE, HIGH_VALUE,
     DENSITY, NUM_NULLS, NUM_BUCKETS, LAST_ANALYZED, SAMPLE_SIZE,
     CHARACTER_SET_NAME)
as
select o.name,
       c.name,
       decode(c.type#, 1, decode(c.charsetform, 2, 'NVARCHAR2', 'VARCHAR2'),
                       2, decode(c.scale, null,
                                 decode(c.precision#, null, 'NUMBER', 'FLOAT'),
                                 'NUMBER'),
                       8, 'LONG',
                       9, decode(c.charsetform, 2, 'NCHAR VARYING', 'VARCHAR'),
                       12, 'DATE', 23, 'RAW', 24, 'LONG RAW', 
                       69, 'ROWID',
                       96, decode(c.charsetform, 2, 'NCHAR', 'CHAR'),
                       105, 'MLSLABEL',
                       106, 'MLSLABEL',
                       111, ot.name,
                       112, decode(c.charsetform, 2, 'NCLOB', 'CLOB'),
                       113, 'BLOB', 114, 'BFILE', 115, 'CFILE',
                       121, ot.name,
                       122, ot.name,
                       123, ot.name,
                       'UNDEFINED'),
       decode(c.type#, 111, 'REF'), ut.name,
       c.length, c.precision#, c.scale,
       decode(sign(c.null$),-1,'D', 0, 'Y', 'N'), c.col#, c.deflength, 
       c.default$, h.distcnt, h.lowval, h.hival, h.density, h.null_cnt,
       decode(h.row_cnt, 0, 1, 1, 1, h.row_cnt-1), h.timestamp#, h.sample_size,
       decode(c.charsetform, 1, 'CHAR_CS',
                             2, 'NCHAR_CS',
                             3, NLS_CHARSET_NAME(c.charsetid),
                             4, 'ARG:'||c.charsetid)
from sys.col$ c, sys.obj$ o, sys.hist_head$ h, sys.coltype$ ac, sys.obj$ ot,
     sys.user$ ut
where o.obj# = c.obj#
  and o.owner# = userenv('SCHEMAID')
  and c.obj# = h.obj#(+) and c.intcol# = h.intcol#(+)
  and bitand(c.property, 32) = 0 /* not hidden column */
  and c.obj# = ac.obj#(+) and c.col# = ac.col#(+)
  and ac.toid = ot.oid$(+)
  and ot.owner# = ut.user#(+)
  and (o.type# in (3, 4)                                     /* cluster, view */
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
/
comment on table USER_TAB_COLUMNS is
'Columns of user''s tables, views and clusters'
/
comment on column USER_TAB_COLUMNS.TABLE_NAME is
'Table, view or cluster name'
/
comment on column USER_TAB_COLUMNS.COLUMN_NAME is
'Column name'
/
comment on column USER_TAB_COLUMNS.DATA_LENGTH is
'Length of the column in bytes'
/
comment on column USER_TAB_COLUMNS.DATA_TYPE is
'Datatype of the column'
/
comment on column USER_TAB_COLUMNS.DATA_TYPE_MOD is
'Datatype modifier of the column'
/
comment on column USER_TAB_COLUMNS.DATA_TYPE_OWNER is
'Owner of the datatype of the column'
/
comment on column USER_TAB_COLUMNS.DATA_PRECISION is
'Length: decimal digits (NUMBER) or binary digits (FLOAT)'
/
comment on column USER_TAB_COLUMNS.DATA_SCALE is
'Digits to right of decimal point in a number'
/
comment on column USER_TAB_COLUMNS.NULLABLE is
'Does column allow NULL values?'
/
comment on column USER_TAB_COLUMNS.COLUMN_ID is
'Sequence number of the column as created'
/
comment on column USER_TAB_COLUMNS.DEFAULT_LENGTH is
'Length of default value for the column'
/
comment on column USER_TAB_COLUMNS.DATA_DEFAULT is
'Default value for the column'
/
comment on column USER_TAB_COLUMNS.NUM_DISTINCT is
'The number of distinct values in the column'
/
comment on column USER_TAB_COLUMNS.LOW_VALUE is
'The low value in the column'
/
comment on column USER_TAB_COLUMNS.HIGH_VALUE is
'The high value in the column'
/
comment on column USER_TAB_COLUMNS.DENSITY is
'The density of the column'
/
comment on column USER_TAB_COLUMNS.NUM_NULLS is
'The number of nulls in the column'
/
comment on column USER_TAB_COLUMNS.NUM_BUCKETS is
'The number of buckets in histogram for the column'
/
comment on column USER_TAB_COLUMNS.LAST_ANALYZED is
'The date of the most recent time this column was analyzed'
/
comment on column USER_TAB_COLUMNS.SAMPLE_SIZE is
'The sample size used in analyzing this column'
/
comment on column USER_TAB_COLUMNS.CHARACTER_SET_NAME is
'Character set name'
/
drop public synonym USER_TAB_COLUMNS
/
create public synonym USER_TAB_COLUMNS for USER_TAB_COLUMNS
/
drop public synonym COLS
/
create public synonym COLS for USER_TAB_COLUMNS
/
grant select on USER_TAB_COLUMNS to PUBLIC with grant option
/
create or replace view ALL_TAB_COLUMNS
    (OWNER, TABLE_NAME,
     COLUMN_NAME, DATA_TYPE, DATA_TYPE_MOD, DATA_TYPE_OWNER,
     DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, COLUMN_ID,
     DEFAULT_LENGTH, DATA_DEFAULT, NUM_DISTINCT, LOW_VALUE, HIGH_VALUE,
     DENSITY, NUM_NULLS, NUM_BUCKETS, LAST_ANALYZED, SAMPLE_SIZE,
     CHARACTER_SET_NAME)
as
select u.name, o.name,
       c.name,
       decode(c.type#, 1, decode(c.charsetform, 2, 'NVARCHAR2', 'VARCHAR2'),
                       2, decode(c.scale, null,
                                 decode(c.precision#, null, 'NUMBER', 'FLOAT'),
                                 'NUMBER'),
                       8, 'LONG',
                       9, decode(c.charsetform, 2, 'NCHAR VARYING', 'VARCHAR'),
                       12, 'DATE', 23, 'RAW', 24, 'LONG RAW', 
                       69, 'ROWID',
                       96, decode(c.charsetform, 2, 'NCHAR', 'CHAR'),
                       105, 'MLSLABEL',
                       106, 'MLSLABEL',
                       111, ot.name,
                       112, decode(c.charsetform, 2, 'NCLOB', 'CLOB'),
                       113, 'BLOB', 114, 'BFILE', 115, 'CFILE',
                       121, ot.name,
                       122, ot.name,
                       123, ot.name,
                       'UNDEFINED'),
       decode(c.type#, 111, 'REF'), ut.name,
       c.length, c.precision#, c.scale,
       decode(sign(c.null$),-1,'D', 0, 'Y', 'N'), c.col#, c.deflength, 
       c.default$, h.distcnt, h.lowval, h.hival, h.density, h.null_cnt,
       decode(h.row_cnt, 0, 1, 1, 1, h.row_cnt-1), h.timestamp#, h.sample_size,
       decode(c.charsetform, 1, 'CHAR_CS',
                             2, 'NCHAR_CS',
                             3, NLS_CHARSET_NAME(c.charsetid),
                             4, 'ARG:'||c.charsetid)
from sys.col$ c, sys.obj$ o, sys.hist_head$ h, sys.user$ u,
     sys.coltype$ ac, sys.obj$ ot, sys.user$ ut
where o.obj# = c.obj#
  and o.owner# = u.user#
  and c.obj# = h.obj#(+) and c.intcol# = h.intcol#(+)
  and bitand(c.property, 32) = 0 /* not hidden column */
  and c.obj# = ac.obj#(+) and c.col# = ac.col#(+)
  and ac.toid = ot.oid$(+)
  and ot.owner# = ut.user#(+)
  and (o.type# in (3, 4)                                     /* cluster, view */
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
  and (o.owner# = userenv('SCHEMAID')
        or
        o.obj# in ( select obj#
                    from sys.objauth$
                    where grantee# in ( select kzsrorol
                                         from x$kzsro
                                       )
                  )
	or /* user has system privileges */
	  exists (select null from v$enabledprivs
		  where priv_number in (-45 /* LOCK ANY TABLE */,
					-47 /* SELECT ANY TABLE */,
					-48 /* INSERT ANY TABLE */,
					-49 /* UPDATE ANY TABLE */,
					-50 /* DELETE ANY TABLE */)
		  )
       )
/
comment on table ALL_TAB_COLUMNS is
'Columns of user''s tables, views and clusters'
/
comment on column ALL_TAB_COLUMNS.TABLE_NAME is
'Table, view or cluster name'
/
comment on column ALL_TAB_COLUMNS.COLUMN_NAME is
'Column name'
/
comment on column ALL_TAB_COLUMNS.DATA_LENGTH is
'Length of the column in bytes'
/
comment on column ALL_TAB_COLUMNS.DATA_TYPE is
'Datatype of the column'
/
comment on column ALL_TAB_COLUMNS.DATA_TYPE_MOD is
'Datatype modifier of the column'
/
comment on column ALL_TAB_COLUMNS.DATA_TYPE_OWNER is
'Owner of the datatype of the column'
/
comment on column ALL_TAB_COLUMNS.DATA_PRECISION is
'Length: decimal digits (NUMBER) or binary digits (FLOAT)'
/
comment on column ALL_TAB_COLUMNS.DATA_SCALE is
'Digits to right of decimal point in a number'
/
comment on column ALL_TAB_COLUMNS.NULLABLE is
'Does column allow NULL values?'
/
comment on column ALL_TAB_COLUMNS.COLUMN_ID is
'Sequence number of the column as created'
/
comment on column ALL_TAB_COLUMNS.DEFAULT_LENGTH is
'Length of default value for the column'
/
comment on column ALL_TAB_COLUMNS.DATA_DEFAULT is
'Default value for the column'
/
comment on column ALL_TAB_COLUMNS.NUM_DISTINCT is
'The number of distinct values in the column'
/
comment on column ALL_TAB_COLUMNS.LOW_VALUE is
'The low value in the column'
/
comment on column ALL_TAB_COLUMNS.HIGH_VALUE is
'The high value in the column'
/
comment on column ALL_TAB_COLUMNS.DENSITY is
'The density of the column'
/
comment on column ALL_TAB_COLUMNS.NUM_NULLS is
'The number of nulls in the column'
/
comment on column ALL_TAB_COLUMNS.NUM_BUCKETS is
'The number of buckets in histogram for the column'
/
comment on column ALL_TAB_COLUMNS.LAST_ANALYZED is
'The date of the most recent time this column was analyzed'
/
comment on column ALL_TAB_COLUMNS.SAMPLE_SIZE is
'The sample size used in analyzing this column'
/
comment on column ALL_TAB_COLUMNS.CHARACTER_SET_NAME is
'Character set name'
/
drop public synonym ALL_TAB_COLUMNS
/
create public synonym ALL_TAB_COLUMNS for ALL_TAB_COLUMNS
/
grant select on ALL_TAB_COLUMNS to PUBLIC with grant option
/
create or replace view DBA_TAB_COLUMNS
    (OWNER, TABLE_NAME,
     COLUMN_NAME, DATA_TYPE, DATA_TYPE_MOD, DATA_TYPE_OWNER,
     DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, COLUMN_ID,
     DEFAULT_LENGTH, DATA_DEFAULT, NUM_DISTINCT, LOW_VALUE, HIGH_VALUE,
     DENSITY, NUM_NULLS, NUM_BUCKETS, LAST_ANALYZED, SAMPLE_SIZE,
     CHARACTER_SET_NAME)
as
select u.name, o.name,
       c.name,
       decode(c.type#, 1, decode(c.charsetform, 2, 'NVARCHAR2', 'VARCHAR2'),
                       2, decode(c.scale, null,
                                 decode(c.precision#, null, 'NUMBER', 'FLOAT'),
                                 'NUMBER'),
                       8, 'LONG',
                       9, decode(c.charsetform, 2, 'NCHAR VARYING', 'VARCHAR'),
                       12, 'DATE', 23, 'RAW', 24, 'LONG RAW', 
                       69, 'ROWID',
                       96, decode(c.charsetform, 2, 'NCHAR', 'CHAR'),
                       105, 'MLSLABEL',
                       106, 'MLSLABEL',
                       111, ot.name,
                       112, decode(c.charsetform, 2, 'NCLOB', 'CLOB'),
                       113, 'BLOB', 114, 'BFILE', 115, 'CFILE',
                       121, ot.name,
                       122, ot.name,
                       123, ot.name,
                       'UNDEFINED'),
       decode(c.type#, 111, 'REF'), ut.name,
       c.length, c.precision#, c.scale,
       decode(sign(c.null$),-1,'D', 0, 'Y', 'N'), c.col#, c.deflength, 
       c.default$, h.distcnt, h.lowval, h.hival, h.density, h.null_cnt,
       decode(h.row_cnt, 0, 1, 1, 1, h.row_cnt-1), h.timestamp#, h.sample_size,
       decode(c.charsetform, 1, 'CHAR_CS',
                             2, 'NCHAR_CS',
                             3, NLS_CHARSET_NAME(c.charsetid),
                             4, 'ARG:'||c.charsetid)
from sys.col$ c, sys.obj$ o, sys.hist_head$ h, sys.user$ u,
     sys.coltype$ ac, sys.obj$ ot, sys.user$ ut
where o.obj# = c.obj#
  and o.owner# = u.user#
  and c.obj# = h.obj#(+) and c.intcol# = h.intcol#(+)
  and bitand(c.property, 32) = 0 /* not hidden column */
  and c.obj# = ac.obj#(+) and c.col# = ac.col#(+)
  and ac.toid = ot.oid$(+)
  and ot.owner# = ut.user#(+)
  and (o.type# in (3, 4)                                     /* cluster, view */
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
/
comment on table DBA_TAB_COLUMNS is
'Columns of user''s tables, views and clusters'
/
comment on column DBA_TAB_COLUMNS.TABLE_NAME is
'Table, view or cluster name'
/
comment on column DBA_TAB_COLUMNS.COLUMN_NAME is
'Column name'
/
comment on column DBA_TAB_COLUMNS.DATA_LENGTH is
'Length of the column in bytes'
/
comment on column DBA_TAB_COLUMNS.DATA_TYPE is
'Datatype of the column'
/
comment on column DBA_TAB_COLUMNS.DATA_TYPE_MOD is
'Datatype modifier of the column'
/
comment on column DBA_TAB_COLUMNS.DATA_TYPE_OWNER is
'Owner of the datatype of the column'
/
comment on column DBA_TAB_COLUMNS.DATA_PRECISION is
'Length: decimal digits (NUMBER) or binary digits (FLOAT)'
/
comment on column DBA_TAB_COLUMNS.DATA_SCALE is
'Digits to right of decimal point in a number'
/
comment on column DBA_TAB_COLUMNS.NULLABLE is
'Does column allow NULL values?'
/
comment on column DBA_TAB_COLUMNS.COLUMN_ID is
'Sequence number of the column as created'
/
comment on column DBA_TAB_COLUMNS.DEFAULT_LENGTH is
'Length of default value for the column'
/
comment on column DBA_TAB_COLUMNS.DATA_DEFAULT is
'Default value for the column'
/
comment on column DBA_TAB_COLUMNS.NUM_DISTINCT is
'The number of distinct values in the column'
/
comment on column DBA_TAB_COLUMNS.LOW_VALUE is
'The low value in the column'
/
comment on column DBA_TAB_COLUMNS.HIGH_VALUE is
'The high value in the column'
/
comment on column DBA_TAB_COLUMNS.DENSITY is
'The density of the column'
/
comment on column DBA_TAB_COLUMNS.NUM_NULLS is
'The number of nulls in the column'
/
comment on column DBA_TAB_COLUMNS.NUM_BUCKETS is
'The number of buckets in histogram for the column'
/
comment on column DBA_TAB_COLUMNS.LAST_ANALYZED is
'The date of the most recent time this column was analyzed'
/
comment on column DBA_TAB_COLUMNS.SAMPLE_SIZE is
'The sample size used in analyzing this column'
/
comment on column DBA_TAB_COLUMNS.CHARACTER_SET_NAME is
'Character set name'
/
drop public synonym DBA_TAB_COLUMNS
/
create public synonym DBA_TAB_COLUMNS for DBA_TAB_COLUMNS
/
grant select on DBA_TAB_COLUMNS to select_catalog_role
/
remark

remark FAMILY "TAB_COL_STATISTICS"
remark This family of views contains column statistics and histogram 
remark information for table columns.
remark
create or replace view USER_TAB_COL_STATISTICS
    (TABLE_NAME, COLUMN_NAME, NUM_DISTINCT, LOW_VALUE, HIGH_VALUE,
     DENSITY, NUM_NULLS, NUM_BUCKETS, LAST_ANALYZED, SAMPLE_SIZE)
as 
select table_name, column_name, num_distinct, low_value, high_value,
       density, num_nulls, num_buckets, last_analyzed, sample_size
from user_tab_columns
where last_analyzed is not null
/
comment on table USER_TAB_COL_STATISTICS is
'Columns of user''s tables, views and clusters'
/
comment on column USER_TAB_COL_STATISTICS.TABLE_NAME is
'Table, view or cluster name'
/
comment on column USER_TAB_COL_STATISTICS.COLUMN_NAME is
'Column name'
/
comment on column USER_TAB_COL_STATISTICS.NUM_DISTINCT is
'The number of distinct values in the column'
/
comment on column USER_TAB_COL_STATISTICS.LOW_VALUE is
'The low value in the column'
/
comment on column USER_TAB_COL_STATISTICS.HIGH_VALUE is
'The high value in the column'
/
comment on column USER_TAB_COL_STATISTICS.DENSITY is
'The density of the column'
/
comment on column USER_TAB_COL_STATISTICS.NUM_NULLS is
'The number of nulls in the column'
/
comment on column USER_TAB_COL_STATISTICS.NUM_BUCKETS is
'The number of buckets in histogram for the column'
/
comment on column USER_TAB_COL_STATISTICS.LAST_ANALYZED is
'The date of the most recent time this column was analyzed'
/
comment on column USER_TAB_COL_STATISTICS.SAMPLE_SIZE is
'The sample size used in analyzing this column'
/
drop public synonym USER_TAB_COL_STATISTICS
/
create public synonym USER_TAB_COL_STATISTICS for USER_TAB_COL_STATISTICS
/
grant select on USER_TAB_COL_STATISTICS to PUBLIC with grant option
/
create or replace view ALL_TAB_COL_STATISTICS
    (TABLE_NAME, COLUMN_NAME, NUM_DISTINCT, LOW_VALUE, HIGH_VALUE,
     DENSITY, NUM_NULLS, NUM_BUCKETS, LAST_ANALYZED, SAMPLE_SIZE)
as 
select table_name, column_name, num_distinct, low_value, high_value,
       density, num_nulls, num_buckets, last_analyzed, sample_size
from user_tab_columns
where last_analyzed is not null
/
comment on table ALL_TAB_COL_STATISTICS is
'Columns of user''s tables, views and clusters'
/
comment on column ALL_TAB_COL_STATISTICS.TABLE_NAME is
'Table, view or cluster name'
/
comment on column ALL_TAB_COL_STATISTICS.COLUMN_NAME is
'Column name'
/
comment on column ALL_TAB_COL_STATISTICS.NUM_DISTINCT is
'The number of distinct values in the column'
/
comment on column ALL_TAB_COL_STATISTICS.LOW_VALUE is
'The low value in the column'
/
comment on column ALL_TAB_COL_STATISTICS.HIGH_VALUE is
'The high value in the column'
/
comment on column ALL_TAB_COL_STATISTICS.DENSITY is
'The density of the column'
/
comment on column ALL_TAB_COL_STATISTICS.NUM_NULLS is
'The number of nulls in the column'
/
comment on column ALL_TAB_COL_STATISTICS.NUM_BUCKETS is
'The number of buckets in histogram for the column'
/
comment on column ALL_TAB_COL_STATISTICS.LAST_ANALYZED is
'The date of the most recent time this column was analyzed'
/
comment on column ALL_TAB_COL_STATISTICS.SAMPLE_SIZE is
'The sample size used in analyzing this column'
/
drop public synonym ALL_TAB_COL_STATISTICS
/
create public synonym ALL_TAB_COL_STATISTICS for ALL_TAB_COL_STATISTICS
/
grant select on ALL_TAB_COL_STATISTICS to PUBLIC with grant option
/
create or replace view DBA_TAB_COL_STATISTICS
    (TABLE_NAME, COLUMN_NAME, NUM_DISTINCT, LOW_VALUE, HIGH_VALUE,
     DENSITY, NUM_NULLS, NUM_BUCKETS, LAST_ANALYZED, SAMPLE_SIZE)
as 
select table_name, column_name, num_distinct, low_value, high_value,
       density, num_nulls, num_buckets, last_analyzed, sample_size
from dba_tab_columns
where last_analyzed is not null
/
comment on table DBA_TAB_COL_STATISTICS is
'Columns of user''s tables, views and clusters'
/
comment on column DBA_TAB_COL_STATISTICS.TABLE_NAME is
'Table, view or cluster name'
/
comment on column DBA_TAB_COL_STATISTICS.COLUMN_NAME is
'Column name'
/
comment on column DBA_TAB_COL_STATISTICS.NUM_DISTINCT is
'The number of distinct values in the column'
/
comment on column DBA_TAB_COL_STATISTICS.LOW_VALUE is
'The low value in the column'
/
comment on column DBA_TAB_COL_STATISTICS.HIGH_VALUE is
'The high value in the column'
/
comment on column DBA_TAB_COL_STATISTICS.DENSITY is
'The density of the column'
/
comment on column DBA_TAB_COL_STATISTICS.NUM_NULLS is
'The number of nulls in the column'
/
comment on column DBA_TAB_COL_STATISTICS.NUM_BUCKETS is
'The number of buckets in histogram for the column'
/
comment on column DBA_TAB_COL_STATISTICS.LAST_ANALYZED is
'The date of the most recent time this column was analyzed'
/
comment on column DBA_TAB_COL_STATISTICS.SAMPLE_SIZE is
'The sample size used in analyzing this column'
/
drop public synonym DBA_TAB_COL_STATISTICS
/
create public synonym DBA_TAB_COL_STATISTICS for DBA_TAB_COL_STATISTICS
/
grant select on DBA_TAB_COL_STATISTICS to select_catalog_role
/
remark
remark  FAMILY "TAB_HISTOGRAMS"
remark  The histograms (part of the statistics used by the cost-based
remark    optimizer) on columns.
remark  The TAB_COL_STATISTICS contain general information about 
remark    each histogram, including the number of buckets.
remark  These views contains that actual histogram data.
remark
create or replace view USER_TAB_HISTOGRAMS
    (TABLE_NAME, COLUMN_NAME, ENDPOINT_NUMBER, ENDPOINT_VALUE)
as
select o.name,
       decode(bitand(c.property, 1), 1, a.name, c.name),
       h.bucket,
       h.endpoint
from sys.col$ c, sys.obj$ o, sys.histgrm$ h, sys.attrcol$ a
where o.obj# = c.obj#
  and o.owner# = userenv('SCHEMAID')
  and c.obj# = h.obj# and c.intcol# = h.intcol#
  and (o.type# in (3, 4)                                     /* cluster, view */
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
  and c.obj# = a.obj#(+)
  and c.intcol# = a.intcol#(+)
union all
select o.name,
       decode(bitand(c.property, 1), 1, a.name, c.name),
       0,
       h.minimum
from sys.col$ c, sys.obj$ o, sys.hist_head$ h, sys.attrcol$ a
where o.obj# = c.obj#
  and o.owner# = userenv('SCHEMAID')
  and c.obj# = h.obj# and c.intcol# = h.intcol#
  and (o.type# in (3, 4)                                     /* cluster, view */
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
  and h.bucket_cnt = 1
  and c.obj# = a.obj#(+)
  and c.intcol# = a.intcol#(+)
union all
select o.name,
       decode(bitand(c.property, 1), 1, a.name, c.name),
       1,
       h.maximum
from sys.col$ c, sys.obj$ o, sys.hist_head$ h, sys.attrcol$ a
where o.obj# = c.obj#
  and o.owner# = userenv('SCHEMAID')
  and c.obj# = h.obj# and c.intcol# = h.intcol#
  and (o.type# in (3, 4)                                     /* cluster, view */
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
  and h.bucket_cnt = 1
  and c.obj# = a.obj#(+)
  and c.intcol# = a.intcol#(+)
/
comment on table USER_TAB_HISTOGRAMS is
'Histograms on columns of user''s tables'
/
comment on column USER_TAB_HISTOGRAMS.TABLE_NAME is
'Table name'
/
comment on column USER_TAB_HISTOGRAMS.COLUMN_NAME is
'Column name or attribute of object column'
/
comment on column USER_TAB_HISTOGRAMS.ENDPOINT_NUMBER is
'Endpoint number'
/
comment on column USER_TAB_HISTOGRAMS.ENDPOINT_VALUE is
'Normalized endpoint value'
/
drop public synonym USER_TAB_HISTOGRAMS
/
create public synonym USER_TAB_HISTOGRAMS for USER_TAB_HISTOGRAMS
/
grant select on USER_TAB_HISTOGRAMS to PUBLIC with grant option
/
rem For backwark compatibility with ORACLE7's catalog
drop public synonym USER_HISTOGRAMS
/
create public synonym USER_HISTOGRAMS for USER_TAB_HISTOGRAMS
/
create or replace view ALL_TAB_HISTOGRAMS
    (OWNER, TABLE_NAME, COLUMN_NAME, ENDPOINT_NUMBER, ENDPOINT_VALUE)
as
select u.name,
       o.name,
       decode(bitand(c.property, 1), 1, a.name, c.name),
       h.bucket,
       h.endpoint
from sys.col$ c, sys.obj$ o, sys.histgrm$ h, sys.user$ u, sys.attrcol$ a
where o.obj# = c.obj#
  and (o.owner# = userenv('SCHEMAID')
        or
        o.obj# in ( select obj#
                    from sys.objauth$
                    where grantee# in ( select kzsrorol
                                         from x$kzsro
                                       )
                  )
	or /* user has system privileges */
	  exists (select null from v$enabledprivs
		  where priv_number in (-45 /* LOCK ANY TABLE */,
					-47 /* SELECT ANY TABLE */,
					-48 /* INSERT ANY TABLE */,
					-49 /* UPDATE ANY TABLE */,
					-50 /* DELETE ANY TABLE */)
		  )
       )
  and o.owner# = u.user#
  and c.obj# = h.obj# and c.intcol# = h.intcol#
  and (o.type# in (3, 4)                                     /* cluster, view */
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
  and c.obj# = a.obj#(+)
  and c.intcol# = a.intcol#(+)
union all
select u.name,
       o.name,
       decode(bitand(c.property, 1), 1, a.name, c.name),
       0,
       h.minimum
from sys.col$ c, sys.obj$ o, sys.hist_head$ h, sys.user$ u, sys.attrcol$ a
where o.obj# = c.obj#
  and (o.owner# = userenv('SCHEMAID')
        or
        o.obj# in ( select obj#
                    from sys.objauth$
                    where grantee# in ( select kzsrorol
                                         from x$kzsro
                                       )
                  )
	or /* user has system privileges */
	  exists (select null from v$enabledprivs
		  where priv_number in (-45 /* LOCK ANY TABLE */,
					-47 /* SELECT ANY TABLE */,
					-48 /* INSERT ANY TABLE */,
					-49 /* UPDATE ANY TABLE */,
					-50 /* DELETE ANY TABLE */)
		  )
       )
  and o.owner# = u.user#
  and c.obj# = h.obj# and c.intcol# = h.intcol#
  and (o.type# in (3, 4)                                     /* cluster, view */
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
  and h.bucket_cnt = 1
  and c.obj# = a.obj#(+)
  and c.intcol# = a.intcol#(+)
union all
select u.name,
       o.name,
       decode(bitand(c.property, 1), 1, a.name, c.name),
       1,
       h.maximum
from sys.col$ c, sys.obj$ o, sys.hist_head$ h, sys.user$ u, sys.attrcol$ a
where o.obj# = c.obj#
  and (o.owner# = userenv('SCHEMAID')
        or
        o.obj# in ( select obj#
                    from sys.objauth$
                    where grantee# in ( select kzsrorol
                                         from x$kzsro
                                       )
                  )
	or /* user has system privileges */
	  exists (select null from v$enabledprivs
		  where priv_number in (-45 /* LOCK ANY TABLE */,
					-47 /* SELECT ANY TABLE */,
					-48 /* INSERT ANY TABLE */,
					-49 /* UPDATE ANY TABLE */,
					-50 /* DELETE ANY TABLE */)
		  )
       )
  and o.owner# = u.user#
  and c.obj# = h.obj# and c.intcol# = h.intcol#
  and (o.type# in (3, 4)                                     /* cluster, view */
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
  and h.bucket_cnt = 1
  and c.obj# = a.obj#(+)
  and c.intcol# = a.intcol#(+)
/
comment on table ALL_TAB_HISTOGRAMS is
'Histograms on columns of all tables visible to user'
/
comment on column ALL_TAB_HISTOGRAMS.OWNER is
'Owner of table'
/
comment on column ALL_TAB_HISTOGRAMS.TABLE_NAME is
'Table name'
/
comment on column ALL_TAB_HISTOGRAMS.COLUMN_NAME is
'Column name or attribute of object column'
/
comment on column ALL_TAB_HISTOGRAMS.ENDPOINT_NUMBER is
'Endpoint number'
/
comment on column ALL_TAB_HISTOGRAMS.ENDPOINT_VALUE is
'Normalized endpoint value'
/
drop public synonym ALL_TAB_HISTOGRAMS
/
create public synonym ALL_TAB_HISTOGRAMS for ALL_TAB_HISTOGRAMS
/
grant select on ALL_TAB_HISTOGRAMS to PUBLIC with grant option
/
rem For backwark compatibility with ORACLE7's catalog
drop public synonym ALL_HISTOGRAMS
/
create public synonym ALL_HISTOGRAMS for ALL_TAB_HISTOGRAMS
/
create or replace view DBA_TAB_HISTOGRAMS
    (OWNER, TABLE_NAME, COLUMN_NAME, ENDPOINT_NUMBER, ENDPOINT_VALUE)
as
select u.name,
       o.name,
       decode(bitand(c.property, 1), 1, a.name, c.name),
       h.bucket,
       h.endpoint
from sys.col$ c, sys.obj$ o, sys.histgrm$ h, sys.user$ u, sys.attrcol$ a
where o.obj# = c.obj#
  and o.owner# = u.user#
  and c.obj# = h.obj# and c.intcol# = h.intcol#
  and (o.type# in (3, 4)                                     /* cluster, view */
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
  and c.obj# = a.obj#(+)
  and c.intcol# = a.intcol#(+)
union all
select u.name,
       o.name,
       decode(bitand(c.property, 1), 1, a.name, c.name),
       0,
       h.minimum
from sys.col$ c, sys.obj$ o, sys.hist_head$ h, sys.user$ u, sys.attrcol$ a
where o.obj# = c.obj#
  and o.owner# = u.user#
  and c.obj# = h.obj# and c.intcol# = h.intcol#
  and (o.type# in (3, 4)                                     /* cluster, view */
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
  and h.bucket_cnt = 1
  and c.obj# = a.obj#(+)
  and c.intcol# = a.intcol#(+)
union all
select u.name,
       o.name,
       decode(bitand(c.property, 1), 1, a.name, c.name),
       1,
       h.maximum
from sys.col$ c, sys.obj$ o, sys.hist_head$ h, sys.user$ u, sys.attrcol$ a
where o.obj# = c.obj#
  and o.owner# = u.user#
  and c.obj# = h.obj# and c.intcol# = h.intcol#
  and (o.type# in (3, 4)                                     /* cluster, view */
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
  and h.bucket_cnt = 1
  and c.obj# = a.obj#(+)
  and c.intcol# = a.intcol#(+)
/
comment on table DBA_TAB_HISTOGRAMS is
'Histograms on columns of all tables'
/
comment on column DBA_TAB_HISTOGRAMS.OWNER is
'Owner of table'
/
comment on column DBA_TAB_HISTOGRAMS.TABLE_NAME is
'Table name'
/
comment on column DBA_TAB_HISTOGRAMS.COLUMN_NAME is
'Column name or attribute of object column'
/
comment on column DBA_TAB_HISTOGRAMS.ENDPOINT_NUMBER is
'Endpoint number'
/
comment on column DBA_TAB_HISTOGRAMS.ENDPOINT_VALUE is
'Normalized endpoint value'
/
drop public synonym DBA_TAB_HISTOGRAMS
/
create public synonym DBA_TAB_HISTOGRAMS for DBA_TAB_HISTOGRAMS
/
grant select on DBA_TAB_HISTOGRAMS to select_catalog_role
/
rem For backwark compatibility with ORACLE7's catalog
drop public synonym DBA_HISTOGRAMS
/
create public synonym DBA_HISTOGRAMS for DBA_TAB_HISTOGRAMS
/
remark
remark  FAMILY "TAB_COMMENTS"
remark  Comments on objects.
remark
create or replace view USER_TAB_COMMENTS
    (TABLE_NAME,
     TABLE_TYPE,
     COMMENTS)
as
select o.name,
       decode(o.type#, 0, 'NEXT OBJECT', 1, 'INDEX', 2, 'TABLE', 3, 'CLUSTER',
                      4, 'VIEW', 5, 'SYNONYM', 'UNDEFINED'),
       c.comment$
from sys.obj$ o, sys.com$ c
where o.owner# = userenv('SCHEMAID')
  and (o.type# in (4)                                                 /* view */
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
  and o.obj# = c.obj#(+)
  and c.col#(+) is null
/
comment on table USER_TAB_COMMENTS is
'Comments on the tables and views owned by the user'
/
comment on column USER_TAB_COMMENTS.TABLE_NAME is
'Name of the object'
/
comment on column USER_TAB_COMMENTS.TABLE_TYPE is
'Type of the object:  "TABLE" or "VIEW"'
/
comment on column USER_TAB_COMMENTS.COMMENTS is
'Comment on the object'
/
drop public synonym USER_TAB_COMMENTS
/
create public synonym USER_TAB_COMMENTS for USER_TAB_COMMENTS
/
grant select on USER_TAB_COMMENTS to PUBLIC with grant option
/
create or replace view ALL_TAB_COMMENTS
    (OWNER, TABLE_NAME,
     TABLE_TYPE,
     COMMENTS)
as
select u.name, o.name,
       decode(o.type#, 0, 'NEXT OBJECT', 1, 'INDEX', 2, 'TABLE', 3, 'CLUSTER',
                      4, 'VIEW', 5, 'SYNONYM', 'UNDEFINED'),
       c.comment$
from sys.obj$ o, sys.user$ u, sys.com$ c
where o.owner# = u.user#
  and o.obj# = c.obj#(+)
  and c.col#(+) is null
  and (o.type# in (4)                                                 /* view */
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
  and (o.owner# = userenv('SCHEMAID')
        or
        o.obj# in ( select obj#
                    from sys.objauth$
                    where grantee# in ( select kzsrorol
                                         from x$kzsro
                                       )
                  )
	or /* user has system privileges */
	  exists (select null from v$enabledprivs
		  where priv_number in (-45 /* LOCK ANY TABLE */,
					-47 /* SELECT ANY TABLE */,
					-48 /* INSERT ANY TABLE */,
					-49 /* UPDATE ANY TABLE */,
					-50 /* DELETE ANY TABLE */)
		  )
       )
/
comment on table ALL_TAB_COMMENTS is
'Comments on tables and views accessible to the user'
/
comment on column ALL_TAB_COMMENTS.OWNER is
'Owner of the object'
/
comment on column ALL_TAB_COMMENTS.TABLE_NAME is
'Name of the object'
/
comment on column ALL_TAB_COMMENTS.TABLE_TYPE is
'Type of the object'
/
comment on column ALL_TAB_COMMENTS.COMMENTS is
'Comment on the object'
/
drop public synonym ALL_TAB_COMMENTS
/
create public synonym ALL_TAB_COMMENTS for ALL_TAB_COMMENTS
/
grant select on ALL_TAB_COMMENTS to PUBLIC with grant option
/
create or replace view DBA_TAB_COMMENTS
    (OWNER, TABLE_NAME,
     TABLE_TYPE,
     COMMENTS)
as
select u.name, o.name,
       decode(o.type#, 0, 'NEXT OBJECT', 1, 'INDEX', 2, 'TABLE', 3, 'CLUSTER',
                      4, 'VIEW', 5, 'SYNONYM', 'UNDEFINED'),
       c.comment$
from sys.obj$ o, sys.user$ u, sys.com$ c
where o.owner# = u.user#
  and (o.type# in (4)                                                 /* view */
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
  and o.obj# = c.obj#(+)
  and c.col#(+) is null
/
drop public synonym DBA_TAB_COMMENTS
/
create public synonym DBA_TAB_COMMENTS for DBA_TAB_COMMENTS
/
grant select on DBA_TAB_COMMENTS to select_catalog_role
/
comment on table DBA_TAB_COMMENTS is
'Comments on all tables and views in the database'
/
comment on column DBA_TAB_COMMENTS.OWNER is
'Owner of the object'
/
comment on column DBA_TAB_COMMENTS.TABLE_NAME is
'Name of the object'
/
comment on column DBA_TAB_COMMENTS.TABLE_TYPE is
'Type of the object'
/
comment on column DBA_TAB_COMMENTS.COMMENTS is
'Comment on the object'
/
remark
remark  FAMILY "TAB_PRIVS"
remark  Grants on objects.
remark
create or replace view USER_TAB_PRIVS
      (GRANTEE, OWNER, TABLE_NAME, GRANTOR, PRIVILEGE, GRANTABLE)
as
select ue.name, u.name, o.name, ur.name, tpm.name, 
       decode(oa.option$, 1, 'YES', 'NO')
from sys.objauth$ oa, sys.obj$ o, sys.user$ u, sys.user$ ur, sys.user$ ue,
     table_privilege_map tpm
where oa.obj# = o.obj#
  and oa.grantor# = ur.user#
  and oa.grantee# = ue.user#
  and oa.col# is null
  and u.user# = o.owner#
  and oa.privilege# = tpm.privilege
  and userenv('SCHEMAID') in (oa.grantor#, oa.grantee#, o.owner#)
/
comment on table USER_TAB_PRIVS is
'Grants on objects for which the user is the owner, grantor or grantee'
/
comment on column USER_TAB_PRIVS.GRANTEE is
'Name of the user to whom access was granted'
/
comment on column USER_TAB_PRIVS.OWNER is
'Owner of the object'
/
comment on column USER_TAB_PRIVS.TABLE_NAME is
'Name of the object'
/
comment on column USER_TAB_PRIVS.GRANTOR is
'Name of the user who performed the grant'
/
comment on column USER_TAB_PRIVS.PRIVILEGE is
'Table Privilege'
/
comment on column USER_TAB_PRIVS.GRANTABLE is
'Privilege is grantable'
/
drop public synonym USER_TAB_PRIVS
/
create public synonym USER_TAB_PRIVS for USER_TAB_PRIVS
/
grant select on USER_TAB_PRIVS to PUBLIC with grant option
/
create or replace view ALL_TAB_PRIVS
      (GRANTOR, GRANTEE, TABLE_SCHEMA, TABLE_NAME, PRIVILEGE, GRANTABLE)
as
select ur.name, ue.name, u.name, o.name, tpm.name, 
       decode(oa.option$, 1, 'YES', 'NO')
from sys.objauth$ oa, sys.obj$ o, sys.user$ u, sys.user$ ur, sys.user$ ue,
     table_privilege_map tpm
where oa.obj# = o.obj#
  and oa.grantor# = ur.user#
  and oa.grantee# = ue.user#
  and oa.col# is null
  and u.user# = o.owner#
  and oa.privilege# = tpm.privilege
  and (oa.grantor# = userenv('SCHEMAID') or
       oa.grantee# in (select kzsrorol from x$kzsro) or
       o.owner# = userenv('SCHEMAID'))
/
comment on table ALL_TAB_PRIVS is
'Grants on objects for which the user is the grantor, grantee, owner, 
 or an enabled role or PUBLIC is the grantee'
/
comment on column ALL_TAB_PRIVS.GRANTOR is
'Name of the user who performed the grant'
/
comment on column ALL_TAB_PRIVS.GRANTEE is
'Name of the user to whom access was granted'
/
comment on column ALL_TAB_PRIVS.TABLE_SCHEMA is
'Schema of the object'
/
comment on column ALL_TAB_PRIVS.TABLE_NAME is
'Name of the object'
/
comment on column ALL_TAB_PRIVS.PRIVILEGE is
'Table Privilege'
/
comment on column ALL_TAB_PRIVS.GRANTABLE is
'Privilege is grantable'
/
drop public synonym ALL_TAB_PRIVS
/
create public synonym ALL_TAB_PRIVS for ALL_TAB_PRIVS
/
grant select on ALL_TAB_PRIVS to PUBLIC with grant option
/
create or replace view DBA_TAB_PRIVS
      (GRANTEE, OWNER, TABLE_NAME, GRANTOR, PRIVILEGE, GRANTABLE)
as
select ue.name, u.name, o.name, ur.name, tpm.name,
       decode(oa.option$, 1, 'YES', 'NO')
from sys.objauth$ oa, sys.obj$ o, sys.user$ u, sys.user$ ur, sys.user$ ue,
     table_privilege_map tpm
where oa.obj# = o.obj#
  and oa.grantor# = ur.user#
  and oa.grantee# = ue.user#
  and oa.col# is null
  and oa.privilege# = tpm.privilege
  and u.user# = o.owner#
/
drop public synonym DBA_TAB_PRIVS
/
create public synonym DBA_TAB_PRIVS for DBA_TAB_PRIVS
/
grant select on DBA_TAB_PRIVS to select_catalog_role
/
comment on table DBA_TAB_PRIVS is
'All grants on objects in the database'
/
comment on column DBA_TAB_PRIVS.GRANTEE is
'User to whom access was granted'
/
comment on column DBA_TAB_PRIVS.OWNER is
'Owner of the object'
/
comment on column DBA_TAB_PRIVS.TABLE_NAME is
'Name of the object'
/
comment on column DBA_TAB_PRIVS.GRANTOR is
'Name of the user who performed the grant'
/
comment on column DBA_TAB_PRIVS.PRIVILEGE is
'Table Privilege'
/
comment on column DBA_TAB_PRIVS.GRANTABLE is
'Privilege is grantable'
/
remark
remark  FAMILY "TAB_PRIVS_MADE"
remark  Grants made on objects.
remark  This family has no DBA member.
remark
create or replace view USER_TAB_PRIVS_MADE
      (GRANTEE, TABLE_NAME, GRANTOR, PRIVILEGE, GRANTABLE)
as
select ue.name, o.name, ur.name, tpm.name, 
       decode(oa.option$, 1, 'YES', 'NO')
from sys.objauth$ oa, sys.obj$ o, sys.user$ ue, sys.user$ ur,
     table_privilege_map tpm
where oa.obj# = o.obj#
  and oa.grantor# = ur.user#
  and oa.grantee# = ue.user#
  and oa.col# is null
  and oa.privilege# = tpm.privilege
  and o.owner# = userenv('SCHEMAID')
/
comment on table USER_TAB_PRIVS_MADE is
'All grants on objects owned by the user'
/
comment on column USER_TAB_PRIVS_MADE.GRANTEE is
'Name of the user to whom access was granted'
/
comment on column USER_TAB_PRIVS_MADE.TABLE_NAME is
'Name of the object'
/
comment on column USER_TAB_PRIVS_MADE.GRANTOR is
'Name of the user who performed the grant'
/
comment on column USER_TAB_PRIVS_MADE.PRIVILEGE is
'Table Privilege'
/
comment on column USER_TAB_PRIVS_MADE.GRANTABLE is
'Privilege is grantable'
/
drop public synonym USER_TAB_PRIVS_MADE
/
create public synonym USER_TAB_PRIVS_MADE for USER_TAB_PRIVS_MADE
/
grant select on USER_TAB_PRIVS_MADE to PUBLIC with grant option
/
create or replace view ALL_TAB_PRIVS_MADE
      (GRANTEE, OWNER, TABLE_NAME, GRANTOR, PRIVILEGE, GRANTABLE)
as
select ue.name, u.name, o.name, ur.name, tpm.name, 
       decode(oa.option$, 1, 'YES', 'NO')
from sys.objauth$ oa, sys.obj$ o, sys.user$ u, sys.user$ ur, sys.user$ ue,
     table_privilege_map tpm
where oa.obj# = o.obj#
  and oa.grantor# = ur.user#
  and oa.grantee# = ue.user#
  and u.user# = o.owner#
  and oa.col# is null
  and oa.privilege# = tpm.privilege
  and userenv('SCHEMAID') in (o.owner#, oa.grantor#)
/
comment on table ALL_TAB_PRIVS_MADE is
'User''s grants and grants on user''s objects'
/
comment on column ALL_TAB_PRIVS_MADE.GRANTEE is
'Name of the user to whom access was granted'
/
comment on column ALL_TAB_PRIVS_MADE.OWNER is
'Owner of the object'
/
comment on column ALL_TAB_PRIVS_MADE.TABLE_NAME is
'Name of the object'
/
comment on column ALL_TAB_PRIVS_MADE.GRANTOR is
'Name of the user who performed the grant'
/
comment on column ALL_TAB_PRIVS_MADE.PRIVILEGE is
'Table Privilege'
/
comment on column ALL_TAB_PRIVS_MADE.GRANTABLE is
'Privilege is grantable'
/
drop public synonym ALL_TAB_PRIVS_MADE
/
create public synonym ALL_TAB_PRIVS_MADE for ALL_TAB_PRIVS_MADE
/
grant select on ALL_TAB_PRIVS_MADE to PUBLIC with grant option
/
remark
remark  FAMILY "TAB_PRIVS_RECD"
remark  Grants received on objects.
remark  This family has no DBA member.
remark
create or replace view USER_TAB_PRIVS_RECD
      (OWNER, TABLE_NAME, GRANTOR, PRIVILEGE, GRANTABLE)
as
select u.name, o.name, ur.name, tpm.name, 
       decode(oa.option$, 1, 'YES', 'NO')
from sys.objauth$ oa, sys.obj$ o, sys.user$ u, sys.user$ ur, 
     table_privilege_map tpm
where oa.obj# = o.obj#
  and oa.grantor# = ur.user#
  and u.user# = o.owner#
  and oa.col# is null
  and oa.privilege# = tpm.privilege
  and oa.grantee# = userenv('SCHEMAID')
/
comment on table USER_TAB_PRIVS_RECD is
'Grants on objects for which the user is the grantee'
/
comment on column USER_TAB_PRIVS_RECD.OWNER is
'Owner of the object'
/
comment on column USER_TAB_PRIVS_RECD.TABLE_NAME is
'Name of the object'
/
comment on column USER_TAB_PRIVS_RECD.GRANTOR is
'Name of the user who performed the grant'
/
comment on column USER_TAB_PRIVS_RECD.PRIVILEGE is
'Table Privilege'
/
comment on column USER_TAB_PRIVS_RECD.GRANTABLE is
'Privilege is grantable'
/
drop public synonym USER_TAB_PRIVS_RECD
/
create public synonym USER_TAB_PRIVS_RECD for USER_TAB_PRIVS_RECD
/
grant select on USER_TAB_PRIVS_RECD to PUBLIC with grant option
/
create or replace view ALL_TAB_PRIVS_RECD
      (GRANTEE, OWNER, TABLE_NAME, GRANTOR, PRIVILEGE, GRANTABLE)
as
select ue.name, u.name, o.name, ur.name, tpm.name, 
       decode(oa.option$, 1, 'YES', 'NO')
from sys.objauth$ oa, sys.obj$ o, sys.user$ u, sys.user$ ur, sys.user$ ue,
     table_privilege_map tpm
where oa.obj# = o.obj#
  and oa.grantor# = ur.user#
  and oa.grantee# = ue.user#
  and u.user# = o.owner#
  and oa.col# is null
  and oa.privilege# = tpm.privilege
  and oa.grantee# in (select kzsrorol from x$kzsro)
/
comment on table ALL_TAB_PRIVS_RECD is
'Grants on objects for which the user, PUBLIC or enabled role is the grantee'
/
comment on column ALL_TAB_PRIVS_RECD.GRANTEE is
'Name of the user to whom access was granted'
/
comment on column ALL_TAB_PRIVS_RECD.OWNER is
'Owner of the object'
/
comment on column ALL_TAB_PRIVS_RECD.TABLE_NAME is
'Name of the object'
/
comment on column ALL_TAB_PRIVS_RECD.GRANTOR is
'Name of the user who performed the grant'
/
comment on column ALL_TAB_PRIVS_RECD.PRIVILEGE is
'Table Privilege'
/
comment on column ALL_TAB_PRIVS_RECD.GRANTABLE is
'Privilege is grantable'
/
drop public synonym ALL_TAB_PRIVS_RECD
/
create public synonym ALL_TAB_PRIVS_RECD for ALL_TAB_PRIVS_RECD
/
grant select on ALL_TAB_PRIVS_RECD to PUBLIC with grant option
/
remark
remark  FAMILY "TS_QUOTAS"
remark  Tablespace quotas for users.
remark  This family has no ALL member.
remark
create or replace view USER_TS_QUOTAS
    (TABLESPACE_NAME, BYTES, MAX_BYTES, BLOCKS, MAX_BLOCKS)
as
select ts.name, q.blocks * ts.blocksize,
       decode(q.maxblocks, -1, -1, q.maxblocks * ts.blocksize),
       q.blocks, q.maxblocks
from sys.tsq$ q, sys.ts$ ts
where q.ts# = ts.ts#
  and q.user# = userenv('SCHEMAID')
/
comment on table USER_TS_QUOTAS is
'Tablespace quotas for the user'
/
comment on column USER_TS_QUOTAS.TABLESPACE_NAME is
'Tablespace name'
/
comment on column USER_TS_QUOTAS.BLOCKS is
'Number of ORACLE blocks charged to the user'
/
comment on column USER_TS_QUOTAS.MAX_BLOCKS is
'User''s quota in ORACLE blocks.  NULL if no limit'
/
comment on column USER_TS_QUOTAS.BYTES is
'Number of bytes charged to the user'
/
comment on column USER_TS_QUOTAS.MAX_BYTES is
'User''s quota in bytes.  NULL if no limit'
/
drop public synonym USER_TS_QUOTAS
/
create public synonym USER_TS_QUOTAS for USER_TS_QUOTAS
/
grant select on USER_TS_QUOTAS to PUBLIC with grant option
/
create or replace view DBA_TS_QUOTAS
    (TABLESPACE_NAME, USERNAME, BYTES, MAX_BYTES, BLOCKS, MAX_BLOCKS)
as
select ts.name, u.name, 
       q.blocks * ts.blocksize, 
       decode(q.maxblocks, -1, -1, q.maxblocks * ts.blocksize),
       q.blocks, q.maxblocks
from sys.tsq$ q, sys.ts$ ts, sys.user$ u
where q.ts# = ts.ts#
  and q.user# = u.user#
  and q.maxblocks != 0
/
drop public synonym DBA_TS_QUOTAS
/
create public synonym DBA_TS_QUOTAS for DBA_TS_QUOTAS
/
grant select on DBA_TS_QUOTAS to select_catalog_role
/
comment on table DBA_TS_QUOTAS is
'Tablespace quotas for all users'
/
comment on column DBA_TS_QUOTAS.TABLESPACE_NAME is
'Tablespace name'
/
comment on column DBA_TS_QUOTAS.USERNAME is
'User with resource rights on the tablespace'
/
comment on column DBA_TS_QUOTAS.BLOCKS is
'Number of ORACLE blocks charged to the user'
/
comment on column DBA_TS_QUOTAS.MAX_BLOCKS is
'User''s quota in ORACLE blocks.  NULL if no limit'
/
comment on column DBA_TS_QUOTAS.BYTES is
'Number of bytes charged to the user'
/
comment on column DBA_TS_QUOTAS.MAX_BYTES is
'User''s quota in bytes.  NULL if no limit'
/
remark
remark  FAMILY "USERS"
remark  Users enrolled in the database.
remark
create or replace view USER_USERS
    (USERNAME, USER_ID, ACCOUNT_STATUS, LOCK_DATE, EXPIRY_DATE,
	DEFAULT_TABLESPACE, TEMPORARY_TABLESPACE, CREATED, EXTERNAL_NAME)
as
select u.name, u.user#,
       m.status, 
       decode(u.astatus, 4, u.ltime, 
                         5, u.ltime, 
			 6, u.ltime,
                         12, u.ltime, NULL),
       decode(u.astatus, 1, u.exptime,
              2, u.exptime,
              6, u.exptime,
              10, u.exptime,
	      14, u.exptime,
	      5, u.exptime,
	      9, u.exptime,
	      13, u.exptime,
              decode(u.ptime, '', NULL, 
                decode(p.limit#, 2147483647, NULL,
                 decode(p.limit#, 0, 
                   decode(dp.limit#, 2147483647, NULL, u.ptime +
                     dp.limit#/86400),
                   u.ptime + p.limit#/86400)))),
       dts.name, tts.name, u.ctime, u.ext_username
from sys.user$ u, sys.ts$ dts, sys.ts$ tts, sys.user_astatus_map m, profile$ p,
 profile$ dp
where u.datats# = dts.ts#
  and u.tempts# = tts.ts#
  and u.astatus = m.status#
  and u.type# = 1
  and u.user# = userenv('SCHEMAID')
  and u.resource$ = p.profile#
  and dp.profile# = 0
  and dp.type# = 1
  and dp.resource# = 1
  and p.type# = 1
  and p.resource# = 1
/
comment on table USER_USERS is
'Information about the current user'
/
comment on column USER_USERS.USERNAME is
'Name of the user'
/
comment on column USER_USERS.USER_ID is
'ID number of the user'
/
comment on column USER_USERS.DEFAULT_TABLESPACE is
'Default tablespace for data'
/
comment on column USER_USERS.TEMPORARY_TABLESPACE is
'Default tablespace for temporary tables'
/
comment on column USER_USERS.CREATED is
'User creation date'
/
comment on column USER_USERS.EXTERNAL_NAME is
'User external name'
/
drop public synonym USER_USERS
/
create public synonym USER_USERS for USER_USERS
/
grant select on USER_USERS to PUBLIC with grant option
/
create or replace view ALL_USERS
    (USERNAME, USER_ID, CREATED)
as
select u.name, u.user#, u.ctime
from sys.user$ u, sys.ts$ dts, sys.ts$ tts
where u.datats# = dts.ts#
  and u.tempts# = tts.ts#
  and u.type# = 1
/
comment on table ALL_USERS is
'Information about all users of the database'
/
comment on column ALL_USERS.USERNAME is
'Name of the user'
/
comment on column ALL_USERS.USER_ID is
'ID number of the user'
/
comment on column ALL_USERS.CREATED is
'User creation date'
/
drop public synonym ALL_USERS
/
create public synonym ALL_USERS for ALL_USERS
/
grant select on ALL_USERS to PUBLIC with grant option
/
create or replace view DBA_USERS
    (USERNAME, USER_ID, PASSWORD, ACCOUNT_STATUS, LOCK_DATE, EXPIRY_DATE,
	DEFAULT_TABLESPACE, TEMPORARY_TABLESPACE, CREATED, PROFILE,
	EXTERNAL_NAME)
as
select u.name, u.user#, u.password,
       m.status, 
       decode(u.astatus, 4, u.ltime, 
                         5, u.ltime,
                         6, u.ltime,
                         12, u.ltime,NULL),
       decode(u.astatus, 1, u.exptime,
              2, u.exptime,
              6, u.exptime,
              10, u.exptime,
	      14, u.exptime,
	      5, u.exptime,
	      9, u.exptime,
	      13, u.exptime,
              decode(u.ptime, '', NULL, 
                decode(pr.limit#, 2147483647, NULL,
                 decode(pr.limit#, 0, 
                   decode(dp.limit#, 2147483647, NULL, u.ptime +
                     dp.limit#/86400),
                   u.ptime + pr.limit#/86400)))),
       dts.name, tts.name, u.ctime, p.name, u.ext_username
       from sys.user$ u, sys.ts$ dts, sys.ts$ tts, sys.profname$ p, 
            sys.user_astatus_map m, sys.profile$ pr, sys.profile$ dp
       where u.datats# = dts.ts#
       and u.resource$ = p.profile#
       and u.tempts# = tts.ts#
       and u.astatus = m.status#
       and u.type# = 1
       and u.resource$ = pr.profile#
       and dp.profile# = 0
       and dp.type#=1
       and dp.resource#=1
       and pr.type# = 1
       and pr.resource# = 1
/
drop public synonym DBA_USERS
/
create public synonym DBA_USERS for DBA_USERS
/
grant select on DBA_USERS to select_catalog_role
/
comment on table DBA_USERS is
'Information about all users of the database'
/
comment on column DBA_USERS.USERNAME is
'Name of the user'
/
comment on column DBA_USERS.USER_ID is
'ID number of the user'
/
comment on column DBA_USERS.PASSWORD is
'Encrypted password'
/
comment on column DBA_USERS.DEFAULT_TABLESPACE is
'Default tablespace for data'
/
comment on column DBA_USERS.TEMPORARY_TABLESPACE is
'Default tablespace for temporary tables'
/
comment on column DBA_USERS.CREATED is
'User creation date'
/
comment on column DBA_USERS.PROFILE is
'User resource profile name'
/
comment on column DBA_USERS.EXTERNAL_NAME is
'User external name'
/
remark
remark  FAMILY "VIEWS"
remark  All relevant information about views, except columns.
remark
create or replace view USER_VIEWS
    (VIEW_NAME, TEXT_LENGTH, TEXT, TYPE_TEXT_LENGTH, TYPE_TEXT,
     OID_TEXT_LENGTH, OID_TEXT, VIEW_TYPE_OWNER, VIEW_TYPE)
as
select o.name, v.textlength, v.text, t.typetextlength, t.typetext,
       t.oidtextlength, t.oidtext, t.typeowner, t.typename
from sys.obj$ o, sys.view$ v, sys.typed_view$ t
where o.obj# = v.obj#
  and o.obj# = t.obj#(+)
  and o.owner# = userenv('SCHEMAID')
/
comment on table USER_VIEWS is
'Description of the user''s own views'
/
comment on column USER_VIEWS.VIEW_NAME is
'Name of the view'
/
comment on column USER_VIEWS.TEXT_LENGTH is
'Length of the view text'
/
comment on column USER_VIEWS.TEXT is
'View text'
/
comment on column USER_VIEWS.TYPE_TEXT_LENGTH is
'Length of the type clause of the object view'
/
comment on column USER_VIEWS.TYPE_TEXT is
'Type clause of the object view'
/
comment on column USER_VIEWS.OID_TEXT_LENGTH is
'Length of the WITH OBJECT OID clause of the object view'
/
comment on column USER_VIEWS.OID_TEXT is
'WITH OBJECT OID clause of the object view'
/
comment on column USER_VIEWS.VIEW_TYPE_OWNER is
'Owner of the type of the view if the view is a object view'
/
comment on column USER_VIEWS.VIEW_TYPE is
'Type of the view if the view is a object view'
/
drop public synonym USER_VIEWS
/
create public synonym USER_VIEWS for USER_VIEWS
/
grant select on USER_VIEWS to PUBLIC with grant option
/
create or replace view ALL_VIEWS
    (OWNER, VIEW_NAME, TEXT_LENGTH, TEXT, TYPE_TEXT_LENGTH, TYPE_TEXT,
     OID_TEXT_LENGTH, OID_TEXT, VIEW_TYPE_OWNER, VIEW_TYPE)
as
select u.name, o.name, v.textlength, v.text, t.typetextlength, t.typetext,
       t.oidtextlength, t.oidtext, t.typeowner, t.typename
from sys.obj$ o, sys.view$ v, sys.user$ u, sys.typed_view$ t
where o.obj# = v.obj#
  and o.obj# = t.obj#(+)
  and o.owner# = u.user#
  and (o.owner# = userenv('SCHEMAID')
       or o.obj# in
            (select oa.obj#
             from sys.objauth$ oa
             where oa.grantee# in ( select kzsrorol
                                         from x$kzsro
                                  )
            )
	or /* user has system privileges */
	  exists (select null from v$enabledprivs
		  where priv_number in (-45 /* LOCK ANY TABLE */,
					-47 /* SELECT ANY TABLE */,
					-48 /* INSERT ANY TABLE */,
					-49 /* UPDATE ANY TABLE */,
					-50 /* DELETE ANY TABLE */)
		  )
      )
/
comment on table ALL_VIEWS is
'Description of views accessible to the user'
/
comment on column ALL_VIEWS.OWNER is
'Owner of the view'
/
comment on column ALL_VIEWS.VIEW_NAME is
'Name of the view'
/
comment on column ALL_VIEWS.TEXT_LENGTH is
'Length of the view text'
/
comment on column ALL_VIEWS.TEXT is
'View text'
/
comment on column ALL_VIEWS.TYPE_TEXT_LENGTH is
'Length of the type clause of the object view'
/
comment on column ALL_VIEWS.TYPE_TEXT is
'Type clause of the object view'
/
comment on column ALL_VIEWS.OID_TEXT_LENGTH is
'Length of the WITH OBJECT OID clause of the object view'
/
comment on column ALL_VIEWS.OID_TEXT is
'WITH OBJECT OID clause of the object view'
/
comment on column ALL_VIEWS.VIEW_TYPE_OWNER is
'Owner of the type of the view if the view is an object view'
/
comment on column ALL_VIEWS.VIEW_TYPE is
'Type of the view if the view is an object view'
/
drop public synonym ALL_VIEWS
/
create public synonym ALL_VIEWS for ALL_VIEWS
/
grant select on ALL_VIEWS to PUBLIC with grant option
/
create or replace view DBA_VIEWS
    (OWNER, VIEW_NAME, TEXT_LENGTH, TEXT, TYPE_TEXT_LENGTH, TYPE_TEXT,
     OID_TEXT_LENGTH, OID_TEXT, VIEW_TYPE_OWNER, VIEW_TYPE)
as
select u.name, o.name, v.textlength, v.text, t.typetextlength, t.typetext,
       t.oidtextlength, t.oidtext, t.typeowner, t.typename
from sys.obj$ o, sys.view$ v, sys.user$ u, sys.typed_view$ t
where o.obj# = v.obj#
  and o.obj# = t.obj#(+)
  and o.owner# = u.user#
/
drop public synonym DBA_VIEWS
/
create public synonym DBA_VIEWS for DBA_VIEWS
/
grant select on DBA_VIEWS to select_catalog_role
/
comment on table DBA_VIEWS is
'Description of all views in the database'
/
comment on column DBA_VIEWS.OWNER is
'Owner of the view'
/
comment on column DBA_VIEWS.VIEW_NAME is
'Name of the view'
/
comment on column DBA_VIEWS.TEXT_LENGTH is
'Length of the view text'
/
comment on column DBA_VIEWS.TEXT is
'View text'
/
comment on column DBA_VIEWS.TYPE_TEXT_LENGTH is
'Length of the type clause of the object view'
/
comment on column DBA_VIEWS.TYPE_TEXT is
'Type clause of the object view'
/
comment on column DBA_VIEWS.OID_TEXT_LENGTH is
'Length of the WITH OBJECT OID clause of the object view'
/
comment on column DBA_VIEWS.OID_TEXT is
'WITH OBJECT OID clause of the object view'
/
comment on column DBA_VIEWS.VIEW_TYPE_OWNER is
'Owner of the type of the view if the view is an object view'
/
comment on column DBA_VIEWS.VIEW_TYPE is
'Type of the view if the view is an object view'
/
remark
remark  FAMILY "CONSTRAINTS"
remark
create or replace view USER_CONSTRAINTS 
    (OWNER, CONSTRAINT_NAME, CONSTRAINT_TYPE,
     TABLE_NAME, SEARCH_CONDITION, R_OWNER,
     R_CONSTRAINT_NAME, DELETE_RULE, STATUS, 
     DEFERRABLE, DEFERRED, VALIDATED, GENERATED, BAD, LAST_CHANGE)
as
select ou.name, oc.name,
       decode(c.type#, 1, 'C', 2, 'P', 3, 'U',
              4, 'R', 5, 'V', 6, 'O', 7,'C', '?'),
       o.name, c.condition, ru.name, rc.name, 
       decode(c.type#, 4,
              decode(c.refact, 1, 'CASCADE', 'NO ACTION'), NULL),
       decode(c.type#, 5, 'ENABLED',
              decode(c.enabled, NULL, 'DISABLED', 'ENABLED')),
       decode(bitand(c.defer, 1), 1, 'DEFERRABLE', 'NOT DEFERRABLE'),
       decode(bitand(c.defer, 2), 2, 'DEFERRED', 'IMMEDIATE'),
       decode(bitand(c.defer, 4), 4, 'VALIDATED', 'NOT VALIDATED'),
       decode(bitand(c.defer, 8), 8, 'GENERATED NAME', 'USER NAME'),
       decode(bitand(c.defer,16),16, 'BAD', null),
       c.mtime
from sys.con$ oc, sys.con$ rc, sys.user$ ou, sys.user$ ru,
     sys.obj$ o, sys.cdef$ c
where oc.owner# = ou.user#
  and oc.con# = c.con#
  and c.obj# = o.obj#
  and c.rcon# = rc.con#(+)
  and rc.owner# = ru.user#(+)
  and o.owner# = userenv('SCHEMAID')
  and c.type# != 8;
/
comment on table USER_CONSTRAINTS is
'Constraint definitions on user''s own tables'
/
comment on column USER_CONSTRAINTS.OWNER is
'Owner of the table'
/
comment on column USER_CONSTRAINTS.CONSTRAINT_NAME is
'Name associated with constraint definition'
/
comment on column USER_CONSTRAINTS.CONSTRAINT_TYPE is
'Type of constraint definition'
/
comment on column USER_CONSTRAINTS.TABLE_NAME is
'Name associated with table with constraint definition'
/
comment on column USER_CONSTRAINTS.SEARCH_CONDITION is
'Text of search condition for table check'
/
comment on column USER_CONSTRAINTS.R_OWNER is
'Owner of table used in referential constraint'
/
comment on column USER_CONSTRAINTS.R_CONSTRAINT_NAME is
'Name of unique constraint definition for referenced table'
/
comment on column USER_CONSTRAINTS.DELETE_RULE is
'The delete rule for a referential constraint'
/
comment on column USER_CONSTRAINTS.STATUS is
'Enforcement status of constraint -  ENABLED or DISABLED'
/
comment on column USER_CONSTRAINTS.DEFERRABLE is
'Is the constraint deferrable - DEFERRABLE or NOT DEFERRABLE'
/
comment on column USER_CONSTRAINTS.DEFERRED is
'Is the constraint deferred by default -  DEFERRED or IMMEDIATE'
/
comment on column USER_CONSTRAINTS.VALIDATED is
'Was this constraint system validated? -  VALIDATED or NOT VALIDATED'
/
comment on column USER_CONSTRAINTS.GENERATED is
'Was the constraint name system generated? -  GENERATED NAME or USER NAME'
/
comment on column USER_CONSTRAINTS.BAD is
'Creating this constraint should give ORA-02436.  Rewrite it before 2000 AD.'
/
comment on column USER_CONSTRAINTS.LAST_CHANGE is
'The date when this column was last enabled or disabled'
/
grant select on USER_CONSTRAINTS to public with grant option
/
drop public synonym USER_CONSTRAINTS
/
create public synonym USER_CONSTRAINTS for USER_CONSTRAINTS
/
create or replace view ALL_CONSTRAINTS 
    (OWNER, CONSTRAINT_NAME, CONSTRAINT_TYPE,
     TABLE_NAME, SEARCH_CONDITION, R_OWNER,
     R_CONSTRAINT_NAME, DELETE_RULE, STATUS, 
     DEFERRABLE, DEFERRED, VALIDATED, GENERATED, BAD, LAST_CHANGE)
as
select ou.name, oc.name,
       decode(c.type#, 1, 'C', 2, 'P', 3, 'U',
              4, 'R', 5, 'V', 6, 'O', 7,'C', '?'),
       o.name, c.condition, ru.name, rc.name,
       decode(c.type#, 4,
              decode(c.refact, 1, 'CASCADE', 'NO ACTION'), NULL),
       decode(c.type#, 5, 'ENABLED',
              decode(c.enabled, NULL, 'DISABLED', 'ENABLED')),
       decode(bitand(c.defer, 1), 1, 'DEFERRABLE', 'NOT DEFERRABLE'),
       decode(bitand(c.defer, 2), 2, 'DEFERRED', 'IMMEDIATE'),
       decode(bitand(c.defer, 4), 4, 'VALIDATED', 'NOT VALIDATED'),
       decode(bitand(c.defer, 8), 8, 'GENERATED NAME', 'USER NAME'),
       decode(bitand(c.defer,16),16, 'BAD', null),
       c.mtime
from sys.con$ oc, sys.con$ rc, sys.user$ ou, sys.user$ ru,
     sys.obj$ o, sys.cdef$ c
where oc.owner# = ou.user#
  and oc.con# = c.con#
  and c.obj# = o.obj#
  and c.type# != 8
  and c.rcon# = rc.con#(+)
  and rc.owner# = ru.user#(+)
  and (o.owner# = userenv('SCHEMAID')
       or o.obj# in (select obj#
                     from sys.objauth$
                     where grantee# in ( select kzsrorol
                                         from x$kzsro
                                       )
                    )
	or /* user has system privileges */
	  exists (select null from v$enabledprivs
		  where priv_number in (-45 /* LOCK ANY TABLE */,
					-47 /* SELECT ANY TABLE */,
					-48 /* INSERT ANY TABLE */,
					-49 /* UPDATE ANY TABLE */,
					-50 /* DELETE ANY TABLE */)
		  )
      )
/
comment on table ALL_CONSTRAINTS is
'Constraint definitions on accessible tables'
/
comment on column ALL_CONSTRAINTS.OWNER is
'Owner of the table'
/
comment on column ALL_CONSTRAINTS.CONSTRAINT_NAME is
'Name associated with constraint definition'
/
comment on column ALL_CONSTRAINTS.CONSTRAINT_TYPE is
'Type of constraint definition'
/
comment on column ALL_CONSTRAINTS.TABLE_NAME is
'Name associated with table with constraint definition'
/
comment on column ALL_CONSTRAINTS.SEARCH_CONDITION is
'Text of search condition for table check'
/
comment on column ALL_CONSTRAINTS.R_OWNER is
'Owner of table used in referential constraint'
/
comment on column ALL_CONSTRAINTS.R_CONSTRAINT_NAME is
'Name of unique constraint definition for referenced table'
/
comment on column ALL_CONSTRAINTS.DELETE_RULE is
'The delete rule for a referential constraint'
/
comment on column ALL_CONSTRAINTS.STATUS is
'Enforcement status of constraint - ENABLED or DISABLED'
/
comment on column ALL_CONSTRAINTS.DEFERRABLE is
'Is the constraint deferrable - DEFERRABLE or NOT DEFERRABLE'
/
comment on column ALL_CONSTRAINTS.DEFERRED is
'Is the constraint deferred by default -  DEFERRED or IMMEDIATE'
/
comment on column ALL_CONSTRAINTS.VALIDATED is
'Was this constraint system validated? -  VALIDATED or NOT VALIDATED'
/
comment on column ALL_CONSTRAINTS.GENERATED is
'Was the constraint name system generated? -  GENERATED NAME or USER NAME'
/
comment on column ALL_CONSTRAINTS.BAD is
'Creating this constraint should give ORA-02436.  Rewrite it before 2000 AD.'
/
comment on column ALL_CONSTRAINTS.LAST_CHANGE is
'The date when this column was last enabled or disabled'
/
grant select on ALL_CONSTRAINTS to public with grant option
/
drop public synonym ALL_CONSTRAINTS
/
create public synonym ALL_CONSTRAINTS for ALL_CONSTRAINTS
/
create or replace view DBA_CONSTRAINTS 
    (OWNER, CONSTRAINT_NAME, CONSTRAINT_TYPE,
     TABLE_NAME, SEARCH_CONDITION, R_OWNER,
     R_CONSTRAINT_NAME, DELETE_RULE, STATUS, 
     DEFERRABLE, DEFERRED, VALIDATED, GENERATED, BAD, LAST_CHANGE)
as
select ou.name, oc.name,
       decode(c.type#, 1, 'C', 2, 'P', 3, 'U',
              4, 'R', 5, 'V', 6, 'O', 7,'C', '?'),
       o.name, c.condition, ru.name, rc.name, 
       decode(c.type#, 4,
              decode(c.refact, 1, 'CASCADE', 'NO ACTION'), NULL),
       decode(c.type#, 5, 'ENABLED',
              decode(c.enabled, NULL, 'DISABLED', 'ENABLED')),
       decode(bitand(c.defer, 1), 1, 'DEFERRABLE', 'NOT DEFERRABLE'),
       decode(bitand(c.defer, 2), 2, 'DEFERRED', 'IMMEDIATE'),
       decode(bitand(c.defer, 4), 4, 'VALIDATED', 'NOT VALIDATED'),
       decode(bitand(c.defer, 8), 8, 'GENERATED NAME', 'USER NAME'),
       decode(bitand(c.defer,16),16, 'BAD', null),
       c.mtime
from sys.con$ oc, sys.con$ rc, sys.user$ ou, sys.user$ ru,
     sys.obj$ o, sys.cdef$ c
where oc.owner# = ou.user#
  and oc.con# = c.con#
  and c.obj# = o.obj#
  and c.type# != 8        /* don't include hash expressions */
  and c.rcon# = rc.con#(+)
  and rc.owner# = ru.user#(+)
/
drop public synonym DBA_CONSTRAINTS
/
create public synonym DBA_CONSTRAINTS for DBA_CONSTRAINTS
/
grant select on DBA_CONSTRAINTS to select_catalog_role
/
comment on table DBA_CONSTRAINTS is
'Constraint definitions on all tables'
/
comment on column DBA_CONSTRAINTS.OWNER is
'Owner of the table'
/
comment on column DBA_CONSTRAINTS.CONSTRAINT_NAME is
'Name associated with constraint definition'
/
comment on column DBA_CONSTRAINTS.CONSTRAINT_TYPE is
'Type of constraint definition'
/
comment on column DBA_CONSTRAINTS.TABLE_NAME is
'Name associated with table with constraint definition'
/
comment on column DBA_CONSTRAINTS.SEARCH_CONDITION is
'Text of search condition for table check'
/
comment on column DBA_CONSTRAINTS.R_OWNER is
'Owner of table used in referential constraint'
/
comment on column DBA_CONSTRAINTS.R_CONSTRAINT_NAME is
'Name of unique constraint definition for referenced table'
/
comment on column DBA_CONSTRAINTS.DELETE_RULE is
'The delete rule for a referential constraint'
/
comment on column DBA_CONSTRAINTS.STATUS is
'Enforcement status of constraint - ENABLED or DISABLED'
/
comment on column DBA_CONSTRAINTS.DEFERRABLE is
'Is the constraint deferrable - DEFERRABLE or NOT DEFERRABLE'
/
comment on column DBA_CONSTRAINTS.DEFERRED is
'Is the constraint deferred by default -  DEFERRED or IMMEDIATE'
/
comment on column DBA_CONSTRAINTS.VALIDATED is
'Was this constraint system validated? -  VALIDATED or NOT VALIDATED'
/
comment on column DBA_CONSTRAINTS.GENERATED is
'Was the constraint name system generated? -  GENERATED NAME or USER NAME'
/
comment on column DBA_CONSTRAINTS.BAD is
'Creating this constraint should give ORA-02436.  Rewrite it before 2000 AD.'
/
comment on column DBA_CONSTRAINTS.LAST_CHANGE is
'The date when this column was last enabled or disabled'
/

remark
remark FAMILY CLUSTER_HASH_EXPRESSIONS
remark 
create or replace view USER_CLUSTER_HASH_EXPRESSIONS
    (OWNER, CLUSTER_NAME, HASH_EXPRESSION)
as
select us.name, o.name, c.condition
from sys.cdef$ c, sys.user$ us, sys.obj$ o
where c.type#   = 8
and   c.obj#   = o.obj#
and   us.user# = o.owner#
and   us.user# = userenv('SCHEMAID')
/

comment on table USER_CLUSTER_HASH_EXPRESSIONS is
'Hash functions for the user''s hash clusters'
/
comment on column USER_CLUSTER_HASH_EXPRESSIONS.OWNER is
'Name of owner of cluster'
/
comment on column USER_CLUSTER_HASH_EXPRESSIONS.CLUSTER_NAME is
'Name of cluster'
/
comment on column USER_CLUSTER_HASH_EXPRESSIONS.HASH_EXPRESSION is
'Text of hash function of cluster'
/
grant select on USER_CLUSTER_HASH_EXPRESSIONS to public with grant option
/
drop public synonym USER_CLUSTER_HASH_EXPRESSIONS
/
create public synonym USER_CLUSTER_HASH_EXPRESSIONS for
 USER_CLUSTER_HASH_EXPRESSIONS
/

create or replace view ALL_CLUSTER_HASH_EXPRESSIONS
    (OWNER, CLUSTER_NAME, HASH_EXPRESSION)
as
select us.name, o.name, c.condition
from sys.cdef$ c, sys.user$ us, sys.obj$ o
where c.type#   = 8
and   c.obj#   = o.obj#
and   us.user# = o.owner#
and   ( us.user# = userenv('SCHEMAID')
        or  /* user has system privilages */
           exists (select null from v$enabledprivs
               where priv_number in (-61 /* CREATE ANY CLUSTER */,
                                     -62 /* ALTER ANY CLUSTER */,
                                     -63 /* DROP ANY CLUSTER */ )
		  )
      )
/

comment on table ALL_CLUSTER_HASH_EXPRESSIONS is
'Hash functions for all accessible clusters'
/
comment on column ALL_CLUSTER_HASH_EXPRESSIONS.OWNER is
'Name of owner of cluster'
/
comment on column ALL_CLUSTER_HASH_EXPRESSIONS.CLUSTER_NAME is
'Name of cluster'
/
comment on column ALL_CLUSTER_HASH_EXPRESSIONS.HASH_EXPRESSION is
'Text of hash function of cluster'
/
grant select on ALL_CLUSTER_HASH_EXPRESSIONS to public with grant option
/
drop public synonym ALL_CLUSTER_HASH_EXPRESSIONS
/
create public synonym ALL_CLUSTER_HASH_EXPRESSIONS for
 ALL_CLUSTER_HASH_EXPRESSIONS
/

create or replace view DBA_CLUSTER_HASH_EXPRESSIONS
    (OWNER, CLUSTER_NAME, HASH_EXPRESSION)
as
select us.name, o.name, c.condition
from sys.cdef$ c, sys.user$ us, sys.obj$ o
where c.type# = 8
and c.obj#   = o.obj#
and us.user# = o.owner#
/

comment on table DBA_CLUSTER_HASH_EXPRESSIONS is
'Hash functions for all clusters'
/
comment on column DBA_CLUSTER_HASH_EXPRESSIONS.OWNER is
'Name of owner of cluster'
/
comment on column DBA_CLUSTER_HASH_EXPRESSIONS.CLUSTER_NAME is
'Text of hash function of the cluster'
/
comment on column DBA_CLUSTER_HASH_EXPRESSIONS.HASH_EXPRESSION is
'Text of hash function of cluster'
/
drop public synonym DBA_CLUSTER_HASH_EXPRESSIONS
/
create public synonym DBA_CLUSTER_HASH_EXPRESSIONS for
 DBA_CLUSTER_HASH_EXPRESSIONS
/
grant select on DBA_CLUSTER_HASH_EXPRESSIONS to select_catalog_role
/

remark
remark  FAMILY "CONS_COLUMNS"
remark
create or replace view USER_CONS_COLUMNS 
    (OWNER, CONSTRAINT_NAME, TABLE_NAME, COLUMN_NAME, POSITION)
as
select u.name, c.name, o.name,
       decode(bitand(col.property, 1), 1, ac.name, col.name), cc.pos#
from sys.user$ u, sys.con$ c, sys.col$ col, sys.ccol$ cc, sys.cdef$ cd,
     sys.obj$ o, sys.attrcol$ ac
where c.owner# = u.user#
  and c.con# = cd.con#
  and cd.con# = cc.con#
  and cc.obj# = col.obj#
  and cc.intcol# = col.intcol#
  and cc.obj# = o.obj#
  and c.owner# = userenv('SCHEMAID')
  and col.obj# = ac.obj#(+)
  and col.intcol# = ac.intcol#(+)
/
comment on table USER_CONS_COLUMNS is
'Information about accessible columns in constraint definitions'
/
comment on column USER_CONS_COLUMNS.OWNER is
'Owner of the constraint definition'
/
comment on column USER_CONS_COLUMNS.CONSTRAINT_NAME is
'Name associated with the constraint definition'
/
comment on column USER_CONS_COLUMNS.TABLE_NAME is
'Name associated with table with constraint definition'
/
comment on column USER_CONS_COLUMNS.COLUMN_NAME is
'Name associated with column or attribute of object column specified in the constraint definition'
/
comment on column USER_CONS_COLUMNS.POSITION is
'Original position of column or attribute in definition'
/
grant select on USER_CONS_COLUMNS to public with grant option
/
drop public synonym USER_CONS_COLUMNS
/
create public synonym USER_CONS_COLUMNS for USER_CONS_COLUMNS
/
create or replace view ALL_CONS_COLUMNS 
    (OWNER, CONSTRAINT_NAME, TABLE_NAME, COLUMN_NAME, POSITION)
as
select u.name, c.name, o.name,
       decode(bitand(col.property, 1), 1, ac.name, col.name), cc.pos#
from sys.user$ u, sys.con$ c, sys.col$ col, sys.ccol$ cc, sys.cdef$ cd,
     sys.obj$ o, sys.attrcol$ ac
where c.owner# = u.user#
  and c.con# = cd.con#
  and cd.con# = cc.con#
  and cc.obj# = col.obj#
  and cc.intcol# = col.intcol#
  and cc.obj# = o.obj#
  and (c.owner# = userenv('SCHEMAID')
       or cd.obj# in (select obj#
                      from sys.objauth$
                      where grantee# in ( select kzsrorol
                                         from x$kzsro
                                       )
                     )
	or /* user has system privileges */
	  exists (select null from v$enabledprivs
		  where priv_number in (-45 /* LOCK ANY TABLE */,
					-47 /* SELECT ANY TABLE */,
					-48 /* INSERT ANY TABLE */,
					-49 /* UPDATE ANY TABLE */,
					-50 /* DELETE ANY TABLE */)
		  )
      )
  and col.obj# = ac.obj#(+)
  and col.intcol# = ac.intcol#(+)
/
comment on table ALL_CONS_COLUMNS is
'Information about accessible columns in constraint definitions'
/
comment on column ALL_CONS_COLUMNS.OWNER is
'Owner of the constraint definition'
/
comment on column ALL_CONS_COLUMNS.CONSTRAINT_NAME is
'Name associated with the constraint definition'
/
comment on column ALL_CONS_COLUMNS.TABLE_NAME is
'Name associated with table with constraint definition'
/
comment on column ALL_CONS_COLUMNS.COLUMN_NAME is
'Name associated with column or attribute of object column specified in the constraint definition'
/
comment on column ALL_CONS_COLUMNS.POSITION is
'Original position of column or attribute in definition'
/
grant select on ALL_CONS_COLUMNS to public with grant option
/
drop public synonym ALL_CONS_COLUMNS
/
create public synonym ALL_CONS_COLUMNS for ALL_CONS_COLUMNS
/
create or replace view DBA_CONS_COLUMNS 
    (OWNER, CONSTRAINT_NAME, TABLE_NAME, COLUMN_NAME, POSITION)
as
select u.name, c.name, o.name,
       decode(bitand(col.property, 1), 1, ac.name, col.name), cc.pos#
from sys.user$ u, sys.con$ c, sys.col$ col, sys.ccol$ cc, sys.cdef$ cd,
     sys.obj$ o, sys.attrcol$ ac
where c.owner# = u.user#
  and c.con# = cd.con#
  and cd.con# = cc.con#
  and cc.obj# = col.obj#
  and cc.intcol# = col.intcol#
  and cc.obj# = o.obj#
  and col.obj# = ac.obj#(+)
  and col.intcol# = ac.intcol#(+)
/
drop public synonym DBA_CONS_COLUMNS
/
create public synonym DBA_CONS_COLUMNS for DBA_CONS_COLUMNS
/
grant select on DBA_CONS_COLUMNS to select_catalog_role
/
comment on table DBA_CONS_COLUMNS is
'Information about accessible columns in constraint definitions'
/
comment on column DBA_CONS_COLUMNS.OWNER is
'Owner of the constraint definition'
/
comment on column DBA_CONS_COLUMNS.CONSTRAINT_NAME is
'Name associated with the constraint definition'
/
comment on column DBA_CONS_COLUMNS.TABLE_NAME is
'Name associated with table with constraint definition'
/
comment on column DBA_CONS_COLUMNS.COLUMN_NAME is
'Name associated with column or attribute of object column specified in the constraint definition'
/
comment on column DBA_CONS_COLUMNS.POSITION is
'Original position of column or attribute in definition'
/

remark
remark  FAMILY "NLS"
remark

create or replace view NLS_SESSION_PARAMETERS (PARAMETER, VALUE) as
select substr(parameter, 1, 30), 
       substr(value, 1, 30) 
from v$nls_parameters
where parameter != 'NLS_CHARACTERSET'
/
comment on table NLS_SESSION_PARAMETERS is
'NLS parameters of the user session'
/
comment on column NLS_SESSION_PARAMETERS.PARAMETER is
'Parameter name'
/
comment on column NLS_SESSION_PARAMETERS.VALUE is
'Parameter value'
/
drop public synonym NLS_SESSION_PARAMETERS
/
create public synonym NLS_SESSION_PARAMETERS for NLS_SESSION_PARAMETERS
/
grant select on NLS_SESSION_PARAMETERS to PUBLIC with grant option
/
create or replace view NLS_INSTANCE_PARAMETERS (PARAMETER, VALUE) as
select substr(upper(name), 1, 30), 
       substr(value, 1, 30) 
from v$parameter 
where name like 'nls%'
/
comment on table NLS_INSTANCE_PARAMETERS is
'NLS parameters of the instance'
/
comment on column NLS_INSTANCE_PARAMETERS.PARAMETER is
'Parameter name'
/
comment on column NLS_INSTANCE_PARAMETERS.VALUE is
'Parameter value'
/
drop public synonym NLS_INSTANCE_PARAMETERS
/
create public synonym NLS_INSTANCE_PARAMETERS for NLS_INSTANCE_PARAMETERS
/
grant select on NLS_INSTANCE_PARAMETERS to PUBLIC with grant option
/
create or replace view NLS_DATABASE_PARAMETERS (PARAMETER, VALUE) as
select name, 
       substr(value$, 1, 30)
from props$ 
where name like 'NLS%'
/
comment on table NLS_DATABASE_PARAMETERS is
'Permanent NLS parameters of the database'
/
comment on column NLS_DATABASE_PARAMETERS.PARAMETER is
'Parameter name'
/
comment on column NLS_DATABASE_PARAMETERS.VALUE is
'Parameter value'
/
drop public synonym NLS_DATABASE_PARAMETERS
/
create public synonym NLS_DATABASE_PARAMETERS for NLS_DATABASE_PARAMETERS
/
grant select on NLS_DATABASE_PARAMETERS to PUBLIC with grant option
/

rem 
rem V5 views required for other Oracle products
rem

create or replace view syscatalog_ 
    (tname, creator, creatorid, tabletype, remarks)
  as
  select o.name, u.name, o.owner#,
         decode(o.type#, 2, 'TABLE', 4, 'VIEW', 6, 'SEQUENCE','?'), c.comment$
  from	sys.user$ u, sys.obj$ o, sys.com$ c
  where u.user# = o.owner#
  and (o.type# in (4, 6)                                    /* view, sequence */
       or
       (o.type# = 2     /* tables, excluding iot - overflow and nested tables */
        and
        not exists (select null
		      from sys.tab$ t
		     where t.obj# = o.obj#
		       and (bitand(t.property, 512) = 512 or
                            bitand(t.property, 8192) = 8192))))
    and o.linkname is null
    and o.obj# = c.obj#(+)
    and ( o.owner# = userenv('SCHEMAID')
	  or o.obj# in
	     (select oa.obj#
	      from   sys.objauth$ oa
	      where  oa.grantee# in (userenv('SCHEMAID'), 1)
	      )
	  or
	  (
	    (o.type# in (4)                                           /* view */
	     or
             (o.type# = 2 /* tables, excluding iot-overflow and nested tables */
              and
              not exists (select null
		            from sys.tab$ t
		           where t.obj# = o.obj#
		             and (bitand(t.property, 512) = 512 or
                                  bitand(t.property, 8192) = 8192))))
	  and
	  exists (select null from v$enabledprivs
		  where priv_number in (-45 /* LOCK ANY TABLE */,
					-47 /* SELECT ANY TABLE */,
					-48 /* INSERT ANY TABLE */,
					-49 /* UPDATE ANY TABLE */,
					-50 /* DELETE ANY TABLE */)
		  )
	   )
	  or
	 ( o.type# = 6 /* sequence */
	   and
	   exists (select null from v$enabledprivs
		   where priv_number = -109 /* SELECT ANY SEQUENCE */)
	 )
       )
/
grant select on syscatalog_ to select_catalog_role
/
create or replace view syscatalog (tname, creator, tabletype, remarks) as
  select tname, creator, tabletype, remarks
  from syscatalog_
/
grant select on syscatalog to public with grant option;
drop synonym system.syscatalog;
create synonym system.syscatalog for syscatalog;
rem
rem The catalog view returns almost all tables accessible to the user
rem except tables in SYS and SYSTEM ("dictionary tables").
rem 
create or replace view catalog (tname, creator, tabletype, remarks) as
  select tname, creator, tabletype, remarks
  from	syscatalog_
  where creatorid not in (0,2)
/
grant select on catalog to public with grant option;
drop synonym system.catalog;
create synonym system.catalog for catalog;

create or replace view tab (tname, tabtype, clusterid) as
   select o.name,
      decode(o.type#, 2, 'TABLE', 3, 'CLUSTER', 
             4, 'VIEW', 5, 'SYNONYM'), t.tab#
  from  sys.tab$ t, sys.obj$ o
  where o.owner# = userenv('SCHEMAID')
  and o.type# >=2
  and o.type# <=5
  and o.linkname is null
  and o.obj# = t.obj# (+)
/
grant select on tab to public with grant option;
drop synonym system.tab;
create synonym system.tab for tab;
drop public synonym tab;
create public synonym tab for tab;
create or replace view col 
  (tname, colno, cname, coltype, width, scale, precision, nulls, defaultval,
   character_set_name) as
  select t.name, c.col#, c.name, 
         decode(c.type#, 1, decode(c.charsetform, 2, 'NVARCHAR2', 'VARCHAR2'),
                         2, decode(c.scale, null,
                                   decode(c.precision#, null, 'NUMBER', 'FLOAT'),
                                  'NUMBER'),
                         8, 'LONG',
                         9, decode(c.charsetform, 2, 'NCHAR VARYING', 'VARCHAR'),
                         12, 'DATE', 23, 'RAW', 24, 'LONG RAW',
                         69, 'ROWID',
                         96, decode(c.charsetform, 2, 'NCHAR', 'CHAR'),
                         105, 'MLSLABEL',
                         106, 'MLSLABEL',
                         111, 'REF '||'"'||ut.name||'"'||'.'||'"'||ot.name||'"',
                         112, decode(c.charsetform, 2, 'NCLOB', 'CLOB'),
                         113, 'BLOB', 114, 'BFILE', 115, 'CFILE',
                         121, '"'||ut.name||'"'||'.'||'"'||ot.name||'"',
                         122, '"'||ut.name||'"'||'.'||'"'||ot.name||'"',
                         123, '"'||ut.name||'"'||'.'||'"'||ot.name||'"',
                         'UNDEFINED'),
         c.length, c.scale, c.precision#,
	 decode(sign(c.null$),-1,'NOT NULL - DISABLED', 0, 'NULL', 
	'NOT NULL'), c.default$,
         decode(c.charsetform, 1, 'CHAR_CS',
                               2, 'NCHAR_CS',
                               3, NLS_CHARSET_NAME(c.charsetid),
                               4, 'ARG:'||c.charsetid)
  from  sys.col$ c, sys.obj$ t, sys.coltype$ ac, sys.obj$ ot, sys.user$ ut
  where t.obj# = c.obj#
  and   t.type# in (2, 3, 4)
  and   t.owner# = userenv('SCHEMAID')
  and   bitand(c.property, 32) = 0 /* not hidden column */
  and   c.obj# = ac.obj#(+)
  and   c.col# = ac.col#(+)
  and   ac.toid = ot.oid$(+)
  and   ot.owner# = ut.user#(+)
/
grant select on col to public with grant option;
drop synonym system.col;
create synonym system.col for col;
drop public synonym col;
create public synonym col for col;
create or replace view syssegobj 
    (obj#, file#, block#, type, pctfree$, pctused$) as
  select obj#, file#, block#, 'TABLE', mod(pctfree$, 100), pctused$ from sys.tab$
  union all
  select obj#, file#, block#, 'CLUSTER', pctfree$, pctused$ from sys.clu$
  union all
  select obj#, file#, block#, 'INDEX', to_number(null), to_number(null)
         from sys.ind$
/
grant select on syssegobj to public with grant option;
create or replace view tabquotas (tname, type, objno, nextext, maxext, pinc,
		       pfree, pused) as
  select t.name, so.type, t.obj#, s.extsize, s.maxexts, s.extpct, so.pctfree$,
	 so.pctused$
  from  sys.seg$ s, sys.obj$ t, syssegobj so
  where t.owner# = userenv('SCHEMAID')
  and   t.obj# = so.obj#
  and   so.file# = s.file# 
  and   so.block# = s.block#
/
grant select on tabquotas to public with grant option;
drop synonym system.tabquotas;
create synonym system.tabquotas for tabquotas;

create or replace view sysfiles (tsname, fname, blocks) as
  select ts.name, dbf.name, f.blocks
  from  sys.ts$ ts, sys.file$ f, sys.v$dbfile dbf
  where ts.ts# = f.ts#(+) and dbf.file# = f.file# and f.status$ = 2
/
grant select on sysfiles to public with grant option;
drop synonym system.sysfiles;
create synonym system.sysfiles for sysfiles;
create or replace view synonyms 
    (sname, syntype, creator, tname, database, tabtype) as
  select s.name, 
	 decode(s.owner#,1,'PUBLIC','PRIVATE'), t.owner, t.name, 'LOCAL', 
	 decode(ot.type#, 1, 'INDEX', 2, 'TABLE', 3, 'CLUSTER', 4, 'VIEW',
			 5, 'SYNONYM', 6, 'SEQUENCE', 7, 'PROCEDURE',
                         8, 'FUNCTION', 9, 'PACKAGE', 22, 'LIBRARY', 
                         'UNDEFINED')
  from  sys.obj$ s, sys.obj$ ot, sys.syn$ t, sys.user$ u
  where s.obj# = t.obj# 
    and ot.linkname is null
    and s.type# = 5
    and ot.name = t.name
    and t.owner = u.name
    and ot.owner# = u.user#
    and s.owner# in (1,userenv('SCHEMAID'))
    and t.node is null
union all
  select s.name, decode(s.owner#, 1, 'PUBLIC', 'PRIVATE'),
	 t.owner, t.name, t.node, 'REMOTE'
  from  sys.obj$ s, sys.syn$ t
  where s.obj# = t.obj#
    and s.type# = 5
    and s.owner# in (1, userenv('SCHEMAID'))
    and t.node is not null
/  
grant select on synonyms to public with grant option;
create or replace view publicsyn (sname, creator, tname, database, tabtype) as
  select sname, creator, tname, database, tabtype
  from  synonyms
  where syntype = 'PUBLIC'
/
grant select on publicsyn to public with grant option;
drop synonym system.publicsyn;
create synonym system.publicsyn for publicsyn;

rem 
rem V6 views required for other Oracle products
rem

create or replace view TABLE_PRIVILEGES
      (GRANTEE, OWNER, TABLE_NAME, GRANTOR,
       SELECT_PRIV, INSERT_PRIV, DELETE_PRIV, 
       UPDATE_PRIV, REFERENCES_PRIV, ALTER_PRIV, INDEX_PRIV,
       CREATED)
as
select ue.name, u.name, o.name, ur.name,
    decode(substr(lpad(sum(power(10, privilege#*2) + 
      decode(option$, null, 0, power(10, privilege#*2 + 1))), 26, '0'), 7, 2), 
      '00', 'N', '01', 'Y', '11', 'G', 'N'),
     decode(substr(lpad(sum(decode(col#, null, power(10, privilege#*2) + 
       decode(option$, null, 0, power(10, privilege#*2 + 1)), 0)), 26, '0'), 
              13, 2), '01', 'A', '11', 'G', 
          decode(sum(decode(col#,
                            null, 0,
                            decode(privilege#, 6, 1, 0))), 0, 'N', 'S')),
    decode(substr(lpad(sum(power(10, privilege#*2) + 
      decode(option$, null, 0, power(10, privilege#*2 + 1))), 26, '0'), 19, 2), 
      '00', 'N', '01', 'Y', '11', 'G', 'N'),
    decode(substr(lpad(sum(decode(col#, null, power(10, privilege#*2) + 
      decode(option$, null, 0, power(10, privilege#*2 + 1)), 0)), 26, '0'), 
             5, 2),'01', 'A', '11', 'G', 
          decode(sum(decode(col#,
                            null, 0,
                            decode(privilege#, 10, 1, 0))), 0, 'N', 'S')),
    decode(substr(lpad(sum(decode(col#, null, power(10, privilege#*2) + 
      decode(option$, null, 0, power(10, privilege#*2 + 1)), 0)), 26, '0'), 
             3, 2), '01', 'A', '11', 'G', 
          decode(sum(decode(col#,
                            null, 0,
                            decode(privilege#, 11, 1, 0))), 0, 'N', 'S')),
   decode(substr(lpad(sum(power(10, privilege#*2) + 
      decode(option$, null, 0, power(10, privilege#*2 + 1))), 26, '0'), 25, 2), 
      '00', 'N', '01', 'Y', '11', 'G', 'N'), 
    decode(substr(lpad(sum(power(10, privilege#*2) + 
      decode(option$, null, 0, power(10, privilege#*2 + 1))), 26, '0'), 15, 2), 
      '00', 'N', '01', 'Y', '11', 'G', 'N'), min(null)
from sys.objauth$ oa, sys.obj$ o, sys.user$ ue, sys.user$ ur, sys.user$ u
where oa.obj# = o.obj#
  and oa.grantor# = ur.user#
  and oa.grantee# = ue.user#
  and u.user# = o.owner#
  and (oa.grantor# = userenv('SCHEMAID') or
       oa.grantee# in (select kzsrorol from x$kzsro) or
       o.owner# = userenv('SCHEMAID'))
  group by u.name, o.name, ur.name, ue.name
/
comment on table TABLE_PRIVILEGES is
'Grants on objects for which the user is the grantor, grantee, owner, 
 or an enabled role or PUBLIC is the grantee'
/
comment on column TABLE_PRIVILEGES.GRANTEE is
'Name of the user to whom access was granted'
/
comment on column TABLE_PRIVILEGES.OWNER is
'Owner of the object'
/
comment on column TABLE_PRIVILEGES.TABLE_NAME is
'Name of the object'
/
comment on column TABLE_PRIVILEGES.GRANTOR is
'Name of the user who performed the grant'
/
comment on column TABLE_PRIVILEGES.SELECT_PRIV is
'Permission to SELECT from the object?'
/
comment on column TABLE_PRIVILEGES.INSERT_PRIV is
'Permission to INSERT into the object?'
/
comment on column TABLE_PRIVILEGES.DELETE_PRIV is
'Permission to DELETE from the object?'
/
comment on column TABLE_PRIVILEGES.UPDATE_PRIV is
'Permission to UPDATE the object?'
/
comment on column TABLE_PRIVILEGES.REFERENCES_PRIV is
'Permission to make REFERENCES to the object?'
/
comment on column TABLE_PRIVILEGES.ALTER_PRIV is
'Permission to ALTER the object?'
/
comment on column TABLE_PRIVILEGES.INDEX_PRIV is
'Permission to create/drop an INDEX on the object?'
/
comment on column TABLE_PRIVILEGES.CREATED is
'Timestamp for the grant'
/
drop public synonym TABLE_PRIVILEGES
/
create public synonym TABLE_PRIVILEGES for TABLE_PRIVILEGES
/
grant select on TABLE_PRIVILEGES to PUBLIC
/
create or replace view COLUMN_PRIVILEGES
      (GRANTEE, OWNER, TABLE_NAME, COLUMN_NAME, GRANTOR,
       INSERT_PRIV, UPDATE_PRIV, REFERENCES_PRIV,
       CREATED)
as
select ue.name, u.name, o.name, c.name, ur.name,
    decode(substr(lpad(sum(power(10, privilege#*2) + 
      decode(option$, null, 0, power(10, privilege#*2 + 1))), 26, '0'), 13, 2), 
      '00', 'N', '01', 'Y', '11', 'G', 'N'),
    decode(substr(lpad(sum(power(10, privilege#*2) + 
      decode(option$, null, 0, power(10, privilege#*2 + 1))), 26, '0'), 5, 2), 
      '00', 'N', '01', 'Y', '11', 'G', 'N'),
    decode(substr(lpad(sum(power(10, privilege#*2) + 
      decode(option$, null, 0, power(10, privilege#*2 + 1))), 26, '0'), 3, 2), 
      '00', 'N', '01', 'Y', '11', 'G', 'N'), min(null)
from sys.objauth$ oa, sys.col$ c,sys.obj$ o, sys.user$ ue, sys.user$ ur, 
     sys.user$ u
where oa.col# is not null
  and oa.obj# = c.obj#
  and oa.col# = c.col#
  and bitand(c.property, 32) = 0 /* not hidden column */
  and oa.obj# = o.obj#
  and oa.grantor# = ur.user#
  and oa.grantee# = ue.user#
  and u.user# = o.owner#
  and (oa.grantor# = userenv('SCHEMAID') or
       oa.grantee# in (select kzsrorol from x$kzsro) or
       o.owner# = userenv('SCHEMAID'))
  group by u.name, o.name, c.name, ur.name, ue.name
/
comment on table COLUMN_PRIVILEGES is
'Grants on columns for which the user is the grantor, grantee, owner, or 
 an enabled role or PUBLIC is the grantee'
/
comment on column COLUMN_PRIVILEGES.GRANTEE is
'Name of the user to whom access was granted'
/
comment on column COLUMN_PRIVILEGES.OWNER is
'Username of the owner of the object'
/
comment on column COLUMN_PRIVILEGES.TABLE_NAME is
'Name of the object'               
/
comment on column COLUMN_PRIVILEGES.COLUMN_NAME is
'Name of the column'
/
comment on column COLUMN_PRIVILEGES.GRANTOR is
'Name of the user who performed the grant'
/
comment on column COLUMN_PRIVILEGES.INSERT_PRIV is
'Permission to INSERT into the column?'
/
comment on column COLUMN_PRIVILEGES.UPDATE_PRIV is
'Permission to UPDATE the column?'
/
comment on column COLUMN_PRIVILEGES.REFERENCES_PRIV is
'Permission to make REFERENCES to the column?'
/
comment on column COLUMN_PRIVILEGES.CREATED is
'Timestamp for the grant'
/
drop public synonym COLUMN_PRIVILEGES
/
create public synonym COLUMN_PRIVILEGES for COLUMN_PRIVILEGES
/
grant select on COLUMN_PRIVILEGES to PUBLIC
/

rem	**********************************************************************
rem		DBA TWO PHASE COMMIT DECISION / DAMAGE ASSESSMENT TABLES
rem	**********************************************************************
rem 	PSS1$: used to add user name column to pending_sub_sessions$
create or replace view pss1$ as
select	pss.*, u.name owner_name
from 	sys.pending_sub_sessions$ pss, sys.user$ u
where   pss.link_owner = u.user#;
grant select on pss1$ to select_catalog_role;

rem 	PS1$: used to add user name column to pending_sessions$
create or replace view ps1$ ( local_tran_id, session_id, branch_id,
	interface, type, parent_dbid, parent_db, db_userid, db_user) as
select	ps.*, u.name db_user
from 	sys.pending_sessions$ ps, sys.user$ u
where   ps.db_userid = u.user#;
grant select on ps1$ to select_catalog_role;

rem 	DBA_2PC_PENDING
rem	use this view to find info about pending (i.e. incomplete) distributed
rem	transactions at this DB.  Use os_user and db_userid to help track down
rem	a responsible party.  Use DBA_2PC_NEIGHBORS to find the commit point.
rem	Or take the advice, if offered.

create or replace view DBA_2PC_PENDING
    (local_tran_id, global_tran_id, state, mixed,
     advice, tran_comment, fail_time, force_time,
     retry_time, os_user, os_terminal, host, db_user, commit#) as
select  local_tran_id,
        nvl(global_oracle_id, global_tran_fmt||'.'||global_foreign_id),
	state, decode(status,'D','yes','no'), heuristic_dflt, tran_comment,
        fail_time, heuristic_time, reco_time,
        top_os_user, top_os_terminal, top_os_host, top_db_user, global_commit#
from	sys.pending_trans$;
drop public synonym DBA_2PC_PENDING;
create public synonym DBA_2PC_PENDING for DBA_2PC_PENDING;
grant select on DBA_2PC_PENDING to select_catalog_role;
comment on table DBA_2PC_PENDING is
  'info about distributed transactions awaiting recovery';
comment on column DBA_2PC_PENDING.local_tran_id is
  'string of form: n.n.n, n a number';
comment on column DBA_2PC_PENDING.global_tran_id is
  'globally unique transaction id';
comment on column DBA_2PC_PENDING.state is
  'collecting, prepared, committed, forced commit, or forced rollback';
comment on column DBA_2PC_PENDING.mixed is
  'yes => part of the transaction committed and part rolled back (commit or rollback with the FORCE option was used)';
comment on column DBA_2PC_PENDING.advice is
  'C for commit, R for rollback, else null';
comment on column DBA_2PC_PENDING.tran_comment is
  'text for "commit work comment <text>"';
comment on column DBA_2PC_PENDING.fail_time is
  'value of SYSDATE when the row was inserted (tx or system recovery)';
comment on column DBA_2PC_PENDING.force_time is
 'time of manual force decision (null if not forced locally)';
comment on column DBA_2PC_PENDING.retry_time is
 'time automatic recovery (RECO) last tried to recover the transaction';
comment on column DBA_2PC_PENDING.os_user is
  'operating system specific name for the end-user';
comment on column DBA_2PC_PENDING.os_terminal is
  'operating system specific name for the end-user terminal';
comment on column DBA_2PC_PENDING.host is
  'name of the host machine for the end-user';
comment on column DBA_2PC_PENDING.db_user is
  'Oracle user name of the end-user at the topmost database';
comment on column DBA_2PC_PENDING.commit# is
  'global commit number for committed transactions';

rem	DBA_2PC_NEIGHBORS: use this view to obtain info about incoming and
rem	  outgoing connections for a particular transaction.  It is suggested
rem 	  that it be queried using:
rem	    select * from dba_2pc_neighbors where local_tran_id = <id>
rem	     order by sess#, "IN_OUT";
rem	  This will group sessions, with outgoing connections following the
rem	  incoming connection for each session.
rem   columns:
rem	IN_OUT: 'in' for incoming connections, 'out' for outgoing
rem 	DATABASE: if 'in', the name of the client database, else name of 
rem	  outgoing db link
rem	DBUSER_OWNER: if 'in', name of local user, else owner of db link
rem	INTERFACE: 'C' hold commit, else 'N'.  For incoming links, 'C'
rem 	  means that we or a DB at the other end of one of our outgoing links
rem       is the commit point (and must not forget until told by the client).
rem	  For outgoing links, 'C' means that the child at the other end is the
rem	  commit point, and will know whether the tran should commit or abort.
rem	  If we are indoubt and do not find a 'C' on an outgoing link, then
rem	  the top level user/DB, or the client, should be able to locate the
rem	  commit point.
rem	DBID: the database id at the other end of the connection
rem	SESS#: session number at this database of the connection.  Sessions are
rem 	  numbered consecutively from 1; there is always at least 1 session, 
rem	  and exactly 1 incoming connection per session.
rem	BRANCH_ID: transaction branch.  An incoming branch is a two byte
rem	  hexadecimal number.  The first byte is the session_id of the
rem	  remote parent session.  The second byte is the branch_id of the
rem	  remote parent session.  If the remote parent session is not Oracle,
rem	  the branch_id can be up to 64 bytes.

create or replace view DBA_2PC_NEIGHBORS(local_tran_id, in_out, database,
                               dbuser_owner, interface, dbid, 
			       sess#, branch) as
select  local_tran_id, 'in', parent_db, db_user, interface, parent_dbid,
        session_id, rawtohex(branch_id)
from	sys.ps1$
union all
select  local_tran_id, 'out', dblink, owner_name, interface, dbid, 
        session_id, to_char(sub_session_id)
from	sys.pss1$;
drop public synonym DBA_2PC_NEIGHBORS;
create public synonym DBA_2PC_NEIGHBORS for DBA_2PC_NEIGHBORS;
grant select on DBA_2PC_NEIGHBORS to select_catalog_role;
comment on table DBA_2PC_NEIGHBORS is
  'information about incoming and outgoing connections for pending transactions';
comment on column DBA_2PC_NEIGHBORS.in_out is
  '"in" for incoming connections, "out" for outgoing';
comment on column DBA_2PC_NEIGHBORS.database is
  'in: client database name; out: outgoing db link';
comment on column DBA_2PC_NEIGHBORS.dbuser_owner is
  'in: name of local user; out: owner of db link';
comment on column DBA_2PC_NEIGHBORS.interface is
  '"C" for request commit, else "N" for prepare or request readonly commit';
comment on column DBA_2PC_NEIGHBORS.dbid is
  'the database id at the other end of the connection';
comment on column DBA_2PC_NEIGHBORS.sess# is
  'session number at this database of the connection';
comment on column DBA_2PC_NEIGHBORS.branch is
  'transaction branch ID at this database of the connection';
/

Rem	DBA_PENDING_TRANSACTIONS
Rem	This view gives information about unresolved transactions (either
Rem	due to failure or co-ordinator has not sent a commit/rollback).
Rem	The view selects information from the pending_trans$ dictionary table
Rem	and the in-memory tables in all instances provided by
Rem	gv$global_transactions. A join is required between pending_trans$
Rem	and pending_sessions$ because the branch_id is stored in 
Rem	pending_sessions$. Since Oracle's lock manager is session based we
Rem	will never have multiple sessions for a given transaction that are in
Rem	the prepared state (although this is possible when transaction is
Rem	in collecting state). Hence, the funny BITAND condition is probably
Rem	not required (tran.state != collecting ==> only one branch left ?)
Rem	Secondly, the view is not just a simple Union of the fixed view
Rem	and the dictionary tables information in order to eliminate the window
Rem	where SMON writes information into the dictionary table after we select
Rem	it from the in-memory table (not having the MINUS may result in
Rem	duplicates in this view).
Rem	DBAs are not required to select this view. Currently, only XA uses this
Rem	view

create or replace view DBA_PENDING_TRANSACTIONS(formatid, globalid, branchid)
as
(((select formatid, globalid, branchid
   from   gv$global_transaction
   where  refcount = preparecount)
 minus
  (select global_tran_fmt, global_foreign_id, branch_id
   from   sys.pending_trans$ tran, sys.pending_sessions$ sess
   where  tran.local_tran_id = sess.local_tran_id
     and  tran.state != 'collecting'
     and  BITAND(TO_NUMBER(tran.session_vector),
		 POWER(2, (sess.session_id - 1))) = sess.session_id)
 )
 union
  (select global_tran_fmt, global_foreign_id, branch_id
   from   sys.pending_trans$ tran, sys.pending_sessions$ sess
   where  tran.local_tran_id = sess.local_tran_id
     and  tran.state != 'collecting'
     and  BITAND(TO_NUMBER(tran.session_vector),
		 POWER(2, (sess.session_id - 1))) = sess.session_id)
);
drop public synonym DBA_PENDING_TRANSACTIONS;
create public synonym DBA_PENDING_TRANSACTIONS for DBA_PENDING_TRANSACTIONS;
grant select on DBA_PENDING_TRANSACTIONS to select_catalog_role;
comment on table DBA_PENDING_TRANSACTIONS is
  'information about unresolved global transactions';
comment on column DBA_PENDING_TRANSACTIONS.formatid is
  'format identifier of the transaction identifier';
comment on column DBA_PENDING_TRANSACTIONS.globalid is
  'global part (gtrid) of the transaction identifier';
comment on column DBA_PENDING_TRANSACTIONS.branchid is
  'branch qualifier (bqual) of the transaction identifier';


Rem	GLOBAL DATABASE NAME

create or replace view GLOBAL_NAME ( GLOBAL_NAME ) as
       select value$ from sys.props$ where name = 'GLOBAL_DB_NAME'
/
comment on table GLOBAL_NAME is 'global database name'
/
comment on column GLOBAL_NAME.GLOBAL_NAME is 'global database name'
/
grant select on GLOBAL_NAME to public with grant option
/
drop public synonym GLOBAL_NAME
/
create public synonym GLOBAL_NAME for GLOBAL_NAME
/

Rem     PRODUCT COMPONENT VERSION
create or replace view product_component_version(product,version,status) as
(select
substr(banner,1, instr(banner,'Version')-1),
substr(banner, instr(banner,'Version')+8,
instr(banner,' - ')-(instr(banner,'Version')+8)),
substr(banner,instr(banner,' - ')+3)
from v$version
where instr(banner,'Version') > 0
and
((instr(banner,'Version') <   instr(banner,'Release')) or
instr(banner,'Release') = 0))
union
(select
substr(banner,1, instr(banner,'Release')-1),
substr(banner, instr(banner,'Release')+8,
instr(banner,' - ')-(instr(banner,'Release')+8)),
substr(banner,instr(banner,' - ')+3)
from v$version
where instr(banner,'Release') > 0
and
instr(banner,'Release') <   instr(banner,' - '))
/
comment on table product_component_version is 
'version and status information for component products'
/
comment on column product_component_version.product is 
'product name';
/
comment on column product_component_version.version is 
'version number'
/
comment on column product_component_version.status is 
'status of release'
/
grant select on product_component_version to public with grant option
/
drop public synonym product_component_version
/
create public synonym product_component_version for product_component_version
/
remark
remark  FAMILY "UPDATABLE_COLUMNS"
remark
create or replace view USER_UPDATABLE_COLUMNS 
(OWNER, TABLE_NAME, COLUMN_NAME, UPDATABLE, INSERTABLE, DELETABLE)
as
select u.name, o.name, c.name,
       decode(bitand(c.fixedstorage,2),
              2, decode(bitand(v.flags,8192), 8192, 'YES', 'NO'),
              'YES'),
       decode(bitand(c.fixedstorage,2),
              2, decode(bitand(v.flags,4096), 4096, 'YES', 'NO'),
              'YES'),
       decode(bitand(c.fixedstorage,2),
              2, decode(bitand(v.flags,16384), 16384, 'YES', 'NO'),
              'YES')
from sys.obj$ o, sys.user$ u, sys.col$ c, sys.view$ v
where u.user# = o.owner#
  and c.obj#  = o.obj#
  and c.obj#  = v.obj#(+)
  and u.user# = userenv('SCHEMAID')
  and bitand(c.property, 32) = 0 /* not hidden column */
/
comment on table USER_UPDATABLE_COLUMNS is
'Description of updatable columns'
/
comment on column USER_UPDATABLE_COLUMNS.OWNER is
'Table owner'
/
comment on column USER_UPDATABLE_COLUMNS.TABLE_NAME is
'Table name'
/
comment on column USER_UPDATABLE_COLUMNS.COLUMN_NAME is
'Column name'
/
comment on column USER_UPDATABLE_COLUMNS.UPDATABLE is
'Is the column updatable?'
/
comment on column USER_UPDATABLE_COLUMNS.INSERTABLE is
'Is the column insertable?'
/
comment on column USER_UPDATABLE_COLUMNS.DELETABLE is
'Is the column deletable?'
/
drop public synonym USER_UPDATABLE_COLUMNS
/
create public synonym USER_UPDATABLE_COLUMNS for USER_UPDATABLE_COLUMNS
/
grant select on USER_UPDATABLE_COLUMNS to PUBLIC with grant option
/
create or replace view ALL_UPDATABLE_COLUMNS 
(OWNER, TABLE_NAME, COLUMN_NAME, UPDATABLE, INSERTABLE, DELETABLE)
as
select u.name, o.name, c.name,
       decode(bitand(c.fixedstorage,2),
              2, decode(bitand(v.flags,8192), 8192, 'YES', 'NO'),
              'YES'),
       decode(bitand(c.fixedstorage,2),
              2, decode(bitand(v.flags,4096), 4096, 'YES', 'NO'),
              'YES'),
       decode(bitand(c.fixedstorage,2),
              2, decode(bitand(v.flags,16384), 16384, 'YES', 'NO'),
              'YES')
from sys.obj$ o, sys.user$ u, sys.col$ c, sys.view$ v
where o.owner# = u.user#
  and o.obj#  = c.obj#
  and c.obj#  = v.obj#(+)
  and bitand(c.property, 32) = 0 /* not hidden column */
  and (o.owner# = userenv('SCHEMAID')
       or o.obj# in
            (select oa.obj#
             from sys.objauth$ oa
             where grantee# in ( select kzsrorol
                                 from x$kzsro
                               ) 
            )
       or /* user has system privileges */
         exists (select null from v$enabledprivs
                 where priv_number in (-45 /* LOCK ANY TABLE */,
                                       -47 /* SELECT ANY TABLE */,
                                       -48 /* INSERT ANY TABLE */,
                                       -49 /* UPDATE ANY TABLE */,
                                       -50 /* DELETE ANY TABLE */)
                 )
      )
/
comment on table ALL_UPDATABLE_COLUMNS is
'Description of all updatable columns'
/
comment on column ALL_UPDATABLE_COLUMNS.OWNER is
'Table owner'
/
comment on column ALL_UPDATABLE_COLUMNS.TABLE_NAME is
'Table name'
/
comment on column ALL_UPDATABLE_COLUMNS.COLUMN_NAME is
'Column name'
/
comment on column ALL_UPDATABLE_COLUMNS.UPDATABLE is
'Is the column updatable?'
/
comment on column ALL_UPDATABLE_COLUMNS.INSERTABLE is
'Is the column insertable?'
/
comment on column ALL_UPDATABLE_COLUMNS.DELETABLE is
'Is the column deletable?'
/
drop public synonym ALL_UPDATABLE_COLUMNS
/
create public synonym ALL_UPDATABLE_COLUMNS for ALL_UPDATABLE_COLUMNS
/
grant select on ALL_UPDATABLE_COLUMNS to PUBLIC with grant option
/
create or replace view DBA_UPDATABLE_COLUMNS 
(OWNER, TABLE_NAME, COLUMN_NAME, UPDATABLE, INSERTABLE, DELETABLE)
as
select u.name, o.name, c.name,
       decode(bitand(c.fixedstorage,2),
              2, decode(bitand(v.flags,8192), 8192, 'YES', 'NO'),
              'YES'),
       decode(bitand(c.fixedstorage,2),
              2, decode(bitand(v.flags,4096), 4096, 'YES', 'NO'),
              'YES'),
       decode(bitand(c.fixedstorage,2),
              2, decode(bitand(v.flags,16384), 16384, 'YES', 'NO'),
              'YES')
from sys.obj$ o, sys.user$ u, sys.col$ c, sys.view$ v
where u.user# = o.owner#
  and c.obj#  = o.obj#
  and c.obj#  = v.obj#(+)
  and bitand(c.property, 32) = 0 /* not hidden column */
/
comment on table DBA_UPDATABLE_COLUMNS is
'Description of dba updatable columns'
/
comment on column DBA_UPDATABLE_COLUMNS.OWNER is
'table owner'
/
comment on column DBA_UPDATABLE_COLUMNS.TABLE_NAME is
'table name'
/
comment on column DBA_UPDATABLE_COLUMNS.COLUMN_NAME is
'column name'
/
comment on column DBA_UPDATABLE_COLUMNS.UPDATABLE is
'Is the column updatable?'
/
comment on column DBA_UPDATABLE_COLUMNS.INSERTABLE is
'Is the column insertable?'
/
comment on column DBA_UPDATABLE_COLUMNS.DELETABLE is
'Is the column deletable?'
/
drop public synonym DBA_UPDATABLE_COLUMNS
/
create public synonym DBA_UPDATABLE_COLUMNS for DBA_UPDATABLE_COLUMNS
/
grant select on DBA_UPDATABLE_COLUMNS to select_catalog_role
/
remark
remark  FAMILY "LOBS"
remark
remark  Views for showing information about LOBs:
remark  USER_LOBS, ALL_LOBS, and DBA_LOBS
remark
create or replace view USER_LOBS
    (TABLE_NAME, COLUMN_NAME, SEGMENT_NAME, INDEX_NAME,
     CHUNK, PCTVERSION, CACHE, LOGGING, IN_ROW)
as
select o.name,
       decode(bitand(c.property, 1), 1, ac.name, c.name),
       lo.name, io.name,
       l.chunk * ts.blocksize, l.pctversion$,
       decode(l.flags, 0, 'YES', 'NO'),
       decode(bitand(l.flags, 2), 2, 'NO', 'YES'),
       decode(l.property, 0, 'NO', 'YES')
from sys.obj$ o, sys.col$ c, sys.attrcol$ ac,
     sys.lob$ l, sys.obj$ lo, sys.obj$ io, sys.ts$ ts
where o.owner# = userenv('SCHEMAID')
  and o.obj# = c.obj#
  and c.obj# = l.obj#
  and c.intcol# = l.intcol#
  and l.lobj# = lo.obj#
  and l.ind# = io.obj#
  and l.ts# = ts.ts#
  and c.obj# = ac.obj#(+)
  and c.intcol# = ac.intcol#(+)
/
comment on table USER_LOBS is
'Description of the user''s own LOBs contained in the user''s own tables'
/
comment on column USER_LOBS.TABLE_NAME is
'Name of the table containing the LOB'
/
comment on column USER_LOBS.COLUMN_NAME is
'Name of the LOB column or attribute'
/
comment on column USER_LOBS.SEGMENT_NAME is
'Name of the LOB segment'
/
comment on column USER_LOBS.INDEX_NAME is
'Name of the LOB index'
/
comment on column USER_LOBS.CHUNK is
'Size of the LOB chunk as a unit of allocation/manipulation in bytes'
/
comment on column USER_LOBS.PCTVERSION is
'Maximum percentage of the LOB space used for versioning'
/
comment on column USER_LOBS.CACHE is
'Is the LOB accessed through the buffer cache?'
/
comment on column USER_LOBS.LOGGING is
'Are changes to the LOB logged?'
/
comment on column USER_LOBS.IN_ROW is
'Are some of the LOBs stored with the base row?'
/
drop public synonym USER_LOBS
/
create public synonym USER_LOBS for USER_LOBS
/
grant select on USER_LOBS to PUBLIC with grant option
/
create or replace view ALL_LOBS
    (OWNER, TABLE_NAME, COLUMN_NAME, SEGMENT_NAME, INDEX_NAME,
     CHUNK, PCTVERSION, CACHE, LOGGING, IN_ROW)
as
select u.name, o.name,
       decode(bitand(c.property, 1), 1, ac.name, c.name), lo.name, io.name,
       l.chunk * ts.blocksize, l.pctversion$,
       decode(l.flags, 0, 'YES', 'NO'),
       decode(bitand(l.flags, 2), 2, 'NO', 'YES'),
       decode(l.property, 0, 'NO', 'YES')
from sys.obj$ o, sys.col$ c, sys.attrcol$ ac,
     sys.lob$ l, sys.obj$ lo, sys.obj$ io, sys.user$ u, sys.ts$ ts
where o.owner# = u.user#
  and o.obj# = c.obj#
  and c.obj# = l.obj#
  and c.intcol# = l.intcol#
  and l.lobj# = lo.obj#
  and l.ind# = io.obj#
  and l.ts# = ts.ts#
  and c.obj# = ac.obj#(+)
  and c.intcol# = ac.intcol#(+)
  and (o.owner# = userenv('SCHEMAID')
       or o.obj# in
            (select oa.obj#
             from sys.objauth$ oa
             where grantee# in ( select kzsrorol
                                 from x$kzsro
                               ) 
            )
       or exists (select null from v$enabledprivs
                  where priv_number in (-45 /* LOCK ANY TABLE */,
                                        -47 /* SELECT ANY TABLE */,
                                        -48 /* INSERT ANY TABLE */,
                                        -49 /* UPDATE ANY TABLE */,
                                        -50 /* DELETE ANY TABLE */)
                 )
      )
/
comment on table ALL_LOBS is
'Description of LOBs contained in tables accessible to the user'
/
comment on column ALL_LOBS.OWNER is
'Owner of the table containing the LOB'
/
comment on column ALL_LOBS.TABLE_NAME is
'Name of the table containing the LOB'
/
comment on column ALL_LOBS.COLUMN_NAME is
'Name of the LOB column or attribute'
/
comment on column ALL_LOBS.SEGMENT_NAME is
'Name of the LOB segment'
/
comment on column ALL_LOBS.INDEX_NAME is
'Name of the LOB index'
/
comment on column ALL_LOBS.CHUNK is
'Size of the LOB chunk as a unit of allocation/manipulation in bytes'
/
comment on column ALL_LOBS.PCTVERSION is
'Maximum percentage of the LOB space used for versioning'
/
comment on column ALL_LOBS.CACHE is
'Is the LOB accessed through the buffer cache?'
/
comment on column ALL_LOBS.LOGGING is
'Are changes to the LOB logged?'
/
comment on column ALL_LOBS.IN_ROW is
'Are some of the LOBs stored with the base row?'
/
drop public synonym ALL_LOBS
/
create public synonym ALL_LOBS for ALL_LOBS
/
grant select on ALL_LOBS to PUBLIC with grant option
/
create or replace view DBA_LOBS
    (OWNER, TABLE_NAME, COLUMN_NAME, SEGMENT_NAME, INDEX_NAME,
     CHUNK, PCTVERSION, CACHE, LOGGING, IN_ROW)
as
select u.name, o.name,
       decode(bitand(c.property, 1), 1, ac.name, c.name), lo.name, io.name,
       l.chunk * ts.blocksize, l.pctversion$,
       decode(l.flags, 0, 'YES', 'NO'),
       decode(bitand(l.flags, 2), 2, 'NO', 'YES'),
       decode(l.property, 0, 'NO', 'YES')
from sys.obj$ o, sys.col$ c, sys.attrcol$ ac,
     sys.lob$ l, sys.obj$ lo, sys.obj$ io, sys.user$ u, sys.ts$ ts
where o.owner# = u.user#
  and o.obj# = c.obj#
  and c.obj# = l.obj#
  and c.intcol# = l.intcol#
  and l.lobj# = lo.obj#
  and l.ind# = io.obj#
  and l.ts# = ts.ts#
  and c.obj# = ac.obj#(+)
  and c.intcol# = ac.intcol#(+)
/
comment on table DBA_LOBS is
'Description of LOBs contained in all tables'
/
comment on column DBA_LOBS.OWNER is
'Owner of the table containing the LOB'
/
comment on column DBA_LOBS.TABLE_NAME is
'Name of the table containing the LOB'
/
comment on column DBA_LOBS.COLUMN_NAME is
'Name of the LOB column or attribute'
/
comment on column DBA_LOBS.SEGMENT_NAME is
'Name of the LOB segment'
/
comment on column DBA_LOBS.INDEX_NAME is
'Name of the LOB index'
/
comment on column DBA_LOBS.CHUNK is
'Size of the LOB chunk as a unit of allocation/manipulation in bytes'
/
comment on column DBA_LOBS.PCTVERSION is
'Maximum percentage of the LOB space used for versioning'
/
comment on column DBA_LOBS.CACHE is
'Is the LOB accessed through the buffer cache?'
/
comment on column DBA_LOBS.LOGGING is
'Are changes to the LOB logged?'
/
comment on column DBA_LOBS.IN_ROW is
'Are some of the LOBs stored with the base row?'
/
drop public synonym DBA_LOBS
/
create public synonym DBA_LOBS for DBA_LOBS
/
grant select on DBA_LOBS to select_catalog_role
/
remark
remark  FAMILY "DIRECTORIES"
remark
remark  Views for showing information about directories:
remark  ALL_DIRECTORIES and DBA_DIRECTORIES
remark
create or replace view ALL_DIRECTORIES
       (OWNER, DIRECTORY_NAME, DIRECTORY_PATH)
as
select u.name, o.name, d.os_path
from sys.user$ u, sys.obj$ o, sys.dir$ d
where u.user# = o.owner#
  and o.obj# = d.obj# 
  and ( o.owner# =  userenv('SCHEMAID')
        or o.obj# in
           (select oa.obj#
            from sys.objauth$ oa 
            where grantee# in (select kzsrorol
                               from x$kzsro
                              )
           )
        or exists (select null from v$enabledprivs
                   where priv_number in (-177, /* CREATE ANY DIRECTORY */
                                         -178  /* DROP ANY DIRECTORY */)
                  )
      )
/
comment on table ALL_DIRECTORIES is
'Description of all directories accessible to the user'
/
comment on column ALL_DIRECTORIES.OWNER is
'Owner of the directory (always SYS)'
/
comment on column ALL_DIRECTORIES.DIRECTORY_NAME is
'Name of the directory'
/
comment on column ALL_DIRECTORIES.DIRECTORY_PATH is
'Operating system pathname for the directory'
/
drop public synonym ALL_DIRECTORIES
/
create public synonym ALL_DIRECTORIES for ALL_DIRECTORIES
/
grant select on ALL_DIRECTORIES to PUBLIC with grant option
/
create or replace view DBA_DIRECTORIES
       (OWNER, DIRECTORY_NAME, DIRECTORY_PATH)
as
select u.name, o.name, d.os_path
from sys.user$ u, sys.obj$ o, sys.dir$ d
where u.user# = o.owner#
  and o.obj# = d.obj#
/
comment on table DBA_DIRECTORIES is
'Description of all directories'
/
comment on column DBA_DIRECTORIES.OWNER is
'Owner of the directory (always SYS)'
/
comment on column DBA_DIRECTORIES.DIRECTORY_NAME is
'Name of the directory'
/
comment on column DBA_DIRECTORIES.DIRECTORY_PATH is
'Operating system pathname for the directory'
/
drop public synonym DBA_DIRECTORIES
/
create public synonym DBA_DIRECTORIES for DBA_DIRECTORIES
/
grant select on DBA_DIRECTORIES to select_catalog_role
/

remark
remark  FAMILY "LIBRARIES"
remark
remark  Views for showing information about PL/SQL Libraries:
remark  USER_LIBRARIES, ALL_LIBRARIES and DBA_LIBRARIES
remark
create or replace view USER_LIBRARIES 
(LIBRARY_NAME, FILE_SPEC, DYNAMIC, STATUS) 
as 
select o.name,  
       l.filespec,
       decode(bitand(l.property, 1), 0, 'Y', 1, 'N', NULL),
       decode(o.status, 0, 'N/A', 1, 'VALID', 'INVALID') 
from sys.obj$ o, sys.library$ l 
where o.owner# = userenv('SCHEMAID') 
  and o.obj# = l.obj# 
/
rem  and ((l.property is null) or (bitand(l.property, 2) = 0))  
comment on table USER_LIBRARIES is 
'Description of the user''s own libraries' 
/ 
comment on column USER_LIBRARIES.LIBRARY_NAME is 
'Name of the library' 
/ 
comment on column USER_LIBRARIES.FILE_SPEC is 
'Operating system file specification of the library' 
/ 
comment on column USER_LIBRARIES.DYNAMIC is 
'Is the library dynamically loadable'
/ 
comment on column USER_LIBRARIES.STATUS is 
'Status of the library' 
/ 
drop public synonym USER_LIBRARIES 
/ 
create public synonym USER_LIBRARIES for USER_LIBRARIES 
/ 
grant select on USER_LIBRARIES to PUBLIC with grant option 
/ 

create or replace view ALL_LIBRARIES 
(OWNER, LIBRARY_NAME, FILE_SPEC, DYNAMIC, STATUS) 
as 
select u.name, 
       o.name,  
       l.filespec,  
       decode(bitand(l.property, 1), 0, 'Y', 1, 'N', NULL),
       decode(o.status, 0, 'N/A', 1, 'VALID', 'INVALID') 
from sys.obj$ o, sys.library$ l, sys.user$ u 
where o.owner# = u.user# 
  and o.obj# = l.obj# 
  and (o.owner# in (userenv('SCHEMAID'), 1 /* PUBLIC */) 
       or o.obj# in 
          ( select oa.obj# 
            from sys.objauth$ oa 
            where grantee# in (select kzsrorol from x$kzsro) 
          ) 
       or ( 
            exists (select NULL from v$enabledprivs  
                    where priv_number in (  
                                      -189 /* CREATE ANY LIBRARY */, 
                                      -190 /* ALTER ANY LIBRARY */, 
                                      -191 /* DROP ANY LIBRARY */, 
                                      -192 /* EXECUTE ANY LIBRARY */ 
                                         ) 
                   ) 
          ) 
      ) 
/ 
comment on table ALL_LIBRARIES is 
'Description of libraries accessible to the user' 
/ 
comment on column ALL_LIBRARIES.OWNER is 
'Owner of the library' 
/ 
comment on column ALL_LIBRARIES.LIBRARY_NAME is 
'Name of the library' 
/ 
comment on column ALL_LIBRARIES.FILE_SPEC is 
'Operating system file specification of the library' 
/ 
comment on column ALL_LIBRARIES.DYNAMIC is 
'Is the library dynamically loadable'
/ 
comment on column ALL_LIBRARIES.STATUS is 
'Status of the library' 
/ 
drop public synonym ALL_LIBRARIES 
/ 
create public synonym ALL_LIBRARIES for ALL_LIBRARIES 
/ 
grant select on ALL_LIBRARIES to PUBLIC with grant option 
/ 

create or replace view DBA_LIBRARIES 
(OWNER, LIBRARY_NAME, FILE_SPEC, DYNAMIC, STATUS) 
as 
select u.name, 
       o.name,  
       l.filespec,  
       decode(bitand(l.property, 1), 0, 'Y', 1, 'N', NULL),
       decode(o.status, 0, 'N/A', 1, 'VALID', 'INVALID') 
from sys.obj$ o, sys.library$ l, sys.user$ u 
where o.owner# = u.user# 
  and o.obj# = l.obj# 
/ 
comment on table DBA_LIBRARIES is 
'Description of all libraries in the database' 
/ 
comment on column DBA_LIBRARIES.OWNER is 
'Owner of the library' 
/ 
comment on column DBA_LIBRARIES.LIBRARY_NAME is 
'Name of the library' 
/ 
comment on column DBA_LIBRARIES.FILE_SPEC is 
'Operating system file specification of the library' 
/ 
comment on column DBA_LIBRARIES.DYNAMIC is 
'Is the library dynamically loadable'
/ 
comment on column DBA_LIBRARIES.STATUS is 
'Status of the library' 
/ 
drop public synonym DBA_LIBRARIES 
/ 
create public synonym DBA_LIBRARIES for DBA_LIBRARIES 
/ 
grant select on DBA_LIBRARIES to select_catalog_role 
/ 

remark
remark  FAMILY "REFS"
remark
remark  Views for showing information about REFs:
remark  USER_REFS, ALL_REFS, and DBA_REFS
remark
create or replace view USER_REFS
    (TABLE_NAME, COLUMN_NAME, WITH_ROWID, IS_SCOPED, 
     SCOPE_TABLE_OWNER, SCOPE_TABLE_NAME)
as
select o.name,
       decode(bitand(c.property, 1), 1, ac.name, c.name),
       decode(bitand(rc.reftyp, 2), 2, 'YES', 'NO'),
       decode(bitand(rc.reftyp, 1), 1, 'YES', 'NO'),
       su.name, so.name
from sys.obj$ o, sys.col$ c, sys.refcon$ rc, sys.obj$ so, sys.user$ su,
     sys.attrcol$ ac
where o.owner# = userenv('SCHEMAID')
  and o.obj# = c.obj#
  and c.obj# = rc.obj#
  and c.col# = rc.col#
  and c.intcol# = rc.intcol#
  and rc.stabid = so.oid$(+)
  and so.owner# = su.user#(+)
  and c.obj# = ac.obj#(+)
  and c.intcol# = ac.intcol#(+)
/
comment on table USER_REFS is
'Description of the user''s own REF columns contained in the user''s own tables'
/
comment on column USER_REFS.TABLE_NAME is
'Name of the table containing the REF column'
/
comment on column USER_REFS.COLUMN_NAME is
'Column name or attribute of object column'
/
comment on column USER_REFS.WITH_ROWID is
'Is the REF value stored with the rowid?'
/
comment on column USER_REFS.IS_SCOPED is
'Is the REF column scoped?'
/
comment on column USER_REFS.SCOPE_TABLE_OWNER is
'Owner of the scope table, if it exists'
/
comment on column USER_REFS.SCOPE_TABLE_NAME is
'Name of the scope table, if it exists'
/
drop public synonym USER_REFS
/
create public synonym USER_REFS for USER_REFS
/
grant select on USER_REFS to PUBLIC with grant option
/
create or replace view ALL_REFS
    (OWNER, TABLE_NAME, COLUMN_NAME, WITH_ROWID, IS_SCOPED, 
     SCOPE_TABLE_OWNER, SCOPE_TABLE_NAME)
as
select u.name, o.name,
       decode(bitand(c.property, 1), 1, ac.name, c.name),
       decode(bitand(rc.reftyp, 2), 2, 'YES', 'NO'),
       decode(bitand(rc.reftyp, 1), 1, 'YES', 'NO'),
       su.name, so.name
from sys.user$ u, sys.obj$ o, sys.col$ c, sys.refcon$ rc, sys.obj$ so,
sys.user$ su, sys.attrcol$ ac
where o.owner# = u.user#
  and o.obj# = c.obj#
  and c.obj# = rc.obj#
  and c.col# = rc.col#
  and c.intcol# = rc.intcol#
  and rc.stabid = so.oid$(+)
  and so.owner# = su.user#(+)
  and c.obj# = ac.obj#(+)
  and c.intcol# = ac.intcol#(+)
  and (o.owner# = userenv('SCHEMAID')
       or o.obj# in
            (select oa.obj#
             from sys.objauth$ oa
             where grantee# in ( select kzsrorol
                                 from x$kzsro
                               ) 
            )
       or exists (select null from v$enabledprivs
                  where priv_number in (-45 /* LOCK ANY TABLE */,
                                        -47 /* SELECT ANY TABLE */,
                                        -48 /* INSERT ANY TABLE */,
                                        -49 /* UPDATE ANY TABLE */,
                                        -50 /* DELETE ANY TABLE */)
                 )
      )
/
comment on table ALL_REFS is
'Description of REF columns contained in tables accessible to the user'
/
comment on column ALL_REFS.OWNER is
'Owner of the table containing the REF column'
/
comment on column ALL_REFS.TABLE_NAME is
'Name of the table containing the REF column'
/
comment on column ALL_REFS.COLUMN_NAME is
'Column name or attribute of object column'
/
comment on column ALL_REFS.WITH_ROWID is
'Is the REF value stored with the rowid?'
/
comment on column ALL_REFS.IS_SCOPED is
'Is the REF column scoped?'
/
comment on column ALL_REFS.SCOPE_TABLE_OWNER is
'Owner of the scope table, if it exists'
/
comment on column ALL_REFS.SCOPE_TABLE_NAME is
'Name of the scope table, if it exists'
/
drop public synonym ALL_REFS
/
create public synonym ALL_REFS for ALL_REFS
/
grant select on ALL_REFS to PUBLIC with grant option
/
create or replace view DBA_REFS
    (OWNER, TABLE_NAME, COLUMN_NAME, WITH_ROWID, IS_SCOPED, 
     SCOPE_TABLE_OWNER, SCOPE_TABLE_NAME)
as
select u.name, o.name,
       decode(bitand(c.property, 1), 1, ac.name, c.name),
       decode(bitand(rc.reftyp, 2), 2, 'YES', 'NO'),
       decode(bitand(rc.reftyp, 1), 1, 'YES', 'NO'),
       su.name, so.name
from sys.obj$ o, sys.col$ c, sys.user$ u, sys.refcon$ rc, sys.obj$ so, 
sys.user$ su, sys.attrcol$ ac
where o.owner# = u.user#
  and o.obj# = c.obj#
  and c.obj# = rc.obj# 
  and c.col# = rc.col#
  and c.intcol# = rc.intcol#
  and rc.stabid = so.oid$(+)
  and so.owner# = su.user#(+)
  and c.obj# = ac.obj#(+)
  and c.intcol# = ac.intcol#(+)
/
comment on table DBA_REFS is
'Description of REF columns contained in all tables'
/
comment on column DBA_REFS.OWNER is
'Owner of the table containing the REF column'
/
comment on column DBA_REFS.TABLE_NAME is
'Name of the table containing the REF column'
/
comment on column DBA_REFS.COLUMN_NAME is
'Column name or attribute of object column'
/
comment on column DBA_REFS.WITH_ROWID is
'Is the REF value stored with the rowid?'
/
comment on column DBA_REFS.IS_SCOPED is
'Is the REF column scoped?'
/
comment on column DBA_REFS.SCOPE_TABLE_OWNER is
'Owner of the scope table, if it exists'
/
comment on column DBA_REFS.SCOPE_TABLE_NAME is
'Name of the scope table, if it exists'
/
drop public synonym DBA_REFS
/
create public synonym DBA_REFS for DBA_REFS
/
grant select on DBA_REFS to select_catalog_role
/
REM
REM  NESTED TABLES:
REM  Views for showing information about nested tables
REM
create or replace view USER_NESTED_TABLES
    (TABLE_NAME, TABLE_TYPE_OWNER, TABLE_TYPE_NAME,
     PARENT_TABLE_NAME, PARENT_TABLE_COLUMN)
as
select distinct o.name, ut.name, ot.name, op.name, ac.name
from sys.ntab$ n, sys.obj$ o, sys.obj$ op, sys.obj$ ot, 
  sys.col$ c, sys.coltype$ ct, sys.user$ u, sys.user$ ut, sys.attrcol$ ac
where o.owner# = userenv('SCHEMAID')
  and n.obj# = op.obj#
  and n.ntab# = o.obj#
  and c.obj# = op.obj#
  and n.intcol# = c.intcol#
  and c.obj# = ac.obj#
  and c.intcol# = ac.intcol#
  and op.obj# = ct.obj# 
  and ct.toid = ot.oid$
  and ct.intcol#=n.intcol#
  and ot.owner# = ut.user#
  and bitand(ct.flags,4)=4
union all
select o.name, ut.name, ot.name, op.name, c.name
from sys.ntab$ n, sys.obj$ o, sys.obj$ op, sys.obj$ ot, 
  sys.col$ c, sys.coltype$ ct, sys.user$ ut
where o.owner# = userenv('SCHEMAID')
  and  n.obj# = op.obj#
  and n.ntab# = o.obj#
  and c.obj# = op.obj#
  and n.intcol# = c.intcol#
  and bitand(c.property,1)=0
  and op.obj# = ct.obj# 
  and ct.toid = ot.oid$
  and ct.intcol#=n.intcol#
  and ot.owner# = ut.user#
  and bitand(ct.flags,4)=4
/
drop public synonym USER_NESTED_TABLES
/
create public synonym USER_NESTED_TABLES for USER_NESTED_TABLES
/
grant select on USER_NESTED_TABLES to PUBLIC with grant option
/
comment on table USER_NESTED_TABLES is
'Description of nested tables contained in the user''s own tables'
/
comment on column USER_NESTED_TABLES.TABLE_NAME is
'Name of the nested table'
/
comment on column USER_NESTED_TABLES.TABLE_TYPE_OWNER is
'Owner of the type of which the nested table was created'
/
comment on column USER_NESTED_TABLES.TABLE_TYPE_NAME is
'Name of the type of the nested table'
/
comment on column USER_NESTED_TABLES.PARENT_TABLE_NAME is
'Name of the parent table containing the nested table'
/
comment on column USER_NESTED_TABLES.PARENT_TABLE_COLUMN is
'Column name of the parent table that corresponds to the nested table'
/

create or replace view ALL_NESTED_TABLES
    (OWNER, TABLE_NAME, TABLE_TYPE_OWNER, TABLE_TYPE_NAME,
     PARENT_TABLE_NAME, PARENT_TABLE_COLUMN)
as 
select u.name, o.name, ut.name, ot.name, op.name, ac.name
from sys.ntab$ n, sys.obj$ o, sys.obj$ op, sys.obj$ ot, 
  sys.col$ c, sys.coltype$ ct, sys.user$ u, sys.user$ ut, sys.attrcol$ ac
where o.owner# = u.user#
  and n.obj# = op.obj#
  and n.ntab# = o.obj#
  and c.obj# = op.obj#
  and n.intcol# = c.intcol#
  and c.obj# = ac.obj#
  and c.intcol# = ac.intcol#
  and op.obj# = ct.obj# 
  and ct.toid = ot.oid$
  and ct.intcol#=n.intcol#
  and ot.owner# = ut.user#
  and bitand(ct.flags,4)=4
  and (op.owner# = userenv('SCHEMAID')
       or op.obj# in
            (select oa.obj#
             from sys.objauth$ oa
             where grantee# in ( select kzsrorol
                                 from x$kzsro
                               ) 
            )
       or /* user has system privileges */
	 exists (select null from v$enabledprivs
	         where priv_number in (-45 /* LOCK ANY TABLE */,
				       -47 /* SELECT ANY TABLE */,
				       -48 /* INSERT ANY TABLE */,
				       -49 /* UPDATE ANY TABLE */,
				       -50 /* DELETE ANY TABLE */)
                 )
      )
union all
select u.name, o.name, ut.name, ot.name, op.name, c.name
from sys.ntab$ n, sys.obj$ o, sys.obj$ op, sys.obj$ ot, 
  sys.col$ c, sys.coltype$ ct, sys.user$ u, sys.user$ ut
where o.owner# = u.user#
  and n.obj# = op.obj#
  and n.ntab# = o.obj#
  and c.obj# = op.obj#
  and n.intcol# = c.intcol#
  and bitand(c.property,1)=0
  and op.obj# = ct.obj# 
  and ct.toid = ot.oid$
  and ct.intcol#=n.intcol#
  and ot.owner# = ut.user#
  and bitand(ct.flags,4)=4
  and (op.owner# = userenv('SCHEMAID')
       or op.obj# in
            (select oa.obj#
             from sys.objauth$ oa
             where grantee# in ( select kzsrorol
                                 from x$kzsro
                               ) 
            )
       or /* user has system privileges */
	 exists (select null from v$enabledprivs
	         where priv_number in (-45 /* LOCK ANY TABLE */,
				       -47 /* SELECT ANY TABLE */,
				       -48 /* INSERT ANY TABLE */,
				       -49 /* UPDATE ANY TABLE */,
				       -50 /* DELETE ANY TABLE */)
                 )
      )
/
drop public synonym ALL_NESTED_TABLES
/
create public synonym ALL_NESTED_TABLES for ALL_NESTED_TABLES
/
grant select on ALL_NESTED_TABLES to PUBLIC with grant option
/
comment on table ALL_NESTED_TABLES is
'Description of nested tables in tables accessible to the user'
/
comment on column ALL_NESTED_TABLES.OWNER is
'Owner of the nested table'
/
comment on column ALL_NESTED_TABLES.TABLE_NAME is
'Name of the nested table'
/
comment on column ALL_NESTED_TABLES.TABLE_TYPE_OWNER is
'Owner of the type of which the nested table was created'
/
comment on column ALL_NESTED_TABLES.TABLE_TYPE_NAME is
'Name of the type of the nested table'
/
comment on column ALL_NESTED_TABLES.PARENT_TABLE_NAME is
'Name of the parent table containing the nested table'
/
comment on column ALL_NESTED_TABLES.PARENT_TABLE_COLUMN is
'Column name of the parent table that corresponds to the nested table'
/

create or replace view DBA_NESTED_TABLES
    (OWNER, TABLE_NAME, TABLE_TYPE_OWNER, TABLE_TYPE_NAME, 
     PARENT_TABLE_NAME, PARENT_TABLE_COLUMN)
as 
select u.name, o.name, ut.name, ot.name, op.name, ac.name
from sys.ntab$ n, sys.obj$ o, sys.obj$ op, sys.obj$ ot, 
  sys.col$ c, sys.coltype$ ct, sys.user$ u, sys.user$ ut, sys.attrcol$ ac
where o.owner# = u.user#
  and n.obj# = op.obj#
  and n.ntab# = o.obj#
  and c.obj# = op.obj#
  and n.intcol# = c.intcol#
  and c.obj# = ac.obj#
  and c.intcol# = ac.intcol#
  and op.obj# = ct.obj# 
  and ct.toid = ot.oid$
  and ct.intcol#=n.intcol#
  and ot.owner# = ut.user#
  and bitand(ct.flags,4)=4
union all
select u.name, o.name, ut.name, ot.name, op.name, c.name
from sys.ntab$ n, sys.obj$ o, sys.obj$ op, sys.obj$ ot, 
  sys.col$ c, sys.coltype$ ct, sys.user$ u, sys.user$ ut
where o.owner# = u.user#
  and n.obj# = op.obj#
  and n.ntab# = o.obj#
  and c.obj# = op.obj#
  and n.intcol# = c.intcol#
  and bitand(c.property,1)=0
  and op.obj# = ct.obj# 
  and ct.toid = ot.oid$
  and ct.intcol#=n.intcol#
  and ot.owner# = ut.user#
  and bitand(ct.flags,4)=4
/
drop public synonym DBA_NESTED_TABLES
/
create public synonym DBA_NESTED_TABLES for DBA_NESTED_TABLES
/
grant select on DBA_NESTED_TABLES to select_catalog_role
/
comment on table DBA_NESTED_TABLES is
'Description of nested tables contained in all tables'
/
comment on column DBA_NESTED_TABLES.OWNER is
'Owner of the nested table'
/
comment on column DBA_NESTED_TABLES.TABLE_NAME is 
'Name of the nested table'
/
comment on column DBA_NESTED_TABLES.TABLE_TYPE_OWNER is
'Owner of the type of which the nested table was created'
/
comment on column DBA_NESTED_TABLES.TABLE_TYPE_NAME is
'Name of the type of the nested table'
/
comment on column DBA_NESTED_TABLES.PARENT_TABLE_NAME is 
'Name of the parent table containing the nested table'
/
comment on column DBA_NESTED_TABLES.PARENT_TABLE_COLUMN is
'Column name of the parent table that corresponds to the nested table'
/
Rem
Rem Trusted Servers View
Rem
create or replace view TRUSTED_SERVERS(TRUST, NAME)
as
select a.trust, b.dbname from sys.trusted_list$ b,
(select decode (dbname, '+*','Untrusted', '-*', 'Trusted') trust
from sys.trusted_list$ where dbname like '%*') a
where b.dbname not like '%*'
union
select decode (dbname, '-*', 'Untrusted', '+*', 'Trusted') trust, 'All'
from sys.trusted_list$ 
where dbname like '%*' and
not exists(select c.trust, d.dbname from sys.trusted_list$ d,
(select decode (dbname, '+*','Untrusted', '-*', 'Trusted') trust
from sys.trusted_list$ where dbname like '%*') c
where d.dbname not like '%*')
/
drop public synonym TRUSTED_SERVERS
/
create public synonym TRUSTED_SERVERS for TRUSTED_SERVERS
/
grant select on TRUSTED_SERVERS to select_catalog_role
/
comment on table TRUSTED_SERVERS is
'Trustedness of Servers'
/
comment on column TRUSTED_SERVERS.TRUST is
'Trustedness of the server listed. Unlisted servers have opposite trustedness.'
/
comment on column TRUSTED_SERVERS.NAME is
'Server name'
/

Rem Auditing views
@@cataudit

Rem Import/export views
@@catexp

Rem Loader views
@@catldr

Rem Server Manager views
@@catsvrmg

Rem Partitioning views
@@catpart

Rem Object views
@@catadt

Rem Recovery Catalog owner role
drop role recovery_catalog_owner;
create role recovery_catalog_owner;
grant create session,alter session,create synonym,create view,
  create database link,create table,create cluster,create sequence,
  create trigger,create procedure to recovery_catalog_owner;

Rem Now copy the grant permissions on the sys tables in to the objauth$ table
Rem Make sure that no duplicates are inserted -- e.g. tables which were not
Rem dropped during the mig process.
Rem Do not worry about the error message below if u are only doing an upgrade
Rem from 8.0.2. The stmt below is only for migration from Oracle7.

insert into sys.objauth$  
select o.obj#, u1.user#, u2.user#,
       priv.privilege#, priv.sequence#, priv.parent,priv.option$, priv.col#
from   grant_mig_priv$ priv, user$ u1, user$ u2, obj$ o , user$ u3
where  priv.name = o.name
and    priv.owner = u3.name 
and    o.type# <> 10                             /* ignore dropped objects */
and    o.type# <> 11                              /* ignore package bodies */
and    o.type# <> 14                                 /* ignore type bodies */
and    u3.user#   = o.owner#
and    priv.grantorname = u1.name
and    priv.granteename = u2.name
and  not exists ( select * from objauth$ auth where 
      auth.obj# = o.obj# and auth.grantee#  = u2.user# );

drop table grant_mig_priv$;
commit;

rem ====================
rem END of catlg803.sql
rem ====================


