
create or replace PACKAGE dbms_logmnr IS

-----------------------------------
-- SUBTYPES and related CONSTANTS
--
 
--
-- Constants for add_archivelog options flag

NEW 		  CONSTANT BINARY_INTEGER := 1;
REMOVEFILE	  CONSTANT BINARY_INTEGER := 2;
ADDFILE		  CONSTANT BINARY_INTEGER := 3;
USE_COLMAP        CONSTANT BINARY_INTEGER := 16;
SKIP_CORRUPTION   CONSTANT BINARY_INTEGER := 32;


SUBTYPE Length               IS BINARY_INTEGER;
SUBTYPE ThreadId            IS BINARY_INTEGER;

-- Workaround for the lack of constrained subtypes
LogFileNameTemplate         VARCHAR2(256);  
SUBTYPE LogFileName         IS LogFileNameTemplate%TYPE;
LogFileDescTemplate         VARCHAR2(256);  
SUBTYPE LogFileDescription  IS LogFileDescTemplate%TYPE;


-------------
-- EXCEPTIONS
--

-------------
-- PROCEDURES 
--
---------------------------------------------------------------------------
---------------------------------------------------------------------------
-- Initialize the log analyzer tool.
--
-- Supplies the log analyzer tool with the list of filenames and SCNs required to
-- initialize the tool.  Once this procedure completes, the server is ready to process
-- selects against the v$redo_log table.
--
---------------------------------------------------------------------------
PROCEDURE start_logmnr( 
     startScn           IN NUMBER default 0 ,
     endScn 		IN NUMBER default 0,
     startTime      	IN DATE default TO_DATE('01-jan-1988','DD-MON-YYYY'),
     endTime        	IN DATE default TO_DATE('01-jan-2988','DD-MON-YYYY'),
     DictFileName    	IN VARCHAR2 default '',
     Options		IN BINARY_INTEGER default 0 );

PROCEDURE add_logfile( 
     LogFileName    	IN VARCHAR2,
     Options		IN BINARY_INTEGER default ADDFILE );

PROCEDURE end_logmnr;

---------------------------------------------------------------------------

pragma TIMESTAMP('1998-05-05:11:25:00');

END;
/
grant execute on dbms_logmnr to execute_catalog_role;
