Rem
Rem $Header: dbmsplts.sql 06-dec-1999.16:40:07 yuli Exp $
Rem
Rem dbmsplts.sql
Rem
Rem  Copyright (c) Oracle Corporation 1998, 1999. All Rights Reserved.
Rem
Rem    NAME
Rem      dbmsplts.sql - Pluggable Tablespace Package Specification
Rem
Rem    DESCRIPTION
Rem      This package contains procedures and functions supporting
Rem      the Pluggable Tablespace feature.  They are mostly called
Rem      by import/export.
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    yuli        12/06/99 - bug 972035: add function kfp_getfh
Rem    jwlee       06/09/99 - bug 864670: check nchar set ID
Rem    jwlee       09/28/98 - check system and temporary tablespace
Rem    jwlee       06/25/98 - misc fixes
Rem    jwlee       06/16/98 - create temp table on the fly
Rem    jwlee       05/19/98 - add dbms_tts package
Rem    jwlee       05/03/98 - add place holder for char set name
Rem    jwlee       04/04/98 - add more exceptions
Rem    jwlee       04/02/98 - Complete coding for first phase
Rem    jwlee       03/30/98 - more
Rem    jwlee       03/30/98 - more on transportable tablespace
Rem    jwlee       03/26/98 - more
Rem    jwlee       03/19/98 - more on Pluggable Tablespace
Rem    jwlee       03/06/98 - Remove highSCN parameter from beginImport
Rem    jwlee       02/25/98 - Pluggable Tablespace Package Specification
Rem    jwlee       02/25/98 - Created
Rem

CREATE OR REPLACE 
PACKAGE dbms_plugts IS

  TS_EXP_BEGIN   CONSTANT binary_integer := 1;
  TS_EXP_END     CONSTANT binary_integer := 2;

  /**********************************************
  **   Routines called directly by EXPORT      **
  **********************************************/

  PROCEDURE beginExport;

  -- This procedure is called at the beginning of exprt. It constructs the
  -- beginImport call in the anonymous PL/SQL block.

  PROCEDURE beginExpTablespace (tsname IN varchar2);

  -- This procedure makes sure tablespaces are read-only during export.
  -- It is called for each tablespace.
  --
  -- Parameters
  --   tsname - (IN) tablespace name.
  --
  -- Possible Exceptions:
  --   ts_not_found
  --   ts_not_read_only


  PROCEDURE checkPluggable (incl_constraints 	IN number,
		 	    incl_triggers 	IN number,
			    incl_grants		IN number);

  -- Make sure objects are self-contained, etc.  If not, ORA-29341
  -- (exception not_self_contained) will be signaled.
  --
  -- Parameters:
  --   incl_constraints - (IN) 1 if include constraints, 0 otherwise.
  --   incl_triggers    - (IN) 1 if include triggers, 0 otherwise.
  --   incl_grants      - (IN) 1 if include grants, 0 otherwise.
  -- Returns:
  --   TRUE if the set of objects is self-contained.

  FUNCTION getLine RETURN varchar2;

  -- This function returns the next line of a block that has been
  -- previously selected for retrieval via selectBlock.
  -- 
  -- Returns:
  --   A string to be appended to the export file.


  PROCEDURE selectBlock (blockID IN binary_integer);

  -- This procedures selects a particular PL/SQL anonymous block for retrieval.
  --
  -- Parameters:
  --   blockID - (IN) the ID to pick a PL/SQL anonymous block
  --                  dbms_plugts.TS_EXP_BEGIN at the beginning of export
  --                  dbms_plugts.TS_EXP_END at the end of export


  /**********************************************
  **   Routines called directly by IMPORT      **
  **********************************************/

  PROCEDURE newDatafile (filename IN varchar2);

  -- The function informs the dbms_Plugts package about the location 
  -- of the new datafiles. This procedure is called directly by import.
  -- If the file can not be fount, an error will be signaled, possible 
  -- at a later point.
  --
  -- Parameters:
  --   filename - (IN) file name (including path)


  PROCEDURE newTablespace (tsname IN varchar2);

  -- Communicate new tablespace name from command line option TABLESPACES 
  -- to the PL/SQL package. This procedure is called directly by import.
  -- 
  -- Parameters:
  --   tsname - (IN) Tablespace name.


  PROCEDURE pluggableUser (usrname IN varchar2);

  -- Communication the list of users entered by the DBA via the USERS 
  -- command line option to the PL/SQL package. This function is called 
  -- directly by import.
  --
  -- Parameters:
  --   usrname - (IN) user name.


  PROCEDURE mapUser (from_user IN varchar2, to_user IN varchar2);

  -- Pass the information from FROM_USER and TO_USER to the PL/SQL 
  -- package. Called directly by import.
  --
  -- Parameters:
  --   from_user - (IN) a user in FROM_USER list.
  --   to_user   - (IN) the corresponding user in TO_USER list.



  /*******************************************************************
  **  Routines called automatically via the PL/SQL anonymous block  **
  *******************************************************************/


  PROCEDURE beginImpTablespace (tsname 		IN varchar2,
 	 	 	 	tsID 		IN number,
 	 	 	 	owner 		IN varchar2,
				n_files		IN binary_integer,
	 	 	 	contents 	IN binary_integer,
 	 	 	 	blkSize 	IN binary_integer,
	 	 	 	inc_num	 	IN binary_integer,
	 	 	 	clean_SCN 	IN number,
			 	dflminext	IN number,
			 	dflmaxext	IN number,
			 	dflinit 	IN number,
			 	dflincr	 	IN number,
			 	dflminlen 	IN number,
			 	dflextpct 	IN binary_integer,
			 	dflogging	IN binary_integer,
			 	affstrength 	IN number,
			 	bitmapped	IN number,
		 	 	dbID 	 	IN number,
			 	directallowed 	IN number,
			 	flags	 	IN binary_integer,
			 	creation_SCN 	IN number,
			 	groupname	IN varchar2,
	 	 	 	spare1	 	IN number,
	 	 	 	spare2	 	IN number,
	 	 	 	spare3	 	IN varchar2,
	 	 	 	spare4	 	IN date);

  -- Pass to dbms_plugts package the information needed to create the 
  -- tablespace in target database.  This procedure also checks to 
  -- make sure the tablespace name does not conflict with any existing 
  -- tablespaces already in the database. And the user name match with the
  -- USERS list in the import comamnd line. It also make sure the blcok size
  -- is the same as that in the target database. Begin importing meta data 
  -- for the tablespace. This procedure call appears in the export file.
  --
  -- The parameter list includes all columns for ts$, except those that 
  -- will for sure be discarded (online$, undofile#, undoblock#, 
  -- ownerinstance, backupowner).  The spares are included so that the 
  -- interface does not have to be changed even when we use these 
  -- spares in the future.
  --
  -- Parameters:
  -- 	tsname 		IN tablespace name
  --   	tsID 		IN tablespace ID in original database
  --    owner 		IN owner of tablespace
  --    n_files		IN number of datafiles in the tablespace
  --    contents 	IN contents column of ts$ (TEMPORARY/PERMANENT)
  --    blkSize 	IN size of block in bytes
  --    inc_num	 	IN incarnation number of extent
  --    clean_SCN 	IN tablespace clean SCN,
  --    dflminext	IN default minimum number of extents
  --    dflmaxext	IN default maximum number of extents
  --    dflinit 	IN default initial extent size
  -- 	dflincr	 	IN default initial extent size
  --    dflminlen 	IN default minimum extent size
  --    dflextpct 	IN default percent extent size increase
  --    dflogging	IN default logging attribute
  --    affstrength 	IN Affinity strength
  --    bitmapped	IN If bitmapped
  -- 	dbID 	 	IN database ID 
  --    directallowed 	IN allowed
  -- 	flags	 	IN flags
  --    creation_SCN 	IN tablespace creation SCN
  --  	groupname	IN Group name
  --    spare1	 	IN spare1 in ts$
  --	spare2	 	IN spare2 in ts$
  --	spare3	 	IN spare3 in ts$
  --	spare4	 	IN spare4 in ts$
  --


  PROCEDURE checkUser (username IN varchar2);

  -- Check the user name in the pluggable set matches that entered by 
  -- the DBA via the import USERS command line option. Make sure that, 
  -- after the user mappings, the required user is already in the database.
  -- This function call appears in the export file.
  --
  -- Parameters:
  --   username - (IN) user name.

  
  PROCEDURE beginImport (clone_oracle_version   IN varchar2,
		 	 charsetID	 	IN binary_integer,
			 ncharsetID		IN varchar2,
	 	 	 platformID	 	IN binary_integer,
	 	 	 platformName	 	IN varchar2,
	 	 	 highest_data_objnum 	IN number,
	 	 	 highest_lob_sequence 	IN number,
			 n_ts                   IN number);

  -- Pass information about the pluggable set to the PL/SQL package. 
  -- Among them is the release version of the Oracle executable that 
  -- created the pluggable set, which is used for checking compatibility. 
  -- This procedure call appears in the export file.
  -- 
  -- Parameters:
  --   clone_oracle_version IN the release version of the Oracle 
  --                           executable that created the pluggable set
  --   charsetID	    IN character set ID 
  --   ncharsetID 	    IN nchar set ID, in varchar2 format
  --                           (May be NULL if generated by 8.1.5)
  --   platformID	    IN platform ID
  --   platformName    	    IN platform name
  --   highest_data_objnum  IN highest data object # in pluggable set
  --   highest_lob_sequence IN highest LOB sequence # in pluggable set
  --   n_ts                 IN number of tablespace to be plugged in.


  PROCEDURE checkCompType (compID IN varchar2, compRL IN varchar2);

  -- Check and adjust version for each compatibility type. This procedure 
  -- appears in the export file.
  --
  -- Parameters:
  --   compID - (IN) compatibility type name
  --   compRL - (IN) release level


  PROCEDURE checkDatafile (name 	 IN varchar2,
	 	 	   databaseID 	 IN number,
	 	 	   absolute_fno  IN binary_integer,
	 	 	   curFileBlks 	 IN number,
	 	 	   tablespace_ID IN number,
	 	 	   relative_fno  IN binary_integer,
	 	 	   maxextend	 IN number,
	 	 	   inc	 	 IN number,
	 	 	   creation_SCN  IN number,
	 	 	   checkpoint_SCN  IN number,
	 	 	   reset_SCN	 IN number,
		 	   spare1 	 IN number,
	 	 	   spare2	 IN number,
	 	 	   spare3	 IN varchar2,
	 	 	   spare4	 IN date );

  -- Call statically linked C routines to associate datafile with 
  -- tablespace, validate file headers. This procedure appears in the 
  -- export file.  The parameter list includes all columns in file$, 
  -- except those that will for sure be discarded (status$, ownerinstance).
  -- 
  -- Parameters:
  --   name 	 	IN file name (excluding path)
  --   databaseID 	IN database ID
  --   absolute_fno  	IN absolute file number
  --   curFileBlks 	IN size of file in blocks
  --   tablespace_ID    IN tablespace ID in original database,
  --   relative_fno     IN relative file number,
  --   maxextend	IN maximum file size
  --   inc	 	IN increment amount
  --   creation_SCN     IN file creation SCN
  --   checkpoint_SCN   IN file checkpoint SCN
  --   reset_SCN 	IN file reset SCN
  --   spare1 	     	IN spare1 in file$
  --   spare2	  	IN spare2 in file$
  --   spare3	  	IN spare3 in file$
  --   spare4	 	IN spare4 in file$


  PROCEDURE endImpTablespace;

  -- Wrap up tablespace check. This procedure appears in the export file.


  PROCEDURE commitPluggable;

  -- Call statically linked C routine to atomically plug-in the pluggable
  -- set. This procedure appears in the export file.


  PROCEDURE endImport;

  -- Finish thing up after objects have been created. This procedure 
  -- appears in the export file.

  /*******************************************************************
  **               Possible Exceptions                              **
  *******************************************************************/

  ts_not_found  EXCEPTION;
  PRAGMA exception_init(ts_not_found, -29304);
  ts_not_found_num NUMBER := -29304;

  ts_not_read_only  EXCEPTION;
  PRAGMA exception_init(ts_not_read_only, -29335);
  ts_not_read_only_num NUMBER := -29335;

  internal_error    EXCEPTION;
  PRAGMA exception_init(internal_error, -29336);
  internal_error_num NUMBER := -29336;

  datafile_not_ready	EXCEPTION;
  PRAGMA exception_init(datafile_not_ready, -29338);
  datafile_not_ready_num    NUMBER := -29338;

  blocksize_mismatch	EXCEPTION;
  PRAGMA exception_init(blocksize_mismatch, -29339);
  blocksize_mismatch_num    NUMBER := -29339;

  exportfile_corrupted  EXCEPTION;
  PRAGMA exception_init(exportfile_corrupted, -29340);
  exportfile_corrupted_num  NUMBER := -29340;

  not_self_contained    EXCEPTION;
  PRAGMA exception_init(not_self_contained, -29341);
  not_self_contained_num    NUMBER := -29341;

  user_not_found        EXCEPTION;
  PRAGMA exception_init(user_not_found, -29342);
  user_not_found_num    NUMBER := -29342;

  mapped_user_not_found EXCEPTION;
  PRAGMA exception_init(mapped_user_not_found, -29343);
  mapped_user_not_found_num    NUMBER := -29343;

  user_not_in_list        EXCEPTION;
  PRAGMA exception_init(user_not_in_list, -29344);
  user_not_in_list_num    NUMBER := -29344;

  different_char_set      EXCEPTION;
  PRAGMA exception_init(different_char_set, -29345);
  different_char_set_num    NUMBER := -29345;

  ts_not_in_list          EXCEPTION;
  PRAGMA exception_init(ts_not_in_list, -29347);
  ts_not_in_list_num      NUMBER := -29347;

  datafiles_missing          EXCEPTION;
  PRAGMA exception_init(datafiles_missing, -29348);
  datafiles_missing_num      NUMBER := -29348;

  ts_name_conflict           EXCEPTION;
  PRAGMA exception_init(ts_name_conflict, -29349);
  ts_name_conflict_num       NUMBER := -29349;

  sys_or_tmp_ts		     EXCEPTION;
  PRAGMA exception_init(sys_or_tmp_ts, -29351);
  sys_or_tmp_ts_num          NUMBER := -29351;

  /******************************************************************
  **             Interface for testing, etc.                       **
  ******************************************************************/

  PROCEDURE init;


  /*******************************************************************
  **               Interface for trusted callouts                   **
  *******************************************************************/

  -- begin export
  PROCEDURE kfp_bexp(vsn 	OUT varchar2,          -- Oracle server version
	             dobj_half 	OUT binary_integer,        -- half of data obj#
		     dobj_odd 	OUT binary_integer); -- lowest bit of data obj#

  -- get char, nchar ID and name
  PROCEDURE kfp_getchar(cid     OUT binary_integer,                  -- char ID
		        ncid    OUT binary_integer);                -- nchar ID


  -- check if char, nchar set match (signal error is not)
  PROCEDURE kfp_chkchar(cid     IN binary_integer,                   -- char ID
	                ncid    IN binary_integer,                  -- nchar ID
	                chknc   IN binary_integer);     -- chech nchar (1 or 0)
		        

  -- allocate datafile and tablespace structures
  PROCEDURE kfp_aldfts(n_dfiles IN binary_integer,       -- number of datafiles
		       n_ts     IN binary_integer);    -- number of tablespaces

  -- read file header
  PROCEDURE kfp_rdfh(fname IN varchar2);    

  
  -- new tablespace
  --
  PROCEDURE kfp_newts(tsname	IN varchar2,                 -- tablespace name
		      tsid      IN binary_integer,                     -- ts ID
		      n_files   IN binary_integer,      -- # of datafiles in ts
		      blksz	IN binary_integer,                -- block size
		      inc_num   IN binary_integer,                     -- inc #
		      cleanSCN  IN number,                          -- cleanSCN
		      dflminext IN binary_integer,          -- dflminext in ts$
		      dflmaxext IN binary_integer,          -- dflmaxext in ts$
		      dflinit   IN binary_integer,            -- dflinit in ts$
		      dflincr   IN binary_integer,            -- dflincr in ts$
		      dflminlen IN binary_integer,          -- dflminlen in ts$
		      dflextpct IN binary_integer,          -- dflextpct in ts$
		      dflogging IN binary_integer,          -- dflogging in ts$
		      bitmapped IN binary_integer,          -- bitmapped in ts$
		      dbID      IN binary_integer,                     -- db ID
		      crtSCN    IN number,                      -- creation SCN
		      contents  IN binary_integer,          -- contents$ in ts$
	   	      flags     IN binary_integer);             -- flags in ts$


  -- Plug in datafile
  -- 
  PROCEDURE kfp_plgdf(dbID	IN binary_integer,               -- database ID
		      afn	IN binary_integer,           -- absolute file #
		      fileBlks 	IN binary_integer,    -- size of file in blocks
		      tsID	IN binary_integer,             -- tablespace ID
		      rfn	IN binary_integer,           -- relative file #
		      maxextend	IN binary_integer,
		      inc	IN binary_integer,
		      crtSCN	IN number,                      -- creation SCN
		      cptSCN	IN number,		      -- checkpoint SCN
		      rstSCN	IN number,		           -- reset SCN
		      spare1    IN binary_integer);          -- spare1 in file$


  -- Commit Pluggable
  --
  PROCEDURE kfp_cmt (data_objn  IN binary_integer);       -- data object number


  -- Initialize kernel data structures
  --
  PROCEDURE kfp_init;


  -- adjust compatibility level
  --
  PROCEDURE kfp_acomp (compID 	IN varchar2,	          -- compatibility type
		       compRL	IN varchar2);                  -- release level

  -- get file header infomation according to file number
  --
  PROCEDURE kfp_getfh (afn       IN  binary_integer,    -- absolute file number
                       dbID      OUT binary_integer,             -- database ID
                       ckpt_SCN  OUT varchar2,                -- checkpoint SCN
                       reset_SCN OUT varchar2);                -- reset log SCN

END dbms_plugts;
/
CREATE OR REPLACE PACKAGE dbms_tts IS

  -- Check if the transportable set is self-contained.  All violations are
  -- inserted into a temporary table that can be selected from view
  -- "transport_set_violations".
  --
  PROCEDURE transport_set_check (ts_list IN varchar2, 
				 incl_constraints IN boolean);

  -- Return TRUE if the transportable set is self-contained. FALSE otherwise.
  --
  FUNCTION isSelfContained (ts_list IN varchar2,
			    incl_constraints IN boolean) RETURN boolean;


  -- downgrade
  --
  PROCEDURE downgrade;

  /*******************************************************************
  **               Possible Exceptions                              **
  *******************************************************************/

  ts_not_found  EXCEPTION;
  PRAGMA exception_init(ts_not_found, -29304);
  ts_not_found_num NUMBER := -29304;

  invalid_ts_list  EXCEPTION;
  PRAGMA exception_init(invalid_ts_list, -29346);
  invalid_ts_list_num NUMBER := -29346;

  sys_or_tmp_ts		     EXCEPTION;
  PRAGMA exception_init(sys_or_tmp_ts, -29351);
  sys_or_tmp_ts_num          NUMBER := -29351;

  /*******************************************************************
  **               Trusted callouts                                 **
  *******************************************************************/

  -- check compatibility
  --
  PROCEDURE kfp_ckcmp;

END dbms_tts;
/
GRANT EXECUTE ON dbms_tts TO execute_catalog_role;
/
drop view sys.transport_set_violations;
/
truncate table sys.transts_error$;
/
drop table sys.transts_error$;
/


