Rem
Rem $Header: e0800030.sql 22-sep-99.10:36:19 rshaikh Exp $
Rem
Rem e0800030.sql
Rem
Rem  Copyright (c) Oracle Corporation 1999. All Rights Reserved.
Rem
Rem    NAME
Rem      e0800030.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      See the README file and the Oracle Migration book for details.
Rem
Rem      This script is to be used for downgrading your database from the
Rem      current release you have installed to the 8.0.3 release.  This
Rem      script provides a direct downgrade path from your current installed
Rem      release to the 8.0.3 release.
Rem
Rem      This script performs the downgrade in the following stages:
Rem        STAGE 1: downgrade from the current release to 8.0.4;
Rem                 call e0800040.sql to do this.
Rem        STAGE 2: downgrade from 8.0.4 to 8.0.3
Rem
Rem    NOTES
Rem      * This script needs to be run in the current release's environment
Rem        (before installing the release to which you want to downgrade).
Rem
Rem      * You must be connect as INTERNAL to run this script.
Rem
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rshaikh     09/22/99 - Created
Rem    ncramesh    08/04/98 - change for sqlplus
Rem    usundara    06/03/98 - rework upgrade/downgrade/migration scripts:
Rem                           * merge from 8.0.5:
Rem                             - change name cat8004d.sql->d08000030.sql
Rem                             - call d0800040
Rem    wuling      11/17/97 - drop dbms_pitr and dbms_pickler packages
Rem    ato         11/15/97 - drop rowcache_parent rowcache_subordinate
Rem    wuling      11/14/97 - drop v$ and gv$recovery_progress
Rem    ato         11/14/97 - add drop public synonyms
Rem    skaluska    11/14/97 - Take care of x$,v$ views
Rem    tlahiri     11/14/97 - drop (gv|v)$(current|recent)_bucket
Rem    mcoyle      11/14/97 - Add V$lock_activity and gv$lock_activity
Rem    ato         11/13/97 - 804->803 downgrade
Rem    ato         11/13/97 - Created
Rem


Rem =========================================================================
Rem BEGIN STAGE 1: downgrade from the current release to 8.0.4
Rem =========================================================================

@@e0800040.sql

Rem =========================================================================
Rem END STAGE 1: downgrade from the current release to 8.0.4
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 2: downgrade from 8.0.4 to 8.0.3
Rem =========================================================================

Rem =========================================================================
Rem AQ related downgrade begins here
Rem =========================================================================

DELETE FROM noexp$ WHERE name = 'AQ$_SCHEDULES'
/
commit
/
DROP table system.aq$_schedules
/
DROP table sys.aq$_message_types
/
DROP view DBA_QUEUE_SCHEDULES
/
DROP table sys.aq$_queue_statistics
/
DROP view v_$aq1
/
DROP public synonym v$aq1
/
DROP view gv_$aq1
/
DROP public synonym gv$aq1 
/
DROP view v_$aq
/
DROP public synonym v$aq
/
DROP view gv_$aq
/
DROP public synonym gv$aq
/

Rem =========================================================================
Rem End AQ related downgrade
Rem =========================================================================


Rem =========================================================================
Rem Lock related v,gv$ view downgrade begins here
Rem =========================================================================

DROP view gv_$lock_activity
/
DROP public synonym gv$lock_activity
/

Rem v$lock_activity will be redefined in catparr.sql in 8.0.3

DROP view v_$lock_activity
/
DROP public synonym v$lock_activity
/
DROP view gv_$dlm_locks
/
DROP public synonym gv$dlm_locks
/
DROP view v_$dlm_locks
/
DROP public synonym v$dlm_locks
/

Rem =========================================================================
Rem End lock related downgrade
Rem =========================================================================


Rem =========================================================================
Rem Buffer cache related view downgrade begins here
Rem =========================================================================
DROP view gv_$current_bucket
/
DROP public synonym gv$current_bucket
/
DROP view v_$current_bucket
/
DROP public synonym v$current_bucket
/
DROP view gv_$recent_bucket
/
DROP public synonym gv$recent_bucket
/
DROP view v_$recent_bucket
/
DROP public synonym v$recent_bucket
/
Rem =========================================================================
Rem End buffer cache related downgrade
Rem =========================================================================


Rem =========================================================================
Rem Row cache related view downgrade begins here
Rem =========================================================================
DROP view gv_$rowcache_parent
/
DROP public synonym gv$rowcache_parent
/
DROP view v_$rowcache_parent
/
DROP public synonym v$rowcache_parent
/
DROP view gv_$rowcache_subordinate
/
DROP public synonym gv$rowcache_subordinate
/
DROP view v_$rowcache_subordinate
/
DROP public synonym v$rowcache_subordinate
/
Rem =========================================================================
Rem End row cache related downgrade
Rem =========================================================================


Rem =========================================================================
Rem recovery related view downgrade begins here
Rem =========================================================================
DROP view gv_$recovery_progress
/
DROP public synonym gv$recovery_progress
/
DROP view v_$recovery_progress
/
DROP public synonym v$recovery_progress
/
Rem =========================================================================
Rem End recovery related view downgrade
Rem =========================================================================


Rem =========================================================================
Rem drop 804 packages which need to reload again after downgrade
Rem =========================================================================

DROP package dbms_pitr
/
DROP package dbms_pickler
/

Rem =========================================================================
Rem END STAGE 2: downgrade from 8.0.4 to 8.0.3
Rem =========================================================================

SET ECHO ON
/
Rem WARNING!!! WARNING!!! WARNING!!!
Rem Do NOT run CATALOG.SQL under 8.0.3 Release
Rem Please follow the downgrading directions in README file
SET ECHO OFF
/

Rem *************************************************************************
Rem END e0800030.sql
Rem *************************************************************************



