-- Remove some portion of the Java related data dictionary objects

-- This script must be run as a subscript of a script which sets the
-- variable jvmrmaction.
-- Possible values are
--  FULL_REMOVAL:        remove all java related objects
--  DOWNGRADE_8.1.7_TO_8.1.6: remove or massage system objects as appropriate
--                       when downgrading from 8.1.7 to 8.1.6
--  DOWNGRADE_8.1.6_TO_8.1.5: remove or massage system objects as appropriate
--                       when downgrading from 8.1.6 to 8.1.5 (after having
--                       earlier downgraded from 8.1.7 to 8.1.6)
--  GRADE_REMOVAL:       remove java related objects as appropriate during
--                       upgrade or downgrade
--  NONE:                do nothing

print jvmrmaction

begin if :jvmrmaction = 'FULL_REMOVAL' then
--
initjvmaux.drp('drop role javauserpriv');
initjvmaux.drp('drop role javaidpriv');
initjvmaux.drp('drop role javasyspriv');
initjvmaux.drp('drop role javadebugpriv');

--
initjvmaux.drp('drop view javasnm');
initjvmaux.drp('drop public synonym javasnm');

--
initjvmaux.drp('drop table aurora$startup$classes$');
initjvmaux.drp('drop table aurora$shutdown$classes$');

end if;end;
/

begin if :jvmrmaction = 'DOWNGRADE_8.1.6_TO_8.1.5' then

--- Strip 8.1.6 bytecode optimizations
rmjvm.strip();

end if;end;
/

begin if :jvmrmaction = 'FULL_REMOVAL' or :jvmrmaction = 'DOWNGRADE_8.1.7_TO_8.1.6' then

--- remove DynamicRegistration
initjvmaux.drp('delete from aurora$startup$classes$ where classname = ''oracle.aurora.net.DynamicRegistration''');
initjvmaux.drp('delete from aurora$shutdown where classname = ''oracle.aurora.net.DynamicRegistration''');
initjvmaux.drp('drop table AURORA$DYN$REG');
if :jvmrmaction = 'DOWNGRADE_8.1.7_TO_8.1.6' then
  dbms_java.aurora_shutdown();
end if;
initjvmaux.drp('drop table AURORA$CURRENT$DYN$REG');

end if;end;
/

begin if :jvmrmaction = 'FULL_REMOVAL' or :jvmrmaction = 'GRADE_REMOVAL' then

--
initjvmaux.drp('drop package get_error$');
initjvmaux.drp('drop public synonym get_error$');

--
initjvmaux.drp('drop trigger AURORA$SERVER$SHUTDOWN');
initjvmaux.drp('drop trigger AURORA$SERVER$STARTUP');

-- initsql
initjvmaux.drp('drop package sqljutl');

end if;end;
/

@@jvmrmdbj
@@jvmrmsec
@@jvmrm_xa


-- The following statements will generate errors if java has never been
-- installed.  Such errors are harmless and can be ignored.
-- Otherwise, they will take some time (tens of minutes) to run.

begin if :jvmrmaction = 'FULL_REMOVAL' then
  rmjvm.run(true);
end if;end;
/

begin if :jvmrmaction = 'GRADE_REMOVAL' then
  rmjvm.run(false);
end if;end;
/

