CREATE OR REPLACE VIEW DBA_CACHEABLE_TABLES_BASE
(OWNER, TABLE_NAME, TEMPORARY)
AS SELECT u.name, o.name, decode(bitand(o.flags, 2), 0, 'N', 2, 'Y', 'N')
   FROM   sys.user$ u, 
          sys.obj$ o, 
          (SELECT t.obj# 
           FROM   sys.tab$ t
           WHERE  /* Exclude the following tables
                   * 0x00000001    typed tables
                   * 0x00000002    having ADT cols
                   * 0x00000004    having nested table columns
                   * 0x00000008    having REF cols
                   * 0x00000010    having array cols
                   * 0x00002000    nested table
                   * 0x00008000    FILE columns
                   * 0x00020000    AQ table
                   * 0x01000000    user-defined REF columns
                   * 0x08000000    sub-object
                   */
                  bitand(t.property,151167007) = 0 
             AND  
                  /* Exclude tables with LONG columns */
                  NOT EXISTS (SELECT 1 FROM   sys.col$ c
                              WHERE  t.obj# = c.obj#
                              AND  c.type# IN (8, 24) /* DTYLNG,DTYLBI */)) tab
   WHERE  o.owner# = u.user#
     AND  o.obj#   = tab.obj#
     AND  
          /* Exclude SYS,SYSTEM,ORDSYS,CTXSYS,MDSYS,ORDPLUGINS,OUTLN tables */
          u.name NOT IN ('SYS', 'SYSTEM', 'ORDSYS', 'CTXSYS', 'MDSYS', 
                         'ORDPLUGINS', 'OUTLN')
     AND 
          /* Exclude snapshot and updatable snapshot log container tables */
          NOT EXISTS (SELECT 1 FROM sys.snap$ s
                      WHERE  s.sowner = u.name
                        AND ((s.tname = o.name) OR (s.uslog = o.name)))
     AND 
          /* Exclude snapshot log container tables */
          NOT EXISTS (SELECT 1 from sys.mlog$ m
                      WHERE  m.mowner = u.name
                        AND  m.log    = o.name)
/
CREATE OR REPLACE VIEW DBA_CACHEABLE_TABLES
(OWNER, TABLE_NAME)
AS SELECT t.owner, t.table_name 
   FROM   dba_cacheable_tables_base t
   WHERE  temporary = 'N'
/
drop public synonym DBA_CACHEABLE_TABLES
/
create public synonym DBA_CACHEABLE_TABLES for DBA_CACHEABLE_TABLES
/
grant select on DBA_CACHEABLE_TABLES to select_catalog_role
/
CREATE OR REPLACE VIEW  DBA_CACHEABLE_OBJECTS
(OWNER, OBJECT_NAME, OBJECT_TYPE)
AS
SELECT u.username owner, u.username object_name, 'USER'
FROM   dba_users u
WHERE  u.username NOT IN ('SYS', 'SYSTEM', 'OUTLN', 'ORDSYS', 'CTXSYS', 
                          'MDSYS', 'ORDPLUGINS', 'PUBLIC')
UNION ALL
SELECT o.owner, o.object_name, o.object_type
FROM   dba_objects o
WHERE  owner NOT IN ('SYS', 'SYSTEM', 'OUTLN', 'ORDSYS', 'CTXSYS', 
                     'MDSYS', 'ORDPLUGINS', 'PUBLIC')
AND    ((object_type IN ('VIEW', 'PROCEDURE', 'FUNCTION', 
                         'PACKAGE', 'SEQUENCE')
            AND NOT EXISTS (SELECT 1 FROM dba_repgenerated r
                            WHERE r.sname = o.owner
                            AND   r.oname = o.object_name
                            AND   r.type  = o.object_type))
        OR
        (object_type = 'VIEW'
            AND NOT EXISTS (SELECT 1 FROM dba_snapshots s
                            WHERE  s.owner = o.owner
                            AND    s.name  = o.object_name)))
UNION ALL
SELECT t.owner, t.table_name object_name, 
       decode(t.temporary, 'Y', 'TEMP TABLE', 'TABLE')
FROM   dba_cacheable_tables_base t
/
drop public synonym DBA_CACHEABLE_OBJECTS
/
create public synonym DBA_CACHEABLE_OBJECTS for DBA_CACHEABLE_OBJECTS
/
grant select on DBA_CACHEABLE_OBJECTS to select_catalog_role
/
CREATE OR REPLACE PACKAGE dbms_ias_inst wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
9
8106000
1
4
0 
11
2 :e:
1PACKAGE:
1DBMS_IAS_INST:
1START_IAS_INST:
1IASNAME:
1VARCHAR2:
1AUTHUSER:
1AUTHPW:
1CONNSTR:
1FINISH_IAS_INST:
1REMOVE_IAS_SUPPORT:
1REGISTER_IAS_SITE:
1SITENAME:
1UNREGISTER_IAS_SITE:
1FUNCTION:
1INSTANTIATION_IN_PROGRESS:
1RETURN:
1BOOLEAN:
0

0
0
52
2
0 a0 1d 97 9a 8f a0 b0
3d 8f a0 b0 3d 8f a0 b0
3d 8f a0 b0 3d b4 55 6a
9a 8f a0 b0 3d b4 55 6a
9a 8f a0 b0 3d b4 55 6a
9a 8f a0 b0 3d 8f a0 b0
3d b4 55 6a 9a 8f a0 b0
3d 8f a0 4d b0 3d b4 55
6a a0 8d 8f a0 b0 3d b4
:2 a0 2c 6a :2 aa 59 58 17 b5 
52
2
0 3 7 8 12 2b 27 26
33 40 3c 23 48 51 4d 3b
59 66 62 38 6e 61 73 77
7b 94 90 5e 9c 8f a1 a5
a9 c2 be 8c ca bd cf d3
d7 f0 ec ba f8 101 fd eb
109 e8 10e 112 116 12f 12b 12a
137 144 140 127 13f 14c 13c 151
155 159 15d 176 172 171 17e 16e
183 187 18b 18f 193 195 197 19a
19d 1a6 
52
2
0 :2 1 9 d 1c 28 :3 1c 28
:3 1c 28 :3 1c 28 :2 1c 1b :2 3 d
1d 28 :2 1d 1c :2 3 d 20 2b
:2 20 1f :2 3 d 1f 2c :3 1f 2c
:2 1f 1e :2 3 d 21 2e :3 21 2e
3f :2 21 20 :3 3 c 27 32 :2 27
26 3c 43 :2 3 :6 1 
52
2
0 :3 1 :5 23 :4 24 :4 25 :4 26 :3 23 :8 32
:8 3c :5 47 :4 48 :3 47 :5 55 :5 56 :3 55 :b 64
:6 1 
1a8
4
:3 0 1 :4 0 2
:6 0 1 :2 0 3
:a 0 17 2 :4 0
5 38 0 3
5 :3 0 4 :7 0
7 6 :3 0 9
5e 0 7 5
:3 0 6 :7 0 b
a :3 0 5 :3 0
7 :7 0 f e
:3 0 10 8c 0
b 5 :3 0 8
:7 0 13 12 :3 0
15 :2 0 17 4
16 0 4c 9
:a 0 1f 3 :4 0
14 ba 0 12
5 :3 0 4 :7 0
1b 1a :3 0 1d
:2 0 1f 18 1e
0 4c a :a 0
27 4 :4 0 18
e8 0 16 5
:3 0 4 :7 0 23
22 :3 0 25 :2 0
27 20 26 0
4c b :a 0 33
5 :4 0 1c :2 0
1a 5 :3 0 c
:7 0 2b 2a :3 0
5 :3 0 4 :7 0
2f 2e :3 0 31
:2 0 33 28 32
0 4c d :a 0
40 6 :7 0 1f
5 :3 0 c :7 0
37 36 :3 0 23
:2 0 21 5 :3 0
4 :7 0 3c 3a
3b :2 0 3e :2 0
40 34 3f 0
4c e :3 0 f
:a 0 4b 7 :4 0
28 :2 0 26 5
:3 0 4 :7 0 45
44 :3 0 10 :3 0
11 :3 0 47 49
0 4b 42 4a
0 4c 2a 4e
0 4e 4c 4d
4f 3 4e 50
2 4f 51 :8 0

31
4
:3 0 1 5 1
9 1 d 1
11 4 8 c
10 14 1 19
1 1c 1 21
1 24 1 29
1 2d 2 2c
30 1 35 1
39 2 38 3d
1 43 1 46
6 17 1f 27
33 40 4b 
1
4
0 
50
0
1
14
7
12
0 1 1 1 1 1 1 0
0 0 0 0 0 0 0 0
0 0 0 0 
20 1 4
34 1 6
9 2 0
4 1 2
d 2 0
28 1 5
11 2 0
3 0 1
43 7 0
39 6 0
2d 5 0
21 4 0
19 3 0
5 2 0
42 1 7
18 1 3
35 6 0
29 5 0
0

/
GRANT EXECUTE ON dbms_ias_inst TO execute_catalog_role
/
DROP PUBLIC SYNONYM dbms_ias_inst
/
CREATE PUBLIC SYNONYM dbms_ias_inst FOR dbms_ias_inst
/
CREATE OR REPLACE PACKAGE dbms_ias_mt_inst wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
9
8106000
1
4
0 
c
2 :e:
1PACKAGE:
1DBMS_IAS_MT_INST:
1CLEAN_IAS_SITE:
1ALTER_SYNC_INTERVAL:
1NEXTDATE:
1VARCHAR2:
1INTERVAL:
1REFGROUP:
1REGISTER_IAS_SITE:
1IASNAME:
1UNREGISTER_IAS_SITE:
1ENABLE_DEFERRED_CONS:
0

0
0
2f
2
0 a0 1d 97 9a b4 55 6a
9a 8f a0 b0 3d 8f a0 b0
3d 8f a0 4d b0 3d b4 55
6a 9a 8f a0 b0 3d b4 55
6a 9a b4 55 6a 9a b4 55
6a :2 aa 59 58 17 b5 
2f
2
0 3 7 8 12 23 24 28
2c 45 41 40 4d 5a 56 3d
62 6c 67 6b 55 74 52 79
7d 81 9a 96 95 a2 92 a7
ab af c0 c1 c5 c9 da db
df e3 e5 e7 ea ed f6 
2f
2
0 :2 1 9 d 0 :2 3 d 21
2d :3 21 2d :3 21 2d 39 :2 21 20
:2 3 d 1f 2a :2 1f 1e :2 3 d
0 :2 3 d 0 :2 3 :6 1 
2f
2
0 :3 1 1b 0 :2 1b :5 27 :4 28 :5 29
:3 27 :8 34 3d 0 :2 3d 43 0 :2 43
:6 1 
f8
4
:3 0 1 :4 0 2
:6 0 1 :2 0 3
:a 0 7 2 :5 0
5 :2 0 7 4
6 0 29 4
:a 0 18 3 :4 0
5 52 0 3
6 :3 0 5 :7 0
b a :3 0 9
:2 0 7 6 :3 0
7 :7 0 f e
:3 0 6 :4 0 8
:7 0 14 12 13
:2 0 16 :2 0 18
8 17 0 29
9 :a 0 20 4
:4 0 f :2 0 d
6 :3 0 a :7 0
1c 1b :3 0 1e
:2 0 20 19 1f
0 29 b :a 0
24 5 :5 0 22
:2 0 24 21 23
0 29 c :a 0
28 6 :5 0 26
:2 0 28 25 27
0 29 11 2b
0 2b 29 2a
2c 3 2b 2d
2 2c 2e :8 0

17
4
:3 0 1 9 1
d 1 11 3
c 10 15 1
1a 1 1d 5
7 18 20 24
28 
1
4
0 
2d
0
1
14
6
a
0 1 1 1 1 1 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
9 3 0
3 0 1
25 1 6
11 3 0
21 1 5
d 3 0
8 1 3
19 1 4
4 1 2
1a 4 0
0

/
GRANT EXECUTE ON dbms_ias_mt_inst TO execute_catalog_role
/
DROP PUBLIC SYNONYM dbms_ias_mt_inst
/
CREATE PUBLIC SYNONYM dbms_ias_mt_inst FOR dbms_ias_mt_inst
/
CREATE OR REPLACE PACKAGE BODY dbms_ias_inst wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
b
8106000
1
4
0 
3e
2 :e:
1PACKAGE:
1BODY:
1DBMS_IAS_INST:
1DQ:
1CONSTANT:
1VARCHAR2:
11:
1":
1START_IAS_INST:
1IASNAME:
1AUTHUSER:
1AUTHPW:
1CONNSTR:
1CANON_IASNAME:
130:
1DUMMY:
1BINARY_INTEGER:
1DBMS_SNAP_INTERNAL:
1CANONICALIZE_IDENTIFIER:
1DBA_IAS_TEMPLATES:
1OWNER:
1USER:
1=:
1IAS_TEMPLATE_NAME:
1DBMS_IAS_INST_UTL:
1NO_DATA_FOUND:
1DBMS_REPCAT_RGT_UTL:
1RAISE_ERROR:
1DBMS_REPCAT_RGT:
1MISS_USER_AUTHORIZATION_NUM:
1dbms_ias_inst:
1missing user authorization:
1OTHERS:
1DBMS_SYS_ERROR:
1RAISE_SYSTEM_ERROR:
1ERRORIASINST_NUM:
1TRUE:
1FINISH_IAS_INST:
1REMOVE_IAS_SUPPORT:
1REGISTER_IAS_SITE:
1SITENAME:
1||:
1UNREGISTER_IAS_SITE:
1CURSOR:
1TEMPLATES:
1I:
1IS NOT NULL:
1REC:
1LOOP:
1FUNCTION:
1INSTANTIATION_IN_PROGRESS:
1RETURN:
1BOOLEAN:
1NUMBER:
1DDL_COUNT:
1COUNT:
1DBA_IAS_OBJECTS:
1OBJECT_TYPE:
1GENERATED DDL:
1ROWNUM:
1FALSE:
1RAISE:
0

0
0
2d2
2
0 a0 1d a0 97 87 :2 a0 51
a5 1c 6e 1b b0 9a 8f a0
b0 3d 8f a0 b0 3d 8f a0
b0 3d 8f a0 b0 3d b4 a3
55 6a a0 51 a5 1c 81 b0
a3 a0 1c 81 b0 :3 a0 6b a0
a5 b d 51 ac :2 a0 b2 ee
:2 a0 7e b4 2e :2 a0 7e b4 2e
a 10 ac e5 d0 b2 e9 :2 a0
6b :4 a0 a5 57 b7 :3 a0 6b :2 a0
6b :2 6e a5 57 b7 a6 9 a0
53 :2 a0 6b :2 a0 6b a0 a5 57
b7 a6 9 a4 b1 11 68 4f
9a 8f a0 b0 3d b4 a3 55
6a a0 51 a5 1c 81 b0 a3
a0 1c 81 b0 :3 a0 6b a0 a5
b d 51 ac :2 a0 b2 ee :2 a0
7e b4 2e :2 a0 7e b4 2e a
10 ac e5 d0 b2 e9 :2 a0 6b
a0 a5 57 b7 :3 a0 6b :2 a0 6b
:2 6e a5 57 b7 a6 9 a0 53
:2 a0 6b :2 a0 6b a0 a5 57 b7
a6 9 a4 b1 11 68 4f 9a
8f a0 b0 3d b4 a3 55 6a
a0 51 a5 1c 81 b0 a3 a0
1c 81 b0 :3 a0 6b a0 a5 b
d 51 ac :2 a0 b2 ee :2 a0 7e
b4 2e :2 a0 7e b4 2e a 10
ac e5 d0 b2 e9 :2 a0 6b a0
a5 57 b7 :3 a0 6b :2 a0 6b :2 6e
a5 57 b7 a6 9 a0 53 :2 a0
6b :2 a0 6b a0 a5 57 b7 a6
9 a4 b1 11 68 4f 9a 8f
a0 b0 3d 8f a0 b0 3d b4
a3 55 6a a0 51 a5 1c 81
b0 a3 a0 1c 81 b0 :3 a0 6b
a0 a5 b d 51 ac :2 a0 b2
ee :2 a0 7e b4 2e :2 a0 7e b4
2e a 10 ac e5 d0 b2 e9
:2 a0 6b :2 a0 7e a0 b4 2e 7e
a0 b4 2e a0 7e a0 b4 2e
7e a0 b4 2e a5 57 b7 :3 a0
6b :2 a0 6b :2 6e a5 57 b7 a6
9 a0 53 :2 a0 6b :2 a0 6b a0
a5 57 b7 a6 9 a4 b1 11
68 4f 9a 8f a0 b0 3d 8f
a0 b0 3d b4 a3 55 6a a0
51 a5 1c 81 b0 a3 a0 1c
81 b0 a0 f4 b4 bf c8 :2 a0
6b ac :2 a0 b9 b2 ee :2 a0 6b
a0 7e b4 2e ac d0 e5 e9
bd b7 11 a4 b1 a0 7e b4
2e :3 a0 6b a0 a5 b d 51
ac :2 a0 b2 ee :2 a0 7e b4 2e
:2 a0 7e b4 2e a 10 ac e5
d0 b2 e9 :2 a0 6b :2 a0 7e a0
b4 2e 7e a0 b4 2e a0 7e
a0 b4 2e 7e a0 b4 2e a5
57 b7 91 :2 a0 37 :2 a0 6b :2 a0
7e :2 a0 6b b4 2e 7e a0 b4
2e a0 7e a0 b4 2e 7e a0
b4 2e a5 57 b7 a0 47 b7
:2 19 3c b7 :3 a0 6b :2 a0 6b :2 6e
a5 57 b7 a6 9 a0 53 :2 a0
6b :2 a0 6b a0 a5 57 b7 a6
9 a4 b1 11 68 4f a0 8d
8f a0 b0 3d b4 :2 a0 a3 2c
6a a0 1c 81 b0 a3 a0 1c
81 b0 a3 a0 51 a5 1c 81
b0 :3 a0 6b a0 a5 b d 51
ac :2 a0 b2 ee :2 a0 7e b4 2e
ac e5 d0 b2 e9 a0 d2 9f
ac :2 a0 b2 ee a0 7e 6e b4
2e :2 a0 7e b4 2e a 10 a0
7e 51 b4 2e a 10 ac e5
d0 b2 e9 a0 7e 51 b4 2e
:2 a0 65 b7 :2 a0 65 b7 :2 19 3c
b7 :2 a0 62 b7 a6 9 a4 a0
b1 11 68 4f b1 b7 a4 11
b1 56 4f 17 b5 
2d2
2
0 3 7 8 14 37 c 1e
22 25 26 2e 33 13 3e 57
53 10 5f 68 64 52 70 7d
79 4f 85 8e 8a 78 96 75
bb 9f a3 a7 ab ae af b7
9e d6 c6 ca d2 9b c2 dd
e1 e5 e8 ec ed ef f3 f6
f7 fb ff 100 107 10b 10f 112
113 118 11c 120 123 124 1 129
12e 12f 135 139 13a 13f 143 147
14a 14e 152 156 15a 15b 160 162
166 16a 16e 171 175 179 17c 181
186 187 18c 18e 18f 194 1 198
19c 1a0 1a3 1a7 1ab 1ae 1b2 1b3
1b8 1ba 1bb 1c0 1c4 1c6 1d2 1d6
1d8 1f1 1ed 1ec 1f9 1e9 21e 202
206 20a 20e 211 212 21a 201 239
229 22d 235 1fe 225 240 244 248
24b 24f 250 252 256 259 25a 25e
262 263 26a 26e 272 275 276 27b
27f 283 286 287 1 28c 291 292
298 29c 29d 2a2 2a6 2aa 2ad 2b1
2b2 2b7 2b9 2bd 2c1 2c5 2c8 2cc
2d0 2d3 2d8 2dd 2de 2e3 2e5 2e6
2eb 1 2ef 2f3 2f7 2fa 2fe 302
305 309 30a 30f 311 312 317 31b
31d 329 32d 32f 348 344 343 350
340 375 359 35d 361 365 368 369
371 358 390 380 384 38c 355 37c
397 39b 39f 3a2 3a6 3a7 3a9 3ad
3b0 3b1 3b5 3b9 3ba 3c1 3c5 3c9
3cc 3cd 3d2 3d6 3da 3dd 3de 1
3e3 3e8 3e9 3ef 3f3 3f4 3f9 3fd
401 404 408 409 40e 410 414 418
41c 41f 423 427 42a 42f 434 435
43a 43c 43d 442 1 446 44a 44e
451 455 459 45c 460 461 466 468
469 46e 472 474 480 484 486 49f
49b 49a 4a7 4b4 4b0 497 4bc 4af
4de 4c5 4c9 4cd 4ac 4d1 4d2 4da
4c4 4f9 4e9 4ed 4f5 4c1 4e5 500
504 508 50b 50f 510 512 516 519
51a 51e 522 523 52a 52e 532 535
536 53b 53f 543 546 547 1 54c
551 552 558 55c 55d 562 566 56a
56d 571 575 578 57c 57d 582 585
589 58a 58f 593 596 59a 59b 5a0
5a3 5a7 5a8 5ad 5ae 5b3 5b5 5b9
5bd 5c1 5c4 5c8 5cc 5cf 5d4 5d9
5da 5df 5e1 5e2 5e7 1 5eb 5ef
5f3 5f6 5fa 5fe 601 605 606 60b
60d 60e 613 617 619 625 629 62b
644 640 63f 64c 659 655 63c 661
654 683 66a 66e 672 651 676 677
67f 669 69e 68e 692 69a 666 68a
6a5 6b5 6b6 6b9 6bd 6c1 6c5 6c8
6c9 6cd 6d1 6d3 6d4 6db 6df 6e3
6e6 6ea 6ed 6ee 6f3 6f4 6f8 6fe
703 708 70a 716 71a 71c 720 723
724 729 72d 731 735 738 73c 73d
73f 743 746 747 74b 74f 750 757
75b 75f 762 763 768 76c 770 773
774 1 779 77e 77f 785 789 78a
78f 793 797 79a 79e 7a2 7a5 7a9
7aa 7af 7b2 7b6 7b7 7bc 7c0 7c3
7c7 7c8 7cd 7d0 7d4 7d5 7da 7db
7e0 7e2 7e6 7ea 7ee 7f0 7f4 7f8
7fb 7ff 803 806 80a 80e 811 812
817 81a 81e 81f 824 828 82b 82f
830 835 838 83c 83d 842 843 848
84a 84e 855 857 85b 85f 862 864
868 86c 870 873 877 87b 87e 883
888 889 88e 890 891 896 1 89a
89e 8a2 8a5 8a9 8ad 8b0 8b4 8b5
8ba 8bc 8bd 8c2 8c6 8c8 8d4 8d8
8da 8de 8f7 8f3 8f2 8ff 8ef 904
908 928 910 914 918 91c 924 90f
943 933 937 93f 90c 95e 94a 94e
951 952 95a 932 965 969 96d 92f
971 975 976 978 97c 97f 980 984
988 989 990 994 998 99b 99c 9a1
9a2 9a8 9ac 9ad 9b2 9b6 9ba 9bd
9be 9c2 9c6 9c7 9ce 9d2 9d5 9da
9db 9e0 9e4 9e8 9eb 9ec 1 9f1
9f6 9fa 9fd a00 a01 1 a06 a0b
a0c a12 a16 a17 a1c a20 a23 a26
a27 a2c a30 a34 a38 a3a a3e a42
a46 a48 a4c a50 a53 a55 a59 a5d
a60 a62 a63 a68 a6c a70 a72 a7e
a82 a84 a86 a88 a8c a98 a9a a9d
a9f aa8 
2d2
2
0 :2 1 9 e 3 a 13 1c
1b 13 22 a 3 d 1c 28
:3 1c 28 :3 1c 28 :3 1c 28 :2 1c 1b
5 :2 3 14 1d 1c :2 14 :2 5 :3 14
:2 5 17 :2 2a 42 :2 17 5 :2 c 13
1e 19 1e c 14 :3 12 c 20
:3 1e :2 c 19 :5 5 :2 17 26 2f 39
41 :2 5 3 a 9 :2 1d 19 :2 29
19 2a :2 9 18 :2 5 :2 a 9 :2 18
2b :2 3d 2b :2 9 11 :2 5 :5 3 d
1d 28 :2 1d 1c 5 :2 3 14 1d
1c :2 14 :2 5 :3 14 :2 5 17 :2 2a 42
:2 17 5 :2 c 13 1e 19 1e c
14 :3 12 c 20 :3 1e :2 c 19 :5 5
:2 17 27 :2 5 3 a 9 :2 1d 19
:2 29 19 2a :2 9 18 :2 5 :2 a 9
:2 18 2b :2 3d 2b :2 9 11 :2 5 :5 3
d 20 2b :2 20 1f 5 :2 3 14
1d 1c :2 14 :2 5 :3 14 :2 5 17 :2 2a
42 :2 17 5 :2 c 13 1e 19 1e
c 14 :3 12 c 20 :3 1e :2 c 19
:5 5 :2 17 2a :2 5 3 a 9 :2 1d
19 :2 29 19 2a :2 9 18 :2 5 :2 a
9 :2 18 2b :2 3d 2b :2 9 11 :2 5
:5 3 d 1f 2c :3 1f 2c :2 1f 1e
5 :2 3 14 1d 1c :2 14 :2 5 :3 14
:2 5 17 :2 2a 42 :2 17 5 :2 c 13
1e 19 1e c 14 :3 12 c 20
:3 1e :2 c 19 :5 5 :2 17 29 33 36
39 :2 33 47 4a :3 33 36 3a :2 33
3f 42 :2 33 :2 5 3 a 9 :2 1d
19 :2 29 19 2a :2 9 18 :2 5 :2 a
9 :2 18 2b :2 3d 2b :2 9 11 :2 5
:5 3 d 21 2e :3 21 2e :2 21 20
5 :2 3 14 1d 1c :2 14 :2 5 :3 14
:2 5 c 0 :2 5 e :2 10 e 27
39 27 22 27 d :2 f 17 :3 15
22 :3 7 :5 5 :4 8 7 19 :2 2c 44
:2 19 7 :2 e 15 20 1b 20 e
16 :3 14 e 22 :3 20 :2 e 1b :5 7
:2 19 2d 36 39 3c :2 36 4a 4d
:3 36 39 3d :2 36 42 45 :2 36 :2 7
1c b 12 1c 7 9 :2 1b 2f
1a 1d 20 :2 24 :2 1a 36 39 :2 1a
3d 40 43 :2 3d 48 4b :2 3d :2 9
1c b 7 :4 5 3 a 9 :2 1d
19 :2 29 19 2a :2 9 18 :2 5 :2 a
9 :2 18 2b :2 3d 2b :2 9 11 :2 5
:6 3 c 26 31 :2 26 25 3b 42
:3 3 :3 12 :2 3 :3 12 :2 3 12 1b 1a
:2 12 3 5 17 :2 2a 42 :2 17 5
:2 c 13 1e 19 1e c 20 :3 1e
19 :4 5 :4 c 1a c 7 :2 c 18
1a :2 18 c 20 :3 1e :3 c 13 15
:2 13 :2 c 7 :4 5 8 12 14 :2 12
7 e 7 16 7 e 7 :4 5
3 a :2 9 18 :2 5 3 7 :8 3
:5 1 
2d2
2
0 :4 1 :9 6 :5 1a :4 1b :4 1c :4 1d 1a
1e :2 1a :6 1e :5 1f :8 22 :6 25 :5 26 :5 27
:2 26 :5 25 :9 2a 20 2c :3 2d :3 2e :2 2f
:2 2d :3 2c :2 30 :6 31 32 :2 31 :3 30 2b
:3 1a 33 :6 41 42 :2 41 :6 42 :5 43 :8 46
:6 49 :5 4a :5 4b :2 4a :5 49 :6 4e 44 50
:3 51 :3 52 :2 53 :2 51 :3 50 :2 54 :6 55 56
:2 55 :3 54 4f :3 41 57 :6 63 64 :2 63
:6 64 :5 65 :8 68 :6 6b :5 6c :5 6d :2 6c :5 6b
:6 71 66 73 :3 74 :3 75 :2 76 :2 74 :3 73
:2 77 :6 78 79 :2 78 :3 77 72 :3 63 7a
:5 85 :4 86 85 87 :2 85 :6 87 :5 88 :8 8b
:6 8e :5 8f :5 90 :2 8f :5 8e :d 93 :9 94 :2 93
89 96 :3 97 :3 98 :2 99 :2 97 :3 96 :2 9a
:6 9b 9c :2 9b :3 9a 95 :3 85 9d :5 aa
:4 ab aa ac :2 aa :6 ac :5 ad :2 ae 0
:2 ae :9 af :7 b0 :4 af :5 ae :4 b2 :8 b4 :6 b7
:5 b8 :5 b9 :2 b8 :5 b7 :d bc :9 bd :2 bc b2
:4 c0 :4 c1 :14 c2 :2 c1 c0 c3 c0 :2 be
:2 b2 b1 c6 :3 c7 :3 c8 :2 c9 :2 c7 :3 c6
:2 ca :6 cb cc :2 cb :3 ca c5 :3 aa cd
:9 dd df :2 dd :4 df :5 e0 :7 e1 :8 e5 :6 e8
:5 e9 :5 e8 :5 ec :3 ed :5 ee :5 ef :2 ee :5 f0
:2 ee ed :4 ec :5 f7 :3 f8 f7 :3 fa :2 f9
:2 f7 e2 fe :2 ff :3 fe fd 100 :3 dd
100 :4 1a :5 1 
aaa
4
:3 0 1 :4 0 2
:3 0 5 :3 0 7
4f 0 5 3
:6 0 1 :2 0 6
:3 0 7 :2 0 3
7 9 :6 0 8
:4 0 d a b
2cd 4 :6 0 9
:a 0 76 2 :4 0
b 75 0 9
6 :3 0 a :7 0
11 10 :3 0 6
:3 0 b :7 0 15
14 :3 0 f :2 0
d 6 :3 0 c
:7 0 19 18 :3 0
6 :3 0 d :7 0
1d 1c :3 0 18
c2 0 16 1f
:2 0 76 e 21
:2 0 6 :3 0 f
:2 0 14 23 25
:6 0 28 26 0
74 e :6 0 e
:3 0 11 :3 0 2a
:7 0 2d 2b 0
74 10 :6 0 12
:3 0 13 :3 0 2f
30 0 a :3 0
1a 31 33 2e
34 0 56 7
:2 0 1c 10 :3 0
14 :3 0 1e 3a
47 0 48 :3 0
15 :3 0 16 :3 0
17 :2 0 22 3e
3f :3 0 18 :3 0
e :3 0 17 :2 0
27 43 44 :3 0
40 46 45 :3 0
4a 4b :5 0 37
3b 0 2a 0
49 :2 0 56 19
:3 0 9 :3 0 4d
4e 0 a :3 0
b :3 0 c :3 0
d :3 0 2c 4f
54 :2 0 56 31
75 1a :3 0 1b
:3 0 1c :3 0 58
59 0 1d :3 0
1e :3 0 5b 5c
0 1f :4 0 20
:4 0 35 5a 60
:2 0 62 39 64
3b 63 62 :2 0
73 21 :3 0 22
:3 0 23 :3 0 67
68 0 19 :3 0
24 :3 0 6a 6b
0 25 :3 0 3d
69 6e :2 0 70
4a 72 42 71
70 :2 0 73 44
:2 0 75 47 75
74 56 73 :6 0
76 1 0 e
21 75 2cd :2 0
26 :a 0 d1 3
:4 0 4f :2 0 4d
6 :3 0 a :7 0
7b 7a :3 0 55
225 0 53 7d
:2 0 d1 78 7f
:2 0 6 :3 0 f
:2 0 51 81 83
:6 0 86 84 0
cf e :6 0 e
:3 0 11 :3 0 88
:7 0 8b 89 0
cf 10 :6 0 12
:3 0 13 :3 0 8d
8e 0 a :3 0
57 8f 91 8c
92 0 b1 7
:2 0 59 10 :3 0
14 :3 0 5b 98
a5 0 a6 :3 0
15 :3 0 16 :3 0
17 :2 0 5f 9c
9d :3 0 18 :3 0
e :3 0 17 :2 0
64 a1 a2 :3 0
9e a4 a3 :3 0
a8 a9 :5 0 95
99 0 67 0
a7 :2 0 b1 19
:3 0 26 :3 0 ab
ac 0 a :3 0
69 ad af :2 0
b1 6b d0 1a
:3 0 1b :3 0 1c
:3 0 b3 b4 0
1d :3 0 1e :3 0
b6 b7 0 1f
:4 0 20 :4 0 6f
b5 bb :2 0 bd
73 bf 75 be
bd :2 0 ce 21
:3 0 22 :3 0 23
:3 0 c2 c3 0
19 :3 0 24 :3 0
c5 c6 0 25
:3 0 77 c4 c9
:2 0 cb 84 cd
7c cc cb :2 0
ce 7e :2 0 d0
81 d0 cf b1
ce :6 0 d1 1
0 78 7f d0
2cd :2 0 27 :a 0
12c 4 :4 0 89
:2 0 87 6 :3 0
a :7 0 d6 d5
:3 0 8f 37c 0
8d d8 :2 0 12c
d3 da :2 0 6
:3 0 f :2 0 8b
dc de :6 0 e1
df 0 12a e
:6 0 e :3 0 11
:3 0 e3 :7 0 e6
e4 0 12a 10
:6 0 12 :3 0 13
:3 0 e8 e9 0
a :3 0 91 ea
ec e7 ed 0
10c 7 :2 0 93
10 :3 0 14 :3 0
95 f3 100 0
101 :3 0 15 :3 0
16 :3 0 17 :2 0
99 f7 f8 :3 0
18 :3 0 e :3 0
17 :2 0 9e fc
fd :3 0 f9 ff
fe :3 0 103 104
:5 0 f0 f4 0
a1 0 102 :2 0
10c 19 :3 0 27
:3 0 106 107 0
a :3 0 a3 108
10a :2 0 10c a5
12b 1a :3 0 1b
:3 0 1c :3 0 10e
10f 0 1d :3 0
1e :3 0 111 112
0 1f :4 0 20
:4 0 a9 110 116
:2 0 118 ad 11a
af 119 118 :2 0
129 21 :3 0 22
:3 0 23 :3 0 11d
11e 0 19 :3 0
24 :3 0 120 121
0 25 :3 0 b1
11f 124 :2 0 126
be 128 b6 127
126 :2 0 129 b8
:2 0 12b bb 12b
12a 10c 129 :6 0
12c 1 0 d3
da 12b 2cd :2 0
28 :a 0 19d 5
:4 0 c3 4ac 0
c1 6 :3 0 29
:7 0 131 130 :3 0
f :2 0 c5 6
:3 0 a :7 0 135
134 :3 0 cc 4e5
0 ca 137 :2 0
19d 12e 139 :2 0
6 :3 0 c8 13b
13d :6 0 140 13e
0 19b e :6 0
e :3 0 11 :3 0
142 :7 0 145 143
0 19b 10 :6 0
12 :3 0 13 :3 0
147 148 0 a
:3 0 ce 149 14b
146 14c 0 17d
7 :2 0 d0 10
:3 0 14 :3 0 d2
152 15f 0 160
:3 0 15 :3 0 16
:3 0 17 :2 0 d6
156 157 :3 0 18
:3 0 e :3 0 17
:2 0 db 15b 15c
:3 0 158 15e 15d
:3 0 162 163 :5 0
14f 153 0 de
0 161 :2 0 17d
19 :3 0 28 :3 0
165 166 0 29
:3 0 4 :3 0 2a
:2 0 e :3 0 e0
16a 16c :3 0 2a
:2 0 4 :3 0 e3
16e 170 :3 0 4
:3 0 2a :2 0 16
:3 0 e6 173 175
:3 0 2a :2 0 4
:3 0 e9 177 179
:3 0 ec 167 17b
:2 0 17d f0 19c
1a :3 0 1b :3 0
1c :3 0 17f 180
0 1d :3 0 1e
:3 0 182 183 0
1f :4 0 20 :4 0
f4 181 187 :2 0
189 f8 18b fa
18a 189 :2 0 19a
21 :3 0 22 :3 0
23 :3 0 18e 18f
0 19 :3 0 24
:3 0 191 192 0
25 :3 0 fc 190
195 :2 0 197 109
199 101 198 197
:2 0 19a 103 :2 0
19c 106 19c 19b
17d 19a :6 0 19d
1 0 12e 139
19c 2cd :2 0 2b
:a 0 256 6 :4 0
10e 651 0 10c
6 :3 0 29 :7 0
1a2 1a1 :3 0 f
:2 0 110 6 :3 0
a :7 0 1a6 1a5
:3 0 117 68a 0
115 1a8 :2 0 256
19f 1aa :2 0 6
:3 0 113 1ac 1ae
:6 0 1b1 1af 0
254 e :6 0 2c
:3 0 11 :3 0 1b3
:7 0 1b6 1b4 0
254 10 :6 0 2d
:a 0 7 1d0 :4 0
1b8 1bb 0 1b9
:3 0 2e :3 0 18
:3 0 1bc 1bd 0
119 14 :3 0 2e
:3 0 1c0 1c1 11b
1c3 1cb 0 1cc
:3 0 2e :3 0 15
:3 0 1c5 1c6 0
16 :3 0 17 :2 0
11f 1c9 1ca :5 0
1bf 1c4 0 1cd
:6 0 1ce :2 0 1d1
1b8 1bb 1d2 0
254 122 1d2 1d4
1d1 1d3 :6 0 1d0
1 :6 0 1d2 a
:3 0 2f :2 0 124
1d6 1d7 :3 0 e
:3 0 12 :3 0 13
:3 0 1da 1db 0
a :3 0 126 1dc
1de 1d9 1df 0
210 7 :2 0 128
10 :3 0 14 :3 0
12a 1e5 1f2 0
1f3 :3 0 15 :3 0
16 :3 0 17 :2 0
12e 1e9 1ea :3 0
18 :3 0 e :3 0
17 :2 0 133 1ee
1ef :3 0 1eb 1f1
1f0 :3 0 1f5 1f6
:5 0 1e2 1e6 0
136 0 1f4 :2 0
210 19 :3 0 2b
:3 0 1f8 1f9 0
29 :3 0 4 :3 0
2a :2 0 e :3 0
138 1fd 1ff :3 0
2a :2 0 4 :3 0
13b 201 203 :3 0
4 :3 0 2a :2 0
16 :3 0 13e 206
208 :3 0 2a :2 0
4 :3 0 141 20a
20c :3 0 144 1fa
20e :2 0 210 148
234 30 :3 0 2d
:3 0 31 :3 0 211
212 19 :3 0 2b
:3 0 215 216 0
29 :3 0 4 :3 0
2a :2 0 30 :3 0
18 :3 0 21b 21c
0 14c 21a 21e
:3 0 2a :2 0 4
:3 0 14f 220 222
:3 0 4 :3 0 2a
:2 0 16 :3 0 152
225 227 :3 0 2a
:2 0 4 :3 0 155
229 22b :3 0 158
217 22d :2 0 22f
15c 231 31 :3 0
214 22f :4 0 232
15e 233 0 232
0 235 1d8 210
0 235 160 0
236 163 255 1a
:3 0 1b :3 0 1c
:3 0 238 239 0
1d :3 0 1e :3 0
23b 23c 0 1f
:4 0 20 :4 0 165
23a 240 :2 0 242
169 244 16b 243
242 :2 0 253 21
:3 0 22 :3 0 23
:3 0 247 248 0
19 :3 0 24 :3 0
24a 24b 0 25
:3 0 16d 249 24e
:2 0 250 17b 252
172 251 250 :2 0
253 174 :2 0 255
177 255 254 236
253 :6 0 256 1
0 19f 1aa 255
2cd :2 0 32 :3 0
33 :a 0 2c7 9
:4 0 180 :2 0 17e
6 :3 0 a :7 0
25c 25b :3 0 34
:3 0 35 :3 0 184
92f 0 182 25e
260 0 2c7 259
262 :2 0 36 :3 0
264 :7 0 267 265
0 2c5 10 :6 0
275 276 0 188
36 :3 0 269 :7 0
26c 26a 0 2c5
37 :6 0 6 :3 0
f :2 0 186 26e
270 :6 0 273 271
0 2c5 e :6 0
e :3 0 12 :3 0
13 :3 0 a :3 0
18a 277 279 274
27a 0 2bc 7
:2 0 18c 10 :3 0
14 :3 0 18e 280
286 0 287 :3 0
18 :3 0 e :3 0
17 :2 0 192 284
285 :4 0 289 28a
:5 0 27d 281 0
195 0 288 :2 0
2bc 38 :3 0 28e
:3 0 38 :2 0 197
37 :3 0 39 :3 0
199 292 2a6 0
2a7 :3 0 3a :3 0
17 :2 0 3b :4 0
19d 295 297 :3 0
18 :3 0 e :3 0
17 :2 0 1a2 29b
29c :3 0 298 29e
29d :2 0 3c :3 0
17 :2 0 7 :2 0
1a7 2a1 2a3 :3 0
29f 2a5 2a4 :3 0
2a9 2aa :5 0 28f
293 0 1aa 0
2a8 :2 0 2bc 37
:3 0 17 :2 0 7
:2 0 1ae 2ad 2af
:3 0 34 :3 0 25
:3 0 2b2 :2 0 2b4
1b1 2ba 34 :3 0
3d :3 0 2b6 :2 0
2b8 1b3 2b9 0
2b8 0 2bb 2b0
2b4 0 2bb 1b5
0 2bc 1b8 2c6
1a :3 0 3e :5 0
2c0 1c7 2c2 1bf
2c1 2c0 :2 0 2c3
1c1 :2 0 2c6 33
:3 0 1c3 2c6 2c5
2bc 2c3 :6 0 2c7
1 0 259 262
2c6 2cd :3 0 2cc
0 2cc :3 0 2cc
2cd 2ca 2cb :6 0
2ce :2 0 1ca 0
4 2cc 2d0 :2 0
2 2ce 2d1 :8 0

1d2
4
:3 0 1 8 1
5 1 f 1
13 1 17 1
1b 4 12 16
1a 1e 1 24
1 20 1 29
1 32 1 36
1 39 1 3d
2 3c 3d 1
42 2 41 42
1 38 4 50
51 52 53 3
35 4c 55 3
5d 5e 5f 1
61 1 57 2
6c 6d 1 6f
1 66 2 64
72 2 27 2c
2 6f 77 1
79 1 7c 1
82 1 7e 1
87 1 90 1
94 1 97 1
9b 2 9a 9b
1 a0 2 9f
a0 1 96 1
ae 3 93 aa
b0 3 b8 b9
ba 1 bc 1
b2 2 c7 c8
1 ca 1 c1
2 bf cd 2
85 8a 2 ca
d2 1 d4 1
d7 1 dd 1
d9 1 e2 1
eb 1 ef 1
f2 1 f6 2
f5 f6 1 fb
2 fa fb 1
f1 1 109 3
ee 105 10b 3
113 114 115 1
117 1 10d 2
122 123 1 125
1 11c 2 11a
128 2 e0 e5
2 125 12d 1
12f 1 133 2
132 136 1 13c
1 138 1 141
1 14a 1 14e
1 151 1 155
2 154 155 1
15a 2 159 15a
1 150 2 169
16b 2 16d 16f
2 172 174 2
176 178 3 168
171 17a 3 14d
164 17c 3 184
185 186 1 188
1 17e 2 193
194 1 196 1
18d 2 18b 199
2 13f 144 2
196 19e 1 1a0
1 1a4 2 1a3
1a7 1 1ad 1
1a9 1 1b2 1
1be 1 1c2 1
1c8 2 1c7 1c8
1 1cf 1 1d5
1 1dd 1 1e1
1 1e4 1 1e8
2 1e7 1e8 1
1ed 2 1ec 1ed
1 1e3 2 1fc
1fe 2 200 202
2 205 207 2
209 20b 3 1fb
204 20d 3 1e0
1f7 20f 2 219
21d 2 21f 221
2 224 226 2
228 22a 3 218
223 22c 1 22e
1 231 2 234
233 1 235 3
23d 23e 23f 1
241 1 237 2
24c 24d 1 24f
1 246 2 244
252 3 1b0 1b5
1d0 2 24f 257
1 25a 1 25d
1 261 1 268
1 26f 1 26d
1 278 1 27c
1 27f 1 283
2 282 283 1
27e 1 28d 1
291 1 296 2
294 296 1 29a
2 299 29a 1
2a2 2 2a0 2a2
1 290 1 2ae
2 2ac 2ae 1
2b3 1 2b7 2
2ba 2b9 4 27b
28b 2ab 2bb 1
2bf 1 2bd 1
2c2 3 266 26b
272 2 2bf 2c8
7 c 76 d1
12c 19d 256 2c7

1
4
0 
2d0
0
1
14
9
22
0 1 1 1 1 1 6 6
1 0 0 0 0 0 0 0
0 0 0 0 
268 9 0
d3 1 4
19f 1 6
1b8 6 7
5 1 0
261 9 0
1b2 6 0
141 5 0
e2 4 0
87 3 0
29 2 0
13 2 0
211 8 0
e 1 2
17 2 0
12e 1 5
1b 2 0
4 0 1
26d 9 0
25a 9 0
1a9 6 0
1a4 6 0
138 5 0
133 5 0
d9 4 0
d4 4 0
7e 3 0
79 3 0
20 2 0
f 2 0
259 1 9
78 1 3
1a0 6 0
12f 5 0
0

/
CREATE OR REPLACE PACKAGE BODY dbms_ias_mt_inst wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
b
8106000
1
4
0 
97
2 :e:
1PACKAGE:
1BODY:
1DBMS_IAS_MT_INST:
1Q:
1CONSTANT:
1VARCHAR2:
11:
1':
1DQ:
1":
1NBEG:
12:
1'":
1NEND:
1"':
1CMA:
1,:
1DOT:
1.:
1PARSE_DDL:
1DDL_TXT:
1USRID:
1BINARY_INTEGER:
1SQL_CURSOR:
1NUMBER:
1DUMMY:
1DBMS_SYS_SQL:
1OPEN_CURSOR:
1IS NOT NULL:
1PARSE_AS_USER:
1DBMS_SQL:
1V7:
1PARSE:
1EXECUTE:
1CLOSE_CURSOR:
1OTHERS:
1IS_OPEN:
1RAISE:
1CLEAN_IAS_SITE:
1SQL_TXT:
11000:
1ERR_NUM:
1ERR_MSG:
12000:
1PROPAGATOR:
130:
1CURSOR:
1REFGROUPS:
1OWNER:
1NAME:
1DBA_RGROUP:
1SNAPSHOTS:
1DBA_SNAPSHOTS:
1SNAPGROUPS:
1GNAME:
1DBA_REPCAT:
1MASTER:
1=:
1N:
1USERS:
1USERNAME:
1DBA_USERS:
1SYS:
1SYSTEM:
1ORDSYS:
1CTXSYS:
1MDSYS:
1ORDPLUGINS:
1OUTLN:
1REC:
1LOOP:
1DBMS_REFRESH:
1DESTROY:
1||:
1SQLCODE:
1Error in dbms_ias_mt_inst.clean_ias_site while :
1trying to drop ref groups.:
1TO_CHAR:
1SUBSTRB:
1SQLERRM:
11800:
1DBMS_SYSTEM:
1KSDWRT:
1TRACE_FILE:
1COMMIT:
1DBMS_REPCAT:
1DROP_SNAPSHOT_REPGROUP:
1trying to drop snapshot repgroups.:
1DROP SNAPSHOT :
1Error in dbms_ias_mt_inst.clean_ias_site while:
1trying to drop snapshots.:
1UNREGISTER_IAS_SITE:
1DBMS_SNAP_INTERNAL:
1REMOVE_BACK_END_DB:
1trying to unregister the IAS site.:
1DEFPROPAGATOR:
1DBMS_DEFER_SYS:
1UNREGISTER_PROPAGATOR:
1Error in dbms_ias_mt_inst.clean_ias_site :
1 :
1dbms_ias_mt_inst.clean_ias_site:: Error while :
1trying to unregister the propagator.:
1USER:
1!=:
1DROP USER :
1 CASCADE:
1trying to drop the users.:
1ALTER_SYNC_INTERVAL:
1NEXTDATE:
1INTERVAL:
1REFGROUP:
1IS NULL:
1CHANGE:
1REGISTER_IAS_SITE:
1IASNAME:
1LOCALDB:
1128:
1BACKDB:
1P_IASNAME:
160:
1GLOBAL_NAME:
1GET_BACK_END_DB:
1REPLACE:
1'':
1BEGIN :
1  SYS.DBMS_IAS_INST.REGISTER_IAS_SITE@:
1(:
1);:
1 END;:
1UID:
1DBMS_SYS_ERROR:
1RAISE_SYSTEM_ERROR:
1DBMS_IAS_INST_UTL:
1ERRORIASINST_NUM:
1FALSE:
1 SYS.DBMS_IAS_INST.UNREGISTER_IAS_SITE@:
1ENABLE_DEFERRED_CONS:
1DEF_CONS:
1C:
1CONSTRAINT_NAME:
1TABLE_NAME:
1DBA_CONSTRAINTS:
1CONSTRAINT_TYPE:
1R:
1DEFERRABLE:
1STATUS:
1DISABLED:
1ALTER TABLE :
1 MODIFY CONSTRAINT :
1 ENABLE NOVALIDATE:
1TRUE:
0

0
0
512
2
0 a0 1d a0 97 87 :2 a0 51
a5 1c 6e 1b b0 87 :2 a0 51
a5 1c 6e 1b b0 87 :2 a0 51
a5 1c 6e 1b b0 87 :2 a0 51
a5 1c 6e 1b b0 87 :2 a0 51
a5 1c 6e 1b b0 87 :2 a0 51
a5 1c 6e 1b b0 9a 8f a0
b0 3d 8f a0 b0 3d b4 a3
55 6a a0 1c 81 b0 a3 a0
1c 81 b0 :3 a0 6b d a0 7e
b4 2e 5a :2 a0 6b :4 a0 6b a0
a5 57 b7 :2 a0 6b :4 a0 6b a5
57 b7 :2 19 3c :3 a0 6b a0 a5
b d :2 a0 6b a0 a5 57 b7
a0 53 :2 a0 6b a0 a5 b :2 a0
6b a0 a5 57 b7 19 3c a0
62 b7 a6 9 a4 b1 11 68
4f 9a a3 b4 55 6a a0 51
a5 1c 81 b0 a3 a0 1c 81
b0 a3 a0 51 a5 1c 81 b0
a3 a0 51 a5 1c 81 b0 a0
f4 b4 bf c8 :2 a0 ac a0 b2
ee ac d0 e5 e9 bd b7 11
a4 b1 a0 f4 b4 bf c8 :2 a0
ac a0 b2 ee ac d0 e5 e9
bd b7 11 a4 b1 a0 f4 b4
bf c8 a0 ac a0 b2 ee a0
7e 6e b4 2e ac d0 e5 e9
bd b7 11 a4 b1 a0 f4 b4
bf c8 a0 ac a0 b2 ee a0
4c :7 6e 5 48 ac d0 e5 e9
bd b7 11 a4 b1 91 :2 a0 37
:2 a0 6b a0 7e :2 a0 6b b4 2e
7e a0 b4 2e 7e a0 b4 2e
7e a0 b4 2e 7e :2 a0 6b b4
2e 7e a0 b4 2e a5 57 b7
a0 53 :2 a0 d a0 6e 7e 6e
b4 2e 7e :2 a0 a5 b b4 2e
7e :2 a0 :2 51 a5 b b4 2e d
:2 a0 6b :2 a0 6b a0 a5 57 b7
a6 9 a4 b1 11 4f b7 a0
47 a0 57 a0 b4 e9 91 :2 a0
37 :2 a0 6b a0 7e :2 a0 6b b4
2e 7e a0 b4 2e a5 57 b7
a0 53 :2 a0 d a0 6e 7e 6e
b4 2e 7e :2 a0 a5 b b4 2e
7e :2 a0 :2 51 a5 b b4 2e d
:2 a0 6b :2 a0 6b a0 a5 57 b7
a6 9 a4 b1 11 4f b7 a0
47 a0 57 a0 b4 e9 91 :2 a0
37 a0 6e 7e a0 b4 2e 7e
:2 a0 6b b4 2e 7e a0 b4 2e
7e a0 b4 2e 7e a0 b4 2e
7e :2 a0 6b b4 2e 7e a0 b4
2e d :2 a0 4d a5 57 b7 a0
53 :2 a0 d a0 6e 7e 6e b4
2e 7e :2 a0 a5 b b4 2e 7e
:2 a0 :2 51 a5 b b4 2e d :2 a0
6b :2 a0 6b a0 a5 57 b7 a6
9 a4 b1 11 4f b7 a0 47
a0 57 a0 b4 e9 a0 57 b3
:2 a0 6b 57 b3 b7 a0 53 :2 a0
d a0 6e 7e 6e b4 2e 7e
:2 a0 a5 b b4 2e 7e :2 a0 :2 51
a5 b b4 2e d :2 a0 6b :2 a0
6b a0 a5 57 b7 a6 9 a4
b1 11 4f a0 57 a0 b4 e9
a0 ac :2 a0 b2 ee ac ad e5
d0 b2 e9 :2 a0 6b a0 a5 57
b7 a0 53 :2 a0 d a0 6e 7e
:2 a0 a5 b b4 2e 7e 6e b4
2e 7e :2 a0 :2 51 a5 b b4 2e
d :2 a0 6b :2 a0 6b 6e 7e 6e
b4 2e a5 57 :2 a0 6b :2 a0 6b
a0 a5 57 b7 a6 9 a4 b1
11 4f a0 57 a0 b4 e9 91
:2 a0 37 :2 a0 6b a0 7e b4 2e
a0 6e 7e a0 b4 2e 7e :2 a0
6b b4 2e 7e a0 b4 2e 7e
6e b4 2e d :2 a0 4d a5 57
b7 19 3c b7 a0 53 :2 a0 d
a0 6e 7e :2 a0 a5 b b4 2e
7e 6e b4 2e 7e :2 a0 :2 51 a5
b b4 2e d :2 a0 6b :2 a0 6b
6e 7e 6e b4 2e a5 57 :2 a0
6b :2 a0 6b a0 a5 57 b7 a6
9 a4 b1 11 4f b7 a0 47
a0 57 a0 b4 e9 b7 a4 a0
b1 11 68 4f 9a 8f a0 b0
3d 8f a0 b0 3d 8f a0 4d
b0 3d b4 a0 55 6a f4 b4
bf c8 a0 ac a0 b2 ee ac
d0 e5 e9 bd b7 11 a4 b1
a0 7e b4 2e 91 :2 a0 37 :2 a0
6b a0 7e :2 a0 6b b4 2e 7e
a0 b4 2e :2 a0 a5 57 b7 a0
47 b7 :2 a0 6b :3 a0 a5 57 b7
:2 19 3c b7 a4 b1 11 68 4f
9a 8f a0 b0 3d b4 a3 55
6a a0 51 a5 1c 81 b0 a3
a0 51 a5 1c 81 b0 a3 a0
51 a5 1c 81 b0 a3 a0 51
a5 1c 81 b0 a0 ac :2 a0 b2
ee ac e5 d0 b2 e9 :3 a0 6b
d :3 a0 :2 6e a5 b d a0 7e
b4 2e a0 6e 7e 6e b4 2e
7e a0 b4 2e 7e 6e b4 2e
7e a0 b4 2e 7e a0 b4 2e
7e a0 b4 2e 7e a0 b4 2e
7e a0 b4 2e 7e a0 b4 2e
7e a0 b4 2e 7e 6e b4 2e
7e 6e b4 2e d :3 a0 a5 57
a0 57 a0 b4 e9 b7 :2 a0 6b
:2 a0 6b a0 a5 57 b7 :2 19 3c
b7 a4 b1 11 68 4f 9a a3
b4 55 6a a0 51 a5 1c 81
b0 a3 a0 51 a5 1c 81 b0
a3 a0 51 a5 1c 81 b0 a0
ac :2 a0 b2 ee ac e5 d0 b2
e9 :3 a0 6b d a0 7e b4 2e
a0 6e 7e 6e b4 2e 7e a0
b4 2e 7e 6e b4 2e 7e a0
b4 2e 7e a0 b4 2e 7e a0
b4 2e 7e 6e b4 2e 7e 6e
b4 2e d :3 a0 a5 57 a0 57
a0 b4 e9 b7 :2 a0 6b :2 a0 6b
a0 a5 57 b7 :2 19 3c b7 a4
b1 11 68 4f 9a a3 b4 55
6a a0 51 a5 1c 81 b0 a0
f4 b4 bf c8 :2 a0 6b :2 a0 6b
:2 a0 6b ac :2 a0 b9 b2 ee :2 a0
6b 7e 6e b4 2e :2 a0 6b 7e
6e b4 2e a 10 :2 a0 6b 7e
6e b4 2e a 10 ac d0 e5
e9 bd b7 11 a4 b1 91 :2 a0
37 a0 6e 7e a0 b4 2e 7e
:2 a0 6b b4 2e 7e a0 b4 2e
7e a0 b4 2e 7e a0 b4 2e
7e :2 a0 6b b4 2e 7e a0 b4
2e 7e 6e b4 2e 7e a0 b4
2e 7e :2 a0 6b b4 2e 7e a0
b4 2e 7e 6e b4 2e d :2 a0
4d a5 57 b7 a0 47 b7 a0
53 :2 a0 6b :2 a0 6b a0 a5 57
b7 a6 9 a4 b1 11 68 4f
b1 b7 a4 11 b1 56 4f 17
b5 
512
2
0 3 7 8 14 37 c 1e
22 25 26 2e 33 13 5c 42
46 10 4a 4b 53 58 41 81
67 6b 3e 6f 70 78 7d 66
a6 8c 90 63 94 95 9d a2
8b cb b1 b5 88 b9 ba c2
c7 b0 f0 d6 da ad de df
e7 ec d5 f7 110 10c d2 118
121 11d 10b 129 108 14a 132 136
13a 13e 146 131 165 155 159 161
12e 151 16c 170 174 177 17b 17f
182 183 188 18b 18f 193 196 19a
19e 1a2 1a6 1a9 1ad 1ae 1b3 1b5
1b9 1bd 1c0 1c4 1c8 1cc 1d0 1d3
1d4 1d9 1db 1df 1e3 1e6 1ea 1ee
1f2 1f5 1f9 1fa 1fc 200 204 208
20b 20f 210 215 217 1 21b 21f
223 226 22a 22b 22d 231 235 238
23c 23d 242 244 248 24b 24f 252
254 255 25a 25e 260 26c 270 272
2a4 287 288 28c 290 294 297 298
2a0 286 2bf 2af 2b3 2bb 283 2da
2c6 2ca 2cd 2ce 2d6 2ae 2f6 2e5
2ab 2e9 2ea 2f2 2e4 2fd 301 2e1
311 314 318 31c 320 321 325 326
32d 32e 332 338 33d 342 344 350
354 356 35a 36a 36b 36e 372 376
37a 37b 37f 380 387 388 38c 392
397 39c 39e 3aa 3ae 3b0 3b4 3c4
3c5 3c8 3cc 3d0 3d1 3d5 3d6 3dd
3e1 3e4 3e9 3ea 3ef 3f0 3f4 3fa
3ff 404 406 412 416 418 41c 42c
42d 430 434 438 439 43d 43e 445
1 449 44e 453 458 45d 462 467
46c 470 473 474 478 47e 483 488
48a 496 49a 49c 4a0 4a4 4a8 4aa
4ae 4b2 4b5 4b9 4bc 4c0 4c4 4c7
4c8 4cd 4d0 4d4 4d5 4da 4dd 4e1
4e2 4e7 4ea 4ee 4ef 4f4 4f7 4fb
4ff 502 503 508 50b 50f 510 515
516 51b 51d 1 521 525 529 52d
531 536 539 53e 53f 544 547 54b
54f 550 552 553 558 55b 55f 563
566 569 56a 56c 56d 572 576 57a
57e 581 585 589 58c 590 591 596
598 599 59e 5a2 5a4 5b0 5b2 5b4
5b8 5bf 5c3 5c8 5cc 5cd 5d2 5d6
5da 5de 5e0 5e4 5e8 5eb 5ef 5f2
5f6 5fa 5fd 5fe 603 606 60a 60b
610 611 616 618 1 61c 620 624
628 62c 631 634 639 63a 63f 642
646 64a 64b 64d 64e 653 656 65a
65e 661 664 665 667 668 66d 671
675 679 67c 680 684 687 68b 68c
691 693 694 699 69d 69f 6ab 6ad
6af 6b3 6ba 6be 6c3 6c7 6c8 6cd
6d1 6d5 6d9 6db 6df 6e4 6e7 6eb
6ec 6f1 6f4 6f8 6fc 6ff 700 705
708 70c 70d 712 715 719 71a 71f
722 726 727 72c 72f 733 737 73a
73b 740 743 747 748 74d 751 755
759 75a 75b 760 762 1 766 76a
76e 772 776 77b 77e 783 784 789
78c 790 794 795 797 798 79d 7a0
7a4 7a8 7ab 7ae 7af 7b1 7b2 7b7
7bb 7bf 7c3 7c6 7ca 7ce 7d1 7d5
7d6 7db 7dd 7de 7e3 7e7 7e9 7f5
7f7 7f9 7fd 804 808 80d 811 812
817 81b 820 821 825 829 82c 831
832 834 1 838 83c 840 844 848
84d 850 855 856 85b 85e 862 866
867 869 86a 86f 872 876 87a 87d
880 881 883 884 889 88d 891 895
898 89c 8a0 8a3 8a7 8a8 8ad 8af
8b0 8b5 8b9 8bb 8c7 8c9 8cd 8d2
8d6 8d7 8dc 8e0 8e1 8e5 8e9 8ea
8f1 1 8f2 8f8 8fc 8fd 902 906
90a 90d 911 912 917 919 1 91d
921 925 929 92d 932 935 939 93d
93e 940 941 946 949 94e 94f 954
957 95b 95f 962 965 966 968 969
96e 972 976 97a 97d 981 985 988
98d 990 995 996 99b 99c 9a1 9a5
9a9 9ac 9b0 9b4 9b7 9bb 9bc 9c1
9c3 9c4 9c9 9cd 9cf 9db 9dd 9e1
9e6 9ea 9eb 9f0 9f4 9f8 9fc 9fe
a02 a06 a09 a0d a10 a11 a16 a1a
a1f a22 a26 a27 a2c a2f a33 a37
a3a a3b a40 a43 a47 a48 a4d a50
a55 a56 a5b a5f a63 a67 a68 a69
a6e a70 a74 a77 a79 1 a7d a81
a85 a89 a8d a92 a95 a99 a9d a9e
aa0 aa1 aa6 aa9 aae aaf ab4 ab7
abb abf ac2 ac5 ac6 ac8 ac9 ace
ad2 ad6 ada add ae1 ae5 ae8 aed
af0 af5 af6 afb afc b01 b05 b09
b0c b10 b14 b17 b1b b1c b21 b23
b24 b29 b2d b2f b3b b3d b3f b43
b4a b4e b53 b57 b58 b5d b5f b63
b67 b69 b75 b79 b7b b94 b90 b8f
b9c ba9 ba5 b8c bb1 bbb bb6 bba
ba4 bc3 ba1 bc8 bcc bd0 bd4 be4
be5 be8 bec bf0 bf1 bf5 bf6 bfd
bfe c02 c08 c0d c12 c14 c20 c24
c26 c2a c2d c2e c33 c37 c3b c3f
c41 c45 c49 c4c c50 c53 c57 c5b
c5e c5f c64 c67 c6b c6c c71 c75
c79 c7a c7f c81 c85 c8c c8e c92
c96 c99 c9d ca1 ca5 ca6 cab cad
cb1 cb5 cb8 cba cbe cc0 ccc cd0
cd2 ceb ce7 ce6 cf3 ce3 d18 cfc
d00 d04 d08 d0b d0c d14 cfb d34
d23 cf8 d27 d28 d30 d22 d50 d3f
d1f d43 d44 d4c d3e d6c d5b d3b
d5f d60 d68 d5a d73 d57 d77 d7b
d7f d80 d87 d88 d8e d92 d93 d98
d9c da0 da4 da7 dab daf db3 db7
dbc dc1 dc2 dc4 dc8 dcc dcf dd0
dd5 dd9 dde de1 de6 de7 dec def
df3 df4 df9 dfc e01 e02 e07 e0a
e0e e0f e14 e17 e1b e1c e21 e24
e28 e29 e2e e31 e35 e36 e3b e3e
e42 e43 e48 e4b e4f e50 e55 e58
e5c e5d e62 e65 e6a e6b e70 e73
e78 e79 e7e e82 e86 e8a e8e e8f
e94 e98 e9d ea1 ea2 ea7 ea9 ead
eb1 eb4 eb8 ebc ebf ec3 ec4 ec9
ecb ecf ed3 ed6 ed8 edc ede eea
eee ef0 f22 f05 f06 f0a f0e f12
f15 f16 f1e f04 f3e f2d f01 f31
f32 f3a f2c f5a f49 f29 f4d f4e
f56 f48 f61 f45 f65 f69 f6d f6e
f75 f76 f7c f80 f81 f86 f8a f8e
f92 f95 f99 f9d fa0 fa1 fa6 faa
faf fb2 fb7 fb8 fbd fc0 fc4 fc5
fca fcd fd2 fd3 fd8 fdb fdf fe0
fe5 fe8 fec fed ff2 ff5 ff9 ffa
fff 1002 1007 1008 100d 1010 1015 1016
101b 101f 1023 1027 102b 102c 1031 1035
103a 103e 103f 1044 1046 104a 104e 1051
1055 1059 105c 1060 1061 1066 1068 106c
1070 1073 1075 1079 107b 1087 108b 108d
10bf 10a2 10a3 10a7 10ab 10af 10b2 10b3
10bb 10a1 10c6 10ca 109e 10da 10dd 10e1
10e5 10e9 10ec 10f0 10f4 10f7 10fb 10ff
1102 1103 1107 110b 110d 110e 1115 1119
111d 1120 1123 1128 1129 112e 1132 1136
1139 113c 1141 1142 1 1147 114c 1150
1154 1157 115a 115f 1160 1 1165 116a
116b 116f 1175 117a 117f 1181 118d 1191
1193 1197 119b 119f 11a1 11a5 11aa 11ad
11b1 11b2 11b7 11ba 11be 11c2 11c5 11c6
11cb 11ce 11d2 11d3 11d8 11db 11df 11e0
11e5 11e8 11ec 11ed 11f2 11f5 11f9 11fd
1200 1201 1206 1209 120d 120e 1213 1216
121b 121c 1221 1224 1228 1229 122e 1231
1235 1239 123c 123d 1242 1245 1249 124a
124f 1252 1257 1258 125d 1261 1265 1269
126a 126b 1270 1272 1276 127d 127f 1
1283 1287 128b 128e 1292 1296 1299 129d
129e 12a3 12a5 12a6 12ab 12af 12b1 12bd
12c1 12c3 12c5 12c7 12cb 12d7 12d9 12dc
12de 12e7 
512
2
0 :2 1 9 e 3 a 13 1c
1b 13 22 a :2 3 a 13 1c
1b 13 22 a :2 3 a 13 1c
1b 13 22 a :2 3 a 13 1c
1b 13 22 a :2 3 a 13 1c
1b 13 22 a :2 3 a 13 1c
1b 13 22 a 3 d 17 22
:3 17 21 :2 17 16 5 :2 3 :3 15 :2 5
:3 15 :2 5 13 :2 20 5 :4 9 8 7
:2 14 22 2e 37 :2 40 44 :2 7 1c
7 :2 14 1a 26 2f :2 38 :2 7 :5 5
e :2 1b 23 :2 e :2 5 :2 12 1f :2 5
3 :2 12 8 :2 15 1d :3 8 :2 15 22
:2 8 29 :4 5 19 :2 d :5 3 d 5
0 :2 3 10 19 18 :2 10 :2 5 :3 10
:2 5 10 19 18 :2 10 :2 5 10 19
18 :2 10 :2 5 c 0 :2 5 e 15
e 1f 1a 1f 1a :3 7 :6 5 c
0 :2 5 e 15 e 1f 1a 1f
1a :3 7 :6 5 c 0 :2 5 :2 e 19
14 19 d 14 16 :3 14 :3 7 :6 5
c 0 :2 5 :2 e 1c 17 1c d
16 1e 25 2f 39 43 1e 2c
:2 d 17 :3 7 :5 5 9 10 1a 5
9 :2 16 b e 11 :2 15 :2 b 1b
1e :2 b 21 24 :2 b 28 2b :2 b
2e 31 :2 35 :2 b 3a 3d :2 b :2 9
7 :2 16 9 14 :2 9 14 46 :3 14
31 15 1d :2 15 :2 14 26 29 31
39 3b :2 29 :2 14 :2 9 :2 15 1c :2 28
34 :2 9 1d :2 11 7 :2 1a 7 1a
9 :6 5 9 10 1b 5 9 :2 15
2c 2f 32 :2 36 :2 2c 3c 3f :2 2c
:2 9 7 :2 16 9 14 :2 9 14 46
:3 14 39 15 1d :2 15 :2 14 26 29
31 39 3b :2 29 :2 14 :2 9 :2 15 1c
:2 28 34 :2 9 1d :2 11 7 :2 1b 7
1b 9 :6 5 9 10 1a 5 9
14 24 27 :2 14 2a 2d :2 31 :2 14
37 3a :2 14 3d 40 :2 14 44 27
:2 14 2a 2d :2 31 :2 14 36 39 :2 14
:2 9 13 1c :2 9 7 :2 16 9 14
:2 9 14 45 :3 14 30 15 1d :2 15
:2 14 26 29 31 39 3b :2 29 :2 14
:2 9 :2 15 1c :2 28 34 :2 9 1d :2 11
7 :2 1a 7 1a 9 :6 5 :4 7 :2 1a
:2 7 5 :2 14 7 12 :2 7 12 44
14 :2 12 39 13 1b :2 13 :2 12 24
27 2f 37 39 :2 27 :2 12 :2 7 :2 13
1a :2 26 32 :2 7 1b :2 f 5 :2 3
:6 5 :2 e 1c e 9 e :2 9 :5 7
:2 16 2c :2 7 5 :2 14 9 14 :2 9
14 40 15 1d :2 15 :2 14 26 29
:2 14 2d 30 38 40 42 :2 30 :2 14
:2 9 :2 15 1c :2 28 1c 4c :3 1c :3 9
:2 15 1c :2 28 34 :2 9 1b :2 f 5
:2 3 :6 5 9 10 16 5 c :2 10
1c :3 19 b 16 23 26 :2 16 29
2c :2 30 :2 16 39 3c :2 16 3f 42
:2 16 :2 b 15 1e :2 b 21 :2 9 7
:2 16 9 14 :2 9 14 40 15 1d
:2 15 :2 14 26 29 :2 14 2d 30 38
40 42 :2 30 :2 14 :2 9 :2 15 1c :2 28
1c 4c :3 1c :3 9 :2 15 1c :2 28 34
:2 9 1d :2 11 7 :2 16 7 16 9
:6 5 :2 3 7 :4 3 d 21 2d :3 21
2d :3 21 2d 39 :2 21 20 4 :2 3
b 0 :2 4 :2 e 18 13 18 13
:3 7 :5 4 :4 9 c 13 1d 8 b
:2 18 1f 22 25 :2 29 :2 1f 2e 31
:2 1f 35 3f :2 b 1d c 8 1a
8 :2 15 1c 26 30 :2 8 :4 6 :6 3
d 1f 2a :2 1f 1e 5 :2 3 f
18 17 :2 f :2 5 f 18 17 :2 f
:2 5 f 18 17 :2 f :2 5 f 18
17 :2 f 5 :2 c 1d 2a 25 2a
25 :5 5 f :2 22 :2 5 12 1a 23
29 :2 12 5 :4 8 7 12 1b :3 12
3b 3e :2 12 45 48 :2 12 22 25
:2 12 2a 2d :2 12 37 3a :2 12 3c
3f :2 12 22 25 :2 12 2a 2d :2 12
37 3a :2 12 3c 3f :2 12 44 :3 12
:2 7 11 1a :7 7 1b 7 :2 16 29
:2 3b 29 :2 7 :4 5 :6 3 d 5 0
:2 3 d 16 15 :2 d :2 5 d 16
15 :2 d :2 5 d 16 15 :2 d 5
:2 c 1d 2a 25 2a 25 :5 5 f
:2 22 5 :4 8 7 12 1b :3 12 3c
40 :2 12 47 4a :2 12 27 2a :2 12
2c 2f :2 12 37 3a :2 12 3c 3f
:2 12 44 :3 12 :2 7 11 1a :7 7 1b
7 :2 16 29 :2 3b 29 :2 7 :4 5 :6 3
d 5 0 :2 3 d 16 15 :2 d
:2 5 c 0 :2 5 e :2 10 17 :2 19
2a :2 2c :2 e 1e e 7 :2 e :2 10
20 22 :2 20 e :2 10 20 22 :2 20
:3 e :2 10 20 22 :2 20 :2 e :4 7 :5 5
9 10 19 5 7 12 21 24
:2 12 27 2a :2 2e :2 12 34 37 :2 12
3a 3d :2 12 41 24 :2 12 27 2a
:2 2e :2 12 39 3c :2 12 3f :3 12 28
2c :2 12 2f 32 :2 36 :2 12 46 49
:2 12 4c :3 12 :2 7 11 1a :2 7 19
9 5 3 :2 12 6 :2 15 28 :2 3a
28 :2 6 19 :2 d :9 3 :5 1 
512
2
0 :4 1 :9 7 :9 8 :9 9 :9 a :9 b :9 c
:5 18 :4 19 18 1a :2 18 :4 1a :5 1b :5 1e
:5 20 :b 21 20 :a 23 :2 22 :2 20 :8 25 :6 28
1c :2 29 :6 2a :6 2b :3 2a :2 2d :4 29 :3 18
2e 3e 3f 0 :2 3e :6 3f :5 40 :7 41
:7 42 :2 43 0 :2 43 :a 44 :5 43 :2 45 0
:2 45 :a 46 :5 45 :2 47 0 :2 47 :5 48 :5 49
:4 48 :5 47 :2 4a 0 :2 4a :5 4b :7 4c :2 4d
:2 4c :4 4b :5 4a :4 50 :3 52 :1d 53 :2 52 51
:2 54 :3 56 :3 57 58 :2 57 58 :4 59 :2 57
:7 59 :3 57 :9 5a :4 54 :2 50 5b 50 5c
50 :5 5d :4 60 :10 62 61 :2 63 :3 65 :3 66
67 :2 66 67 :4 68 :2 66 :7 68 :3 66 :9 69
:4 63 :2 60 6a 60 6b 60 :5 6c :4 6f
:15 71 72 :2 71 :4 72 :2 71 :2 72 :3 71 :5 73
70 :2 74 :3 76 :3 77 78 :2 77 78 :4 79
:2 77 :7 79 :3 77 :9 7a :4 74 :2 6f 7b 6f
7c 6f :5 7d :3 81 :5 85 7f :2 86 :3 88
:3 89 8a :2 89 8a :4 8b :2 89 :7 8b :3 89
:9 8c :4 86 :2 4e 8d :5 8e :3 92 :4 93 94
:4 92 :6 96 91 :2 98 :3 9a :3 9b :4 9c :2 9b
:2 9c :2 9b :7 9c :3 9b :6 9d :2 9e 9f :2 9e
:2 9d :9 a0 :4 98 :2 4e a1 :5 a2 :4 a5 :7 a7
:15 a8 :5 a9 :3 a7 a6 :2 ab :3 ad :3 ae :4 af
:2 ae :2 af :2 ae :7 af :3 ae :6 b0 :2 b1 b2
:2 b1 :2 b0 :9 b3 :4 ab :2 a5 b4 a5 b5
a5 :5 b7 :2 4e b9 :3 3e b9 :5 c4 :4 c5
:5 c6 c4 c7 :2 c4 c7 0 :2 c7 :9 c8
:5 c7 :4 ca :4 cc :12 cd cc ce cc ca
:8 d0 :2 cf :2 ca :2 c9 :3 c4 d2 :6 dd de
:2 dd :6 de :7 df :7 e0 :7 e1 :b e4 :5 e7 :8 e9
:4 eb :3 ec ed :2 ec :2 ed :2 ec :2 ed :2 ec
:2 ee :2 ec :2 ee :2 ec :2 ee :2 ec :2 ee :2 ec
:2 ef :2 ec :2 ef :2 ec :2 ef :2 ec :2 ef :2 ec
ef f0 :3 ec :5 f1 :5 f2 eb :6 f4 f5
:2 f4 :2 f3 :2 eb :2 e2 :3 dd f7 104 105
0 :2 104 :6 105 :7 106 :7 107 :b 10a :5 10d :4 10f
:3 110 111 :2 110 :2 111 :2 110 :2 111 :2 110 :2 112
:2 110 :2 112 :2 110 :2 112 :2 110 :2 112 :2 110 112
113 :3 110 :5 114 :5 115 10f :6 117 118 :2 117
:2 116 :2 10f :2 108 :3 104 11a 120 121 0
:2 120 :6 121 :2 122 0 :2 122 :a 123 :5 124 :7 125
:7 126 :2 125 :7 127 :2 125 124 :3 123 :5 122 :4 129
:15 12b 12c :2 12b :4 12c :2 12b :2 12c :2 12b 12c
12d :2 12b :2 12d :2 12b :4 12d :2 12b :2 12d :2 12b
12d 12e :3 12b :5 12f 129 130 129 128
:2 131 :6 132 133 :2 132 :4 131 :3 120 134 :4 18
:5 1 
12e9
4
:3 0 1 :4 0 2
:3 0 5 :3 0 7
:2 0 5 3 :6 0
1 :2 0 6 :3 0
7 :2 0 3 7
9 :6 0 8 :4 0
d a b 50d
4 :6 0 c :2 0
9 5 :3 0 6
:3 0 7 10 12
:6 0 a :4 0 16
13 14 50d 9
:6 0 c :2 0 d
5 :3 0 6 :3 0
b 19 1b :6 0
d :4 0 1f 1c
1d 50d b :6 0
7 :2 0 11 5
:3 0 6 :3 0 f
22 24 :6 0 f
:4 0 28 25 26
50d e :6 0 7
:2 0 15 5 :3 0
6 :3 0 13 2b
2d :6 0 11 :4 0
31 2e 2f 50d
10 :6 0 1b 108
0 19 5 :3 0
6 :3 0 17 34
36 :6 0 13 :4 0
3a 37 38 50d
12 :6 0 14 :a 0
9d 2 :4 0 1f
:2 0 1d 6 :3 0
15 :7 0 3e 3d
:3 0 17 :3 0 16
:7 0 42 41 :3 0
24 151 0 22
44 :2 0 9d 3b
46 :2 0 19 :3 0
48 :7 0 4b 49
0 9b 18 :6 0
18 :3 0 19 :3 0
4d :7 0 50 4e
0 9b 1a :6 0
1b :3 0 1c :3 0
52 53 0 51
54 0 83 16
:3 0 1d :2 0 26
57 58 :3 0 59
:2 0 1b :3 0 1e
:3 0 5b 5c 0
18 :3 0 15 :3 0
1f :3 0 20 :3 0
60 61 0 16
:3 0 28 5d 64
:2 0 66 2d 73
1b :3 0 21 :3 0
67 68 0 18
:3 0 15 :3 0 1f
:3 0 20 :3 0 6c
6d 0 2f 69
6f :2 0 71 33
72 0 71 0
74 5a 66 0
74 35 0 83
1a :3 0 1b :3 0
22 :3 0 76 77
0 18 :3 0 38
78 7a 75 7b
0 83 1b :3 0
23 :3 0 7d 7e
0 18 :3 0 3a
7f 81 :2 0 83
3c 9c 24 :3 0
1b :3 0 25 :3 0
86 87 0 18
:3 0 41 88 8a
1b :3 0 23 :3 0
8c 8d 0 18
:3 0 43 8e 90
:2 0 92 45 93
8b 92 0 94
47 0 97 26
:5 0 97 53 99
4c 98 97 :2 0
9a 4e :2 0 9c
50 9c 9b 83
9a :6 0 9d 1
0 3b 46 9c
50d :2 0 27 :a 0
31a 3 :4 0 59
2ab 0 57 0
a1 :2 0 31a 9f
a2 :2 0 6 :3 0
29 :2 0 49 a4
a6 :6 0 a9 a7
0 318 28 :6 0
2e :2 0 5d 19
:3 0 ab :7 0 ae
ac 0 318 2a
:6 0 6 :3 0 2c
:2 0 5b b0 b2
:6 0 b5 b3 0
318 2b :9 0 61
6 :3 0 5f b7
b9 :6 0 bc ba
0 318 2d :6 0
2f :3 0 30 :a 0
4 cc :3 0 be
c1 0 bf :3 0
31 :3 0 32 :3 0
63 33 :3 0 66
c6 :2 0 c8 :5 0
c4 c7 0 c9
:6 0 ca :2 0 cd
be c1 ce 0
318 68 ce d0
cd cf :6 0 cc
1 :6 0 ce 2f
:3 0 34 :a 0 5
e0 :4 0 d2 d5
0 d3 :3 0 31
:3 0 32 :3 0 6a
35 :3 0 6d da
:2 0 dc :5 0 d8
db 0 dd :6 0
de :2 0 e1 d2
d5 e2 0 318
6f e2 e4 e1
e3 :6 0 e0 1
:6 0 e2 2f :3 0
36 :a 0 6 f8
:4 0 e6 e9 0
e7 :3 0 37 :3 0
71 38 :3 0 73
ed f3 0 f4
:3 0 39 :3 0 3a
:2 0 3b :4 0 77
f0 f2 :5 0 eb
ee 0 f5 :6 0
f6 :2 0 f9 e6
e9 fa 0 318
7a fa fc f9
fb :6 0 f8 1
:6 0 fa 2f :3 0
3c :a 0 7 116
:4 0 fe 101 0
ff :3 0 3d :3 0
7c 3e :3 0 7e
105 111 0 112
:3 0 3d :3 0 3f
:4 0 40 :4 0 41
:4 0 42 :4 0 43
:4 0 44 :4 0 45
:4 0 80 :3 0 107
108 110 :2 0 103
106 0 113 :6 0
114 :2 0 117 fe
101 118 0 318
88 118 11a 117
119 :6 0 116 1
:6 0 118 46 :3 0
30 :3 0 47 :3 0
11b 11c 48 :3 0
49 :3 0 11f 120
0 9 :3 0 4a
:2 0 46 :3 0 31
:3 0 124 125 0
8a 123 127 :3 0
4a :2 0 9 :3 0
8d 129 12b :3 0
4a :2 0 12 :3 0
90 12d 12f :3 0
4a :2 0 9 :3 0
93 131 133 :3 0
4a :2 0 46 :3 0
32 :3 0 136 137
0 96 135 139
:3 0 4a :2 0 9
:3 0 99 13b 13d
:3 0 9c 121 13f
:2 0 141 9e 16c
24 :3 0 2a :3 0
4b :3 0 144 145
0 167 2b :3 0
4c :4 0 4a :2 0
4d :4 0 a0 149
14b :3 0 4a :2 0
4e :3 0 2a :3 0
a3 14e 150 a5
14d 152 :3 0 4a
:2 0 4f :3 0 50
:3 0 7 :2 0 51
:2 0 a8 155 159
ac 154 15b :3 0
147 15c 0 167
52 :3 0 53 :3 0
15e 15f 0 52
:3 0 54 :3 0 161
162 0 2b :3 0
af 160 165 :2 0
167 ba 169 b6
168 167 :2 0 16a
b8 :2 0 16c 0
16c 16b 141 16a
:6 0 16e 8 :3 0
b2 170 47 :3 0
11e 16e :4 0 315
55 :3 0 173 174
:2 0 175 55 :5 0
172 :2 0 315 46
:3 0 36 :3 0 47
:3 0 176 177 56
:3 0 57 :3 0 17a
17b 0 9 :3 0
4a :2 0 46 :3 0
37 :3 0 17f 180
0 bf 17e 182
:3 0 4a :2 0 9
:3 0 c2 184 186
:3 0 c5 17c 188
:2 0 18a c7 1b5
24 :3 0 2a :3 0
4b :3 0 18d 18e
0 1b0 2b :3 0
4c :4 0 4a :2 0
58 :4 0 c9 192
194 :3 0 4a :2 0
4e :3 0 2a :3 0
cc 197 199 ce
196 19b :3 0 4a
:2 0 4f :3 0 50
:3 0 7 :2 0 51
:2 0 d1 19e 1a2
d5 19d 1a4 :3 0
190 1a5 0 1b0
52 :3 0 53 :3 0
1a7 1a8 0 52
:3 0 54 :3 0 1aa
1ab 0 2b :3 0
d8 1a9 1ae :2 0
1b0 e3 1b2 df
1b1 1b0 :2 0 1b3
e1 :2 0 1b5 0
1b5 1b4 18a 1b3
:6 0 1b7 a :3 0
db 1b9 47 :3 0
179 1b7 :4 0 315
55 :3 0 1bc 1bd
:2 0 1be 55 :5 0
1bb :2 0 315 46
:3 0 34 :3 0 47
:3 0 1bf 1c0 28
:3 0 59 :4 0 4a
:2 0 9 :3 0 e8
1c5 1c7 :3 0 4a
:2 0 46 :3 0 31
:3 0 1ca 1cb 0
eb 1c9 1cd :3 0
4a :2 0 9 :3 0
ee 1cf 1d1 :3 0
4a :2 0 12 :3 0
f1 1d3 1d5 :3 0
4a :2 0 9 :3 0
f4 1d7 1d9 :3 0
4a :2 0 46 :3 0
32 :3 0 1dc 1dd
0 f7 1db 1df
:3 0 4a :2 0 9
:3 0 fa 1e1 1e3
:3 0 1c3 1e4 0
1eb 14 :3 0 28
:4 0 fd 1e6 1e9
:2 0 1eb 100 216
24 :3 0 2a :3 0
4b :3 0 1ee 1ef
0 211 2b :3 0
5a :4 0 4a :2 0
5b :4 0 103 1f3
1f5 :3 0 4a :2 0
4e :3 0 2a :3 0
106 1f8 1fa 108
1f7 1fc :3 0 4a
:2 0 4f :3 0 50
:3 0 7 :2 0 51
:2 0 10b 1ff 203
10f 1fe 205 :3 0
1f1 206 0 211
52 :3 0 53 :3 0
208 209 0 52
:3 0 54 :3 0 20b
20c 0 2b :3 0
112 20a 20f :2 0
211 11d 213 119
212 211 :2 0 214
11b :2 0 216 0
216 215 1eb 214
:6 0 218 c :3 0
115 21a 47 :3 0
1c2 218 :4 0 315
55 :3 0 21d 21e
:2 0 21f 55 :5 0
21c :2 0 315 5c
:3 0 220 222 :2 0
228 0 5d :3 0
5e :3 0 223 224
0 225 227 :2 0
228 0 122 253
24 :3 0 2a :3 0
4b :3 0 22b 22c
0 24e 2b :3 0
4c :4 0 4a :2 0
5f :4 0 125 230
232 :3 0 4a :2 0
4e :3 0 2a :3 0
128 235 237 12a
234 239 :3 0 4a
:2 0 4f :3 0 50
:3 0 7 :2 0 51
:2 0 12d 23c 240
131 23b 242 :3 0
22e 243 0 24e
52 :3 0 53 :3 0
245 246 0 52
:3 0 54 :3 0 248
249 0 2b :3 0
134 247 24c :2 0
24e 13f 250 13b
24f 24e :2 0 251
13d :2 0 253 0
253 252 228 251
:6 0 315 3 :3 0
55 :3 0 257 258
:2 0 259 55 :5 0
256 :2 0 315 3d
:3 0 137 2d :3 0
60 :3 0 144 25e
:2 0 260 :4 0 263
264 :2 0 261 :2 0
25b 25f 0 146
0 262 :2 0 26c
61 :3 0 62 :3 0
266 267 0 2d
:3 0 148 268 26a
:2 0 26c 14a 2a4
24 :3 0 2a :3 0
4b :3 0 26f 270
0 29f 2b :3 0
63 :4 0 4a :2 0
4e :3 0 2a :3 0
14d 275 277 14f
274 279 :3 0 4a
:2 0 64 :4 0 152
27b 27d :3 0 4a
:2 0 4f :3 0 50
:3 0 7 :2 0 51
:2 0 155 280 284
159 27f 286 :3 0
272 287 0 29f
52 :3 0 53 :3 0
289 28a 0 52
:3 0 54 :3 0 28c
28d 0 65 :4 0
4a :2 0 66 :4 0
15c 290 292 :3 0
15f 28b 294 :2 0
29f 52 :3 0 53
:3 0 296 297 0
52 :3 0 54 :3 0
299 29a 0 2b
:3 0 162 298 29d
:2 0 29f 16e 2a1
16a 2a0 29f :2 0
2a2 16c :2 0 2a4
0 2a4 2a3 26c
2a2 :6 0 315 3
:3 0 55 :3 0 2a8
2a9 :2 0 2aa 55
:5 0 2a7 :2 0 315
46 :3 0 3c :3 0
47 :3 0 2ab 2ac
46 :3 0 3d :3 0
2af 2b0 0 67
:3 0 68 :2 0 165
2b3 2b4 :3 0 28
:3 0 69 :4 0 4a
:2 0 9 :3 0 174
2b8 2ba :3 0 4a
:2 0 46 :3 0 3d
:3 0 2bd 2be 0
177 2bc 2c0 :3 0
4a :2 0 9 :3 0
17a 2c2 2c4 :3 0
4a :2 0 6a :4 0
17d 2c6 2c8 :3 0
2b6 2c9 0 2d0
14 :3 0 28 :4 0
180 2cb 2ce :2 0
2d0 183 2d1 2b5
2d0 0 2d2 186
0 2d3 188 30b
24 :3 0 2a :3 0
4b :3 0 2d6 2d7
0 306 2b :3 0
63 :4 0 4a :2 0
4e :3 0 2a :3 0
18a 2dc 2de 18c
2db 2e0 :3 0 4a
:2 0 64 :4 0 18f
2e2 2e4 :3 0 4a
:2 0 4f :3 0 50
:3 0 7 :2 0 51
:2 0 192 2e7 2eb
196 2e6 2ed :3 0
2d9 2ee 0 306
52 :3 0 53 :3 0
2f0 2f1 0 52
:3 0 54 :3 0 2f3
2f4 0 65 :4 0
4a :2 0 6b :4 0
199 2f7 2f9 :3 0
19c 2f2 2fb :2 0
306 52 :3 0 53
:3 0 2fd 2fe 0
52 :3 0 54 :3 0
300 301 0 2b
:3 0 19f 2ff 304
:2 0 306 1ab 308
1a7 307 306 :2 0
309 1a9 :2 0 30b
0 30b 30a 2d3
309 :6 0 30d 10
:3 0 1a5 30f 47
:3 0 2ae 30d :4 0
315 55 :3 0 312
313 :2 0 314 55
:5 0 311 :2 0 315
1c7 319 :3 0 319
27 :3 0 1be 319
318 315 316 :6 0
31a 1 0 9f
a2 319 50d :2 0
6c :a 0 36e 12
:4 0 1bc ba1 0
1a2 6 :3 0 6d
:7 0 31f 31e :3 0
1b6 :2 0 1ba 6
:3 0 6e :7 0 323
322 :3 0 6 :4 0
6f :7 0 328 326
327 :2 0 2f :3 0
32a :2 0 36e 31c
32c :2 0 30 :a 0
13 33b :4 0 32e
331 0 32f :3 0
32 :3 0 1b4 33
:3 0 1b1 335 :2 0
337 :5 0 333 336
0 338 :6 0 339
:2 0 33c 32e 331
33d 0 36c 1d5
33d 33f 33c 33e
:6 0 33b 1 :6 0
33d 6f :3 0 70
:2 0 1d7 341 342
:3 0 46 :3 0 30
:3 0 47 :3 0 344
345 48 :3 0 71
:3 0 348 349 0
9 :3 0 4a :2 0
46 :3 0 32 :3 0
34d 34e 0 1d9
34c 350 :3 0 4a
:2 0 9 :3 0 1dc
352 354 :3 0 6d
:3 0 6e :3 0 1df
34a 358 :2 0 35a
1e3 35c 47 :3 0
347 35a :4 0 35d
1e5 368 48 :3 0
71 :3 0 35e 35f
0 6f :3 0 6d
:3 0 6e :3 0 1e7
360 364 :2 0 366
1eb 367 0 366
0 369 343 35d
0 369 1ed 0
36a 1f4 36d :3 0
36d 1f2 36d 36c
36a 36b :6 0 36e
1 0 31c 32c
36d 50d :2 0 72
:a 0 3ff 15 :4 0
1f9 :2 0 1f7 6
:3 0 73 :7 0 373
372 :3 0 75 :2 0
1fd 375 :2 0 3ff
370 377 :2 0 6
:3 0 75 :2 0 1fb
379 37b :6 0 37e
37c 0 3fd 74
:6 0 29 :2 0 201
6 :3 0 1ff 380
382 :6 0 385 383
0 3fd 76 :6 0
78 :2 0 205 6
:3 0 203 387 389
:6 0 38c 38a 0
3fd 28 :6 0 20b
:2 0 209 6 :3 0
207 38e 390 :6 0
393 391 0 3fd
77 :6 0 79 :3 0
74 :3 0 79 :3 0
20d 398 :2 0 39a
:4 0 39c 39d :5 0
395 399 0 20f
0 39b :2 0 3fb
76 :3 0 5d :3 0
7a :3 0 3a0 3a1
0 39f 3a2 0
3fb 77 :3 0 7b
:3 0 73 :3 0 8
:4 0 7c :4 0 211
3a5 3a9 3a4 3aa
0 3fb 76 :3 0
1d :2 0 215 3ad
3ae :3 0 28 :3 0
7d :4 0 4a :2 0
7e :4 0 217 3b2
3b4 :3 0 4a :2 0
76 :3 0 21a 3b6
3b8 :3 0 4a :2 0
7f :4 0 21d 3ba
3bc :3 0 4a :2 0
4 :3 0 220 3be
3c0 :3 0 4a :2 0
74 :3 0 223 3c2
3c4 :3 0 4a :2 0
4 :3 0 226 3c6
3c8 :3 0 4a :2 0
10 :3 0 229 3ca
3cc :3 0 4a :2 0
4 :3 0 22c 3ce
3d0 :3 0 4a :2 0
77 :3 0 22f 3d2
3d4 :3 0 4a :2 0
4 :3 0 232 3d6
3d8 :3 0 4a :2 0
80 :4 0 235 3da
3dc :3 0 4a :2 0
81 :4 0 238 3de
3e0 :3 0 3b0 3e1
0 3ed 14 :3 0
28 :3 0 82 :3 0
23b 3e3 3e6 :2 0
3ed 55 :3 0 3ea
3eb :2 0 3ec 55
:5 0 3e9 :2 0 3ed
23e 3f9 83 :3 0
84 :3 0 3ee 3ef
0 85 :3 0 86
:3 0 3f1 3f2 0
87 :3 0 242 3f0
3f5 :2 0 3f7 245
3f8 0 3f7 0
3fa 3af 3ed 0
3fa 247 0 3fb
254 3fe :3 0 3fe
24f 3fe 3fd 3fb
3fc :6 0 3ff 1
0 370 377 3fe
50d :2 0 5c :a 0
46d 16 :4 0 75
:2 0 24a 0 403
:2 0 46d 401 404
:2 0 6 :3 0 75
:2 0 24d 406 408
:6 0 40b 409 0
46b 74 :6 0 29
:2 0 25c 6 :3 0
25a 40d 40f :6 0
412 410 0 46b
76 :6 0 262 :2 0
260 6 :3 0 25e
414 416 :6 0 419
417 0 46b 28
:6 0 79 :3 0 74
:3 0 79 :3 0 264
41e :2 0 420 :4 0
422 423 :5 0 41b
41f 0 266 0
421 :2 0 469 76
:3 0 5d :3 0 7a
:3 0 426 427 0
425 428 0 469
76 :3 0 1d :2 0
268 42b 42c :3 0
28 :3 0 7d :4 0
4a :2 0 88 :4 0
26a 430 432 :3 0
4a :2 0 76 :3 0
26d 434 436 :3 0
4a :2 0 7f :4 0
270 438 43a :3 0
4a :2 0 4 :3 0
273 43c 43e :3 0
4a :2 0 74 :3 0
276 440 442 :3 0
4a :2 0 4 :3 0
279 444 446 :3 0
4a :2 0 80 :4 0
27c 448 44a :3 0
4a :2 0 81 :4 0
27f 44c 44e :3 0
42e 44f 0 45b
14 :3 0 28 :3 0
82 :3 0 282 451
454 :2 0 45b 55
:3 0 458 459 :2 0
45a 55 :5 0 457
:2 0 45b 285 467
83 :3 0 84 :3 0
45c 45d 0 85
:3 0 86 :3 0 45f
460 0 87 :3 0
289 45e 463 :2 0
465 28c 466 0
465 0 468 42d
45b 0 468 28e
0 469 299 46c
:3 0 46c 295 46c
46b 469 46a :6 0
46d 1 0 401
404 46c 50d :2 0
89 :a 0 507 17
:7 0 29e 0 471
:2 0 507 46f 472
:2 0 6 :3 0 2c
:2 0 291 474 476
:6 0 479 477 0
505 28 :6 0 2f
:3 0 8a :a 0 18
4ab :3 0 47b 47e
0 47c :3 0 8b
:3 0 31 :3 0 47f
480 0 8b :3 0
8c :3 0 482 483
0 8b :3 0 8d
:3 0 485 486 0
2a0 8e :3 0 8b
:3 0 489 48a 2a4
48c 4a6 0 4a7
:3 0 8b :3 0 8f
:3 0 48e 48f 0
3a :2 0 90 :4 0
2a8 491 493 :3 0
8b :3 0 91 :3 0
495 496 0 3a
:2 0 91 :4 0 2ad
498 49a :3 0 494
49c 49b :2 0 8b
:3 0 92 :3 0 49e
49f 0 3a :2 0
93 :4 0 2b2 4a1
4a3 :3 0 49d 4a5
4a4 :4 0 488 48d
0 4a8 :6 0 4a9
:2 0 4ac 47b 47e
4ad 0 505 2b5
4ad 4af 4ac 4ae
:6 0 4ab 1 :6 0
4ad 46 :3 0 8a
:3 0 47 :3 0 4b0
4b1 28 :3 0 94
:4 0 4a :2 0 9
:3 0 2b7 4b6 4b8
:3 0 4a :2 0 46
:3 0 31 :3 0 4bb
4bc 0 2ba 4ba
4be :3 0 4a :2 0
9 :3 0 2bd 4c0
4c2 :3 0 4a :2 0
12 :3 0 2c0 4c4
4c6 :3 0 4a :2 0
9 :3 0 2c3 4c8
4ca :3 0 4a :2 0
46 :3 0 8d :3 0
4cd 4ce 0 2c6
4cc 4d0 :3 0 4a
:2 0 9 :3 0 2c9
4d2 4d4 :3 0 4a
:2 0 95 :4 0 2cc
4d6 4d8 :3 0 4a
:2 0 9 :3 0 2cf
4da 4dc :3 0 4a
:2 0 46 :3 0 8c
:3 0 4df 4e0 0
2d2 4de 4e2 :3 0
4a :2 0 9 :3 0
2d5 4e4 4e6 :3 0
4a :2 0 96 :4 0
2d8 4e8 4ea :3 0
4b4 4eb 0 4f2
14 :3 0 28 :4 0
2db 4ed 4f0 :2 0
4f2 2de 4f4 47
:3 0 4b3 4f2 :4 0
4f5 2e1 506 24
:3 0 83 :3 0 84
:3 0 4f8 4f9 0
85 :3 0 86 :3 0
4fb 4fc 0 97
:3 0 2e3 4fa 4ff
:2 0 501 2ef 503
2e8 502 501 :2 0
504 2ea :2 0 506
2ec 506 505 4f5
504 :6 0 507 1
0 46f 472 506
50d :3 0 50c 0
50c :3 0 50c 50d
50a 50b :6 0 50e
:2 0 2f2 0 4
50c 510 :2 0 2
50e 511 :8 0 
2ff
4
:3 0 1 8 1
5 1 11 1
e 1 1a 1
17 1 23 1
20 1 2c 1
29 1 35 1
32 1 3c 1
40 2 3f 43
1 45 1 4c
1 56 4 5e
5f 62 63 1
65 3 6a 6b
6e 1 70 2
73 72 1 79
1 80 4 55
74 7c 82 1
89 1 8f 1
91 1 93 1
a5 0 1 85
1 99 2 4a
4f 3 94 96
9e 1 a0 1
aa 1 b1 1
af 1 b8 1
b6 2 c2 c3
1 c5 1 cb
2 d6 d7 1
d9 1 df 1
ea 1 ec 1
f1 2 ef f1
1 f7 1 102
1 104 7 109
10a 10b 10c 10d
10e 10f 1 115
2 122 126 2
128 12a 2 12c
12e 2 130 132
2 134 138 2
13a 13c 1 13e
1 140 2 148
14a 1 14f 2
14c 151 3 156
157 158 2 153
15a 2 163 164
1 16c 0 166
1 143 1 169
4 146 15d 166
16d 2 17d 181
2 183 185 1
187 1 189 2
191 193 1 198
2 195 19a 3
19f 1a0 1a1 2
19c 1a3 2 1ac
1ad 1 1b5 0
1af 1 18c 1
1b2 4 18f 1a6
1af 1b6 2 1c4
1c6 2 1c8 1cc
2 1ce 1d0 2
1d2 1d4 2 1d6
1d8 2 1da 1de
2 1e0 1e2 2
1e7 1e8 2 1e5
1ea 2 1f2 1f4
1 1f9 2 1f6
1fb 3 200 201
202 2 1fd 204
2 20d 20e 1
216 0 210 1
1ed 1 213 4
1f0 207 210 217
2 221 226 2
22f 231 1 236
2 233 238 3
23d 23e 23f 2
23a 241 2 24a
24b 1 25a 0
24d 1 22a 1
250 4 22d 244
24d 254 1 25d
1 25c 1 269
2 265 26b 1
276 2 273 278
2 27a 27c 3
281 282 283 2
27e 285 2 28f
291 2 28e 293
2 29b 29c 2
2b1 2b2 1 2b2
1 26e 1 2a1
5 271 288 295
29e 2a5 2 2b7
2b9 2 2bb 2bf
2 2c1 2c3 2
2c5 2c7 2 2cc
2cd 2 2ca 2cf
1 2d1 1 2d2
1 2dd 2 2da
2df 2 2e1 2e3
3 2e8 2e9 2ea
2 2e5 2ec 2
2f6 2f8 2 2f5
2fa 2 302 303
1 31d 0 1
30b 1 2d5 1
308 5 2d8 2ef
2fc 305 30c 1
334 0 1 332
3 320 324 329
1 325 1 321
8 a8 ad b4
bb cc e0 f8
116 d 170 175
1b9 1be 21a 21f
253 259 2a4 2aa
30f 314 31b 1
33a 1 340 2
34b 34f 2 351
353 3 355 356
357 1 359 1
35c 3 361 362
363 1 365 2
368 367 1 369
1 33b 2 369
36f 1 371 1
374 1 37a 1
376 1 381 1
37f 1 388 1
386 1 38f 1
38d 1 394 1
397 1 396 3
3a6 3a7 3a8 1
3ac 2 3b1 3b3
2 3b5 3b7 2
3b9 3bb 2 3bd
3bf 2 3c1 3c3
2 3c5 3c7 2
3c9 3cb 2 3cd
3cf 2 3d1 3d3
2 3d5 3d7 2
3d9 3db 2 3dd
3df 2 3e4 3e5
3 3e2 3e7 3ec
2 3f3 3f4 1
3f6 2 3f9 3f8
1 402 0 1
407 4 37d 384
38b 392 5 39e
3a3 3ab 3fa 400
1 40e 1 40c
1 415 1 413
1 41a 1 41d
1 41c 1 42a
2 42f 431 2
433 435 2 437
439 2 43b 43d
2 43f 441 2
443 445 2 447
449 2 44b 44d
2 452 453 3
450 455 45a 2
461 462 1 464
2 467 466 1
475 0 468 3
40a 411 418 4
424 429 468 46e
1 470 3 481
484 487 1 48b
1 492 2 490
492 1 499 2
497 499 1 4a2
2 4a0 4a2 1
4aa 2 4b5 4b7
2 4b9 4bd 2
4bf 4c1 2 4c3
4c5 2 4c7 4c9
2 4cb 4cf 2
4d1 4d3 2 4d5
4d7 2 4d9 4db
2 4dd 4e1 2
4e3 4e5 2 4e7
4e9 2 4ee 4ef
2 4ec 4f1 1
4f4 2 4fd 4fe
1 500 1 4f7
1 503 2 478
4ab 2 500 508
:2 c 15 1e 27
30 39 9d 31a
36e 3ff 46d 507

1
4
0 
510
1
1
28
19
2d
0 1 1 3 3 3 3 3
8 3 a 3 c 3 3 3
10 1 12 12 1 1 1 17
17 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0

3c 2 0
31d 12 0
4 0 1
32e 12 13
e6 3 6
be 3 4
46f 1 17
325 12 0
401 1 16
32 1 0
e 1 0
4c 2 0
d2 3 5
20 1 0
38d 15 0
4b0 19 0
344 14 0
2ab 10 0
1bf c 0
176 a 0
11b 8 0
321 12 0
31c 1 12
fe 3 7
3b 1 2
af 3 0
370 1 15
9f 1 3
40 2 0
47b 17 18
aa 3 0
45 2 0
470 17 0
413 16 0
386 15 0
a0 3 0
5 1 0
371 15 0
29 1 0
40c 16 0
402 16 0
37f 15 0
376 15 0
b6 3 0
17 1 0
0

/
