Rem
Rem $Header: rmrepapi.sql 03-may-99.18:32:39 arrajara Exp $
Rem
Rem rmrepapi.sql
Rem
Rem  Copyright (c) Oracle Corporation 1999. All Rights Reserved.
Rem
Rem    NAME
Rem      rmrepapi.sql - Remove java RepAPI specific objects from db
Rem
Rem    DESCRIPTION
Rem
Rem    NOTES
Rem      Inverse of initrepapi.sql
Rem      Assumption: To be executed by connecting as 'internal'
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    arrajara    05/03/00 - dbms_orb_context -> sns_context
Rem    arrajara    10/29/99 - Drop RepAPI objects and unpublish
Rem    arrajara    10/29/99 - Created
Rem


--### Dropjava
DECLARE
   cur      INTEGER;
   ret      INTEGER;
   drop_sql VARCHAR2(200);
BEGIN
 cur := dbms_sql.open_cursor;

 FOR class_cursor IN (SELECT dbms_java.longname(object_name) cname, 
                             object_type otype
                             FROM sys.all_objects 
                               WHERE dbms_java.longname(object_name) 
                                 LIKE '%repapi%')  LOOP
     IF class_cursor.otype = 'JAVA CLASS' THEN
       drop_sql := 'DROP JAVA CLASS "' || class_cursor.cname || '"';
       dbms_sql.parse(cur, drop_sql, dbms_sql.v7);
       ret := dbms_sql.execute(cur);
     ELSIF class_cursor.otype = 'SYNONYM' THEN
       drop_sql := 'DROP PUBLIC SYNONYM "' || class_cursor.cname || '"';
       dbms_sql.parse(cur, drop_sql, dbms_sql.v7);
       ret := dbms_sql.execute(cur);
     END IF;
 END LOOP;
 COMMIT;

 dbms_sql.close_cursor(cur);

 EXCEPTION WHEN OTHERS THEN 
   IF dbms_sql.is_open(cur) THEN
     dbms_sql.close_cursor(cur);
   END IF;
   dbms_system.ksdwrt(2, 'Exception in rmrepapi.sql: dropjava: ' ||
                            TO_CHAR(SQLCODE) || ': ' || SQLERRM);
   RAISE;
END;
/

--### Unpublish
DECLARE
  objectname VARCHAR2 (256);  
  rootinode NUMBER;
  etcinode NUMBER;
BEGIN
  objectname := 'repapi';
  rootinode := 1;

  SELECT child INTO etcinode FROM sns$bindings$
    WHERE parent = 1 AND id = 'etc';

  sns_context.unlink (etcinode, objectname);
  COMMIT;

  EXCEPTION WHEN OTHERS THEN 
   dbms_system.ksdwrt(2, 'Exception in rmrepapi.sql: unpublish: ' ||
                            TO_CHAR(SQLCODE) || ': ' || SQLERRM);
   RAISE;
END;
/
