create or replace 
package STANDARD is              -- careful on this line; SED edit occurs!

  type BOOLEAN is (FALSE, TRUE);

  type DATE is DATE_BASE;

  type NUMBER is NUMBER_BASE;
  subtype FLOAT is NUMBER; -- NUMBER(126)
  subtype REAL is FLOAT; -- FLOAT(63)
  subtype "DOUBLE PRECISION" is FLOAT;

-- other number subtypes
  subtype INTEGER is NUMBER(38,0);
  subtype INT is INTEGER;
  subtype SMALLINT is NUMBER(38,0);
  subtype DECIMAL is NUMBER(38,0);
  subtype NUMERIC is DECIMAL;
  subtype DEC is DECIMAL;


  subtype BINARY_INTEGER is INTEGER range '-2147483647'..2147483647;
--                used to be -2147483648 - less than MAXSB4MINVAL
  subtype NATURAL is BINARY_INTEGER range 0..2147483647;
  subtype NATURALN is NATURAL not null;
  subtype POSITIVE is BINARY_INTEGER range 1..2147483647;
  subtype POSITIVEN is POSITIVE not null;
  subtype SIGNTYPE is BINARY_INTEGER range '-1'..1;  -- for SIGN functions

  type VARCHAR2 is NEW CHAR_BASE;
  pragma PACK(VARCHAR2);

  subtype VARCHAR is VARCHAR2;
  subtype STRING is VARCHAR2;

  subtype LONG is VARCHAR2(32760);

  subtype RAW is VARCHAR2;
  subtype "LONG RAW" is RAW(32760);

  subtype ROWID is VARCHAR2(256);

  -- Ansi fixed-length char
  -- Define synonyms for CHAR and CHARN.
  subtype CHAR is VARCHAR2;
  subtype CHARACTER is CHAR;

  type MLSLABEL is new CHAR_BASE;
--  subtype MLSLABEL is MLSLABEL_BASE(256); 

-- Large object data types.
--  binary, character, character file, binary file.
  type  BLOB is BLOB_BASE;
  type  CLOB is CLOB_BASE;
-- no CFILE in 8.0.2
-- type  CFILE is CFILE_BASE;
  type  BFILE is BFILE_BASE;

-- Verbose and NCHAR type names
  subtype "CHARACTER VARYING" is VARCHAR;
  subtype "CHAR VARYING" is VARCHAR;
  subtype "NATIONAL CHARACTER" is CHAR CHARACTER SET NCHAR_CS;
  subtype "NATIONAL CHAR" is CHAR CHARACTER SET NCHAR_CS;
  subtype "NCHAR" is CHAR CHARACTER SET NCHAR_CS;
  subtype "NATIONAL CHARACTER VARYING" is VARCHAR CHARACTER SET NCHAR_CS;
  subtype "NATIONAL CHAR VARYING" is VARCHAR CHARACTER SET NCHAR_CS;
  subtype "NCHAR VARYING" is VARCHAR CHARACTER SET NCHAR_CS;
  subtype "NVARCHAR2" is VARCHAR2 CHARACTER SET NCHAR_CS;
  subtype "CHARACTER LARGE OBJECT" is CLOB;
  subtype "CHAR LARGE OBJECT" is CLOB;
  subtype "NATIONAL CHARACTER LARGE OBJEC" is CLOB CHARACTER SET NCHAR_CS;
  subtype "NCHAR LARGE OBJECT" is CLOB CHARACTER SET NCHAR_CS;
  subtype "NCLOB" is CLOB CHARACTER SET NCHAR_CS;
  subtype "BINARY LARGE OBJECT" is BLOB;

--***************** Predefined exceptions *****************

  CURSOR_ALREADY_OPEN exception;
    pragma EXCEPTION_INIT(CURSOR_ALREADY_OPEN, '-6511');

  DUP_VAL_ON_INDEX exception;
    pragma EXCEPTION_INIT(DUP_VAL_ON_INDEX, '-0001');

  TIMEOUT_ON_RESOURCE exception;
    pragma EXCEPTION_INIT(TIMEOUT_ON_RESOURCE, '-0051');

--TRANSACTION_BACKED_OUT exception;
--  pragma EXCEPTION_INIT(TRANSACTION_BACKED_OUT, '-0061');

  INVALID_CURSOR exception;
    pragma EXCEPTION_INIT(INVALID_CURSOR, '-1001');

  NOT_LOGGED_ON exception;
    pragma EXCEPTION_INIT(NOT_LOGGED_ON, '-1012');

  LOGIN_DENIED exception;
    pragma EXCEPTION_INIT(LOGIN_DENIED, '-1017');

  NO_DATA_FOUND exception;
    pragma EXCEPTION_INIT(NO_DATA_FOUND, 100);

  ZERO_DIVIDE exception;
    pragma EXCEPTION_INIT(ZERO_DIVIDE, '-1476');

  INVALID_NUMBER exception;
    pragma EXCEPTION_INIT(INVALID_NUMBER, '-1722');

  TOO_MANY_ROWS exception;
    pragma EXCEPTION_INIT(TOO_MANY_ROWS, '-1422');

  STORAGE_ERROR exception;
    pragma EXCEPTION_INIT(STORAGE_ERROR, '-6500');

  PROGRAM_ERROR exception;
    pragma EXCEPTION_INIT(PROGRAM_ERROR, '-6501');

  VALUE_ERROR exception;
    pragma EXCEPTION_INIT(VALUE_ERROR, '-6502');

  ACCESS_INTO_NULL exception;
    pragma EXCEPTION_INIT(ACCESS_INTO_NULL, '-6530');

  COLLECTION_IS_NULL exception;
    pragma EXCEPTION_INIT(COLLECTION_IS_NULL , '-6531');

  SUBSCRIPT_OUTSIDE_LIMIT exception;
    pragma EXCEPTION_INIT(SUBSCRIPT_OUTSIDE_LIMIT,'-6532');

  SUBSCRIPT_BEYOND_COUNT exception;
    pragma EXCEPTION_INIT(SUBSCRIPT_BEYOND_COUNT ,'-6533');


--****************************************************************

  function "EXISTS" return BOOLEAN;
    pragma BUILTIN('EXISTS',10,240,240); -- This is special cased in PH2 -- Pj

  function GREATEST (pattern NUMBER) return NUMBER;
    pragma BUILTIN('GREATEST',12,240,240);-- This is special cased in PH2 -- Pj
  function GREATEST (pattern VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET pattern%CHARSET;
    pragma BUILTIN('GREATEST',12,240,240);-- This is special cased in PH2 -- Pj
  function GREATEST (pattern DATE) return DATE;
    pragma BUILTIN('GREATEST',12,240,240);-- This is special cased in PH2 -- Pj

  function LEAST (pattern NUMBER) return NUMBER;
    pragma BUILTIN('LEAST',13,240,240);-- This is special cased in PH2 -- Pj
  function LEAST (pattern VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET pattern%CHARSET;
    pragma BUILTIN('LEAST',13,240,240);-- This is special cased in PH2 -- Pj
  function LEAST (pattern DATE) return DATE;
    pragma BUILTIN('LEAST',13,240,240);-- This is special cased in PH2 -- Pj

  function DECODE (expr NUMBER, pat NUMBER, res NUMBER) return NUMBER;
    pragma BUILTIN('DECODE',22,240,240);-- This is special cased in PH2 -- Pj
  function DECODE (expr NUMBER,
                   pat NUMBER,
                   res VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET res%CHARSET;
    pragma BUILTIN('DECODE',22,240,240);-- This is special cased in PH2 -- Pj
  function DECODE (expr NUMBER, pat NUMBER, res DATE) return DATE;
    pragma BUILTIN('DECODE',22,240,240);-- This is special cased in PH2 -- Pj

  function DECODE (expr VARCHAR2 CHARACTER SET ANY_CS,
                   pat VARCHAR2 CHARACTER SET expr%CHARSET,
                   res NUMBER) return NUMBER;
    pragma BUILTIN('DECODE',22,240,240);-- This is special cased in PH2 -- Pj
  function DECODE (expr VARCHAR2 CHARACTER SET ANY_CS,
                   pat VARCHAR2 CHARACTER SET expr%CHARSET,
                   res VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET res%CHARSET;
    pragma BUILTIN('DECODE',22,240,240);-- This is special cased in PH2 -- Pj
  function DECODE (expr VARCHAR2 CHARACTER SET ANY_CS,
                   pat VARCHAR2 CHARACTER SET expr%CHARSET,
                   res DATE) return DATE;
    pragma BUILTIN('DECODE',22,240,240);-- This is special cased in PH2 -- Pj

  function DECODE (expr DATE, pat DATE, res NUMBER) return NUMBER;
    pragma BUILTIN('DECODE',22,240,240);-- This is special cased in PH2 -- Pj
  function DECODE (expr DATE,
                   pat DATE,
                   res VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET res%CHARSET;
    pragma BUILTIN('DECODE',22,240,240);-- This is special cased in PH2 -- Pj
  function DECODE (expr DATE, pat DATE, res DATE) return DATE;
    pragma BUILTIN('DECODE',22,240,240);-- This is special cased in PH2 -- Pj

  function SQLCODE return NUMBER;
    pragma BUILTIN('SQLCODE',45, 10, 0); -- PEMS_DB, DB_SQLCODE

  function SQLERRM return varchar2;
    pragma FIPSFLAG('SQLERRM', 1452);   

  function SQLERRM (code NUMBER) return varchar2;
    pragma BUILTIN('SQLERRM',46, 10, 1); -- PEMS_DB, DB_SQLERRM
    pragma FIPSFLAG('SQLERRM', 1452);   

  function LEVEL return NUMBER;

  function ROWNUM return NUMBER;

  function '='  (LEFT BOOLEAN, RIGHT BOOLEAN) return BOOLEAN;
    pragma BUILTIN('=',2, 3, 1); -- PEMS_INTEGER, PEMDCMEQ
    pragma FIPSFLAG('=', 1450); 
  function '!=' (LEFT BOOLEAN, RIGHT BOOLEAN) return BOOLEAN; -- also <> and ~=
    pragma BUILTIN('!=',5, 3, 2); -- PEMS_INTEGER, PEMDCMNE
    pragma FIPSFLAG('!=', 1450);        
  function '<'  (LEFT BOOLEAN, RIGHT BOOLEAN) return BOOLEAN;
    pragma BUILTIN('<',4, 3, 3);  -- PEMS_INTEGER, PEMDCMLT
    pragma FIPSFLAG('<', 1450); 
  function '<=' (LEFT BOOLEAN, RIGHT BOOLEAN) return BOOLEAN;
    pragma BUILTIN('<=',6, 3, 4); -- PEMS_INTEGER, PEMDCMLE
    pragma FIPSFLAG('<=', 1450);        
  function '>'  (LEFT BOOLEAN, RIGHT BOOLEAN) return BOOLEAN;
    pragma BUILTIN('>',1, 3, 5); -- PEMS_INTEGER, PEMDCMGT
    pragma FIPSFLAG('>', 1450); 
  function '>=' (LEFT BOOLEAN, RIGHT BOOLEAN) return BOOLEAN;
    pragma BUILTIN('>=',3, 3, 6); -- PEMS_INTEGER, PEMDMGE
    pragma FIPSFLAG('>=', 1450);        

  --  Since SQL permits short-circuit evaluation, the 'and' and 'or'
  --  operations will always be interpreted as 'and then' and 'or else'
  --  when they occur in conditional statements.

  function XOR (LEFT BOOLEAN, RIGHT BOOLEAN) return BOOLEAN;
    pragma BUILTIN('XOR',8, 3, 9); -- PEMS_INTEGER, INT_XOR
    pragma FIPSFLAG('XOR', 1450);       

  function 'NOT' (RIGHT BOOLEAN) return BOOLEAN;
    pragma BUILTIN('NOT',9, 3, 10); -- PEMS_INTEGER, INT_NOT

  function 'IS NULL' (B BOOLEAN) return BOOLEAN;
    pragma BUILTIN('IS NULL', 0, 3, 0);  -- PEMS_INTEGER, PEMDNUL
    pragma FIPSFLAG('IS NULL', 1450);   

  function 'IS NOT NULL' (B BOOLEAN) return BOOLEAN;
    pragma FIPSFLAG('IS NOT NULL', 1450);       

  function NVL (B1 BOOLEAN, B2 BOOLEAN) return BOOLEAN;
    pragma FIPSFLAG('NVL', 1450);       

--****************************************************************

  function '='  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                 RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET) return BOOLEAN;
    pragma BUILTIN('=',2, 1, 14); -- PEMS_CHAR, PEMDCMEQ (VARCHAR2 SEMANTICS)
    pragma FIPSFLAG('=', 1454); 
  function '!=' (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                 RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET) return BOOLEAN;
    pragma BUILTIN('!=',5, 1, 15);  -- PEMS_CHAR, PEMDCMNE (VARCHAR2 SEMANTICS)
    pragma FIPSFLAG('!=', 1454);        
  function '<'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                 RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET) return BOOLEAN;
    pragma BUILTIN('<',4, 1, 16); -- PEMS_CHAR, PEMDCMLT (VARCHAR2 SEMANTICS)
    pragma FIPSFLAG('<', 1454); 
  function '<=' (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                 RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET) return BOOLEAN;
    pragma BUILTIN('<=',6, 1, 17); -- PEMS_CHAR, PEMDCMLE (VARCHAR2 SEMANTICS)
    pragma FIPSFLAG('<=', 1454);        
  function '>'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                 RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET) return BOOLEAN;
    pragma BUILTIN('>',1, 1, 18); -- PEMS_CHAR, PEMDCMGT (VARCHAR2 SEMANTICS)
    pragma FIPSFLAG('>', 1454); 
  function '>=' (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                 RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET) return BOOLEAN;
    pragma BUILTIN('>=',3, 1, 19); -- PEMS_CHAR, PEMDCMGE (VARCHAR2 SEMANTICS)
    pragma FIPSFLAG('>=', 1454);        

  function '||' (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                 RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return VARCHAR2 CHARACTER SET LEFT%CHARSET;
    pragma BUILTIN('||',25, 1, 7); -- PEMS_CHAR, CHAR_CONCAT
    pragma FIPSFLAG('||', 1454);        

  function CONCAT(LEFT VARCHAR2 CHARACTER SET ANY_CS,
                  RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return VARCHAR2 CHARACTER SET LEFT%CHARSET;
    pragma BUILTIN(CONCAT,25, 1, 7); -- PEMS_CHAR, CHAR_CONCAT
    pragma FIPSFLAG(CONCAT, 1454);      

  function LENGTH(ch VARCHAR2 CHARACTER SET ANY_CS) return natural;
    pragma FIPSFLAG('LENGTH', 1452);    
  -- In SUBSTR, LEN defaults to remainder of string
  -- In substr and instr, a negative value of parameter POS means to
  -- count from the right end of the string.
  function SUBSTR(STR1 VARCHAR2 CHARACTER SET ANY_CS,
                  POS BINARY_INTEGER,
                  LEN BINARY_INTEGER := 2147483647)
        return VARCHAR2 CHARACTER SET STR1%CHARSET;
    pragma FIPSFLAG('SUBSTR', 1452);    

  -- Find nth occurrence of str1 in str2 starting at pos
  function INSTR(STR1 VARCHAR2 CHARACTER SET ANY_CS,
                 STR2 VARCHAR2 CHARACTER SET STR1%CHARSET,
                 POS BINARY_INTEGER := 1,
                 NTH POSITIVE := 1) return BINARY_INTEGER;
    pragma FIPSFLAG('INSTR', 1452);     

  function UPPER(ch VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET ch%CHARSET;
    pragma FIPSFLAG('UPPER', 1452);     
  function LOWER(ch VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET ch%CHARSET;
    pragma FIPSFLAG('LOWER', 1452);     
  function ASCII(ch VARCHAR2 CHARACTER SET ANY_CS)
        return BINARY_INTEGER; -- should be ASCII.CHRANGE
    pragma FIPSFLAG('ASCII', 1452);     
  function CHR(n BINARY_INTEGER) return varchar2;  -- N should be ASCII.CHRANGE
    pragma FIPSFLAG('CHR', 1452);       
  function " SYS$STANDARD_CHR" (n NATURAL, csn VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET csn%CHARSET;
    pragma FIPSFLAG(' SYS$STANDARD_CHR', 1452);
  function INITCAP(ch VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET ch%CHARSET;
    pragma FIPSFLAG('INITCAP', 1452);   
  function SOUNDEX(ch VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET ch%CHARSET;
    pragma FIPSFLAG('SOUNDEX', 1452);   

  function LPAD(STR1 VARCHAR2 CHARACTER SET ANY_CS,
                LEN binary_integer,
                PAD VARCHAR2 CHARACTER SET STR1%CHARSET)
        return VARCHAR2 CHARACTER SET STR1%CHARSET;
    pragma FIPSFLAG('LPAD', 1452);      
  function LPAD(STR1 VARCHAR2 CHARACTER SET ANY_CS,
                LEN binary_integer)
        return VARCHAR2 CHARACTER SET STR1%CHARSET;
  pragma FIPSFLAG('LPAD', 1452);

  function RPAD(STR1 VARCHAR2 CHARACTER SET ANY_CS,
                LEN binary_integer,
                PAD VARCHAR2 CHARACTER SET STR1%CHARSET)
        return VARCHAR2 CHARACTER SET STR1%CHARSET;
    pragma FIPSFLAG('RPAD', 1452);       
  function RPAD(STR1 VARCHAR2 CHARACTER SET ANY_CS,
                LEN binary_integer)
        return VARCHAR2 CHARACTER SET STR1%CHARSET;
    pragma FIPSFLAG('RPAD', 1452);       

  function TRANSLATE(STR1 VARCHAR2 CHARACTER SET ANY_CS,
                     SRC VARCHAR2 CHARACTER SET STR1%CHARSET,
                     DEST VARCHAR2 CHARACTER SET STR1%CHARSET)
        return VARCHAR2 CHARACTER SET STR1%CHARSET;
    pragma FIPSFLAG('TRANSLATE', 1452); 

  function REPLACE(SRCSTR VARCHAR2 CHARACTER SET ANY_CS,
                   OLDSUB VARCHAR2 CHARACTER SET SRCSTR%CHARSET,
                   NEWSUB VARCHAR2 CHARACTER SET SRCSTR%CHARSET := NULL)
        return VARCHAR2 CHARACTER SET SRCSTR%CHARSET;
    pragma FIPSFLAG('REPLACE', 1452);

  function LTRIM(STR1 VARCHAR2 CHARACTER SET ANY_CS := ' ',
                 TSET VARCHAR2 CHARACTER SET STR1%CHARSET)
        return VARCHAR2 CHARACTER SET STR1%CHARSET;
    pragma FIPSFLAG('LTRIM', 1452);
  function LTRIM(STR1 VARCHAR2 CHARACTER SET ANY_CS := ' ')
        return VARCHAR2 CHARACTER SET STR1%CHARSET;
    pragma FIPSFLAG('LTRIM', 1452);

  function RTRIM(STR1 VARCHAR2 CHARACTER SET ANY_CS := ' ',
                 TSET VARCHAR2 CHARACTER SET STR1%CHARSET)
        return VARCHAR2 CHARACTER SET STR1%CHARSET;
    pragma FIPSFLAG('RTRIM', 1452);
  function RTRIM(STR1 VARCHAR2 CHARACTER SET ANY_CS := ' ')
        return VARCHAR2 CHARACTER SET STR1%CHARSET;
    pragma FIPSFLAG('RTRIM', 1452);

  function 'LIKE' (str VARCHAR2 CHARACTER SET ANY_CS,
                   pat VARCHAR2 CHARACTER SET str%CHARSET)
        return BOOLEAN;
  function 'NOT_LIKE' (str VARCHAR2 CHARACTER SET ANY_CS,
                       pat VARCHAR2 CHARACTER SET str%CHARSET)
        return BOOLEAN;
  function 'LIKE' (str VARCHAR2 CHARACTER SET ANY_CS,
                   pat VARCHAR2 CHARACTER SET str%CHARSET,
                   esc VARCHAR2 CHARACTER SET str%CHARSET)
        return BOOLEAN;
  function 'NOT_LIKE' (str VARCHAR2 CHARACTER SET ANY_CS,
                       pat VARCHAR2 CHARACTER SET str%CHARSET,
                       esc VARCHAR2 CHARACTER SET str%CHARSET)
        return BOOLEAN;
  function 'IS NULL' (s VARCHAR2 CHARACTER SET ANY_CS) return BOOLEAN;
    pragma BUILTIN('IS NULL', 0, 1, 20);  -- PEMS_CHAR, PEMDNUL
  function 'IS NOT NULL' (s VARCHAR2 CHARACTER SET ANY_CS) return BOOLEAN;

  function NVL(s1 VARCHAR2 CHARACTER SET ANY_CS,
               s2 VARCHAR2 CHARACTER SET s1%CHARSET)
        return VARCHAR2 CHARACTER SET s1%CHARSET;
    pragma FIPSFLAG('NVL', 1452);


--****************************************************************

  function '='  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;
    pragma BUILTIN('=',2, 2, 1); -- PEMS_NUMBER, PEMDCMEQ
  function '!=' (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;  -- also <> and ~=
    pragma BUILTIN('!=',5, 2, 2); -- PEMS_NUMBER, PEMDCMNE
    pragma FIPSFLAG('!=', 1452);
  function '<'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;
    pragma BUILTIN('<',4, 2, 3); -- PEMS_NUMBER, PEMDCMLT
  function '<=' (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;
    pragma BUILTIN('<=',6, 2, 4); -- PEMS_NUMBER, PEMDCMLE
  function '>'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;
    pragma BUILTIN('>',1, 2, 5); -- PEMS_NUMBER, PEMDCMGT
  function '>=' (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;
    pragma BUILTIN('>=',3, 2, 6); -- PEMS_NUMBER, PEMDCMGE

  function 'IS NULL' (n NUMBER) return BOOLEAN;
    pragma BUILTIN('IS NULL', 0, 2, 0); -- PEMS_NUMBER, PEMDNUL
  function 'IS NOT NULL' (n NUMBER) return BOOLEAN;
  function NVL(n1 NUMBER, n2 NUMBER) return NUMBER;
    pragma FIPSFLAG('NVL', 1452);

  function '+' (RIGHT NUMBER) return NUMBER;
    pragma BUILTIN('+',14, 0, 1); -- PEMS_QUICK
  function '-' (RIGHT NUMBER) return NUMBER;
    pragma BUILTIN('-',15, 2, 7); -- PEMS_NUMBER, NUM_NEG
  function ABS(n NUMBER) return NUMBER;
    pragma FIPSFLAG('ABS', 1452);

  function '+' (LEFT NUMBER, RIGHT NUMBER) return NUMBER;
    pragma BUILTIN('+',14, 2, 8); -- PEMS_NUMBER, NUM_ADD
  function '-' (LEFT NUMBER, RIGHT NUMBER) return NUMBER;
    pragma BUILTIN('-',15, 2, 9); -- PEMS_NUMBER, NUM_SUB
  function '*' (LEFT NUMBER, RIGHT NUMBER) return NUMBER;
    pragma BUILTIN('*',17, 2, 10); -- PEMS_NUMBER, NUM_MUL
  function '/' (LEFT NUMBER, RIGHT NUMBER) return NUMBER;
    pragma BUILTIN('/',18, 2, 11); -- PEMS_NUMBER, NUM_DIV

  function 'REM' (LEFT NUMBER, RIGHT NUMBER) return NUMBER;
    pragma FIPSFLAG('REM', 1452);
  function 'MOD'(n1 NUMBER, n2 NUMBER) return NUMBER;
    pragma FIPSFLAG('MOD', 1452);

  function '**' (LEFT NUMBER, RIGHT NUMBER) return NUMBER;
    pragma FIPSFLAG('**', 1452);

  function FLOOR(n NUMBER) return NUMBER;
    pragma FIPSFLAG('FLOOR', 1452);
  function CEIL(n NUMBER) return NUMBER;
    pragma FIPSFLAG('CEIL', 1452);
  function SQRT(n NUMBER) return NUMBER;
    pragma FIPSFLAG('SQRT', 1452);
  function SIGN(n NUMBER) return SIGNTYPE;
  pragma FIPSFLAG('SIGN', 1452);

  function COS(N NUMBER) return NUMBER;
  function SIN(N NUMBER) return NUMBER;
  function TAN(N NUMBER) return NUMBER;
  function COSH(N NUMBER) return NUMBER;
  function SINH(N NUMBER) return NUMBER;
  function TANH(N NUMBER) return NUMBER;
  function EXP(N NUMBER) return NUMBER;
  function LN(N NUMBER) return NUMBER;

  function BITAND (LEFT binary_integer, RIGHT binary_integer)  
        return binary_integer; 
  function LOG (LEFT NUMBER, RIGHT NUMBER) return NUMBER;

  function TRUNC (n NUMBER, places binary_integer := 0) return NUMBER;
    pragma FIPSFLAG('TRUNC', 1452);

  function ROUND (LEFT NUMBER, RIGHT binary_integer := 0) return NUMBER;
    pragma FIPSFLAG('ROUND', 1452);

  function POWER (n NUMBER, e NUMBER) return NUMBER;
    pragma FIPSFLAG('POWER', 1452);

--****************************************************************

  function '='  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma BUILTIN('=',2, 12, 1); -- PEMS_DATE, PEMDCMEQ
    pragma FIPSFLAG('=', 1450);
  function '!=' (LEFT DATE, RIGHT DATE) return BOOLEAN;  -- also <> and ~=
    pragma BUILTIN('!=',5, 12, 2); -- PEMS_DATE, PEMDCMNE
    pragma FIPSFLAG('!=', 1450);
  function '<'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma BUILTIN('<',4, 12, 3); -- PEMS_DATE, PEMDCMLT
    pragma FIPSFLAG('<', 1450);
  function '<=' (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma BUILTIN('<=',6, 12, 4); -- PEMS_DATE, PEMDCMLE
    pragma FIPSFLAG('<=', 1450);
  function '>'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma BUILTIN('>',1, 12, 5);  -- PEMS_DATE, PEMDCMGT
    pragma FIPSFLAG('>', 1450);
  function '>=' (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma BUILTIN('>=',3, 12, 6);  -- PEMS_DATE, PEMDCMGE
    pragma FIPSFLAG('>=', 1450);

  function '+' (LEFT DATE, RIGHT NUMBER) return DATE;
    pragma BUILTIN('+',14, 12, 7); -- PEMS_DATE, DATE_ADD1
    pragma FIPSFLAG('+', 1450);
  function '+' (LEFT NUMBER, RIGHT DATE) return DATE;
    pragma BUILTIN('+',14, 12, 8); -- PEMS_DATE, DATE_ADD2
    pragma FIPSFLAG('+', 1450);
  function '-' (LEFT DATE, RIGHT NUMBER) return DATE;
    pragma BUILTIN('-',15, 12, 9); -- PEMS_DATE, DATE_SUB1
    pragma FIPSFLAG('-', 1450);
  function '-' (LEFT NUMBER, RIGHT DATE) return DATE;
    pragma BUILTIN('-',15, 12, 10); -- PEMS_DATE, DATE_SUB2
    pragma FIPSFLAG('-', 1450);
  function '-' (LEFT DATE, RIGHT DATE) return NUMBER;
    pragma BUILTIN('-',15, 12, 11); -- PEMS_DATE, DATE_SUB3
    pragma FIPSFLAG('-', 1450);

  function LAST_DAY(RIGHT DATE) return DATE;
    pragma BUILTIN('LAST_DAY',38, 12, 12); -- PEMS_DATE, DATE_LAST_DAY
    pragma FIPSFLAG('LAST_DAY', 1450);
  function ADD_MONTHS(LEFT DATE, RIGHT NUMBER) return DATE;
    pragma BUILTIN('ADD_MONTHS',39, 12, 13); -- PEMS_DATE, DATE_ADD_MONTHS1
    pragma FIPSFLAG('ADD_MONTHS', 1450);
  function ADD_MONTHS(LEFT NUMBER, RIGHT DATE) return DATE;
    pragma BUILTIN('ADD_MONTHS',39, 12, 14); -- PEMS_DATE, DATE_ADD_MONTHS2
    pragma FIPSFLAG('ADD_MONTHS', 1450);

  function MONTHS_BETWEEN(LEFT DATE, RIGHT DATE) return NUMBER;
    pragma BUILTIN('MONTHS_BETWEEN',42, 12, 15); -- PEMS_DATE, DATE_MONTHS_BET
    pragma FIPSFLAG('MONTHS_BETWEEN', 1450);
  function NEXT_DAY(LEFT DATE, RIGHT VARCHAR2) return DATE;
    pragma BUILTIN('NEXT_DAY',43, 12, 16); -- PEMS_DATE, DATE_NEXT_DAY
    pragma FIPSFLAG('NEXT_DAY', 1450);
  function ROUND(RIGHT DATE) return DATE;
    pragma BUILTIN('ROUND',24, 12, 17); -- PEMS_DATE, DATE_ROUND
    pragma FIPSFLAG('ROUND', 1450);
  function NEW_TIME(RIGHT DATE, MIDDLE VARCHAR2, LEFT VARCHAR2) return DATE;
    pragma FIPSFLAG('NEW_TIME', 1450);

  function 'IS NULL' (d DATE) return BOOLEAN;
    pragma BUILTIN('IS NULL', 0, 12, 0);  -- PEMS_DATE, PEMDNUL
    pragma FIPSFLAG('IS NULL', 1450);
  function 'IS NOT NULL' (d DATE) return BOOLEAN;
    pragma FIPSFLAG('IS NOT NULL', 1450);
  function NVL (d1 DATE, d2 DATE) return DATE;
    pragma FIPSFLAG('NVL', 1450);

--****************************************************************

  function TRUNC(LEFT DATE) return DATE;
    pragma BUILTIN('TRUNC',51, 12, 20); -- PEMS_DATE, DATE_TRUNC1
    pragma FIPSFLAG('TRUNC', 1450);
  function TRUNC(LEFT DATE, RIGHT VARCHAR2) return DATE;
    pragma BUILTIN('TRUNC',51, 12, 21); -- PEMS_DATE, DATE_TRUNC2
    pragma FIPSFLAG('TRUNC', 1450);
  function ROUND(LEFT DATE, RIGHT VARCHAR2) return DATE;
    pragma BUILTIN('ROUND',24, 12, 22); -- PEMS_DATE, DATE_ROUND2
    pragma FIPSFLAG('ROUND', 1450);

--****************************************************************
-- basetype conversion routines

  function TO_DATE    (RIGHT VARCHAR2)   return DATE;
    pragma BUILTIN('TO_DATE',40, 1, 10); -- PEMS_CHAR, CHR_CNV_DAT
    pragma FIPSFLAG('TO_DATE', 1450);

  function TO_DATE (LEFT VARCHAR2, RIGHT VARCHAR2) return DATE;
    pragma BUILTIN('TO_DATE',40, 1, 8); -- PEMS_CHAR, CHR_CNV_DATE
    pragma FIPSFLAG('TO_DATE', 1450);

  function TO_DATE (LEFT NUMBER, RIGHT VARCHAR2) return DATE;
    pragma FIPSFLAG('TO_DATE', 1450);

  function TO_DATE(left varchar2, format varchar2, parms varchar2) return date;

  function TO_CHAR (RIGHT DATE) return VARCHAR2;
    pragma BUILTIN('TO_CHAR',41, 12, 23); -- PEMS_DATE, DAT_CNV_CHR2

  function TO_CHAR (LEFT DATE, RIGHT VARCHAR2) return VARCHAR2;
    pragma BUILTIN('TO_CHAR',41, 12, 19); -- PEMS_DATE, DAT_CNV_CHR1
    pragma FIPSFLAG('TO_CHAR', 1450);

  function TO_CHAR (LEFT NUMBER, RIGHT VARCHAR2) return VARCHAR2;
    pragma BUILTIN('TO_CHAR',41, 2, 14); -- PEMS_NUMBER, NUM_CNV_CHR

  function TO_CHAR (LEFT NUMBER) return VARCHAR2;
    pragma BUILTIN('TO_CHAR',41, 2, 12); -- PEMS_NUMBER, NUM_CNV_CHR

  function TO_NUMBER (LEFT NUMBER) RETURN NUMBER;

  function TO_NUMBER (RIGHT VARCHAR2)    return NUMBER;
    pragma BUILTIN('TO_NUMBER',48, 1, 9); -- PEMS_CHAR, CHR_CNV_NUM

  function TO_NUMBER(left varchar2, format varchar2)    return number;
  function TO_NUMBER(left varchar2, format varchar2, parms varchar2) 
    return number;

--****************************************************************

  -- Note that we really aren't returning an binary_integer.  It returns
  -- whatever the POSth datatype is....  This should COG ok though...
  function  GETBND(POS BINARY_INTEGER)           return BINARY_INTEGER;
    pragma BUILTIN('GETBND',240,202,240);
    pragma FIPSFLAG('GETBND', 1452);

  procedure SETBND(POS BINARY_INTEGER, VAL NUMBER);
    pragma BUILTIN('SETBND',240,201,240);
    pragma FIPSFLAG('SETBND', 1453);


------------ Define the Pragmas ----------------
-- (most of) these don't really need the argument_id's
-- in fact I think this is unneeded
pragma NEWPRAGMA(interface,language,subprogram);
pragma NEWPRAGMA(interface_C,subprogram,C_routine);
pragma NEWPRAGMA(Environ_Call,Call_Num,Arg);
pragma NEWPRAGMA(Environ_Call1,Call_Num,Arg);


-- Define SQL predicates.  These don't gen code, so no body is needed.

-- PRIOR is WEIRD - For now, it will be treated as a function call.
-- Does the function only take a column name?  how about its use in
-- a predicate?
function 'PRIOR'(colname VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET colname%CHARSET;
    pragma FIPSFLAG('PRIOR', 1452);
function 'PRIOR'(colname NUMBER) return NUMBER;
    pragma FIPSFLAG('PRIOR', 1452);
function 'PRIOR'(colname DATE) return DATE;
    pragma FIPSFLAG('PRIOR', 1450);

-- Outer Join has same problem as PRIOR
function '(+)'(colname VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET colname%CHARSET;
function '(+)'(colname NUMBER) return NUMBER;
function '(+)'(colname DATE) return DATE;
    pragma FIPSFLAG('(+)', 1450);

function '=ANY'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                  RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return BOOLEAN;
function '=ANY'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma FIPSFLAG('=ANY', 1450);
function '=ANY'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;

function '!=ANY'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                   RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return BOOLEAN;
function '!=ANY'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma FIPSFLAG('!=ANY', 1450);
function '!=ANY'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;

function '<ANY'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                  RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return BOOLEAN;
function '<ANY'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma FIPSFLAG('<ANY', 1450);
function '<ANY'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;

function '<=ANY'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                   RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return BOOLEAN;
function '<=ANY'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma FIPSFLAG('<=ANY', 1450);
function '<=ANY'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;

function '>ANY'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                  RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return BOOLEAN;
function '>ANY'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma FIPSFLAG('>ANY', 1450);
function '>ANY'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;

function '>=ANY'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                   RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return BOOLEAN;
function '>=ANY'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma FIPSFLAG('>=ANY', 1450);
function '>=ANY'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;

function '=ALL'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                  RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return BOOLEAN;
function '=ALL'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma FIPSFLAG('=ALL', 1450);
function '=ALL'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;

function '!=ALL'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                   RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return BOOLEAN;
function '!=ALL'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma FIPSFLAG('!=ALL', 1450);
function '!=ALL'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;

function '<ALL'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                  RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return BOOLEAN;
function '<ALL'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma FIPSFLAG('<ALL', 1450);
function '<ALL'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;

function '<=ALL'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                   RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return BOOLEAN;
function '<=ALL'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma FIPSFLAG('<=ALL', 1450);
function '<=ALL'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;

function '>ALL'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                  RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return BOOLEAN;
function '>ALL'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma FIPSFLAG('>ALL', 1450);
function '>ALL'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;

function '>=ALL'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                   RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return BOOLEAN;
function '>=ALL'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma FIPSFLAG('>=ALL', 1450);
function '>=ALL'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;

function '=SOME'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                   RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return BOOLEAN;
function '=SOME'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma FIPSFLAG('=SOME', 1450);
function '=SOME'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;

function '!=SOME'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                    RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return BOOLEAN;
function '!=SOME'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma FIPSFLAG('!=SOME', 1450);
function '!=SOME'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;

function '<SOME'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                   RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return BOOLEAN;
function '<SOME'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma FIPSFLAG('<SOME', 1450);
function '<SOME'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;

function '<=SOME'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                    RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return BOOLEAN;
function '<=SOME'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma FIPSFLAG('<=SOME', 1450);
function '<=SOME'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;

function '>SOME'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                   RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return BOOLEAN;
function '>SOME'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma FIPSFLAG('>SOME', 1450);
function '>SOME'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;

function '>=SOME'  (LEFT VARCHAR2 CHARACTER SET ANY_CS,
                    RIGHT VARCHAR2 CHARACTER SET LEFT%CHARSET)
        return BOOLEAN;
function '>=SOME'  (LEFT DATE, RIGHT DATE) return BOOLEAN;
    pragma FIPSFLAG('>=SOME', 1450);
function '>=SOME'  (LEFT NUMBER, RIGHT NUMBER) return BOOLEAN;

function 'BETWEEN' (TESTVAL VARCHAR2 CHARACTER SET ANY_CS,
                    LOW VARCHAR2 CHARACTER SET TESTVAL%CHARSET,
                    HIGH VARCHAR2 CHARACTER SET TESTVAL%CHARSET)
        return BOOLEAN;
function 'BETWEEN' (TESTVAL NUMBER, LOW NUMBER, HIGH NUMBER) return BOOLEAN;
function 'BETWEEN' (TESTVAL BOOLEAN, LOW BOOLEAN, HIGH BOOLEAN) return BOOLEAN;
    pragma FIPSFLAG('BETWEEN', 1450);
function 'BETWEEN' (TESTVAL DATE, LOW DATE, HIGH DATE) return BOOLEAN;
    pragma FIPSFLAG('BETWEEN', 1450);


--      SQL Transaction routines

procedure SET_TRANSACTION_USE(vc VARCHAR2);
procedure COMMIT;
procedure COMMIT_CM(vc VARCHAR2);
procedure ROLLBACK_NR;
procedure ROLLBACK_SV(Save_Point CHAR);
procedure SAVEPOINT(Save_Point CHAR);

--      Generic SQL DDL routine

--procedure SQL_DDL(Stmt VARCHAR2);


  function SYSDATE return DATE;
    pragma FIPSFLAG('SYSDATE', 1452);

  function UID return NUMBER;
    pragma FIPSFLAG('UID', 1452);

  function USER return VARCHAR2;


  function USERENV (envstr VARCHAR2) return VARCHAR2;
    pragma FIPSFLAG('USERENV', 1452);


  -- ROWID: this dreadful identifier is supposed to represent a datatype
  -- outside of SQL and and a pseudo-column (function, to us) when inside
  -- a sql statement.  ADA data model doesn't allow for any
  -- function X return X;
  -- so we must special case this.  Yuk.  There's special-case code in ph2nre
  -- which maps "rowid" to "rowid " if we're inside a SQL stmt.
  function "ROWID " return ROWID;
    pragma builtin('ROWID ', 1, 209, 240);  -- this had better never be called.

  function NULLFN (str VARCHAR2) return RAW;
    pragma builtin('NULLFN', 1, 0, 1); 

  function HEXTORAW (c VARCHAR2) return RAW;
     pragma builtin('HEXTORAW', 1, 23, 1);

  function RAWTOHEX (r RAW) return VARCHAR2;
     pragma builtin('RAWTOHEX', 1, 23, 2);

  function CHARTOROWID (str VARCHAR2) return ROWID;
    pragma builtin('CHARTOROWID', 1, 0, 1);

  function ROWIDTOCHAR (str ROWID) return VARCHAR2;
    pragma builtin('ROWIDTOCHAR', 1, 0, 1);


-- Trusted*Oracle additions

  Function ROWLABEL return MLSLABEL;                     -- pseudo column

  Function TO_CHAR(label MLSLABEL) return VARCHAR2;
    pragma BUILTIN('TO_CHAR',90, 4, 1); -- PEMS_CHAR, CHR_CNV_MLS

  Function TO_CHAR(label MLSLABEL, format VARCHAR2) return VARCHAR2;
    pragma BUILTIN('TO_CHAR',90, 4, 19); -- PEMS_DATE, MLS_CNV_CHR1
    pragma FIPSFLAG('TO_CHAR', 1450);

  Function TO_LABEL(label VARCHAR2, format VARCHAR2 ) return  MLSLABEL;
    pragma BUILTIN('TO_LABEL',90, 4, 8); -- PEMS_CHAR, CHR_CNV_MLS
    pragma FIPSFLAG('TO_LABEL', 1450);

  Function TO_LABEL(label VARCHAR2 ) return  MLSLABEL;
    pragma BUILTIN('TO_LABEL',90, 4, 2); -- PEMS_CHAR, CHR_CNV_MLS
    pragma FIPSFLAG('TO_LABEL', 1450);

-- vararg routines - icds in stdbdy 
  Function LEAST_UB    (pattern MLSLABEL) return MLSLABEL;
    pragma BUILTIN('LEAST_UB',90, 4, 3); -- PEMS_CHAR, CHR_CNV_MLS
  Function GREATEST_LB (pattern MLSLABEL) return MLSLABEL;
    pragma BUILTIN('GREATEST_LB',90, 4, 4); -- PEMS_CHAR, CHR_CNV_MLS

  Function '>=' (label1 MLSLABEL, label2 MLSLABEL) return BOOLEAN;
  Function '>'  (label1 MLSLABEL, label2 MLSLABEL) return BOOLEAN;
  Function '<=' (label1 MLSLABEL, label2 MLSLABEL) return BOOLEAN;
  Function '<'  (label1 MLSLABEL, label2 MLSLABEL) return BOOLEAN;
  Function '='  (label1 MLSLABEL, label2 MLSLABEL) return BOOLEAN;
  Function '!=' (label1 MLSLABEL, label2 MLSLABEL) return BOOLEAN;
  function 'IS NULL' (label MLSLABEL) return BOOLEAN;
    pragma BUILTIN('IS NULL', 0, 1,20);   -- same "cod" as IS NULL(varchar2)
  function 'IS NOT NULL' (label MLSLABEL) return BOOLEAN;

  function NVL(label1 MLSLABEL, label2 MLSLABEL) return MLSLABEL;
    pragma FIPSFLAG('NVL', 1452);

-- group functions 
  Function LUB (label MLSLABEL) return MLSLABEL;
  Function GLB (label MLSLABEL) return MLSLABEL;

-- end of Trusted*Oracle additions 


-- beginning of NLS routines 

  function NLSSORT(c VARCHAR2 CHARACTER SET ANY_CS) return RAW;
    pragma FIPSFLAG('NLSSORT', 1452);   
  function NLSSORT(c VARCHAR2 CHARACTER SET ANY_CS, c2 VARCHAR2) return RAW;
    pragma FIPSFLAG('NLSSORT', 1452);   
  function NLS_UPPER(ch VARCHAR2 CHARACTER SET ANY_CS, parms VARCHAR2)
        return VARCHAR2 CHARACTER SET ch%CHARSET;
    pragma FIPSFLAG('NLS_UPPER', 1452); 
  function NLS_UPPER(ch VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET ch%CHARSET;
    pragma FIPSFLAG('NLS_UPPER', 1452); 
  function NLS_LOWER(ch VARCHAR2 CHARACTER SET ANY_CS, parms VARCHAR2)
        return VARCHAR2 CHARACTER SET ch%CHARSET;
    pragma FIPSFLAG('NLS_LOWER', 1452); 
  function NLS_LOWER(ch VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET ch%CHARSET;
    pragma FIPSFLAG('NLS_LOWER', 1452); 
  function NLS_INITCAP(ch VARCHAR2 CHARACTER SET ANY_CS, parms VARCHAR2)
        return VARCHAR2 CHARACTER SET ch%CHARSET;
    pragma FIPSFLAG('NLS_INITCAP', 1452);       
  function NLS_INITCAP(ch VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET ch%CHARSET;
    pragma FIPSFLAG('NLS_INITCAP', 1452);       

  function LENGTHB(ch VARCHAR2 CHARACTER SET ANY_CS) return NUMBER;
    pragma FIPSFLAG('LENGTHB', 1452);   
  function SUBSTRB(STR1 VARCHAR2 CHARACTER SET ANY_CS,
                   POS BINARY_INTEGER, 
                   LEN BINARY_INTEGER := 2147483647)
        return VARCHAR2 CHARACTER SET STR1%CHARSET;
    pragma FIPSFLAG('SUBSTRB', 1452);   
  function INSTRB(STR1 VARCHAR2 CHARACTER SET ANY_CS,
                 STR2 VARCHAR2 CHARACTER SET STR1%CHARSET,
                 POS BINARY_INTEGER := 1,
                 NTH POSITIVE := 1) return BINARY_INTEGER;
    pragma FIPSFLAG('INSTRB', 1452);    

  function TO_SINGLE_BYTE(c VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET c%CHARSET;
    pragma FIPSFLAG('TO_SINGLE_BYTE', 1452);    
  function TO_MULTI_BYTE(c VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET c%CHARSET;
    pragma FIPSFLAG('TO_MULTI_BYTE', 1452);     

  -- Next two added for NLS 6/3/92 JEM.
  function TO_CHAR(left date, format varchar2, parms varchar2) return varchar2;
  function TO_CHAR(left number, format varchar2, parms varchar2) 
    return varchar2;
  function NLS_CHARSET_NAME(csetid NUMBER) return VARCHAR2;
  function NLS_CHARSET_ID(csetname VARCHAR2) return NUMBER;
  function NLS_CHARSET_DECL_LEN(bytecnt NUMBER, csetid NUMBER) return NUMBER;
-- end of NLS routines 

function CONVERT(src VARCHAR2, destcset VARCHAR2) return VARCHAR2;
function CONVERT(src VARCHAR2, destcset VARCHAR2, srccset VARCHAR2) 
        return VARCHAR2;
function " SYS$STANDARD_TRANSLATE" (src VARCHAR2 CHARACTER SET ANY_CS,
                                    csn VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET csn%CHARSET;
   pragma FIPSFLAG(' SYS$STANDARD_TRANSLATE',1452);

function VSIZE (e number ) return NUMBER;
    pragma builtin('VSIZE', 1, 0, 1);
function VSIZE (e DATE) return NUMBER;
    pragma builtin('VSIZE', 1, 0, 1);
function VSIZE (e VARCHAR2 CHARACTER SET ANY_CS) return NUMBER;
    pragma builtin('VSIZE', 1, 0, 1);


-- dump 
-- dump( expr [,display_format[,start_pos[,length]]]) return VARCHAR2
function DUMP(e varchar2 character set any_cs,
              df binary_integer := null,sp binary_integer := null,
              len binary_integer := null) return VARCHAR2;
    pragma builtin('DUMP', 1, 0, 1);

function DUMP(e number,df binary_integer := null,sp binary_integer := null,
                len binary_integer := null) return VARCHAR2;
    pragma builtin('DUMP', 1, 0, 1);

function DUMP(e date,df binary_integer := null,sp binary_integer := null,
                len binary_integer := null) return VARCHAR2;
    pragma builtin('DUMP', 1, 0, 1);

-- exception for ref cursors
ROWTYPE_MISMATCH exception;
pragma EXCEPTION_INIT(ROWTYPE_MISMATCH, '-6504');

subtype pls_integer is binary_integer;

    -- Fips flagging for Trigonometric functions already declared
    pragma FIPSFLAG('COS', 1452);
    pragma FIPSFLAG('SIN', 1452);
    pragma FIPSFLAG('TAN', 1452);
    pragma FIPSFLAG('COSH', 1452);
    pragma FIPSFLAG('SINH', 1452);
    pragma FIPSFLAG('TANH', 1452);

--
-- ACOS, ASIN, ATAN, ATAN2 
--   Inverse Trigonometric functions
--   These functions return NULL if any of the inputs are NULL
--
  function ACOS(N NUMBER) return NUMBER;
    pragma FIPSFLAG('ACOS', 1452);
    
  function ASIN(N NUMBER) return NUMBER;
    pragma FIPSFLAG('ASIN', 1452);
    
  function ATAN(N NUMBER) return NUMBER;
    pragma FIPSFLAG('ATAN', 1452);
    
  function ATAN2(x NUMBER, y NUMBER) return NUMBER;
  pragma FIPSFLAG('ATAN2', 1452);

  --#### This is the end of 7.3 Standard
  
-- LOB IS NULL
  function 'IS NULL' (n CLOB CHARACTER SET ANY_CS) return BOOLEAN;
    pragma BUILTIN('IS NULL', 0, 2, 0); -- PEMS_NUMBER, PEMDNUL
  function 'IS NOT NULL' (n CLOB CHARACTER SET ANY_CS) return BOOLEAN;

  function 'IS NULL' (n BLOB) return BOOLEAN;
    pragma BUILTIN('IS NULL', 0, 2, 0); -- PEMS_NUMBER, PEMDNUL
  function 'IS NOT NULL' (n BLOB) return BOOLEAN;

-- function 'IS NULL' (n CFILE) return BOOLEAN;
--    pragma BUILTIN('IS NULL', 0, 2, 0); -- PEMS_NUMBER, PEMDNUL
--  function 'IS NOT NULL' (n CFILE) return BOOLEAN;

  function 'IS NULL' (n BFILE) return BOOLEAN;
    pragma BUILTIN('IS NULL', 0, 2, 0); -- PEMS_NUMBER, PEMDNUL
  function 'IS NOT NULL' (n BFILE) return BOOLEAN;
-- end LOB IS NULL

-- The following data types are generics, used specially within package
-- STANDARD and some other Oracle packages.  They are protected against
-- other use; sorry.  True generic types are not yet part of the language.

  type "<ADT_1>" as object (dummy char(1));
  type "<RECORD_1>" is record (dummy char(1));
  type "<TUPLE_1>" as object (dummy char(1));
  type "<VARRAY_1>" is varray (1) of char(1);
  type "<V2_TABLE_1>" is table of char(1) index by binary_integer;
  type "<TABLE_1>" is table of char(1);
  type "<COLLECTION_1>" is table of char(1);
  type "<REF_CURSOR_1>" is ref cursor;
  
  -- This will actually match against a Q_TABLE
  type "<TYPED_TABLE>" is table of  "<ADT_1>";
  subtype "<ADT_WITH_OID>" is "<TYPED_TABLE>";

--****************************************************************
-- 20 mar 96 =G=> In the following, arguments "1, 1, 1" to pragma BUILTIN
-- e.g.,                pragma builtin('whatever', 1, 1, 1)
-- indicate that those three numeric arguments to pragma BUILTIN are unknown,
-- because they are not yet implemented by the backend. $$$ 

  function '='  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
    pragma BUILTIN('=', 1, 1, 1);
    pragma FIPSFLAG('=', 1450); 
  function '!=' (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN; 
    pragma BUILTIN('!=', 1, 1, 1);
    pragma FIPSFLAG('!=', 1450);        
  function '<'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
    pragma BUILTIN('<', 1, 1, 1);
    pragma FIPSFLAG('<', 1450); 
  function '<=' (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
    pragma BUILTIN('<=', 1, 1, 1);
    pragma FIPSFLAG('<=', 1450);        
  function '>'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
    pragma BUILTIN('>', 1, 1, 1);
    pragma FIPSFLAG('>', 1450); 
  function '>=' (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
    pragma BUILTIN('>=', 1, 1, 1);
    pragma FIPSFLAG('>=', 1450);        

  function '=ANY'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
  function '!=ANY'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
  function '<ANY'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
  function '<=ANY'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
  function '>ANY'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
  function '>=ANY'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
  function '=ALL'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
  function '!=ALL'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
  function '<ALL'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
  function '<=ALL'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
  function '>ALL'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
  function '>=ALL'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
  function '=SOME'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
  function '!=SOME'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
  function '<SOME'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
  function '<=SOME'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
  function '>SOME'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;
  function '>=SOME'  (LEFT "<ADT_1>", RIGHT "<ADT_1>") return BOOLEAN;

-- Outer Join
  function '(+)'  ( colname "<ADT_1>") return "<ADT_1>";
-- ?   pragma BUILTIN ('(+)', 1, 1, 1);
     pragma FIPSFLAG('(+)', 1450);

--  GREATEST and LEAST are not yet supported for ADTs in 8.0.2.
--  function GREATEST (pattern "<ADT_1>") return "<ADT_1>";
--    pragma BUILTIN('GREATEST', 1, 1, 1);

--  function LEAST (pattern "<ADT_1>") return "<ADT_1>";
--    pragma BUILTIN('LEAST', 1, 1, 1);

  function DECODE (expr "<ADT_1>", pat "<ADT_1>", res "<ADT_1>") 
        return "<ADT_1>";
    pragma BUILTIN('DECODE', 1, 1, 1);

  function 'BETWEEN' (TESTVAL "<ADT_1>", LOW "<ADT_1>", HIGH "<ADT_1>")
        return BOOLEAN;

  function 'IS NULL' (B "<ADT_1>") return BOOLEAN;
    pragma BUILTIN('IS NULL', 0, 3, 0);
    pragma FIPSFLAG('IS NULL', 1450);   

  function 'IS NOT NULL' (B "<ADT_1>") return BOOLEAN;
    pragma FIPSFLAG('IS NOT NULL', 1450);       

  function NVL (B1 "<ADT_1>", B2 "<ADT_1>") return "<ADT_1>";
    pragma FIPSFLAG('NVL', 1450);       

  function VALUE (item "<ADT_WITH_OID>") return "<ADT_1>";
    pragma BUILTIN('VALUE', 1, 1, 1);
    pragma FIPSFLAG('VALUE', 1450);
    
  function REF (item "<ADT_WITH_OID>") return REF "<ADT_1>";
    pragma BUILTIN('REF', 1, 1, 1);
    pragma FIPSFLAG('REF', 1450); 

  function DEREF (r REF "<ADT_1>") return "<ADT_1>";
    pragma BUILTIN('DEREF', 1, 1, 1);
    pragma FIPSFLAG('DEREF', 1450);

--****************************************************************
-- overloadings for REF ADT

  function 'IS NULL' (B REF "<ADT_1>") return BOOLEAN;
    pragma BUILTIN('IS NULL', 0, 3, 0);
    pragma FIPSFLAG('IS NULL', 1450);   

  function 'IS NOT NULL' (B REF "<ADT_1>") return BOOLEAN;
    pragma FIPSFLAG('IS NOT NULL', 1450);       

  function 'IS DANGLING' (B REF "<ADT_1>") return BOOLEAN;
    pragma BUILTIN('IS DANGLING', 1, 1, 1);
    pragma FIPSFLAG('IS DANGLING', 1450);

  function 'IS NOT DANGLING' (B REF "<ADT_1>") return BOOLEAN;
    pragma BUILTIN('IS NOT DANGLING', 1, 1, 1);
    pragma FIPSFLAG('IS NOT DANGLING', 1450);

  function NVL (B1 REF "<ADT_1>", B2 REF "<ADT_1>") return REF "<ADT_1>";
    pragma FIPSFLAG('NVL', 1450);       

  function '='  (LEFT REF "<ADT_1>", RIGHT REF "<ADT_1>") return BOOLEAN;
    pragma BUILTIN('=', 0, 3, 1);
    pragma FIPSFLAG('=', 1450); 

  function '!=' (LEFT REF "<ADT_1>", RIGHT REF "<ADT_1>") return BOOLEAN; 
    pragma BUILTIN('!=', 0, 3, 2);
    pragma FIPSFLAG('!=', 1450);        


--****************************************************************

--  function '='  (LEFT "<COLLECTION_1>", RIGHT "<COLLECTION_1>") 
--      return BOOLEAN;
--    pragma BUILTIN('=', 1, 1, 1);
--    pragma FIPSFLAG('=', 1450);       
--
--  function '!=' (LEFT "<COLLECTION_1>", RIGHT "<COLLECTION_1>") 
--      return BOOLEAN; 
--    pragma BUILTIN('!=', 1, 1, 1);
--    pragma FIPSFLAG('!=', 1450);      
--
--  function '=ANY'  (LEFT "<COLLECTION_1>", RIGHT "<COLLECTION_1>") 
--      return BOOLEAN;
--  function '!=ANY'  (LEFT "<COLLECTION_1>", RIGHT "<COLLECTION_1>") 
--      return BOOLEAN;
--  function '=ALL'  (LEFT "<COLLECTION_1>", RIGHT "<COLLECTION_1>") 
--      return BOOLEAN;
--  function '!=ALL'  (LEFT "<COLLECTION_1>", RIGHT "<COLLECTION_1>") 
--      return BOOLEAN;
--  function '=SOME'  (LEFT "<COLLECTION_1>", RIGHT "<COLLECTION_1>") 
--      return BOOLEAN;
--  function '!=SOME'  (LEFT "<COLLECTION_1>", RIGHT "<COLLECTION_1>") 
--      return BOOLEAN;
--
--  function DECODE (expr "<COLLECTION_1>", pat "<COLLECTION_1>", 
--                                        res "<COLLECTION_1>")
--      return "<COLLECTION_1>";
--    pragma BUILTIN('DECODE', 1, 1, 1);

  function 'IS NULL' (B "<COLLECTION_1>") return BOOLEAN;
    pragma BUILTIN('IS NULL', 0, 3, 0);
    pragma FIPSFLAG('IS NULL', 1450);   

  function 'IS NOT NULL' (B "<COLLECTION_1>") return BOOLEAN;
    pragma FIPSFLAG('IS NOT NULL', 1450);       

  function NVL (B1 "<COLLECTION_1>", B2 "<COLLECTION_1>") 
        return "<COLLECTION_1>";
    pragma FIPSFLAG('NVL', 1450);       

--****************************************************************

  function '='  (LEFT "<REF_CURSOR_1>", RIGHT "<REF_CURSOR_1>") 
        return BOOLEAN;
    pragma BUILTIN('=', 1, 1, 1);
    pragma FIPSFLAG('=', 1450); 

  function '!=' (LEFT "<REF_CURSOR_1>", RIGHT "<REF_CURSOR_1>") 
        return BOOLEAN;
    pragma BUILTIN('!=', 1, 1, 1);
    pragma FIPSFLAG('!=', 1450);        

  function '=ANY'  (LEFT "<REF_CURSOR_1>", RIGHT "<REF_CURSOR_1>") 
        return BOOLEAN;
  function '!=ANY'  (LEFT "<REF_CURSOR_1>", RIGHT "<REF_CURSOR_1>") 
        return BOOLEAN;
  function '=ALL'  (LEFT "<REF_CURSOR_1>", RIGHT "<REF_CURSOR_1>") 
        return BOOLEAN;
  function '!=ALL'  (LEFT "<REF_CURSOR_1>", RIGHT "<REF_CURSOR_1>") 
        return BOOLEAN;
  function '=SOME'  (LEFT "<REF_CURSOR_1>", RIGHT "<REF_CURSOR_1>") 
        return BOOLEAN;
  function '!=SOME'  (LEFT "<REF_CURSOR_1>", RIGHT "<REF_CURSOR_1>") 
        return BOOLEAN;

  function DECODE (expr "<REF_CURSOR_1>", pat "<REF_CURSOR_1>", 
                                          res "<REF_CURSOR_1>") 
        return "<REF_CURSOR_1>";
    pragma BUILTIN('DECODE', 1, 1, 1);

  function 'IS NULL' (B "<REF_CURSOR_1>") return BOOLEAN;
    pragma BUILTIN('IS NULL', 0, 3, 0);
    pragma FIPSFLAG('IS NULL', 1450);   

  function 'IS NOT NULL' (B "<REF_CURSOR_1>") return BOOLEAN;
    pragma FIPSFLAG('IS NOT NULL', 1450);       

  function NVL (B1 "<REF_CURSOR_1>", B2 "<REF_CURSOR_1>") 
        return "<REF_CURSOR_1>";
    pragma FIPSFLAG('NVL', 1450);       

  function EMPTY_CLOB return clob;
  function EMPTY_BLOB return blob;

  function BFILENAME(directory varchar2,filename varchar2) return BFILE;

  function "SYS$LOB_REPLICATION" (x in blob) return blob;
  function "SYS$LOB_REPLICATION" (x in clob character set any_cs) 
    return clob character set x%charset;

  --#### This is the end of 8.0 Standard
  
  type TIME is new DATE_BASE;
  type TIMESTAMP is new DATE_BASE;
  type "TIME WITH TIME ZONE" is new DATE_BASE;
  type "TIMESTAMP WITH TIME ZONE" is new DATE_BASE;
  type "INTERVAL YEAR TO MONTH" is new DATE_BASE;
  type "INTERVAL DAY TO SECOND" is new DATE_BASE;

--  + overloadings
    
  function '+'(LEFT TIMESTAMP, RIGHT "INTERVAL YEAR TO MONTH") return TIMESTAMP;
  function '+'(LEFT TIMESTAMP, RIGHT "INTERVAL DAY TO SECOND") return TIMESTAMP;

  function '+'(LEFT "TIMESTAMP WITH TIME ZONE", RIGHT "INTERVAL YEAR TO MONTH")
               return "TIMESTAMP WITH TIME ZONE" ; 
  function '+'(LEFT "TIMESTAMP WITH TIME ZONE", RIGHT "INTERVAL DAY TO SECOND")
               return "TIMESTAMP WITH TIME ZONE" ; 

  function '+'(LEFT TIME, RIGHT "INTERVAL DAY TO SECOND") return TIME; 

  function '+'(LEFT "TIME WITH TIME ZONE", RIGHT "INTERVAL DAY TO SECOND") 
               return "TIME WITH TIME ZONE"; 

  function '+'(LEFT date, RIGHT "INTERVAL YEAR TO MONTH") return date ; 
  function '+'(LEFT date, RIGHT "INTERVAL DAY TO SECOND") return date ; 
  function '+'(LEFT "INTERVAL YEAR TO MONTH", RIGHT TIMESTAMP) return TIMESTAMP; 
  function '+'(LEFT "INTERVAL YEAR TO MONTH", RIGHT "TIMESTAMP WITH TIME ZONE") 
               return "TIMESTAMP WITH TIME ZONE" ; 
  function '+'(LEFT "INTERVAL YEAR TO MONTH", RIGHT date) return date ; 

  function '+'(LEFT "INTERVAL DAY TO SECOND", RIGHT TIMESTAMP)  return TIMESTAMP; 
  function '+'(LEFT "INTERVAL DAY TO SECOND", RIGHT "TIMESTAMP WITH TIME ZONE") 
                return "TIMESTAMP WITH TIME ZONE" ; 
  function '+'(LEFT "INTERVAL DAY TO SECOND", RIGHT TIME) return TIME ;
  function '+'(LEFT "INTERVAL DAY TO SECOND", RIGHT "TIME WITH TIME ZONE") 
                return "TIME WITH TIME ZONE" ; 
  function '+'(LEFT "INTERVAL DAY TO SECOND", RIGHT date) return date ; 

  function '+'(LEFT "INTERVAL DAY TO SECOND", RIGHT "INTERVAL DAY TO SECOND") 
               return "INTERVAL DAY TO SECOND" ; 
  function '+'(LEFT "INTERVAL YEAR TO MONTH", RIGHT "INTERVAL YEAR TO MONTH") 
               return "INTERVAL YEAR TO MONTH" ; 
  
-- begin subtract 
  function " SYS$DSINTERVALSUBTRACT"(LEFT TIMESTAMP, RIGHT TIMESTAMP) 
           return "INTERVAL DAY TO SECOND" ; 
  function " SYS$YMINTERVALSUBTRACT"(LEFT TIMESTAMP, RIGHT TIMESTAMP) 
           return "INTERVAL YEAR TO MONTH" ; 
  function '-'(LEFT TIMESTAMP, RIGHT "INTERVAL YEAR TO MONTH") return TIMESTAMP; 
  function '-'(LEFT TIMESTAMP, RIGHT "INTERVAL DAY TO SECOND") return TIMESTAMP; 

  function " SYS$DSINTERVALSUBTRACT"
   (LEFT "TIMESTAMP WITH TIME ZONE", RIGHT "TIMESTAMP WITH TIME ZONE") 
    return "INTERVAL DAY TO SECOND" ; 
  function " SYS$YMINTERVALSUBTRACT"
   (LEFT "TIMESTAMP WITH TIME ZONE", RIGHT "TIMESTAMP WITH TIME ZONE") 
    return "INTERVAL YEAR TO MONTH" ; 
  function '-' (LEFT "TIMESTAMP WITH TIME ZONE", RIGHT "INTERVAL YEAR TO MONTH") 
    return "TIMESTAMP WITH TIME ZONE" ; 
  function '-' (LEFT "TIMESTAMP WITH TIME ZONE" , RIGHT "INTERVAL DAY TO SECOND") 
    return "TIMESTAMP WITH TIME ZONE" ; 

  function " SYS$DSINTERVALSUBTRACT" (LEFT TIME, RIGHT TIME) 
     return "INTERVAL DAY TO SECOND" ; 
  function '-' (LEFT TIME, RIGHT "INTERVAL DAY TO SECOND") 
    return TIME ; 
  function " SYS$DSINTERVALSUBTRACT" 
   (LEFT "TIME WITH TIME ZONE", RIGHT "TIME WITH TIME ZONE") 
    return "INTERVAL DAY TO SECOND" ; 
  function '-' (LEFT "TIME WITH TIME ZONE", RIGHT "INTERVAL DAY TO SECOND") 
    return "TIME WITH TIME ZONE" ; 
  function  " SYS$DSINTERVALSUBTRACT" (LEFT date, RIGHT date)  
    return "INTERVAL DAY TO SECOND" ; 
  function " SYS$YMINTERVALSUBTRACT" (LEFT date, RIGHT date)  
    return "INTERVAL YEAR TO MONTH" ; 
  function '-' (LEFT date, RIGHT "INTERVAL YEAR TO MONTH") return date; 
  function '-' (LEFT date, RIGHT "INTERVAL DAY TO SECOND") return date; 

  function '-' (LEFT "INTERVAL YEAR TO MONTH", RIGHT "INTERVAL YEAR TO MONTH") 
    return "INTERVAL YEAR TO MONTH" ; 
  function '-' (LEFT "INTERVAL DAY TO SECOND", RIGHT "INTERVAL DAY TO SECOND") 
   return "INTERVAL DAY TO SECOND" ; 

-- end subtract 

-- other datetime operators

  function '*' (LEFT number, RIGHT "INTERVAL YEAR TO MONTH") 
    return "INTERVAL YEAR TO MONTH" ; 
  function '*' (LEFT number, RIGHT "INTERVAL DAY TO SECOND") 
    return "INTERVAL DAY TO SECOND" ; 

  function '*' (LEFT "INTERVAL YEAR TO MONTH", RIGHT number) 
    return "INTERVAL YEAR TO MONTH" ; 
  function '*' (LEFT "INTERVAL DAY TO SECOND", RIGHT number) 
    return "INTERVAL DAY TO SECOND" ; 

  function '/' (LEFT "INTERVAL YEAR TO MONTH", RIGHT number) 
    return "INTERVAL YEAR TO MONTH" ; 
  function '/' (LEFT "INTERVAL DAY TO SECOND", RIGHT number) 
    return "INTERVAL DAY TO SECOND" ; 


  function current_date return date;
  function current_time return "TIME WITH TIME ZONE";
  function current_timestamp return "TIMESTAMP WITH TIME ZONE";

-- to_char 
-- 12 conversions 
function TO_CHAR (RIGHT TIME)  return varchar2;
    pragma BUILTIN('TO_CHAR', 0, 15, 2);
function TO_CHAR (RIGHT TIMESTAMP)  return varchar2;
    pragma BUILTIN('TO_CHAR', 0, 15, 4);
function TO_CHAR (RIGHT "TIME WITH TIME ZONE")  return varchar2;
    pragma BUILTIN('TO_CHAR', 0, 15, 6);
function TO_CHAR (RIGHT "TIMESTAMP WITH TIME ZONE")  return varchar2;
    pragma BUILTIN('TO_CHAR', 0, 15, 8);
function TO_CHAR (RIGHT "INTERVAL YEAR TO MONTH") return varchar2;
    pragma BUILTIN('TO_CHAR', 0, 15, 10);
function TO_CHAR (RIGHT "INTERVAL DAY TO SECOND") return varchar2; 
    pragma BUILTIN('TO_CHAR', 0, 15, 12);


function TO_TIME (RIGHT varchar2)  return TIME;
    pragma BUILTIN('TO_TIME', 0, 15, 1);
function TO_TIMESTAMP (RIGHT varchar2)  return TIMESTAMP;
    pragma BUILTIN('TO_TIMESTAMP', 0, 15, 3);
function TO_TIME_TZ (RIGHT varchar2) return  "TIME WITH TIME ZONE";
    pragma BUILTIN('TO_TIME_TZ', 0, 15, 5);
function TO_TIMESTAMP_TZ (RIGHT varchar2) return  "TIMESTAMP WITH TIME ZONE";
    pragma BUILTIN('TO_TIMESTAMP_TZ', 0, 15, 7);
function TO_YMINTERVAL (RIGHT varchar2) return  "INTERVAL YEAR TO MONTH";
    pragma BUILTIN('TO_YMINTERVAL', 0, 15, 9);
function TO_DSINTERVAL (RIGHT varchar2) return  "INTERVAL DAY TO SECOND";
    pragma BUILTIN('TO_DSINTERVAL', 0, 15, 11);


-- with nls args 
function TO_TIME(left varchar2, format varchar2, parms varchar2) return time;
function TO_TIME(left varchar2, format varchar2) return time;
function TO_TIMESTAMP(left varchar2, format varchar2, parms varchar2) 
                      return timestamp;
function TO_TIMESTAMP(left varchar2, format varchar2) 
                      return timestamp;
function TO_TIMESTAMP_TZ(left varchar2, format varchar2, parms varchar2) 
                    return "TIMESTAMP WITH TIME ZONE";
function TO_TIMESTAMP_TZ(left varchar2, format varchar2)
                    return "TIMESTAMP WITH TIME ZONE";
function TO_TIME_TZ(left varchar2, format varchar2, parms varchar2) 
                    return "TIME WITH TIME ZONE";
function TO_TIME_TZ(left varchar2, format varchar2)
                    return "TIME WITH TIME ZONE";
function TO_DSINTERVAL (RIGHT varchar2, parms varchar) 
                        return  "INTERVAL DAY TO SECOND";
 
function NUMTOYMINTERVAL(numerator number, units varchar2) 
  return "INTERVAL YEAR TO MONTH";
function NUMTODSINTERVAL(numerator number, units varchar2) 
  return "INTERVAL DAY TO SECOND";
  
 --****************************************************************
  
  TYPE UROWID IS NEW CHAR_BASE;

  function '='  (LEFT UROWID, RIGHT UROWID) return BOOLEAN;
    pragma BUILTIN('=',0, 11, 1);
    pragma FIPSFLAG('=', 1450);
  function '!=' (LEFT UROWID, RIGHT UROWID) return BOOLEAN;  -- also <> and ~=
    pragma BUILTIN('!=',0, 11, 2);
    pragma FIPSFLAG('!=', 1450);
  function '<'  (LEFT UROWID, RIGHT UROWID) return BOOLEAN;
    pragma BUILTIN('<',0, 11, 3);
    pragma FIPSFLAG('<', 1450);
  function '<=' (LEFT UROWID, RIGHT UROWID) return BOOLEAN;
    pragma BUILTIN('<=',0, 11, 4);
    pragma FIPSFLAG('<=', 1450);
  function '>'  (LEFT UROWID, RIGHT UROWID) return BOOLEAN;
    pragma BUILTIN('>',0, 11, 5);
    pragma FIPSFLAG('>', 1450);
  function '>=' (LEFT UROWID, RIGHT UROWID) return BOOLEAN;
    pragma BUILTIN('>=',0, 11, 6);
    pragma FIPSFLAG('>=', 1450);

  function 'IS NULL' (u UROWID) return BOOLEAN;
    pragma BUILTIN('IS NULL', 0, 14, 0); -- PEMS_UROWID, PEMDNUL
    pragma FIPSFLAG('IS NULL', 1450);
  function 'IS NOT NULL' (u UROWID) return BOOLEAN;
    pragma FIPSFLAG('IS NOT NULL', 1450);
  
  function "UROWID " return UROWID;
    pragma builtin('UROWID ', 1, 209, 240);  -- this had better never be called.

  SYS_INVALID_ROWID  EXCEPTION;
  PRAGMA EXCEPTION_INIT(SYS_INVALID_ROWID, '-1410');

-- New built-in function SYS_GUID, returns globally unique id
  function SYS_GUID return RAW;

-- New built-in function SYS_CONTEXT
  function SYS_CONTEXT (namespace varchar2, attribute varchar2)
           return varchar2; 

  -- The following generic index table data types are used by the PL/SQL
  -- compiler to materialize an array attribute at the runtime (for more
  -- details about the array attributes, please see Bulk Binds document).
  type " SYS$INT_V2TABLE" is table of pls_integer index by binary_integer;

  -- The object instance i.e. SELF is null                 
  SELF_IS_NULL exception;
    pragma EXCEPTION_INIT(SELF_IS_NULL, '-30625');

  function TRIM(v VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET v%CHARSET;

  --#### This is the end of 8.1.5 Standard

  -- SYS_CONTEXT now has an additional optional parameter
  function SYS_CONTEXT
             (namespace varchar2, attribute varchar2, newoptional varchar2)
           return varchar2; 

  -- CUBE and ROLLUP are not real functions; they are variants on the GROUP
  -- BY clause (GROUP BY CUBE (...) and GROUP BY ROLLUP (...)). They have
  -- been added here as functions to avoid name capture issues.
  --
  -- Note that both CUBE and ROLLUP look like true vararg functions with
  -- *no* repeating pattern of formals - hence they are special cased in
  -- the overloading code.
  function CUBE return NUMBER;
  function ROLLUP return NUMBER;

  -- The GROUPING function must be used in conjunction with CUBE and ROLLUP
  -- in the GROUP BY clause. The type of the parameter to GROUPING can be
  -- any type that can appear in a GROUP BY list.
  function GROUPING(v VARCHAR2) return NUMBER;
  function GROUPING(a "<ADT_1>") return NUMBER;

  -- This is for TRIM(x). No trim set.
  function " SYS$STANDARD_TRIM" (v VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET v%CHARSET;

  -- This is for TRIM(LEADING/TRAILING FROM x). No trim set.
  function " SYS$STANDARD_TRIM" (STR1 VARCHAR2 CHARACTER SET ANY_CS ,
                               TRFLAG BINARY_INTEGER)
        return VARCHAR2 CHARACTER SET STR1%CHARSET;

  -- General TRIM. LEADING, TRAILING and BOTH options as 3rd argument.
  -- This one takes a trim set.
  function " SYS$STANDARD_TRIM" (STR1   VARCHAR2 CHARACTER SET ANY_CS ,
                                 TSET   VARCHAR2 CHARACTER SET STR1%CHARSET,
                                 TRFLAG BINARY_INTEGER)
        return VARCHAR2 CHARACTER SET STR1%CHARSET;

  --#### This is the end of the supported parts of 8.1.6 Standard

  --## Support for ANSI datetime data types is under development.
  --## The following operations, as well as the related types and
  --## operations defined above in the 8.1.5 section, are not yet
  --## available for use and are still subject to change.

  
  -- new subtypes 
  subtype time_unconstrained is time(9);
  subtype time_tz_unconstrained is time(9) with time zone;
  subtype timestamp_unconstrained is timestamp(9);
  subtype timestamp_tz_unconstrained is timestamp(9) with time zone;
  subtype yminterval_unconstrained is interval year(9) to month;
  subtype dsinterval_unconstrained is interval day(9) to second (9);


  --- datetime equivalence 
  function '='  (LEFT TIME_UNCONSTRAINED, 
                 RIGHT TIME_UNCONSTRAINED) return BOOLEAN;
  function '!=' (LEFT TIME_UNCONSTRAINED,
                 RIGHT TIME_UNCONSTRAINED) return BOOLEAN; 
  function '<'  (LEFT TIME_UNCONSTRAINED, 
                 RIGHT TIME_UNCONSTRAINED) return BOOLEAN;
  function '<=' (LEFT TIME_UNCONSTRAINED, 
                 RIGHT TIME_UNCONSTRAINED) return BOOLEAN;
  function '>'  (LEFT TIME_UNCONSTRAINED, 
                 RIGHT TIME_UNCONSTRAINED) return BOOLEAN;
  function '>=' (LEFT TIME_UNCONSTRAINED, 
                 RIGHT TIME_UNCONSTRAINED) return BOOLEAN;

  function '='  (LEFT TIMESTAMP_UNCONSTRAINED, 
                 RIGHT TIMESTAMP_UNCONSTRAINED) return BOOLEAN;
  function '!=' (LEFT TIMESTAMP_UNCONSTRAINED, 
                 RIGHT TIMESTAMP_UNCONSTRAINED) return BOOLEAN; 
  function '<'  (LEFT TIMESTAMP_UNCONSTRAINED, 
                 RIGHT TIMESTAMP_UNCONSTRAINED) return BOOLEAN;
  function '<=' (LEFT TIMESTAMP_UNCONSTRAINED, 
                 RIGHT TIMESTAMP_UNCONSTRAINED) return BOOLEAN;
  function '>'  (LEFT TIMESTAMP_UNCONSTRAINED, 
                 RIGHT TIMESTAMP_UNCONSTRAINED) return BOOLEAN;
  function '>=' (LEFT TIMESTAMP_UNCONSTRAINED, 
                 RIGHT TIMESTAMP_UNCONSTRAINED) return BOOLEAN;

  function '='  (LEFT TIME_TZ_UNCONSTRAINED, 
                 RIGHT TIME_TZ_UNCONSTRAINED) return BOOLEAN;
  function '!=' (LEFT TIME_TZ_UNCONSTRAINED, 
                 RIGHT TIME_TZ_UNCONSTRAINED) return BOOLEAN; 
  function '<'  (LEFT TIME_TZ_UNCONSTRAINED, 
                 RIGHT TIME_TZ_UNCONSTRAINED) return BOOLEAN;
  function '<=' (LEFT TIME_TZ_UNCONSTRAINED, 
                 RIGHT TIME_TZ_UNCONSTRAINED) return BOOLEAN;
  function '>'  (LEFT TIME_TZ_UNCONSTRAINED, 
                 RIGHT TIME_TZ_UNCONSTRAINED) return BOOLEAN;
  function '>=' (LEFT TIME_TZ_UNCONSTRAINED, 
                 RIGHT TIME_TZ_UNCONSTRAINED) return BOOLEAN;
                 
  function '='  (LEFT YMINTERVAL_UNCONSTRAINED, 
                 RIGHT YMINTERVAL_UNCONSTRAINED) return BOOLEAN;
  function '!=' (LEFT YMINTERVAL_UNCONSTRAINED, 
                 RIGHT YMINTERVAL_UNCONSTRAINED) return BOOLEAN; 
  function '<'  (LEFT YMINTERVAL_UNCONSTRAINED, 
                 RIGHT YMINTERVAL_UNCONSTRAINED) return BOOLEAN;
  function '<=' (LEFT YMINTERVAL_UNCONSTRAINED, 
                 RIGHT YMINTERVAL_UNCONSTRAINED) return BOOLEAN;
  function '>'  (LEFT YMINTERVAL_UNCONSTRAINED, 
                 RIGHT YMINTERVAL_UNCONSTRAINED) return BOOLEAN;
  function '>=' (LEFT YMINTERVAL_UNCONSTRAINED, 
                 RIGHT YMINTERVAL_UNCONSTRAINED) return BOOLEAN;
                 
  function '='  (LEFT DSINTERVAL_UNCONSTRAINED, 
                 RIGHT DSINTERVAL_UNCONSTRAINED) return BOOLEAN;
  function '!=' (LEFT DSINTERVAL_UNCONSTRAINED, 
                 RIGHT DSINTERVAL_UNCONSTRAINED) return BOOLEAN; 
  function '<'  (LEFT DSINTERVAL_UNCONSTRAINED, 
                 RIGHT DSINTERVAL_UNCONSTRAINED) return BOOLEAN;
  function '<=' (LEFT DSINTERVAL_UNCONSTRAINED, 
                 RIGHT DSINTERVAL_UNCONSTRAINED) return BOOLEAN;
  function '>'  (LEFT DSINTERVAL_UNCONSTRAINED, 
                 RIGHT DSINTERVAL_UNCONSTRAINED) return BOOLEAN;
  function '>=' (LEFT DSINTERVAL_UNCONSTRAINED, 
                 RIGHT DSINTERVAL_UNCONSTRAINED) return BOOLEAN;
                 
  function TO_TIME (RIGHT TIME_TZ_UNCONSTRAINED)  return TIME_UNCONSTRAINED;
    pragma BUILTIN('TO_TIME', 0, 15, 13);
  function TO_TIME_TZ (RIGHT TIME_UNCONSTRAINED)  return TIME_TZ_UNCONSTRAINED;
    pragma BUILTIN('TO_TIME_TZ', 0, 15, 14);
  function TO_TIMESTAMP (RIGHT TIMESTAMP_TZ_UNCONSTRAINED)  
    return TIMESTAMP_UNCONSTRAINED;
    pragma BUILTIN('TO_TIMESTAMP', 0, 15, 15);
  function TO_TIMESTAMP_TZ (RIGHT TIMESTAMP_UNCONSTRAINED)  
    return TIMESTAMP_TZ_UNCONSTRAINED;
    pragma BUILTIN('TO_TIMESTAMP_TZ', 0, 15, 16);

  function '-'
      (LEFT TIME_UNCONSTRAINED, RIGHT TIME_UNCONSTRAINED) 
    return DSINTERVAL_UNCONSTRAINED; 
  function '-'
      (LEFT TIMESTAMP_UNCONSTRAINED, RIGHT TIMESTAMP_UNCONSTRAINED) 
    return DSINTERVAL_UNCONSTRAINED; 
  function '-'
      (LEFT TIME_TZ_UNCONSTRAINED, RIGHT TIME_TZ_UNCONSTRAINED) 
    return DSINTERVAL_UNCONSTRAINED; 
  function '-'
      (LEFT TIMESTAMP_TZ_UNCONSTRAINED, RIGHT TIMESTAMP_TZ_UNCONSTRAINED) 
    return DSINTERVAL_UNCONSTRAINED; 
   
  -- timezone functions
  function SYS_AT_TIME_ZONE(t time_tz_unconstrained,
                            i varchar2) RETURN time_tz_unconstrained;
  function SYS_AT_TIME_ZONE(t timestamp_tz_unconstrained,
                            i varchar2) RETURN timestamp_tz_unconstrained;
  FUNCTION systimestamp RETURN timestamp_tz_unconstrained;
  FUNCTION dbtimezone RETURN varchar2;
  FUNCTION sessiontimezone RETURN varchar2;
    
  FUNCTION localtimestamp RETURN timestamp_unconstrained;
  FUNCTION localtime RETURN time_unconstrained;

  FUNCTION TO_LOCAL_TZ(t timestamp_unconstrained) 
    return timestamp_tz_unconstrained;
  FUNCTION TO_LOCAL_TZ(t timestamp_tz_unconstrained) 
           return timestamp_tz_unconstrained;

  FUNCTION TO_DB_TZ(t timestamp_unconstrained) 
    return timestamp_tz_unconstrained;
  FUNCTION TO_DB_TZ(t timestamp_tz_unconstrained) 
           return timestamp_tz_unconstrained;

  function TO_TIMESTAMP (RIGHT DATE)  return TIMESTAMP_UNCONSTRAINED;
    pragma BUILTIN('TO_TIMESTAMP', 0, 15, 17);

  type "TIMESTAMP WITH LOCAL TIME ZONE" is new DATE_BASE;
  subtype timestamp_ltz_unconstrained is timestamp(9) with local time zone;
  
  function TO_CHAR (RIGHT TIMESTAMP_LTZ_UNCONSTRAINED)  return varchar2;
  pragma BUILTIN('TO_CHAR', 0, 15, 20);

  function '+'(LEFT TIMESTAMP_LTZ_UNCONSTRAINED,
               RIGHT yminterval_unconstrained)
               return TIMESTAMP_LTZ_UNCONSTRAINED; 
  function '+'(LEFT TIMESTAMP_LTZ_UNCONSTRAINED,
               RIGHT dsinterval_unconstrained)
               return TIMESTAMP_LTZ_UNCONSTRAINED; 
  function '+'(LEFT yminterval_unconstrained,
               RIGHT TIMESTAMP_LTZ_UNCONSTRAINED)
               return TIMESTAMP_LTZ_UNCONSTRAINED ; 
  function '+'(LEFT dsinterval_unconstrained,
               RIGHT TIMESTAMP_LTZ_UNCONSTRAINED)
               return TIMESTAMP_LTZ_UNCONSTRAINED ; 

  function '-'(LEFT TIMESTAMP_LTZ_UNCONSTRAINED,
               RIGHT yminterval_unconstrained) 
               return TIMESTAMP_LTZ_UNCONSTRAINED ; 
  function '-'(LEFT TIMESTAMP_LTZ_UNCONSTRAINED,
               RIGHT dsinterval_unconstrained) 
               return TIMESTAMP_LTZ_UNCONSTRAINED ; 

  function " SYS$DSINTERVALSUBTRACT"(LEFT TIMESTAMP_LTZ_UNCONSTRAINED,
                                     RIGHT TIMESTAMP_LTZ_UNCONSTRAINED) 
                                     return dsinterval_unconstrained; 
  function " SYS$YMINTERVALSUBTRACT"(LEFT TIMESTAMP_LTZ_UNCONSTRAINED,
                                     RIGHT TIMESTAMP_LTZ_UNCONSTRAINED) 
                                     return yminterval_unconstrained; 

  function '-'(LEFT TIMESTAMP_LTZ_UNCONSTRAINED,
               RIGHT TIMESTAMP_LTZ_UNCONSTRAINED) 
               return dsinterval_unconstrained; 

  function '='  (LEFT TIMESTAMP_TZ_UNCONSTRAINED, 
                 RIGHT TIMESTAMP_TZ_UNCONSTRAINED) return BOOLEAN;
  function '!=' (LEFT TIMESTAMP_TZ_UNCONSTRAINED, 
                 RIGHT TIMESTAMP_TZ_UNCONSTRAINED) return BOOLEAN; 
  function '<'  (LEFT TIMESTAMP_TZ_UNCONSTRAINED, 
                 RIGHT TIMESTAMP_TZ_UNCONSTRAINED) return BOOLEAN;
  function '<=' (LEFT TIMESTAMP_TZ_UNCONSTRAINED, 
                 RIGHT TIMESTAMP_TZ_UNCONSTRAINED) return BOOLEAN;
  function '>'  (LEFT TIMESTAMP_TZ_UNCONSTRAINED, 
                 RIGHT TIMESTAMP_TZ_UNCONSTRAINED) return BOOLEAN;
  function '>=' (LEFT TIMESTAMP_TZ_UNCONSTRAINED, 
                 RIGHT TIMESTAMP_TZ_UNCONSTRAINED) return BOOLEAN;
                 
  function '='  (LEFT TIMESTAMP_LTZ_UNCONSTRAINED, 
                 RIGHT TIMESTAMP_LTZ_UNCONSTRAINED) return BOOLEAN;
  function '!=' (LEFT TIMESTAMP_LTZ_UNCONSTRAINED, 
                 RIGHT TIMESTAMP_LTZ_UNCONSTRAINED) return BOOLEAN; 
  function '<'  (LEFT TIMESTAMP_LTZ_UNCONSTRAINED, 
                 RIGHT TIMESTAMP_LTZ_UNCONSTRAINED) return BOOLEAN;
  function '<=' (LEFT TIMESTAMP_LTZ_UNCONSTRAINED, 
                 RIGHT TIMESTAMP_LTZ_UNCONSTRAINED) return BOOLEAN;
  function '>'  (LEFT TIMESTAMP_LTZ_UNCONSTRAINED, 
                 RIGHT TIMESTAMP_LTZ_UNCONSTRAINED) return BOOLEAN;
  function '>=' (LEFT TIMESTAMP_LTZ_UNCONSTRAINED, 
                 RIGHT TIMESTAMP_LTZ_UNCONSTRAINED) return BOOLEAN;
   
  function SYS_LITERALTOYMINTERVAL(numerator varchar2, units varchar2) 
  return YMINTERVAL_UNCONSTRAINED;
  function SYS_LITERALTODSINTERVAL(numerator varchar2, units varchar2) 
  return DSINTERVAL_UNCONSTRAINED;
  function SYS_LITERALTOTIME(numerator varchar2) return TIME;    
  function SYS_LITERALTOTZTIME(numerator varchar2) 
    return TIME_TZ_UNCONSTRAINED;    
  function SYS_LITERALTOTIMESTAMP(numerator varchar2) 
    return TIMESTAMP_UNCONSTRAINED;    
  function SYS_LITERALTOTZTIMESTAMP(numerator varchar2) 
    return TIMESTAMP_TZ_UNCONSTRAINED;    
  function SYS_LITERALTODATE(numerator varchar2) return DATE;    
                                             
  -- Explicit conversions between date and datetime
  function TO_TIMESTAMP(ARG TIMESTAMP_LTZ_UNCONSTRAINED) return TIMESTAMP;
    pragma BUILTIN('TO_TIMESTAMP', 0, 15, 24);

  function TO_TIMESTAMP_TZ(ARG DATE) return TIMESTAMP WITH TIME ZONE;
    pragma BUILTIN('TO_TIMESTAMP_TZ', 0, 15, 27);

  function TO_TIMESTAMP_TZ(ARG TIMESTAMP_LTZ_UNCONSTRAINED)
                           return TIMESTAMP WITH TIME ZONE;
    pragma BUILTIN('TO_TIMESTAMP_TZ', 0, 15, 26);

  -- IS [NOT] NULL / NVL for datetime 
  function 'IS NULL' (b TIME_UNCONSTRAINED) return BOOLEAN;
  function 'IS NOT NULL' (b TIME_UNCONSTRAINED) return BOOLEAN;
  function NVL (b1 TIME_UNCONSTRAINED, 
                b2 TIME_UNCONSTRAINED) return TIME_UNCONSTRAINED;

  function 'IS NULL' (b TIME_TZ_UNCONSTRAINED) return BOOLEAN;
  function 'IS NOT NULL' (b TIME_TZ_UNCONSTRAINED) return BOOLEAN;
  function NVL (b1 TIME_TZ_UNCONSTRAINED, b2 TIME_TZ_UNCONSTRAINED) 
    return TIME_TZ_UNCONSTRAINED;

  function 'IS NULL' (b TIMESTAMP_UNCONSTRAINED) return BOOLEAN;
  function 'IS NOT NULL' (b TIMESTAMP_UNCONSTRAINED) return BOOLEAN;
  function NVL (b1 TIMESTAMP_UNCONSTRAINED, 
                b2 TIMESTAMP_UNCONSTRAINED) return TIMESTAMP_UNCONSTRAINED;

  function 'IS NULL' (b TIMESTAMP_TZ_UNCONSTRAINED) return BOOLEAN;
  function 'IS NOT NULL' (b TIMESTAMP_TZ_UNCONSTRAINED) return BOOLEAN;
  function NVL (b1 TIMESTAMP_TZ_UNCONSTRAINED, b2 TIMESTAMP_TZ_UNCONSTRAINED) 
    return TIMESTAMP_TZ_UNCONSTRAINED;
 
  function 'IS NULL' (b TIMESTAMP_LTZ_UNCONSTRAINED) return BOOLEAN;
  function 'IS NOT NULL' (b TIMESTAMP_LTZ_UNCONSTRAINED) return BOOLEAN;
  function NVL (b1 TIMESTAMP_LTZ_UNCONSTRAINED, 
                b2 TIMESTAMP_LTZ_UNCONSTRAINED) 
    return TIMESTAMP_LTZ_UNCONSTRAINED;
 
  function 'IS NULL' (b YMINTERVAL_UNCONSTRAINED) return BOOLEAN;
  function 'IS NOT NULL' (b YMINTERVAL_UNCONSTRAINED) return BOOLEAN;
  function NVL (b1 YMINTERVAL_UNCONSTRAINED, b2 YMINTERVAL_UNCONSTRAINED) 
    return YMINTERVAL_UNCONSTRAINED;

  function 'IS NULL' (b DSINTERVAL_UNCONSTRAINED) return BOOLEAN;
  function 'IS NOT NULL' (b DSINTERVAL_UNCONSTRAINED) return BOOLEAN;
  function NVL (b1 DSINTERVAL_UNCONSTRAINED, b2 DSINTERVAL_UNCONSTRAINED) 
    return DSINTERVAL_UNCONSTRAINED;

  function " SYS$EXTRACT_FROM"
              (T TIME_UNCONSTRAINED,FIELD VARCHAR2)return NUMBER;
  function " SYS$EXTRACT_FROM"
              (T TIME_TZ_UNCONSTRAINED,FIELD varchar2) return NUMBER;
  function " SYS$EXTRACT_FROM"
              (T TIMESTAMP_UNCONSTRAINED,FIELD VARCHAR2) return NUMBER;
  function " SYS$EXTRACT_FROM"
              (T TIMESTAMP_TZ_UNCONSTRAINED,FIELD VARCHAR2) return NUMBER;
  function " SYS$EXTRACT_FROM"
              (T TIMESTAMP_LTZ_UNCONSTRAINED,FIELD varchar2) return NUMBER;
  function " SYS$EXTRACT_FROM"
              (T DATE,FIELD VARCHAR2) return NUMBER;
  function " SYS$EXTRACT_FROM"
              (I YMINTERVAL_UNCONSTRAINED,FIELD VARCHAR2) return NUMBER;
  function " SYS$EXTRACT_FROM"
              (I DSINTERVAL_UNCONSTRAINED,FIELD VARCHAR2) return NUMBER;


  -- overlaps 
  FUNCTION sys_over__tt(t1 time_unconstrained,t2 time_unconstrained,
                        t3 time_unconstrained,t4 time_unconstrained) 
                        RETURN BOOLEAN;

  FUNCTION sys_over__ti(t1 time_unconstrained,t2 time_unconstrained,
                        t3 time_unconstrained,t4 dsinterval_unconstrained) 
                        RETURN BOOLEAN;

  FUNCTION sys_over__it(t1 time_unconstrained,t2 dsinterval_unconstrained,
                        t3 time_unconstrained,t4 time_unconstrained) 
                        RETURN BOOLEAN;

  FUNCTION sys_over_iit(t1 time_unconstrained,
                        t2 dsinterval_unconstrained,
                        t3 time_unconstrained,
                        t4 dsinterval_unconstrained) RETURN BOOLEAN;

  FUNCTION sys_over__dd(t1 date,t2 date,
                        t3 date,t4 date) RETURN BOOLEAN;


  FUNCTION sys_over__di(t1 date,t2 date,
                         t3 date,t4 dsinterval_unconstrained) RETURN BOOLEAN;

  FUNCTION sys_over__id(t1 date,t2 dsinterval_unconstrained,
                         t3 date,t4 date) RETURN BOOLEAN;

  FUNCTION sys_over_iid(t1 date,
                        t2 dsinterval_unconstrained,
                        t3 date,
                        t4 dsinterval_unconstrained) RETURN BOOLEAN;


  --#### All user-visible declarations should preceed this point.  The 
  --#### following are implementation-oriented pragmas that may need
  --#### editing in the future; we would prefer to be able to edit them
  --#### without affecting the rft numbering of user-visible items.

  --#### interface pragmas

  PRAGMA interface(c,length,"peslen");
  PRAGMA interface(c,substr,"pessub");
  PRAGMA interface(c,instr,"pesist");
  PRAGMA interface(c,UPPER,"pesupp");
  PRAGMA interface(c,LOWER,"peslow");
  PRAGMA interface(c,ASCII,"pesasc");
  PRAGMA interface(c,CHR,"peschr");
  PRAGMA interface(c," SYS$STANDARD_CHR","peschr");
  PRAGMA interface(c,INITCAP,"pesicp");
  PRAGMA interface(c,LPAD,"peslpd",1);  
  PRAGMA interface(c,LPAD,"peslpd",2);  
  PRAGMA interface(c,RPAD,"pesrpd",1);  
  PRAGMA interface(c,RPAD,"pesrpd",2);
  PRAGMA interface(c,LTRIM,"pesltr",1);
  PRAGMA interface(c,LTRIM,"pesltr",2);
  PRAGMA interface(c,RTRIM,"pesrtr",1);
  PRAGMA interface(c,RTRIM,"pesrtr",2);
  PRAGMA interface(c,'LIKE',"peslik",1);
  PRAGMA interface(c,'LIKE',"pesli2",2);
  PRAGMA interface(c,ABS,"pesabs");
  PRAGMA interface(c,'MOD',"pesmod");
  PRAGMA interface(c,floor,"pesflo");
  PRAGMA interface(c,CEIL,"pescei");
  PRAGMA interface (c, SQRT, "pessqt");
  PRAGMA interface(c,SIGN,"pessgn");
  PRAGMA interface(c,cos,"pescos");
  PRAGMA interface(c,sin,"pessin");
  PRAGMA interface(c,TAN,"pestan");
  PRAGMA interface(c,COSH,"pescsh");
  PRAGMA interface(c,SINH,"pessnh");
  PRAGMA interface(c,TANH,"pestnh");
  PRAGMA interface(c,EXP,"pesexp");
  PRAGMA interface(c,LN,"pesln");
  PRAGMA interface(c,BITAND,"pesbtd");
  PRAGMA interface(c,LOG,"peslog");
  PRAGMA interface(c,TRUNC,"pestru",1);
  PRAGMA interface(c,ROUND,"pesrnd",1);
  PRAGMA interface(c,POWER,"pespow");
  PRAGMA interface(c,NEW_TIME,"pesnwt");
  PRAGMA interface(c,TO_DATE,"pesc2d",4);
  PRAGMA interface(c,TO_NUMBER,"pesc2n",3);
  PRAGMA interface(c,TO_NUMBER,"pesc2n",4);
  PRAGMA interface(c,'>=',"peszge",5); 
  PRAGMA interface(c,'>',"peszgt",5);  
  PRAGMA interface(c,'<=',"peszle",5);
  PRAGMA interface(c,'<',"peszlt",5);  
  PRAGMA interface(c,'=',"peszeq",5);  
  PRAGMA interface(c,'!=',"peszne",5);
  PRAGMA interface(c,nlssort,"pesxco",2);
  PRAGMA interface(c,NLS_UPPER,"pesxup",1);
  PRAGMA interface(c,NLS_LOWER,"pesxlo",1);
  PRAGMA interface(c,NLS_INITCAP,"pesxcp",1);
  PRAGMA interface(c,lengthb,"pesxln");
  PRAGMA interface(c,substrb,"pesxsu");
  PRAGMA interface(c,instrb,"pesxis");
  PRAGMA interface(c,TO_SINGLE_BYTE, "pesxsi");
  PRAGMA interface(c,TO_MULTI_BYTE,"pesxmu");
  PRAGMA interface(c,TO_CHAR,"pesd2c",7);
  PRAGMA interface(c,TO_CHAR,"pesn2c",8);
  PRAGMA interface(c," SYS$STANDARD_TRANSLATE","pesxcs");
  PRAGMA interface(c,ATAN,"pesatan");
  PRAGMA interface(c,EMPTY_CLOB,"peslcem");  
  PRAGMA interface(c,EMPTY_BLOB,"peslbem");
  PRAGMA interface(c,BFILENAME,"pesfnm");  
  PRAGMA interface(c,TO_TIME,"pes3tm",2);
  PRAGMA interface(c,TO_TIME,"pes3tm",3);
  PRAGMA interface(c,TO_TIMESTAMP,"pes3ts",2);
  PRAGMA interface(c,TO_TIMESTAMP,"pes3ts",3);
  PRAGMA interface(c,TO_TIMESTAMP_TZ,"pes3tp",2); 
  PRAGMA interface(c,TO_TIMESTAMP_TZ,"pes3tp",3);
  PRAGMA interface(c,TO_TIME_TZ,"pes3te",2);
  PRAGMA interface(c,TO_TIME_TZ,"pes3te",3); 
  PRAGMA interface(c,TO_DSINTERVAL,"pes2dsi",2);
  PRAGMA interface(c,sys_over__tt,"pesott",1);
  PRAGMA interface(c,sys_over__ti,"pesoti",1);
  PRAGMA interface(c,sys_over_iit,"pesoiit",1);
  PRAGMA interface(c,sys_over__dd,"pesodd",1);
  PRAGMA interface(c,sys_over__di,"pesodi",1);
  PRAGMA interface(c,sys_over_iid,"pesoiid",1);
  PRAGMA interface(c,SYS_AT_TIME_ZONE,"pesatz",1);
  PRAGMA interface(c,SYS_AT_TIME_ZONE,"pesatz",2);
  PRAGMA interface(c,SESSIONTIMEZONE,"pessestz",1);
  PRAGMA interface(c," SYS$STANDARD_TRIM","pestrim",1);
  PRAGMA interface(c," SYS$STANDARD_TRIM","pestrim",2);
  PRAGMA interface(c," SYS$STANDARD_TRIM","pestrim",3);
  PRAGMA interface(c,TRIM,"pestrim",1);
  -- Datetime addition
  PRAGMA interface(c,'+',"pesati",5);    --  +(tsp, iym) return tsp
  PRAGMA interface(c,'+',"pesati",6);    --  +(tsp, ids) return tsp
  PRAGMA interface(c,'+',"pesati",7);    --  +(tsz, iym) return tsz
  PRAGMA interface(c,'+',"pesati",8);    --  +(tsz, ids) return tsz
  PRAGMA interface(c,'+',"pesati",9);    --  +(tim, ids) return tim
  PRAGMA interface(c,'+',"pesati",10);   --  +(tmz, ids) return tmz
  PRAGMA interface(c,'+',"pesadi",11);   --  +(dat, iym) return dat
  PRAGMA interface(c,'+',"pesadi",12);   --  +(dat, ids) return dat
  PRAGMA interface(c,'+',"pesait",13);   --  +(iym, tsp) return tsp
  PRAGMA interface(c,'+',"pesait",14);   --  +(iym, tsz) return tsz
  PRAGMA interface(c,'+',"pesaid",15);   --  +(iym, dat) return dat
  PRAGMA interface(c,'+',"pesait",16);   --  +(ids, tsp) return tsp
  PRAGMA interface(c,'+',"pesait",17);   --  +(ids, tsz) return tsz
  PRAGMA interface(c,'+',"pesait",18);   --  +(ids, tim) return tim
  PRAGMA interface(c,'+',"pesait",19);   --  +(ids, tmz) return tmz
  PRAGMA interface(c,'+',"pesaid",20);   --  +(ids, dat) return dat
  PRAGMA interface(c,'+',"pesaii",21);   --  +(ids, ids) return ids
  PRAGMA interface(c,'+',"pesaii",22);   --  +(iym, iym) return iym
  PRAGMA interface(c,'+',"pesati",23);   --  +(ltz, iym) return ltz
  PRAGMA interface(c,'+',"pesati",24);   --  +(ltz, ids) return ltz
  PRAGMA interface(c,'+',"pesait",25);   --  +(iym, ltz) return ltz
  PRAGMA interface(c,'+',"pesait",26);   --  +(ids, ltz) return ltz
  -- Datetime subtraction
  PRAGMA interface(c,'-',"pessti",6);    --  -(tsp, iym) return tsp
  PRAGMA interface(c,'-',"pessti",7);    --  -(tsp, ids) return tsp
  PRAGMA interface(c,'-',"pessti",8);    --  -(tsz, iym) return tsz
  PRAGMA interface(c,'-',"pessti",9);    --  -(tsz, ids) return tsz
  PRAGMA interface(c,'-',"pessti",10);   --  -(tim, ids) return tim
  PRAGMA interface(c,'-',"pessti",11);   --  -(tmz, ids) return tmz
  PRAGMA interface(c,'-',"pessdi",12);   --  -(dat, iym) return dat
  PRAGMA interface(c,'-',"pessdi",13);   --  -(dat, ids) return dat
  PRAGMA interface(c,'-',"pessii",14);   --  -(iym, iym) return iym
  PRAGMA interface(c,'-',"pessii",15);   --  -(ids, ids) return ids
  PRAGMA interface(c,'-',"pessttds",16); --  -(tim, tim) return ids
  PRAGMA interface(c,'-',"pessttds",17); --  -(tsp, tsp) return ids
  PRAGMA interface(c,'-',"pessttds",18); --  -(tmz, tmz) return ids
  PRAGMA interface(c,'-',"pessttds",19); --  -(tsz, tsz) return ids
  PRAGMA interface(c,'-',"pessti",20);   --  -(ltz, iym) return iym
  PRAGMA interface(c,'-',"pessti",21);   --  -(ltz, ids) return ids
  PRAGMA interface(c,'-',"pessttds",22); --  -(ltz, ltz) return ids
  PRAGMA interface(c," SYS$DSINTERVALSUBTRACT","pessttds",1);
  PRAGMA interface(c," SYS$DSINTERVALSUBTRACT","pessttds",2);
  PRAGMA interface(c," SYS$DSINTERVALSUBTRACT","pessttds",3);
  PRAGMA interface(c," SYS$DSINTERVALSUBTRACT","pessttds",4);
  PRAGMA interface(c," SYS$DSINTERVALSUBTRACT","pessddds",5);
  PRAGMA interface(c," SYS$DSINTERVALSUBTRACT","pessttds",6);
  PRAGMA interface(c," SYS$YMINTERVALSUBTRACT","pessttym",1);
  PRAGMA interface(c," SYS$YMINTERVALSUBTRACT","pessttym",2);
  PRAGMA interface(c," SYS$YMINTERVALSUBTRACT","pessddym",3);
  PRAGMA interface(c," SYS$YMINTERVALSUBTRACT","pessttym",4);
  -- Datetime multiplication
  PRAGMA interface(c,'*',"pesmni",2);    --  *(num, iym) return iym
  PRAGMA interface(c,'*',"pesmni",3);    --  *(num, ids) return ids
  PRAGMA interface(c,'*',"pesmin",4);    --  *(iym, num) return iym
  PRAGMA interface(c,'*',"pesmin",5);    --  *(ids, num) return ids
  -- Datetime division
  PRAGMA interface(c,'/',"pesdvin",2);   --  /(iym, num) return iym
  PRAGMA interface(c,'/',"pesdvin",3);   --  /(ids, num) return ids
  -- TIME
  PRAGMA interface(c,'=',"peseqt",10);
  PRAGMA interface(c,'!=',"pesnet",10);
  PRAGMA interface(c,'>',"pesgtt",8);
  PRAGMA interface(c,'<',"pesltt",8);
  PRAGMA interface(c,'>=',"pesget",8);
  PRAGMA interface(c,'<=',"peslet",8);
  -- TIME WITH TIME ZONE
  PRAGMA interface(c,'=',"peseqt",11);
  PRAGMA interface(c,'!=',"pesnet",11);
  PRAGMA interface(c,'>',"pesgtt",9);
  PRAGMA interface(c,'<',"pesltt",9);
  PRAGMA interface(c,'>=',"pesget",9);
  PRAGMA interface(c,'<=',"peslet",9);
  -- TIMESTAMP
  PRAGMA interface(c,'=',"peseqt",12);
  PRAGMA interface(c,'!=',"pesnet",12);
  PRAGMA interface(c,'>',"pesgtt",10);
  PRAGMA interface(c,'<',"pesltt",10);
  PRAGMA interface(c,'>=',"pesget",10);
  PRAGMA interface(c,'<=',"peslet",10);
  -- INTERVAL YEAR TO MONTH
  PRAGMA interface(c,'=',"peseqi",13);
  PRAGMA interface(c,'!=',"pesnei",13);
  PRAGMA interface(c,'>',"pesgti",11);
  PRAGMA interface(c,'<',"peslti",11);
  PRAGMA interface(c,'>=',"pesgei",11);
  PRAGMA interface(c,'<=',"peslei",11);
  -- INTERVAL DAY TO SECOND
  PRAGMA interface(c,'=',"peseqi",14);
  PRAGMA interface(c,'!=',"pesnei",14);
  PRAGMA interface(c,'>',"pesgti",12);
  PRAGMA interface(c,'<',"peslti",12);
  PRAGMA interface(c,'>=',"pesgei",12);
  PRAGMA interface(c,'<=',"peslei",12);
  -- TIMESTAMP_TZ_UNCONSTRAINED     
  PRAGMA interface(c,'=',"peseqt",15);
  PRAGMA interface(c,'!=',"pesnet",15);
  PRAGMA interface(c,'>',"pesgtt",13);
  PRAGMA interface(c,'<',"pesltt",13);
  PRAGMA interface(c,'>=',"pesget",13);
  PRAGMA interface(c,'<=',"peslet",13);
  -- TIMESTAMP WITH LOCAL TIME ZONE
  PRAGMA interface(c,'=',"peseqt",16);
  PRAGMA interface(c,'!=',"pesnet",16);
  PRAGMA interface(c,'>',"pesgtt",14);
  PRAGMA interface(c,'<',"pesltt",14);
  PRAGMA interface(c,'>=',"pesget",14);
  PRAGMA interface(c,'<=',"peslet",14);
  -- Other datetime functions
  PRAGMA interface(c,'CURRENT_DATE',"pescdt",1);
  PRAGMA interface(c,'CURRENT_TIME',"pesctm",1);
  PRAGMA interface(c,'CURRENT_TIMESTAMP',"pescts",1);
  --  Internal calls to evaluate datetime/interval literals without NLS parms.
  PRAGMA interface(c,SYS_LITERALTOYMINTERVAL,"pesc2ymi",1);
  PRAGMA interface(c,SYS_LITERALTODSINTERVAL,"pesc2dsi",1);
  PRAGMA interface(c,SYS_LITERALTOTIME,"pesc2tim",1);
  PRAGMA interface(c,SYS_LITERALTOTZTIME,"pesc2tim",1);
  PRAGMA interface(c,SYS_LITERALTOTIMESTAMP,"pesc2tsp",1);
  PRAGMA interface(c,SYS_LITERALTOTZTIMESTAMP,"pesc2tsp",1);
  PRAGMA interface(c,SYS_LITERALTODATE,"pesc2date",1);
  -- is null 
  PRAGMA interface(c,"IS NULL","pesdin",14); -- time
  PRAGMA interface(c,"IS NULL","pesdin",15); -- time wtz
  PRAGMA interface(c,"IS NULL","pesdin",16); -- timestamp
  PRAGMA interface(c,"IS NULL","pesdin",17); -- timestamp wtz
  PRAGMA interface(c,"IS NULL","pesdin",18); -- timestamp lwtz
  PRAGMA interface(c,"IS NULL","pesiin",19); -- interval ym
  PRAGMA interface(c,"IS NULL","pesiin",20); -- interval ds
  -- extract(field from expr)
  PRAGMA interface(c," SYS$EXTRACT_FROM","pesefd",1);  
  PRAGMA interface(c," SYS$EXTRACT_FROM","pesefd",2);
  PRAGMA interface(c," SYS$EXTRACT_FROM","pesefd",3);
  PRAGMA interface(c," SYS$EXTRACT_FROM","pesefd",4);
  PRAGMA interface(c," SYS$EXTRACT_FROM","pesefd",5);
  PRAGMA interface(c," SYS$EXTRACT_FROM","pesefdt",6);
  PRAGMA interface(c," SYS$EXTRACT_FROM","pesefi",7);
  PRAGMA interface(c," SYS$EXTRACT_FROM","pesefi",8);

  --#### new_names pragmas

  -- This is an internal pragma that restricts the use
  -- of particular new entries in package standard.
  -- It is only valid in package standard.
  -- Note that left out of the 8.1.5 set are non datetime
  -- entries urowid, "UROWID ", self_is_null and trim.

  pragma new_names('8.1.5',
                   time,"TIME WITH TIME ZONE",
                   timestamp,"TIMESTAMP WITH TIME ZONE",
                   "INTERVAL DAY TO SECOND",
                   "INTERVAL YEAR TO MONTH",
                   to_time, to_timestamp,
                   to_time_tz, to_timestamp_tz,
                   " SYS$DSINTERVALSUBTRACT",
                   " SYS$YMINTERVALSUBTRACT",
                   to_yminterval,to_dsinterval,
                   NUMTOYMINTERVAL, NUMTODSINTERVAL,
                   current_date, 
                   current_time,current_timestamp);

  pragma new_names('8.1.6',
                   dbtimezone, sessiontimezone, localtimestamp,
                   localtime, to_local_tz, to_db_tz,
                   cube, rollup, grouping, "TIMESTAMP WITH LOCAL TIME ZONE");

  --#### timestamp pragma (please keep this last)

  -- The following pragma overrides any other setting of the timestamp,
  -- and is used so that we recognize the client-side and server-side instances
  -- of package STANDARD as being the same.  Package STANDARD is special in
  -- that it is really the root of the PL/SQL dependencies graph; as such it
  -- itself doesn't ever need recompiling due to changes to things below it.
  -- The pragma mechanism used here is currently ignored except for
  -- package STANDARD, but in future may not be.  Do NOT add similar pragmas
  -- to your own code as it may in future interfere with the package
  -- consistency maintenance mechanisms and could have dire results.
  pragma TIMESTAMP('1996-11-19:00:00:00');
end;
/
create or replace 
package body STANDARD is         -- careful on this line; SED edit occurs!

subtype Cursor_Handle is binary_integer range 0..255;

-- icds 

  function pesxlt(ch VARCHAR2 CHARACTER SET ANY_CS,
                  cpy VARCHAR2 CHARACTER SET ch%CHARSET,
                  frm VARCHAR2 CHARACTER SET ch%CHARSET,
                  too VARCHAR2 CHARACTER SET ch%CHARSET)
        return VARCHAR2 CHARACTER SET ch%CHARSET;
    pragma interface (c,pesxlt);

  function peslik(str VARCHAR2 CHARACTER SET ANY_CS,
                   pat VARCHAR2 CHARACTER SET str%CHARSET)
        return BOOLEAN;
    pragma interface (c,peslik);

  function pesli2(str VARCHAR2 CHARACTER SET ANY_CS,
                   pat VARCHAR2 CHARACTER SET str%CHARSET,
                   esc VARCHAR2 CHARACTER SET str%CHARSET)
        return BOOLEAN;
    pragma interface (c,pesli2);

-- trig fns 
  function pesxco(c VARCHAR2 CHARACTER SET ANY_CS, format VARCHAR2) return raw;
    pragma interface (c,pesxco);

  function pesxup(ch VARCHAR2 CHARACTER SET ANY_CS, format VARCHAR2)
        return VARCHAR2 CHARACTER SET ch%CHARSET;
    pragma interface (c,pesxup);

  function pesxlo(ch VARCHAR2 CHARACTER SET ANY_CS, format VARCHAR2)
        return VARCHAR2 CHARACTER SET ch%CHARSET;
    pragma interface (c,pesxlo);

  function pesxcp(ch VARCHAR2 CHARACTER SET ANY_CS, format VARCHAR2)
        return VARCHAR2 CHARACTER SET ch%CHARSET;
    pragma interface (c,pesxcp);

-- end of NLS icds

-- begin trusted icds
-- Comparisons
-- Conversions
--  function peslts(label MLSLABEL,format VARCHAR2) return VARCHAR2;
--    pragma interface (c,peslts);
--  function pesstl(label varchar2,format VARCHAR2) return MLSLABEL;
--    pragma interface (c,pesstl);
-- end trusted icds
-----------------------------------------------------------

  function 'IS NOT NULL'(b BOOLEAN) return BOOLEAN is
  begin
    return (NOT b IS NULL);
  end 'IS NOT NULL';

  function NVL (b1 BOOLEAN, b2 BOOLEAN) return BOOLEAN is
  begin
    if (b1 IS NULL) then return (b2); else return(b1); end if;
  end NVL;

  function sqlerrm return varchar2 is
    n1 number;
  begin
    n1 := sqlcode;
    return sqlerrm(n1);
  end sqlerrm;

  function SOUNDEX(ch VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET ch%CHARSET is
    c VARCHAR2(2000) CHARACTER SET ch%CHARSET;
  begin
  --return pessdx(ch);
    select soundex(ch) into c from sys.dual;
    return c;
  end SOUNDEX;

  function TRANSLATE(STR1 VARCHAR2 CHARACTER SET ANY_CS,
                     SRC VARCHAR2 CHARACTER SET STR1%CHARSET,
                     DEST VARCHAR2 CHARACTER SET STR1%CHARSET)
        return VARCHAR2 CHARACTER SET STR1%CHARSET is
  begin
    if str1 is null then return str1; else
        -- The substr and concat in arg list to pesxlt is done to
        -- allocate a modifiable COPY of the first arg, STR1. This
        -- operation is a complete cheat, because we pass the copy
        -- as an IN parm, and modify it on the sly.  
    return pesxlt(STR1, substr(str1,1,1) || substr(str1,2),
                           SRC, DEST);
    end if;
  end TRANSLATE;

  function REPLACE(SRCSTR VARCHAR2 CHARACTER SET ANY_CS,
                   OLDSUB VARCHAR2 CHARACTER SET SRCSTR%CHARSET,
                   NEWSUB VARCHAR2 CHARACTER SET SRCSTR%CHARSET := NULL)
        return VARCHAR2 CHARACTER SET SRCSTR%CHARSET is
  brk binary_integer;
  begin
    if srcstr is null then return srcstr; -- NULL
    else
        brk := instr(srcstr, oldsub);
        if brk > 0
        then
          return(substr(srcstr, 1, brk - 1) || newsub 
                 || replace(substr(srcstr, 
                                    brk + length(oldsub)),
                            oldsub, newsub));
        else return srcstr; 
        end if;
    end if;
  end;

  function 'NOT_LIKE' (str VARCHAR2 CHARACTER SET ANY_CS,
                       pat VARCHAR2 CHARACTER SET str%CHARSET)
        return BOOLEAN is
  begin
    return (not peslik(str, pat));
  end;
  function 'NOT_LIKE' (str VARCHAR2 CHARACTER SET ANY_CS,
                       pat VARCHAR2 CHARACTER SET str%CHARSET,
                       esc VARCHAR2 CHARACTER SET str%CHARSET)
        return BOOLEAN is
  begin
    return (not pesli2(str, pat, esc));
  end;

  function 'IS NOT NULL' (s VARCHAR2 CHARACTER SET ANY_CS) return BOOLEAN is
  begin
    return (NOT (s IS NULL));
  end 'IS NOT NULL';

  function NVL(s1 VARCHAR2 CHARACTER SET ANY_CS,
               s2 VARCHAR2 CHARACTER SET s1%CHARSET)
        return VARCHAR2 CHARACTER SET s1%CHARSET is
  begin
    if (s1 IS NULL) then return (s2); else return (s1); end if;
  end NVL;

  function 'IS NOT NULL'(n NUMBER) return BOOLEAN is
  begin
    return (NOT (n IS NULL));
  end 'IS NOT NULL';

  function NVL (n1 NUMBER, n2 NUMBER) return NUMBER is
  begin
    if (n1 IS NULL) then return (n2); else return(n1); end if;
  end NVL;

  function 'REM' (LEFT NUMBER, RIGHT NUMBER) return NUMBER is
  begin
    return (LEFT - (trunc(LEFT / RIGHT) * RIGHT));
  end;

  function '**' (LEFT NUMBER, RIGHT NUMBER) return NUMBER is
  begin
    return (POWER(LEFT, RIGHT));
  end;

  function 'IS NOT NULL'(d DATE) return BOOLEAN is
  begin
    return(NOT (d IS NULL));
  end 'IS NOT NULL';

  function NVL (d1 DATE, d2 DATE) return DATE is
  begin
    if (d1 IS NULL) then return(d2); else return(d1); end if;
  end NVL;

-- Just call the other to_char with a null format string. 
-- Perhaps this can be done more intelligently in the future. JEM 3/14/90.
--  function TO_CHAR(LEFT NUMBER)        return varchar2 is
--  begin
--    return TO_CHAR(LEFT, '');
--  end TO_CHAR;

-- Added 3/16/90 by JEM.
 function TO_NUMBER(LEFT NUMBER) return NUMBER is
 begin
   return(LEFT);
 end to_number;

 function TO_DATE(LEFT NUMBER, RIGHT VARCHAR2) return DATE IS
 begin
   return (TO_DATE(TO_char(LEFT), RIGHT));
 end TO_DATE;

  --  SQL 'PSD' routines
  --
  --  NB: These 5 are all obsoleted by plzsql() below, but leave them here for
  --  backward compatibility.

  Procedure plzopn(cnum OUT Cursor_Handle, rc OUT Binary_Integer);
          pragma interface (c,plzopn);
  Function plzosq(cnum Cursor_Handle, stmt VARCHAR2) return Binary_Integer;
          pragma interface (c,plzosq);
  Function plzexe(cnum Cursor_Handle,chp Binary_Integer,nbnds Binary_Integer) 
          return Binary_Integer;
          pragma interface (c,plzexe);
  Function plzexe(cnum Cursor_Handle) return Binary_Integer is
  Begin
        return(plzexe(cnum,0,0));
  End;
  Function plzcls(cnum Cursor_Handle) return Binary_Integer;
          pragma interface (c,plzcls);
        

  function UID return NUMBER is
  n number;
  begin
        select uid into n from sys.dual;
        return n;
  end;

  function USER return varchar2 is
  c varchar2(255);
  begin
        select user into c from sys.dual;
        return c;
  end;


  function USERENV (envstr VARCHAR2) return varchar2 is
  c varchar2(255);
  begin
    c := upper(envstr);
    if c is null then 
        null;
    elsif c = 'TERMINAL' then
        select userenv('TERMINAL') into c from sys.dual;
    elsif c = 'ENTRYID' then
        select userenv('ENTRYID') into c from sys.dual;
    elsif c = 'SESSIONID' then
        select userenv('SESSIONID') into c from sys.dual;
    elsif c = 'LANGUAGE' then
        select userenv('LANGUAGE') into c from sys.dual;
    elsif c = 'LABEL' then
        select userenv('LABEL') into c from sys.dual;
    elsif c = 'LANG' then
        select userenv('LANG') into c from sys.dual;
    elsif c = 'OSDBA' then
        select userenv('OSDBA') into c from sys.dual;
    elsif c = 'INSTANCE' then
        select userenv('INSTANCE') into c from sys.dual;
    elsif c = 'CLIENT_INFO' then
        select userenv('CLIENT_INFO') into c from sys.dual;
    else raise VALUE_ERROR;
    end if;
    return c;
  end;

-- Trusted*Oracle additions 

  Function ROWLABEL return MLSLABEL is
        begin return null; end;
-- removed - now builtin's

--  Function TO_CHAR(label MLSLABEL, format varchar2 := '')
--       return VARCHAR2 is
--    begin return peslts(label,format); end;
--
--  Function TO_LABEL(label varchar2, format varchar2 := '')
--       return MLSLABEL is
--    begin return pesstl(label,format); end;

-- Comparison functions 
  function 'IS NOT NULL'(label MLSLABEL) return BOOLEAN is
  begin
    return (NOT (label IS NULL));
  end 'IS NOT NULL';

  function NVL (label1 MLSLABEL, label2 MLSLABEL) return MLSLABEL is
  begin
    if (label1 IS NULL) then return (label2); else return (label1); end if;
  end NVL;

-- group functions 
  Function LUB (label MLSLABEL) return MLSLABEL is
        begin return null; end;
  Function GLB (label MLSLABEL) return MLSLABEL is
        begin return null; end;

-- end of Trusted*Oracle additions 

    
-- beginning of NLS routines 
-- replaced with new versions 6/3/92 JEM 

  function NLSSORT(c VARCHAR2 CHARACTER SET ANY_CS) return RAW is
  begin
    return pesxco(c,'');
  end NLSSORT;

  function NLS_UPPER(ch VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET ch%CHARSET is
  begin
    return pesxup(ch,'');
  end NLS_UPPER;

  function NLS_LOWER(ch VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET ch%CHARSET is
  begin
    return pesxlo(ch,'');
  end NLS_LOWER;

  function NLS_INITCAP(ch VARCHAR2 CHARACTER SET ANY_CS)
        return VARCHAR2 CHARACTER SET ch%CHARSET is
  begin
    return pesxcp(ch,'');
  end NLS_INITCAP;

  function NLS_CHARSET_NAME(csetid NUMBER) 
    return VARCHAR2 is
   v varchar2(2000);
  begin
   select nls_charset_name(csetid) into v from sys.dual;
   return v;
  end NLS_CHARSET_NAME;

  function NLS_CHARSET_ID(csetname VARCHAR2) 
    return NUMBER is
   n NUMBER;
  begin
   select nls_charset_id(csetname) into n from sys.dual;
   return n;
  end NLS_CHARSET_ID;

  function NLS_CHARSET_DECL_LEN(bytecnt NUMBER, csetid NUMBER) 
    return NUMBER is
   n NUMBER;
  begin
   select nls_charset_decl_len(bytecnt, csetid) into n from sys.dual;
   return n;
  end NLS_CHARSET_DECL_LEN;
-- end of NLS routines 


  function CONVERT(src varchar2, destcset varchar2) return varchar2
  is
   v varchar2(2000);
  begin
   select convert(src,destcset) into v from sys.dual;
   return v;
  end;

  function CONVERT(src varchar2, destcset varchar2,srccset varchar2)
        return varchar2
  is
    v varchar2(2000);
  begin
    select convert(src,destcset,srccset) into v from sys.dual;
    return v;
  end;

-- DUMP and VSIZE are now not allowed in non-sql plsql, has code to forbid 
-- it there, and is defined as a builtin in stdspc. The body will not be 
-- called in plsql.
--- CMB
----
-- dump 
-- dump( expr [,display_format[,start_pos[,length]]]) return varchar2
-- how large should the plsql varchar2 string be 
--

-- why do we need these dummy bodies for LEVEL and ROWNUM?

  function LEVEL return NUMBER is
        begin return 0.0; end;

  function ROWNUM return NUMBER is
        begin return 0.0; end;

--
-- ACOS, ASIN, ATAN, ATAN2 
--   These functions return NULL if any of the inputs are NULL
--
  function pesacos(n NUMBER) return NUMBER;
    pragma interface (c,pesacos);

  function pesasin(n NUMBER) return NUMBER;
    pragma interface (c,pesasin);

  function pesatn2(x NUMBER, y NUMBER) return NUMBER;
    pragma interface (c,pesatn2);

  function ACOS(n NUMBER) return NUMBER is
  begin
    if (n > 1) or (n < -1) then raise VALUE_ERROR; end if;
    return pesacos(n);
  end ACOS;

  function ASIN(n NUMBER) return NUMBER is
  begin
    if (n > 1) or (n < -1) then raise VALUE_ERROR; end if;
    return pesasin(n);
  end ASIN;

  function ATAN2(x NUMBER, y NUMBER) return NUMBER is
  begin
    if ((x = 0) and (y = 0)) then raise VALUE_ERROR; end if;
    return pesatn2(x, y);
  end ATAN2;

-- LOB IS NOT NULL
  function 'IS NOT NULL'(n CLOB CHARACTER SET ANY_CS) return BOOLEAN is
  begin
    return (NOT n IS NULL);
  end 'IS NOT NULL';

  function 'IS NOT NULL'(n BLOB) return BOOLEAN is
  begin
    return (NOT n IS NULL);
  end 'IS NOT NULL';

--  function 'IS NOT NULL'(n CFILE) return BOOLEAN is
--  begin
--    return (NOT n IS NULL);
--  end 'IS NOT NULL';

  function 'IS NOT NULL'(n BFILE) return BOOLEAN is
  begin
    return (NOT n IS NULL);
  end 'IS NOT NULL';
-- end LOB IS NOT NULL

--****************************************************************

  function NVL (B1 "<ADT_1>", B2 "<ADT_1>") return "<ADT_1>" is
  begin
    if (B1 IS NULL) then return(B2); else return(B1); end if;
  end NVL;

  function NVL (B1 REF "<ADT_1>", B2 REF "<ADT_1>") return REF "<ADT_1>" is
  begin
    if (B1 IS NULL) then return(B2); else return(B1); end if;
  end NVL;

  function NVL (B1 "<COLLECTION_1>", B2 "<COLLECTION_1>") 
        return "<COLLECTION_1>" is
  begin
    if (B1 IS NULL) then return(B2); else return(B1); end if;
  end NVL;

  function NVL (B1 "<REF_CURSOR_1>", B2 "<REF_CURSOR_1>") 
        return "<REF_CURSOR_1>" is
  begin
    if (B1 IS NULL) then return(B2); else return(B1); end if;
  end NVL;

  function 'IS NOT NULL'(B "<ADT_1>") return BOOLEAN is
  begin
    return (NOT B IS NULL);
  end 'IS NOT NULL';

  function 'IS NOT NULL'(B REF "<ADT_1>") return BOOLEAN is
  begin
    return (NOT B IS NULL);
  end 'IS NOT NULL';

  function 'IS NOT NULL'(B "<COLLECTION_1>") return BOOLEAN is
  begin
    return (NOT B IS NULL);
  end 'IS NOT NULL';

  function 'IS NOT NULL'(B "<REF_CURSOR_1>") return BOOLEAN is
  begin
    return (NOT B IS NULL);
  end 'IS NOT NULL';

  /* these are special internal functions
     they are potential dangerous and not to be used by customers */
  function "SYS$LOB_REPLICATION" (x in blob) return blob 
        is begin return x; end;
  function "SYS$LOB_REPLICATION" (x in clob character set any_cs) 
    return clob character set x%charset
  is begin return x; end;

  function 'IS NOT NULL' (u UROWID) return BOOLEAN is
  begin
    return (NOT (u IS NULL));
  end 'IS NOT NULL';

  -- Should there be 'IS [NOT] NULL' for datetime ?
  
  --  Generic SQL DDL routine
  --
  --  This used to use plzopn, plzosq, etc. declared above;  now we use a 
  --  single bundled call.  Move these defs here so new ICD will not disturb
  --  the ordering of the list.

  FUNCTION plzsql(stmt VARCHAR2) RETURN binary_integer;
  PRAGMA interface (c,plzsql);
  
  procedure SQL_DDL(Stmt VARCHAR2) is
         rc Binary_Integer;
         DDL_ERROR exception;
  Begin
         rc := plzsql(Stmt);
         if ( rc IS NOT NULL ) then
                RAISE DDL_ERROR;
         end if;
  End;

  --  SQL Transaction routines

  procedure SET_TRANSACTION_USE (vc varchar2) is
  Begin
         SQL_DDL('SET TRANSACTION USE ROLLBACK SEGMENT ' || vc);
  End;

  procedure COMMIT is
  Begin
         SQL_DDL('COMMIT');
  End;

  procedure COMMIT_CM (vc varchar2) is
  Begin
         SQL_DDL('COMMIT work comment ' || '''' || vc || '''');
  End;

  procedure ROLLBACK_NR is
  Begin
         SQL_DDL('ROLLBACK');
  End;

  procedure ROLLBACK_SV(Save_Point CHAR) is
  Begin
         SQL_DDL('ROLLBACK TO ' || Save_Point);
  End;

  procedure SAVEPOINT(Save_Point CHAR) is
  begin
         SQL_DDL('SAVEPOINT ' || Save_Point);
  end;


------ Datetime code starts here ------
  
 
-- functions to create intervals from constituent parts.  

  function pesn2ymi(numerator number, units number)
    return "INTERVAL YEAR TO MONTH";
  pragma interface (c,pesn2ymi);
  function pesn2dsi(numerator number, units number)
     return "INTERVAL DAY TO SECOND";
  pragma interface (c,pesn2dsi);

  function NUMTOYMINTERVAL(numerator number, units number) 
     return "INTERVAL YEAR TO MONTH"
     is begin return pesn2ymi(numerator,units); end;
  function NUMTODSINTERVAL(numerator number, units number) 
     return "INTERVAL DAY TO SECOND"
     is begin return pesn2dsi(numerator,units); end;

 function NUMTOYMINTERVAL(numerator number, units varchar2) 
     return "INTERVAL YEAR TO MONTH"
     IS unitno NUMBER := 0; unitstr VARCHAR2(5) := upper(trim(units));
     begin 
     IF (unitstr = 'YEAR')  THEN unitno := 1; 
     elsif (unitstr = 'MONTH') THEN unitno := 2; 
     END IF;
     return pesn2ymi(numerator,unitno); 
     -- IF unitno := 0 core will RAISE correct error
     end;

 function NUMTODSINTERVAL(numerator number, units varchar2) 
     return "INTERVAL DAY TO SECOND"
          IS unitno NUMBER := 0; unitstr VARCHAR2(6) := upper(trim(units));
     begin 
     IF (unitstr = 'DAY') THEN  unitno := 1; 
     elsif (unitstr = 'HOUR') THEN unitno := 2; 
     elsif (unitstr = 'MINUTE') THEN  unitno := 3; 
     elsif (unitstr = 'SECOND') THEN unitno := 4; 
     END IF;
     return pesn2dsi(numerator,unitno); 
     -- IF unitno = 0 core will RAISE correct error
     end;
     
  --  In stdspc.pls this was 
  --  PRAGMA interface(c,sysdate,"pessdt");
  --  now we call the server directly
  function sysdate return date is 
   d date; 
   begin 
     select sysdate into d from sys.dual;
     return d;
   end;   
     

  function SYS_GUID return raw is
  c raw(16);
  begin
        select sys_guid() into c from sys.dual;
        return c;
  end;

  function SYS_CONTEXT(namespace varchar2, attribute varchar2)
    return varchar2 is 
  c varchar2(4000);
  BEGIN
     select sys_context(namespace,attribute) into c from sys.dual;
     return c;
  end;
  FUNCTION sys_over__id(t1 date,
                        t2 dsinterval_unconstrained,
                        t3 date,
                        t4 date) RETURN BOOLEAN
   is BEGIN RETURN sys_over__di(t3,t4,t1,t2); END;   

  FUNCTION sys_over__it(t1 time_unconstrained,
                        t2 dsinterval_unconstrained,
                        t3 time_unconstrained,
                        t4 time_unconstrained) RETURN BOOLEAN
   is BEGIN RETURN sys_over__ti(t3,t4,t1,t2); END;   

    

-- time zone functions       

  FUNCTION systimestamp RETURN timestamp_tz_unconstrained 
  IS  t timestamp_tz_unconstrained;
  BEGIN
    SELECT systimestamp INTO t FROM sys.dual; 
    RETURN t; 
  END;
  
  FUNCTION dbtimezone RETURN varchar2
  IS  t VARCHAR2(7);
  BEGIN 
    SELECT dbtimezone INTO t FROM sys.dual;
    RETURN t; 
  END;

  FUNCTION localtimestamp RETURN timestamp_unconstrained
  IS t timestamp_tz_unconstrained := current_timestamp;
  BEGIN
   RETURN (cast(t AS timestamp_unconstrained)); 
  END;
  
  FUNCTION localtime RETURN time_unconstrained
  IS t time_tz_unconstrained := current_time;
  BEGIN 
   RETURN (cast(t AS time_unconstrained)); 
  END;

          
   --- t in implicit tz to session tz
  FUNCTION TO_LOCAL_TZ(t timestamp_unconstrained) 
      return timestamp_tz_unconstrained
  is
  begin 
    return (t at local);
  end;

  FUNCTION TO_LOCAL_TZ(t timestamp_tz_unconstrained) 
           return timestamp_tz_unconstrained
    is
  begin 
    return (t at local);
  end;

      
  FUNCTION TO_DB_TZ(t timestamp_unconstrained) 
    return timestamp_tz_unconstrained
  is
   t2 timestamp_tz_unconstrained;
  begin 
    select to_db_tz(t) into t2 from sys.dual;
    return t2;
  end;

  FUNCTION TO_DB_TZ(t timestamp_tz_unconstrained) 
    return timestamp_tz_unconstrained
  is 
   t2 timestamp_tz_unconstrained;
  begin 
    select to_db_tz(t) into t2 from sys.dual;
    return t2;
  end;

  function SYS_CONTEXT(namespace varchar2, attribute varchar2, newoptional varchar2)
    return varchar2 is 
  c varchar2(4000);
  BEGIN
     select sys_context(namespace,attribute, newoptional) into c from sys.dual;
     return c;
  end;

  -- We never expect this function to be called in PL/SQL - this is enforced
  -- in PH2
  function CUBE return NUMBER is
  begin
    raise PROGRAM_ERROR;
  end CUBE;

  -- We never expect this function to be called in PL/SQL - this is enforced
  -- in PH2
  function ROLLUP return NUMBER is
  begin
    raise PROGRAM_ERROR;
  end ROLLUP;

  -- We never expect this function to be called in PL/SQL - this is enforced
  -- in PH2
  function GROUPING(v VARCHAR2) return NUMBER is
  begin
    raise PROGRAM_ERROR;
  end GROUPING;

  -- We never expect this function to be called in PL/SQL - this is enforced
  -- in PH2
  function GROUPING(a "<ADT_1>") return NUMBER is
  begin
    raise PROGRAM_ERROR;
  end GROUPING;

-- IS [NOT] NULL / NVL for datetime 

  function 'IS NOT NULL'(b TIME_UNCONSTRAINED) return BOOLEAN is
  begin
    return (NOT (b IS NULL));
  end 'IS NOT NULL';
  function NVL (b1 TIME_UNCONSTRAINED, b2 TIME_UNCONSTRAINED) 
  return TIME_UNCONSTRAINED is
  begin
    if (b1 IS NULL) then return(b2); else return(b1); end if;
  end NVL;

  function 'IS NOT NULL' (b TIME_TZ_UNCONSTRAINED) return BOOLEAN is
  begin
    return (NOT (b IS NULL));
  end 'IS NOT NULL';
  function NVL (b1 TIME_TZ_UNCONSTRAINED, b2 TIME_TZ_UNCONSTRAINED) 
    return TIME_TZ_UNCONSTRAINED is
  begin
    if (b1 IS NULL) then return(b2); else return(b1); end if;
  end NVL;

  function 'IS NOT NULL' (b TIMESTAMP_UNCONSTRAINED) return BOOLEAN is
  begin
    return (NOT (b IS NULL));
  end 'IS NOT NULL';
  function NVL (b1 TIMESTAMP_UNCONSTRAINED, b2 TIMESTAMP_UNCONSTRAINED)
    return TIMESTAMP_UNCONSTRAINED  is
  begin
    if (b1 IS NULL) then return(b2); else return(b1); end if;
  end NVL;

  function 'IS NOT NULL' (b TIMESTAMP_TZ_UNCONSTRAINED) return BOOLEAN is
  begin
    return (NOT (b IS NULL));
  end 'IS NOT NULL';
  function NVL (b1 TIMESTAMP_TZ_UNCONSTRAINED,
                b2 TIMESTAMP_TZ_UNCONSTRAINED) 
    return TIMESTAMP_TZ_UNCONSTRAINED  is
  begin
    if (b1 IS NULL) then return(b2); else return(b1); end if;
  end NVL;

 
  function 'IS NOT NULL' (b TIMESTAMP_LTZ_UNCONSTRAINED) 
    return BOOLEAN is 
  begin
    return (NOT (b IS NULL));
  end 'IS NOT NULL';
  function NVL (b1 TIMESTAMP_LTZ_UNCONSTRAINED, 
                b2 TIMESTAMP_LTZ_UNCONSTRAINED) 
    return TIMESTAMP_LTZ_UNCONSTRAINED  is
  begin
    if (b1 IS NULL) then return(b2); else return(b1); end if;
  end NVL;
 
  function 'IS NOT NULL' (b YMINTERVAL_UNCONSTRAINED) return BOOLEAN is
  begin
    return (NOT (b IS NULL));
  end 'IS NOT NULL';
  function NVL (b1 YMINTERVAL_UNCONSTRAINED, b2 YMINTERVAL_UNCONSTRAINED) 
    return YMINTERVAL_UNCONSTRAINED    is
  begin
    if (b1 IS NULL) then return(b2); else return(b1); end if;
  end NVL;

  function 'IS NOT NULL' (b DSINTERVAL_UNCONSTRAINED) return BOOLEAN is
  begin
    return (NOT (b IS NULL));
  end 'IS NOT NULL';
  function NVL (b1 DSINTERVAL_UNCONSTRAINED, b2 DSINTERVAL_UNCONSTRAINED) 
    return DSINTERVAL_UNCONSTRAINED is
  begin
    if (b1 IS NULL) then return(b2); else return(b1); end if;
  end NVL;


-- END OF PACKAGE standard  
end;



/
grant execute on STANDARD to public;
/
