/* $Header: aqjmsdemo02.java 16-mar-00.13:05:10 rbhyrava Exp $ */

/* Copyright (c) Oracle Corporation 2000. All Rights Reserved. */

/*
   DESCRIPTION
    <short description of component this file declares/defines>

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    rbhyrava    03/16/00 - AQ jms demos
    rbhyrava    03/15/00 - AQ JMS demo - Message Listener Demo - Enqueue Messag
    rbhyrava    03/15/00 - Creation
 */

/**
 *  @version $Header: aqjmsdemo02.java 16-mar-00.13:05:10 rbhyrava Exp $
 *  @author  rbhyrava
 *  @since   release specific (what release of product did this appear in)
 */



/***
 * This is a sample java file which uses Oracle JMS - Java Messaging Service 
 * API to Publish messages into topic. aqjmsdemo04 will demonstrate the 
 * Subscribers receiving the messages asynchronously using Message Listener
 * aqjmsdemo02 - enqueues the messages to the queue 
 * aqjmsdemo03 - setup Message Listener and dequeue the messages 

 * This demo does the following:
 * -- Create a Queue 
 * -- Send several MAP messages 
 *
 * The following instructions describe how to compile and execute 
 * this sample on the client machine. 
 *
 * System requirements:
 * ====================
 *  1) Oracle 8.1.6 database or higher 
 *  2) The client machine should have JDK 1.1.x or JDK1.2 or higher installed
 *  3) The following jar/zip files should be in the CLASSPATH on the client 
 *     machine. 
 *     For JDK1.2.x 
 *        classes12.zip 
 *        aqapi.jar
 *        jmscommon.jar
 *     For JDK1.1.x 
 *        classes111.zip 
 *        aqapi11.jar
 *        jmscommon.jar
 *  Set up CLASSPATH, PATH, LD_LIBRARY_PATH based on JDK version and platform.
 * Compilation and Running:
 *  ========================
 *  4) If you already have the jars in step 3) in classpath 
 *      javac aqjmsdemo02.java 
 *
 *  5) java aqjmsdemo02  <SID> <HOST> <PORT> <DRIVER> 
 *     Example usage: 
 *       java aqjmsdemo02 orcl82 dlsun666 1521 thin 
 *
 ***/
/* import useful packages */
import oracle.AQ.*;
import oracle.jms.*;
import javax.jms.*;
import java.lang.*;

public class aqjmsdemo02
{
  public static void main (String args [])
       throws java.sql.SQLException, ClassNotFoundException, JMSException
  {
     QueueSession  qsess = null;
      try
      {
        if (args.length < 4 )
         System.out.println("Usage:java filename [SID] [HOST] [PORT] [DRIVER]");
        else {
          qsess = createSession(args);
          setupQueue(qsess) ;
          enqueueMessages(qsess);
          System.out.println("End of Demo") ;
        }
      }
      catch (Exception ex)
      {
         System.out.println("Exception-1: " + ex);
         ex.printStackTrace();
      }
  }

   public static QueueSession createSession(String args[]) throws Exception
   {
      QueueSession  qsess = null;
      QueueConnectionFactory qcfact;
      QueueConnection qconn;
      try 
      {
        //args passed are sid,host,port,driver 
         
         qcfact = AQjmsFactory.getQueueConnectionFactory(
                      args[1], args[0], Integer.parseInt(args[2]), args[3]);

         qconn = qcfact.createQueueConnection( "jmsuser","jmsuser");

         /* Create a Queue Session */
         qsess = 
             qconn.createQueueSession(true, Session.CLIENT_ACKNOWLEDGE);

         qconn.start() ;
         System.out.println("Successfully created QueueSession");  
      }
      catch (Exception ex)
      {
         System.out.println("Exception: " + ex); 
         ex.printStackTrace();      
      }  
      return qsess;
   }

   public static void setupQueue(QueueSession qsess) throws Exception
   {
      AQQueueTableProperty qtprop ;
      AQQueueTable qtable;
      AQjmsDestinationProperty dprop;
      Queue q1;
      try {

         /* Create Queue Tables */
         System.out.println("Creating Queue Table...") ;
    
          qtprop = new AQQueueTableProperty ("SYS.AQ$_JMS_MAP_MESSAGE") ;
          qtprop.setCompatible("8.1") ;
          qtprop.setPayloadType("SYS.AQ$_JMS_MAP_MESSAGE") ;
    
           /* Drop if the queue table already exists */
           try { 
             qtable=((AQjmsSession)qsess).getQueueTable("JMSUSER", "JMSQTABLE");
             qtable.drop(true);
           } catch (Exception e) {} 
    
           qtable = ((AQjmsSession)qsess).createQueueTable("JMSUSER", 
             "jmsqtable", qtprop) ;
              
          System.out.println ("Creating Queue...");
          dprop = new AQjmsDestinationProperty() ;
          q1=((AQjmsSession)qsess).createQueue(qtable,"JMSMAPQ",dprop) ;
    
          /* Start the Queue */
          ((AQjmsDestination)q1).start(qsess, true, true);

         System.out.println("Successfully setup Queue");  
      } catch (Exception ex) {
         System.out.println("Error in setupTopic: " + ex);
         throw ex;
      }
   }

  public static void enqueueMessages(QueueSession qsess) throws Exception
  {
    Queue q1 ;
    MapMessage[] Messages;
    byte[] barray ;
    QueueSender qsender;

    TopicSubscriber tsub1,tsub2;
    TopicPublisher publisher;
    StringBuffer txtbuf ;
    TextMessage txtmsg, dtxtmsg;
    try
    {
      /* Get Queue */
      q1 = ((AQjmsSession)qsess).getQueue("JMSUSER", "JMSMAPQ") ;

      System.out.println("Send messages...") ;

      barray  = new byte[25] ;
      for ( int i=0 ; i< 25 ; i++) barray[i] = 67 ;
      
      Messages = new MapMessage[5] ;

      Messages[0] = qsess.createMapMessage() ;
      Messages[0].setIntProperty ("carno", 3355) ;
      Messages[0].setStringProperty ("color", "BLUE") ;
      Messages[0].setStringProperty ("make", "BMW") ;
      Messages[0].setDoubleProperty ("price", 20000) ;
      Messages[0].setIntProperty ("year", 1999) ;

      Messages[1] = qsess.createMapMessage() ;
      Messages[1].setIntProperty ("carno", 4444) ;
      Messages[1].setStringProperty ("color", "BLACK") ;
      Messages[1].setStringProperty ("make", "ACURA") ;
      Messages[1].setDoubleProperty ("price", 22995) ;
      Messages[1].setIntProperty ("year", 1998) ;

      Messages[2] = qsess.createMapMessage() ;
      Messages[2].setIntProperty ("carno", 1212) ;
      Messages[2].setStringProperty ("color", "BLUE") ;
      Messages[2].setStringProperty ("make", "MERCEDES") ;
      Messages[2].setDoubleProperty ("price", 30995) ;
      Messages[2].setIntProperty ("year", 2001) ;

      Messages[3] = qsess.createMapMessage() ;
      Messages[3].setIntProperty ("carno", 5345) ;
      Messages[3].setStringProperty ("color", "GREEN") ;
      Messages[3].setStringProperty ("make", "LEXUS") ;
      Messages[3].setDoubleProperty ("price", 21895) ;
      Messages[3].setIntProperty ("year", 1995) ;

      Messages[4] = qsess.createMapMessage() ;
      Messages[4].setIntProperty ("carno", 8909) ;
      Messages[4].setStringProperty ("color", "BLUE") ;
      Messages[4].setStringProperty ("make", "BMW") ;
      Messages[4].setDoubleProperty ("price", 40995) ;
      Messages[4].setIntProperty ("year", 2002) ;

      /* Create Queue Sender */ 
      qsender = qsess.createSender(q1) ;

      for ( int i = 0 ; i < 5 ; i++ ) 
      {
        Messages[i].setBytes("Picture" , barray) ;
        Messages[i].setJMSCorrelationID(Messages[i].getStringProperty("color"));
        System.out.println("Sending "+Messages[i].getStringProperty ("color") + 
                           " " + Messages[i].getStringProperty("make") + 
                           " " + Messages[i].getIntProperty("year") + 
                           " " + Messages[i].getDoubleProperty("price")) ; 

        qsender.send(q1, Messages[i], DeliveryMode.PERSISTENT, 
            1+ (i%10) , AQjmsConstants.EXPIRATION_NEVER ) ;
        try { 
           Thread.sleep(5000) ;
        } catch (InterruptedException e) {}  ;
        qsess.commit() ;
      }
      System.out.println("Successfully Sent Messages.");  

    } catch (JMSException e) {
      System.out.println("Error in Sending Messages : " + e) ;
      throw e;
    }
 } 
}
