-- Inital load of CUSTOMERS table and ORDERS table. Load one customer record
-- and one order record for the customer
--
-- This example shows how to load a REF field and a VARRAY.  The ORDER table
-- has a primary key reference to the customer table and it stores the order
-- items in a VARRAY.
--

LOAD DATA
INFILE * 
CONTINUEIF THIS (1) = '*'

INTO TABLE customers
replace
fields terminated by ","
(
  cust_no                       char,
  name                          char,
  addr                          char
)

INTO TABLE orders
replace
fields terminated by ","
(
  order_no                      char,
  cust_no             FILLER    char,
  cust                          REF (CONSTANT 'CUSTOMERS', cust_no),
  item_list_count     FILLER    char,
  item_list                     varray count (item_list_count)
  (
    item_list                   column object
    (
      item                      char,
      cnt                       char,
      price                     char
    )
  )  
)

BEGINDATA
*00001,Spacely Sprockets,15 Space Way,
*00101,00001,2,
*Sprocket clips, 10000, .01,
 Sprocket cleaner, 10, 14.00
*00002,Cogswell Cogs,12 Cogswell Lane,
*00100,00002,4,
*one quarter inch cogs,1000,.02,
*one half inch cog, 150, .04,
*one inch cog, 75, .10,
 Custom coffee mugs, 10, 2.50
