-- This is an example of using SQL Loader to load LOBs from secondaray data
-- file.  In this example, we are loading the RESUME filed in the EMP table.
-- We have one file per resume (the "TERMINATED BY EOF" clause indicates 
-- this) and the name of the file containing the resume is in field RES_FILE.
--
-- Note that since RES_FILE is a FILLER field, the file name stored in the
-- field is not loaded into any field in the table.
-- Also note that the field name for column RESUME is quoted since RESUME is
-- also a keyword for SQL Loader.  The quotes force SQL Loader to treat it
-- as a column name instead.

LOAD DATA
INFILE *
INTO TABLE EMP 
REPLACE
FIELDS TERMINATED BY ','
( EMPNO    INTEGER EXTERNAL,
  ENAME    CHAR,
  JOB      CHAR,
  MGR      INTEGER EXTERNAL,
  SAL      DECIMAL EXTERNAL,
  COMM     DECIMAL EXTERNAL,
  DEPTNO   INTEGER EXTERNAL,
  RES_FILE FILLER CHAR,
  "RESUME" LOBFILE (RES_FILE) TERMINATED BY EOF NULLIF RES_FILE = 'NONE'
)

BEGINDATA
7782,CLARK,MANAGER,7839,2572.50,,10,ulcase91.dat
7839,KING,PRESIDENT,,5500.00,,10,ulcase92.dat
7934,MILLER,CLERK,7782,920.00,,10,ulcase93.dat
7566,JONES,MANAGER,7839,3123.75,,20,ulcase94.dat
7499,ALLEN,SALESMAN,7698,1600.00,300.00,30,ulcase95.dat
7654,MARTIN,SALESMAN,7698,1312.50,1400.00,30,ulcase96.dat
7658,CHAN,ANALYST,7566,3450.00,,20,NONE
