Rem
Rem Prepare ONLDAP schema for bulk data loading
Rem

rem Now drop the indexes on DN, CN and AttrStore
rem
drop index EI_attrStore;
rem
rem Indexes on DN
rem
drop index EP_dn;
drop index RP_dn;
drop index PN_dn;
rem

CREATE OR REPLACE
PROCEDURE dropCatalogIndexes(attrName IN varchar2)
AS
    attrNameLower   VARCHAR2(32);
    sqlCommand      VARCHAR2(2048);
    sqlCursor       INTEGER;
    rows_processed  INTEGER;
BEGIN
    sqlCursor := dbms_sql.open_cursor;	

    attrNameLower := lower(attrName);

    sqlCommand := 'DROP INDEX EV_' || attrNameLower;
    dbms_sql.parse(sqlCursor, sqlCommand, dbms_sql.v7);
    rows_processed := dbms_sql.execute(sqlCursor);

    sqlCommand := 'DROP INDEX VA_' || attrNameLower;
    dbms_sql.parse(sqlCursor, sqlCommand, dbms_sql.v7);
    rows_processed := dbms_sql.execute(sqlCursor);
END;
/
