#!/bin/sh

usage() {
cat <<USAGE_MESSAGE
usage: ${0} [ -connect <Database connect string> ]
            [ -login < Database Account Login > ]
            [ -pass < Database Account Password > ]
            [ -all ]
            [ -cat <catalogue name> ]
            [ -pct <percent> ]
            [ -help | -usage ]

 connect: DB Connect string
 login: DB Account Login
 pass: DB Account Password.
 all : Estimate Statistics on All Catalogue tables plus DN catalogue.
 cat : Either All Catalogues (all) or a particular  one (e.g ct_cn)..
 pct : Percent of Data To sample .

Defaults:
 connect : ORACLE_SID
 login : ods
 pass  : ods
 all   : All catalogues
 pct   : 100
 
Example 1. To do 100 % statistics on all Tables use..
      ${0} -all -pct 100

Example 2. To do 50 % statistics on all Tables use..
      ${0} -all -pct 50

Example 3. To do 50 % statistics on CT_CN Table use..
      ${0} -cat ct_cn -pct 50

Example 4. To do 40 % statistics on all catlaogs use..
      ${0} -cat all -pct 40

USAGE_MESSAGE
}

CONNECT=""
LOGIN=ods
PASS=ods
OPTION=all
CAT="dummy"
PERCNT="100"

TMPDIR=${ORACLE_HOME}/ldap/log
NULLFILE=/tmp/null
LOGFILE=${TMPDIR}/oidstats.log

# parse arguments
while [ $# -gt 0 ] ; do
  case $1 in

    -connect) CONNECT=$2;
       if [ -z "${CONNECT}" ] ; then
         CONNECT="";
       else
         shift;
       fi;;

    -login) LOGIN=$2;
       if [ -z "${LOGIN}" ] ; then
         LOGIN="";             
       else
         shift;
       fi;;

    -pass) PASS=$2;
       if [ -z "${PASS}" ] ; then
         PASS="";             
       else
         shift;
       fi;;

    -all) 
         OPTION=all;;

    -cat) CAT=$2;
       if [ -z "${CAT}" ] ; then
         CAT="";
       else
         if [ "${CAT}" = "all" ]
         then
           OPTION="allcat";
           shift;
         else
           OPTION="CAT";
           shift;
         fi
       fi;;

    -pct) PERCNT=$2;
       if [ -z "${PERCNT}" ] ; then
         PERCNT="100";
       else
         shift;
       fi;;

    # help, usage, and ignore anything else
    -help ) usage ; exit 1 ;;
    # help, usage, and ignore anything else
    *) echo "$1 Not Found " ; usage ; exit 1 ;;

  esac
  shift
done              

  > ${LOGFILE}

  if [ "${LOGIN}" = "" -o "${PASS}" = "" -o "${OPTION}" = "" -o "${CAT}" = "" ]
  then
    usage;
    exit 1;
  fi

  if [ "${CONNECT}" = "" ]
  then
    if [ "${ORACLE_SID}" = "" ]
    then
      echo "ORACLE_SID not set.." ;
      usage;
      exit 1;
    fi
    CMDNAME="sqlplus ${LOGIN}/${PASS}"
  else
    CMDNAME="sqlplus ${LOGIN}/${PASS}@${CONNECT}"
  fi

  rm -f ${TMPDIR}/cat* 2> ${NULLFILE}

${CMDNAME} >> ${LOGFILE} 2>&1 <<EOF_SQLPLUS
  set serveroutput on;
  set pages;
  spool ${TMPDIR}/catalogue.lst;
  select object_name from user_objects where object_name like 'CT_%';
  spool off;
  exit;
EOF_SQLPLUS

  if [ ! -f ${TMPDIR}/catalogue.lst ]
  then 
    echo "Error occurred fetching information from Database...";
    exit 1;
  fi

  if  [ "${OPTION}" = "all" ]
  then
   echo "analyze table DS_ATTRSTORE estimate statistics sample ${PERCNT} percent;" >> ${TMPDIR}/catalogue.sql
   echo "analyze table DS_ATTRSTORE compute statistics ;" >> ${TMPDIR}/catalogue.sql
   echo "analyze table CT_DN estimate statistics sample ${PERCNT} percent;" >> ${TMPDIR}/catalogue.sql
   echo "analyze table CT_DN compute statistics ;" >> ${TMPDIR}/catalogue.sql
  fi

  if  [ "${OPTION}" = "all" -o "${OPTION}" = "CAT" ]
  then
    grep -i "${CAT}" ${TMPDIR}/catalogue.lst > ${TMPDIR}/final_catalogue.lst
  fi 

  if  [ "${OPTION}" = "all" -o "${OPTION}" = "allcat" ]
  then 
    grep "CT_" ${TMPDIR}/catalogue.lst | grep -v "CT_%"  > ${TMPDIR}/final_catalogue.lst
  fi

  cat ${TMPDIR}/final_catalogue.lst | while read  buffer
  do 
   echo "analyze table ${buffer} estimate statistics sample ${PERCNT} percent;" >> ${TMPDIR}/catalogue.sql
   echo "analyze table ${buffer} compute statistics ;" >> ${TMPDIR}/catalogue.sql
  done

  echo "Analyzing Following Tables percent ${PERCNT} ...."

  if  [ "${OPTION}" = "all" ]
  then
    echo "DS_ATTSTORE"
    echo "CT_DN"
  fi

  cat ${TMPDIR}/final_catalogue.lst 

  echo "...."

  rm -f ${TMPDIR}/catalogue.lst

  ${CMDNAME} >> ${LOGFILE} 2>&1 < ${TMPDIR}/catalogue.sql

  echo "Done..."

  rm -f ${TMPDIR}/*catalogue*
