#!/bin/sh
#
# usage: LoadOrclSchema.sh <host> <port> <admin_dn> <admin_password> [verbose]
#

if [ $# -eq 0 ]
then
  echo "usage: LoadOrclSchema.sh <host> <port> <admin_dn> <admin_password>"
  exit 1
fi

if [ $# -eq 5 ]
then
verbose="-v"
else
verbose=" "
fi

ldapmodify -c -a $verbose -h $1 -p $2 -D "$3"  -w $4 -f oidbase.ldif
ldapmodify -c -a $verbose -h $1 -p $2 -D "$3"  -w $4 -f oidrdbms.ldif
ldapmodify -c -a $verbose -h $1 -p $2 -D "$3"  -w $4 -f oidnet.ldif

exit 0
