##
## bulkdelete.sh
## Delete a subtree for the root node provided
## 

## Initialize all the variabale

LDAP_DIR=${ORACLE_HOME}/ldap
LDAP_ADMIN=${LDAP_DIR}/admin
LDAP_BIN=${LDAP_DIR}/bin
LDAP_LOG=${LDAP_DIR}/log
LDAP_LOAD=${LDAP_DIR}/load
TMPDIR=${LDAP_LOAD}
NORMDN=null
ERRORS=0
SIZE=1000
ENCODING=".UTF8"
PSWD="A"
#bo=`tput smso`
#no=`tput rmso`

usage() {
  cat << BULKDEL
usage : bulkdelete.sh -connect <connect descriptor> -base <DN> [ -size <commit size> ]
       
      -connect        specifies the Net8 connect descriptor used to connect to
                      the database.
      -base           specifies DN of the ROOT whose subtree is to be deleted.
                      DN should always be enclose in doublequotes i.e " ".
      -size           specifies the number of entries to be committed as a part                       of one transaction.
      -encode         specifies the native character set (e.g ".ZHS16GBK" )
     
BULKDEL

exit
} 

##--------------CREATETBLFILE function------------
createtblfile() {
      echo " set feedback off
             spool ${LDAP_LOG}/temptbl.lst
             CREATE TABLE tempEID (
                    ENTRYID     NUMBER NOT NULL)
             TABLESPACE OLTS_CT_STORE
             STORAGE ( FREELISTS 6);
             CREATE INDEX va_tempEID on tempEID (entryid );
             COMMIT;
             spool off
             exit" > ${TMPDIR}/temptbl.sql

}
##--------------CREATEdrptblfile function------------
createdrptblfile() {
      echo " set feedback off
             spool ${LDAP_LOG}/drptbl.lst
             DROP TABLE tempEID ;
             COMMIT;
             spool off
             exit" > ${TMPDIR}/drptbl.sql

}
droptable() {
${ORACLE_HOME}/bin/sqlplus -s ${LDAP_CONNECT} @${TMPDIR}/drptbl.sql > ${TMPDIR}/null 2>&1
  if [ -s ${LDAP_LOG}/droptbl.lst ] ; then
      echo --------
      echo Cannot drop temporary table. 
      echo Fix the problem and drop temptable.
      echo -------
      cat ${LDAP_LOG}/droptbl.lst
      echo
  fi

 rm -f ${LDAP_LOG}/droptbl.lst ${TMPDIR}/drptbl.sql > ${TMPDIR}/null
}


##--------------CREATETABLE function------------
createtable() {
${ORACLE_HOME}/bin/sqlplus -s ${LDAP_CONNECT} @${TMPDIR}/temptbl.sql > ${TMPDIR}/null 2>&1
  if [ -s ${LDAP_LOG}/temptbl.lst ] ; then
      echo --------
      echo Last deletion operation perfomed was incomplete
      echo Completing the Subtree delete for the DN specified last time
      echo Deleting .........
      echo -------
      echo
  else
      echo -------
      echo Deleting subtree for .........
      echo ${UNNORMDN}
      echo -------
      echo
  fi

rm -f ${LDAP_LOG}/temptbl.lst ${TMPDIR}/temptbl.sql > ${TMPDIR}/null
}

getNormDn() {
   echo " DN:  ${UNNORMDN} 
objectclass: country" > ${TMPDIR}/temp.ldif
  ${LDAP_BIN}/datagen connect=${MACH} encode=${ENCODING} file=${TMPDIR}/temp.ldif dnfile=${LDAP_LOAD}/dns.dat > ${LDAP_LOG}/bulkdelete.log 2>&1
  if [ $? != 0  ] ; then
     echo Problems encoutered while normalizing  ${UNNORMDN}
     echo See ${LDAP_LOG}/bulkdelete.log.
     exit 1
  fi
  if [ -s ${LDAP_LOAD}/dns.dat ] ; then
  cd ${LDAP_LOAD}
  $ORACLE_HOME/bin/sqlplus ${LDAP_CONNECT} @${LDAP_ADMIN}/ldapbcdt.sql > ${TMPDIR}/null 2>&1
  echo " LOAD DATA
         INFILE dns.dat
         APPEND
         INTO TABLE dn_check
         FIELDS TERMINATED BY X'ff'
         (NORMDN, dn) " > ${TMPDIR}/dns.ctl
  $ORACLE_HOME/bin/sqlldr ${LDAP_CONNECT} control=${TMPDIR}/dns.ctl errors=10000 direct=true > ${TMPDIR}/null 2>&1 ;
  if [ $? != 0  ] ; then
     echo Problems encoutered while connecting to server
     echo 
     exit 1
  fi
  else
     echo Dn specifed is invalid......  ${UNNORMDN}
     echo 
     exit 1
  fi
  rm -f ${LDAP_LOAD}/dns.dat ${TMPDIR}/dns.ctl ${TMPDIR}/temp.ldif > ${TMPDIR}/null
}
cleanup() {
rm  -f ${LDAP_LOG}/temptbl.lst  ${LDAP_LOG}/droptbl.lst  > ${TMPDIR}/null
}
if [ $# -eq 0 ] ; then
  usage
fi
while [ $# -gt 0 ] ; do
      case $1 in
           -connect) LDAP_CONNECT=$2 ;
                     if [ -z "${LDAP_CONNECT}" ] ; then
				usage ;
		     fi
		     shift ;;
          -base) UNNORMDN=$2 ;
                  shift ;;
          -encode) ENCODING=$2;
                  if [ -z "${ENCODING}" ] ; then
                    ENCODING=".UTF8" ;
                  fi;
                  shift;;
          -size) SIZE=$2 ;
                 shift ;;
          -w)    PSWD=$2;
                 shift;;
	   -*)  usage  ;;
      esac
      shift
done


if [ -z $ORACLE_HOME ] 
then
  echo ORACLE_HOME not set
  exit 1
fi

if [ -z "${UNNORMDN}" ] ; then
     usage ;
fi



MACH=${LDAP_CONNECT}
tnsping ${LDAP_CONNECT} > ${TMPDIR}/null 2>&1
if [ $? != 0 ] ; then
  echo
  echo Connect descriptor specified is not valid.. Or not available
  echo
  usage
fi

####THis is the Security Implementation######
if [ ${PSWD} = "A" ] ; then
   echo " "
   echo "${bo}This tool can only be executed if you know database user password for OiD${no}"  
   echo " "
   printf "Enter OiD password ::" 
   stty -echo; read PSWD ; stty echo ; echo
   #clear
fi
echo " set feedback off
   connect ods/${PSWD}@${LDAP_CONNECT} ;
   exit; " > ${TMPDIR}/seccheck.sql
### check if the password provided is correct
${ORACLE_HOME}/bin/sqlplus  odscommon/odscommon@${LDAP_CONNECT} @${TMPDIR}/seccheck.sql  > ${LDAP_LOG}/catchecK.lst
err=`grep -c ERROR ${LDAP_LOG}/catchecK.lst`
rm -f ${LDAP_LOG}/seccheck.lst ${TMPDIR}/seccheck.sql > ${TMPDIR}/null
if [ ${err} != 0 ] ; then
  echo " Password for OiD user is WRONG.."
  echo " Cannot execute this tool ..."
  exit
fi

LDAP_CONNECT=ods/${PSWD}@${LDAP_CONNECT}

cleanup
if [ ${ERRORS} = 1 ] ; then
  exit
fi
getNormDn
createtblfile
createtable
${ORACLE_HOME}/bin/sqlplus -s ${LDAP_CONNECT} @${LDAP_ADMIN}/bulkdelete.sql ${SIZE} > ${LDAP_LOG}/bulkdelete.log 2>&1
if [ -s ${LDAP_LOG}/bulkdelete.log ] ; then
   echo        
   echo
   echo Errors encountered while Deleting the subtree for
   echo ... ${UNNORMDN}
   echo check ${LDAP_LOG}/bulkdelete.log
   echo
   echo Fix the problem and execute the bulkdelete.sh again
   echo 
   cat ${LDAP_LOG}/bulkdelete.log
   echo
else
   echo
   echo  Subtree for ${UNNORMDN} Successfully deleted.
   echo
   createdrptblfile
   droptable
fi

   
