## ldaprepl.sh
## 

## Initialize all the variabale

LDAP_DIR=${ORACLE_HOME}/ldap
LDAP_ADMIN=${LDAP_DIR}/admin
LDAP_BIN=${LDAP_DIR}/bin
LDAP_LOG=${LDAP_DIR}/log
LDAP_LOAD=${LDAP_DIR}/load
TMPDIR=${LDAP_DIR}/load
ASR=0
NODE=0
OPTREAD=0
DELNODE=0
QUIESCE=0             
TMPFILE=${TMPDIR}/asr.info
LOGFILE=${LDAP_ADMIN}/LOGS/ldaprepl.log
noOfNodes=0
bo=``
no=``
##############
## Usage Function
##############
usage() {
  cat << REPLSETUP
usage : ldaprepl.sh [-asrsetup|-addnode] 
       
      -asrsetup   Configure ASR for Directory Replication Group.
      -addnode    Configure ASR for adding a New Node to an existing
                  Replication Group.
      -delnode    Reconfigure ASR to delete a Node from existing
                  Replication Group.
      -quiesce    Quiesce ASR for Directory Replication Group.

      NOTE: Only one of -asrsetup , -addnode ,-delnode , -quiesce, -dbcopynode
            should be specified.    


REPLSETUP

exit
} 
##############
## Accept Input From the User .
## Contains 5 Functions.. inputMain, accInput, 
## Accept Master Def Site info,  Accepts Nodes Info , Accept Add NodeInfo
################
accMasterDefInfo() {
echo "${bo}Please provide Information about Master Definition Site ${no} "
echo "============================================================ "
echo "  "
printf "Enter MDS Host Name :"
read MDS_HOST
printf  "Enter MDS Global Name :"
read MDS_GLOBALNAME  
if [ ${DELNODE} = 0 ] ; then
  printf "Enter System Password for MDS:"
  stty -echo; read MDS_SYSPSSWD ; stty echo ; echo
fi   
}
nodeInfo() {
if [ ${NODE} = 1 ] ; then
echo "${bo}Please provide Information about existing Master Sites in Replication Group${no}"
else
echo "${bo}Please provide Information about all other Master Sites${no}"
fi
echo " =========================================================="
echo "  "
MORENODE=Y
rm -f ${TMPFILE} > ${TMPDIR}/null
while [ ${MORENODE} = "Y" ] ; do
  accNodeInfo
  if [ ${NODE} = 1 ] ; then
    printf "%s Are there more Master Sites in the existing Replication  group(Y/N)::%s  " ${bo} ${no}
  else
    printf "%s Are there more Master Sites in the group(Y/N)::%s  " ${bo} ${no}
  fi
  read MORE
  if [ "y" = $MORE  -o "Y" = $MORE -o "YES" = $MORE -o "yes" = $MORE  ] ; then
    MORENODE=Y
  else
    MORENODE=N
  fi 

done
chmod 400 ${TMPFILE}
}
accNodeInfo() {
printf "Enter Host Name :"
read N_HOST
printf "Enter Global Name :"
read N_GLOBALNAME  
printf "Enter System Password :"
stty -echo; read N_SYSPSSWD ; stty echo ; echo
echo $N_HOST "  " $N_GLOBALNAME " "  $N_SYSPSSWD  >> ${TMPFILE} 
}
accAddNodeInfo() {
echo "  "
echo "${bo}Please provide Information about the node you want to Add${no}"
echo "============================================================== "
echo "  "
printf "Enter node Host Name :"
read NODE_HOST
printf "Enter node Global Name :"
read NODE_GLOBALNAME 
printf "Enter System Password for node:"
stty -echo; read NODE_SYSPSSWD ; stty echo ; echo
}
accDelNodeInfo() {
echo "  "
echo "${bo}Please provide Information about the node you want to Delete${no}"
echo "============================================================== "
echo "  "
printf "Enter node Host Name :"
read DELNODE_HOST
printf "Enter node Global Name :"
read DELNODE_GLOBALNAME
}     
##############
## Verify that the information entered by the user is Correct. 
## for this all the info will be displayed and user will be asked
## to verify it
##############
verifyInfo() {
#clear
echo "${bo}Please verify the information you Provided ${no} "
echo ""
echo "                                    HOST NAME           GLOBAL NAME"
echo "                                    ---------           -----------"
printf "Master Definition Site:  %20s  %20s  \n" $MDS_HOST $MDS_GLOBALNAME
if [ ${DELNODE} = 0 ] ; then                                 
  cnt=1
  count=1
  for info in `cat  ${TMPFILE}` ; do
   if [ ${cnt} -eq 1 ] ; then
      HOST=${info}
   fi
   if [ ${cnt} -eq 2 ] ; then
      GLOBALNAME=${info}
   fi
   if [ ${cnt} -eq 3 ] ; then
      SYSPSSWD=${info}
      cnt=0 
      printf "        Master Site ${count} :  %20s  %20s  \n" $HOST $GLOBALNAME
      count=`expr ${count} + 1`
   fi
   cnt=`expr ${cnt} + 1 `
  done 
fi
if [ ${NODE} = 1 ] ; then
printf "     Node to be added :  %20s  %20s \n" $NODE_HOST $NODE_GLOBALNAME 
fi
if [ ${DELNODE} = 1 ] ; then
printf "   Node to be Deleted :  %20s  %20s \n" $DELNODE_HOST $DELNODE_GLOBALNAME
fi   
}
accInput() {
accMasterDefInfo
if [ ${DELNODE} = 0 ] ; then              
   nodeInfo
fi
if [ ${NODE} = 1 ] ; then
  accAddNodeInfo
fi
}
inputMain() {
verified=F
while [ ${verified} = "F" ] ; do
  accInput
  verifyInfo
  printf "%s Above Information is Correct (Y/N)::%s  " ${bo} ${no}
  read resp
  if [ "Y" = ${resp} -o "y" = ${resp} -o "YES" = ${resp} -o "yes" = ${resp} ] ; then
   verified=T
  fi

done
}
##############
##  Some messages put in function which will be displayed 
## After user has enterd all the required input.
##############
startProcess() {
#clear
echo "${bo}           Replication Setup in Progress                ${no}"
echo "${bo}========================================================${no}"
echo ""

}
##############
## Configure all Master Sites.
##############
configMasterSites() {
cnt=1
for info in `cat  ${TMPFILE}` ; do
 if [ ${cnt} -eq 1 ] ; then
    HOST=${info}
 fi
 if [ ${cnt} -eq 2 ] ; then
    GLOBALNAME=${info}
 fi
 if [ ${cnt} -eq 3 ] ; then
    SYSPSSWD=${info}
    echo "Setup Of Remote Master ... ${GLOBALNAME}... under progress"
    echo "Setup Of Remote Master ... ${GLOBALNAME}... under progress" >> ${LOGFILE}
    ${ORACLE_HOME}/bin/sqlplus -s system/${SYSPSSWD}@${GLOBALNAME} @${LDAP_ADMIN}/ldapsetrm.sql   ${SYSPSSWD} ${GLOBALNAME}  ${MDS_GLOBALNAME} ${MDS_SYSPSSWD}  >> ${LOGFILE}
    echo "Setup Of Remote Master ... ${GLOBALNAME}... Completed "
    echo "Setup Of Remote Master ... ${GLOBALNAME}... Completed " >> ${LOGFILE}
    cnt=0 
 fi
 cnt=`expr ${cnt} + 1 `
done 

}
##############
## Configure Master Definition Site
##############
configMasterDefSite() {

echo "Configuring Master Definition Site ......."
echo "Configuring Master Definition Site ......." > ${LOGFILE}
${ORACLE_HOME}/bin/sqlplus -s system/${MDS_SYSPSSWD}@${MDS_GLOBALNAME} @${LDAP_ADMIN}/ldapsetms.sql  ${MDS_SYSPSSWD}  ${MDS_GLOBALNAME}  >> ${LOGFILE}
echo "Master Definition Site configuration complete ......."
echo "Master Definition Site configuration complete ......." >> ${LOGFILE}

}
##############
## Configure Replication Push Jobs at all sites including MDS 
##############
mdsPushJobs() {

  echo "Creating Jobs at Master Definition Site .........."
  echo "Creating Jobs at Master Definition Site .........." >> ${LOGFILE}
  ${ORACLE_HOME}/bin/sqlplus -s repadmin/repadmin@${MDS_GLOBALNAME} @${LDAP_ADMIN}/ldapjobs.sql  ${MDS_GLOBALNAME} >> ${LOGFILE}
  echo " Jobs Created."
  echo " Jobs Created Were." >> ${LOGFILE}
  cat ${LDAP_ADMIN}/LOGS/drjobs.sql >> ${LOGFILE}
  cat ${LDAP_ADMIN}/LOGS/crjobs.sql >> ${LOGFILE}

}
addNodePushJobs() {

  echo "Creating Jobs at Node .. ${NODE_GLOBALNAME}........"
  echo "Creating Jobs at Node .. ${NODE_GLOBALNAME}........" >> ${LOGFILE}
  ${ORACLE_HOME}/bin/sqlplus -s repadmin/repadmin@${NODE_GLOBALNAME} @${LDAP_ADMIN}/ldapjobs.sql  ${NODE_GLOBALNAME} >> ${LOGFILE}
  echo " Jobs Created."
  echo " Jobs Created Were." >> ${LOGFILE}
  cat ${LDAP_ADMIN}/LOGS/drjobs.sql >> ${LOGFILE}
  cat ${LDAP_ADMIN}/LOGS/crjobs.sql >> ${LOGFILE}

}
configReplPushJobs() {
cnt=1
for info in `cat ${TMPFILE}` ; do
   if [ ${cnt} -eq 2 ] ; then
      GLOBALNAME=${info}
   fi
   if [ ${cnt} -eq 3 ] ; then
      SYSPSSWD=${info}
      echo "Creating Jobs at Node .. ${GLOBALNAME}........"
      echo "Creating Jobs at Node .. ${GLOBALNAME}........" >> ${LOGFILE}
      ${ORACLE_HOME}/bin/sqlplus -s repadmin/repadmin@${GLOBALNAME} @${LDAP_ADMIN}/ldapjobs.sql  ${GLOBALNAME} >> ${LOGFILE}
      echo " Jobs Created."
      echo " Jobs Created Were." >> ${LOGFILE}
      cat ${LDAP_ADMIN}/LOGS/drjobs.sql >> ${LOGFILE}
      cat ${LDAP_ADMIN}/LOGS/crjobs.sql >> ${LOGFILE}
      cnt=0
   fi
   cnt=`expr ${cnt} + 1 `
done 
}
##############
## Resume Replication at Master Def Site
##############
resumeReplAtMDS() {
echo "Resuming Replication at Master Def Site............"
echo "Resuming Replication at Master Def Site............" >> ${LOGFILE}
${ORACLE_HOME}/bin/sqlplus -s repadmin/repadmin@${MDS_GLOBALNAME} @${LDAP_ADMIN}/ldapresume.sql  ${MDS_GLOBALNAME} >> ${LOGFILE}
}
##############
##  Quiesce ASR environment.
##############
quiesceASR() {
echo "Quiesce ASR environment before adding node ....."
echo "Quiesce ASR environment before adding node ....." >> ${LOGFILE}
err=0
${ORACLE_HOME}/bin/sqlplus -s repadmin/repadmin@${MDS_GLOBALNAME} @${LDAP_ADMIN}/ldapsuspend.sql ${MDS_GLOBALNAME}  > ${LOGFILE}
    err=`grep -c 'Suspend did not complete even after' ${LOGFILE}`
    if [ ${err} != 0 ] ; then
       echo " Error while Quiescing . Check ${LOGFILE} "
       exit
    fi          
echo "Quiesce Complete"
echo "Quiesce Complete" >> ${LOGFILE}
}
##############
##  Add New Node 
##############
addNewNode() {
echo "Configuring the new Node ...${NODE_GLOBALNAME}........."
echo "Configuring the new Node ...${NODE_GLOBALNAME}........." >> ${LOGFILE}
${ORACLE_HOME}/bin/sqlplus -s system/${NODE_SYSPSSWD}@${NODE_GLOBALNAME} @${LDAP_ADMIN}/ldapsetrm.sql   ${NODE_SYSPSSWD} ${NODE_GLOBALNAME}   ${MDS_GLOBALNAME} ${MDS_SYSPSSWD}   >> ${LOGFILE}
echo "New node Configured"
echo "New node Configured" >> ${LOGFILE}
}
##############
##  Perfor Post Add Node operations
##############
postAddNode() {
echo "Performing Post add Node operation..........."
echo "Performing Post add Node operation..........." >> ${LOGFILE}
${ORACLE_HOME}/bin/sqlplus -s ods/ods@${NODE_GLOBALNAME} @${LDAP_ADMIN}/ldappostadd.sql  ${NODE_GLOBALNAME} ${MDS_GLOBALNAME}  ${NODE_HOST}  ${MDS_HOST} >> ${LOGFILE}
}
##############
##  Create file for Defer Admin jobs execution  
##############
createdeferadmfile() {
if [ ${DELNODE} -eq 1 ] ; then
echo "
BEGIN
   DBMS_REPCAT.DO_DEFERRED_REPCAT_ADMIN('ldap_rep',TRUE);
END;
/
exit; " > ${LDAP_ADMIN}/ldapdeferadm.sql
else 
echo "
BEGIN
   DBMS_REPCAT.DO_DEFERRED_REPCAT_ADMIN('ldap_rep',FALSE);
END;
/
exit; " > ${LDAP_ADMIN}/ldapdeferadm.sql
fi
}
##############
##  Defer Admin jobs on all nodes before and after resumin replication. 
##############
deferadminjobs() {
for info in `cat ${TMPFILE}` ; do
   if [ ${cnt} -eq 2 ] ; then
      GLOBALNAME=${info}
   fi
   if [ ${cnt} -eq 3 ] ; then
      ${ORACLE_HOME}/bin/sqlplus -s repadmin/repadmin@${GLOBALNAME} @${LDAP_ADMIN}/ldapdeferadm.sql  >> ${LOGFILE}
      cnt=0
   fi
   cnt=`expr ${cnt} + 1 `
done 
${ORACLE_HOME}/bin/sqlplus -s repadmin/repadmin@${MDS_GLOBALNAME} @${LDAP_ADMIN}/ldapdeferadm.sql >> ${LOGFILE}
if [ ${NODE} = 1 ] ; then
${ORACLE_HOME}/bin/sqlplus -s repadmin/repadmin@${NODE_GLOBALNAME} @${LDAP_ADMIN}/ldapdeferadm.sql >> ${LOGFILE}
fi

}

cleanup() {
rm  -f   ${TMPFILE} ${LDAP_LOG}/check.lst  > ${TMPDIR}/null
}
### Create File to remove master site from replication.
createremmstrfile() {
echo "
Rem
Rem  Removes master database from replication
Rem

BEGIN
   DBMS_REPCAT.REMOVE_MASTER_DATABASES(gname=>'LDAP_REP',
                                       master_list =>
                                '${DELNODE_GLOBALNAME}');
END;
/
exit; " > ${LDAP_ADMIN}/delnode.sql
}             
##############
##  Perform  check whether Setup is complete or not
##############
checkForCompletion() {
COMPLETE="N"
cntr=1
echo " Checking for completion of Jobs on all nodes........."
while [ ${COMPLETE} = "N" ] ; do
   COMPLETE="Y"
   ${ORACLE_HOME}/bin/sqlplus -s system/${MDS_SYSPSSWD}@${MDS_GLOBALNAME} @${LDAP_ADMIN}/ldaplogq.sql > ${LDAP_LOG}/check.lst
   if [ -s ${LDAP_LOG}/check.lst ] ; then
       if [ ${cntr} -eq 15 ] ; then
          echo "."
          echo "Jobs not yet  Completed on ..${MDS_GLOBALNAME}..Will take some more time "
       fi
       COMPLETE="N"
       printf "."
   fi

   cnt=1
   for info in `cat ${TMPFILE}` ; do
      if [ ${cnt} -eq 2 ] ; then
         GLOBALNAME=${info}
      fi
      if [ ${cnt} -eq 3 ] ; then
         SYSPSSWD=${info}
         ${ORACLE_HOME}/bin/sqlplus -s system/${SYSPSSWD}@${GLOBALNAME} @${LDAP_ADMIN}/ldaplogq.sql > ${LDAP_LOG}/check.lst
         if [ -s ${LDAP_LOG}/check.lst ] ; then
           if [ ${cntr} -eq 15 ] ; then
           echo "."
           echo "Jobs not yet Completed on ..${GLOBALNAME}..Will take some more time "
           fi
           COMPLETE="N"
           printf "."
         fi
         cnt=0
      fi
      cnt=`expr ${cnt} + 1 `
   done 
   if [ ${NODE} -eq 1 ] ; then
      ${ORACLE_HOME}/bin/sqlplus -s system/${NODE_SYSPSSWD}@${NODE_GLOBALNAME} @${LDAP_ADMIN}/ldaplogq.sql > ${LDAP_LOG}/check.lst
      if [ -s ${LDAP_LOG}/check.lst ] ; then
          if [ ${cntr} -eq 15 ] ; then
             echo "."
             echo "Jobs not yet Completed on ..${NODE_GLOBALNAME}.. Will take some more time"
          fi
          COMPLETE="N"
          printf "."
      fi
   fi
   if [ ${cntr} = 30 ] ; then
      echo "---REPLICATION SETUP FAILED ----"
      echo " For possible reasons and TroubleShooting refer OiD administrator"
      echo " Manual. "
      cleanup
      exit
    fi
   sleep 20
   cntr=`expr ${cntr} + 1`
done 
}
####Check for DEl NODE COMPLETION
###
checkForDelNodeCompletion() {
COMPLETE="N"
cntr=1
echo " Checking for completion of Jobs on all nodes........."
while [ ${COMPLETE} = "N" ] ; do
   COMPLETE="Y"
   ${ORACLE_HOME}/bin/sqlplus -s repadmin/repadmin@${MDS_GLOBALNAME} @${LDAP_ADMIN}/ldaplogq.sql > ${LDAP_LOG}/check.lst
  if [ -s ${LDAP_LOG}/check.lst ] ; then 
       COMPLETE="N"
       printf "."
   ##Since it's not complete run defadminjobs again
       ${ORACLE_HOME}/bin/sqlplus -s repadmin/repadmin@${MDS_GLOBALNAME} @${LDAP_ADMIN}/ldapdeferadm.sql  >> ${LOGFILE} 
    if [ ${cntr} = 30 ] ; then
      echo "---REPLICATION SETUP FAILED ----"
      echo " For possible reasons and TroubleShooting refer OiD administrator"
      echo " Manual. "
      cleanup
      exit
    fi
   fi
   sleep 30
   cntr=`expr ${cntr} + 1`
done
}         

### To check that there are no connection problems between nodes and MDS..
### Function checkConn .. checks if connection can be made from node to all 
## other nodes and MDS and from MDS to all nodes.. 
## It calls createConCheckFIle.
createConCheckFile() {
cnt=1
LDAP_CONNECT=${MDS_GLOBALNAME}
echo " set feedback off " > ${TMPDIR}/concheck.sql
echo " connect system/${MDS_SYSPSSWD}@${MDS_GLOBALNAME};" >> ${TMPDIR}/concheck.sql
for info in `cat ${TMPFILE}` ; do
   if [ ${cnt} -eq 2 ] ; then
      GLOBALNAME=${info}
      LDAP_CONNECT=${LDAP_CONNECT}" "${GLOBALNAME}
   fi
   if [ ${cnt} -eq 3 ] ; then
      SYSPSSWD=${info}
      echo "connect system/${SYSPSSWD}@${GLOBALNAME};" >> ${TMPDIR}/concheck.sql
      cnt=0
   fi
   cnt=`expr ${cnt} + 1 `
done 
if [ ${NODE} = 1 ] ; then
LDAP_CONNECT=${LDAP_CONNECT}" "${NODE_GLOBALNAME}
echo  "connect system/$NODE_SYSPSSWD@$NODE_GLOBALNAME;">> ${TMPDIR}/concheck.sql
fi
echo " exit; " >> ${TMPDIR}/concheck.sql
}
checkConn() {
ERRORS=0
for nodes in ${LDAP_CONNECT} ; do 
  tnsping ${nodes} > ${TMPDIR}/null 2>&1
  if [ $? != 0 ] ; then 
    echo Unable to detect database using connect descriptor -- ${nodes}
    ERRORS=1
  fi
done
if [ ${ERRORS} = 1 ] ; then
 rm -f ${TMPDIR}/concheck.sql ${TMPFILE} > ${TMPDIR}/null
 exit
fi
for info in ${LDAP_CONNECT} ; do 
      ${ORACLE_HOME}/bin/sqlplus -s odscommon/odscommon@${info} @${TMPDIR}/concheck.sql > ${LDAP_LOG}/concheck.lst
     err=`grep -c ERROR ${LDAP_LOG}/concheck.lst`
     rm -f ${LDAP_LOG}/concheck.lst > ${TMPDIR}/null
     if [ ${err} != 0 ] ; then
         echo " Error establising connection from ${GLOBALNAME} to one or more "
         echo " of other nodes or MDS.."
         err=0
         ERRORS=1
     fi
     noOfNodes=`expr ${noOfNodes} + 1 `
done
rm -f ${TMPDIR}/concheck.sql > ${TMPDIR}/null
if [ ${ERRORS} = 1 ] ; then
echo " Check tnsnames.ora , sqlnet.ora or it is possible you have entered wrong"
echo " GlobalName or system password for one or more of the nodes"
rm -f ${TMPFILE} > ${TMPDIR}/null
exit
fi
}
### Function to check connection for Delete node procedure ###
checkConnforDelNode() {
ERRORS=0
tnsping ${MDS_GLOBALNAME} > nul 2>&1
if [ $? != 0 ] ; then
  echo Unable to detect database using connect descriptor -- ${MDS_GLOBALNAME}
  ERRORS=1
fi
tnsping ${DELNODE_GLOBALNAME} > nul 2>&1
if [ $? != 0 ] ; then
  echo Unable to detect database using connect descriptor -- ${DELNODE_GLOBALNAME}
  ERRORS=1
fi
if [ ${ERRORS} = 1 ] ; then
echo " Check tnsnames.ora , sqlnet.ora or it is possible you have entered wrong"
echo " GlobalName for node to be deleted OR MasterDefinition site "
rm -f ${TMPFILE} > nul
exit
fi
}              
### Function to Check init.ora param job_queue_processes which should be one  
### equal to more than (total no of nodes in repl group -1 )  
checkInitParams() {
noOfNodes=`expr ${noOfNodes} - 1 `
echo " set heading off
       set feedback off
       SELECT value from v\$parameter where name = 'job_queue_processes' ;
       exit; " > ${TMPDIR}/initcheck.sql
cnt=1
for info in `cat ${TMPFILE}` ; do
   if [ ${cnt} -eq 2 ] ; then
      GLOBALNAME=${info}
   fi
   if [ ${cnt} -eq 3 ] ; then
      SYSPSSWD=${info}
      ${ORACLE_HOME}/bin/sqlplus -s system/$SYSPSSWD@${GLOBALNAME} @${TMPDIR}/initcheck.sql > ${LDAP_LOG}/initcheck.lst
      err=`cat ${LDAP_LOG}/initcheck.lst`
      if [ $noOfNodes -gt $err ] ; then
        echo " INIT.ORA param job_queue_processes in ${GLOBALNAME} is =$err "
        echo " It should be >=$noOfNodes."
        ERRORS=1
      fi
      cnt=0
   fi
   cnt=`expr ${cnt} + 1 `
done 
${ORACLE_HOME}/bin/sqlplus -s system/$MDS_SYSPSSWD@${MDS_GLOBALNAME} @${TMPDIR}/initcheck.sql > ${LDAP_LOG}/initcheck.lst
  err=`cat ${LDAP_LOG}/initcheck.lst`
  if [ $noOfNodes -gt $err ] ; then
    echo " INIT.ORA param job_queue_processes in ${GLOBALNAME} is =$err "
    echo " It should be >=$noOfNodes."
    ERRORS=1
fi
if [ ${NODE} = 1 ] ; then
   ${ORACLE_HOME}/bin/sqlplus -s system/$NODE_SYSPSSWD@${NODE_GLOBALNAME} @${TMPDIR}/initcheck.sql > ${LDAP_LOG}/initcheck.lst
     err=`cat ${LDAP_LOG}/initcheck.lst`
     if [ $noOfNodes -gt $err ] ; then
       echo " INIT.ORA param job_queue_processes in ${GLOBALNAME} is =$err "
       echo " It should be >=$noOfNodes."
       ERRORS=1
     fi
fi
rm -f ${TMPDIR}/initcheck.sql ${LDAP_LOG}/initcheck.sql > ${TMPDIR}/null
if [ ${ERRORS} = 1 ] ; then
 rm -f ${TMPFILE} > ${TMPDIR}/null
 exit
fi
}

################Above this are all Functions Command Line Parsing is
################ is the Starting point.

############
###ONE: Command line Parsing
############
if [ $# -eq 0 ] ; then
  usage
fi
while [ $# -gt 0 ] ; do
      case $1 in
          -asrsetup) if [ ${OPTREAD} -eq 1 ] ; then
                        usage;
                     fi;
                     ASR=1 ;
                     OPTREAD=1;;
          -addnode) if [ ${OPTREAD} -eq 1 ] ; then
                        usage;
                    fi;
                    NODE=1 ;
                    OPTREAD=1;;
          -delnode) if [ ${OPTREAD} -eq 1 ] ; then
                        usage;
                    fi;
                    DELNODE=1 ;
                    OPTREAD=1;;
          -quiesce) if [ ${OPTREAD} -eq 1 ] ; then
                        usage;
                    fi;
                    QUIESCE=1 ;
                    OPTREAD=1;;   
	      -*)  usage  ;;
           *)  usage ;;
      esac
      shift
done

################
### THREE::DO ASR SETUP or ADD NODE 
###############
cd ${LDAP_ADMIN}
cleanup
cd ${LDAP_ADMIN}
cleanup
### First take required info from user
if [ ${QUIESCE} = 0 ] ; then
inputMain
fi

### Then check that connect strings and passwords provided are OK.
if [ ${ASR} = 1 -o ${NODE} = 1 ] ; then
createConCheckFile
checkConn
fi

## Next step is to check if the init.ora parameters related to ASR are OK.
if [ ${ASR} = 1 -o ${NODE} = 1 ] ; then
checkInitParams
fi

### Starting ASR setup/addnode 
if [ ${QUIESCE} = 0 ] ; then
startProcess
createdeferadmfile
fi        

if [ ${ASR} -eq 1 ] ; then
    configMasterDefSite
    configMasterSites
    configReplPushJobs
    mdsPushJobs
    deferadminjobs
    deferadminjobs
    #sleep 200
    resumeReplAtMDS
    deferadminjobs
    checkForCompletion
fi
if [ ${NODE} -eq 1 ] ; then                    
    quiesceASR
    addNewNode
    addNodePushJobs
    configReplPushJobs
    mdsPushJobs
    deferadminjobs
    deferadminjobs
    resumeReplAtMDS
    deferadminjobs
    checkForCompletion
    postAddNode
fi
if [ ${DELNODE} -eq 1 ] ; then
    ########
    checkConnforDelNode
    ########
    quiesceASR
    ########
    createremmstrfile
    echo " Remove master database ${DELNODE_GLOBALNAME} from replication" >>  ${LOGFILE}
    ${ORACLE_HOME}/bin/sqlplus -s repadmin/repadmin@${MDS_GLOBALNAME} @${LDAP_ADMIN}/delnode.sql >> ${LOGFILE}
    ########
    echo " Resume replication.. Will take some time" >>  ${LOGFILE}
    resumeReplAtMDS
    ########
    ########
    checkForDelNodeCompletion
fi                                
####
####
#### Quiesce the REplication Environment.
####
####
if [ ${QUIESCE} -eq 1 ] ; then
 echo "${bo}Please provide Information about Master Definition Site ${no} "
 echo "============================================================ "
 echo "  "
 printf  "Enter MDS Global Name :"
 read MDS_GLOBALNAME
 tnsping ${MDS_GLOBALNAME} > nul 2>&1
 if [ $? != 0 ] ; then
   echo Unable to detect database using connect descriptor -- ${MDS_GLOBALNAME}
   exit
 fi
 quiesceASR
fi
echo "."
echo "Replication Setup Complete....."
echo "Replication Setup Complete....." >> ${LOGFILE}
               
cleanup
