# $Header: dgalert.tcl 22-mar-99.09:32:27 dholail Exp $
#
# copyright (c) 1999 by the Oracle Corporation
#
# NAME:
#
#  dgalert.tcl : Event definition of the Oracle Data Gatherer alert event. 
#
# ARGUMENTS:
#           None
#
# RETURN:
#           $SCRIPT_FAIL or
#           $CLEAR_EVENT or
#           $NO_EVENT or
#           $WARNING_EVENT or
#           $ALERT_EVENT
#
# OUTPUT:
#           None 
#
# $Log:  $
# Revision 1.1  1997/09/17 16:54  jriel
# Initial revision
#
# 


# Event definition

oradefine event /oracle/host/fault/dgalert description=VOC-01293 \
report=VOC-01294
oraresults output
oradefine end

# Initialize global variables
#comment out to fix bug#606739
#set last_report $NO_EVENT
set output ""
set ignore_line 0
oraeventpersist last_alert_size -1 

# The main event checking functions

proc EvalEvent {} {

    # Declare globals we will use
    global last_report output
    global last_alert_size
    global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
    global oramsg env

    # initialize the return code
    set ret_code $NO_EVENT
    set err ""

    # Get the alert file size
    set dgalertfile $oramsg(orahome)//odg//log//alert_dg.log

    # check for the existence of the alert file
    # During initialization, set the alert file name and size
    if {$last_alert_size == -1} {
    	if { [file exists $dgalertfile] } {
       	     if {[catch {set last_alert_size [file size $dgalertfile]} err]} {
	         lappend output [format [msgtxt [NETWORK] nms 1005] dgalert.tcl] 
                 lappend output $err
	         if {$last_report == $SCRIPT_FAIL} {
		    return $NO_EVENT
	         } else {
		    set last_report $SCRIPT_FAIL
		    return $SCRIPT_FAIL
	         }
	     }
      	} else {
	        ORATCL_DEBUG "dgalert : $oramsg(oraobject) : [oratime] : alert_dg.log does not exist"
       		set last_alert_size 0
      	}
        return $NO_EVENT
    }

    # get the new alert file size
    if {[catch {set current_alert_size [file size $dgalertfile]} err]} {
        lappend output [format [msgtxt [NETWORK] nms 1005] dgalert.tcl] 
	lappend output $err
	if {$last_report == $SCRIPT_FAIL} {
	    return $NO_EVENT
	} else {
	    set last_report $SCRIPT_FAIL
	    return $SCRIPT_FAIL
	}
    }
    
    # print out event trace info 
    ORATCL_DEBUG "dgalert : $oramsg(oraobject) : [oratime] : $dgalertfile, $current_alert_size"

    # list of the alerts which can be ignored
    set interesting_lines {Warning: Error:}
    set ignore_errors {ODG-00000 ODG-05052 ODG-05149 ODG-05023 ODG-05477 ODG-05644 ODG-05036 ODG-05038 ODG-05141 ODG-05767 ODG-05149 }
    set ret_code $NO_EVENT
    set output ""

    # If the alert file sizes differ, then search the alert file for errors
    if {$last_alert_size != $current_alert_size} {
	if {[catch {set fd [open $dgalertfile r]} err]} {
            lappend output [format [msgtxt [NETWORK] nms 1005] dgalert.tcl] 
	    lappend output $err
	    if {$last_report == $SCRIPT_FAIL} {
	        return $NO_EVENT
            } else {
	        set last_report $SCRIPT_FAIL
	        return $SCRIPT_FAIL
	    }
    	} else {		        
        	if {[catch {seek $fd $last_alert_size start} err]} {
                    lappend output [format [msgtxt [NETWORK] nms 1005] dgalert.tcl] 
		    lappend output $err
                    catch {close $fd} err
	    	    if {$last_report == $SCRIPT_FAIL} {
	        	return $NO_EVENT
	            } else {
		        set last_report $SCRIPT_FAIL
	        	return $SCRIPT_FAIL
	    	    }
    		}
	}

        while {[gets $fd line] >= 0} {        
            set ignore_line 1

            # determine if this is an interesting line
            foreach interest $interesting_lines {
                if {[string first $interest $line] >= 0} {
                    set ignore_line 0
                    break
                }
            }


            # for interesting lines determine if alert entry should be ignored
            if {$ignore_line == 0} {
                foreach error $ignore_errors {
                    if {[string first $error $line] >= 0} {
                        set ignore_line 1
                        break
                    }
                }
            }


            # if current line is not ignored then have an alert
            if {$ignore_line == 0} {
                set ret_code $ALERT_EVENT
                lappend alerts $line

                if {[llength $alerts] >= 10} {
                    lappend alerts ...
                    break
                }
            }
      }

      catch {close $fd} err        
    }

    set last_alert_size $current_alert_size

    if { $ret_code != $NO_EVENT } {
        append output $alerts

	      ORATCL_DEBUG "dgalert : $oramsg(oraobject) : [oratime] : MESSAGE - $ret_code, $output"
    }

    return $ret_code
}
