# $Header: dskfulpct.tcl 13-apr-00.06:10:41 jmansur Exp $
#
# copyright (c) 1999 by the Oracle Corporation
#
# NAME:
#
#  dskfulpct.tcl : Event tcl file that checks if the disk space is full 
#
# ARGUMENTS:
#           argv(0) == disk name 
#           argv(1) == threshold value for alert
#           argv(2) == threshold value for warning
#
# RETURN:
#           $SCRIPT_FAIL or
#           $CLEAR_EVENT or
#           $NO_EVENT or
#           $WARNING_EVENT or
#           $ALERT_EVENT
#
# OUTPUT:
#           disk names and space left on disks
#
# $Log:  $
#
#
# Event definition
oradefine event /oracle/host/space/dskfulpct description=VOC-01356 \
report=VOC-01357
oraarguments disk_name alert_threshold warning_threshold
oravardesc disk_name string message=VOC-01358
oravardesc alert_threshold int message=VOC-01359
oravardesc warning_threshold int message=VOC-01360
oraresults disks space_left
oravardesc disks string
oravardesc space_left int
oradefine end


# Initialize global variables
#comment out to fix bug#606739
#set last_report $CLEAR_EVENT
set output ""
oraeventpersist last_alerts {}
oraeventpersist last_warnings {}


# The main event checking functions
proc EvalEvent {} {


    # Declare globals we will use
    global argv last_report output 
    global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
    global oramsg
    global last_alerts last_warnings


    # initialize the return code and output
    set ret_code $CLEAR_EVENT
    set output ""
    set alerts {}
    set warnings {}


    # issue command to find the disk space usage

    if {[string compare [lindex $argv 0] *] == 0} {
        lappend output [format [msgtxt [NETWORK] nms 1005] dskfulpct.tcl]
        lappend output [msgtxt [NETWORK] nms 1077]
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }

    set disk_names [lindex $argv 0]

    if { [catch {pctdiskusage $disk_names} disk_usage] } {
        lappend output [format [msgtxt [NETWORK] nms 1005] dskfulpct.tcl]
        lappend output [msgtxt [NETWORK] nms 1078]
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }


    # print out event trace info 
    ORATCL_DEBUG "dskfulpct : $oramsg(oraobject) : [oratime] : $disk_names $disk_usage"


    # Check for alert and warning threshold
    set i 0
    while {$i < [llength [lindex $disk_usage 0]]} {
        set avail [lindex [lindex $disk_usage 2] $i]
        set disk [lindex [lindex $disk_usage 3] $i]
        if {$avail < [lindex $argv 1]} {
            set ret_code $ALERT_EVENT
            lappend output $disk $avail
            lappend alerts $disk
        } elseif {$avail < [lindex $argv 2]} {
            if { $ret_code != $ALERT_EVENT } {
                set ret_code $WARNING_EVENT
            }
            lappend output $disk $avail
            lappend warnings $disk
        }
        incr i
    }


    # return
    if { $ret_code == $last_report &&
         [string compare $last_warnings $warnings] == 0 &&
         [string compare $last_alerts $alerts] == 0 } {
        return $NO_EVENT
    } else {
        ORATCL_DEBUG "dskfulpct : $oramsg(oraobject) : [oratime] : MESSAGE - $ret_code, $output"
        set last_report $ret_code
        set last_warnings $warnings
        set last_alerts $alerts
        return $ret_code 
    }
}

