# $Header: swapfull.tcl 29-mar-99.06:38:02 dholail Exp $
#
# copyright (c) 1999 by the Oracle Corporation
#
# NAME:
#
#  swapfull.tcl : Event tcl file that checks if the swap area is full 
#                 This script uses swap command to obtain swap information.
#
# ARGUMENTS:
#           argv(0) == threshold value for alert
#           argv(1) == threshold value for warning
#
# RETURN:
#           $SCRIPT_FAIL or
#           $CLEAR_EVENT or
#           $NO_EVENT or
#           $WARNING_EVENT or
#           $ALERT_EVENT
#
# OUTPUT:
#           space left on the swap area
#
# $Log:  $
# Revision 1.3  1996/08/22  20:34:23  yliu
# added porting note
#
# Revision 1.2  1995/10/27  17:46:17  yliu
# rename to swapfull
#
# Revision 1.1  1995/10/27  00:27:14  yliu
# Initial revision
#
##########################################################################
#
# Porting note :
# swap command may not exist on some of the platforms. Please make appropriate
# change for your port. Make sure you parse the output correctly.
#
##########################################################################


# Event definition
oradefine event /oracle/host/space/swapfull description=VOC-01261 \
report=VOC-01262
oraarguments alert_threshold warning_threshold
oravardesc alert_threshold int message=VOC-01263
oravardesc warning_threshold int message=VOC-01264
oraresults space_left
oravardesc space_left int
oradefine end


# Initialize global variables
#comment out to fix bug#606739
#set last_report $CLEAR_EVENT
set output ""


# The main event checking functions
proc EvalEvent {} {


    # Declare globals we will use
    global argv last_report output 
    global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
    global oramsg


    # initialize the return code and output
    set ret_code $CLEAR_EVENT
    set output ""
    set err ""

    # get the available swap space
   if { [catch {set avail [swapusage]} err] } {
        lappend output [format [msgtxt [NETWORK] nms 1005] swapfull.tcl]
        lappend output $err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
   }

    # print out event trace info 
    ORATCL_DEBUG "swapfull : $oramsg(oraobject) : [oratime] : $avail"


    # Check for alert and warning threshold
    if {$avail < [lindex $argv 0]} {
        set ret_code $ALERT_EVENT
        set output $avail
    } elseif {$avail < [lindex $argv 1]} {
        set ret_code $WARNING_EVENT
        set output $avail
    }


    #return
    if {$last_report == $ret_code} {
        return $NO_EVENT
    } else {
	ORATCL_DEBUG "swapfull : $oramsg(oraobject) : [oratime] : MESSAGE - $ret_code, $output"
        set last_report $ret_code
        return $ret_code 
    }
}

