# $Header: faildjob.tcl 06-jun-00.10:56:07 jmansur Exp $
#
# copyright (c) 1999 by the Oracle Corporation
#
# NAME:
#
#  faildjob.tcl : Event tcl file that checks if any job failed at least once.
#
# ARGUMENTS:
#           argv(0) == connect string
#           argv(1) == threshold value for alert
#           
#
# RETURN:
#           $SCRIPT_FAIL
#           $CLEAR_EVENT
#           $NO_EVENT
#           $WARNING_EVENT
#           $ALERT_EVENT
#
# OUTPUT:
#           A list of jobs that have failed
#
# $Log:  $
# Revision 1.5  12/12/97  18:28:59  rposham
# initial
#

# Event definition
#
#
#
oradefine event /oracle/rdbms/fault/faildjob description=VOC-01903 \
report=VOC-01904
oraarguments connect_str alert_threshold
oravardesc connect_str oracle_signon
oravardesc alert_threshold unsigned default=0 message=VOC-01905
oraresults jobs failures
oravardesc jobs string
oravardesc failures unsigned
oradefine end
#



# Initialize global variables
#comment out to fix bug#606739
#set last_report $CLEAR_EVENT
set output ""
oraeventpersist last_jobs {} 
oraeventpersist last_failures {} 


# The main event checking functions
proc EvalEvent {} {


    # Declare globals we will use
    global argv last_report output
    global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
    global oramsg 
    global last_jobs last_failures

    # initialize the return code and output
    set ret_code $CLEAR_EVENT
    set output ""
    set err ""
    set jobs {}
    set failures {}

    # connect to the database and open a cursor
    set connect [format "%s@%s" [lindex $argv 0] $oramsg(oraobject)]
    if {[catch {oralogon $connect} lda]} {
        lappend output [msgtxt [RDBMS] ora $oramsg(rc)] ""
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }

    if {[catch {set cur [oraopen $lda]} err]} {
	lappend output $err
        catch {oralogoff $lda} err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }

    # get job ids of failed jobs
    set sql "select job, failures from sys.dba_jobs where failures > 0"
    if { [catch { orasql $cur $sql }] } {
        lappend output [convertout $oramsg(db_characterset) \
            $oramsg(errortxt)] $sql
        catch {oraclose $cur} err
        catch {oralogoff $lda} err
	lappend output $err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }

    if {[catch {set row [orafetch $cur]} err]} {
	lappend output $err
        catch {oraclose $cur} err
        catch {oralogoff $lda} err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }

    while {$oramsg(rc) == 0} {
        lappend jobs [lindex $row 0]
        lappend failures [lindex $row 1]

        if {[catch {set row [orafetch $cur]} err]} {
	    lappend output $err
            catch {oraclose $cur} err
            catch {oralogoff $lda} err
            if {$last_report == $SCRIPT_FAIL} {
    	        return $NO_EVENT
            } else {
            	set last_report $SCRIPT_FAIL
	        return $SCRIPT_FAIL
            }
        }
    }


    # log off
    catch {oraclose $cur} err
    catch {oralogoff $lda]} err
            
    # print out event trace info 
    ORATCL_DEBUG "faildjob : $oramsg(oraobject) : [oratime] : [llength $jobs]"


    # check number of failed jobs against alert threshold 
    if {[llength $jobs] > [lindex $argv 1]} {
        set ret_code $ALERT_EVENT
        lappend output $jobs $failures
    } 
    
    
    # return
    if { $ret_code == $last_report &&
         [string compare $last_jobs $jobs] == 0 &&
         [string compare $last_failures $failures] == 0 } {
        return $NO_EVENT
    } else {
        ORATCL_DEBUG "faildjob : $oramsg(oraobject) : [oratime] : MESSAGE - $ret_code, $output"
        set last_report $ret_code
        set last_jobs $jobs
        set last_failures $failures
        return $ret_code 
    }
}


