# $Header: updown.tcl 29-mar-99.12:12:23 dholail Exp $
#
# copyright (c) 1999 by the Oracle Corporation
#
# NAME:
#
#  updown.tcl : Event tcl file that checks if database is down
#
# ARGUMENTS:
#           None    
#
# RETURN:
#           $CLEAR_EVENT or
#           $NO_EVENT or
#           $ALERT_EVENT
#
# OUTPUT:
#           None
#
# $Log:  $
# Revision 1.2  1995/09/28  20:20:26  yliu
# use message file
#
# Revision 1.1  1995/09/07  17:21:43  yliu
# Initial revision
#


# Event definition
oradefine event /oracle/rdbms/fault/updown description=VOC-01001 \
report=VOC-01002
oradefine end


# Initialize global variables
#comment out to fix bug#606739
#set last_report $CLEAR_EVENT
set output ""     


# The main event checking functions
proc EvalEvent {} {


    # Declare globals we will use
    global last_report output
    global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
    global oramsg


    # initialize the return code and output
    set ret_code $CLEAR_EVENT
    set output ""
    set err ""

    # Get the database status
    if {[catch {set db_stat [oradbsnmp get rdbmsRelState.$oramsg(oraindex).$oramsg(oraindex)]} err]} {
	lappend output $err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }

    set status [lindex $db_stat 1]


    if {$status != 2} {
        set ret_code $ALERT_EVENT
    }


    # print out event trace info 
    ORATCL_DEBUG "updown : $oramsg(oraobject) : [oratime] : $status"


    # return
    if {$last_report == $ret_code} {
        return $NO_EVENT
    } else {
        ORATCL_DEBUG "updown : $oramsg(oraobject) : [oratime] : MESSAGE - $ret_code, $output"

        set last_report $ret_code
        return $ret_code 
    }

}

