# $Header: sysstata.tcl 31-mar-00.10:47:23 sgrover Exp $
#
# copyright (c) 1999 by the Oracle Corporation
#
# NAME:
#
#  sysstat.tcl : Event tcl file that checks if the absolute value of the 
#                specified v$sysstat parameter is too high
#
# ARGUMENTS:
#           argv(0) == no of occurrance
#           argv(1) == threshold value for alert
#           argv(2) == threshold value for warning
#           argv(3) == parameter name
#
# RETURN:
#           $SCRIPT_FAIL or
#           $CLEAR_EVENT or
#           $NO_EVENT or
#           $WARNING_EVENT or
#           $ALERT_EVENT
#
# OUTPUT:
#           The current parameter name and value
#
# $Log:  $
# Revision 1.6  1996/06/24  23:54:55  yliu
# fixed bug 370148
#
# Revision 1.5  1996/02/07  01:49:17  yliu
# use character set conversion
#
# Revision 1.4  1996/01/10  01:35:44  yliu
# use message file
#
# Revision 1.3  1995/10/25 01:41:04  yliu
# add connect string to the parameter list
#
# Revision 1.2  1995/10/18  22:47:28  yliu
# improve error handling
#
# Revision 1.1  1995/10/13  23:55:36  yliu
# Initial revision
#

# Event definition
oradefine event /oracle/rdbms/perf/sysstata description=VOC-01211 \
report=VOC-01212
oraarguments connect_str no_occurrence alert_threshold warning_threshold parameter_name
oravardesc connect_str oracle_signon
oravardesc no_occurrence unsigned default=3 message=VOC-01213
oravardesc alert_threshold number message=VOC-01214
oravardesc warning_threshold number message=VOC-01215
oravardesc parameter_name string message=VOC-01216
oraresults stat_name curr_value
oravardesc stat_name string
oravardesc curr_value string
oradefine end


# Initialize global variables
#comment out to fix bug#606739
#set last_report $CLEAR_EVENT
set output ""
set no_occurrence 0


# The main event checking functions
proc EvalEvent {} {


    # Declare globals we will use
    global argv last_report output no_occurrence
    global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
    global oramsg 


    # initialize the return code and output
    set ret_code $CLEAR_EVENT
    set output ""
    set err ""

    # Get current value
    set connect [format "%s@%s" [lindex $argv 0] $oramsg(oraobject)]
    if {[catch {oralogon $connect} lda]} {
        lappend output [msgtxt [RDBMS] ora $oramsg(rc)] ""
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }
    if {[catch {set cur [oraopen $lda]} err]} {
	lappend output $err
        catch {oralogoff $lda} err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }

    set stat_name [lindex $argv 4]

    set sql {select value from v$sysstat where name = }
    set sql [concat $sql [format "'%s'" $stat_name]]

    if {[catch {orasql $cur $sql}]} {
        lappend output [convertout $oramsg(db_characterset) \
            $oramsg(errortxt)] $sql
        catch {oraclose $cur} err
        catch {oralogoff $lda} err
	lappend output $err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }
    if {[catch {set row [orafetch $cur]} err]} {
	lappend output $err
        catch {oraclose $cur} err
        catch {oralogoff $lda} err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }
    if {$oramsg(rows) == 0} {
        lappend output [msgtxt [NETWORK] nms 1008] $sql
        catch {oraclose $cur} err
        catch {oralogoff $lda} err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }
    set curr_value [lindex $row 0]
    set curr_value_float [format "%f" $curr_value]

    catch {oraclose $cur} err
    catch {oralogoff $lda} err


    # print out event trace info 
    ORATCL_DEBUG "sysstata : $oramsg(oraobject) : [oratime] : $stat_name, $curr_value"

    # Check for alert and warning threshold
    if {$curr_value_float >= [lindex $argv 2]} {
        if {$no_occurrence < [expr [lindex $argv 1]-1]} {
            incr no_occurrence
        } else {
            set ret_code $ALERT_EVENT
            lappend output $stat_name $curr_value
        }
    } elseif {$curr_value_float >= [lindex $argv 3]} {
        if {$no_occurrence < [expr [lindex $argv 1]-1]} {
            incr no_occurrence
        } else {
            set ret_code $WARNING_EVENT
            lappend output $stat_name $curr_value
        }
    } else {
        set no_occurrence 0
    } 

    # return
    if {$last_report == $ret_code} {
        return $NO_EVENT
    } else {
        ORATCL_DEBUG "sysstata : $oramsg(oraobject) : [oratime] : MESSAGE - $ret_code, $output"

        set last_report $ret_code
        return $ret_code 
    }


}

