# $Header: sesslmt.tcl 30-mar-99.15:57:14 dholail Exp $
#
# copyright (c) 1999 by the Oracle Corporation
#
# NAME:
#
#  sesslmt.tcl : Event tcl file that checks if the session usage is 
#                reaching its limit.
#
# ARGUMENTS:
#           argv(0) == threshold value for alert
#           argv(1) == threshold value for warning
#
# RETURN:
#           $SCRIPT_FAIL or
#           $CLEAR_EVENT or
#           $NO_EVENT or
#           $WARNING_EVENT or
#           $ALERT_EVENT
#
# OUTPUT:
#           no of existing sessiones, and its limit
#
# $Log:  $
# Revision 1.6  1996/06/24  23:56:05  yliu
# fixed bug 370148
#
# Revision 1.5  1996/02/07  01:55:20  yliu
# use character set conversion
#
# Revision 1.4  1996/01/10  02:02:10  yliu
# use message file
#
# Revision 1.3  1995/10/25 17:58:42  yliu
# add connect string to the parameter list
#
# Revision 1.2  1995/09/28  22:02:54  yliu
# use message file
#
# Revision 1.1  1995/09/07  21:36:59  yliu
# Initial revision
#


# Event definition
oradefine event /oracle/rdbms/resource/sesslmt description=VOC-01091 \
report=VOC-01092
oraarguments connect_str alert_threshold warning_threshold
oravardesc connect_str oracle_signon
oravardesc alert_threshold unsigned minimum=0 maximum=100 default=90 message=VOC-01093
oravardesc warning_threshold unsigned minimum=0 maximum=100 default=80 message=VOC-01094
oraresults currents limits
oravardesc currents int
oravardesc limits int
oradefine end


# Initialize global variables
#comment out to fix bug#606739
#set last_report $CLEAR_EVENT
set output ""


# The main event checking functions
proc EvalEvent {} {


    # Declare globals we will use
    global argv last_report output
    global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
    global oramsg


    # initialize the return code and output
    set ret_code $CLEAR_EVENT
    set output ""
    set err ""

    # get current value and its limit
    set connect [format "%s@%s" [lindex $argv 0] $oramsg(oraobject)]
    if {[catch {oralogon $connect} lda]} {
        lappend output [msgtxt [RDBMS] ora $oramsg(rc)] ""
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }
    if {[catch {set cur [oraopen $lda]} err]} {
	lappend output $err
        catch {oralogoff $lda} err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }

    set sql {select count(*) from v$session}
    if {[catch {orasql $cur $sql}]} {
        lappend output [convertout $oramsg(db_characterset) \
            $oramsg(errortxt)] $sql
        catch {oraclose $cur} err
        catch {oralogoff $lda} err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }
    if {[catch {set row [orafetch $cur]} err]} {
	lappend output $err
        catch {oraclose $cur} err
        catch {oralogoff $lda} err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }

    set current [lindex $row 0]

    # log off
    catch {oraclose $cur} err
    catch {oralogoff $lda} err

    if {[catch {set temp_list [oradbsnmp get rdbmsSrvParamCurrValue.$oramsg(oraindex).8.115.101.115.115.105.111.110.115.1]} err]} {
	lappend output $err
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }
    set limit [lindex $temp_list 1]
    if { $limit == 0 } {
        set ratio 0
    } else {
        set ratio [divide [expr 100 * $current] $limit] 
    } 

            
    # print out event trace info 
    ORATCL_DEBUG "sesslmt : $oramsg(oraobject) : [oratime] : $current, $limit, $ratio"


    # Check ratio against alert and warning thresholds
    if {$ratio > [lindex $argv 1]} {
        set ret_code $ALERT_EVENT
        lappend output $current $limit
    } elseif {$ratio > [lindex $argv 2]} {
        set ret_code $WARNING_EVENT
        lappend output $current $limit
    } 


    # return
    if {$last_report == $ret_code} {
        return $NO_EVENT
    } else {
        ORATCL_DEBUG "sesslmt : $oramsg(oraobject) : [oratime] : MESSAGE - $ret_code, $output"
        set last_report $ret_code
        return $ret_code 
    }
}

