# $Header: updown.tcl 29-mar-99.09:09:23 dholail Exp $
#
# copyright (c) 1999 by the Oracle Corporation
#
# NAME:
#
#  updown.tcl : Event tcl file that checks if a listener is down
#
# ARGUMENTS:
#           None    
#
# RETURN:
#           $CLEAR_EVENT or
#           $NO_EVENT or
#           $ALERT_EVENT
#
# OUTPUT:
#           None
#
# $Log:  $
# Revision 1.11  1998/02/12  groyal
# improved error messages issued for script evaluation failures
#
# Revision 1.10  1996/08/22  20:51:20  yliu
# use tempfile and rmfile verbs
#
# Revision 1.9  1996/03/06  23:26:44  yliu
# back out previous change
#
# Revision 1.7  1996/02/08 00:52:12  yliu
# make argv global
#
# Revision 1.6  1996/01/29 20:19:19  yliu
# added listener_name as a parameter
#
# Revision 1.5  1996/01/10 23:24:07  yliu
# use message file
#
# Revision 1.4  1995/10/30 21:32:53  yliu
# Do not use oraobject
#

# Event definition
oradefine event /oracle/sqlnet/fault/updown description=VOC-01181 \
report=VOC-01182
oraarguments listener_name
oravardesc listener_name string default=* message=VOC-01183
oradefine end


# Initialize global variables
#comment out to fix bug#606739
#set last_report $CLEAR_EVENT
set output ""     



# The main event checking functions
proc EvalEvent {} {


    # Declare globals we will use
    global last_report output
    global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
    global oramsg argv


    # initialize the return code and output
    set ret_code $CLEAR_EVENT
    set output ""


    # get listener status
    set name [lindex $argv 0]

    # NT LISTENER CONTROL UTILITY DOES NOT SUPPORT * TO BE THE DEFAULT LISTENER
    if { [string compare $name *] == 0} {
	   lappend output [msgtxt [NETWORK] nms 1002] 
	   ORATCL_DEBUG "updown : $oramsg(oraobject) : [oratime] : $output "
	   return $SCRIPT_FAIL
    }

    if { [catch {getlsnrstatus $name} status] } {
        lappend output [format [msgtxt [NETWORK] nms 1005] "updown.tcl"]
        lappend output [msgtxt [NETWORK] nms 1079]
        if {$last_report == $SCRIPT_FAIL} {
            return $NO_EVENT
        } else {
            set last_report $SCRIPT_FAIL
            return $SCRIPT_FAIL
        }
    }

    
    # check listener status
    if {$status == 0} {
        set ret_code $ALERT_EVENT
    }


    # print out event trace info 
    ORATCL_DEBUG "updown : $oramsg(oraobject) : [oratime] : $status"


    # return
    if {$last_report == $ret_code} {
        return $NO_EVENT
    } else {
        ORATCL_DEBUG "updown : $oramsg(oraobject) : [oratime] : MESSAGE - $ret_code, $output"
        set last_report $ret_code
        return $ret_code 
    }


}

