# $Header: osexec.tcl 22-may-97.23:55:57 dnakos Exp $
#
# copyright (c) 1995 by the Oracle Corporation
#
# NAME:
#
#  osexec.tcl : Script to execute an OS Command
#
# ARGUMENTS:
#        
#           argv(0) == OS command or shell script
#           argv(1) == args to command delimited by quotes: eg: "-l -p foo" 
#
# $Log:  $
# Revision 1.6  1996/04/04  19:59:43  yliu
# fixed ls /tmp/* problem
#
# Revision 1.5  1996/02/07  02:13:19  yliu
# use character set conversion
#
# Revision 1.4  1995/09/25 23:24:18  yliu
# use message file
#
# Revision 1.3  1995/09/12  00:54:42  bpurvy
# added "command" to arg list
#
# Revision 1.2  1995/09/12  00:16:48  bpurvy
# collected stdout in a variable and puts'ed it
#
# Revision 1.1  1995/09/07  00:31:05  yliu
# Initial revision
#

oradefine job /oracle/host/general/osexec description=VOC-02021
oraarguments command args 
oravardesc command string message=VOC-02022
oravardesc args string message=VOC-02023
oradefine end

set command [convertin $oramsg(agent_characterset) [lindex $argv 0]]
set argument [convertin $oramsg(agent_characterset) [lindex $argv 1]]

if { [catch {OS_SHELL_EXEC "$command $argument"} outx] } {
    orafail [convertout $oramsg(agent_characterset) $outx]
}
puts [convertout $oramsg(agent_characterset) $outx]







