#
# Copyright (c) 1996, 1997, 1998, 1999, 2000 by Oracle Corporation
#
# NAME: otrcdcf.tcl - Trace CLI delete collection files script
#
# VERSION: 817 NT
#
# ARGUMENTS:
#
#      argv(0) = Oracle home
#      argv(1) = collection name
#      argv(2) = cdf file name [optional]
#
# INPUT FILES:
#
#      none
#

oradefine job /oracle/otrace/general/otrcdcf

global oramsg

set epc_s_begclijob       87
set epc_s_inv_col_name   121
set epc_s_nohompar       156
set epc_s_delcdf         169
set epc_s_nocliexe       175

set agent_addr [lindex [orainfo] 2]
catch {orajobstat $agent_addr [msgtxt otrace EPC [format "%05d" $epc_s_begclijob]]} cstat


#Set Oracle home based on 0th input parameter ...
set ohome [lindex $argv 0]
if { $ohome == "" } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_nohompar]]
}
set env(ORACLE_HOME) $ohome

set col_name [lindex $argv 1]
if { $col_name == "" } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_inv_col_name]]
}

set cdf_fname [lindex $argv 2]
if { $cdf_fname == "" } {
# If not supplied, default to collection name.cdf ...
    set cdf_fname [append col_name ".cdf"]
}


### Note versioned/non-versioned otrace directory for NT ...
set cdf_filespec  ""
set prod_dir_list [list otrace otrace80 otrace73]
foreach prod_dir $prod_dir_list {
    set cdf_filespec [concatname [list $ohome $prod_dir admin cdf $cdf_fname]]
    if { [file exists $cdf_filespec] } {
        break
    } else {
        set cdf_filespec ""
    }
}
if { $cdf_filespec == "" } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_delcdf]]
}


### Note for NT that image name must include .exe extension ...
set cliexe [concatname [list $ohome bin otrccol.exe ] ]
if { ! [file executable $cliexe] } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_nocliexe]]
}

if {[catch { exec $cliexe _dcf $col_name $cdf_filespec } del_result] } {
    orafail [msgtxt otrace EPC [format "%05d" [lindex $errorCode 2]]]
} 

puts [convertout $oramsg(agent_characterset) $del_result]
catch {orajobstat $agent_addr "$del_result"} cstat

