#
# Copyright (c) 1996, 1997, 1998, 1999, 2000 by Oracle Corporation
#
# NAME: otrcfmt.tcl - Trace CLI format collection data script
#
# VERSION: 817 NT
#
# ARGUMENTS:
#
#      argv(0) = Oracle home
#
# INPUT FILES:
#
#      file(0) = parameter file
#

oradefine job /oracle/otrace/general/otrcfmt

global oramsg

set epc_s_nohompar  156
set epc_s_nocliexe  175
set epc_s_fmtdone   176
set epc_s_fmtstart  177


set agent_addr [lindex [orainfo] 2]

puts [msgtxt otrace EPC [format "%05d" $epc_s_fmtstart]]
catch {orajobstat $agent_addr [msgtxt otrace EPC [format "%05d" $epc_s_fmtstart]]} cstat


# Set Oracle home based on input parameter ...
set ohome [lindex $argv 0]
if { $ohome == "" } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_nohompar]]
}
set env(ORACLE_HOME) $ohome

# Set job user/pw env variables ...
set env(EPC_JOB_USER) $SMP_USER
set env(EPC_JOB_PW)   $SMP_PASSWORD

set fmt_param_file [lindex $oramsg(orainput) 0]

### Note for NT that image name must include .exe extension ...
set cliexe [concatname [list $ohome bin otrccol.exe ] ]
if { ! [file executable $cliexe] } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_nocliexe]]
}


# Perform format ...

if {[catch {exec $cliexe _format $fmt_param_file} fmt_ret ] } {
    puts " "
    puts [convertout $oramsg(agent_characterset) $fmt_ret]
    puts " "
    orafail [msgtxt otrace EPC [format "%05d" [lindex $errorCode 2]]]
} else {
    set done_msg [msgtxt otrace EPC [format "%05d" $epc_s_fmtdone]]
# If sucessful format output includes ID=, return it ...  (JMc, 9/30/96)
    set loc_id  [string last "(ID=" $fmt_ret]
    if { $loc_id > 0 } {
	set id_str [string range $fmt_ret $loc_id end]
        set done_msg [lappend done_msg  $id_str]
    }
    catch {orajobstat $agent_addr "$done_msg"} cstat
    puts $done_msg
}
