#
# Copyright (c) 1996, 1997, 1998 by Oracle Corporation
#
# NAME: otrcpfdf.tcl - Trace CLI put fdf file (to agent node) script
#
# VERSION: 813 NT
#
# ARGUMENTS:
#
#      argv(0) = Oracle home
#      argv(1) = new fdf file name (on agent)
#
# INPUT FILES:
#
#      file(0) = existing fdf file (on client)
#

oradefine job /oracle/otrace/general/otrcpfdf

global oramsg

set epc_s_notinstall  11
set epc_s_fdffilereq  61
set epc_s_filnamreq   75
set epc_s_crefdf      83
set epc_s_begclijob   87
set epc_s_comclijob  133
set epc_s_nohompar   156

set agent_addr [lindex [orainfo] 2]
catch {orajobstat $agent_addr [msgtxt otrace EPC [format "%05d" $epc_s_begclijob]]} cstat


#Set Oracle home based on 0th input parameter ...
set ohome [lindex $argv 0]
if { $ohome == "" } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_nohompar]]
}
set env(ORACLE_HOME) $ohome

set fname [lindex $argv 1]
if { $fname == "" } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_filnamreq]]
}

### Note versioned Trace directory for NT ...
set trace_prod_dir ""

if { [file isdirectory [concatname [list $ohome otrace]]] } {
    set trace_prod_dir "otrace"
} elseif { [file isdirectory [concatname [list $ohome otrace80]]] } {
    set trace_prod_dir "otrace80"
} elseif { [file isdirectory [concatname [list $ohome otrace73]]] } {
    set trace_prod_dir "otrace73"
}
if { $trace_prod_dir == "" } {
    puts " "
    puts [msgtxt otrace EPC [format "%05d" $epc_s_notinstall]]
    continue
}
set fdf_file [concatname [list $ohome $trace_prod_dir admin fdf $fname ] ]
set fdf_file [append fdf_file ".fdf"]

set inp_file [lindex $oramsg(orainput) 0]

if { $inp_file == "" } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_fdffilereq]]
}

### Note platform-specific copy command ...
if { [catch { eval exec copy $inp_file $fdf_file } copy_stat] } {
    orafail [msgtxt otrace EPC [format "%05d" $epc_s_crefdf]]
}
catch {orajobstat $agent_addr [msgtxt otrace EPC [format "%05d" $epc_s_comclijob]]} cstat
puts "Completed CLI put fdf."

